/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.CreateAppDataArgs;
import android.os.CreateAppDataResult;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ReconcileSdkDataArgs;
import android.os.RemoteException;
import android.os.storage.CrateMetadata;

public interface IInstalld
extends IInterface {
    public static final int FLAG_STORAGE_DE = 1;
    public static final int FLAG_STORAGE_CE = 2;
    public static final int FLAG_STORAGE_EXTERNAL = 4;
    public static final int FLAG_STORAGE_SDK = 8;
    public static final int FLAG_CLEAR_CACHE_ONLY = 16;
    public static final int FLAG_CLEAR_CODE_CACHE_ONLY = 32;
    public static final int FLAG_FREE_CACHE_V2 = 256;
    public static final int FLAG_FREE_CACHE_V2_DEFY_QUOTA = 512;
    public static final int FLAG_FREE_CACHE_NOOP = 1024;
    public static final int FLAG_FREE_CACHE_DEFY_TARGET_FREE_BYTES = 2048;
    public static final int FLAG_USE_QUOTA = 4096;
    public static final int FLAG_FORCE = 8192;
    public static final int FLAG_CLEAR_APP_DATA_KEEP_ART_PROFILES = 131072;

    public void createUserData(String var1, int var2, int var3, int var4) throws RemoteException;

    public void destroyUserData(String var1, int var2, int var3) throws RemoteException;

    public void setFirstBoot() throws RemoteException;

    public CreateAppDataResult createAppData(CreateAppDataArgs var1) throws RemoteException;

    public CreateAppDataResult[] createAppDataBatched(CreateAppDataArgs[] var1) throws RemoteException;

    public void reconcileSdkData(ReconcileSdkDataArgs var1) throws RemoteException;

    public void restoreconAppData(String var1, String var2, int var3, int var4, int var5, String var6) throws RemoteException;

    public void migrateAppData(String var1, String var2, int var3, int var4) throws RemoteException;

    public void clearAppData(String var1, String var2, int var3, int var4, long var5) throws RemoteException;

    public void destroyAppData(String var1, String var2, int var3, int var4, long var5) throws RemoteException;

    public void fixupAppData(String var1, int var2) throws RemoteException;

    public long[] getAppSize(String var1, String[] var2, int var3, int var4, int var5, long[] var6, String[] var7) throws RemoteException;

    public long[] getUserSize(String var1, int var2, int var3, int[] var4) throws RemoteException;

    public long[] getExternalSize(String var1, int var2, int var3, int[] var4) throws RemoteException;

    public CrateMetadata[] getAppCrates(String var1, String[] var2, int var3) throws RemoteException;

    public CrateMetadata[] getUserCrates(String var1, int var2) throws RemoteException;

    public void setAppQuota(String var1, int var2, int var3, long var4) throws RemoteException;

    public void moveCompleteApp(String var1, String var2, String var3, int var4, String var5, int var6, String var7) throws RemoteException;

    public boolean dexopt(String var1, int var2, String var3, String var4, int var5, String var6, int var7, String var8, String var9, String var10, String var11, boolean var12, int var13, String var14, String var15, String var16) throws RemoteException;

    public void controlDexOptBlocking(boolean var1) throws RemoteException;

    public boolean compileLayouts(String var1, String var2, String var3, int var4) throws RemoteException;

    public void rmdex(String var1, String var2) throws RemoteException;

    public int mergeProfiles(int var1, String var2, String var3) throws RemoteException;

    public boolean dumpProfiles(int var1, String var2, String var3, String var4, boolean var5) throws RemoteException;

    public boolean copySystemProfile(String var1, int var2, String var3, String var4) throws RemoteException;

    public void clearAppProfiles(String var1, String var2) throws RemoteException;

    public void destroyAppProfiles(String var1) throws RemoteException;

    public void deleteReferenceProfile(String var1, String var2) throws RemoteException;

    public boolean createProfileSnapshot(int var1, String var2, String var3, String var4) throws RemoteException;

    public void destroyProfileSnapshot(String var1, String var2) throws RemoteException;

    public void rmPackageDir(String var1, String var2) throws RemoteException;

    public void freeCache(String var1, long var2, int var4) throws RemoteException;

    public void linkNativeLibraryDirectory(String var1, String var2, String var3, int var4) throws RemoteException;

    public void createOatDir(String var1, String var2, String var3) throws RemoteException;

    public void linkFile(String var1, String var2, String var3, String var4) throws RemoteException;

    public void moveAb(String var1, String var2, String var3, String var4) throws RemoteException;

    public long deleteOdex(String var1, String var2, String var3, String var4) throws RemoteException;

    public boolean reconcileSecondaryDexFile(String var1, String var2, int var3, String[] var4, String var5, int var6) throws RemoteException;

    public byte[] hashSecondaryDexFile(String var1, String var2, int var3, String var4, int var5) throws RemoteException;

    public void invalidateMounts() throws RemoteException;

    public boolean isQuotaSupported(String var1) throws RemoteException;

    public boolean prepareAppProfile(String var1, int var2, int var3, String var4, String var5, String var6) throws RemoteException;

    public long snapshotAppData(String var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public void restoreAppDataSnapshot(String var1, String var2, int var3, String var4, int var5, int var6, int var7) throws RemoteException;

    public void destroyAppDataSnapshot(String var1, String var2, int var3, long var4, int var6, int var7) throws RemoteException;

    public void destroyCeSnapshotsNotSpecified(String var1, int var2, int[] var3) throws RemoteException;

    public void tryMountDataMirror(String var1) throws RemoteException;

    public void onPrivateVolumeRemoved(String var1) throws RemoteException;

    public void migrateLegacyObbData() throws RemoteException;

    public void cleanupInvalidPackageDirs(String var1, int var2, int var3) throws RemoteException;

    public int getOdexVisibility(String var1, String var2, String var3, String var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInstalld {
        public static final String DESCRIPTOR = "android.os.IInstalld";
        static final int TRANSACTION_createUserData = 1;
        static final int TRANSACTION_destroyUserData = 2;
        static final int TRANSACTION_setFirstBoot = 3;
        static final int TRANSACTION_createAppData = 4;
        static final int TRANSACTION_createAppDataBatched = 5;
        static final int TRANSACTION_reconcileSdkData = 6;
        static final int TRANSACTION_restoreconAppData = 7;
        static final int TRANSACTION_migrateAppData = 8;
        static final int TRANSACTION_clearAppData = 9;
        static final int TRANSACTION_destroyAppData = 10;
        static final int TRANSACTION_fixupAppData = 11;
        static final int TRANSACTION_getAppSize = 12;
        static final int TRANSACTION_getUserSize = 13;
        static final int TRANSACTION_getExternalSize = 14;
        static final int TRANSACTION_getAppCrates = 15;
        static final int TRANSACTION_getUserCrates = 16;
        static final int TRANSACTION_setAppQuota = 17;
        static final int TRANSACTION_moveCompleteApp = 18;
        static final int TRANSACTION_dexopt = 19;
        static final int TRANSACTION_controlDexOptBlocking = 20;
        static final int TRANSACTION_compileLayouts = 21;
        static final int TRANSACTION_rmdex = 22;
        static final int TRANSACTION_mergeProfiles = 23;
        static final int TRANSACTION_dumpProfiles = 24;
        static final int TRANSACTION_copySystemProfile = 25;
        static final int TRANSACTION_clearAppProfiles = 26;
        static final int TRANSACTION_destroyAppProfiles = 27;
        static final int TRANSACTION_deleteReferenceProfile = 28;
        static final int TRANSACTION_createProfileSnapshot = 29;
        static final int TRANSACTION_destroyProfileSnapshot = 30;
        static final int TRANSACTION_rmPackageDir = 31;
        static final int TRANSACTION_freeCache = 32;
        static final int TRANSACTION_linkNativeLibraryDirectory = 33;
        static final int TRANSACTION_createOatDir = 34;
        static final int TRANSACTION_linkFile = 35;
        static final int TRANSACTION_moveAb = 36;
        static final int TRANSACTION_deleteOdex = 37;
        static final int TRANSACTION_reconcileSecondaryDexFile = 38;
        static final int TRANSACTION_hashSecondaryDexFile = 39;
        static final int TRANSACTION_invalidateMounts = 40;
        static final int TRANSACTION_isQuotaSupported = 41;
        static final int TRANSACTION_prepareAppProfile = 42;
        static final int TRANSACTION_snapshotAppData = 43;
        static final int TRANSACTION_restoreAppDataSnapshot = 44;
        static final int TRANSACTION_destroyAppDataSnapshot = 45;
        static final int TRANSACTION_destroyCeSnapshotsNotSpecified = 46;
        static final int TRANSACTION_tryMountDataMirror = 47;
        static final int TRANSACTION_onPrivateVolumeRemoved = 48;
        static final int TRANSACTION_migrateLegacyObbData = 49;
        static final int TRANSACTION_cleanupInvalidPackageDirs = 50;
        static final int TRANSACTION_getOdexVisibility = 51;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInstalld asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInstalld) {
                return (IInstalld)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createUserData";
                }
                case 2: {
                    return "destroyUserData";
                }
                case 3: {
                    return "setFirstBoot";
                }
                case 4: {
                    return "createAppData";
                }
                case 5: {
                    return "createAppDataBatched";
                }
                case 6: {
                    return "reconcileSdkData";
                }
                case 7: {
                    return "restoreconAppData";
                }
                case 8: {
                    return "migrateAppData";
                }
                case 9: {
                    return "clearAppData";
                }
                case 10: {
                    return "destroyAppData";
                }
                case 11: {
                    return "fixupAppData";
                }
                case 12: {
                    return "getAppSize";
                }
                case 13: {
                    return "getUserSize";
                }
                case 14: {
                    return "getExternalSize";
                }
                case 15: {
                    return "getAppCrates";
                }
                case 16: {
                    return "getUserCrates";
                }
                case 17: {
                    return "setAppQuota";
                }
                case 18: {
                    return "moveCompleteApp";
                }
                case 19: {
                    return "dexopt";
                }
                case 20: {
                    return "controlDexOptBlocking";
                }
                case 21: {
                    return "compileLayouts";
                }
                case 22: {
                    return "rmdex";
                }
                case 23: {
                    return "mergeProfiles";
                }
                case 24: {
                    return "dumpProfiles";
                }
                case 25: {
                    return "copySystemProfile";
                }
                case 26: {
                    return "clearAppProfiles";
                }
                case 27: {
                    return "destroyAppProfiles";
                }
                case 28: {
                    return "deleteReferenceProfile";
                }
                case 29: {
                    return "createProfileSnapshot";
                }
                case 30: {
                    return "destroyProfileSnapshot";
                }
                case 31: {
                    return "rmPackageDir";
                }
                case 32: {
                    return "freeCache";
                }
                case 33: {
                    return "linkNativeLibraryDirectory";
                }
                case 34: {
                    return "createOatDir";
                }
                case 35: {
                    return "linkFile";
                }
                case 36: {
                    return "moveAb";
                }
                case 37: {
                    return "deleteOdex";
                }
                case 38: {
                    return "reconcileSecondaryDexFile";
                }
                case 39: {
                    return "hashSecondaryDexFile";
                }
                case 40: {
                    return "invalidateMounts";
                }
                case 41: {
                    return "isQuotaSupported";
                }
                case 42: {
                    return "prepareAppProfile";
                }
                case 43: {
                    return "snapshotAppData";
                }
                case 44: {
                    return "restoreAppDataSnapshot";
                }
                case 45: {
                    return "destroyAppDataSnapshot";
                }
                case 46: {
                    return "destroyCeSnapshotsNotSpecified";
                }
                case 47: {
                    return "tryMountDataMirror";
                }
                case 48: {
                    return "onPrivateVolumeRemoved";
                }
                case 49: {
                    return "migrateLegacyObbData";
                }
                case 50: {
                    return "cleanupInvalidPackageDirs";
                }
                case 51: {
                    return "getOdexVisibility";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createUserData(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroyUserData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    this.setFirstBoot();
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    CreateAppDataArgs _arg0 = data.readTypedObject(CreateAppDataArgs.CREATOR);
                    data.enforceNoDataAvail();
                    CreateAppDataResult _result = this.createAppData(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    CreateAppDataArgs[] _arg0 = data.createTypedArray(CreateAppDataArgs.CREATOR);
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.createAppDataBatched(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 6: {
                    ReconcileSdkDataArgs _arg0 = data.readTypedObject(ReconcileSdkDataArgs.CREATOR);
                    data.enforceNoDataAvail();
                    this.reconcileSdkData(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    this.restoreconAppData(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.migrateAppData(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    long _arg4 = data.readLong();
                    data.enforceNoDataAvail();
                    this.clearAppData(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    long _arg4 = data.readLong();
                    data.enforceNoDataAvail();
                    this.destroyAppData(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.fixupAppData(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    String[] _arg1 = data.createStringArray();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    long[] _arg5 = data.createLongArray();
                    String[] _arg6 = data.createStringArray();
                    data.enforceNoDataAvail();
                    long[] _result = this.getAppSize(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int[] _arg3 = data.createIntArray();
                    data.enforceNoDataAvail();
                    long[] _result = this.getUserSize(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int[] _arg3 = data.createIntArray();
                    data.enforceNoDataAvail();
                    long[] _result = this.getExternalSize(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    String[] _arg1 = data.createStringArray();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getAppCrates(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getUserCrates(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setAppQuota(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    int _arg5 = data.readInt();
                    String _arg6 = data.readString();
                    data.enforceNoDataAvail();
                    this.moveCompleteApp(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    String _arg7 = data.readString();
                    String _arg8 = data.readString();
                    String _arg9 = data.readString();
                    String _arg10 = data.readString();
                    boolean _arg11 = data.readBoolean();
                    int _arg12 = data.readInt();
                    String _arg13 = data.readString();
                    String _arg14 = data.readString();
                    String _arg15 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.dexopt(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10, _arg11, _arg12, _arg13, _arg14, _arg15);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.controlDexOptBlocking(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.compileLayouts(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.rmdex(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.mergeProfiles(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.dumpProfiles(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.copySystemProfile(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.clearAppProfiles(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.destroyAppProfiles(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.deleteReferenceProfile(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.createProfileSnapshot(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.destroyProfileSnapshot(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.rmPackageDir(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.freeCache(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.linkNativeLibraryDirectory(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.createOatDir(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.linkFile(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.moveAb(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    long _result = this.deleteOdex(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 38: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String[] _arg3 = data.createStringArray();
                    String _arg4 = data.readString();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.reconcileSecondaryDexFile(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    byte[] _result = this.hashSecondaryDexFile(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 40: {
                    this.invalidateMounts();
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isQuotaSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.prepareAppProfile(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 43: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.snapshotAppData(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 44: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.restoreAppDataSnapshot(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    long _arg3 = data.readLong();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroyAppDataSnapshot(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.destroyCeSnapshotsNotSpecified(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.tryMountDataMirror(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onPrivateVolumeRemoved(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    this.migrateLegacyObbData();
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cleanupInvalidPackageDirs(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getOdexVisibility(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 50;
        }

        private static class Proxy
        implements IInstalld {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createUserData(String uuid, int userId, int userSerial, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    _data.writeInt(userSerial);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyUserData(String uuid, int userId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFirstBoot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CreateAppDataResult createAppData(CreateAppDataArgs args) throws RemoteException {
                CreateAppDataResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(args, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CreateAppDataResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CreateAppDataResult[] createAppDataBatched(CreateAppDataArgs[] args) throws RemoteException {
                CreateAppDataResult[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(args, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(CreateAppDataResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reconcileSdkData(ReconcileSdkDataArgs args) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(args, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreconAppData(String uuid, String packageName, int userId, int flags, int appId, String seInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    _data.writeInt(appId);
                    _data.writeString(seInfo);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void migrateAppData(String uuid, String packageName, int userId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearAppData(String uuid, String packageName, int userId, int flags, long ceDataInode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    _data.writeLong(ceDataInode);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyAppData(String uuid, String packageName, int userId, int flags, long ceDataInode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    _data.writeLong(ceDataInode);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fixupAppData(String uuid, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] getAppSize(String uuid, String[] packageNames, int userId, int flags, int appId, long[] ceDataInodes, String[] codePaths) throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    _data.writeInt(appId);
                    _data.writeLongArray(ceDataInodes);
                    _data.writeStringArray(codePaths);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] getUserSize(String uuid, int userId, int flags, int[] appIds) throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    _data.writeIntArray(appIds);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] getExternalSize(String uuid, int userId, int flags, int[] appIds) throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    _data.writeIntArray(appIds);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CrateMetadata[] getAppCrates(String uuid, String[] packageNames, int userId) throws RemoteException {
                CrateMetadata[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(CrateMetadata.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CrateMetadata[] getUserCrates(String uuid, int userId) throws RemoteException {
                CrateMetadata[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(CrateMetadata.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAppQuota(String uuid, int userId, int appId, long cacheQuota) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    _data.writeInt(appId);
                    _data.writeLong(cacheQuota);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveCompleteApp(String fromUuid, String toUuid, String packageName, int appId, String seInfo, int targetSdkVersion, String fromCodePath) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fromUuid);
                    _data.writeString(toUuid);
                    _data.writeString(packageName);
                    _data.writeInt(appId);
                    _data.writeString(seInfo);
                    _data.writeInt(targetSdkVersion);
                    _data.writeString(fromCodePath);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean dexopt(String apkPath, int uid, String packageName, String instructionSet, int dexoptNeeded, String outputPath, int dexFlags, String compilerFilter, String uuid, String sharedLibraries, String seInfo, boolean downgrade, int targetSdkVersion, String profileName, String dexMetadataPath, String compilationReason) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(apkPath);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(instructionSet);
                    _data.writeInt(dexoptNeeded);
                    _data.writeString(outputPath);
                    _data.writeInt(dexFlags);
                    _data.writeString(compilerFilter);
                    _data.writeString(uuid);
                    _data.writeString(sharedLibraries);
                    _data.writeString(seInfo);
                    _data.writeBoolean(downgrade);
                    _data.writeInt(targetSdkVersion);
                    _data.writeString(profileName);
                    _data.writeString(dexMetadataPath);
                    _data.writeString(compilationReason);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void controlDexOptBlocking(boolean block) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(block);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean compileLayouts(String apkPath, String packageName, String outDexFile, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(apkPath);
                    _data.writeString(packageName);
                    _data.writeString(outDexFile);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rmdex(String codePath, String instructionSet) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(codePath);
                    _data.writeString(instructionSet);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int mergeProfiles(int uid, String packageName, String profileName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(profileName);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean dumpProfiles(int uid, String packageName, String profileName, String codePath, boolean dumpClassesAndMethods) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(profileName);
                    _data.writeString(codePath);
                    _data.writeBoolean(dumpClassesAndMethods);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean copySystemProfile(String systemProfile, int uid, String packageName, String profileName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(systemProfile);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(profileName);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearAppProfiles(String packageName, String profileName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(profileName);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyAppProfiles(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteReferenceProfile(String packageName, String profileName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(profileName);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean createProfileSnapshot(int appId, String packageName, String profileName, String classpath) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(appId);
                    _data.writeString(packageName);
                    _data.writeString(profileName);
                    _data.writeString(classpath);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyProfileSnapshot(String packageName, String profileName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(profileName);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rmPackageDir(String packageName, String packageDir) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(packageDir);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freeCache(String uuid, long targetFreeBytes, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeLong(targetFreeBytes);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void linkNativeLibraryDirectory(String uuid, String packageName, String nativeLibPath32, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeString(packageName);
                    _data.writeString(nativeLibPath32);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createOatDir(String packageName, String oatDir, String instructionSet) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(oatDir);
                    _data.writeString(instructionSet);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void linkFile(String packageName, String relativePath, String fromBase, String toBase) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(relativePath);
                    _data.writeString(fromBase);
                    _data.writeString(toBase);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveAb(String packageName, String apkPath, String instructionSet, String outputPath) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(apkPath);
                    _data.writeString(instructionSet);
                    _data.writeString(outputPath);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long deleteOdex(String packageName, String apkPath, String instructionSet, String outputPath) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(apkPath);
                    _data.writeString(instructionSet);
                    _data.writeString(outputPath);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reconcileSecondaryDexFile(String dexPath, String pkgName, int uid, String[] isas, String volume_uuid, int storage_flag) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(dexPath);
                    _data.writeString(pkgName);
                    _data.writeInt(uid);
                    _data.writeStringArray(isas);
                    _data.writeString(volume_uuid);
                    _data.writeInt(storage_flag);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] hashSecondaryDexFile(String dexPath, String pkgName, int uid, String volumeUuid, int storageFlag) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(dexPath);
                    _data.writeString(pkgName);
                    _data.writeInt(uid);
                    _data.writeString(volumeUuid);
                    _data.writeInt(storageFlag);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateMounts() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isQuotaSupported(String uuid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean prepareAppProfile(String packageName, int userId, int appId, String profileName, String codePath, String dexMetadata) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(appId);
                    _data.writeString(profileName);
                    _data.writeString(codePath);
                    _data.writeString(dexMetadata);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long snapshotAppData(String uuid, String packageName, int userId, int snapshotId, int storageFlags) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(snapshotId);
                    _data.writeInt(storageFlags);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreAppDataSnapshot(String uuid, String packageName, int appId, String seInfo, int user, int snapshotId, int storageflags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeString(packageName);
                    _data.writeInt(appId);
                    _data.writeString(seInfo);
                    _data.writeInt(user);
                    _data.writeInt(snapshotId);
                    _data.writeInt(storageflags);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyAppDataSnapshot(String uuid, String packageName, int userId, long ceSnapshotInode, int snapshotId, int storageFlags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeLong(ceSnapshotInode);
                    _data.writeInt(snapshotId);
                    _data.writeInt(storageFlags);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyCeSnapshotsNotSpecified(String uuid, int userId, int[] retainSnapshotIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    _data.writeIntArray(retainSnapshotIds);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tryMountDataMirror(String volumeUuid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPrivateVolumeRemoved(String volumeUuid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volumeUuid);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void migrateLegacyObbData() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cleanupInvalidPackageDirs(String uuid, int userId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getOdexVisibility(String packageName, String apkPath, String instructionSet, String outputPath) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(apkPath);
                    _data.writeString(instructionSet);
                    _data.writeString(outputPath);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IInstalld {
        @Override
        public void createUserData(String uuid, int userId, int userSerial, int flags) throws RemoteException {
        }

        @Override
        public void destroyUserData(String uuid, int userId, int flags) throws RemoteException {
        }

        @Override
        public void setFirstBoot() throws RemoteException {
        }

        @Override
        public CreateAppDataResult createAppData(CreateAppDataArgs args) throws RemoteException {
            return null;
        }

        @Override
        public CreateAppDataResult[] createAppDataBatched(CreateAppDataArgs[] args) throws RemoteException {
            return null;
        }

        @Override
        public void reconcileSdkData(ReconcileSdkDataArgs args) throws RemoteException {
        }

        @Override
        public void restoreconAppData(String uuid, String packageName, int userId, int flags, int appId, String seInfo) throws RemoteException {
        }

        @Override
        public void migrateAppData(String uuid, String packageName, int userId, int flags) throws RemoteException {
        }

        @Override
        public void clearAppData(String uuid, String packageName, int userId, int flags, long ceDataInode) throws RemoteException {
        }

        @Override
        public void destroyAppData(String uuid, String packageName, int userId, int flags, long ceDataInode) throws RemoteException {
        }

        @Override
        public void fixupAppData(String uuid, int flags) throws RemoteException {
        }

        @Override
        public long[] getAppSize(String uuid, String[] packageNames, int userId, int flags, int appId, long[] ceDataInodes, String[] codePaths) throws RemoteException {
            return null;
        }

        @Override
        public long[] getUserSize(String uuid, int userId, int flags, int[] appIds) throws RemoteException {
            return null;
        }

        @Override
        public long[] getExternalSize(String uuid, int userId, int flags, int[] appIds) throws RemoteException {
            return null;
        }

        @Override
        public CrateMetadata[] getAppCrates(String uuid, String[] packageNames, int userId) throws RemoteException {
            return null;
        }

        @Override
        public CrateMetadata[] getUserCrates(String uuid, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setAppQuota(String uuid, int userId, int appId, long cacheQuota) throws RemoteException {
        }

        @Override
        public void moveCompleteApp(String fromUuid, String toUuid, String packageName, int appId, String seInfo, int targetSdkVersion, String fromCodePath) throws RemoteException {
        }

        @Override
        public boolean dexopt(String apkPath, int uid, String packageName, String instructionSet, int dexoptNeeded, String outputPath, int dexFlags, String compilerFilter, String uuid, String sharedLibraries, String seInfo, boolean downgrade, int targetSdkVersion, String profileName, String dexMetadataPath, String compilationReason) throws RemoteException {
            return false;
        }

        @Override
        public void controlDexOptBlocking(boolean block) throws RemoteException {
        }

        @Override
        public boolean compileLayouts(String apkPath, String packageName, String outDexFile, int uid) throws RemoteException {
            return false;
        }

        @Override
        public void rmdex(String codePath, String instructionSet) throws RemoteException {
        }

        @Override
        public int mergeProfiles(int uid, String packageName, String profileName) throws RemoteException {
            return 0;
        }

        @Override
        public boolean dumpProfiles(int uid, String packageName, String profileName, String codePath, boolean dumpClassesAndMethods) throws RemoteException {
            return false;
        }

        @Override
        public boolean copySystemProfile(String systemProfile, int uid, String packageName, String profileName) throws RemoteException {
            return false;
        }

        @Override
        public void clearAppProfiles(String packageName, String profileName) throws RemoteException {
        }

        @Override
        public void destroyAppProfiles(String packageName) throws RemoteException {
        }

        @Override
        public void deleteReferenceProfile(String packageName, String profileName) throws RemoteException {
        }

        @Override
        public boolean createProfileSnapshot(int appId, String packageName, String profileName, String classpath) throws RemoteException {
            return false;
        }

        @Override
        public void destroyProfileSnapshot(String packageName, String profileName) throws RemoteException {
        }

        @Override
        public void rmPackageDir(String packageName, String packageDir) throws RemoteException {
        }

        @Override
        public void freeCache(String uuid, long targetFreeBytes, int flags) throws RemoteException {
        }

        @Override
        public void linkNativeLibraryDirectory(String uuid, String packageName, String nativeLibPath32, int userId) throws RemoteException {
        }

        @Override
        public void createOatDir(String packageName, String oatDir, String instructionSet) throws RemoteException {
        }

        @Override
        public void linkFile(String packageName, String relativePath, String fromBase, String toBase) throws RemoteException {
        }

        @Override
        public void moveAb(String packageName, String apkPath, String instructionSet, String outputPath) throws RemoteException {
        }

        @Override
        public long deleteOdex(String packageName, String apkPath, String instructionSet, String outputPath) throws RemoteException {
            return 0L;
        }

        @Override
        public boolean reconcileSecondaryDexFile(String dexPath, String pkgName, int uid, String[] isas, String volume_uuid, int storage_flag) throws RemoteException {
            return false;
        }

        @Override
        public byte[] hashSecondaryDexFile(String dexPath, String pkgName, int uid, String volumeUuid, int storageFlag) throws RemoteException {
            return null;
        }

        @Override
        public void invalidateMounts() throws RemoteException {
        }

        @Override
        public boolean isQuotaSupported(String uuid) throws RemoteException {
            return false;
        }

        @Override
        public boolean prepareAppProfile(String packageName, int userId, int appId, String profileName, String codePath, String dexMetadata) throws RemoteException {
            return false;
        }

        @Override
        public long snapshotAppData(String uuid, String packageName, int userId, int snapshotId, int storageFlags) throws RemoteException {
            return 0L;
        }

        @Override
        public void restoreAppDataSnapshot(String uuid, String packageName, int appId, String seInfo, int user, int snapshotId, int storageflags) throws RemoteException {
        }

        @Override
        public void destroyAppDataSnapshot(String uuid, String packageName, int userId, long ceSnapshotInode, int snapshotId, int storageFlags) throws RemoteException {
        }

        @Override
        public void destroyCeSnapshotsNotSpecified(String uuid, int userId, int[] retainSnapshotIds) throws RemoteException {
        }

        @Override
        public void tryMountDataMirror(String volumeUuid) throws RemoteException {
        }

        @Override
        public void onPrivateVolumeRemoved(String volumeUuid) throws RemoteException {
        }

        @Override
        public void migrateLegacyObbData() throws RemoteException {
        }

        @Override
        public void cleanupInvalidPackageDirs(String uuid, int userId, int flags) throws RemoteException {
        }

        @Override
        public int getOdexVisibility(String packageName, String apkPath, String instructionSet, String outputPath) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

