/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RSDriverException;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.view.Surface;
import android.view.SurfaceHolder;

@Deprecated
public class RenderScriptGL
extends RenderScript {
    int mWidth;
    int mHeight;
    SurfaceConfig mSurfaceConfig;

    @UnsupportedAppUsage
    public RenderScriptGL(Context ctx, SurfaceConfig sc) {
        super(ctx);
        this.mSurfaceConfig = new SurfaceConfig(sc);
        int sdkVersion = ctx.getApplicationInfo().targetSdkVersion;
        this.mWidth = 0;
        this.mHeight = 0;
        long device = this.nDeviceCreate();
        int dpi = ctx.getResources().getDisplayMetrics().densityDpi;
        this.mContext = this.nContextCreateGL(device, 0, sdkVersion, this.mSurfaceConfig.mColorMin, this.mSurfaceConfig.mColorPref, this.mSurfaceConfig.mAlphaMin, this.mSurfaceConfig.mAlphaPref, this.mSurfaceConfig.mDepthMin, this.mSurfaceConfig.mDepthPref, this.mSurfaceConfig.mStencilMin, this.mSurfaceConfig.mStencilPref, this.mSurfaceConfig.mSamplesMin, this.mSurfaceConfig.mSamplesPref, this.mSurfaceConfig.mSamplesQ, dpi);
        if (this.mContext == 0L) {
            throw new RSDriverException("Failed to create RS context.");
        }
        this.mMessageThread = new RenderScript.MessageThread(this);
        this.mMessageThread.start();
    }

    @UnsupportedAppUsage
    public void setSurface(SurfaceHolder sur, int w, int h) {
        this.validate();
        Surface s = null;
        if (sur != null) {
            s = sur.getSurface();
        }
        this.mWidth = w;
        this.mHeight = h;
        this.nContextSetSurface(w, h, s);
    }

    public void setSurfaceTexture(SurfaceTexture sur, int w, int h) {
        this.validate();
        Surface s = null;
        if (sur != null) {
            s = new Surface(sur);
        }
        this.mWidth = w;
        this.mHeight = h;
        this.nContextSetSurface(w, h, s);
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void pause() {
        this.validate();
        this.nContextPause();
    }

    public void resume() {
        this.validate();
        this.nContextResume();
    }

    @UnsupportedAppUsage
    public void bindRootScript(Script s) {
        this.validate();
        this.nContextBindRootScript((int)this.safeID(s));
    }

    @UnsupportedAppUsage
    public void bindProgramStore(ProgramStore p) {
        this.validate();
        this.nContextBindProgramStore((int)this.safeID(p));
    }

    public void bindProgramFragment(ProgramFragment p) {
        this.validate();
        this.nContextBindProgramFragment((int)this.safeID(p));
    }

    @UnsupportedAppUsage
    public void bindProgramRaster(ProgramRaster p) {
        this.validate();
        this.nContextBindProgramRaster((int)this.safeID(p));
    }

    @UnsupportedAppUsage
    public void bindProgramVertex(ProgramVertex p) {
        this.validate();
        this.nContextBindProgramVertex((int)this.safeID(p));
    }

    public static class SurfaceConfig {
        int mDepthMin = 0;
        int mDepthPref = 0;
        int mStencilMin = 0;
        int mStencilPref = 0;
        int mColorMin = 8;
        int mColorPref = 8;
        int mAlphaMin = 0;
        int mAlphaPref = 0;
        int mSamplesMin = 1;
        int mSamplesPref = 1;
        float mSamplesQ = 1.0f;

        @UnsupportedAppUsage
        public SurfaceConfig() {
        }

        public SurfaceConfig(SurfaceConfig sc) {
            this.mDepthMin = sc.mDepthMin;
            this.mDepthPref = sc.mDepthPref;
            this.mStencilMin = sc.mStencilMin;
            this.mStencilPref = sc.mStencilPref;
            this.mColorMin = sc.mColorMin;
            this.mColorPref = sc.mColorPref;
            this.mAlphaMin = sc.mAlphaMin;
            this.mAlphaPref = sc.mAlphaPref;
            this.mSamplesMin = sc.mSamplesMin;
            this.mSamplesPref = sc.mSamplesPref;
            this.mSamplesQ = sc.mSamplesQ;
        }

        private void validateRange(int umin, int upref, int rmin, int rmax) {
            if (umin < rmin || umin > rmax) {
                throw new RSIllegalArgumentException("Minimum value provided out of range.");
            }
            if (upref < umin) {
                throw new RSIllegalArgumentException("preferred must be >= Minimum.");
            }
        }

        public void setColor(int minimum, int preferred) {
            this.validateRange(minimum, preferred, 5, 8);
            this.mColorMin = minimum;
            this.mColorPref = preferred;
        }

        public void setAlpha(int minimum, int preferred) {
            this.validateRange(minimum, preferred, 0, 8);
            this.mAlphaMin = minimum;
            this.mAlphaPref = preferred;
        }

        @UnsupportedAppUsage
        public void setDepth(int minimum, int preferred) {
            this.validateRange(minimum, preferred, 0, 24);
            this.mDepthMin = minimum;
            this.mDepthPref = preferred;
        }

        public void setSamples(int minimum, int preferred, float Q) {
            this.validateRange(minimum, preferred, 1, 32);
            if (Q < 0.0f || Q > 1.0f) {
                throw new RSIllegalArgumentException("Quality out of 0-1 range.");
            }
            this.mSamplesMin = minimum;
            this.mSamplesPref = preferred;
            this.mSamplesQ = Q;
        }
    }
}

