/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.LinkProperties;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.AccessNetworkConstants;
import android.telephony.DataFailCause;
import android.telephony.TelephonyManager;
import android.telephony.data.ApnSetting;
import com.android.internal.telephony.util.TelephonyUtils;
import java.util.Objects;

public class PreciseDataConnectionState
implements Parcelable {
    private final int mTransportType;
    private final int mId;
    private final int mState;
    private final int mNetworkType;
    private final int mFailCause;
    private final LinkProperties mLinkProperties;
    private final ApnSetting mApnSetting;
    private static final long GET_DATA_CONNECTION_STATE_R_VERSION = 148535736L;
    public static final Parcelable.Creator<PreciseDataConnectionState> CREATOR = new Parcelable.Creator<PreciseDataConnectionState>(){

        @Override
        public PreciseDataConnectionState createFromParcel(Parcel in) {
            return new PreciseDataConnectionState(in);
        }

        public PreciseDataConnectionState[] newArray(int size) {
            return new PreciseDataConnectionState[size];
        }
    };

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public PreciseDataConnectionState(int state, int networkType, int apnTypes, String apn, LinkProperties linkProperties, int failCause) {
        this(-1, -1, state, networkType, linkProperties, failCause, new ApnSetting.Builder().setApnTypeBitmask(apnTypes).setApnName(apn).setEntryName(apn).build());
    }

    private PreciseDataConnectionState(int transportType, int id2, int state, int networkType, LinkProperties linkProperties, int failCause, ApnSetting apnSetting) {
        this.mTransportType = transportType;
        this.mId = id2;
        this.mState = state;
        this.mNetworkType = networkType;
        this.mLinkProperties = linkProperties;
        this.mFailCause = failCause;
        this.mApnSetting = apnSetting;
    }

    private PreciseDataConnectionState(Parcel in) {
        this.mTransportType = in.readInt();
        this.mId = in.readInt();
        this.mState = in.readInt();
        this.mNetworkType = in.readInt();
        this.mLinkProperties = in.readParcelable(LinkProperties.class.getClassLoader(), LinkProperties.class);
        this.mFailCause = in.readInt();
        this.mApnSetting = in.readParcelable(ApnSetting.class.getClassLoader(), ApnSetting.class);
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionState() {
        if (this.mState == 4 && !Compatibility.isChangeEnabled(148535736L)) {
            return 2;
        }
        return this.mState;
    }

    public int getTransportType() {
        return this.mTransportType;
    }

    public int getId() {
        return this.mId;
    }

    public int getState() {
        return this.mState;
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionApnTypeBitMask() {
        return this.mApnSetting != null ? this.mApnSetting.getApnTypeBitmask() : 0;
    }

    @SystemApi
    @Deprecated
    public String getDataConnectionApn() {
        return this.mApnSetting != null ? this.mApnSetting.getApnName() : "";
    }

    public LinkProperties getLinkProperties() {
        return this.mLinkProperties;
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionFailCause() {
        return this.mFailCause;
    }

    public int getLastCauseCode() {
        return this.mFailCause;
    }

    public ApnSetting getApnSetting() {
        return this.mApnSetting;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mTransportType);
        out.writeInt(this.mId);
        out.writeInt(this.mState);
        out.writeInt(this.mNetworkType);
        out.writeParcelable(this.mLinkProperties, flags);
        out.writeInt(this.mFailCause);
        out.writeParcelable(this.mApnSetting, flags);
    }

    public int hashCode() {
        return Objects.hash(this.mTransportType, this.mId, this.mState, this.mNetworkType, this.mFailCause, this.mLinkProperties, this.mApnSetting);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreciseDataConnectionState that = (PreciseDataConnectionState)o;
        return this.mTransportType == that.mTransportType && this.mId == that.mId && this.mState == that.mState && this.mNetworkType == that.mNetworkType && this.mFailCause == that.mFailCause && Objects.equals(this.mLinkProperties, that.mLinkProperties) && Objects.equals(this.mApnSetting, that.mApnSetting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" state: " + TelephonyUtils.dataStateToString(this.mState));
        sb.append(", transport: " + AccessNetworkConstants.transportTypeToString(this.mTransportType));
        sb.append(", id: " + this.mId);
        sb.append(", network type: " + TelephonyManager.getNetworkTypeName(this.mNetworkType));
        sb.append(", APN Setting: " + this.mApnSetting);
        sb.append(", link properties: " + this.mLinkProperties);
        sb.append(", fail cause: " + DataFailCause.toString(this.mFailCause));
        return sb.toString();
    }

    public static class Builder {
        private int mTransportType = -1;
        private int mId = -1;
        private int mState = -1;
        private int mNetworkType = 0;
        private LinkProperties mLinkProperties = null;
        private int mFailCause = 0;
        private ApnSetting mApnSetting = null;

        public Builder setTransportType(int transportType) {
            this.mTransportType = transportType;
            return this;
        }

        public Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        public Builder setState(int state) {
            this.mState = state;
            return this;
        }

        public Builder setNetworkType(int networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        public Builder setLinkProperties(LinkProperties linkProperties) {
            this.mLinkProperties = linkProperties;
            return this;
        }

        public Builder setFailCause(int failCause) {
            this.mFailCause = failCause;
            return this;
        }

        public Builder setApnSetting(ApnSetting apnSetting) {
            this.mApnSetting = apnSetting;
            return this;
        }

        public PreciseDataConnectionState build() {
            return new PreciseDataConnectionState(this.mTransportType, this.mId, this.mState, this.mNetworkType, this.mLinkProperties, this.mFailCause, this.mApnSetting);
        }
    }
}

