/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.BackupUtils;
import android.util.Log;
import android.util.Range;
import com.android.internal.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.time.Clock;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Objects;

public class RecurrenceRule
implements Parcelable {
    private static final String TAG = "RecurrenceRule";
    private static final boolean LOGD = Log.isLoggable("RecurrenceRule", 3);
    private static final int VERSION_INIT = 0;
    @VisibleForTesting
    public static Clock sClock = Clock.systemDefaultZone();
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public final ZonedDateTime start;
    public final ZonedDateTime end;
    public final Period period;
    public static final Parcelable.Creator<RecurrenceRule> CREATOR = new Parcelable.Creator<RecurrenceRule>(){

        @Override
        public RecurrenceRule createFromParcel(Parcel source) {
            return new RecurrenceRule(source);
        }

        public RecurrenceRule[] newArray(int size) {
            return new RecurrenceRule[size];
        }
    };

    public RecurrenceRule(ZonedDateTime start, ZonedDateTime end, Period period) {
        this.start = start;
        this.end = end;
        this.period = period;
    }

    @Deprecated
    public static RecurrenceRule buildNever() {
        return new RecurrenceRule(null, null, null);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static RecurrenceRule buildRecurringMonthly(int dayOfMonth, ZoneId zone) {
        ZonedDateTime now = ZonedDateTime.now(sClock).withZoneSameInstant(zone);
        ZonedDateTime start = ZonedDateTime.of(now.toLocalDate().minusYears(1L).withMonth(1).withDayOfMonth(dayOfMonth), LocalTime.MIDNIGHT, zone);
        return new RecurrenceRule(start, null, Period.ofMonths(1));
    }

    private RecurrenceRule(Parcel source) {
        this.start = RecurrenceRule.convertZonedDateTime(source.readString());
        this.end = RecurrenceRule.convertZonedDateTime(source.readString());
        this.period = RecurrenceRule.convertPeriod(source.readString());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(RecurrenceRule.convertZonedDateTime(this.start));
        dest.writeString(RecurrenceRule.convertZonedDateTime(this.end));
        dest.writeString(RecurrenceRule.convertPeriod(this.period));
    }

    public RecurrenceRule(DataInputStream in) throws IOException {
        int version = in.readInt();
        switch (version) {
            case 0: {
                this.start = RecurrenceRule.convertZonedDateTime(BackupUtils.readString(in));
                this.end = RecurrenceRule.convertZonedDateTime(BackupUtils.readString(in));
                this.period = RecurrenceRule.convertPeriod(BackupUtils.readString(in));
                break;
            }
            default: {
                throw new ProtocolException("Unknown version " + version);
            }
        }
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(0);
        BackupUtils.writeString(out, RecurrenceRule.convertZonedDateTime(this.start));
        BackupUtils.writeString(out, RecurrenceRule.convertZonedDateTime(this.end));
        BackupUtils.writeString(out, RecurrenceRule.convertPeriod(this.period));
    }

    public String toString() {
        return "RecurrenceRule{" + "start=" + this.start + " end=" + this.end + " period=" + this.period + "}";
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.period);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecurrenceRule) {
            RecurrenceRule other = (RecurrenceRule)obj;
            return Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.period, other.period);
        }
        return false;
    }

    public boolean isRecurring() {
        return this.period != null;
    }

    @Deprecated
    public boolean isMonthly() {
        return this.start != null && this.period != null && this.period.getYears() == 0 && this.period.getMonths() == 1 && this.period.getDays() == 0;
    }

    public Iterator<Range<ZonedDateTime>> cycleIterator() {
        if (this.period != null) {
            return new RecurringIterator();
        }
        return new NonrecurringIterator();
    }

    public static String convertZonedDateTime(ZonedDateTime time) {
        return time != null ? time.toString() : null;
    }

    public static ZonedDateTime convertZonedDateTime(String time) {
        return time != null ? ZonedDateTime.parse(time) : null;
    }

    public static String convertPeriod(Period period) {
        return period != null ? period.toString() : null;
    }

    public static Period convertPeriod(String period) {
        return period != null ? Period.parse(period) : null;
    }

    private class RecurringIterator
    implements Iterator<Range<ZonedDateTime>> {
        int i;
        ZonedDateTime cycleStart;
        ZonedDateTime cycleEnd;

        public RecurringIterator() {
            ZonedDateTime anchor;
            ZonedDateTime zonedDateTime = anchor = RecurrenceRule.this.end != null ? RecurrenceRule.this.end : ZonedDateTime.now(sClock).withZoneSameInstant(RecurrenceRule.this.start.getZone());
            if (LOGD) {
                Log.d(RecurrenceRule.TAG, "Resolving using anchor " + anchor);
            }
            this.updateCycle();
            while (anchor.toEpochSecond() > this.cycleEnd.toEpochSecond()) {
                ++this.i;
                this.updateCycle();
            }
            while (anchor.toEpochSecond() <= this.cycleStart.toEpochSecond()) {
                --this.i;
                this.updateCycle();
            }
        }

        private void updateCycle() {
            this.cycleStart = this.roundBoundaryTime(RecurrenceRule.this.start.plus(RecurrenceRule.this.period.multipliedBy(this.i)));
            this.cycleEnd = this.roundBoundaryTime(RecurrenceRule.this.start.plus(RecurrenceRule.this.period.multipliedBy(this.i + 1)));
        }

        private ZonedDateTime roundBoundaryTime(ZonedDateTime boundary) {
            if (RecurrenceRule.this.isMonthly() && boundary.getDayOfMonth() < RecurrenceRule.this.start.getDayOfMonth()) {
                return ZonedDateTime.of(boundary.toLocalDate(), LocalTime.MAX, RecurrenceRule.this.start.getZone());
            }
            return boundary;
        }

        @Override
        public boolean hasNext() {
            return this.cycleStart.toEpochSecond() >= RecurrenceRule.this.start.toEpochSecond();
        }

        @Override
        public Range<ZonedDateTime> next() {
            if (LOGD) {
                Log.d(RecurrenceRule.TAG, "Cycle " + this.i + " from " + this.cycleStart + " to " + this.cycleEnd);
            }
            Range<ZonedDateTime> r = new Range<ZonedDateTime>(this.cycleStart, this.cycleEnd);
            --this.i;
            this.updateCycle();
            return r;
        }
    }

    private class NonrecurringIterator
    implements Iterator<Range<ZonedDateTime>> {
        boolean hasNext;

        public NonrecurringIterator() {
            this.hasNext = RecurrenceRule.this.start != null && RecurrenceRule.this.end != null;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Range<ZonedDateTime> next() {
            this.hasNext = false;
            return new Range<ZonedDateTime>(RecurrenceRule.this.start, RecurrenceRule.this.end);
        }
    }
}

