/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ProgressBar;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbsSeekBar
extends ProgressBar {
    private final Rect mTempRect = new Rect();
    @UnsupportedAppUsage
    private Drawable mThumb;
    private ColorStateList mThumbTintList = null;
    private BlendMode mThumbBlendMode = null;
    private boolean mHasThumbTint = false;
    private boolean mHasThumbBlendMode = false;
    private Drawable mTickMark;
    private ColorStateList mTickMarkTintList = null;
    private BlendMode mTickMarkBlendMode = null;
    private boolean mHasTickMarkTint = false;
    private boolean mHasTickMarkBlendMode = false;
    private int mThumbOffset;
    @UnsupportedAppUsage
    private boolean mSplitTrack;
    @UnsupportedAppUsage
    float mTouchProgressOffset;
    @UnsupportedAppUsage
    boolean mIsUserSeekable = true;
    private int mKeyProgressIncrement = 1;
    private static final int NO_ALPHA = 255;
    @UnsupportedAppUsage
    private float mDisabledAlpha;
    private int mThumbExclusionMaxSize;
    private int mScaledTouchSlop;
    private float mTouchDownX;
    @UnsupportedAppUsage
    private boolean mIsDragging;
    private float mTouchThumbOffset = 0.0f;
    private List<Rect> mUserGestureExclusionRects = Collections.emptyList();
    private final List<Rect> mGestureExclusionRects = new ArrayList<Rect>();
    private final Rect mThumbRect = new Rect();

    public AbsSeekBar(Context context) {
        super(context);
    }

    public AbsSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AbsSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public AbsSeekBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SeekBar, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.SeekBar, attrs, a, defStyleAttr, defStyleRes);
        Drawable thumb = a.getDrawable(0);
        this.setThumb(thumb);
        if (a.hasValue(4)) {
            this.mThumbBlendMode = Drawable.parseBlendMode(a.getInt(4, -1), this.mThumbBlendMode);
            this.mHasThumbBlendMode = true;
        }
        if (a.hasValue(3)) {
            this.mThumbTintList = a.getColorStateList(3);
            this.mHasThumbTint = true;
        }
        Drawable tickMark = a.getDrawable(5);
        this.setTickMark(tickMark);
        if (a.hasValue(7)) {
            this.mTickMarkBlendMode = Drawable.parseBlendMode(a.getInt(7, -1), this.mTickMarkBlendMode);
            this.mHasTickMarkBlendMode = true;
        }
        if (a.hasValue(6)) {
            this.mTickMarkTintList = a.getColorStateList(6);
            this.mHasTickMarkTint = true;
        }
        this.mSplitTrack = a.getBoolean(2, false);
        int thumbOffset = a.getDimensionPixelOffset(1, this.getThumbOffset());
        this.setThumbOffset(thumbOffset);
        boolean useDisabledAlpha = a.getBoolean(8, true);
        a.recycle();
        if (useDisabledAlpha) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.Theme, 0, 0);
            this.mDisabledAlpha = ta.getFloat(3, 0.5f);
            ta.recycle();
        } else {
            this.mDisabledAlpha = 1.0f;
        }
        this.applyThumbTint();
        this.applyTickMarkTint();
        this.mScaledTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.mThumbExclusionMaxSize = this.getResources().getDimensionPixelSize(17105534);
    }

    public void setThumb(Drawable thumb) {
        boolean needUpdate;
        if (this.mThumb != null && thumb != this.mThumb) {
            this.mThumb.setCallback(null);
            needUpdate = true;
        } else {
            needUpdate = false;
        }
        if (thumb != null) {
            thumb.setCallback(this);
            if (this.canResolveLayoutDirection()) {
                thumb.setLayoutDirection(this.getLayoutDirection());
            }
            this.mThumbOffset = thumb.getIntrinsicWidth() / 2;
            if (needUpdate && (thumb.getIntrinsicWidth() != this.mThumb.getIntrinsicWidth() || thumb.getIntrinsicHeight() != this.mThumb.getIntrinsicHeight())) {
                this.requestLayout();
            }
        }
        this.mThumb = thumb;
        this.applyThumbTint();
        this.invalidate();
        if (needUpdate) {
            this.updateThumbAndTrackPos(this.getWidth(), this.getHeight());
            if (thumb != null && thumb.isStateful()) {
                int[] state = this.getDrawableState();
                thumb.setState(state);
            }
        }
    }

    public Drawable getThumb() {
        return this.mThumb;
    }

    public void setThumbTintList(ColorStateList tint) {
        this.mThumbTintList = tint;
        this.mHasThumbTint = true;
        this.applyThumbTint();
    }

    public ColorStateList getThumbTintList() {
        return this.mThumbTintList;
    }

    public void setThumbTintMode(PorterDuff.Mode tintMode) {
        this.setThumbTintBlendMode(tintMode != null ? BlendMode.fromValue(tintMode.nativeInt) : null);
    }

    public void setThumbTintBlendMode(BlendMode blendMode) {
        this.mThumbBlendMode = blendMode;
        this.mHasThumbBlendMode = true;
        this.applyThumbTint();
    }

    public PorterDuff.Mode getThumbTintMode() {
        return this.mThumbBlendMode != null ? BlendMode.blendModeToPorterDuffMode(this.mThumbBlendMode) : null;
    }

    public BlendMode getThumbTintBlendMode() {
        return this.mThumbBlendMode;
    }

    private void applyThumbTint() {
        if (this.mThumb != null && (this.mHasThumbTint || this.mHasThumbBlendMode)) {
            this.mThumb = this.mThumb.mutate();
            if (this.mHasThumbTint) {
                this.mThumb.setTintList(this.mThumbTintList);
            }
            if (this.mHasThumbBlendMode) {
                this.mThumb.setTintBlendMode(this.mThumbBlendMode);
            }
            if (this.mThumb.isStateful()) {
                this.mThumb.setState(this.getDrawableState());
            }
        }
    }

    public int getThumbOffset() {
        return this.mThumbOffset;
    }

    public void setThumbOffset(int thumbOffset) {
        this.mThumbOffset = thumbOffset;
        this.invalidate();
    }

    public void setSplitTrack(boolean splitTrack) {
        this.mSplitTrack = splitTrack;
        this.invalidate();
    }

    public boolean getSplitTrack() {
        return this.mSplitTrack;
    }

    public void setTickMark(Drawable tickMark) {
        if (this.mTickMark != null) {
            this.mTickMark.setCallback(null);
        }
        this.mTickMark = tickMark;
        if (tickMark != null) {
            tickMark.setCallback(this);
            tickMark.setLayoutDirection(this.getLayoutDirection());
            if (tickMark.isStateful()) {
                tickMark.setState(this.getDrawableState());
            }
            this.applyTickMarkTint();
        }
        this.invalidate();
    }

    public Drawable getTickMark() {
        return this.mTickMark;
    }

    public void setTickMarkTintList(ColorStateList tint) {
        this.mTickMarkTintList = tint;
        this.mHasTickMarkTint = true;
        this.applyTickMarkTint();
    }

    public ColorStateList getTickMarkTintList() {
        return this.mTickMarkTintList;
    }

    public void setTickMarkTintMode(PorterDuff.Mode tintMode) {
        this.setTickMarkTintBlendMode(tintMode != null ? BlendMode.fromValue(tintMode.nativeInt) : null);
    }

    public void setTickMarkTintBlendMode(BlendMode blendMode) {
        this.mTickMarkBlendMode = blendMode;
        this.mHasTickMarkBlendMode = true;
        this.applyTickMarkTint();
    }

    public PorterDuff.Mode getTickMarkTintMode() {
        return this.mTickMarkBlendMode != null ? BlendMode.blendModeToPorterDuffMode(this.mTickMarkBlendMode) : null;
    }

    public BlendMode getTickMarkTintBlendMode() {
        return this.mTickMarkBlendMode;
    }

    private void applyTickMarkTint() {
        if (this.mTickMark != null && (this.mHasTickMarkTint || this.mHasTickMarkBlendMode)) {
            this.mTickMark = this.mTickMark.mutate();
            if (this.mHasTickMarkTint) {
                this.mTickMark.setTintList(this.mTickMarkTintList);
            }
            if (this.mHasTickMarkBlendMode) {
                this.mTickMark.setTintBlendMode(this.mTickMarkBlendMode);
            }
            if (this.mTickMark.isStateful()) {
                this.mTickMark.setState(this.getDrawableState());
            }
        }
    }

    public void setKeyProgressIncrement(int increment) {
        this.mKeyProgressIncrement = increment < 0 ? -increment : increment;
    }

    public int getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    @Override
    public synchronized void setMin(int min) {
        super.setMin(min);
        int range = this.getMax() - this.getMin();
        if (this.mKeyProgressIncrement == 0 || range / this.mKeyProgressIncrement > 20) {
            this.setKeyProgressIncrement(Math.max(1, Math.round((float)range / 20.0f)));
        }
    }

    @Override
    public synchronized void setMax(int max) {
        super.setMax(max);
        int range = this.getMax() - this.getMin();
        if (this.mKeyProgressIncrement == 0 || range / this.mKeyProgressIncrement > 20) {
            this.setKeyProgressIncrement(Math.max(1, Math.round((float)range / 20.0f)));
        }
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        return who == this.mThumb || who == this.mTickMark || super.verifyDrawable(who);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mThumb != null) {
            this.mThumb.jumpToCurrentState();
        }
        if (this.mTickMark != null) {
            this.mTickMark.jumpToCurrentState();
        }
    }

    @Override
    protected void drawableStateChanged() {
        Drawable tickMark;
        Drawable thumb;
        super.drawableStateChanged();
        Drawable progressDrawable = this.getProgressDrawable();
        if (progressDrawable != null && this.mDisabledAlpha < 1.0f) {
            progressDrawable.setAlpha(this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha));
        }
        if ((thumb = this.mThumb) != null && thumb.isStateful() && thumb.setState(this.getDrawableState())) {
            this.invalidateDrawable(thumb);
        }
        if ((tickMark = this.mTickMark) != null && tickMark.isStateful() && tickMark.setState(this.getDrawableState())) {
            this.invalidateDrawable(tickMark);
        }
    }

    @Override
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mThumb != null) {
            this.mThumb.setHotspot(x, y);
        }
    }

    @Override
    void onVisualProgressChanged(int id2, float scale) {
        Drawable thumb;
        super.onVisualProgressChanged(id2, scale);
        if (id2 == 16908301 && (thumb = this.mThumb) != null) {
            this.setThumbPos(this.getWidth(), thumb, scale, Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateThumbAndTrackPos(w, h);
    }

    private void updateThumbAndTrackPos(int w, int h) {
        int thumbOffset;
        int trackOffset;
        int offsetHeight;
        int thumbHeight;
        int paddedHeight = h - this.mPaddingTop - this.mPaddingBottom;
        Drawable track = this.getCurrentDrawable();
        Drawable thumb = this.mThumb;
        int trackHeight = Math.min(this.mMaxHeight, paddedHeight);
        int n = thumbHeight = thumb == null ? 0 : thumb.getIntrinsicHeight();
        if (thumbHeight > trackHeight) {
            offsetHeight = (paddedHeight - thumbHeight) / 2;
            trackOffset = offsetHeight + (thumbHeight - trackHeight) / 2;
            thumbOffset = offsetHeight;
        } else {
            trackOffset = offsetHeight = (paddedHeight - trackHeight) / 2;
            thumbOffset = offsetHeight + (trackHeight - thumbHeight) / 2;
        }
        if (track != null) {
            int trackWidth = w - this.mPaddingRight - this.mPaddingLeft;
            track.setBounds(0, trackOffset, trackWidth, trackOffset + trackHeight);
        }
        if (thumb != null) {
            this.setThumbPos(w, thumb, this.getScale(), thumbOffset);
        }
    }

    private float getScale() {
        int min = this.getMin();
        int max = this.getMax();
        int range = max - min;
        return range > 0 ? (float)(this.getProgress() - min) / (float)range : 0.0f;
    }

    private void setThumbPos(int w, Drawable thumb, float scale, int offset) {
        int bottom;
        int top;
        int available = w - this.mPaddingLeft - this.mPaddingRight;
        int thumbWidth = thumb.getIntrinsicWidth();
        int thumbHeight = thumb.getIntrinsicHeight();
        available -= thumbWidth;
        int thumbPos = (int)(scale * (float)(available += this.mThumbOffset * 2) + 0.5f);
        if (offset == Integer.MIN_VALUE) {
            Rect oldBounds = thumb.getBounds();
            top = oldBounds.top;
            bottom = oldBounds.bottom;
        } else {
            top = offset;
            bottom = offset + thumbHeight;
        }
        int left = this.isLayoutRtl() && this.mMirrorForRtl ? available - thumbPos : thumbPos;
        int right = left + thumbWidth;
        Drawable background = this.getBackground();
        if (background != null) {
            int offsetX = this.mPaddingLeft - this.mThumbOffset;
            int offsetY = this.mPaddingTop;
            background.setHotspotBounds(left + offsetX, top + offsetY, right + offsetX, bottom + offsetY);
        }
        thumb.setBounds(left, top, right, bottom);
        this.updateGestureExclusionRects();
    }

    @Override
    public void setSystemGestureExclusionRects(List<Rect> rects) {
        Preconditions.checkNotNull(rects, "rects must not be null");
        this.mUserGestureExclusionRects = rects;
        this.updateGestureExclusionRects();
    }

    private void updateGestureExclusionRects() {
        Drawable thumb = this.mThumb;
        if (thumb == null) {
            super.setSystemGestureExclusionRects(this.mUserGestureExclusionRects);
            return;
        }
        this.mGestureExclusionRects.clear();
        thumb.copyBounds(this.mThumbRect);
        this.mThumbRect.offset(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
        this.growRectTo(this.mThumbRect, Math.min(this.getHeight(), this.mThumbExclusionMaxSize));
        this.mGestureExclusionRects.add(this.mThumbRect);
        this.mGestureExclusionRects.addAll(this.mUserGestureExclusionRects);
        super.setSystemGestureExclusionRects(this.mGestureExclusionRects);
    }

    @VisibleForTesting
    public void growRectTo(Rect r, int minimumSize) {
        int dx;
        int dy = minimumSize - r.height();
        if (dy > 0) {
            r.top -= (dy + 1) / 2;
            r.bottom += dy / 2;
        }
        if ((dx = minimumSize - r.width()) > 0) {
            r.left -= (dx + 1) / 2;
            r.right += dx / 2;
        }
    }

    @Override
    public void onResolveDrawables(int layoutDirection) {
        super.onResolveDrawables(layoutDirection);
        if (this.mThumb != null) {
            this.mThumb.setLayoutDirection(layoutDirection);
        }
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawThumb(canvas);
    }

    @Override
    void drawTrack(Canvas canvas) {
        Drawable thumbDrawable = this.mThumb;
        if (thumbDrawable != null && this.mSplitTrack) {
            Insets insets = thumbDrawable.getOpticalInsets();
            Rect tempRect = this.mTempRect;
            thumbDrawable.copyBounds(tempRect);
            tempRect.offset(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            tempRect.left += insets.left;
            tempRect.right -= insets.right;
            int saveCount = canvas.save();
            canvas.clipRect(tempRect, Region.Op.DIFFERENCE);
            super.drawTrack(canvas);
            this.drawTickMarks(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            super.drawTrack(canvas);
            this.drawTickMarks(canvas);
        }
    }

    protected void drawTickMarks(Canvas canvas) {
        int count;
        if (this.mTickMark != null && (count = this.getMax() - this.getMin()) > 1) {
            int w = this.mTickMark.getIntrinsicWidth();
            int h = this.mTickMark.getIntrinsicHeight();
            int halfW = w >= 0 ? w / 2 : 1;
            int halfH = h >= 0 ? h / 2 : 1;
            this.mTickMark.setBounds(-halfW, -halfH, halfW, halfH);
            float spacing = (float)(this.getWidth() - this.mPaddingLeft - this.mPaddingRight) / (float)count;
            int saveCount = canvas.save();
            canvas.translate(this.mPaddingLeft, this.getHeight() / 2);
            for (int i = 0; i <= count; ++i) {
                this.mTickMark.draw(canvas);
                canvas.translate(spacing, 0.0f);
            }
            canvas.restoreToCount(saveCount);
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void drawThumb(Canvas canvas) {
        if (this.mThumb != null) {
            int saveCount = canvas.save();
            canvas.translate(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            this.mThumb.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.getCurrentDrawable();
        int thumbHeight = this.mThumb == null ? 0 : this.mThumb.getIntrinsicHeight();
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
            dh = Math.max(thumbHeight, dh);
        }
        this.setMeasuredDimension(AbsSeekBar.resolveSizeAndState(dw += this.mPaddingLeft + this.mPaddingRight, widthMeasureSpec, 0), AbsSeekBar.resolveSizeAndState(dh += this.mPaddingTop + this.mPaddingBottom, heightMeasureSpec, 0));
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsUserSeekable || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.mThumb != null) {
                    int availableWidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                    this.mTouchThumbOffset = (float)(this.getProgress() - this.getMin()) / (float)(this.getMax() - this.getMin()) - (event.getX() - (float)this.mPaddingLeft) / (float)availableWidth;
                    if (Math.abs(this.mTouchThumbOffset * (float)availableWidth) > (float)this.getThumbOffset()) {
                        this.mTouchThumbOffset = 0.0f;
                    }
                }
                if (this.isInScrollingContainer()) {
                    this.mTouchDownX = event.getX();
                    break;
                }
                this.startDrag(event);
                break;
            }
            case 2: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    break;
                }
                float x = event.getX();
                if (!(Math.abs(x - this.mTouchDownX) > (float)this.mScaledTouchSlop)) break;
                this.startDrag(event);
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                }
                this.invalidate();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                }
                this.invalidate();
            }
        }
        return true;
    }

    private void startDrag(MotionEvent event) {
        this.setPressed(true);
        if (this.mThumb != null) {
            this.invalidate(this.mThumb.getBounds());
        }
        this.onStartTrackingTouch();
        this.trackTouchEvent(event);
        this.attemptClaimDrag();
    }

    private void setHotspot(float x, float y) {
        Drawable bg = this.getBackground();
        if (bg != null) {
            bg.setHotspot(x, y);
        }
    }

    @UnsupportedAppUsage
    private void trackTouchEvent(MotionEvent event) {
        float scale;
        int x = Math.round(event.getX());
        int y = Math.round(event.getY());
        int width = this.getWidth();
        int availableWidth = width - this.mPaddingLeft - this.mPaddingRight;
        float progress = 0.0f;
        if (this.isLayoutRtl() && this.mMirrorForRtl) {
            if (x > width - this.mPaddingRight) {
                scale = 0.0f;
            } else if (x < this.mPaddingLeft) {
                scale = 1.0f;
            } else {
                scale = (float)(availableWidth - x + this.mPaddingLeft) / (float)availableWidth + this.mTouchThumbOffset;
                progress = this.mTouchProgressOffset;
            }
        } else if (x < this.mPaddingLeft) {
            scale = 0.0f;
        } else if (x > width - this.mPaddingRight) {
            scale = 1.0f;
        } else {
            scale = (float)(x - this.mPaddingLeft) / (float)availableWidth + this.mTouchThumbOffset;
            progress = this.mTouchProgressOffset;
        }
        int range = this.getMax() - this.getMin();
        this.setHotspot(x, y);
        this.setProgressInternal(Math.round(progress += scale * (float)range + (float)this.getMin()), true, false);
    }

    private void attemptClaimDrag() {
        if (this.mParent != null) {
            this.mParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    void onStartTrackingTouch() {
        this.mIsDragging = true;
    }

    void onStopTrackingTouch() {
        this.mIsDragging = false;
    }

    void onKeyChange() {
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.isEnabled()) {
            int increment = this.mKeyProgressIncrement;
            switch (keyCode) {
                case 21: 
                case 69: {
                    increment = -increment;
                }
                case 22: 
                case 70: 
                case 81: {
                    int n = increment = this.isLayoutRtl() ? -increment : increment;
                    if (!this.setProgressInternal(this.getProgress() + increment, true, true)) break;
                    this.onKeyChange();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return AbsSeekBar.class.getName();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.isEnabled()) {
            int progress = this.getProgress();
            if (progress > this.getMin()) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
            }
            if (progress < this.getMax()) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            }
        }
    }

    @Override
    public boolean performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (action) {
            case 16908349: {
                if (!this.canUserSetProgress()) {
                    return false;
                }
                if (arguments == null || !arguments.containsKey("android.view.accessibility.action.ARGUMENT_PROGRESS_VALUE")) {
                    return false;
                }
                float value = arguments.getFloat("android.view.accessibility.action.ARGUMENT_PROGRESS_VALUE");
                return this.setProgressInternal((int)value, true, true);
            }
            case 4096: 
            case 8192: {
                if (!this.canUserSetProgress()) {
                    return false;
                }
                int range = this.getMax() - this.getMin();
                int increment = Math.max(1, Math.round((float)range / 20.0f));
                if (action == 8192) {
                    increment = -increment;
                }
                if (this.setProgressInternal(this.getProgress() + increment, true, true)) {
                    this.onKeyChange();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    boolean canUserSetProgress() {
        return !this.isIndeterminate() && this.isEnabled();
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        Drawable thumb = this.mThumb;
        if (thumb != null) {
            this.setThumbPos(this.getWidth(), thumb, this.getScale(), Integer.MIN_VALUE);
            this.invalidate();
        }
    }
}

