/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.window.DisplayAreaAppearedInfo;
import android.window.IDisplayAreaOrganizer;
import android.window.WindowContainerToken;

public interface IDisplayAreaOrganizerController
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IDisplayAreaOrganizerController";

    public ParceledListSlice<DisplayAreaAppearedInfo> registerOrganizer(IDisplayAreaOrganizer var1, int var2) throws RemoteException;

    public void unregisterOrganizer(IDisplayAreaOrganizer var1) throws RemoteException;

    public DisplayAreaAppearedInfo createTaskDisplayArea(IDisplayAreaOrganizer var1, int var2, int var3, String var4) throws RemoteException;

    public void deleteTaskDisplayArea(WindowContainerToken var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayAreaOrganizerController {
        static final int TRANSACTION_registerOrganizer = 1;
        static final int TRANSACTION_unregisterOrganizer = 2;
        static final int TRANSACTION_createTaskDisplayArea = 3;
        static final int TRANSACTION_deleteTaskDisplayArea = 4;

        public Stub() {
            this.attachInterface(this, IDisplayAreaOrganizerController.DESCRIPTOR);
        }

        public static IDisplayAreaOrganizerController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDisplayAreaOrganizerController.DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayAreaOrganizerController) {
                return (IDisplayAreaOrganizerController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerOrganizer";
                }
                case 2: {
                    return "unregisterOrganizer";
                }
                case 3: {
                    return "createTaskDisplayArea";
                }
                case 4: {
                    return "deleteTaskDisplayArea";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDisplayAreaOrganizerController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IDisplayAreaOrganizer _arg0 = IDisplayAreaOrganizer.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice<DisplayAreaAppearedInfo> _result = this.registerOrganizer(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    IDisplayAreaOrganizer _arg0 = IDisplayAreaOrganizer.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterOrganizer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IDisplayAreaOrganizer _arg0 = IDisplayAreaOrganizer.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    DisplayAreaAppearedInfo _result = this.createTaskDisplayArea(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    WindowContainerToken _arg0 = data.readTypedObject(WindowContainerToken.CREATOR);
                    data.enforceNoDataAvail();
                    this.deleteTaskDisplayArea(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IDisplayAreaOrganizerController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDisplayAreaOrganizerController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<DisplayAreaAppearedInfo> registerOrganizer(IDisplayAreaOrganizer organizer, int displayAreaFeature) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayAreaOrganizerController.DESCRIPTOR);
                    _data.writeStrongInterface(organizer);
                    _data.writeInt(displayAreaFeature);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterOrganizer(IDisplayAreaOrganizer organizer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayAreaOrganizerController.DESCRIPTOR);
                    _data.writeStrongInterface(organizer);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DisplayAreaAppearedInfo createTaskDisplayArea(IDisplayAreaOrganizer organizer, int displayId, int parentFeatureId, String name) throws RemoteException {
                DisplayAreaAppearedInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayAreaOrganizerController.DESCRIPTOR);
                    _data.writeStrongInterface(organizer);
                    _data.writeInt(displayId);
                    _data.writeInt(parentFeatureId);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DisplayAreaAppearedInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteTaskDisplayArea(WindowContainerToken taskDisplayArea) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayAreaOrganizerController.DESCRIPTOR);
                    _data.writeTypedObject(taskDisplayArea, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDisplayAreaOrganizerController {
        @Override
        public ParceledListSlice<DisplayAreaAppearedInfo> registerOrganizer(IDisplayAreaOrganizer organizer, int displayAreaFeature) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterOrganizer(IDisplayAreaOrganizer organizer) throws RemoteException {
        }

        @Override
        public DisplayAreaAppearedInfo createTaskDisplayArea(IDisplayAreaOrganizer organizer, int displayId, int parentFeatureId, String name) throws RemoteException {
            return null;
        }

        @Override
        public void deleteTaskDisplayArea(WindowContainerToken taskDisplayArea) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

