/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.StartingWindowInfo;
import android.window.StartingWindowRemovalInfo;

public interface ITaskOrganizer
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITaskOrganizer";

    public void addStartingWindow(StartingWindowInfo var1, IBinder var2) throws RemoteException;

    public void removeStartingWindow(StartingWindowRemovalInfo var1) throws RemoteException;

    public void copySplashScreenView(int var1) throws RemoteException;

    public void onAppSplashScreenViewRemoved(int var1) throws RemoteException;

    public void onTaskAppeared(ActivityManager.RunningTaskInfo var1, SurfaceControl var2) throws RemoteException;

    public void onTaskVanished(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onTaskInfoChanged(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onImeDrawnOnTask(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskOrganizer {
        static final int TRANSACTION_addStartingWindow = 1;
        static final int TRANSACTION_removeStartingWindow = 2;
        static final int TRANSACTION_copySplashScreenView = 3;
        static final int TRANSACTION_onAppSplashScreenViewRemoved = 4;
        static final int TRANSACTION_onTaskAppeared = 5;
        static final int TRANSACTION_onTaskVanished = 6;
        static final int TRANSACTION_onTaskInfoChanged = 7;
        static final int TRANSACTION_onBackPressedOnTaskRoot = 8;
        static final int TRANSACTION_onImeDrawnOnTask = 9;

        public Stub() {
            this.attachInterface(this, ITaskOrganizer.DESCRIPTOR);
        }

        public static ITaskOrganizer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITaskOrganizer.DESCRIPTOR);
            if (iin != null && iin instanceof ITaskOrganizer) {
                return (ITaskOrganizer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addStartingWindow";
                }
                case 2: {
                    return "removeStartingWindow";
                }
                case 3: {
                    return "copySplashScreenView";
                }
                case 4: {
                    return "onAppSplashScreenViewRemoved";
                }
                case 5: {
                    return "onTaskAppeared";
                }
                case 6: {
                    return "onTaskVanished";
                }
                case 7: {
                    return "onTaskInfoChanged";
                }
                case 8: {
                    return "onBackPressedOnTaskRoot";
                }
                case 9: {
                    return "onImeDrawnOnTask";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITaskOrganizer.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    StartingWindowInfo _arg0 = data.readTypedObject(StartingWindowInfo.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.addStartingWindow(_arg0, _arg1);
                    break;
                }
                case 2: {
                    StartingWindowRemovalInfo _arg0 = data.readTypedObject(StartingWindowRemovalInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeStartingWindow(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.copySplashScreenView(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAppSplashScreenViewRemoved(_arg0);
                    break;
                }
                case 5: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    SurfaceControl _arg1 = data.readTypedObject(SurfaceControl.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskAppeared(_arg0, _arg1);
                    break;
                }
                case 6: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskVanished(_arg0);
                    break;
                }
                case 7: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskInfoChanged(_arg0);
                    break;
                }
                case 8: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onBackPressedOnTaskRoot(_arg0);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onImeDrawnOnTask(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements ITaskOrganizer {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITaskOrganizer.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addStartingWindow(StartingWindowInfo info, IBinder appToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    _data.writeStrongBinder(appToken);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeStartingWindow(StartingWindowRemovalInfo removalInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(removalInfo, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void copySplashScreenView(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAppSplashScreenViewRemoved(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskAppeared(ActivityManager.RunningTaskInfo taskInfo, SurfaceControl leash) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    _data.writeTypedObject(leash, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskVanished(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskInfoChanged(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImeDrawnOnTask(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITaskOrganizer {
        @Override
        public void addStartingWindow(StartingWindowInfo info, IBinder appToken) throws RemoteException {
        }

        @Override
        public void removeStartingWindow(StartingWindowRemovalInfo removalInfo) throws RemoteException {
        }

        @Override
        public void copySplashScreenView(int taskId) throws RemoteException {
        }

        @Override
        public void onAppSplashScreenViewRemoved(int taskId) throws RemoteException {
        }

        @Override
        public void onTaskAppeared(ActivityManager.RunningTaskInfo taskInfo, SurfaceControl leash) throws RemoteException {
        }

        @Override
        public void onTaskVanished(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onTaskInfoChanged(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onImeDrawnOnTask(int taskId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

