/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.WindowManager;
import android.window.RemoteTransition;
import com.android.internal.util.AnnotationValidations;

public class TransitionRequestInfo
implements Parcelable {
    private final int mType;
    private ActivityManager.RunningTaskInfo mTriggerTask;
    private RemoteTransition mRemoteTransition;
    private DisplayChange mDisplayChange;
    public static final Parcelable.Creator<TransitionRequestInfo> CREATOR = new Parcelable.Creator<TransitionRequestInfo>(){

        public TransitionRequestInfo[] newArray(int size) {
            return new TransitionRequestInfo[size];
        }

        @Override
        public TransitionRequestInfo createFromParcel(Parcel in) {
            return new TransitionRequestInfo(in);
        }
    };

    public TransitionRequestInfo(int type, ActivityManager.RunningTaskInfo triggerTask, RemoteTransition remoteTransition) {
        this(type, triggerTask, remoteTransition, null);
    }

    public TransitionRequestInfo(int type, ActivityManager.RunningTaskInfo triggerTask, RemoteTransition remoteTransition, DisplayChange displayChange) {
        this.mType = type;
        AnnotationValidations.validate(WindowManager.TransitionType.class, null, this.mType);
        this.mTriggerTask = triggerTask;
        this.mRemoteTransition = remoteTransition;
        this.mDisplayChange = displayChange;
    }

    public int getType() {
        return this.mType;
    }

    public ActivityManager.RunningTaskInfo getTriggerTask() {
        return this.mTriggerTask;
    }

    public RemoteTransition getRemoteTransition() {
        return this.mRemoteTransition;
    }

    public DisplayChange getDisplayChange() {
        return this.mDisplayChange;
    }

    public TransitionRequestInfo setTriggerTask(ActivityManager.RunningTaskInfo value) {
        this.mTriggerTask = value;
        return this;
    }

    public TransitionRequestInfo setRemoteTransition(RemoteTransition value) {
        this.mRemoteTransition = value;
        return this;
    }

    public TransitionRequestInfo setDisplayChange(DisplayChange value) {
        this.mDisplayChange = value;
        return this;
    }

    public String toString() {
        return "TransitionRequestInfo { type = " + this.mType + ", triggerTask = " + this.mTriggerTask + ", remoteTransition = " + this.mRemoteTransition + ", displayChange = " + this.mDisplayChange + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mTriggerTask != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mRemoteTransition != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mDisplayChange != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mType);
        if (this.mTriggerTask != null) {
            dest.writeTypedObject(this.mTriggerTask, flags);
        }
        if (this.mRemoteTransition != null) {
            dest.writeTypedObject(this.mRemoteTransition, flags);
        }
        if (this.mDisplayChange != null) {
            dest.writeTypedObject(this.mDisplayChange, flags);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TransitionRequestInfo(Parcel in) {
        byte flg = in.readByte();
        int type = in.readInt();
        ActivityManager.RunningTaskInfo triggerTask = (flg & 2) == 0 ? null : in.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
        RemoteTransition remoteTransition = (flg & 4) == 0 ? null : in.readTypedObject(RemoteTransition.CREATOR);
        DisplayChange displayChange = (flg & 8) == 0 ? null : in.readTypedObject(DisplayChange.CREATOR);
        this.mType = type;
        AnnotationValidations.validate(WindowManager.TransitionType.class, null, this.mType);
        this.mTriggerTask = triggerTask;
        this.mRemoteTransition = remoteTransition;
        this.mDisplayChange = displayChange;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class DisplayChange
    implements Parcelable {
        private final int mDisplayId;
        private Rect mStartAbsBounds = null;
        private Rect mEndAbsBounds = null;
        private int mStartRotation = -1;
        private int mEndRotation = -1;
        private boolean mPhysicalDisplayChanged = false;
        public static final Parcelable.Creator<DisplayChange> CREATOR = new Parcelable.Creator<DisplayChange>(){

            public DisplayChange[] newArray(int size) {
                return new DisplayChange[size];
            }

            @Override
            public DisplayChange createFromParcel(Parcel in) {
                return new DisplayChange(in);
            }
        };

        public DisplayChange(int displayId) {
            this.mDisplayId = displayId;
        }

        public DisplayChange(int displayId, int startRotation, int endRotation) {
            this.mDisplayId = displayId;
            this.mStartRotation = startRotation;
            this.mEndRotation = endRotation;
        }

        public int getDisplayId() {
            return this.mDisplayId;
        }

        public Rect getStartAbsBounds() {
            return this.mStartAbsBounds;
        }

        public Rect getEndAbsBounds() {
            return this.mEndAbsBounds;
        }

        public int getStartRotation() {
            return this.mStartRotation;
        }

        public int getEndRotation() {
            return this.mEndRotation;
        }

        public boolean isPhysicalDisplayChanged() {
            return this.mPhysicalDisplayChanged;
        }

        public DisplayChange setStartAbsBounds(Rect value) {
            this.mStartAbsBounds = value;
            return this;
        }

        public DisplayChange setEndAbsBounds(Rect value) {
            this.mEndAbsBounds = value;
            return this;
        }

        public DisplayChange setStartRotation(int value) {
            this.mStartRotation = value;
            return this;
        }

        public DisplayChange setEndRotation(int value) {
            this.mEndRotation = value;
            return this;
        }

        public DisplayChange setPhysicalDisplayChanged(boolean value) {
            this.mPhysicalDisplayChanged = value;
            return this;
        }

        public String toString() {
            return "DisplayChange { displayId = " + this.mDisplayId + ", startAbsBounds = " + this.mStartAbsBounds + ", endAbsBounds = " + this.mEndAbsBounds + ", startRotation = " + this.mStartRotation + ", endRotation = " + this.mEndRotation + ", physicalDisplayChanged = " + this.mPhysicalDisplayChanged + " }";
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mPhysicalDisplayChanged) {
                flg = (byte)(flg | 0x20);
            }
            if (this.mStartAbsBounds != null) {
                flg = (byte)(flg | 2);
            }
            if (this.mEndAbsBounds != null) {
                flg = (byte)(flg | 4);
            }
            dest.writeByte(flg);
            dest.writeInt(this.mDisplayId);
            if (this.mStartAbsBounds != null) {
                dest.writeTypedObject(this.mStartAbsBounds, flags);
            }
            if (this.mEndAbsBounds != null) {
                dest.writeTypedObject(this.mEndAbsBounds, flags);
            }
            dest.writeInt(this.mStartRotation);
            dest.writeInt(this.mEndRotation);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        protected DisplayChange(Parcel in) {
            byte flg = in.readByte();
            boolean physicalDisplayChanged = (flg & 0x20) != 0;
            int displayId = in.readInt();
            Rect startAbsBounds = (flg & 2) == 0 ? null : in.readTypedObject(Rect.CREATOR);
            Rect endAbsBounds = (flg & 4) == 0 ? null : in.readTypedObject(Rect.CREATOR);
            int startRotation = in.readInt();
            int endRotation = in.readInt();
            this.mDisplayId = displayId;
            this.mStartAbsBounds = startAbsBounds;
            this.mEndAbsBounds = endAbsBounds;
            this.mStartRotation = startRotation;
            this.mEndRotation = endRotation;
            this.mPhysicalDisplayChanged = physicalDisplayChanged;
        }

        @Deprecated
        private void __metadata() {
        }
    }
}

