/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers;

import com.android.i18n.phonenumbers.CountryCodeToRegionCodeMap;
import com.android.i18n.phonenumbers.MetadataLoader;
import com.android.i18n.phonenumbers.MetadataManager;
import com.android.i18n.phonenumbers.MetadataSource;
import com.android.i18n.phonenumbers.Phonemetadata;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

class MultiFileMetadataSourceImpl
implements MetadataSource {
    private final String phoneNumberMetadataFilePrefix;
    private final MetadataLoader metadataLoader;
    private final ConcurrentHashMap<String, Phonemetadata.PhoneMetadata> geographicalRegions = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Phonemetadata.PhoneMetadata> nonGeographicalRegions = new ConcurrentHashMap();

    MultiFileMetadataSourceImpl(String phoneNumberMetadataFilePrefix, MetadataLoader metadataLoader) {
        this.phoneNumberMetadataFilePrefix = phoneNumberMetadataFilePrefix;
        this.metadataLoader = metadataLoader;
    }

    MultiFileMetadataSourceImpl(MetadataLoader metadataLoader) {
        this("/com/android/i18n/phonenumbers/data/PhoneNumberMetadataProto", metadataLoader);
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        return MetadataManager.getMetadataFromMultiFilePrefix(regionCode, this.geographicalRegions, this.phoneNumberMetadataFilePrefix, this.metadataLoader);
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        if (!this.isNonGeographical(countryCallingCode)) {
            return null;
        }
        return MetadataManager.getMetadataFromMultiFilePrefix(countryCallingCode, this.nonGeographicalRegions, this.phoneNumberMetadataFilePrefix, this.metadataLoader);
    }

    private boolean isNonGeographical(int countryCallingCode) {
        List<String> regionCodes = CountryCodeToRegionCodeMap.getCountryCodeToRegionCodeMap().get(countryCallingCode);
        return regionCodes.size() == 1 && "001".equals(regionCodes.get(0));
    }
}

