/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.ComponentName;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.SoundTrigger;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;

public interface ISoundTriggerSession
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.app.ISoundTriggerSession";

    public SoundTrigger.GenericSoundModel getSoundModel(ParcelUuid var1) throws RemoteException;

    public void updateSoundModel(SoundTrigger.GenericSoundModel var1) throws RemoteException;

    public void deleteSoundModel(ParcelUuid var1) throws RemoteException;

    public int startRecognition(ParcelUuid var1, IRecognitionStatusCallback var2, SoundTrigger.RecognitionConfig var3, boolean var4) throws RemoteException;

    public int stopRecognition(ParcelUuid var1, IRecognitionStatusCallback var2) throws RemoteException;

    public int loadGenericSoundModel(SoundTrigger.GenericSoundModel var1) throws RemoteException;

    public int loadKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel var1) throws RemoteException;

    public int startRecognitionForService(ParcelUuid var1, Bundle var2, ComponentName var3, SoundTrigger.RecognitionConfig var4) throws RemoteException;

    public int stopRecognitionForService(ParcelUuid var1) throws RemoteException;

    public int unloadSoundModel(ParcelUuid var1) throws RemoteException;

    public boolean isRecognitionActive(ParcelUuid var1) throws RemoteException;

    public int getModelState(ParcelUuid var1) throws RemoteException;

    public SoundTrigger.ModuleProperties getModuleProperties() throws RemoteException;

    public int setParameter(ParcelUuid var1, int var2, int var3) throws RemoteException;

    public int getParameter(ParcelUuid var1, int var2) throws RemoteException;

    public SoundTrigger.ModelParamRange queryParameter(ParcelUuid var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISoundTriggerSession {
        static final int TRANSACTION_getSoundModel = 1;
        static final int TRANSACTION_updateSoundModel = 2;
        static final int TRANSACTION_deleteSoundModel = 3;
        static final int TRANSACTION_startRecognition = 4;
        static final int TRANSACTION_stopRecognition = 5;
        static final int TRANSACTION_loadGenericSoundModel = 6;
        static final int TRANSACTION_loadKeyphraseSoundModel = 7;
        static final int TRANSACTION_startRecognitionForService = 8;
        static final int TRANSACTION_stopRecognitionForService = 9;
        static final int TRANSACTION_unloadSoundModel = 10;
        static final int TRANSACTION_isRecognitionActive = 11;
        static final int TRANSACTION_getModelState = 12;
        static final int TRANSACTION_getModuleProperties = 13;
        static final int TRANSACTION_setParameter = 14;
        static final int TRANSACTION_getParameter = 15;
        static final int TRANSACTION_queryParameter = 16;

        public Stub() {
            this.attachInterface(this, ISoundTriggerSession.DESCRIPTOR);
        }

        public static ISoundTriggerSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISoundTriggerSession.DESCRIPTOR);
            if (iin != null && iin instanceof ISoundTriggerSession) {
                return (ISoundTriggerSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSoundModel";
                }
                case 2: {
                    return "updateSoundModel";
                }
                case 3: {
                    return "deleteSoundModel";
                }
                case 4: {
                    return "startRecognition";
                }
                case 5: {
                    return "stopRecognition";
                }
                case 6: {
                    return "loadGenericSoundModel";
                }
                case 7: {
                    return "loadKeyphraseSoundModel";
                }
                case 8: {
                    return "startRecognitionForService";
                }
                case 9: {
                    return "stopRecognitionForService";
                }
                case 10: {
                    return "unloadSoundModel";
                }
                case 11: {
                    return "isRecognitionActive";
                }
                case 12: {
                    return "getModelState";
                }
                case 13: {
                    return "getModuleProperties";
                }
                case 14: {
                    return "setParameter";
                }
                case 15: {
                    return "getParameter";
                }
                case 16: {
                    return "queryParameter";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISoundTriggerSession.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    SoundTrigger.GenericSoundModel _result = this.getSoundModel(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    SoundTrigger.GenericSoundModel _arg0 = data.readTypedObject(SoundTrigger.GenericSoundModel.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateSoundModel(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    this.deleteSoundModel(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    IRecognitionStatusCallback _arg1 = IRecognitionStatusCallback.Stub.asInterface(data.readStrongBinder());
                    SoundTrigger.RecognitionConfig _arg2 = data.readTypedObject(SoundTrigger.RecognitionConfig.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.startRecognition(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 5: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    IRecognitionStatusCallback _arg1 = IRecognitionStatusCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.stopRecognition(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    SoundTrigger.GenericSoundModel _arg0 = data.readTypedObject(SoundTrigger.GenericSoundModel.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.loadGenericSoundModel(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    SoundTrigger.KeyphraseSoundModel _arg0 = data.readTypedObject(SoundTrigger.KeyphraseSoundModel.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.loadKeyphraseSoundModel(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    SoundTrigger.RecognitionConfig _arg3 = data.readTypedObject(SoundTrigger.RecognitionConfig.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.startRecognitionForService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 9: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.stopRecognitionForService(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 10: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.unloadSoundModel(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isRecognitionActive(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getModelState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 13: {
                    SoundTrigger.ModuleProperties _result = this.getModuleProperties();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setParameter(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 15: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getParameter(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 16: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    SoundTrigger.ModelParamRange _result = this.queryParameter(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 15;
        }

        private static class Proxy
        implements ISoundTriggerSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISoundTriggerSession.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoundTrigger.GenericSoundModel getSoundModel(ParcelUuid soundModelId) throws RemoteException {
                SoundTrigger.GenericSoundModel _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SoundTrigger.GenericSoundModel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateSoundModel(SoundTrigger.GenericSoundModel soundModel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModel, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteSoundModel(ParcelUuid soundModelId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startRecognition(ParcelUuid soundModelId, IRecognitionStatusCallback callback, SoundTrigger.RecognitionConfig config, boolean runInBatterySaver) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(config, 0);
                    _data.writeBoolean(runInBatterySaver);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int stopRecognition(ParcelUuid soundModelId, IRecognitionStatusCallback callback) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int loadGenericSoundModel(SoundTrigger.GenericSoundModel soundModel) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModel, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int loadKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel soundModel) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModel, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startRecognitionForService(ParcelUuid soundModelId, Bundle params, ComponentName callbackIntent, SoundTrigger.RecognitionConfig config) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    _data.writeTypedObject(params, 0);
                    _data.writeTypedObject(callbackIntent, 0);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int stopRecognitionForService(ParcelUuid soundModelId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int unloadSoundModel(ParcelUuid soundModelId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRecognitionActive(ParcelUuid parcelUuid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(parcelUuid, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getModelState(ParcelUuid soundModelId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoundTrigger.ModuleProperties getModuleProperties() throws RemoteException {
                SoundTrigger.ModuleProperties _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SoundTrigger.ModuleProperties.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setParameter(ParcelUuid soundModelId, int modelParam, int value) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    _data.writeInt(modelParam);
                    _data.writeInt(value);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getParameter(ParcelUuid soundModelId, int modelParam) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    _data.writeInt(modelParam);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoundTrigger.ModelParamRange queryParameter(ParcelUuid soundModelId, int modelParam) throws RemoteException {
                SoundTrigger.ModelParamRange _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISoundTriggerSession.DESCRIPTOR);
                    _data.writeTypedObject(soundModelId, 0);
                    _data.writeInt(modelParam);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SoundTrigger.ModelParamRange.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISoundTriggerSession {
        @Override
        public SoundTrigger.GenericSoundModel getSoundModel(ParcelUuid soundModelId) throws RemoteException {
            return null;
        }

        @Override
        public void updateSoundModel(SoundTrigger.GenericSoundModel soundModel) throws RemoteException {
        }

        @Override
        public void deleteSoundModel(ParcelUuid soundModelId) throws RemoteException {
        }

        @Override
        public int startRecognition(ParcelUuid soundModelId, IRecognitionStatusCallback callback, SoundTrigger.RecognitionConfig config, boolean runInBatterySaver) throws RemoteException {
            return 0;
        }

        @Override
        public int stopRecognition(ParcelUuid soundModelId, IRecognitionStatusCallback callback) throws RemoteException {
            return 0;
        }

        @Override
        public int loadGenericSoundModel(SoundTrigger.GenericSoundModel soundModel) throws RemoteException {
            return 0;
        }

        @Override
        public int loadKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel soundModel) throws RemoteException {
            return 0;
        }

        @Override
        public int startRecognitionForService(ParcelUuid soundModelId, Bundle params, ComponentName callbackIntent, SoundTrigger.RecognitionConfig config) throws RemoteException {
            return 0;
        }

        @Override
        public int stopRecognitionForService(ParcelUuid soundModelId) throws RemoteException {
            return 0;
        }

        @Override
        public int unloadSoundModel(ParcelUuid soundModelId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isRecognitionActive(ParcelUuid parcelUuid) throws RemoteException {
            return false;
        }

        @Override
        public int getModelState(ParcelUuid soundModelId) throws RemoteException {
            return 0;
        }

        @Override
        public SoundTrigger.ModuleProperties getModuleProperties() throws RemoteException {
            return null;
        }

        @Override
        public int setParameter(ParcelUuid soundModelId, int modelParam, int value) throws RemoteException {
            return 0;
        }

        @Override
        public int getParameter(ParcelUuid soundModelId, int modelParam) throws RemoteException {
            return 0;
        }

        @Override
        public SoundTrigger.ModelParamRange queryParameter(ParcelUuid soundModelId, int modelParam) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

