/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.usage.UsageStats;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.metrics.LogMaker;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.resolver.IResolverRankerResult;
import android.service.resolver.IResolverRankerService;
import android.service.resolver.ResolverTarget;
import android.util.Log;
import com.android.internal.app.AbstractResolverComparator;
import com.android.internal.app.ChooserActivityLogger;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverComparatorModel;
import com.android.internal.lang.System_Delegate;
import com.android.internal.logging.MetricsLogger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class ResolverRankerServiceResolverComparator
extends AbstractResolverComparator {
    private static final String TAG = "RRSResolverComparator";
    private static final boolean DEBUG = false;
    private static final long USAGE_STATS_PERIOD = 604800000L;
    private static final long RECENCY_TIME_PERIOD = 43200000L;
    private static final float RECENCY_MULTIPLIER = 2.0f;
    private static final int CONNECTION_COST_TIMEOUT_MILLIS = 200;
    private final Collator mCollator;
    private final Map<String, UsageStats> mStats;
    private final long mCurrentTime;
    private final long mSinceTime;
    private final LinkedHashMap<ComponentName, ResolverTarget> mTargetsDict = new LinkedHashMap();
    private final String mReferrerPackage;
    private final Object mLock = new Object();
    private ArrayList<ResolverTarget> mTargets;
    private String mAction;
    private ComponentName mResolvedRankerName;
    private ComponentName mRankerServiceName;
    private IResolverRankerService mRanker;
    private ResolverRankerServiceConnection mConnection;
    private Context mContext;
    private CountDownLatch mConnectSignal;
    private ResolverRankerServiceComparatorModel mComparatorModel;

    public ResolverRankerServiceResolverComparator(Context context, Intent intent, String referrerPackage, AbstractResolverComparator.AfterCompute afterCompute, ChooserActivityLogger chooserActivityLogger) {
        super(context, intent);
        this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        this.mReferrerPackage = referrerPackage;
        this.mContext = context;
        this.mCurrentTime = System_Delegate.currentTimeMillis();
        this.mSinceTime = this.mCurrentTime - 604800000L;
        this.mStats = this.mUsm.queryAndAggregateUsageStats(this.mSinceTime, this.mCurrentTime);
        this.mAction = intent.getAction();
        this.mRankerServiceName = new ComponentName(this.mContext, this.getClass());
        this.setCallBack(afterCompute);
        this.setChooserActivityLogger(chooserActivityLogger);
        this.mComparatorModel = this.buildUpdatedModel();
    }

    @Override
    public void handleResultMessage(Message msg) {
        if (msg.what != 0) {
            return;
        }
        if (msg.obj == null) {
            Log.e(TAG, "Receiving null prediction results.");
            return;
        }
        List receivedTargets = (List)msg.obj;
        if (receivedTargets != null && this.mTargets != null && receivedTargets.size() == this.mTargets.size()) {
            int size = this.mTargets.size();
            boolean isUpdated = false;
            for (int i = 0; i < size; ++i) {
                float predictedProb = ((ResolverTarget)receivedTargets.get(i)).getSelectProbability();
                if (predictedProb == this.mTargets.get(i).getSelectProbability()) continue;
                this.mTargets.get(i).setSelectProbability(predictedProb);
                isUpdated = true;
            }
            if (isUpdated) {
                this.mRankerServiceName = this.mResolvedRankerName;
                this.mComparatorModel = this.buildUpdatedModel();
            }
        } else {
            Log.e(TAG, "Sizes of sent and received ResolverTargets diff.");
        }
    }

    @Override
    public void doCompute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        long recentSinceTime = this.mCurrentTime - 43200000L;
        float mostRecencyScore = 1.0f;
        float mostTimeSpentScore = 1.0f;
        float mostLaunchScore = 1.0f;
        float mostChooserScore = 1.0f;
        for (ResolverActivity.ResolvedComponentInfo resolvedComponentInfo : targets) {
            ResolverTarget resolverTarget = new ResolverTarget();
            this.mTargetsDict.put(resolvedComponentInfo.name, resolverTarget);
            UsageStats pkStats = this.mStats.get(resolvedComponentInfo.name.getPackageName());
            if (pkStats == null) continue;
            if (!resolvedComponentInfo.name.getPackageName().equals(this.mReferrerPackage) && !ResolverRankerServiceResolverComparator.isPersistentProcess(resolvedComponentInfo)) {
                float recencyScore = Math.max(pkStats.getLastTimeUsed() - recentSinceTime, 0L);
                resolverTarget.setRecencyScore(recencyScore);
                if (recencyScore > mostRecencyScore) {
                    mostRecencyScore = recencyScore;
                }
            }
            float timeSpentScore = pkStats.getTotalTimeInForeground();
            resolverTarget.setTimeSpentScore(timeSpentScore);
            if (timeSpentScore > mostTimeSpentScore) {
                mostTimeSpentScore = timeSpentScore;
            }
            float launchScore = pkStats.mLaunchCount;
            resolverTarget.setLaunchScore(launchScore);
            if (launchScore > mostLaunchScore) {
                mostLaunchScore = launchScore;
            }
            float chooserScore = 0.0f;
            if (pkStats.mChooserCounts != null && this.mAction != null && pkStats.mChooserCounts.get(this.mAction) != null) {
                chooserScore = pkStats.mChooserCounts.get(this.mAction).getOrDefault(this.mContentType, 0).intValue();
                if (this.mAnnotations != null) {
                    int size = this.mAnnotations.length;
                    for (int i = 0; i < size; ++i) {
                        chooserScore += (float)pkStats.mChooserCounts.get(this.mAction).getOrDefault(this.mAnnotations[i], 0).intValue();
                    }
                }
            }
            resolverTarget.setChooserScore(chooserScore);
            if (!(chooserScore > mostChooserScore)) continue;
            mostChooserScore = chooserScore;
        }
        this.mTargets = new ArrayList<ResolverTarget>(this.mTargetsDict.values());
        for (ResolverTarget resolverTarget : this.mTargets) {
            float recency = resolverTarget.getRecencyScore() / mostRecencyScore;
            this.setFeatures(resolverTarget, recency * recency * 2.0f, resolverTarget.getLaunchScore() / mostLaunchScore, resolverTarget.getTimeSpentScore() / mostTimeSpentScore, resolverTarget.getChooserScore() / mostChooserScore);
            this.addDefaultSelectProbability(resolverTarget);
        }
        this.predictSelectProbabilities(this.mTargets);
        this.mComparatorModel = this.buildUpdatedModel();
    }

    @Override
    public int compare(ResolveInfo lhs, ResolveInfo rhs) {
        return this.mComparatorModel.getComparator().compare(lhs, rhs);
    }

    @Override
    public float getScore(ComponentName name) {
        return this.mComparatorModel.getScore(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateModel(ComponentName componentName) {
        Object object = this.mLock;
        synchronized (object) {
            this.mComparatorModel.notifyOnTargetSelected(componentName);
        }
    }

    @Override
    public void destroy() {
        this.mHandler.removeMessages(0);
        this.mHandler.removeMessages(1);
        if (this.mConnection != null) {
            this.mContext.unbindService(this.mConnection);
            this.mConnection.destroy();
        }
        this.afterCompute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRanker(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection != null && this.mRanker != null) {
                return;
            }
        }
        Intent intent = this.resolveRankerService();
        if (intent == null) {
            return;
        }
        this.mConnectSignal = new CountDownLatch(1);
        this.mConnection = new ResolverRankerServiceConnection(this.mConnectSignal);
        context.bindServiceAsUser(intent, this.mConnection, 1, UserHandle.SYSTEM);
    }

    private Intent resolveRankerService() {
        Intent intent = new Intent("android.service.resolver.ResolverRankerService");
        List<ResolveInfo> resolveInfos = this.mPm.queryIntentServices(intent, 0);
        for (ResolveInfo resolveInfo : resolveInfos) {
            ComponentName componentName;
            block5: {
                if (resolveInfo == null || resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.applicationInfo == null) continue;
                componentName = new ComponentName(resolveInfo.serviceInfo.applicationInfo.packageName, resolveInfo.serviceInfo.name);
                try {
                    String perm = this.mPm.getServiceInfo((ComponentName)componentName, (int)0).permission;
                    if (!"android.permission.BIND_RESOLVER_RANKER_SERVICE".equals(perm)) {
                        Log.w(TAG, "ResolverRankerService " + componentName + " does not require permission " + "android.permission.BIND_RESOLVER_RANKER_SERVICE" + " - this service will not be queried for ResolverRankerServiceResolverComparator. add android:permission=\"" + "android.permission.BIND_RESOLVER_RANKER_SERVICE" + "\" to the <service> tag for " + componentName + " in the manifest.");
                        continue;
                    }
                    if (0 != this.mPm.checkPermission("android.permission.PROVIDE_RESOLVER_RANKER_SERVICE", resolveInfo.serviceInfo.packageName)) {
                        Log.w(TAG, "ResolverRankerService " + componentName + " does not hold permission " + "android.permission.PROVIDE_RESOLVER_RANKER_SERVICE" + " - this service will not be queried for ResolverRankerServiceResolverComparator.");
                    }
                    break block5;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(TAG, "Could not look up service " + componentName + "; component name not found");
                }
                continue;
            }
            this.mResolvedRankerName = componentName;
            intent.setComponent(componentName);
            return intent;
        }
        return null;
    }

    @Override
    void beforeCompute() {
        super.beforeCompute();
        this.mTargetsDict.clear();
        this.mTargets = null;
        this.mRankerServiceName = new ComponentName(this.mContext, this.getClass());
        this.mComparatorModel = this.buildUpdatedModel();
        this.mResolvedRankerName = null;
        this.initRanker(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void predictSelectProbabilities(List<ResolverTarget> targets) {
        if (this.mConnection != null) {
            try {
                this.mConnectSignal.await(200L, TimeUnit.MILLISECONDS);
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mRanker != null) {
                        this.mRanker.predict(targets, this.mConnection.resolverRankerResult);
                        return;
                    }
                }
            }
            catch (InterruptedException e) {
                Log.e(TAG, "Error in Wait for Service Connection.");
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in Predict: " + e);
            }
        }
        this.afterCompute();
    }

    private void addDefaultSelectProbability(ResolverTarget target) {
        float sum = 2.5543f * target.getLaunchScore() + 2.8412f * target.getTimeSpentScore() + 0.269f * target.getRecencyScore() + 4.2222f * target.getChooserScore();
        target.setSelectProbability((float)(1.0 / (1.0 + Math.exp(1.6568f - sum))));
    }

    private void setFeatures(ResolverTarget target, float recencyScore, float launchScore, float timeSpentScore, float chooserScore) {
        target.setRecencyScore(recencyScore);
        target.setLaunchScore(launchScore);
        target.setTimeSpentScore(timeSpentScore);
        target.setChooserScore(chooserScore);
    }

    static boolean isPersistentProcess(ResolverActivity.ResolvedComponentInfo rci) {
        if (rci != null && rci.getCount() > 0) {
            return (rci.getResolveInfoAt((int)0).activityInfo.applicationInfo.flags & 8) != 0;
        }
        return false;
    }

    private ResolverRankerServiceComparatorModel buildUpdatedModel() {
        return new ResolverRankerServiceComparatorModel(this.mStats, this.mTargetsDict, this.mTargets, this.mCollator, this.mRanker, this.mRankerServiceName, this.mAnnotations != null, this.mPm);
    }

    static class ResolverRankerServiceComparatorModel
    implements ResolverComparatorModel {
        private final Map<String, UsageStats> mStats;
        private final Map<ComponentName, ResolverTarget> mTargetsDict;
        private final List<ResolverTarget> mTargets;
        private final Collator mCollator;
        private final IResolverRankerService mRanker;
        private final ComponentName mRankerServiceName;
        private final boolean mAnnotationsUsed;
        private final PackageManager mPm;

        ResolverRankerServiceComparatorModel(Map<String, UsageStats> stats, Map<ComponentName, ResolverTarget> targetsDict, List<ResolverTarget> targets, Collator collator, IResolverRankerService ranker, ComponentName rankerServiceName, boolean annotationsUsed, PackageManager pm) {
            this.mStats = stats;
            this.mTargetsDict = targetsDict;
            this.mTargets = targets;
            this.mCollator = collator;
            this.mRanker = ranker;
            this.mRankerServiceName = rankerServiceName;
            this.mAnnotationsUsed = annotationsUsed;
            this.mPm = pm;
        }

        @Override
        public Comparator<ResolveInfo> getComparator() {
            return (lhs, rhs) -> {
                CharSequence sb;
                CharSequence sa;
                if (this.mStats != null) {
                    int selectProbabilityDiff;
                    ResolverTarget lhsTarget = this.mTargetsDict.get(new ComponentName(lhs.activityInfo.packageName, lhs.activityInfo.name));
                    ResolverTarget rhsTarget = this.mTargetsDict.get(new ComponentName(rhs.activityInfo.packageName, rhs.activityInfo.name));
                    if (lhsTarget != null && rhsTarget != null && (selectProbabilityDiff = Float.compare(rhsTarget.getSelectProbability(), lhsTarget.getSelectProbability())) != 0) {
                        return selectProbabilityDiff > 0 ? 1 : -1;
                    }
                }
                if ((sa = lhs.loadLabel(this.mPm)) == null) {
                    sa = lhs.activityInfo.name;
                }
                if ((sb = rhs.loadLabel(this.mPm)) == null) {
                    sb = rhs.activityInfo.name;
                }
                return this.mCollator.compare(sa.toString().trim(), sb.toString().trim());
            };
        }

        @Override
        public float getScore(ComponentName name) {
            ResolverTarget target = this.mTargetsDict.get(name);
            if (target != null) {
                return target.getSelectProbability();
            }
            return 0.0f;
        }

        @Override
        public void notifyOnTargetSelected(ComponentName componentName) {
            if (this.mRanker != null) {
                try {
                    int selectedPos = new ArrayList<ComponentName>(this.mTargetsDict.keySet()).indexOf(componentName);
                    if (selectedPos >= 0 && this.mTargets != null) {
                        float selectedProbability = this.getScore(componentName);
                        int order = 0;
                        for (ResolverTarget target : this.mTargets) {
                            if (!(target.getSelectProbability() > selectedProbability)) continue;
                            ++order;
                        }
                        this.logMetrics(order);
                        this.mRanker.train(this.mTargets, selectedPos);
                    }
                }
                catch (RemoteException e) {
                    Log.e(ResolverRankerServiceResolverComparator.TAG, "Error in Train: " + e);
                }
            }
        }

        private void logMetrics(int selectedPos) {
            if (this.mRankerServiceName != null) {
                MetricsLogger metricsLogger = new MetricsLogger();
                LogMaker log = new LogMaker(1085);
                log.setComponentName(this.mRankerServiceName);
                log.addTaggedData(1086, this.mAnnotationsUsed ? 1 : 0);
                log.addTaggedData(1087, selectedPos);
                metricsLogger.write(log);
            }
        }
    }

    private class ResolverRankerServiceConnection
    implements ServiceConnection {
        private final CountDownLatch mConnectSignal;
        public final IResolverRankerResult resolverRankerResult = new IResolverRankerResult.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendResult(List<ResolverTarget> targets) throws RemoteException {
                Object object = ResolverRankerServiceResolverComparator.this.mLock;
                synchronized (object) {
                    Message msg = Message.obtain();
                    msg.what = 0;
                    msg.obj = targets;
                    ResolverRankerServiceResolverComparator.this.mHandler.sendMessage(msg);
                }
            }
        };

        public ResolverRankerServiceConnection(CountDownLatch connectSignal) {
            this.mConnectSignal = connectSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = ResolverRankerServiceResolverComparator.this.mLock;
            synchronized (object) {
                ResolverRankerServiceResolverComparator.this.mRanker = IResolverRankerService.Stub.asInterface(service);
                ResolverRankerServiceResolverComparator.this.mComparatorModel = ResolverRankerServiceResolverComparator.this.buildUpdatedModel();
                this.mConnectSignal.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = ResolverRankerServiceResolverComparator.this.mLock;
            synchronized (object) {
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = ResolverRankerServiceResolverComparator.this.mLock;
            synchronized (object) {
                ResolverRankerServiceResolverComparator.this.mRanker = null;
                ResolverRankerServiceResolverComparator.this.mComparatorModel = ResolverRankerServiceResolverComparator.this.buildUpdatedModel();
            }
        }
    }
}

