/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import android.graphics.Color;
import com.android.internal.graphics.palette.Palette;
import com.android.internal.graphics.palette.Quantizer;
import com.android.internal.graphics.palette.QuantizerMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WuQuantizer
implements Quantizer {
    private static final int BITS = 5;
    private static final int MAX_INDEX = 32;
    private static final int SIDE_LENGTH = 33;
    private static final int TOTAL_SIZE = 35937;
    private int[] mWeights;
    private int[] mMomentsR;
    private int[] mMomentsG;
    private int[] mMomentsB;
    private double[] mMoments;
    private Box[] mCubes;
    private Palette mPalette;
    private int[] mColors;
    private Map<Integer, Integer> mInputPixelToCount;

    @Override
    public List<Palette.Swatch> getQuantizedColors() {
        return this.mPalette.getSwatches();
    }

    @Override
    public void quantize(int[] pixels, int colorCount) {
        assert (pixels.length > 0);
        QuantizerMap quantizerMap = new QuantizerMap();
        quantizerMap.quantize(pixels, colorCount);
        this.mInputPixelToCount = quantizerMap.getColorToCount();
        Set<Integer> uniqueColors = this.mInputPixelToCount.keySet();
        if (uniqueColors.size() <= colorCount) {
            this.mColors = new int[this.mInputPixelToCount.keySet().size()];
            int index = 0;
            Iterator<Integer> iterator = uniqueColors.iterator();
            while (iterator.hasNext()) {
                int color2 = iterator.next();
                this.mColors[index++] = color2;
            }
        } else {
            this.constructHistogram(this.mInputPixelToCount);
            this.createMoments();
            CreateBoxesResult createBoxesResult = this.createBoxes(colorCount);
            this.mColors = this.createResult(createBoxesResult.mResultCount);
        }
        ArrayList<Palette.Swatch> swatches = new ArrayList<Palette.Swatch>();
        for (Object color3 : (Iterator<Integer>)this.mColors) {
            swatches.add(new Palette.Swatch((int)color3, 0));
        }
        this.mPalette = Palette.from(swatches);
    }

    public int[] getColors() {
        return this.mColors;
    }

    public Map<Integer, Integer> inputPixelToCount() {
        return this.mInputPixelToCount;
    }

    private static int getIndex(int r, int g, int b) {
        return (r << 10) + (r << 6) + (g << 5) + r + g + b;
    }

    private void constructHistogram(Map<Integer, Integer> pixels) {
        this.mWeights = new int[35937];
        this.mMomentsR = new int[35937];
        this.mMomentsG = new int[35937];
        this.mMomentsB = new int[35937];
        this.mMoments = new double[35937];
        for (Map.Entry<Integer, Integer> pair : pixels.entrySet()) {
            int index;
            int pixel = pair.getKey();
            int count = pair.getValue();
            int red = Color.red(pixel);
            int green = Color.green(pixel);
            int blue = Color.blue(pixel);
            int bitsToRemove = 3;
            int iR = (red >> bitsToRemove) + 1;
            int iG = (green >> bitsToRemove) + 1;
            int iB = (blue >> bitsToRemove) + 1;
            int n = index = WuQuantizer.getIndex(iR, iG, iB);
            this.mWeights[n] = this.mWeights[n] + count;
            int n2 = index;
            this.mMomentsR[n2] = this.mMomentsR[n2] + red * count;
            int n3 = index;
            this.mMomentsG[n3] = this.mMomentsG[n3] + green * count;
            int n4 = index;
            this.mMomentsB[n4] = this.mMomentsB[n4] + blue * count;
            int n5 = index;
            this.mMoments[n5] = this.mMoments[n5] + (double)(count * (red * red + green * green + blue * blue));
        }
    }

    private void createMoments() {
        for (int r = 1; r < 33; ++r) {
            int[] area = new int[33];
            int[] areaR = new int[33];
            int[] areaG = new int[33];
            int[] areaB = new int[33];
            double[] area2 = new double[33];
            for (int g = 1; g < 33; ++g) {
                int line = 0;
                int lineR = 0;
                int lineG = 0;
                int lineB = 0;
                double line2 = 0.0;
                for (int b = 1; b < 33; ++b) {
                    int index = WuQuantizer.getIndex(r, g, b);
                    line += this.mWeights[index];
                    lineR += this.mMomentsR[index];
                    lineG += this.mMomentsG[index];
                    lineB += this.mMomentsB[index];
                    line2 += this.mMoments[index];
                    int n = b;
                    area[n] = area[n] + line;
                    int n2 = b;
                    areaR[n2] = areaR[n2] + lineR;
                    int n3 = b;
                    areaG[n3] = areaG[n3] + lineG;
                    int n4 = b;
                    areaB[n4] = areaB[n4] + lineB;
                    int n5 = b;
                    area2[n5] = area2[n5] + line2;
                    int previousIndex = WuQuantizer.getIndex(r - 1, g, b);
                    this.mWeights[index] = this.mWeights[previousIndex] + area[b];
                    this.mMomentsR[index] = this.mMomentsR[previousIndex] + areaR[b];
                    this.mMomentsG[index] = this.mMomentsG[previousIndex] + areaG[b];
                    this.mMomentsB[index] = this.mMomentsB[previousIndex] + areaB[b];
                    this.mMoments[index] = this.mMoments[previousIndex] + area2[b];
                }
            }
        }
    }

    private CreateBoxesResult createBoxes(int maxColorCount) {
        this.mCubes = new Box[maxColorCount];
        for (int i = 0; i < maxColorCount; ++i) {
            this.mCubes[i] = new Box();
        }
        double[] volumeVariance = new double[maxColorCount];
        Box firstBox = this.mCubes[0];
        firstBox.r1 = 32;
        firstBox.g1 = 32;
        firstBox.b1 = 32;
        int generatedColorCount = 0;
        int next = 0;
        for (int i = 1; i < maxColorCount; ++i) {
            if (this.cut(this.mCubes[next], this.mCubes[i])) {
                volumeVariance[next] = this.mCubes[next].vol > 1 ? this.variance(this.mCubes[next]) : 0.0;
                volumeVariance[i] = this.mCubes[i].vol > 1 ? this.variance(this.mCubes[i]) : 0.0;
            } else {
                volumeVariance[next] = 0.0;
                --i;
            }
            next = 0;
            double temp = volumeVariance[0];
            for (int k = 1; k <= i; ++k) {
                if (!(volumeVariance[k] > temp)) continue;
                temp = volumeVariance[k];
                next = k;
            }
            generatedColorCount = i + 1;
            if (temp <= 0.0) break;
        }
        return new CreateBoxesResult(maxColorCount, generatedColorCount);
    }

    private int[] createResult(int colorCount) {
        int[] colors = new int[colorCount];
        int nextAvailableIndex = 0;
        for (int i = 0; i < colorCount; ++i) {
            Box cube = this.mCubes[i];
            int weight = WuQuantizer.volume(cube, this.mWeights);
            if (weight <= 0) continue;
            int r = WuQuantizer.volume(cube, this.mMomentsR) / weight;
            int g = WuQuantizer.volume(cube, this.mMomentsG) / weight;
            int b = WuQuantizer.volume(cube, this.mMomentsB) / weight;
            int color2 = Color.rgb(r, g, b);
            colors[nextAvailableIndex++] = color2;
        }
        int[] resultArray = new int[nextAvailableIndex];
        System.arraycopy(colors, 0, resultArray, 0, nextAvailableIndex);
        return resultArray;
    }

    private double variance(Box cube) {
        int dr = WuQuantizer.volume(cube, this.mMomentsR);
        int dg = WuQuantizer.volume(cube, this.mMomentsG);
        int db = WuQuantizer.volume(cube, this.mMomentsB);
        double xx = this.mMoments[WuQuantizer.getIndex(cube.r1, cube.g1, cube.b1)] - this.mMoments[WuQuantizer.getIndex(cube.r1, cube.g1, cube.b0)] - this.mMoments[WuQuantizer.getIndex(cube.r1, cube.g0, cube.b1)] + this.mMoments[WuQuantizer.getIndex(cube.r1, cube.g0, cube.b0)] - this.mMoments[WuQuantizer.getIndex(cube.r0, cube.g1, cube.b1)] + this.mMoments[WuQuantizer.getIndex(cube.r0, cube.g1, cube.b0)] + this.mMoments[WuQuantizer.getIndex(cube.r0, cube.g0, cube.b1)] - this.mMoments[WuQuantizer.getIndex(cube.r0, cube.g0, cube.b0)];
        int hypotenuse = dr * dr + dg * dg + db * db;
        int volume2 = WuQuantizer.volume(cube, this.mWeights);
        double variance2 = xx - (double)hypotenuse / (double)volume2;
        return variance2;
    }

    private boolean cut(Box one, Box two) {
        Direction cutDirection;
        int wholeR = WuQuantizer.volume(one, this.mMomentsR);
        int wholeG = WuQuantizer.volume(one, this.mMomentsG);
        int wholeB = WuQuantizer.volume(one, this.mMomentsB);
        int wholeW = WuQuantizer.volume(one, this.mWeights);
        MaximizeResult maxRResult = this.maximize(one, Direction.RED, one.r0 + 1, one.r1, wholeR, wholeG, wholeB, wholeW);
        MaximizeResult maxGResult = this.maximize(one, Direction.GREEN, one.g0 + 1, one.g1, wholeR, wholeG, wholeB, wholeW);
        MaximizeResult maxBResult = this.maximize(one, Direction.BLUE, one.b0 + 1, one.b1, wholeR, wholeG, wholeB, wholeW);
        double maxR = maxRResult.mMaximum;
        double maxG = maxGResult.mMaximum;
        double maxB = maxBResult.mMaximum;
        if (maxR >= maxG && maxR >= maxB) {
            if (maxRResult.mCutLocation < 0) {
                return false;
            }
            cutDirection = Direction.RED;
        } else {
            cutDirection = maxG >= maxR && maxG >= maxB ? Direction.GREEN : Direction.BLUE;
        }
        two.r1 = one.r1;
        two.g1 = one.g1;
        two.b1 = one.b1;
        switch (cutDirection) {
            case RED: {
                two.r0 = one.r1 = maxRResult.mCutLocation;
                two.g0 = one.g0;
                two.b0 = one.b0;
                break;
            }
            case GREEN: {
                one.g1 = maxGResult.mCutLocation;
                two.r0 = one.r0;
                two.g0 = one.g1;
                two.b0 = one.b0;
                break;
            }
            case BLUE: {
                one.b1 = maxBResult.mCutLocation;
                two.r0 = one.r0;
                two.g0 = one.g0;
                two.b0 = one.b1;
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected direction " + (Object)((Object)cutDirection));
            }
        }
        one.vol = (one.r1 - one.r0) * (one.g1 - one.g0) * (one.b1 - one.b0);
        two.vol = (two.r1 - two.r0) * (two.g1 - two.g0) * (two.b1 - two.b0);
        return true;
    }

    private MaximizeResult maximize(Box cube, Direction direction, int first, int last, int wholeR, int wholeG, int wholeB, int wholeW) {
        int baseR = WuQuantizer.bottom(cube, direction, this.mMomentsR);
        int baseG = WuQuantizer.bottom(cube, direction, this.mMomentsG);
        int baseB = WuQuantizer.bottom(cube, direction, this.mMomentsB);
        int baseW = WuQuantizer.bottom(cube, direction, this.mWeights);
        double max = 0.0;
        int cut = -1;
        for (int i = first; i < last; ++i) {
            int halfR = baseR + WuQuantizer.top(cube, direction, i, this.mMomentsR);
            int halfG = baseG + WuQuantizer.top(cube, direction, i, this.mMomentsG);
            int halfB = baseB + WuQuantizer.top(cube, direction, i, this.mMomentsB);
            int halfW = baseW + WuQuantizer.top(cube, direction, i, this.mWeights);
            if (halfW == 0) continue;
            double tempNumerator = halfR * halfR + halfG * halfG + halfB * halfB;
            double tempDenominator = halfW;
            double temp = tempNumerator / tempDenominator;
            halfR = wholeR - halfR;
            halfG = wholeG - halfG;
            halfB = wholeB - halfB;
            if ((halfW = wholeW - halfW) == 0 || !((temp += (tempNumerator = (double)(halfR * halfR + halfG * halfG + halfB * halfB)) / (tempDenominator = (double)halfW)) > max)) continue;
            max = temp;
            cut = i;
        }
        return new MaximizeResult(cut, max);
    }

    private static int volume(Box cube, int[] moment) {
        return moment[WuQuantizer.getIndex(cube.r1, cube.g1, cube.b1)] - moment[WuQuantizer.getIndex(cube.r1, cube.g1, cube.b0)] - moment[WuQuantizer.getIndex(cube.r1, cube.g0, cube.b1)] + moment[WuQuantizer.getIndex(cube.r1, cube.g0, cube.b0)] - moment[WuQuantizer.getIndex(cube.r0, cube.g1, cube.b1)] + moment[WuQuantizer.getIndex(cube.r0, cube.g1, cube.b0)] + moment[WuQuantizer.getIndex(cube.r0, cube.g0, cube.b1)] - moment[WuQuantizer.getIndex(cube.r0, cube.g0, cube.b0)];
    }

    private static int bottom(Box cube, Direction direction, int[] moment) {
        switch (direction) {
            case RED: {
                return -moment[WuQuantizer.getIndex(cube.r0, cube.g1, cube.b1)] + moment[WuQuantizer.getIndex(cube.r0, cube.g1, cube.b0)] + moment[WuQuantizer.getIndex(cube.r0, cube.g0, cube.b1)] - moment[WuQuantizer.getIndex(cube.r0, cube.g0, cube.b0)];
            }
            case GREEN: {
                return -moment[WuQuantizer.getIndex(cube.r1, cube.g0, cube.b1)] + moment[WuQuantizer.getIndex(cube.r1, cube.g0, cube.b0)] + moment[WuQuantizer.getIndex(cube.r0, cube.g0, cube.b1)] - moment[WuQuantizer.getIndex(cube.r0, cube.g0, cube.b0)];
            }
            case BLUE: {
                return -moment[WuQuantizer.getIndex(cube.r1, cube.g1, cube.b0)] + moment[WuQuantizer.getIndex(cube.r1, cube.g0, cube.b0)] + moment[WuQuantizer.getIndex(cube.r0, cube.g1, cube.b0)] - moment[WuQuantizer.getIndex(cube.r0, cube.g0, cube.b0)];
            }
        }
        throw new IllegalArgumentException("unexpected direction " + (Object)((Object)direction));
    }

    private static int top(Box cube, Direction direction, int position, int[] moment) {
        switch (direction) {
            case RED: {
                return moment[WuQuantizer.getIndex(position, cube.g1, cube.b1)] - moment[WuQuantizer.getIndex(position, cube.g1, cube.b0)] - moment[WuQuantizer.getIndex(position, cube.g0, cube.b1)] + moment[WuQuantizer.getIndex(position, cube.g0, cube.b0)];
            }
            case GREEN: {
                return moment[WuQuantizer.getIndex(cube.r1, position, cube.b1)] - moment[WuQuantizer.getIndex(cube.r1, position, cube.b0)] - moment[WuQuantizer.getIndex(cube.r0, position, cube.b1)] + moment[WuQuantizer.getIndex(cube.r0, position, cube.b0)];
            }
            case BLUE: {
                return moment[WuQuantizer.getIndex(cube.r1, cube.g1, position)] - moment[WuQuantizer.getIndex(cube.r1, cube.g0, position)] - moment[WuQuantizer.getIndex(cube.r0, cube.g1, position)] + moment[WuQuantizer.getIndex(cube.r0, cube.g0, position)];
            }
        }
        throw new IllegalArgumentException("unexpected direction " + (Object)((Object)direction));
    }

    private static class Box {
        public int r0 = 0;
        public int r1 = 0;
        public int g0 = 0;
        public int g1 = 0;
        public int b0 = 0;
        public int b1 = 0;
        public int vol = 0;

        private Box() {
        }
    }

    private static class CreateBoxesResult {
        final int mRequestedCount;
        final int mResultCount;

        CreateBoxesResult(int requestedCount, int resultCount) {
            this.mRequestedCount = requestedCount;
            this.mResultCount = resultCount;
        }
    }

    private static class MaximizeResult {
        final int mCutLocation;
        final double mMaximum;

        MaximizeResult(int cut, double max) {
            this.mCutLocation = cut;
            this.mMaximum = max;
        }
    }

    private static enum Direction {
        RED,
        GREEN,
        BLUE;

    }
}

