/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class CancellationGroup {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ArrayList<CompletableFuture<?>> mFutureList = null;
    @GuardedBy(value={"mLock"})
    private boolean mCanceled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryRegisterFutureOrCancelImmediately(CompletableFuture<?> future) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCanceled) {
                future.cancel(false);
                return false;
            }
            if (this.mFutureList == null) {
                this.mFutureList = new ArrayList(1);
            }
            this.mFutureList.add(future);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterFuture(CompletableFuture<?> future) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFutureList != null) {
                this.mFutureList.remove(future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCanceled) {
                this.mCanceled = true;
                if (this.mFutureList != null) {
                    this.mFutureList.forEach((Consumer<CompletableFuture<?>>)((Consumer<CompletableFuture>)future -> future.cancel(false)));
                    this.mFutureList.clear();
                    this.mFutureList = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCanceled;
        }
    }
}

