/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.jank;

import android.graphics.HardwareRendererObserver;
import android.os.Handler;
import android.os.Trace;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.Choreographer;
import android.view.FrameMetrics;
import android.view.SurfaceControl;
import android.view.ThreadedRenderer;
import android.view.ViewRootImpl;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.jank.InteractionJankMonitor;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.TimeUnit;

public class FrameTracker
extends SurfaceControl.OnJankDataListener
implements HardwareRendererObserver.OnFrameMetricsAvailableListener {
    private static final String TAG = "FrameTracker";
    private static final boolean DEBUG = false;
    private static final long INVALID_ID = -1L;
    public static final int NANOS_IN_MILLISECOND = 1000000;
    static final int REASON_END_UNKNOWN = -1;
    static final int REASON_END_NORMAL = 0;
    static final int REASON_END_SURFACE_DESTROYED = 1;
    static final int REASON_CANCEL_NORMAL = 16;
    static final int REASON_CANCEL_NOT_BEGUN = 17;
    static final int REASON_CANCEL_SAME_VSYNC = 18;
    static final int REASON_CANCEL_TIMEOUT = 19;
    private final HardwareRendererObserver mObserver;
    private SurfaceControl mSurfaceControl;
    private final int mTraceThresholdMissedFrames;
    private final int mTraceThresholdFrameTimeMillis;
    private final ThreadedRendererWrapper mRendererWrapper;
    private final FrameMetricsWrapper mMetricsWrapper;
    private final SparseArray<JankInfo> mJankInfos = new SparseArray();
    private final InteractionJankMonitor.Session mSession;
    private final ViewRootWrapper mViewRoot;
    private final SurfaceControlWrapper mSurfaceControlWrapper;
    private final ViewRootImpl.SurfaceChangedCallback mSurfaceChangedCallback;
    private final Handler mHandler;
    private final ChoreographerWrapper mChoreographer;
    private final StatsLogWrapper mStatsLog;
    private final Object mLock = InteractionJankMonitor.getInstance().getLock();
    private final boolean mDeferMonitoring;
    @VisibleForTesting
    public final boolean mSurfaceOnly;
    private long mBeginVsyncId = -1L;
    private long mEndVsyncId = -1L;
    private boolean mMetricsFinalized;
    private boolean mCancelled = false;
    private FrameTrackerListener mListener;
    private boolean mTracingStarted = false;
    private Runnable mWaitForFinishTimedOut;

    public FrameTracker(InteractionJankMonitor.Session session, Handler handler, ThreadedRendererWrapper renderer, ViewRootWrapper viewRootWrapper, SurfaceControlWrapper surfaceControlWrapper, ChoreographerWrapper choreographer, FrameMetricsWrapper metrics, StatsLogWrapper statsLog, int traceThresholdMissedFrames, int traceThresholdFrameTimeMillis, FrameTrackerListener listener, InteractionJankMonitor.Configuration config) {
        this.mSurfaceOnly = config.isSurfaceOnly();
        this.mSession = session;
        this.mHandler = handler;
        this.mChoreographer = choreographer;
        this.mSurfaceControlWrapper = surfaceControlWrapper;
        this.mStatsLog = statsLog;
        this.mDeferMonitoring = config.shouldDeferMonitor();
        this.mRendererWrapper = this.mSurfaceOnly ? null : renderer;
        this.mMetricsWrapper = this.mSurfaceOnly ? null : metrics;
        this.mViewRoot = this.mSurfaceOnly ? null : viewRootWrapper;
        this.mObserver = this.mSurfaceOnly ? null : new HardwareRendererObserver(this, this.mMetricsWrapper.getTiming(), handler, false);
        this.mTraceThresholdMissedFrames = traceThresholdMissedFrames;
        this.mTraceThresholdFrameTimeMillis = traceThresholdFrameTimeMillis;
        this.mListener = listener;
        if (this.mSurfaceOnly) {
            this.mSurfaceControl = config.getSurfaceControl();
            this.mSurfaceChangedCallback = null;
        } else {
            if (this.mViewRoot.getSurfaceControl().isValid()) {
                this.mSurfaceControl = this.mViewRoot.getSurfaceControl();
            }
            this.mSurfaceChangedCallback = new ViewRootImpl.SurfaceChangedCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void surfaceCreated(SurfaceControl.Transaction t) {
                    Object object = FrameTracker.this.mLock;
                    synchronized (object) {
                        if (FrameTracker.this.mSurfaceControl == null) {
                            FrameTracker.this.mSurfaceControl = FrameTracker.this.mViewRoot.getSurfaceControl();
                            if (FrameTracker.this.mBeginVsyncId != -1L) {
                                FrameTracker.this.mSurfaceControlWrapper.addJankStatsListener(FrameTracker.this, FrameTracker.this.mSurfaceControl);
                                FrameTracker.this.markEvent("FT#deferMonitoring");
                                FrameTracker.this.postTraceStartMarker();
                            }
                        }
                    }
                }

                @Override
                public void surfaceReplaced(SurfaceControl.Transaction t) {
                }

                @Override
                public void surfaceDestroyed() {
                    FrameTracker.this.mHandler.postDelayed(() -> {
                        Object object = FrameTracker.this.mLock;
                        synchronized (object) {
                            if (!FrameTracker.this.mMetricsFinalized) {
                                FrameTracker.this.end(1);
                                FrameTracker.this.finish();
                            }
                        }
                    }, 50L);
                }
            };
            this.mViewRoot.addSurfaceChangedCallback(this.mSurfaceChangedCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        Object object = this.mLock;
        synchronized (object) {
            long currentVsync = this.mChoreographer.getVsyncId();
            long l = this.mBeginVsyncId = this.mDeferMonitoring ? currentVsync + 1L : currentVsync;
            if (this.mSurfaceControl != null) {
                if (this.mDeferMonitoring) {
                    this.markEvent("FT#deferMonitoring");
                    this.postTraceStartMarker();
                } else {
                    this.beginInternal();
                }
                this.mSurfaceControlWrapper.addJankStatsListener(this, this.mSurfaceControl);
            }
            if (!this.mSurfaceOnly) {
                this.mRendererWrapper.addObserver(this.mObserver);
            }
        }
    }

    @VisibleForTesting
    public void postTraceStartMarker() {
        this.mChoreographer.mChoreographer.postCallback(0, this::beginInternal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginInternal() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCancelled || this.mEndVsyncId != -1L) {
                return;
            }
            this.mTracingStarted = true;
            this.markEvent("FT#begin");
            Trace.beginAsyncSection(this.mSession.getName(), (int)this.mBeginVsyncId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean end(int reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCancelled || this.mEndVsyncId != -1L) {
                return false;
            }
            this.mEndVsyncId = this.mChoreographer.getVsyncId();
            if (this.mBeginVsyncId == -1L) {
                return this.cancel(17);
            }
            if (this.mEndVsyncId <= this.mBeginVsyncId) {
                return this.cancel(18);
            }
            this.markEvent("FT#end#" + reason);
            Trace.endAsyncSection(this.mSession.getName(), (int)this.mBeginVsyncId);
            this.mSession.setReason(reason);
            this.mWaitForFinishTimedOut = () -> {
                Log.e(TAG, "force finish cuj because of time out:" + this.mSession.getName());
                this.finish();
            };
            this.mHandler.postDelayed(this.mWaitForFinishTimedOut, TimeUnit.SECONDS.toMillis(10L));
            this.notifyCujEvent(InteractionJankMonitor.ACTION_SESSION_END);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(int reason) {
        Object object = this.mLock;
        synchronized (object) {
            boolean cancelFromEnd;
            boolean bl = cancelFromEnd = reason == 17 || reason == 18;
            if (this.mCancelled || this.mEndVsyncId != -1L && !cancelFromEnd) {
                return false;
            }
            this.mCancelled = true;
            this.markEvent("FT#cancel#" + reason);
            if (this.mTracingStarted) {
                Trace.endAsyncSection(this.mSession.getName(), (int)this.mBeginVsyncId);
            }
            this.removeObservers();
            this.mSession.setReason(reason);
            this.notifyCujEvent(InteractionJankMonitor.ACTION_SESSION_CANCEL);
            return true;
        }
    }

    private void markEvent(String desc) {
        Trace.beginSection(TextUtils.formatSimple("%s#%s", this.mSession.getName(), desc));
        Trace.endSection();
    }

    private void notifyCujEvent(String action) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onCujEvents(this.mSession, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onJankDataAvailable(SurfaceControl.JankData[] jankData) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCancelled) {
                return;
            }
            for (SurfaceControl.JankData jankStat : jankData) {
                if (!this.isInRange(jankStat.frameVsyncId)) continue;
                JankInfo info = this.findJankInfo(jankStat.frameVsyncId);
                if (info != null) {
                    info.surfaceControlCallbackFired = true;
                    info.jankType = jankStat.jankType;
                    continue;
                }
                this.mJankInfos.put((int)jankStat.frameVsyncId, JankInfo.createFromSurfaceControlCallback(jankStat.frameVsyncId, jankStat.jankType));
            }
            this.processJankInfos();
        }
    }

    private JankInfo findJankInfo(long frameVsyncId) {
        return this.mJankInfos.get((int)frameVsyncId);
    }

    private boolean isInRange(long vsyncId) {
        return vsyncId >= this.mBeginVsyncId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrameMetricsAvailable(int dropCountSinceLastInvocation) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCancelled) {
                return;
            }
            long totalDurationNanos = this.mMetricsWrapper.getMetric(8);
            boolean isFirstFrame = this.mMetricsWrapper.getMetric(9) == 1L;
            long frameVsyncId = this.mMetricsWrapper.getTiming()[1];
            if (!this.isInRange(frameVsyncId)) {
                return;
            }
            JankInfo info = this.findJankInfo(frameVsyncId);
            if (info != null) {
                info.hwuiCallbackFired = true;
                info.totalDurationNanos = totalDurationNanos;
                info.isFirstFrame = isFirstFrame;
            } else {
                this.mJankInfos.put((int)frameVsyncId, JankInfo.createFromHwuiCallback(frameVsyncId, totalDurationNanos, isFirstFrame));
            }
            this.processJankInfos();
        }
    }

    private boolean hasReceivedCallbacksAfterEnd() {
        JankInfo last;
        if (this.mEndVsyncId == -1L) {
            return false;
        }
        JankInfo jankInfo = last = this.mJankInfos.size() == 0 ? null : this.mJankInfos.valueAt(this.mJankInfos.size() - 1);
        if (last == null) {
            return false;
        }
        if (last.frameVsyncId < this.mEndVsyncId) {
            return false;
        }
        for (int i = this.mJankInfos.size() - 1; i >= 0; --i) {
            JankInfo info = this.mJankInfos.valueAt(i);
            if (info.frameVsyncId < this.mEndVsyncId || !this.callbacksReceived(info)) continue;
            return true;
        }
        return false;
    }

    private void processJankInfos() {
        if (this.mMetricsFinalized) {
            return;
        }
        if (!this.hasReceivedCallbacksAfterEnd()) {
            return;
        }
        this.finish();
    }

    private boolean callbacksReceived(JankInfo info) {
        return this.mSurfaceOnly ? info.surfaceControlCallbackFired : info.hwuiCallbackFired && info.surfaceControlCallbackFired;
    }

    private void finish() {
        this.mHandler.removeCallbacks(this.mWaitForFinishTimedOut);
        this.mWaitForFinishTimedOut = null;
        this.mMetricsFinalized = true;
        this.removeObservers();
        int totalFramesCount = 0;
        long maxFrameTimeNanos = 0L;
        int missedFramesCount = 0;
        int missedAppFramesCount = 0;
        int missedSfFramesCount = 0;
        int maxSuccessiveMissedFramesCount = 0;
        int successiveMissedFramesCount = 0;
        for (int i = 0; i < this.mJankInfos.size(); ++i) {
            boolean isFirstDrawn;
            JankInfo info = this.mJankInfos.valueAt(i);
            boolean bl = isFirstDrawn = !this.mSurfaceOnly && info.isFirstFrame;
            if (isFirstDrawn) continue;
            if (info.frameVsyncId > this.mEndVsyncId) break;
            if (info.surfaceControlCallbackFired) {
                ++totalFramesCount;
                boolean missedFrame = false;
                if ((info.jankType & 8) != 0) {
                    Log.w(TAG, "Missed App frame:" + info.jankType);
                    ++missedAppFramesCount;
                    missedFrame = true;
                }
                if ((info.jankType & 1) != 0 || (info.jankType & 2) != 0 || (info.jankType & 4) != 0 || (info.jankType & 0x20) != 0 || (info.jankType & 0x10) != 0) {
                    Log.w(TAG, "Missed SF frame:" + info.jankType);
                    ++missedSfFramesCount;
                    missedFrame = true;
                }
                if (missedFrame) {
                    ++missedFramesCount;
                    ++successiveMissedFramesCount;
                } else {
                    maxSuccessiveMissedFramesCount = Math.max(maxSuccessiveMissedFramesCount, successiveMissedFramesCount);
                    successiveMissedFramesCount = 0;
                }
                if (!this.mSurfaceOnly && !info.hwuiCallbackFired) {
                    Log.w(TAG, "Missing HWUI jank callback for vsyncId: " + info.frameVsyncId);
                }
            }
            if (this.mSurfaceOnly || !info.hwuiCallbackFired) continue;
            maxFrameTimeNanos = Math.max(info.totalDurationNanos, maxFrameTimeNanos);
            if (info.surfaceControlCallbackFired) continue;
            Log.w(TAG, "Missing SF jank callback for vsyncId: " + info.frameVsyncId);
        }
        maxSuccessiveMissedFramesCount = Math.max(maxSuccessiveMissedFramesCount, successiveMissedFramesCount);
        Trace.traceCounter(4096L, this.mSession.getName() + "#missedFrames", missedFramesCount);
        Trace.traceCounter(4096L, this.mSession.getName() + "#missedAppFrames", missedAppFramesCount);
        Trace.traceCounter(4096L, this.mSession.getName() + "#missedSfFrames", missedSfFramesCount);
        Trace.traceCounter(4096L, this.mSession.getName() + "#totalFrames", totalFramesCount);
        Trace.traceCounter(4096L, this.mSession.getName() + "#maxFrameTimeMillis", (int)(maxFrameTimeNanos / 1000000L));
        Trace.traceCounter(4096L, this.mSession.getName() + "#maxSuccessiveMissedFrames", maxSuccessiveMissedFramesCount);
        if (this.shouldTriggerPerfetto(missedFramesCount, (int)maxFrameTimeNanos)) {
            this.triggerPerfetto();
        }
        if (this.mSession.logToStatsd()) {
            this.mStatsLog.write(305, this.mSession.getStatsdInteractionType(), totalFramesCount, missedFramesCount, maxFrameTimeNanos, missedSfFramesCount, missedAppFramesCount, maxSuccessiveMissedFramesCount);
        }
    }

    private boolean shouldTriggerPerfetto(int missedFramesCount, int maxFrameTimeNanos) {
        boolean overMissedFramesThreshold = this.mTraceThresholdMissedFrames != -1 && missedFramesCount >= this.mTraceThresholdMissedFrames;
        boolean overFrameTimeThreshold = !this.mSurfaceOnly && this.mTraceThresholdFrameTimeMillis != -1 && maxFrameTimeNanos >= this.mTraceThresholdFrameTimeMillis * 1000000;
        return overMissedFramesThreshold || overFrameTimeThreshold;
    }

    @VisibleForTesting
    public void removeObservers() {
        this.mSurfaceControlWrapper.removeJankStatsListener(this);
        if (!this.mSurfaceOnly) {
            this.mRendererWrapper.removeObserver(this.mObserver);
            if (this.mSurfaceChangedCallback != null) {
                this.mViewRoot.removeSurfaceChangedCallback(this.mSurfaceChangedCallback);
            }
        }
    }

    public void triggerPerfetto() {
        InteractionJankMonitor.getInstance().trigger(this.mSession);
    }

    public static interface FrameTrackerListener {
        public void onCujEvents(InteractionJankMonitor.Session var1, String var2);
    }

    public static class StatsLogWrapper {
        public void write(int code, int arg1, long arg2, long arg3, long arg4, long arg5, long arg6, long arg7) {
            FrameworkStatsLog.write(code, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
    }

    public static class ChoreographerWrapper {
        private final Choreographer mChoreographer;

        public ChoreographerWrapper(Choreographer choreographer) {
            this.mChoreographer = choreographer;
        }

        public long getVsyncId() {
            return this.mChoreographer.getVsyncId();
        }
    }

    public static class SurfaceControlWrapper {
        public void addJankStatsListener(SurfaceControl.OnJankDataListener listener, SurfaceControl surfaceControl) {
            SurfaceControl.addJankDataListener(listener, surfaceControl);
        }

        public void removeJankStatsListener(SurfaceControl.OnJankDataListener listener) {
            SurfaceControl.removeJankDataListener(listener);
        }
    }

    public static class ViewRootWrapper {
        private final ViewRootImpl mViewRoot;

        public ViewRootWrapper(ViewRootImpl viewRoot) {
            this.mViewRoot = viewRoot;
        }

        public void addSurfaceChangedCallback(ViewRootImpl.SurfaceChangedCallback callback) {
            this.mViewRoot.addSurfaceChangedCallback(callback);
        }

        public void removeSurfaceChangedCallback(ViewRootImpl.SurfaceChangedCallback callback) {
            this.mViewRoot.removeSurfaceChangedCallback(callback);
        }

        public SurfaceControl getSurfaceControl() {
            return this.mViewRoot.getSurfaceControl();
        }
    }

    public static class ThreadedRendererWrapper {
        private final ThreadedRenderer mRenderer;

        public ThreadedRendererWrapper(ThreadedRenderer renderer) {
            this.mRenderer = renderer;
        }

        public void addObserver(HardwareRendererObserver observer) {
            this.mRenderer.addObserver(observer);
        }

        public void removeObserver(HardwareRendererObserver observer) {
            this.mRenderer.removeObserver(observer);
        }
    }

    public static class FrameMetricsWrapper {
        private final FrameMetrics mFrameMetrics = new FrameMetrics();

        public long[] getTiming() {
            return this.mFrameMetrics.mTimingData;
        }

        public long getMetric(int index) {
            return this.mFrameMetrics.getMetric(index);
        }
    }

    private static class JankInfo {
        long frameVsyncId;
        long totalDurationNanos;
        boolean isFirstFrame;
        boolean hwuiCallbackFired;
        boolean surfaceControlCallbackFired;
        int jankType;

        static JankInfo createFromHwuiCallback(long frameVsyncId, long totalDurationNanos, boolean isFirstFrame) {
            return new JankInfo(frameVsyncId, true, false, 0, totalDurationNanos, isFirstFrame);
        }

        static JankInfo createFromSurfaceControlCallback(long frameVsyncId, int jankType) {
            return new JankInfo(frameVsyncId, false, true, jankType, 0L, false);
        }

        private JankInfo(long frameVsyncId, boolean hwuiCallbackFired, boolean surfaceControlCallbackFired, int jankType, long totalDurationNanos, boolean isFirstFrame) {
            this.frameVsyncId = frameVsyncId;
            this.hwuiCallbackFired = hwuiCallbackFired;
            this.surfaceControlCallbackFired = surfaceControlCallbackFired;
            this.totalDurationNanos = totalDurationNanos;
            this.jankType = jankType;
            this.isFirstFrame = isFirstFrame;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Reasons {
    }
}

