/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ActivityManager;
import android.app.usage.NetworkStatsManager;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.UidTraffic;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.NetworkStats;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.Binder;
import android.os.BluetoothBatteryStats;
import android.os.Handler;
import android.os.IBatteryPropertiesRegistrar;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WakeLockStats;
import android.os.WorkSource;
import android.os._Original_Build;
import android.os.connectivity.CellularBatteryStats;
import android.os.connectivity.GpsBatteryStats;
import android.os.connectivity.WifiActivityEnergyInfo;
import android.os.connectivity.WifiBatteryStats;
import android.provider.Settings;
import android.telephony.CellSignalStrength;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthNr;
import android.telephony.ModemActivityInfo;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.IndentingPrintWriter;
import android.util.KeyValueListParser;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.LongSparseLongArray;
import android.util.MutableInt;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseDoubleArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import android.util.Xml;
import android.view.Display;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.EventLogTags;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatteryStatsHistory;
import com.android.internal.os.BatteryStatsHistoryIterator;
import com.android.internal.os.BinderCallsStats;
import com.android.internal.os.BinderTransactionNameResolver;
import com.android.internal.os.BluetoothPowerCalculator;
import com.android.internal.os.Clock;
import com.android.internal.os.CpuPowerCalculator;
import com.android.internal.os.KernelCpuSpeedReader;
import com.android.internal.os.KernelCpuUidTimeReader;
import com.android.internal.os.KernelMemoryBandwidthStats;
import com.android.internal.os.KernelSingleUidTimeReader;
import com.android.internal.os.KernelWakelockReader;
import com.android.internal.os.KernelWakelockStats;
import com.android.internal.os.LongArrayMultiStateCounter;
import com.android.internal.os.LongMultiStateCounter;
import com.android.internal.os.MobileRadioPowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.RailStats;
import com.android.internal.os.RpmStats;
import com.android.internal.os.SystemServerCpuThreadReader;
import com.android.internal.os.WifiPowerCalculator;
import com.android.internal.power.MeasuredEnergyStats;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FrameworkStatsLog;
import com.android.internal.util.XmlUtils;
import com.android.net.module.util.NetworkCapabilitiesUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParserException;

public class BatteryStatsImpl
extends BatteryStats {
    private static final String TAG = "BatteryStatsImpl";
    private static final boolean DEBUG = false;
    public static final boolean DEBUG_ENERGY = false;
    private static final boolean DEBUG_ENERGY_CPU = false;
    private static final boolean DEBUG_BINDER_STATS = false;
    private static final boolean DEBUG_MEMORY = false;
    private static final boolean DEBUG_HISTORY = false;
    private static final int MAGIC = -1166707595;
    static final int VERSION = 208;
    private static final int MAX_WAKELOCKS_PER_UID = ActivityManager.isLowRamDeviceStatic() ? 40 : 200;
    private static final int NUM_WIFI_TX_LEVELS = 1;
    private static final int NUM_BT_TX_LEVELS = 1;
    @VisibleForTesting
    public static final int WAKE_LOCK_WEIGHT = 50;
    public static final int RESET_REASON_CORRUPT_FILE = 1;
    public static final int RESET_REASON_ADB_COMMAND = 2;
    public static final int RESET_REASON_FULL_CHARGE = 3;
    public static final int RESET_REASON_MEASURED_ENERGY_BUCKETS_CHANGE = 4;
    protected Clock mClock;
    private final AtomicFile mStatsFile;
    public final AtomicFile mCheckinFile;
    public final AtomicFile mDailyFile;
    static final int MSG_REPORT_CPU_UPDATE_NEEDED = 1;
    static final int MSG_REPORT_POWER_CHANGE = 2;
    static final int MSG_REPORT_CHARGING = 3;
    static final int MSG_REPORT_RESET_STATS = 4;
    static final long DELAY_UPDATE_WAKELOCKS = 60000L;
    private static final double MILLISECONDS_IN_HOUR = 3600000.0;
    private static final long MILLISECONDS_IN_YEAR = 31536000000L;
    private static final BatteryStats.LongCounter ZERO_LONG_COUNTER = new BatteryStats.LongCounter(){

        @Override
        public long getCountLocked(int which) {
            return 0L;
        }

        @Override
        public long getCountForProcessState(int procState) {
            return 0L;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=0");
        }
    };
    private static final BatteryStats.LongCounter[] ZERO_LONG_COUNTER_ARRAY = new BatteryStats.LongCounter[]{ZERO_LONG_COUNTER};
    private final KernelWakelockReader mKernelWakelockReader = new KernelWakelockReader();
    private final KernelWakelockStats mTmpWakelockStats = new KernelWakelockStats();
    @VisibleForTesting
    protected KernelCpuUidTimeReader.KernelCpuUidUserSysTimeReader mCpuUidUserSysTimeReader;
    @VisibleForTesting
    protected KernelCpuSpeedReader[] mKernelCpuSpeedReaders;
    @VisibleForTesting
    protected KernelCpuUidTimeReader.KernelCpuUidFreqTimeReader mCpuUidFreqTimeReader;
    @VisibleForTesting
    protected KernelCpuUidTimeReader.KernelCpuUidActiveTimeReader mCpuUidActiveTimeReader;
    @VisibleForTesting
    protected KernelCpuUidTimeReader.KernelCpuUidClusterTimeReader mCpuUidClusterTimeReader;
    @VisibleForTesting
    protected KernelSingleUidTimeReader mKernelSingleUidTimeReader;
    @VisibleForTesting
    protected SystemServerCpuThreadReader mSystemServerCpuThreadReader = SystemServerCpuThreadReader.create();
    private final KernelMemoryBandwidthStats mKernelMemoryBandwidthStats = new KernelMemoryBandwidthStats();
    private final LongSparseArray<SamplingTimer> mKernelMemoryStats = new LongSparseArray();
    private static final int[] SUPPORTED_PER_PROCESS_STATE_STANDARD_ENERGY_BUCKETS = new int[]{3, 7, 4, 5};
    private static final int PROC_STATE_TIME_COUNTER_STATE_COUNT = 8;
    @GuardedBy(value={"this"})
    public boolean mPerProcStateCpuTimesAvailable = true;
    @GuardedBy(value={"this"})
    private long mNumSingleUidCpuTimeReads;
    @GuardedBy(value={"this"})
    private long mCpuTimeReadsTrackingStartTimeMs = SystemClock.uptimeMillis();
    @GuardedBy(value={"this"})
    private int mNumUidsRemoved;
    @GuardedBy(value={"this"})
    private int mNumAllUidCpuTimeReads;
    private RpmStats mTmpRpmStats = null;
    private static final long RPM_STATS_UPDATE_FREQ_MS = 1000L;
    private long mLastRpmStatsUpdateTimeMs = -1000L;
    private final RailStats mTmpRailStats = new RailStats();
    @GuardedBy(value={"this"})
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    protected Queue<UidToRemove> mPendingRemovedUids = new LinkedList<UidToRemove>();
    private BatteryResetListener mBatteryResetListener;
    private final PlatformIdleStateCallback mPlatformIdleStateCallback;
    private final Runnable mDeferSetCharging = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            synchronized (batteryStatsImpl) {
                if (BatteryStatsImpl.this.mOnBattery) {
                    return;
                }
                boolean changed = BatteryStatsImpl.this.setChargingLocked(true);
                if (changed) {
                    long uptimeMs = BatteryStatsImpl.this.mClock.uptimeMillis();
                    long elapsedRealtimeMs = BatteryStatsImpl.this.mClock.elapsedRealtime();
                    BatteryStatsImpl.this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
                }
            }
        }
    };
    public final MeasuredEnergyRetriever mMeasuredEnergyRetriever;
    public Handler mHandler;
    private ExternalStatsSync mExternalSync = null;
    @VisibleForTesting
    protected UserInfoProvider mUserInfoProvider = null;
    private BatteryCallback mCallback;
    final SparseIntArray mIsolatedUids = new SparseIntArray();
    final SparseIntArray mIsolatedUidRefCounts = new SparseIntArray();
    final SparseArray<Uid> mUidStats = new SparseArray();
    @VisibleForTesting
    @UnsupportedAppUsage
    protected ArrayList<StopwatchTimer> mPartialTimers = new ArrayList();
    @UnsupportedAppUsage
    final ArrayList<StopwatchTimer> mFullTimers = new ArrayList();
    @UnsupportedAppUsage
    final ArrayList<StopwatchTimer> mWindowTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mDrawTimers = new ArrayList();
    final SparseArray<ArrayList<StopwatchTimer>> mSensorTimers = new SparseArray();
    final ArrayList<StopwatchTimer> mWifiRunningTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mFullWifiLockTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWifiMulticastTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWifiScanTimers = new ArrayList();
    final SparseArray<ArrayList<StopwatchTimer>> mWifiBatchedScanTimers = new SparseArray();
    final ArrayList<StopwatchTimer> mAudioTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mVideoTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mFlashlightTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mCameraTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mBluetoothScanOnTimers = new ArrayList();
    @VisibleForTesting
    protected ArrayList<StopwatchTimer> mLastPartialTimers = new ArrayList();
    protected final TimeBase mOnBatteryTimeBase = new TimeBase(true);
    protected final TimeBase mOnBatteryScreenOffTimeBase = new TimeBase(true);
    boolean mDistributeWakelockCpu;
    private boolean mSystemReady;
    boolean mShuttingDown;
    final BatteryStats.HistoryEventTracker mActiveEvents = new BatteryStats.HistoryEventTracker();
    long mHistoryBaseTimeMs;
    protected boolean mHaveBatteryLevel = false;
    protected boolean mRecordingHistory = false;
    int mNumHistoryItems;
    private static final int HISTORY_TAG_INDEX_LIMIT = 32766;
    private static final int MAX_HISTORY_TAG_STRING_LENGTH = 1024;
    final HashMap<BatteryStats.HistoryTag, Integer> mHistoryTagPool = new HashMap();
    private SparseArray<BatteryStats.HistoryTag> mHistoryTags;
    final Parcel mHistoryBuffer = Parcel.obtain();
    final BatteryStats.HistoryItem mHistoryLastWritten = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryLastLastWritten = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryAddTmp = new BatteryStats.HistoryItem();
    int mNextHistoryTagIdx = 0;
    int mNumHistoryTagChars = 0;
    int mHistoryBufferLastPos = -1;
    int mActiveHistoryStates = -1;
    int mActiveHistoryStates2 = -1;
    long mLastHistoryElapsedRealtimeMs = 0L;
    long mTrackRunningHistoryElapsedRealtimeMs = 0L;
    long mTrackRunningHistoryUptimeMs = 0L;
    final BatteryStatsHistory mBatteryStatsHistory;
    final BatteryStats.HistoryItem mHistoryCur = new BatteryStats.HistoryItem();
    BatteryStats.HistoryItem mHistory;
    BatteryStats.HistoryItem mHistoryEnd;
    BatteryStats.HistoryItem mHistoryLastEnd;
    BatteryStats.HistoryItem mHistoryCache;
    BatteryStats.HistoryStepDetails mLastHistoryStepDetails = null;
    byte mLastHistoryStepLevel = 0;
    final BatteryStats.HistoryStepDetails mCurHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    final BatteryStats.HistoryStepDetails mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    final BatteryStats.HistoryStepDetails mTmpHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    long mLastStepCpuUserTimeMs;
    long mCurStepCpuUserTimeMs;
    long mLastStepCpuSystemTimeMs;
    long mCurStepCpuSystemTimeMs;
    long mLastStepStatUserTimeMs;
    long mLastStepStatSystemTimeMs;
    long mLastStepStatIOWaitTimeMs;
    long mLastStepStatIrqTimeMs;
    long mLastStepStatSoftIrqTimeMs;
    long mLastStepStatIdleTimeMs;
    long mCurStepStatUserTimeMs;
    long mCurStepStatSystemTimeMs;
    long mCurStepStatIOWaitTimeMs;
    long mCurStepStatIrqTimeMs;
    long mCurStepStatSoftIrqTimeMs;
    long mCurStepStatIdleTimeMs;
    private BatteryStatsHistoryIterator mBatteryStatsHistoryIterator;
    private BatteryStats.HistoryItem mHistoryIterator;
    int mStartCount;
    @GuardedBy(value={"this"})
    boolean mIgnoreNextExternalStats = false;
    long mStartClockTimeMs;
    String mStartPlatformVersion;
    String mEndPlatformVersion;
    long mUptimeUs;
    long mUptimeStartUs;
    long mRealtimeUs;
    long mRealtimeStartUs;
    int mWakeLockNesting;
    boolean mWakeLockImportant;
    public boolean mRecordAllHistory;
    boolean mNoAutoReset;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    protected int mScreenState = 0;
    StopwatchTimer mScreenOnTimer;
    StopwatchTimer mScreenDozeTimer;
    int mScreenBrightnessBin = -1;
    final StopwatchTimer[] mScreenBrightnessTimer = new StopwatchTimer[5];
    boolean mPretendScreenOff;
    DisplayBatteryStats[] mPerDisplayBatteryStats;
    private int mDisplayMismatchWtfCount = 0;
    boolean mInteractive;
    StopwatchTimer mInteractiveTimer;
    boolean mPowerSaveModeEnabled;
    StopwatchTimer mPowerSaveModeEnabledTimer;
    boolean mDeviceIdling;
    StopwatchTimer mDeviceIdlingTimer;
    boolean mDeviceLightIdling;
    StopwatchTimer mDeviceLightIdlingTimer;
    int mDeviceIdleMode;
    long mLastIdleTimeStartMs;
    long mLongestLightIdleTimeMs;
    long mLongestFullIdleTimeMs;
    StopwatchTimer mDeviceIdleModeLightTimer;
    StopwatchTimer mDeviceIdleModeFullTimer;
    boolean mPhoneOn;
    StopwatchTimer mPhoneOnTimer;
    int mAudioOnNesting;
    StopwatchTimer mAudioOnTimer;
    int mVideoOnNesting;
    StopwatchTimer mVideoOnTimer;
    int mFlashlightOnNesting;
    StopwatchTimer mFlashlightOnTimer;
    int mCameraOnNesting;
    StopwatchTimer mCameraOnTimer;
    private static final int USB_DATA_UNKNOWN = 0;
    private static final int USB_DATA_DISCONNECTED = 1;
    private static final int USB_DATA_CONNECTED = 2;
    int mUsbDataState = 0;
    int mGpsSignalQualityBin = -1;
    final StopwatchTimer[] mGpsSignalQualityTimer = new StopwatchTimer[2];
    int mPhoneSignalStrengthBin = -1;
    int mPhoneSignalStrengthBinRaw = -1;
    final StopwatchTimer[] mPhoneSignalStrengthsTimer = new StopwatchTimer[CellSignalStrength.getNumSignalStrengthLevels()];
    StopwatchTimer mPhoneSignalScanningTimer;
    int mPhoneDataConnectionType = -1;
    final StopwatchTimer[] mPhoneDataConnectionsTimer = new StopwatchTimer[NUM_DATA_CONNECTION_TYPES];
    int mActiveRat = 0;
    private static final int NR_FREQUENCY_COUNT = 5;
    RadioAccessTechnologyBatteryStats[] mPerRatBatteryStats = new RadioAccessTechnologyBatteryStats[3];
    final LongSamplingCounter[] mNetworkByteActivityCounters = new LongSamplingCounter[10];
    final LongSamplingCounter[] mNetworkPacketActivityCounters = new LongSamplingCounter[10];
    StopwatchTimer mWifiMulticastWakelockTimer;
    ControllerActivityCounterImpl mWifiActivity;
    ControllerActivityCounterImpl mBluetoothActivity;
    ControllerActivityCounterImpl mModemActivity;
    boolean mHasWifiReporting = false;
    boolean mHasBluetoothReporting = false;
    boolean mHasModemReporting = false;
    boolean mWifiOn;
    StopwatchTimer mWifiOnTimer;
    boolean mGlobalWifiRunning;
    StopwatchTimer mGlobalWifiRunningTimer;
    int mWifiState = -1;
    final StopwatchTimer[] mWifiStateTimer = new StopwatchTimer[8];
    int mWifiSupplState = -1;
    final StopwatchTimer[] mWifiSupplStateTimer = new StopwatchTimer[13];
    int mWifiSignalStrengthBin = -1;
    final StopwatchTimer[] mWifiSignalStrengthsTimer = new StopwatchTimer[5];
    StopwatchTimer mWifiActiveTimer;
    int mBluetoothScanNesting;
    StopwatchTimer mBluetoothScanTimer;
    int mMobileRadioPowerState = 1;
    long mMobileRadioActiveStartTimeMs;
    StopwatchTimer mMobileRadioActiveTimer;
    StopwatchTimer mMobileRadioActivePerAppTimer;
    LongSamplingCounter mMobileRadioActiveAdjustedTime;
    LongSamplingCounter mMobileRadioActiveUnknownTime;
    LongSamplingCounter mMobileRadioActiveUnknownCount;
    int mWifiRadioPowerState = 1;
    @GuardedBy(value={"this"})
    @VisibleForTesting
    protected MeasuredEnergyStats.Config mMeasuredEnergyStatsConfig;
    @GuardedBy(value={"this"})
    @VisibleForTesting
    protected MeasuredEnergyStats mGlobalMeasuredEnergyStats;
    BluetoothPowerCalculator mBluetoothPowerCalculator = null;
    CpuPowerCalculator mCpuPowerCalculator = null;
    MobileRadioPowerCalculator mMobileRadioPowerCalculator = null;
    WifiPowerCalculator mWifiPowerCalculator = null;
    boolean mOnBattery;
    @VisibleForTesting
    protected boolean mOnBatteryInternal;
    boolean mCharging = true;
    int mLastChargingStateLevel;
    int mDischargeStartLevel;
    int mDischargeUnplugLevel;
    int mDischargePlugLevel;
    int mDischargeCurrentLevel;
    int mCurrentBatteryLevel;
    int mLowDischargeAmountSinceCharge;
    int mHighDischargeAmountSinceCharge;
    int mDischargeScreenOnUnplugLevel;
    int mDischargeScreenOffUnplugLevel;
    int mDischargeScreenDozeUnplugLevel;
    int mDischargeAmountScreenOn;
    int mDischargeAmountScreenOnSinceCharge;
    int mDischargeAmountScreenOff;
    int mDischargeAmountScreenOffSinceCharge;
    int mDischargeAmountScreenDoze;
    int mDischargeAmountScreenDozeSinceCharge;
    private LongSamplingCounter mDischargeScreenOffCounter;
    private LongSamplingCounter mDischargeScreenDozeCounter;
    private LongSamplingCounter mDischargeCounter;
    private LongSamplingCounter mDischargeLightDozeCounter;
    private LongSamplingCounter mDischargeDeepDozeCounter;
    static final int MAX_LEVEL_STEPS = 200;
    int mInitStepMode = 0;
    int mCurStepMode = 0;
    int mModStepMode = 0;
    int mLastDischargeStepLevel;
    int mMinDischargeStepLevel;
    final BatteryStats.LevelStepTracker mDischargeStepTracker = new BatteryStats.LevelStepTracker(200);
    final BatteryStats.LevelStepTracker mDailyDischargeStepTracker = new BatteryStats.LevelStepTracker(400);
    ArrayList<BatteryStats.PackageChange> mDailyPackageChanges;
    int mLastChargeStepLevel;
    int mMaxChargeStepLevel;
    final BatteryStats.LevelStepTracker mChargeStepTracker = new BatteryStats.LevelStepTracker(200);
    final BatteryStats.LevelStepTracker mDailyChargeStepTracker = new BatteryStats.LevelStepTracker(400);
    static final int MAX_DAILY_ITEMS = 10;
    long mDailyStartTimeMs = 0L;
    long mNextMinDailyDeadlineMs = 0L;
    long mNextMaxDailyDeadlineMs = 0L;
    final ArrayList<BatteryStats.DailyItem> mDailyItems = new ArrayList();
    long mLastWriteTimeMs = 0L;
    private int mPhoneServiceState = -1;
    private int mPhoneServiceStateRaw = -1;
    private int mPhoneSimStateRaw = -1;
    private int mNumConnectivityChange;
    private int mBatteryVoltageMv = -1;
    private int mEstimatedBatteryCapacityMah = -1;
    private int mLastLearnedBatteryCapacityUah = -1;
    private int mMinLearnedBatteryCapacityUah = -1;
    private int mMaxLearnedBatteryCapacityUah = -1;
    private long mBatteryTimeToFullSeconds = -1L;
    private boolean mCpuFreqsInitialized;
    private long[] mCpuFreqs;
    private LongArrayMultiStateCounter.LongArrayContainer mTmpCpuTimeInFreq;
    private LongSamplingCounterArray mBinderThreadCpuTimesUs;
    @VisibleForTesting
    protected PowerProfile mPowerProfile;
    @VisibleForTesting
    @GuardedBy(value={"this"})
    protected final Constants mConstants;
    private final HashMap<String, SamplingTimer> mRpmStats = new HashMap();
    private final HashMap<String, SamplingTimer> mScreenOffRpmStats = new HashMap();
    private final HashMap<String, SamplingTimer> mKernelWakelockStats = new HashMap();
    String mLastWakeupReason = null;
    long mLastWakeupUptimeMs = 0L;
    private final HashMap<String, SamplingTimer> mWakeupReasonStats = new HashMap();
    static final int DELTA_TIME_MASK = 524287;
    static final int DELTA_TIME_LONG = 524287;
    static final int DELTA_TIME_INT = 524286;
    static final int DELTA_TIME_ABS = 524285;
    static final int DELTA_BATTERY_LEVEL_FLAG = 524288;
    static final int DELTA_STATE_FLAG = 0x100000;
    static final int DELTA_STATE2_FLAG = 0x200000;
    static final int DELTA_WAKELOCK_FLAG = 0x400000;
    static final int DELTA_EVENT_FLAG = 0x800000;
    static final int DELTA_BATTERY_CHARGE_FLAG = 0x1000000;
    static final int DELTA_STATE_MASK = -33554432;
    static final int TAG_FIRST_OCCURRENCE_FLAG = 32768;
    static final int STATE_BATTERY_MASK = -16777216;
    static final int STATE_BATTERY_STATUS_MASK = 7;
    static final int STATE_BATTERY_STATUS_SHIFT = 29;
    static final int STATE_BATTERY_HEALTH_MASK = 7;
    static final int STATE_BATTERY_HEALTH_SHIFT = 26;
    static final int STATE_BATTERY_PLUG_MASK = 3;
    static final int STATE_BATTERY_PLUG_SHIFT = 24;
    static final int BATTERY_DELTA_LEVEL_FLAG = 1;
    int mChangedStates = 0;
    int mChangedStates2 = 0;
    private String mInitialAcquireWakeName;
    private int mInitialAcquireWakeUid = -1;
    int mSensorNesting;
    int mGpsNesting;
    int mWifiFullLockNesting = 0;
    int mWifiScanNesting = 0;
    int mWifiMulticastNesting = 0;
    private final Object mWifiNetworkLock = new Object();
    @GuardedBy(value={"mWifiNetworkLock"})
    private String[] mWifiIfaces = EmptyArray.STRING;
    @GuardedBy(value={"mWifiNetworkLock"})
    private NetworkStats mLastWifiNetworkStats = new NetworkStats(0L, -1);
    private final Object mModemNetworkLock = new Object();
    @GuardedBy(value={"mModemNetworkLock"})
    private String[] mModemIfaces = EmptyArray.STRING;
    @GuardedBy(value={"mModemNetworkLock"})
    private NetworkStats mLastModemNetworkStats = new NetworkStats(0L, -1);
    private ModemActivityInfo mLastModemActivityInfo = null;
    private final BluetoothActivityInfoCache mLastBluetoothActivityInfo = new BluetoothActivityInfoCache();
    long mTempTotalCpuUserTimeUs;
    long mTempTotalCpuSystemTimeUs;
    long[][] mWakeLockAllocationsUs;
    public static final int BATTERY_PLUGGED_NONE = 0;
    final ReentrantLock mWriteLock = new ReentrantLock();
    @UnsupportedAppUsage
    public static final Parcelable.Creator<BatteryStatsImpl> CREATOR = new Parcelable.Creator<BatteryStatsImpl>(){

        @Override
        public BatteryStatsImpl createFromParcel(Parcel in) {
            return new BatteryStatsImpl(in);
        }

        public BatteryStatsImpl[] newArray(int size) {
            return new BatteryStatsImpl[size];
        }
    };

    public LongSparseArray<SamplingTimer> getKernelMemoryStats() {
        return this.mKernelMemoryStats;
    }

    public void postBatteryNeedsCpuUpdateMsg() {
        this.mHandler.sendEmptyMessage(1);
    }

    @GuardedBy(value={"this"})
    @VisibleForTesting
    public void updateProcStateCpuTimesLocked(int uid, long timestampMs) {
        if (!this.initKernelSingleUidTimeReaderLocked()) {
            return;
        }
        Uid u = this.getUidStatsLocked(uid);
        ++this.mNumSingleUidCpuTimeReads;
        LongArrayMultiStateCounter onBatteryCounter = u.getProcStateTimeCounter(timestampMs).getCounter();
        LongArrayMultiStateCounter onBatteryScreenOffCounter = u.getProcStateScreenOffTimeCounter(timestampMs).getCounter();
        this.mKernelSingleUidTimeReader.addDelta(uid, onBatteryCounter, timestampMs);
        this.mKernelSingleUidTimeReader.addDelta(uid, onBatteryScreenOffCounter, timestampMs);
        if (u.mChildUids != null) {
            LongArrayMultiStateCounter.LongArrayContainer deltaContainer = this.getCpuTimeInFreqContainer();
            int childUidCount = u.mChildUids.size();
            for (int j = childUidCount - 1; j >= 0; --j) {
                LongArrayMultiStateCounter cpuTimeInFreqCounter = u.mChildUids.valueAt((int)j).cpuTimeInFreqCounter;
                if (cpuTimeInFreqCounter == null) continue;
                this.mKernelSingleUidTimeReader.addDelta(u.mChildUids.keyAt(j), cpuTimeInFreqCounter, timestampMs, deltaContainer);
                onBatteryCounter.addCounts(deltaContainer);
                onBatteryScreenOffCounter.addCounts(deltaContainer);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void clearPendingRemovedUidsLocked() {
        long cutOffTimeMs = this.mClock.elapsedRealtime() - this.mConstants.UID_REMOVE_DELAY_MS;
        while (!this.mPendingRemovedUids.isEmpty() && this.mPendingRemovedUids.peek().getUidRemovalTimestamp() < cutOffTimeMs) {
            this.mPendingRemovedUids.poll().removeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCpuTimesForAllUids() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            if (!this.trackPerProcStateCpuTimes()) {
                return;
            }
            if (!this.initKernelSingleUidTimeReaderLocked()) {
                return;
            }
            SparseArray<long[]> allUidCpuFreqTimesMs = this.mCpuUidFreqTimeReader.getAllUidCpuFreqTimeMs();
            for (int i = allUidCpuFreqTimesMs.size() - 1; i >= 0; --i) {
                LongArrayMultiStateCounter counter;
                int procState;
                int uid = allUidCpuFreqTimesMs.keyAt(i);
                int parentUid = this.mapUid(uid);
                Uid u = this.getAvailableUidStatsLocked(parentUid);
                if (u == null || (procState = u.mProcessState) == 7) continue;
                long timestampMs = this.mClock.elapsedRealtime();
                LongArrayMultiStateCounter onBatteryCounter = u.getProcStateTimeCounter(timestampMs).getCounter();
                LongArrayMultiStateCounter onBatteryScreenOffCounter = u.getProcStateScreenOffTimeCounter(timestampMs).getCounter();
                if (uid == parentUid || Process.isSdkSandboxUid(uid)) {
                    this.mKernelSingleUidTimeReader.addDelta(parentUid, onBatteryCounter, timestampMs);
                    this.mKernelSingleUidTimeReader.addDelta(parentUid, onBatteryScreenOffCounter, timestampMs);
                    continue;
                }
                Uid.ChildUid childUid = u.getChildUid(uid);
                if (childUid == null || (counter = childUid.cpuTimeInFreqCounter) == null) continue;
                LongArrayMultiStateCounter.LongArrayContainer deltaContainer = this.getCpuTimeInFreqContainer();
                this.mKernelSingleUidTimeReader.addDelta(uid, counter, timestampMs, deltaContainer);
                onBatteryCounter.addCounts(deltaContainer);
                onBatteryScreenOffCounter.addCounts(deltaContainer);
            }
        }
    }

    @VisibleForTesting
    public static long[] addCpuTimes(long[] timesA, long[] timesB) {
        if (timesA != null && timesB != null) {
            for (int i = timesA.length - 1; i >= 0; --i) {
                int n = i;
                timesA[n] = timesA[n] + timesB[i];
            }
            return timesA;
        }
        return timesA == null ? (Object)(timesB == null ? null : timesB) : timesA;
    }

    @GuardedBy(value={"this"})
    private boolean initKernelSingleUidTimeReaderLocked() {
        if (this.mKernelSingleUidTimeReader == null) {
            if (this.mPowerProfile == null) {
                return false;
            }
            if (this.mCpuFreqs == null) {
                this.mCpuFreqs = this.mCpuUidFreqTimeReader.readFreqs(this.mPowerProfile);
            }
            if (this.mCpuFreqs != null) {
                this.mKernelSingleUidTimeReader = new KernelSingleUidTimeReader(this.mCpuFreqs.length);
            } else {
                this.mPerProcStateCpuTimesAvailable = this.mCpuUidFreqTimeReader.allUidTimesAvailable();
                return false;
            }
        }
        this.mPerProcStateCpuTimesAvailable = this.mCpuUidFreqTimeReader.allUidTimesAvailable() && this.mKernelSingleUidTimeReader.singleUidCpuTimesAvailable();
        return true;
    }

    @GuardedBy(value={"this"})
    private RadioAccessTechnologyBatteryStats getRatBatteryStatsLocked(int rat) {
        RadioAccessTechnologyBatteryStats stats = this.mPerRatBatteryStats[rat];
        if (stats == null) {
            int freqCount = rat == 2 ? 5 : 1;
            this.mPerRatBatteryStats[rat] = stats = new RadioAccessTechnologyBatteryStats(freqCount, this.mClock, this.mOnBatteryTimeBase);
        }
        return stats;
    }

    public Map<String, ? extends Timer> getRpmStats() {
        return this.mRpmStats;
    }

    public Map<String, ? extends Timer> getScreenOffRpmStats() {
        return this.mScreenOffRpmStats;
    }

    @UnsupportedAppUsage
    public Map<String, ? extends Timer> getKernelWakelockStats() {
        return this.mKernelWakelockStats;
    }

    @Override
    public WakeLockStats getWakeLockStats() {
        long realtimeMs = this.mClock.elapsedRealtime();
        long realtimeUs = realtimeMs * 1000L;
        ArrayList<WakeLockStats.WakeLock> uidWakeLockStats = new ArrayList<WakeLockStats.WakeLock>();
        for (int i = this.mUidStats.size() - 1; i >= 0; --i) {
            Uid uid = this.mUidStats.valueAt(i);
            ArrayMap<String, Uid.Wakelock> wakelockStats = uid.mWakelockStats.getMap();
            for (int j = wakelockStats.size() - 1; j >= 0; --j) {
                long totalTimeLockHeldMs;
                String name = wakelockStats.keyAt(j);
                Uid.Wakelock wakelock = wakelockStats.valueAt(j);
                DualTimer timer = wakelock.mTimerPartial;
                if (timer == null || (totalTimeLockHeldMs = timer.getTotalTimeLocked(realtimeUs, 0) / 1000L) == 0L) continue;
                uidWakeLockStats.add(new WakeLockStats.WakeLock(uid.getUid(), name, timer.getCountLocked(0), totalTimeLockHeldMs, timer.isRunningLocked() ? timer.getCurrentDurationMsLocked(realtimeMs) : 0L));
            }
        }
        return new WakeLockStats(uidWakeLockStats);
    }

    @Override
    @GuardedBy(value={"this"})
    public BluetoothBatteryStats getBluetoothBatteryStats() {
        long elapsedRealtimeUs = this.mClock.elapsedRealtime() * 1000L;
        ArrayList<BluetoothBatteryStats.UidStats> uidStats = new ArrayList<BluetoothBatteryStats.UidStats>();
        for (int i = this.mUidStats.size() - 1; i >= 0; --i) {
            long txTimeMs;
            Uid uid = this.mUidStats.valueAt(i);
            Timer scanTimer = uid.getBluetoothScanTimer();
            long scanTimeMs = scanTimer != null ? scanTimer.getTotalTimeLocked(elapsedRealtimeUs, 0) / 1000L : 0L;
            Timer unoptimizedScanTimer = uid.getBluetoothUnoptimizedScanTimer();
            long unoptimizedScanTimeMs = unoptimizedScanTimer != null ? unoptimizedScanTimer.getTotalTimeLocked(elapsedRealtimeUs, 0) / 1000L : 0L;
            Counter scanResultCounter = uid.getBluetoothScanResultCounter();
            int scanResultCount = scanResultCounter != null ? scanResultCounter.getCountLocked(0) : 0;
            ControllerActivityCounterImpl counter = uid.getBluetoothControllerActivity();
            long rxTimeMs = counter != null ? ((BatteryStats.ControllerActivityCounter)counter).getRxTimeCounter().getCountLocked(0) : 0L;
            long l = txTimeMs = counter != null ? ((BatteryStats.ControllerActivityCounter)counter).getTxTimeCounters()[0].getCountLocked(0) : 0L;
            if (scanTimeMs == 0L && unoptimizedScanTimeMs == 0L && scanResultCount == 0 && rxTimeMs == 0L && txTimeMs == 0L) continue;
            uidStats.add(new BluetoothBatteryStats.UidStats(uid.getUid(), scanTimeMs, unoptimizedScanTimeMs, scanResultCount, rxTimeMs, txTimeMs));
        }
        return new BluetoothBatteryStats(uidStats);
    }

    public Map<String, ? extends Timer> getWakeupReasonStats() {
        return this.mWakeupReasonStats;
    }

    @Override
    public long getUahDischarge(int which) {
        return this.mDischargeCounter.getCountLocked(which);
    }

    @Override
    public long getUahDischargeScreenOff(int which) {
        return this.mDischargeScreenOffCounter.getCountLocked(which);
    }

    @Override
    public long getUahDischargeScreenDoze(int which) {
        return this.mDischargeScreenDozeCounter.getCountLocked(which);
    }

    @Override
    public long getUahDischargeLightDoze(int which) {
        return this.mDischargeLightDozeCounter.getCountLocked(which);
    }

    @Override
    public long getUahDischargeDeepDoze(int which) {
        return this.mDischargeDeepDozeCounter.getCountLocked(which);
    }

    @Override
    public int getEstimatedBatteryCapacity() {
        return this.mEstimatedBatteryCapacityMah;
    }

    @Override
    public int getLearnedBatteryCapacity() {
        return this.mLastLearnedBatteryCapacityUah;
    }

    @Override
    public int getMinLearnedBatteryCapacity() {
        return this.mMinLearnedBatteryCapacityUah;
    }

    @Override
    public int getMaxLearnedBatteryCapacity() {
        return this.mMaxLearnedBatteryCapacityUah;
    }

    public BatteryStatsImpl() {
        this(Clock.SYSTEM_CLOCK);
    }

    public BatteryStatsImpl(Clock clock) {
        this(clock, (File)null);
    }

    public BatteryStatsImpl(Clock clock, File historyDirectory) {
        this.init(clock);
        this.mStartClockTimeMs = clock.currentTimeMillis();
        this.mCheckinFile = null;
        this.mDailyFile = null;
        if (historyDirectory == null) {
            this.mStatsFile = null;
            this.mBatteryStatsHistory = new BatteryStatsHistory(this.mHistoryBuffer);
        } else {
            this.mStatsFile = new AtomicFile(new File(historyDirectory, "batterystats.bin"));
            this.mBatteryStatsHistory = new BatteryStatsHistory(this, historyDirectory, this.mHistoryBuffer);
        }
        this.mHandler = null;
        this.mPlatformIdleStateCallback = null;
        this.mMeasuredEnergyRetriever = null;
        this.mUserInfoProvider = null;
        this.mConstants = new Constants(this.mHandler);
        this.clearHistoryLocked();
    }

    private void init(Clock clock) {
        this.mClock = clock;
        this.mCpuUidUserSysTimeReader = new KernelCpuUidTimeReader.KernelCpuUidUserSysTimeReader(true, clock);
        this.mCpuUidFreqTimeReader = new KernelCpuUidTimeReader.KernelCpuUidFreqTimeReader(true, clock);
        this.mCpuUidActiveTimeReader = new KernelCpuUidTimeReader.KernelCpuUidActiveTimeReader(true, clock);
        this.mCpuUidClusterTimeReader = new KernelCpuUidTimeReader.KernelCpuUidClusterTimeReader(true, clock);
    }

    public SamplingTimer getRpmTimerLocked(String name) {
        SamplingTimer rpmt = this.mRpmStats.get(name);
        if (rpmt == null) {
            rpmt = new SamplingTimer(this.mClock, this.mOnBatteryTimeBase);
            this.mRpmStats.put(name, rpmt);
        }
        return rpmt;
    }

    public SamplingTimer getScreenOffRpmTimerLocked(String name) {
        SamplingTimer rpmt = this.mScreenOffRpmStats.get(name);
        if (rpmt == null) {
            rpmt = new SamplingTimer(this.mClock, this.mOnBatteryScreenOffTimeBase);
            this.mScreenOffRpmStats.put(name, rpmt);
        }
        return rpmt;
    }

    public SamplingTimer getWakeupReasonTimerLocked(String name) {
        SamplingTimer timer = this.mWakeupReasonStats.get(name);
        if (timer == null) {
            timer = new SamplingTimer(this.mClock, this.mOnBatteryTimeBase);
            this.mWakeupReasonStats.put(name, timer);
        }
        return timer;
    }

    public SamplingTimer getKernelWakelockTimerLocked(String name) {
        SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
        if (kwlt == null) {
            kwlt = new SamplingTimer(this.mClock, this.mOnBatteryScreenOffTimeBase);
            this.mKernelWakelockStats.put(name, kwlt);
        }
        return kwlt;
    }

    public SamplingTimer getKernelMemoryTimerLocked(long bucket) {
        SamplingTimer kmt = this.mKernelMemoryStats.get(bucket);
        if (kmt == null) {
            kmt = new SamplingTimer(this.mClock, this.mOnBatteryTimeBase);
            this.mKernelMemoryStats.put(bucket, kmt);
        }
        return kmt;
    }

    private int writeHistoryTag(BatteryStats.HistoryTag tag) {
        Integer idxObj;
        int stringLength;
        if (tag.string == null) {
            Slog.wtfStack(TAG, "writeHistoryTag called with null name");
        }
        if ((stringLength = tag.string.length()) > 1024) {
            Slog.e(TAG, "Long battery history tag: " + tag.string);
            tag.string = tag.string.substring(0, 1024);
        }
        if ((idxObj = this.mHistoryTagPool.get(tag)) != null) {
            int idx = idxObj;
            if ((idx & 0x8000) != 0) {
                this.mHistoryTagPool.put(tag, idx & 0xFFFF7FFF);
            }
            return idx;
        }
        if (this.mNextHistoryTagIdx < 32766) {
            int idx = this.mNextHistoryTagIdx++;
            BatteryStats.HistoryTag key = new BatteryStats.HistoryTag();
            key.setTo(tag);
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(key, idx);
            this.mNumHistoryTagChars += stringLength + 1;
            if (this.mHistoryTags != null) {
                this.mHistoryTags.put(idx, key);
            }
            return idx | 0x8000;
        }
        return 65534;
    }

    @GuardedBy(value={"this"})
    public void writeHistoryDelta(Parcel dest, BatteryStats.HistoryItem cur, BatteryStats.HistoryItem last) {
        boolean batteryChargeChanged;
        boolean state2IntChanged;
        int stateInt;
        boolean stateIntChanged;
        boolean batteryLevelIntChanged;
        if (last == null || cur.cmd != 0) {
            dest.writeInt(524285);
            cur.writeToParcel(dest, 0);
            return;
        }
        long deltaTime = cur.time - last.time;
        int lastBatteryLevelInt = this.buildBatteryLevelInt(last);
        int lastStateInt = this.buildStateInt(last);
        int deltaTimeToken = deltaTime < 0L || deltaTime > Integer.MAX_VALUE ? 524287 : (deltaTime >= 524285L ? 524286 : (int)deltaTime);
        int firstToken = deltaTimeToken | cur.states & 0xFE000000;
        int includeStepDetails = this.mLastHistoryStepLevel > cur.batteryLevel ? 1 : 0;
        boolean computeStepDetails = includeStepDetails != 0 || this.mLastHistoryStepDetails == null;
        int batteryLevelInt = this.buildBatteryLevelInt(cur) | includeStepDetails;
        boolean bl = batteryLevelIntChanged = batteryLevelInt != lastBatteryLevelInt;
        if (batteryLevelIntChanged) {
            firstToken |= 0x80000;
        }
        boolean bl2 = stateIntChanged = (stateInt = this.buildStateInt(cur)) != lastStateInt;
        if (stateIntChanged) {
            firstToken |= 0x100000;
        }
        boolean bl3 = state2IntChanged = cur.states2 != last.states2;
        if (state2IntChanged) {
            firstToken |= 0x200000;
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            firstToken |= 0x400000;
        }
        if (cur.eventCode != 0) {
            firstToken |= 0x800000;
        }
        boolean bl4 = batteryChargeChanged = cur.batteryChargeUah != last.batteryChargeUah;
        if (batteryChargeChanged) {
            firstToken |= 0x1000000;
        }
        dest.writeInt(firstToken);
        if (deltaTimeToken >= 524286) {
            if (deltaTimeToken == 524286) {
                dest.writeInt((int)deltaTime);
            } else {
                dest.writeLong(deltaTime);
            }
        }
        if (batteryLevelIntChanged) {
            dest.writeInt(batteryLevelInt);
        }
        if (stateIntChanged) {
            dest.writeInt(stateInt);
        }
        if (state2IntChanged) {
            dest.writeInt(cur.states2);
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            int wakeLockIndex = cur.wakelockTag != null ? this.writeHistoryTag(cur.wakelockTag) : 65535;
            int wakeReasonIndex = cur.wakeReasonTag != null ? this.writeHistoryTag(cur.wakeReasonTag) : 65535;
            dest.writeInt(wakeReasonIndex << 16 | wakeLockIndex);
            if (cur.wakelockTag != null && (wakeLockIndex & 0x8000) != 0) {
                cur.wakelockTag.writeToParcel(dest, 0);
                cur.tagsFirstOccurrence = true;
            }
            if (cur.wakeReasonTag != null && (wakeReasonIndex & 0x8000) != 0) {
                cur.wakeReasonTag.writeToParcel(dest, 0);
                cur.tagsFirstOccurrence = true;
            }
        }
        if (cur.eventCode != 0) {
            int index = this.writeHistoryTag(cur.eventTag);
            int codeAndIndex = cur.eventCode & 0xFFFF | index << 16;
            dest.writeInt(codeAndIndex);
            if ((index & 0x8000) != 0) {
                cur.eventTag.writeToParcel(dest, 0);
                cur.tagsFirstOccurrence = true;
            }
        }
        if (computeStepDetails) {
            if (this.mPlatformIdleStateCallback != null) {
                this.mCurHistoryStepDetails.statSubsystemPowerState = this.mPlatformIdleStateCallback.getSubsystemLowPowerStats();
            }
            this.computeHistoryStepDetails(this.mCurHistoryStepDetails, this.mLastHistoryStepDetails);
            if (includeStepDetails != 0) {
                this.mCurHistoryStepDetails.writeToParcel(dest);
            }
            cur.stepDetails = this.mCurHistoryStepDetails;
            this.mLastHistoryStepDetails = this.mCurHistoryStepDetails;
        } else {
            cur.stepDetails = null;
        }
        if (this.mLastHistoryStepLevel < cur.batteryLevel) {
            this.mLastHistoryStepDetails = null;
        }
        this.mLastHistoryStepLevel = cur.batteryLevel;
        if (batteryChargeChanged) {
            dest.writeInt(cur.batteryChargeUah);
        }
        dest.writeDouble(cur.modemRailChargeMah);
        dest.writeDouble(cur.wifiRailChargeMah);
    }

    private int buildBatteryLevelInt(BatteryStats.HistoryItem h) {
        return h.batteryLevel << 25 & 0xFE000000 | h.batteryTemperature << 15 & 0x1FF8000 | h.batteryVoltage << 1 & 0x7FFE;
    }

    private void readBatteryLevelInt(int batteryLevelInt, BatteryStats.HistoryItem out) {
        out.batteryLevel = (byte)((batteryLevelInt & 0xFE000000) >>> 25);
        out.batteryTemperature = (short)((batteryLevelInt & 0x1FF8000) >>> 15);
        out.batteryVoltage = (char)((batteryLevelInt & 0x7FFE) >>> 1);
    }

    private int buildStateInt(BatteryStats.HistoryItem h) {
        int plugType = 0;
        if ((h.batteryPlugType & 1) != 0) {
            plugType = 1;
        } else if ((h.batteryPlugType & 2) != 0) {
            plugType = 2;
        } else if ((h.batteryPlugType & 4) != 0) {
            plugType = 3;
        }
        return (h.batteryStatus & 7) << 29 | (h.batteryHealth & 7) << 26 | (plugType & 3) << 24 | h.states & 0xFFFFFF;
    }

    private void computeHistoryStepDetails(BatteryStats.HistoryStepDetails out, BatteryStats.HistoryStepDetails last) {
        BatteryStats.HistoryStepDetails tmp = last != null ? this.mTmpHistoryStepDetails : out;
        this.requestImmediateCpuUpdate();
        if (last == null) {
            int NU = this.mUidStats.size();
            for (int i = 0; i < NU; ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.mLastStepUserTimeMs = uid.mCurStepUserTimeMs;
                uid.mLastStepSystemTimeMs = uid.mCurStepSystemTimeMs;
            }
            this.mLastStepCpuUserTimeMs = this.mCurStepCpuUserTimeMs;
            this.mLastStepCpuSystemTimeMs = this.mCurStepCpuSystemTimeMs;
            this.mLastStepStatUserTimeMs = this.mCurStepStatUserTimeMs;
            this.mLastStepStatSystemTimeMs = this.mCurStepStatSystemTimeMs;
            this.mLastStepStatIOWaitTimeMs = this.mCurStepStatIOWaitTimeMs;
            this.mLastStepStatIrqTimeMs = this.mCurStepStatIrqTimeMs;
            this.mLastStepStatSoftIrqTimeMs = this.mCurStepStatSoftIrqTimeMs;
            this.mLastStepStatIdleTimeMs = this.mCurStepStatIdleTimeMs;
            tmp.clear();
            return;
        }
        out.userTime = (int)(this.mCurStepCpuUserTimeMs - this.mLastStepCpuUserTimeMs);
        out.systemTime = (int)(this.mCurStepCpuSystemTimeMs - this.mLastStepCpuSystemTimeMs);
        out.statUserTime = (int)(this.mCurStepStatUserTimeMs - this.mLastStepStatUserTimeMs);
        out.statSystemTime = (int)(this.mCurStepStatSystemTimeMs - this.mLastStepStatSystemTimeMs);
        out.statIOWaitTime = (int)(this.mCurStepStatIOWaitTimeMs - this.mLastStepStatIOWaitTimeMs);
        out.statIrqTime = (int)(this.mCurStepStatIrqTimeMs - this.mLastStepStatIrqTimeMs);
        out.statSoftIrqTime = (int)(this.mCurStepStatSoftIrqTimeMs - this.mLastStepStatSoftIrqTimeMs);
        out.statIdlTime = (int)(this.mCurStepStatIdleTimeMs - this.mLastStepStatIdleTimeMs);
        out.appCpuUid3 = -1;
        out.appCpuUid2 = -1;
        out.appCpuUid1 = -1;
        out.appCpuUTime3 = 0;
        out.appCpuUTime2 = 0;
        out.appCpuUTime1 = 0;
        out.appCpuSTime3 = 0;
        out.appCpuSTime2 = 0;
        out.appCpuSTime1 = 0;
        int NU = this.mUidStats.size();
        for (int i = 0; i < NU; ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            int totalUTimeMs = (int)(uid.mCurStepUserTimeMs - uid.mLastStepUserTimeMs);
            int totalSTimeMs = (int)(uid.mCurStepSystemTimeMs - uid.mLastStepSystemTimeMs);
            int totalTimeMs = totalUTimeMs + totalSTimeMs;
            uid.mLastStepUserTimeMs = uid.mCurStepUserTimeMs;
            uid.mLastStepSystemTimeMs = uid.mCurStepSystemTimeMs;
            if (totalTimeMs <= out.appCpuUTime3 + out.appCpuSTime3) continue;
            if (totalTimeMs <= out.appCpuUTime2 + out.appCpuSTime2) {
                out.appCpuUid3 = uid.mUid;
                out.appCpuUTime3 = totalUTimeMs;
                out.appCpuSTime3 = totalSTimeMs;
                continue;
            }
            out.appCpuUid3 = out.appCpuUid2;
            out.appCpuUTime3 = out.appCpuUTime2;
            out.appCpuSTime3 = out.appCpuSTime2;
            if (totalTimeMs <= out.appCpuUTime1 + out.appCpuSTime1) {
                out.appCpuUid2 = uid.mUid;
                out.appCpuUTime2 = totalUTimeMs;
                out.appCpuSTime2 = totalSTimeMs;
                continue;
            }
            out.appCpuUid2 = out.appCpuUid1;
            out.appCpuUTime2 = out.appCpuUTime1;
            out.appCpuSTime2 = out.appCpuSTime1;
            out.appCpuUid1 = uid.mUid;
            out.appCpuUTime1 = totalUTimeMs;
            out.appCpuSTime1 = totalSTimeMs;
        }
        this.mLastStepCpuUserTimeMs = this.mCurStepCpuUserTimeMs;
        this.mLastStepCpuSystemTimeMs = this.mCurStepCpuSystemTimeMs;
        this.mLastStepStatUserTimeMs = this.mCurStepStatUserTimeMs;
        this.mLastStepStatSystemTimeMs = this.mCurStepStatSystemTimeMs;
        this.mLastStepStatIOWaitTimeMs = this.mCurStepStatIOWaitTimeMs;
        this.mLastStepStatIrqTimeMs = this.mCurStepStatIrqTimeMs;
        this.mLastStepStatSoftIrqTimeMs = this.mCurStepStatSoftIrqTimeMs;
        this.mLastStepStatIdleTimeMs = this.mCurStepStatIdleTimeMs;
    }

    @Override
    @GuardedBy(value={"this"})
    public void commitCurrentHistoryBatchLocked() {
        this.mHistoryLastWritten.cmd = (byte)-1;
    }

    @GuardedBy(value={"this"})
    public void createFakeHistoryEvents(long numEvents) {
        long elapsedRealtimeMs = this.mClock.elapsedRealtime();
        long uptimeMs = this.mClock.uptimeMillis();
        for (long i = 0L; i < numEvents; ++i) {
            this.noteLongPartialWakelockStart("name1", "historyName1", 1000, elapsedRealtimeMs, uptimeMs);
            this.noteLongPartialWakelockFinish("name1", "historyName1", 1000, elapsedRealtimeMs, uptimeMs);
        }
    }

    @GuardedBy(value={"this"})
    void addHistoryBufferLocked(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur) {
        int dataSize;
        if (!this.mHaveBatteryLevel || !this.mRecordingHistory) {
            return;
        }
        long timeDiffMs = this.mHistoryBaseTimeMs + elapsedRealtimeMs - this.mHistoryLastWritten.time;
        int diffStates = this.mHistoryLastWritten.states ^ cur.states & this.mActiveHistoryStates;
        int diffStates2 = this.mHistoryLastWritten.states2 ^ cur.states2 & this.mActiveHistoryStates2;
        int lastDiffStates = this.mHistoryLastWritten.states ^ this.mHistoryLastLastWritten.states;
        int lastDiffStates2 = this.mHistoryLastWritten.states2 ^ this.mHistoryLastLastWritten.states2;
        if (!(this.mHistoryBufferLastPos < 0 || this.mHistoryLastWritten.cmd != 0 || timeDiffMs >= 1000L || (diffStates & lastDiffStates) != 0 || (diffStates2 & lastDiffStates2) != 0 || this.mHistoryLastWritten.tagsFirstOccurrence || cur.tagsFirstOccurrence || this.mHistoryLastWritten.wakelockTag != null && cur.wakelockTag != null || this.mHistoryLastWritten.wakeReasonTag != null && cur.wakeReasonTag != null || this.mHistoryLastWritten.stepDetails != null || this.mHistoryLastWritten.eventCode != 0 && cur.eventCode != 0 || this.mHistoryLastWritten.batteryLevel != cur.batteryLevel || this.mHistoryLastWritten.batteryStatus != cur.batteryStatus || this.mHistoryLastWritten.batteryHealth != cur.batteryHealth || this.mHistoryLastWritten.batteryPlugType != cur.batteryPlugType || this.mHistoryLastWritten.batteryTemperature != cur.batteryTemperature || this.mHistoryLastWritten.batteryVoltage != cur.batteryVoltage)) {
            this.mHistoryBuffer.setDataSize(this.mHistoryBufferLastPos);
            this.mHistoryBuffer.setDataPosition(this.mHistoryBufferLastPos);
            this.mHistoryBufferLastPos = -1;
            elapsedRealtimeMs = this.mHistoryLastWritten.time - this.mHistoryBaseTimeMs;
            if (this.mHistoryLastWritten.wakelockTag != null) {
                cur.wakelockTag = cur.localWakelockTag;
                cur.wakelockTag.setTo(this.mHistoryLastWritten.wakelockTag);
            }
            if (this.mHistoryLastWritten.wakeReasonTag != null) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                cur.wakeReasonTag.setTo(this.mHistoryLastWritten.wakeReasonTag);
            }
            if (this.mHistoryLastWritten.eventCode != 0) {
                cur.eventCode = this.mHistoryLastWritten.eventCode;
                cur.eventTag = cur.localEventTag;
                cur.eventTag.setTo(this.mHistoryLastWritten.eventTag);
            }
            this.mHistoryLastWritten.setTo(this.mHistoryLastLastWritten);
        }
        if ((dataSize = this.mHistoryBuffer.dataSize()) >= this.mConstants.MAX_HISTORY_BUFFER) {
            long start = SystemClock.uptimeMillis();
            this.writeHistoryLocked(true);
            this.mBatteryStatsHistory.startNextFile();
            this.mHistoryBuffer.setDataSize(0);
            this.mHistoryBuffer.setDataPosition(0);
            this.mHistoryBuffer.setDataCapacity(this.mConstants.MAX_HISTORY_BUFFER / 2);
            this.mHistoryBufferLastPos = -1;
            this.mHistoryLastWritten.clear();
            this.mHistoryLastLastWritten.clear();
            for (Map.Entry<BatteryStats.HistoryTag, Integer> entry : this.mHistoryTagPool.entrySet()) {
                entry.setValue(entry.getValue() | 0x8000);
            }
            BatteryStats.HistoryItem copy = new BatteryStats.HistoryItem();
            copy.setTo(cur);
            this.startRecordingHistory(elapsedRealtimeMs, uptimeMs, false);
            this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)0, copy);
            return;
        }
        if (dataSize == 0) {
            cur.currentTime = this.mClock.currentTimeMillis();
            this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)7, cur);
        }
        this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)0, cur);
    }

    @GuardedBy(value={"this"})
    private void addHistoryBufferLocked(long elapsedRealtimeMs, byte cmd, BatteryStats.HistoryItem cur) {
        if (this.mBatteryStatsHistoryIterator != null) {
            throw new IllegalStateException("Can't do this while iterating history!");
        }
        this.mHistoryBufferLastPos = this.mHistoryBuffer.dataPosition();
        this.mHistoryLastLastWritten.setTo(this.mHistoryLastWritten);
        boolean hasTags = this.mHistoryLastWritten.tagsFirstOccurrence || cur.tagsFirstOccurrence;
        this.mHistoryLastWritten.setTo(this.mHistoryBaseTimeMs + elapsedRealtimeMs, cmd, cur);
        this.mHistoryLastWritten.tagsFirstOccurrence = hasTags;
        this.mHistoryLastWritten.states &= this.mActiveHistoryStates;
        this.mHistoryLastWritten.states2 &= this.mActiveHistoryStates2;
        this.writeHistoryDelta(this.mHistoryBuffer, this.mHistoryLastWritten, this.mHistoryLastLastWritten);
        this.mLastHistoryElapsedRealtimeMs = elapsedRealtimeMs;
        cur.wakelockTag = null;
        cur.wakeReasonTag = null;
        cur.eventCode = 0;
        cur.eventTag = null;
        cur.tagsFirstOccurrence = false;
    }

    @GuardedBy(value={"this"})
    void addHistoryRecordLocked(long elapsedRealtimeMs, long uptimeMs) {
        long diffElapsedMs;
        long diffUptimeMs;
        if (this.mTrackRunningHistoryElapsedRealtimeMs != 0L && (diffUptimeMs = uptimeMs - this.mTrackRunningHistoryUptimeMs) < (diffElapsedMs = elapsedRealtimeMs - this.mTrackRunningHistoryElapsedRealtimeMs) - 20L) {
            long wakeElapsedTimeMs = elapsedRealtimeMs - (diffElapsedMs - diffUptimeMs);
            this.mHistoryAddTmp.setTo(this.mHistoryLastWritten);
            this.mHistoryAddTmp.wakelockTag = null;
            this.mHistoryAddTmp.wakeReasonTag = null;
            this.mHistoryAddTmp.eventCode = 0;
            this.mHistoryAddTmp.states &= Integer.MAX_VALUE;
            this.addHistoryRecordInnerLocked(wakeElapsedTimeMs, uptimeMs, this.mHistoryAddTmp);
        }
        this.mHistoryCur.states |= Integer.MIN_VALUE;
        this.mTrackRunningHistoryElapsedRealtimeMs = elapsedRealtimeMs;
        this.mTrackRunningHistoryUptimeMs = uptimeMs;
        this.addHistoryRecordInnerLocked(elapsedRealtimeMs, uptimeMs, this.mHistoryCur);
    }

    @GuardedBy(value={"this"})
    void addHistoryRecordInnerLocked(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur) {
        this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, cur);
    }

    @GuardedBy(value={"this"})
    public void addHistoryEventLocked(long elapsedRealtimeMs, long uptimeMs, int code, String name, int uid) {
        this.mHistoryCur.eventCode = code;
        this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
        this.mHistoryCur.eventTag.string = name;
        this.mHistoryCur.eventTag.uid = uid;
        this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    void addHistoryRecordLocked(long elapsedRealtimeMs, long uptimeMs, byte cmd, BatteryStats.HistoryItem cur) {
        BatteryStats.HistoryItem rec = this.mHistoryCache;
        if (rec != null) {
            this.mHistoryCache = rec.next;
        } else {
            rec = new BatteryStats.HistoryItem();
        }
        rec.setTo(this.mHistoryBaseTimeMs + elapsedRealtimeMs, cmd, cur);
        this.addHistoryRecordLocked(rec);
    }

    @GuardedBy(value={"this"})
    void addHistoryRecordLocked(BatteryStats.HistoryItem rec) {
        ++this.mNumHistoryItems;
        rec.next = null;
        this.mHistoryLastEnd = this.mHistoryEnd;
        if (this.mHistoryEnd != null) {
            this.mHistoryEnd.next = rec;
            this.mHistoryEnd = rec;
        } else {
            this.mHistory = this.mHistoryEnd = rec;
        }
    }

    @GuardedBy(value={"this"})
    void clearHistoryLocked() {
        this.mHistoryBaseTimeMs = 0L;
        this.mLastHistoryElapsedRealtimeMs = 0L;
        this.mTrackRunningHistoryElapsedRealtimeMs = 0L;
        this.mTrackRunningHistoryUptimeMs = 0L;
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryBuffer.setDataCapacity(this.mConstants.MAX_HISTORY_BUFFER / 2);
        this.mHistoryLastLastWritten.clear();
        this.mHistoryLastWritten.clear();
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
        this.mActiveHistoryStates = -1;
        this.mActiveHistoryStates2 = -1;
    }

    @GuardedBy(value={"this"})
    public void updateTimeBasesLocked(boolean unplugged, int screenState, long uptimeUs, long realtimeUs) {
        boolean updateOnBatteryScreenOffTimeBase;
        boolean screenOff = !Display.isOnState(screenState);
        boolean updateOnBatteryTimeBase = unplugged != this.mOnBatteryTimeBase.isRunning();
        boolean bl = updateOnBatteryScreenOffTimeBase = (unplugged && screenOff) != this.mOnBatteryScreenOffTimeBase.isRunning();
        if (updateOnBatteryScreenOffTimeBase || updateOnBatteryTimeBase) {
            int i;
            if (updateOnBatteryScreenOffTimeBase) {
                this.updateKernelWakelocksLocked(realtimeUs);
                this.updateBatteryPropertiesLocked();
            }
            if (updateOnBatteryTimeBase) {
                this.updateRpmStatsLocked(realtimeUs);
            }
            this.mOnBatteryTimeBase.setRunning(unplugged, uptimeUs, realtimeUs);
            if (updateOnBatteryTimeBase) {
                for (i = this.mUidStats.size() - 1; i >= 0; --i) {
                    this.mUidStats.valueAt(i).updateOnBatteryBgTimeBase(uptimeUs, realtimeUs);
                }
            }
            if (updateOnBatteryScreenOffTimeBase) {
                this.mOnBatteryScreenOffTimeBase.setRunning(unplugged && screenOff, uptimeUs, realtimeUs);
                for (i = this.mUidStats.size() - 1; i >= 0; --i) {
                    this.mUidStats.valueAt(i).updateOnBatteryScreenOffBgTimeBase(uptimeUs, realtimeUs);
                }
            }
        }
    }

    @GuardedBy(value={"this"})
    private void updateBatteryPropertiesLocked() {
        try {
            IBatteryPropertiesRegistrar registrar = IBatteryPropertiesRegistrar.Stub.asInterface(ServiceManager.getService("batteryproperties"));
            if (registrar != null) {
                registrar.scheduleUpdate();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @GuardedBy(value={"this"})
    public void addIsolatedUidLocked(int isolatedUid, int appUid) {
        this.addIsolatedUidLocked(isolatedUid, appUid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void addIsolatedUidLocked(int isolatedUid, int appUid, long elapsedRealtimeMs, long uptimeMs) {
        this.mIsolatedUids.put(isolatedUid, appUid);
        this.mIsolatedUidRefCounts.put(isolatedUid, 1);
        Uid u = this.getUidStatsLocked(appUid, elapsedRealtimeMs, uptimeMs);
        u.addIsolatedUid(isolatedUid);
    }

    public void scheduleRemoveIsolatedUidLocked(int isolatedUid, int appUid) {
        int curUid = this.mIsolatedUids.get(isolatedUid, -1);
        if (curUid == appUid && this.mExternalSync != null) {
            this.mExternalSync.scheduleCpuSyncDueToRemovedUid(isolatedUid);
        }
    }

    @GuardedBy(value={"this"})
    public boolean maybeRemoveIsolatedUidLocked(int isolatedUid, long elapsedRealtimeMs, long uptimeMs) {
        int refCount = this.mIsolatedUidRefCounts.get(isolatedUid, 0) - 1;
        if (refCount > 0) {
            this.mIsolatedUidRefCounts.put(isolatedUid, refCount);
            return false;
        }
        int idx = this.mIsolatedUids.indexOfKey(isolatedUid);
        if (idx >= 0) {
            int ownerUid = this.mIsolatedUids.valueAt(idx);
            Uid u = this.getUidStatsLocked(ownerUid, elapsedRealtimeMs, uptimeMs);
            u.removeIsolatedUid(isolatedUid);
            this.mIsolatedUids.removeAt(idx);
            this.mIsolatedUidRefCounts.delete(isolatedUid);
        } else {
            Slog.w(TAG, "Attempted to remove untracked isolated uid (" + isolatedUid + ")");
        }
        this.mPendingRemovedUids.add(new UidToRemove(isolatedUid, elapsedRealtimeMs));
        return true;
    }

    public void incrementIsolatedUidRefCount(int uid) {
        int refCount = this.mIsolatedUidRefCounts.get(uid, 0);
        if (refCount <= 0) {
            Slog.w(TAG, "Attempted to increment ref counted of untracked isolated uid (" + uid + ")");
            return;
        }
        this.mIsolatedUidRefCounts.put(uid, refCount + 1);
    }

    private int mapUid(int uid) {
        if (Process.isSdkSandboxUid(uid)) {
            return Process.getAppUidForSdkSandboxUid(uid);
        }
        return this.mapIsolatedUid(uid);
    }

    private int mapIsolatedUid(int uid) {
        return this.mIsolatedUids.get(uid, uid);
    }

    @GuardedBy(value={"this"})
    public void noteEventLocked(int code, String name, int uid) {
        this.noteEventLocked(code, name, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteEventLocked(int code, String name, int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (!this.mActiveEvents.updateState(code, name, uid = this.mapUid(uid), 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, code, name, uid);
    }

    @GuardedBy(value={"this"})
    public void noteCurrentTimeChangedLocked() {
        long currentTime = this.mClock.currentTimeMillis();
        long elapsedRealtime = this.mClock.elapsedRealtime();
        long uptime = this.mClock.uptimeMillis();
        this.noteCurrentTimeChangedLocked(currentTime, elapsedRealtime, uptime);
    }

    @GuardedBy(value={"this"})
    public void noteCurrentTimeChangedLocked(long currentTimeMs, long elapsedRealtimeMs, long uptimeMs) {
        this.recordCurrentTimeChangeLocked(currentTimeMs, elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteProcessStartLocked(String name, int uid) {
        this.noteProcessStartLocked(name, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteProcessStartLocked(String name, int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs);
            u.getProcessStatsLocked(name).incStartsLocked();
        }
        if (!this.mActiveEvents.updateState(32769, name, uid, 0)) {
            return;
        }
        if (!this.mRecordAllHistory) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 32769, name, uid);
    }

    @GuardedBy(value={"this"})
    public void noteProcessCrashLocked(String name, int uid) {
        this.noteProcessCrashLocked(name, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteProcessCrashLocked(String name, int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs);
            u.getProcessStatsLocked(name).incNumCrashesLocked();
        }
    }

    @GuardedBy(value={"this"})
    public void noteProcessAnrLocked(String name, int uid) {
        this.noteProcessAnrLocked(name, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteProcessAnrLocked(String name, int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs);
            u.getProcessStatsLocked(name).incNumAnrsLocked();
        }
    }

    @GuardedBy(value={"this"})
    public void noteUidProcessStateLocked(int uid, int state) {
        this.noteUidProcessStateLocked(uid, state, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteUidProcessStateLocked(int uid, int state, long elapsedRealtimeMs, long uptimeMs) {
        int parentUid = this.mapUid(uid);
        if (uid != parentUid && Process.isIsolated(uid)) {
            return;
        }
        FrameworkStatsLog.write(27, uid, ActivityManager.processStateAmToProto(state));
        this.getUidStatsLocked(parentUid, elapsedRealtimeMs, uptimeMs).updateUidProcessStateLocked(state, elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteProcessFinishLocked(String name, int uid) {
        this.noteProcessFinishLocked(name, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteProcessFinishLocked(String name, int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (!this.mActiveEvents.updateState(16385, name, uid = this.mapUid(uid), 0)) {
            return;
        }
        if (!this.mRecordAllHistory) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 16385, name, uid);
    }

    @GuardedBy(value={"this"})
    public void noteSyncStartLocked(String name, int uid) {
        this.noteSyncStartLocked(name, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteSyncStartLocked(String name, int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteStartSyncLocked(name, elapsedRealtimeMs);
        if (!this.mActiveEvents.updateState(32772, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 32772, name, uid);
    }

    @GuardedBy(value={"this"})
    public void noteSyncFinishLocked(String name, int uid) {
        this.noteSyncFinishLocked(name, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteSyncFinishLocked(String name, int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteStopSyncLocked(name, elapsedRealtimeMs);
        if (!this.mActiveEvents.updateState(16388, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 16388, name, uid);
    }

    @GuardedBy(value={"this"})
    public void noteJobStartLocked(String name, int uid) {
        this.noteJobStartLocked(name, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteJobStartLocked(String name, int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteStartJobLocked(name, elapsedRealtimeMs);
        if (!this.mActiveEvents.updateState(32774, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 32774, name, uid);
    }

    @GuardedBy(value={"this"})
    public void noteJobFinishLocked(String name, int uid, int stopReason) {
        this.noteJobFinishLocked(name, uid, stopReason, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteJobFinishLocked(String name, int uid, int stopReason, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteStopJobLocked(name, elapsedRealtimeMs, stopReason);
        if (!this.mActiveEvents.updateState(16390, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 16390, name, uid);
    }

    @GuardedBy(value={"this"})
    public void noteJobsDeferredLocked(int uid, int numDeferred, long sinceLast) {
        this.noteJobsDeferredLocked(uid, numDeferred, sinceLast, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteJobsDeferredLocked(int uid, int numDeferred, long sinceLast, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteJobsDeferredLocked(numDeferred, sinceLast);
    }

    @GuardedBy(value={"this"})
    public void noteAlarmStartLocked(String name, WorkSource workSource, int uid) {
        this.noteAlarmStartLocked(name, workSource, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteAlarmStartLocked(String name, WorkSource workSource, int uid, long elapsedRealtimeMs, long uptimeMs) {
        this.noteAlarmStartOrFinishLocked(32781, name, workSource, uid, elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteAlarmFinishLocked(String name, WorkSource workSource, int uid) {
        this.noteAlarmFinishLocked(name, workSource, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteAlarmFinishLocked(String name, WorkSource workSource, int uid, long elapsedRealtimeMs, long uptimeMs) {
        this.noteAlarmStartOrFinishLocked(16397, name, workSource, uid, elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    private void noteAlarmStartOrFinishLocked(int historyItem, String name, WorkSource workSource, int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (!this.mRecordAllHistory) {
            return;
        }
        if (workSource != null) {
            for (int i = 0; i < workSource.size(); ++i) {
                uid = this.mapUid(workSource.getUid(i));
                if (!this.mActiveEvents.updateState(historyItem, name, uid, 0)) continue;
                this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, historyItem, name, uid);
            }
            List<WorkSource.WorkChain> workChains = workSource.getWorkChains();
            if (workChains != null) {
                for (int i = 0; i < workChains.size(); ++i) {
                    uid = this.mapUid(workChains.get(i).getAttributionUid());
                    if (!this.mActiveEvents.updateState(historyItem, name, uid, 0)) continue;
                    this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, historyItem, name, uid);
                }
            }
        } else if (this.mActiveEvents.updateState(historyItem, name, uid = this.mapUid(uid), 0)) {
            this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, historyItem, name, uid);
        }
    }

    @GuardedBy(value={"this"})
    public void noteWakupAlarmLocked(String packageName, int uid, WorkSource workSource, String tag) {
        this.noteWakupAlarmLocked(packageName, uid, workSource, tag, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWakupAlarmLocked(String packageName, int uid, WorkSource workSource, String tag, long elapsedRealtimeMs, long uptimeMs) {
        if (workSource != null) {
            for (int i = 0; i < workSource.size(); ++i) {
                uid = workSource.getUid(i);
                String workSourceName = workSource.getPackageName(i);
                if (!this.isOnBattery()) continue;
                Uid.Pkg pkg = this.getPackageStatsLocked(uid, workSourceName != null ? workSourceName : packageName, elapsedRealtimeMs, uptimeMs);
                pkg.noteWakeupAlarmLocked(tag);
            }
            List<WorkSource.WorkChain> workChains = workSource.getWorkChains();
            if (workChains != null) {
                for (int i = 0; i < workChains.size(); ++i) {
                    WorkSource.WorkChain wc = workChains.get(i);
                    uid = wc.getAttributionUid();
                    if (!this.isOnBattery()) continue;
                    Uid.Pkg pkg = this.getPackageStatsLocked(uid, packageName, elapsedRealtimeMs, uptimeMs);
                    pkg.noteWakeupAlarmLocked(tag);
                }
            }
        } else if (this.isOnBattery()) {
            Uid.Pkg pkg = this.getPackageStatsLocked(uid, packageName, elapsedRealtimeMs, uptimeMs);
            pkg.noteWakeupAlarmLocked(tag);
        }
    }

    private void requestWakelockCpuUpdate() {
        this.mExternalSync.scheduleCpuSyncDueToWakelockChange(60000L);
    }

    private void requestImmediateCpuUpdate() {
        this.mExternalSync.scheduleCpuSyncDueToWakelockChange(0L);
    }

    @GuardedBy(value={"this"})
    public void setRecordAllHistoryLocked(boolean enabled) {
        block6: {
            block5: {
                this.mRecordAllHistory = enabled;
                if (enabled) break block5;
                this.mActiveEvents.removeEvents(5);
                this.mActiveEvents.removeEvents(13);
                HashMap<String, SparseIntArray> active = this.mActiveEvents.getStateForEvent(1);
                if (active == null) break block6;
                long mSecRealtime = this.mClock.elapsedRealtime();
                long mSecUptime = this.mClock.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                    SparseIntArray uids = ent.getValue();
                    for (int j = 0; j < uids.size(); ++j) {
                        this.addHistoryEventLocked(mSecRealtime, mSecUptime, 16385, ent.getKey(), uids.keyAt(j));
                    }
                }
                break block6;
            }
            HashMap<String, SparseIntArray> active = this.mActiveEvents.getStateForEvent(1);
            if (active != null) {
                long mSecRealtime = this.mClock.elapsedRealtime();
                long mSecUptime = this.mClock.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                    SparseIntArray uids = ent.getValue();
                    for (int j = 0; j < uids.size(); ++j) {
                        this.addHistoryEventLocked(mSecRealtime, mSecUptime, 32769, ent.getKey(), uids.keyAt(j));
                    }
                }
            }
        }
    }

    public void setNoAutoReset(boolean enabled) {
        this.mNoAutoReset = enabled;
    }

    @GuardedBy(value={"this"})
    public void setPretendScreenOff(boolean pretendScreenOff) {
        if (this.mPretendScreenOff != pretendScreenOff) {
            this.mPretendScreenOff = pretendScreenOff;
            int primaryScreenState = this.mPerDisplayBatteryStats[0].screenState;
            this.noteScreenStateLocked(0, primaryScreenState, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis(), this.mClock.currentTimeMillis());
        }
    }

    @GuardedBy(value={"this"})
    public void noteStartWakeLocked(int uid, int pid, WorkSource.WorkChain wc, String name, String historyName, int type, boolean unimportantForLogging) {
        this.noteStartWakeLocked(uid, pid, wc, name, historyName, type, unimportantForLogging, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteStartWakeLocked(int uid, int pid, WorkSource.WorkChain wc, String name, String historyName, int type, boolean unimportantForLogging, long elapsedRealtimeMs, long uptimeMs) {
        int mappedUid = this.mapUid(uid);
        if (type == 0) {
            this.aggregateLastWakeupUptimeLocked(elapsedRealtimeMs, uptimeMs);
            if (historyName == null) {
                historyName = name;
            }
            if (this.mRecordAllHistory && this.mActiveEvents.updateState(32773, historyName, mappedUid, 0)) {
                this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 32773, historyName, mappedUid);
            }
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states |= 0x40000000;
                this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                this.mHistoryCur.wakelockTag.string = this.mInitialAcquireWakeName = historyName;
                this.mHistoryCur.wakelockTag.uid = this.mInitialAcquireWakeUid = mappedUid;
                this.mWakeLockImportant = !unimportantForLogging;
                this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            } else if (!this.mWakeLockImportant && !unimportantForLogging && this.mHistoryLastWritten.cmd == 0) {
                if (this.mHistoryLastWritten.wakelockTag != null) {
                    this.mHistoryLastWritten.wakelockTag = null;
                    this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                    this.mHistoryCur.wakelockTag.string = this.mInitialAcquireWakeName = historyName;
                    this.mHistoryCur.wakelockTag.uid = this.mInitialAcquireWakeUid = mappedUid;
                    this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
                }
                this.mWakeLockImportant = true;
            }
            ++this.mWakeLockNesting;
        }
        if (mappedUid >= 0) {
            if (mappedUid != uid) {
                this.incrementIsolatedUidRefCount(uid);
            }
            if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
                this.requestWakelockCpuUpdate();
            }
            this.getUidStatsLocked(mappedUid, elapsedRealtimeMs, uptimeMs).noteStartWakeLocked(pid, name, type, elapsedRealtimeMs);
            if (wc != null) {
                FrameworkStatsLog.write(10, wc.getUids(), wc.getTags(), this.getPowerManagerWakeLockLevel(type), name, 1);
            } else {
                FrameworkStatsLog.write_non_chained(10, this.mapIsolatedUid(uid), null, this.getPowerManagerWakeLockLevel(type), name, 1);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteStopWakeLocked(int uid, int pid, WorkSource.WorkChain wc, String name, String historyName, int type) {
        this.noteStopWakeLocked(uid, pid, wc, name, historyName, type, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteStopWakeLocked(int uid, int pid, WorkSource.WorkChain wc, String name, String historyName, int type, long elapsedRealtimeMs, long uptimeMs) {
        int mappedUid = this.mapUid(uid);
        if (type == 0) {
            --this.mWakeLockNesting;
            if (this.mRecordAllHistory) {
                if (historyName == null) {
                    historyName = name;
                }
                if (this.mActiveEvents.updateState(16389, historyName, mappedUid, 0)) {
                    this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 16389, historyName, mappedUid);
                }
            }
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states &= 0xBFFFFFFF;
                this.mInitialAcquireWakeName = null;
                this.mInitialAcquireWakeUid = -1;
                this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            }
        }
        if (mappedUid >= 0) {
            if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
                this.requestWakelockCpuUpdate();
            }
            this.getUidStatsLocked(mappedUid, elapsedRealtimeMs, uptimeMs).noteStopWakeLocked(pid, name, type, elapsedRealtimeMs);
            if (wc != null) {
                FrameworkStatsLog.write(10, wc.getUids(), wc.getTags(), this.getPowerManagerWakeLockLevel(type), name, 0);
            } else {
                FrameworkStatsLog.write_non_chained(10, this.mapIsolatedUid(uid), null, this.getPowerManagerWakeLockLevel(type), name, 0);
            }
            if (mappedUid != uid) {
                this.maybeRemoveIsolatedUidLocked(uid, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    private int getPowerManagerWakeLockLevel(int battertStatsWakelockType) {
        switch (battertStatsWakelockType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 26;
            }
            case 18: {
                return 128;
            }
            case 2: {
                Slog.e(TAG, "Illegal window wakelock type observed in batterystats.");
                return -1;
            }
        }
        Slog.e(TAG, "Illegal wakelock type in batterystats: " + battertStatsWakelockType);
        return -1;
    }

    @GuardedBy(value={"this"})
    public void noteStartWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        this.noteStartWakeFromSourceLocked(ws, pid, name, historyName, type, unimportantForLogging, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteStartWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStartWakeLocked(ws.getUid(i), pid, null, name, historyName, type, unimportantForLogging, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> wcs = ws.getWorkChains();
        if (wcs != null) {
            for (int i = 0; i < wcs.size(); ++i) {
                WorkSource.WorkChain wc = wcs.get(i);
                this.noteStartWakeLocked(wc.getAttributionUid(), pid, wc, name, historyName, type, unimportantForLogging, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteChangeWakelockFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) {
        this.noteChangeWakelockFromSourceLocked(ws, pid, name, historyName, type, newWs, newPid, newName, newHistoryName, newType, newUnimportantForLogging, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteChangeWakelockFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging, long elapsedRealtimeMs, long uptimeMs) {
        ArrayList<WorkSource.WorkChain> goneChains;
        int i;
        ArrayList<WorkSource.WorkChain> newChains;
        ArrayList<WorkSource.WorkChain>[] wcs = WorkSource.diffChains(ws, newWs);
        int NN = newWs.size();
        for (int i2 = 0; i2 < NN; ++i2) {
            this.noteStartWakeLocked(newWs.getUid(i2), newPid, null, newName, newHistoryName, newType, newUnimportantForLogging, elapsedRealtimeMs, uptimeMs);
        }
        if (wcs != null && (newChains = wcs[0]) != null) {
            for (i = 0; i < newChains.size(); ++i) {
                WorkSource.WorkChain newChain = (WorkSource.WorkChain)newChains.get(i);
                this.noteStartWakeLocked(newChain.getAttributionUid(), newPid, newChain, newName, newHistoryName, newType, newUnimportantForLogging, elapsedRealtimeMs, uptimeMs);
            }
        }
        int NO = ws.size();
        for (i = 0; i < NO; ++i) {
            this.noteStopWakeLocked(ws.getUid(i), pid, null, name, historyName, type, elapsedRealtimeMs, uptimeMs);
        }
        if (wcs != null && (goneChains = wcs[1]) != null) {
            for (int i3 = 0; i3 < goneChains.size(); ++i3) {
                WorkSource.WorkChain goneChain = (WorkSource.WorkChain)goneChains.get(i3);
                this.noteStopWakeLocked(goneChain.getAttributionUid(), pid, goneChain, name, historyName, type, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteStopWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type) {
        this.noteStopWakeFromSourceLocked(ws, pid, name, historyName, type, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteStopWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStopWakeLocked(ws.getUid(i), pid, null, name, historyName, type, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> wcs = ws.getWorkChains();
        if (wcs != null) {
            for (int i = 0; i < wcs.size(); ++i) {
                WorkSource.WorkChain wc = wcs.get(i);
                this.noteStopWakeLocked(wc.getAttributionUid(), pid, wc, name, historyName, type, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteLongPartialWakelockStart(String name, String historyName, int uid) {
        this.noteLongPartialWakelockStart(name, historyName, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteLongPartialWakelockStart(String name, String historyName, int uid, long elapsedRealtimeMs, long uptimeMs) {
        this.noteLongPartialWakeLockStartInternal(name, historyName, uid, elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteLongPartialWakelockStartFromSource(String name, String historyName, WorkSource workSource) {
        this.noteLongPartialWakelockStartFromSource(name, historyName, workSource, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteLongPartialWakelockStartFromSource(String name, String historyName, WorkSource workSource, long elapsedRealtimeMs, long uptimeMs) {
        int N = workSource.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(workSource.getUid(i));
            this.noteLongPartialWakeLockStartInternal(name, historyName, uid, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = workSource.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = workChain.getAttributionUid();
                this.noteLongPartialWakeLockStartInternal(name, historyName, uid, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    private void noteLongPartialWakeLockStartInternal(String name, String historyName, int uid, long elapsedRealtimeMs, long uptimeMs) {
        int mappedUid = this.mapUid(uid);
        if (historyName == null) {
            historyName = name;
        }
        if (!this.mActiveEvents.updateState(32788, historyName, mappedUid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 32788, historyName, mappedUid);
        if (mappedUid != uid) {
            this.incrementIsolatedUidRefCount(uid);
        }
    }

    @GuardedBy(value={"this"})
    public void noteLongPartialWakelockFinish(String name, String historyName, int uid) {
        this.noteLongPartialWakelockFinish(name, historyName, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteLongPartialWakelockFinish(String name, String historyName, int uid, long elapsedRealtimeMs, long uptimeMs) {
        this.noteLongPartialWakeLockFinishInternal(name, historyName, uid, elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteLongPartialWakelockFinishFromSource(String name, String historyName, WorkSource workSource) {
        this.noteLongPartialWakelockFinishFromSource(name, historyName, workSource, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteLongPartialWakelockFinishFromSource(String name, String historyName, WorkSource workSource, long elapsedRealtimeMs, long uptimeMs) {
        int N = workSource.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(workSource.getUid(i));
            this.noteLongPartialWakeLockFinishInternal(name, historyName, uid, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = workSource.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = workChain.getAttributionUid();
                this.noteLongPartialWakeLockFinishInternal(name, historyName, uid, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    private void noteLongPartialWakeLockFinishInternal(String name, String historyName, int uid, long elapsedRealtimeMs, long uptimeMs) {
        int mappedUid = this.mapUid(uid);
        if (historyName == null) {
            historyName = name;
        }
        if (!this.mActiveEvents.updateState(16404, historyName, mappedUid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 16404, historyName, mappedUid);
        if (mappedUid != uid) {
            this.maybeRemoveIsolatedUidLocked(uid, elapsedRealtimeMs, uptimeMs);
        }
    }

    @GuardedBy(value={"this"})
    void aggregateLastWakeupUptimeLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mLastWakeupReason != null) {
            long deltaUptimeMs = uptimeMs - this.mLastWakeupUptimeMs;
            SamplingTimer timer = this.getWakeupReasonTimerLocked(this.mLastWakeupReason);
            timer.add(deltaUptimeMs * 1000L, 1, elapsedRealtimeMs);
            FrameworkStatsLog.write(36, this.mLastWakeupReason, deltaUptimeMs * 1000L);
            this.mLastWakeupReason = null;
        }
    }

    @GuardedBy(value={"this"})
    public void noteWakeupReasonLocked(String reason) {
        this.noteWakeupReasonLocked(reason, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWakeupReasonLocked(String reason, long elapsedRealtimeMs, long uptimeMs) {
        this.aggregateLastWakeupUptimeLocked(elapsedRealtimeMs, uptimeMs);
        this.mHistoryCur.wakeReasonTag = this.mHistoryCur.localWakeReasonTag;
        this.mHistoryCur.wakeReasonTag.string = reason;
        this.mHistoryCur.wakeReasonTag.uid = 0;
        this.mLastWakeupReason = reason;
        this.mLastWakeupUptimeMs = uptimeMs;
        this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    public boolean startAddingCpuLocked() {
        this.mExternalSync.cancelCpuSyncDueToWakelockChange();
        return this.mOnBatteryInternal;
    }

    @GuardedBy(value={"this"})
    public void finishAddingCpuLocked(int totalUTimeMs, int totalSTimeMs, int statUserTimeMs, int statSystemTimeMs, int statIOWaitTimeMs, int statIrqTimeMs, int statSoftIrqTimeMs, int statIdleTimeMs) {
        this.mCurStepCpuUserTimeMs += (long)totalUTimeMs;
        this.mCurStepCpuSystemTimeMs += (long)totalSTimeMs;
        this.mCurStepStatUserTimeMs += (long)statUserTimeMs;
        this.mCurStepStatSystemTimeMs += (long)statSystemTimeMs;
        this.mCurStepStatIOWaitTimeMs += (long)statIOWaitTimeMs;
        this.mCurStepStatIrqTimeMs += (long)statIrqTimeMs;
        this.mCurStepStatSoftIrqTimeMs += (long)statSoftIrqTimeMs;
        this.mCurStepStatIdleTimeMs += (long)statIdleTimeMs;
    }

    public void noteProcessDiedLocked(int uid, int pid) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.mPids.remove(pid);
        }
    }

    public long getProcessWakeTime(int uid, int pid, long realtimeMs) {
        BatteryStats.Uid.Pid p;
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null && (p = u.mPids.get(pid)) != null) {
            return p.mWakeSumMs + (p.mWakeNesting > 0 ? realtimeMs - p.mWakeStartMs : 0L);
        }
        return 0L;
    }

    public void reportExcessiveCpuLocked(int uid, String proc, long overTimeMs, long usedTimeMs) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.reportExcessiveCpuLocked(proc, overTimeMs, usedTimeMs);
        }
    }

    @GuardedBy(value={"this"})
    public void noteStartSensorLocked(int uid, int sensor) {
        this.noteStartSensorLocked(uid, sensor, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteStartSensorLocked(int uid, int sensor, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states |= 0x800000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
        ++this.mSensorNesting;
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteStartSensor(sensor, elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteStopSensorLocked(int uid, int sensor) {
        this.noteStopSensorLocked(uid, sensor, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteStopSensorLocked(int uid, int sensor, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        --this.mSensorNesting;
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states &= 0xFF7FFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteStopSensor(sensor, elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteGpsChangedLocked(WorkSource oldWs, WorkSource newWs) {
        this.noteGpsChangedLocked(oldWs, newWs, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteGpsChangedLocked(WorkSource oldWs, WorkSource newWs, long elapsedRealtimeMs, long uptimeMs) {
        int i;
        for (i = 0; i < newWs.size(); ++i) {
            this.noteStartGpsLocked(newWs.getUid(i), null, elapsedRealtimeMs, uptimeMs);
        }
        for (i = 0; i < oldWs.size(); ++i) {
            this.noteStopGpsLocked(oldWs.getUid(i), null, elapsedRealtimeMs, uptimeMs);
        }
        ArrayList<WorkSource.WorkChain>[] wcs = WorkSource.diffChains(oldWs, newWs);
        if (wcs != null) {
            int i2;
            if (wcs[0] != null) {
                ArrayList<WorkSource.WorkChain> newChains = wcs[0];
                for (i2 = 0; i2 < newChains.size(); ++i2) {
                    this.noteStartGpsLocked(-1, (WorkSource.WorkChain)newChains.get(i2), elapsedRealtimeMs, uptimeMs);
                }
            }
            if (wcs[1] != null) {
                ArrayList<WorkSource.WorkChain> goneChains = wcs[1];
                for (i2 = 0; i2 < goneChains.size(); ++i2) {
                    this.noteStopGpsLocked(-1, (WorkSource.WorkChain)goneChains.get(i2), elapsedRealtimeMs, uptimeMs);
                }
            }
        }
    }

    @GuardedBy(value={"this"})
    private void noteStartGpsLocked(int uid, WorkSource.WorkChain workChain, long elapsedRealtimeMs, long uptimeMs) {
        if (workChain != null) {
            uid = workChain.getAttributionUid();
        }
        int mappedUid = this.mapUid(uid);
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states |= 0x20000000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
        ++this.mGpsNesting;
        if (workChain == null) {
            FrameworkStatsLog.write_non_chained(6, this.mapIsolatedUid(uid), null, 1);
        } else {
            FrameworkStatsLog.write(6, workChain.getUids(), workChain.getTags(), 1);
        }
        this.getUidStatsLocked(mappedUid, elapsedRealtimeMs, uptimeMs).noteStartGps(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    private void noteStopGpsLocked(int uid, WorkSource.WorkChain workChain, long elapsedRealtimeMs, long uptimeMs) {
        if (workChain != null) {
            uid = workChain.getAttributionUid();
        }
        int mappedUid = this.mapUid(uid);
        --this.mGpsNesting;
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states &= 0xDFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.stopAllGpsSignalQualityTimersLocked(-1, elapsedRealtimeMs);
            this.mGpsSignalQualityBin = -1;
        }
        if (workChain == null) {
            FrameworkStatsLog.write_non_chained(6, this.mapIsolatedUid(uid), null, 0);
        } else {
            FrameworkStatsLog.write(6, workChain.getUids(), workChain.getTags(), 0);
        }
        this.getUidStatsLocked(mappedUid, elapsedRealtimeMs, uptimeMs).noteStopGps(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteGpsSignalQualityLocked(int signalLevel) {
        this.noteGpsSignalQualityLocked(signalLevel, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteGpsSignalQualityLocked(int signalLevel, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mGpsNesting == 0) {
            return;
        }
        if (signalLevel < 0 || signalLevel >= this.mGpsSignalQualityTimer.length) {
            this.stopAllGpsSignalQualityTimersLocked(-1, elapsedRealtimeMs);
            return;
        }
        if (this.mGpsSignalQualityBin != signalLevel) {
            if (this.mGpsSignalQualityBin >= 0) {
                this.mGpsSignalQualityTimer[this.mGpsSignalQualityBin].stopRunningLocked(elapsedRealtimeMs);
            }
            if (!this.mGpsSignalQualityTimer[signalLevel].isRunningLocked()) {
                this.mGpsSignalQualityTimer[signalLevel].startRunningLocked(elapsedRealtimeMs);
            }
            this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFF7F | signalLevel << 7;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mGpsSignalQualityBin = signalLevel;
        }
    }

    @GuardedBy(value={"this"})
    public void noteScreenStateLocked(int display, int state) {
        this.noteScreenStateLocked(display, state, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis(), this.mClock.currentTimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteScreenStateLocked(int display, int displayState, long elapsedRealtimeMs, long uptimeMs, long currentTimeMs) {
        int state;
        if (displayState > 4) {
            if (Display.isOnState(displayState)) {
                displayState = 2;
            } else if (Display.isDozeState(displayState)) {
                displayState = Display.isSuspendedState(displayState) ? 4 : 3;
            } else if (Display.isOffState(displayState)) {
                displayState = 1;
            } else {
                Slog.wtf(TAG, "Unknown screen state (not mapped): " + displayState);
                displayState = 0;
            }
        }
        int overallBin = this.mScreenBrightnessBin;
        int externalUpdateFlag = 0;
        boolean shouldScheduleSync = false;
        int numDisplay = this.mPerDisplayBatteryStats.length;
        if (display < 0 || display >= numDisplay) {
            Slog.wtf(TAG, "Unexpected note screen state for display " + display + " (only " + this.mPerDisplayBatteryStats.length + " displays exist...)");
            return;
        }
        DisplayBatteryStats displayStats = this.mPerDisplayBatteryStats[display];
        int oldDisplayState = displayStats.screenState;
        if (oldDisplayState == displayState) {
            state = this.mScreenState;
        } else {
            int bin;
            displayStats.screenState = displayState;
            switch (oldDisplayState) {
                case 2: {
                    displayStats.screenOnTimer.stopRunningLocked(elapsedRealtimeMs);
                    bin = displayStats.screenBrightnessBin;
                    if (bin >= 0) {
                        displayStats.screenBrightnessTimers[bin].stopRunningLocked(elapsedRealtimeMs);
                    }
                    overallBin = this.evaluateOverallScreenBrightnessBinLocked();
                    shouldScheduleSync = true;
                    break;
                }
                case 3: {
                    if (displayState == 4) break;
                    displayStats.screenDozeTimer.stopRunningLocked(elapsedRealtimeMs);
                    shouldScheduleSync = true;
                    break;
                }
                case 4: {
                    if (displayState == 3) break;
                    displayStats.screenDozeTimer.stopRunningLocked(elapsedRealtimeMs);
                    shouldScheduleSync = true;
                    break;
                }
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    Slog.wtf(TAG, "Attempted to stop timer for unexpected display state " + display);
                }
            }
            switch (displayState) {
                case 2: {
                    displayStats.screenOnTimer.startRunningLocked(elapsedRealtimeMs);
                    bin = displayStats.screenBrightnessBin;
                    if (bin >= 0) {
                        displayStats.screenBrightnessTimers[bin].startRunningLocked(elapsedRealtimeMs);
                    }
                    overallBin = this.evaluateOverallScreenBrightnessBinLocked();
                    shouldScheduleSync = true;
                    break;
                }
                case 3: {
                    if (oldDisplayState == 4) break;
                    displayStats.screenDozeTimer.startRunningLocked(elapsedRealtimeMs);
                    shouldScheduleSync = true;
                    break;
                }
                case 4: {
                    if (oldDisplayState == 3) break;
                    displayStats.screenDozeTimer.startRunningLocked(elapsedRealtimeMs);
                    shouldScheduleSync = true;
                    break;
                }
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    Slog.wtf(TAG, "Attempted to start timer for unexpected display state " + displayState + " for display " + display);
                }
            }
            if (shouldScheduleSync && this.mGlobalMeasuredEnergyStats != null && this.mGlobalMeasuredEnergyStats.isStandardBucketSupported(0)) {
                externalUpdateFlag |= 0x20;
            }
            state = 0;
            for (int i = 0; i < numDisplay; ++i) {
                int tempState = this.mPerDisplayBatteryStats[i].screenState;
                if (tempState == 2 || state == 2) {
                    state = 2;
                    continue;
                }
                if (tempState == 3 || state == 3) {
                    state = 3;
                    continue;
                }
                if (tempState == 4 || state == 4) {
                    state = 4;
                    continue;
                }
                if (tempState != 1 && state != 1) continue;
                state = 1;
            }
        }
        boolean batteryRunning = this.mOnBatteryTimeBase.isRunning();
        boolean batteryScreenOffRunning = this.mOnBatteryScreenOffTimeBase.isRunning();
        int n = state = this.mPretendScreenOff ? 1 : state;
        if (this.mScreenState != state) {
            this.recordDailyStatsIfNeededLocked(true, currentTimeMs);
            int oldState = this.mScreenState;
            this.mScreenState = state;
            if (state != 0) {
                int stepState = state - 1;
                if ((stepState & 3) == stepState) {
                    this.mModStepMode |= this.mCurStepMode & 3 ^ stepState;
                    this.mCurStepMode = this.mCurStepMode & 0xFFFFFFFC | stepState;
                } else {
                    Slog.wtf(TAG, "Unexpected screen state: " + state);
                }
            }
            boolean updateHistory = false;
            if (Display.isDozeState(state) && !Display.isDozeState(oldState)) {
                this.mHistoryCur.states |= 0x40000;
                this.mScreenDozeTimer.startRunningLocked(elapsedRealtimeMs);
                updateHistory = true;
            } else if (Display.isDozeState(oldState) && !Display.isDozeState(state)) {
                this.mHistoryCur.states &= 0xFFFBFFFF;
                this.mScreenDozeTimer.stopRunningLocked(elapsedRealtimeMs);
                updateHistory = true;
            }
            if (Display.isOnState(state)) {
                this.mHistoryCur.states |= 0x100000;
                this.mScreenOnTimer.startRunningLocked(elapsedRealtimeMs);
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].startRunningLocked(elapsedRealtimeMs);
                }
                updateHistory = true;
            } else if (Display.isOnState(oldState)) {
                this.mHistoryCur.states &= 0xFFEFFFFF;
                this.mScreenOnTimer.stopRunningLocked(elapsedRealtimeMs);
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(elapsedRealtimeMs);
                }
                updateHistory = true;
            }
            if (updateHistory) {
                this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            }
            externalUpdateFlag |= 1;
            shouldScheduleSync = true;
            if (Display.isOnState(state)) {
                this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), state, uptimeMs * 1000L, elapsedRealtimeMs * 1000L);
                this.noteStartWakeLocked(-1, -1, null, "screen", null, 0, false, elapsedRealtimeMs, uptimeMs);
            } else if (Display.isOnState(oldState)) {
                this.noteStopWakeLocked(-1, -1, null, "screen", "screen", 0, elapsedRealtimeMs, uptimeMs);
                this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), state, uptimeMs * 1000L, elapsedRealtimeMs * 1000L);
            }
            if (this.mOnBatteryInternal) {
                this.updateDischargeScreenLevelsLocked(oldState, state);
            }
        }
        this.maybeUpdateOverallScreenBrightness(overallBin, elapsedRealtimeMs, uptimeMs);
        if (shouldScheduleSync) {
            int numDisplays = this.mPerDisplayBatteryStats.length;
            int[] displayStates = new int[numDisplays];
            for (int i = 0; i < numDisplays; ++i) {
                displayStates[i] = this.mPerDisplayBatteryStats[i].screenState;
            }
            this.mExternalSync.scheduleSyncDueToScreenStateChange(externalUpdateFlag, batteryRunning, batteryScreenOffRunning, state, displayStates);
        }
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void noteScreenBrightnessLocked(int brightness) {
        this.noteScreenBrightnessLocked(0, brightness);
    }

    @GuardedBy(value={"this"})
    public void noteScreenBrightnessLocked(int display, int brightness) {
        this.noteScreenBrightnessLocked(display, brightness, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteScreenBrightnessLocked(int display, int brightness, long elapsedRealtimeMs, long uptimeMs) {
        int overallBin;
        int bin = brightness / 51;
        if (bin < 0) {
            bin = 0;
        } else if (bin >= 5) {
            bin = 4;
        }
        int numDisplays = this.mPerDisplayBatteryStats.length;
        if (display < 0 || display >= numDisplays) {
            Slog.wtf(TAG, "Unexpected note screen brightness for display " + display + " (only " + this.mPerDisplayBatteryStats.length + " displays exist...)");
            return;
        }
        DisplayBatteryStats displayStats = this.mPerDisplayBatteryStats[display];
        int oldBin = displayStats.screenBrightnessBin;
        if (oldBin == bin) {
            overallBin = this.mScreenBrightnessBin;
        } else {
            displayStats.screenBrightnessBin = bin;
            if (displayStats.screenState == 2) {
                if (oldBin >= 0) {
                    displayStats.screenBrightnessTimers[oldBin].stopRunningLocked(elapsedRealtimeMs);
                }
                displayStats.screenBrightnessTimers[bin].startRunningLocked(elapsedRealtimeMs);
            }
            overallBin = this.evaluateOverallScreenBrightnessBinLocked();
        }
        this.maybeUpdateOverallScreenBrightness(overallBin, elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    private int evaluateOverallScreenBrightnessBinLocked() {
        int overallBin = -1;
        int numDisplays = this.getDisplayCount();
        for (int display = 0; display < numDisplays; ++display) {
            int displayBrightnessBin = this.mPerDisplayBatteryStats[display].screenState == 2 ? this.mPerDisplayBatteryStats[display].screenBrightnessBin : -1;
            if (displayBrightnessBin <= overallBin) continue;
            overallBin = displayBrightnessBin;
        }
        return overallBin;
    }

    @GuardedBy(value={"this"})
    private void maybeUpdateOverallScreenBrightness(int overallBin, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mScreenBrightnessBin != overallBin) {
            if (overallBin >= 0) {
                this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFFF8 | overallBin << 0;
                this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            }
            if (this.mScreenState == 2) {
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(elapsedRealtimeMs);
                }
                if (overallBin >= 0) {
                    this.mScreenBrightnessTimer[overallBin].startRunningLocked(elapsedRealtimeMs);
                }
            }
            this.mScreenBrightnessBin = overallBin;
        }
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void noteUserActivityLocked(int uid, int event) {
        this.noteUserActivityLocked(uid, event, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteUserActivityLocked(int uid, int event, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mOnBatteryInternal) {
            uid = this.mapUid(uid);
            this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteUserActivityLocked(event);
        }
    }

    @GuardedBy(value={"this"})
    public void noteWakeUpLocked(String reason, int reasonUid) {
        this.noteWakeUpLocked(reason, reasonUid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWakeUpLocked(String reason, int reasonUid, long elapsedRealtimeMs, long uptimeMs) {
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 18, reason, reasonUid);
    }

    @GuardedBy(value={"this"})
    public void noteInteractiveLocked(boolean interactive) {
        this.noteInteractiveLocked(interactive, this.mClock.elapsedRealtime());
    }

    @GuardedBy(value={"this"})
    public void noteInteractiveLocked(boolean interactive, long elapsedRealtimeMs) {
        if (this.mInteractive != interactive) {
            this.mInteractive = interactive;
            if (interactive) {
                this.mInteractiveTimer.startRunningLocked(elapsedRealtimeMs);
            } else {
                this.mInteractiveTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteConnectivityChangedLocked(int type, String extra) {
        this.noteConnectivityChangedLocked(type, extra, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteConnectivityChangedLocked(int type, String extra, long elapsedRealtimeMs, long uptimeMs) {
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 9, extra, type);
        ++this.mNumConnectivityChange;
    }

    @GuardedBy(value={"this"})
    private void noteMobileRadioApWakeupLocked(long elapsedRealtimeMillis, long uptimeMillis, int uid) {
        uid = this.mapUid(uid);
        this.addHistoryEventLocked(elapsedRealtimeMillis, uptimeMillis, 19, "", uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMillis, uptimeMillis).noteMobileRadioApWakeupLocked();
    }

    @GuardedBy(value={"this"})
    public boolean noteMobileRadioPowerStateLocked(int powerState, long timestampNs, int uid) {
        return this.noteMobileRadioPowerStateLocked(powerState, timestampNs, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public boolean noteMobileRadioPowerStateLocked(int powerState, long timestampNs, int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mMobileRadioPowerState != powerState) {
            long realElapsedRealtimeMs;
            boolean active = BatteryStatsImpl.isActiveRadioPowerState(powerState);
            if (active) {
                if (uid > 0) {
                    this.noteMobileRadioApWakeupLocked(elapsedRealtimeMs, uptimeMs, uid);
                }
                this.mMobileRadioActiveStartTimeMs = realElapsedRealtimeMs = timestampNs / 1000000L;
                this.mHistoryCur.states |= 0x2000000;
            } else {
                realElapsedRealtimeMs = timestampNs / 1000000L;
                long lastUpdateTimeMs = this.mMobileRadioActiveStartTimeMs;
                if (realElapsedRealtimeMs < lastUpdateTimeMs) {
                    Slog.wtf(TAG, "Data connection inactive timestamp " + realElapsedRealtimeMs + " is before start time " + lastUpdateTimeMs);
                    realElapsedRealtimeMs = elapsedRealtimeMs;
                } else if (realElapsedRealtimeMs < elapsedRealtimeMs) {
                    this.mMobileRadioActiveAdjustedTime.addCountLocked(elapsedRealtimeMs - realElapsedRealtimeMs);
                }
                this.mHistoryCur.states &= 0xFDFFFFFF;
            }
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mMobileRadioPowerState = powerState;
            this.getRatBatteryStatsLocked(this.mActiveRat).noteActive(active, elapsedRealtimeMs);
            if (active) {
                this.mMobileRadioActiveTimer.startRunningLocked(elapsedRealtimeMs);
                this.mMobileRadioActivePerAppTimer.startRunningLocked(elapsedRealtimeMs);
            } else {
                this.mMobileRadioActiveTimer.stopRunningLocked(realElapsedRealtimeMs);
                this.mMobileRadioActivePerAppTimer.stopRunningLocked(realElapsedRealtimeMs);
                return true;
            }
        }
        return false;
    }

    private static boolean isActiveRadioPowerState(int powerState) {
        return powerState == 2 || powerState == 3;
    }

    @GuardedBy(value={"this"})
    public void notePowerSaveModeLocked(boolean enabled) {
        this.notePowerSaveModeLocked(enabled, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void notePowerSaveModeLockedInit(boolean enabled, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mPowerSaveModeEnabled != enabled) {
            this.notePowerSaveModeLocked(enabled, elapsedRealtimeMs, uptimeMs);
        } else {
            FrameworkStatsLog.write(20, enabled ? 1 : 0);
        }
    }

    @GuardedBy(value={"this"})
    public void notePowerSaveModeLocked(boolean enabled, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mPowerSaveModeEnabled != enabled) {
            int stepState = enabled ? 4 : 0;
            this.mModStepMode |= this.mCurStepMode & 4 ^ stepState;
            this.mCurStepMode = this.mCurStepMode & 0xFFFFFFFB | stepState;
            this.mPowerSaveModeEnabled = enabled;
            if (enabled) {
                this.mHistoryCur.states2 |= Integer.MIN_VALUE;
                this.mPowerSaveModeEnabledTimer.startRunningLocked(elapsedRealtimeMs);
            } else {
                this.mHistoryCur.states2 &= Integer.MAX_VALUE;
                this.mPowerSaveModeEnabledTimer.stopRunningLocked(elapsedRealtimeMs);
            }
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            FrameworkStatsLog.write(20, enabled ? 1 : 0);
        }
    }

    @GuardedBy(value={"this"})
    public void noteDeviceIdleModeLocked(int mode, String activeReason, int activeUid) {
        this.noteDeviceIdleModeLocked(mode, activeReason, activeUid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteDeviceIdleModeLocked(int mode, String activeReason, int activeUid, long elapsedRealtimeMs, long uptimeMs) {
        boolean nowLightIdling;
        boolean nowIdling;
        boolean bl = nowIdling = mode == 2;
        if (this.mDeviceIdling && !nowIdling && activeReason == null) {
            nowIdling = true;
        }
        boolean bl2 = nowLightIdling = mode == 1;
        if (this.mDeviceLightIdling && !nowLightIdling && !nowIdling && activeReason == null) {
            nowLightIdling = true;
        }
        if (activeReason != null && (this.mDeviceIdling || this.mDeviceLightIdling)) {
            this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 10, activeReason, activeUid);
        }
        if (this.mDeviceIdling != nowIdling || this.mDeviceLightIdling != nowLightIdling) {
            int statsmode = nowIdling ? 2 : (nowLightIdling ? 1 : 0);
            FrameworkStatsLog.write(22, statsmode);
        }
        if (this.mDeviceIdling != nowIdling) {
            this.mDeviceIdling = nowIdling;
            int stepState = nowIdling ? 8 : 0;
            this.mModStepMode |= this.mCurStepMode & 8 ^ stepState;
            this.mCurStepMode = this.mCurStepMode & 0xFFFFFFF7 | stepState;
            if (nowIdling) {
                this.mDeviceIdlingTimer.startRunningLocked(elapsedRealtimeMs);
            } else {
                this.mDeviceIdlingTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }
        if (this.mDeviceLightIdling != nowLightIdling) {
            this.mDeviceLightIdling = nowLightIdling;
            if (nowLightIdling) {
                this.mDeviceLightIdlingTimer.startRunningLocked(elapsedRealtimeMs);
            } else {
                this.mDeviceLightIdlingTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }
        if (this.mDeviceIdleMode != mode) {
            this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xF9FFFFFF | mode << 25;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            long lastDuration = elapsedRealtimeMs - this.mLastIdleTimeStartMs;
            this.mLastIdleTimeStartMs = elapsedRealtimeMs;
            if (this.mDeviceIdleMode == 1) {
                if (lastDuration > this.mLongestLightIdleTimeMs) {
                    this.mLongestLightIdleTimeMs = lastDuration;
                }
                this.mDeviceIdleModeLightTimer.stopRunningLocked(elapsedRealtimeMs);
            } else if (this.mDeviceIdleMode == 2) {
                if (lastDuration > this.mLongestFullIdleTimeMs) {
                    this.mLongestFullIdleTimeMs = lastDuration;
                }
                this.mDeviceIdleModeFullTimer.stopRunningLocked(elapsedRealtimeMs);
            }
            if (mode == 1) {
                this.mDeviceIdleModeLightTimer.startRunningLocked(elapsedRealtimeMs);
            } else if (mode == 2) {
                this.mDeviceIdleModeFullTimer.startRunningLocked(elapsedRealtimeMs);
            }
            this.mDeviceIdleMode = mode;
            FrameworkStatsLog.write(21, mode);
        }
    }

    @GuardedBy(value={"this"})
    public void notePackageInstalledLocked(String pkgName, long versionCode) {
        this.notePackageInstalledLocked(pkgName, versionCode, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void notePackageInstalledLocked(String pkgName, long versionCode, long elapsedRealtimeMs, long uptimeMs) {
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 11, pkgName, (int)versionCode);
        BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
        pc.mPackageName = pkgName;
        pc.mUpdate = true;
        pc.mVersionCode = versionCode;
        this.addPackageChange(pc);
    }

    @GuardedBy(value={"this"})
    public void notePackageUninstalledLocked(String pkgName) {
        this.notePackageUninstalledLocked(pkgName, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void notePackageUninstalledLocked(String pkgName, long elapsedRealtimeMs, long uptimeMs) {
        this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, 12, pkgName, 0);
        BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
        pc.mPackageName = pkgName;
        pc.mUpdate = true;
        this.addPackageChange(pc);
    }

    private void addPackageChange(BatteryStats.PackageChange pc) {
        if (this.mDailyPackageChanges == null) {
            this.mDailyPackageChanges = new ArrayList();
        }
        this.mDailyPackageChanges.add(pc);
    }

    @GuardedBy(value={"this"})
    void stopAllGpsSignalQualityTimersLocked(int except) {
        this.stopAllGpsSignalQualityTimersLocked(except, this.mClock.elapsedRealtime());
    }

    @GuardedBy(value={"this"})
    void stopAllGpsSignalQualityTimersLocked(int except, long elapsedRealtimeMs) {
        for (int i = 0; i < this.mGpsSignalQualityTimer.length; ++i) {
            if (i == except) continue;
            while (this.mGpsSignalQualityTimer[i].isRunningLocked()) {
                this.mGpsSignalQualityTimer[i].stopRunningLocked(elapsedRealtimeMs);
            }
        }
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void notePhoneOnLocked() {
        this.notePhoneOnLocked(this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void notePhoneOnLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (!this.mPhoneOn) {
            this.mHistoryCur.states2 |= 0x800000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mPhoneOn = true;
            this.mPhoneOnTimer.startRunningLocked(elapsedRealtimeMs);
        }
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void notePhoneOffLocked() {
        this.notePhoneOffLocked(this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void notePhoneOffLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mPhoneOn) {
            this.mHistoryCur.states2 &= 0xFF7FFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mPhoneOn = false;
            this.mPhoneOnTimer.stopRunningLocked(elapsedRealtimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    private void registerUsbStateReceiver(Context context) {
        IntentFilter usbStateFilter = new IntentFilter();
        usbStateFilter.addAction("android.hardware.usb.action.USB_STATE");
        context.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                boolean state = intent.getBooleanExtra("connected", false);
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                synchronized (batteryStatsImpl) {
                    BatteryStatsImpl.this.noteUsbConnectionStateLocked(state, BatteryStatsImpl.this.mClock.elapsedRealtime(), BatteryStatsImpl.this.mClock.uptimeMillis());
                }
            }
        }, usbStateFilter);
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            if (this.mUsbDataState == 0) {
                Intent usbState = context.registerReceiver(null, usbStateFilter);
                boolean initState = usbState != null && usbState.getBooleanExtra("connected", false);
                this.noteUsbConnectionStateLocked(initState, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
            }
        }
    }

    @GuardedBy(value={"this"})
    private void noteUsbConnectionStateLocked(boolean connected, long elapsedRealtimeMs, long uptimeMs) {
        int newState;
        int n = newState = connected ? 2 : 1;
        if (this.mUsbDataState != newState) {
            this.mUsbDataState = newState;
            this.mHistoryCur.states2 = connected ? (this.mHistoryCur.states2 |= 0x40000) : (this.mHistoryCur.states2 &= 0xFFFBFFFF);
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
    }

    @GuardedBy(value={"this"})
    void stopAllPhoneSignalStrengthTimersLocked(int except, long elapsedRealtimeMs) {
        for (int i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            if (i == except) continue;
            while (this.mPhoneSignalStrengthsTimer[i].isRunningLocked()) {
                this.mPhoneSignalStrengthsTimer[i].stopRunningLocked(elapsedRealtimeMs);
            }
        }
    }

    private int fixPhoneServiceState(int state, int signalBin) {
        if (this.mPhoneSimStateRaw == 1 && state == 1 && signalBin > 0) {
            state = 0;
        }
        return state;
    }

    @GuardedBy(value={"this"})
    private void updateAllPhoneStateLocked(int state, int simState, int strengthBin, long elapsedRealtimeMs, long uptimeMs) {
        boolean scanning = false;
        boolean newHistory = false;
        this.mPhoneServiceStateRaw = state;
        this.mPhoneSimStateRaw = simState;
        this.mPhoneSignalStrengthBinRaw = strengthBin;
        if (simState == 1 && state == 1 && strengthBin > 0) {
            state = 0;
        }
        if (state == 3) {
            strengthBin = -1;
        } else if (state != 0 && state == 1) {
            scanning = true;
            strengthBin = 0;
            if (!this.mPhoneSignalScanningTimer.isRunningLocked()) {
                this.mHistoryCur.states |= 0x200000;
                newHistory = true;
                this.mPhoneSignalScanningTimer.startRunningLocked(elapsedRealtimeMs);
                FrameworkStatsLog.write(94, state, simState, strengthBin);
            }
        }
        if (!scanning && this.mPhoneSignalScanningTimer.isRunningLocked()) {
            this.mHistoryCur.states &= 0xFFDFFFFF;
            newHistory = true;
            this.mPhoneSignalScanningTimer.stopRunningLocked(elapsedRealtimeMs);
            FrameworkStatsLog.write(94, state, simState, strengthBin);
        }
        if (this.mPhoneServiceState != state) {
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFE3F | state << 6;
            newHistory = true;
            this.mPhoneServiceState = state;
        }
        if (this.mPhoneSignalStrengthBin != strengthBin) {
            if (this.mPhoneSignalStrengthBin >= 0) {
                this.mPhoneSignalStrengthsTimer[this.mPhoneSignalStrengthBin].stopRunningLocked(elapsedRealtimeMs);
            }
            if (strengthBin >= 0) {
                if (!this.mPhoneSignalStrengthsTimer[strengthBin].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[strengthBin].startRunningLocked(elapsedRealtimeMs);
                }
                this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFFC7 | strengthBin << 3;
                newHistory = true;
                FrameworkStatsLog.write(40, strengthBin);
            } else {
                this.stopAllPhoneSignalStrengthTimersLocked(-1, elapsedRealtimeMs);
            }
            this.mPhoneSignalStrengthBin = strengthBin;
        }
        if (newHistory) {
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
    }

    @GuardedBy(value={"this"})
    public void notePhoneStateLocked(int state, int simState) {
        this.notePhoneStateLocked(state, simState, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void notePhoneStateLocked(int state, int simState, long elapsedRealtimeMs, long uptimeMs) {
        this.updateAllPhoneStateLocked(state, simState, this.mPhoneSignalStrengthBinRaw, elapsedRealtimeMs, uptimeMs);
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void notePhoneSignalStrengthLocked(SignalStrength signalStrength) {
        this.notePhoneSignalStrengthLocked(signalStrength, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void notePhoneSignalStrengthLocked(SignalStrength signalStrength, long elapsedRealtimeMs, long uptimeMs) {
        int overallSignalStrength = signalStrength.getLevel();
        SparseIntArray perRatSignalStrength = new SparseIntArray(3);
        List<CellSignalStrength> cellSignalStrengths = signalStrength.getCellSignalStrengths();
        int size = cellSignalStrengths.size();
        for (int i = 0; i < size; ++i) {
            int level;
            int ratType;
            CellSignalStrength cellSignalStrength = cellSignalStrengths.get(i);
            if (cellSignalStrength instanceof CellSignalStrengthNr) {
                ratType = 2;
                level = cellSignalStrength.getLevel();
            } else if (cellSignalStrength instanceof CellSignalStrengthLte) {
                ratType = 1;
                level = cellSignalStrength.getLevel();
            } else {
                ratType = 0;
                level = cellSignalStrength.getLevel();
            }
            if (perRatSignalStrength.get(ratType, -1) >= level) continue;
            perRatSignalStrength.put(ratType, level);
        }
        this.notePhoneSignalStrengthLocked(overallSignalStrength, perRatSignalStrength, elapsedRealtimeMs, uptimeMs);
    }

    @GuardedBy(value={"this"})
    public void notePhoneSignalStrengthLocked(int signalStrength, SparseIntArray perRatSignalStrength) {
        this.notePhoneSignalStrengthLocked(signalStrength, perRatSignalStrength, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void notePhoneSignalStrengthLocked(int signalStrength, SparseIntArray perRatSignalStrength, long elapsedRealtimeMs, long uptimeMs) {
        int size = perRatSignalStrength.size();
        for (int i = 0; i < size; ++i) {
            int rat = perRatSignalStrength.keyAt(i);
            int ratSignalStrength = perRatSignalStrength.valueAt(i);
            this.getRatBatteryStatsLocked(rat).noteSignalStrength(ratSignalStrength, elapsedRealtimeMs);
        }
        this.updateAllPhoneStateLocked(this.mPhoneServiceStateRaw, this.mPhoneSimStateRaw, signalStrength, elapsedRealtimeMs, uptimeMs);
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void notePhoneDataConnectionStateLocked(int dataType, boolean hasData, int serviceType, int nrFrequency) {
        this.notePhoneDataConnectionStateLocked(dataType, hasData, serviceType, nrFrequency, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void notePhoneDataConnectionStateLocked(int dataType, boolean hasData, int serviceType, int nrFrequency, long elapsedRealtimeMs, long uptimeMs) {
        int newRat;
        int bin = 0;
        if (hasData) {
            if (dataType > 0 && dataType <= TelephonyManager.getAllNetworkTypes().length) {
                bin = dataType;
            } else {
                switch (serviceType) {
                    case 1: {
                        bin = 0;
                        break;
                    }
                    case 2: {
                        bin = DATA_CONNECTION_EMERGENCY_SERVICE;
                        break;
                    }
                    default: {
                        bin = DATA_CONNECTION_OTHER;
                    }
                }
            }
        }
        if ((newRat = BatteryStatsImpl.mapNetworkTypeToRadioAccessTechnology(bin)) == 2) {
            this.getRatBatteryStatsLocked(newRat).noteFrequencyRange(nrFrequency, elapsedRealtimeMs);
        }
        if (this.mPhoneDataConnectionType != bin) {
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFC1FF | bin << 9;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            if (this.mPhoneDataConnectionType >= 0) {
                this.mPhoneDataConnectionsTimer[this.mPhoneDataConnectionType].stopRunningLocked(elapsedRealtimeMs);
            }
            this.mPhoneDataConnectionType = bin;
            this.mPhoneDataConnectionsTimer[bin].startRunningLocked(elapsedRealtimeMs);
            if (this.mActiveRat != newRat) {
                this.getRatBatteryStatsLocked(this.mActiveRat).noteActive(false, elapsedRealtimeMs);
                this.mActiveRat = newRat;
            }
            boolean modemActive = this.mMobileRadioActiveTimer.isRunningLocked();
            this.getRatBatteryStatsLocked(newRat).noteActive(modemActive, elapsedRealtimeMs);
        }
    }

    private static int mapNetworkTypeToRadioAccessTechnology(int dataType) {
        switch (dataType) {
            case 20: {
                return 2;
            }
            case 13: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return 0;
            }
        }
        Slog.w(TAG, "Unhandled NetworkType (" + dataType + "), mapping to OTHER");
        return 0;
    }

    private static int mapRadioAccessNetworkTypeToRadioAccessTechnology(int dataType) {
        switch (dataType) {
            case 6: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 0;
            }
        }
        Slog.w(TAG, "Unhandled RadioAccessNetworkType (" + dataType + "), mapping to OTHER");
        return 0;
    }

    @GuardedBy(value={"this"})
    public void noteWifiOnLocked() {
        this.noteWifiOnLocked(this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiOnLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (!this.mWifiOn) {
            this.mHistoryCur.states2 |= 0x10000000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mWifiOn = true;
            this.mWifiOnTimer.startRunningLocked(elapsedRealtimeMs);
            this.scheduleSyncExternalStatsLocked("wifi-off", 2);
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiOffLocked() {
        this.noteWifiOffLocked(this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiOffLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mWifiOn) {
            this.mHistoryCur.states2 &= 0xEFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mWifiOn = false;
            this.mWifiOnTimer.stopRunningLocked(elapsedRealtimeMs);
            this.scheduleSyncExternalStatsLocked("wifi-on", 2);
        }
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void noteAudioOnLocked(int uid) {
        this.noteAudioOnLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteAudioOnLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        if (this.mAudioOnNesting == 0) {
            this.mHistoryCur.states |= 0x400000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mAudioOnTimer.startRunningLocked(elapsedRealtimeMs);
        }
        ++this.mAudioOnNesting;
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteAudioTurnedOnLocked(elapsedRealtimeMs);
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void noteAudioOffLocked(int uid) {
        this.noteAudioOffLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteAudioOffLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mAudioOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        if (--this.mAudioOnNesting == 0) {
            this.mHistoryCur.states &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mAudioOnTimer.stopRunningLocked(elapsedRealtimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteAudioTurnedOffLocked(elapsedRealtimeMs);
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void noteVideoOnLocked(int uid) {
        this.noteVideoOnLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteVideoOnLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        if (this.mVideoOnNesting == 0) {
            this.mHistoryCur.states2 |= 0x40000000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mVideoOnTimer.startRunningLocked(elapsedRealtimeMs);
        }
        ++this.mVideoOnNesting;
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteVideoTurnedOnLocked(elapsedRealtimeMs);
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void noteVideoOffLocked(int uid) {
        this.noteVideoOffLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteVideoOffLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mVideoOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        if (--this.mVideoOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xBFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mVideoOnTimer.stopRunningLocked(elapsedRealtimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteVideoTurnedOffLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteResetAudioLocked() {
        this.noteResetAudioLocked(this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteResetAudioLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mAudioOnNesting > 0) {
            this.mAudioOnNesting = 0;
            this.mHistoryCur.states &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mAudioOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetAudioLocked(elapsedRealtimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteResetVideoLocked() {
        this.noteResetVideoLocked(this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteResetVideoLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mVideoOnNesting > 0) {
            this.mVideoOnNesting = 0;
            this.mHistoryCur.states2 &= 0xBFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mVideoOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetVideoLocked(elapsedRealtimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteActivityResumedLocked(int uid) {
        this.noteActivityResumedLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteActivityResumedLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteActivityResumedLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteActivityPausedLocked(int uid) {
        this.noteActivityPausedLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteActivityPausedLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteActivityPausedLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteVibratorOnLocked(int uid, long durationMillis) {
        this.noteVibratorOnLocked(uid, durationMillis, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteVibratorOnLocked(int uid, long durationMillis, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteVibratorOnLocked(durationMillis, elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteVibratorOffLocked(int uid) {
        this.noteVibratorOffLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteVibratorOffLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteVibratorOffLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteFlashlightOnLocked(int uid) {
        this.noteFlashlightOnLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteFlashlightOnLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        if (this.mFlashlightOnNesting++ == 0) {
            this.mHistoryCur.states2 |= 0x8000000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mFlashlightOnTimer.startRunningLocked(elapsedRealtimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteFlashlightTurnedOnLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteFlashlightOffLocked(int uid) {
        this.noteFlashlightOffLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteFlashlightOffLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mFlashlightOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        if (--this.mFlashlightOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mFlashlightOnTimer.stopRunningLocked(elapsedRealtimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteFlashlightTurnedOffLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteCameraOnLocked(int uid) {
        this.noteCameraOnLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteCameraOnLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        if (this.mCameraOnNesting++ == 0) {
            this.mHistoryCur.states2 |= 0x200000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mCameraOnTimer.startRunningLocked(elapsedRealtimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteCameraTurnedOnLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteCameraOffLocked(int uid) {
        this.noteCameraOffLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteCameraOffLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mCameraOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        if (--this.mCameraOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xFFDFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mCameraOnTimer.stopRunningLocked(elapsedRealtimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteCameraTurnedOffLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteResetCameraLocked() {
        this.noteResetCameraLocked(this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteResetCameraLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mCameraOnNesting > 0) {
            this.mCameraOnNesting = 0;
            this.mHistoryCur.states2 &= 0xFFDFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mCameraOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetCameraLocked(elapsedRealtimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteResetFlashlightLocked() {
        this.noteResetFlashlightLocked(this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteResetFlashlightLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mFlashlightOnNesting > 0) {
            this.mFlashlightOnNesting = 0;
            this.mHistoryCur.states2 &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mFlashlightOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetFlashlightLocked(elapsedRealtimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    private void noteBluetoothScanStartedLocked(WorkSource.WorkChain workChain, int uid, boolean isUnoptimized, long elapsedRealtimeMs, long uptimeMs) {
        if (workChain != null) {
            uid = workChain.getAttributionUid();
        }
        uid = this.mapUid(uid);
        if (this.mBluetoothScanNesting == 0) {
            this.mHistoryCur.states2 |= 0x100000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mBluetoothScanTimer.startRunningLocked(elapsedRealtimeMs);
        }
        ++this.mBluetoothScanNesting;
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteBluetoothScanStartedLocked(elapsedRealtimeMs, isUnoptimized);
    }

    @GuardedBy(value={"this"})
    public void noteBluetoothScanStartedFromSourceLocked(WorkSource ws, boolean isUnoptimized) {
        this.noteBluetoothScanStartedFromSourceLocked(ws, isUnoptimized, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteBluetoothScanStartedFromSourceLocked(WorkSource ws, boolean isUnoptimized, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteBluetoothScanStartedLocked(null, ws.getUid(i), isUnoptimized, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                this.noteBluetoothScanStartedLocked(workChains.get(i), -1, isUnoptimized, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    private void noteBluetoothScanStoppedLocked(WorkSource.WorkChain workChain, int uid, boolean isUnoptimized, long elapsedRealtimeMs, long uptimeMs) {
        if (workChain != null) {
            uid = workChain.getAttributionUid();
        }
        uid = this.mapUid(uid);
        --this.mBluetoothScanNesting;
        if (this.mBluetoothScanNesting == 0) {
            this.mHistoryCur.states2 &= 0xFFEFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mBluetoothScanTimer.stopRunningLocked(elapsedRealtimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteBluetoothScanStoppedLocked(elapsedRealtimeMs, isUnoptimized);
    }

    @GuardedBy(value={"this"})
    public void noteBluetoothScanStoppedFromSourceLocked(WorkSource ws, boolean isUnoptimized) {
        this.noteBluetoothScanStoppedFromSourceLocked(ws, isUnoptimized, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteBluetoothScanStoppedFromSourceLocked(WorkSource ws, boolean isUnoptimized, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteBluetoothScanStoppedLocked(null, ws.getUid(i), isUnoptimized, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                this.noteBluetoothScanStoppedLocked(workChains.get(i), -1, isUnoptimized, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteResetBluetoothScanLocked() {
        this.noteResetBluetoothScanLocked(this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteResetBluetoothScanLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mBluetoothScanNesting > 0) {
            this.mBluetoothScanNesting = 0;
            this.mHistoryCur.states2 &= 0xFFEFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mBluetoothScanTimer.stopAllRunningLocked(elapsedRealtimeMs);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetBluetoothScanLocked(elapsedRealtimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteBluetoothScanResultsFromSourceLocked(WorkSource ws, int numNewResults) {
        this.noteBluetoothScanResultsFromSourceLocked(ws, numNewResults, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteBluetoothScanResultsFromSourceLocked(WorkSource ws, int numNewResults, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteBluetoothScanResultsLocked(numNewResults);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain wc = workChains.get(i);
                int uid = this.mapUid(wc.getAttributionUid());
                this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteBluetoothScanResultsLocked(numNewResults);
            }
        }
    }

    @GuardedBy(value={"this"})
    private void noteWifiRadioApWakeupLocked(long elapsedRealtimeMillis, long uptimeMillis, int uid) {
        uid = this.mapUid(uid);
        this.addHistoryEventLocked(elapsedRealtimeMillis, uptimeMillis, 19, "", uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMillis, uptimeMillis).noteWifiRadioApWakeupLocked();
    }

    @GuardedBy(value={"this"})
    public void noteWifiRadioPowerState(int powerState, long timestampNs, int uid) {
        this.noteWifiRadioPowerState(powerState, timestampNs, uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiRadioPowerState(int powerState, long timestampNs, int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mWifiRadioPowerState != powerState) {
            boolean active;
            boolean bl = active = powerState == 2 || powerState == 3;
            if (active) {
                if (uid > 0) {
                    this.noteWifiRadioApWakeupLocked(elapsedRealtimeMs, uptimeMs, uid);
                }
                this.mHistoryCur.states |= 0x4000000;
                this.mWifiActiveTimer.startRunningLocked(elapsedRealtimeMs);
            } else {
                this.mHistoryCur.states &= 0xFBFFFFFF;
                this.mWifiActiveTimer.stopRunningLocked(timestampNs / 1000000L);
            }
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mWifiRadioPowerState = powerState;
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiRunningLocked(WorkSource ws) {
        this.noteWifiRunningLocked(ws, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiRunningLocked(WorkSource ws, long elapsedRealtimeMs, long uptimeMs) {
        if (!this.mGlobalWifiRunning) {
            this.mHistoryCur.states2 |= 0x20000000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mGlobalWifiRunning = true;
            this.mGlobalWifiRunningTimer.startRunningLocked(elapsedRealtimeMs);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                int uid = this.mapUid(ws.getUid(i));
                this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiRunningLocked(elapsedRealtimeMs);
            }
            List<WorkSource.WorkChain> workChains = ws.getWorkChains();
            if (workChains != null) {
                for (int i = 0; i < workChains.size(); ++i) {
                    int uid = this.mapUid(workChains.get(i).getAttributionUid());
                    this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiRunningLocked(elapsedRealtimeMs);
                }
            }
            this.scheduleSyncExternalStatsLocked("wifi-running", 2);
        } else {
            Log.w(TAG, "noteWifiRunningLocked -- called while WIFI running");
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiRunningChangedLocked(WorkSource oldWs, WorkSource newWs) {
        this.noteWifiRunningChangedLocked(oldWs, newWs, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiRunningChangedLocked(WorkSource oldWs, WorkSource newWs, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mGlobalWifiRunning) {
            int uid;
            int i;
            int N = oldWs.size();
            for (int i2 = 0; i2 < N; ++i2) {
                int uid2 = this.mapUid(oldWs.getUid(i2));
                this.getUidStatsLocked(uid2, elapsedRealtimeMs, uptimeMs).noteWifiStoppedLocked(elapsedRealtimeMs);
            }
            List<WorkSource.WorkChain> workChains = oldWs.getWorkChains();
            if (workChains != null) {
                for (i = 0; i < workChains.size(); ++i) {
                    uid = this.mapUid(workChains.get(i).getAttributionUid());
                    this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiStoppedLocked(elapsedRealtimeMs);
                }
            }
            N = newWs.size();
            for (i = 0; i < N; ++i) {
                uid = this.mapUid(newWs.getUid(i));
                this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiRunningLocked(elapsedRealtimeMs);
            }
            workChains = newWs.getWorkChains();
            if (workChains != null) {
                for (i = 0; i < workChains.size(); ++i) {
                    uid = this.mapUid(workChains.get(i).getAttributionUid());
                    this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiRunningLocked(elapsedRealtimeMs);
                }
            }
        } else {
            Log.w(TAG, "noteWifiRunningChangedLocked -- called while WIFI not running");
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiStoppedLocked(WorkSource ws) {
        this.noteWifiStoppedLocked(ws, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiStoppedLocked(WorkSource ws, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mGlobalWifiRunning) {
            this.mHistoryCur.states2 &= 0xDFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            this.mGlobalWifiRunning = false;
            this.mGlobalWifiRunningTimer.stopRunningLocked(elapsedRealtimeMs);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                int uid = this.mapUid(ws.getUid(i));
                this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiStoppedLocked(elapsedRealtimeMs);
            }
            List<WorkSource.WorkChain> workChains = ws.getWorkChains();
            if (workChains != null) {
                for (int i = 0; i < workChains.size(); ++i) {
                    int uid = this.mapUid(workChains.get(i).getAttributionUid());
                    this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiStoppedLocked(elapsedRealtimeMs);
                }
            }
            this.scheduleSyncExternalStatsLocked("wifi-stopped", 2);
        } else {
            Log.w(TAG, "noteWifiStoppedLocked -- called while WIFI not running");
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiStateLocked(int wifiState, String accessPoint) {
        this.noteWifiStateLocked(wifiState, accessPoint, this.mClock.elapsedRealtime());
    }

    @GuardedBy(value={"this"})
    public void noteWifiStateLocked(int wifiState, String accessPoint, long elapsedRealtimeMs) {
        if (this.mWifiState != wifiState) {
            if (this.mWifiState >= 0) {
                this.mWifiStateTimer[this.mWifiState].stopRunningLocked(elapsedRealtimeMs);
            }
            this.mWifiState = wifiState;
            this.mWifiStateTimer[wifiState].startRunningLocked(elapsedRealtimeMs);
            this.scheduleSyncExternalStatsLocked("wifi-state", 2);
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiSupplicantStateChangedLocked(int supplState, boolean failedAuth) {
        this.noteWifiSupplicantStateChangedLocked(supplState, failedAuth, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiSupplicantStateChangedLocked(int supplState, boolean failedAuth, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mWifiSupplState != supplState) {
            if (this.mWifiSupplState >= 0) {
                this.mWifiSupplStateTimer[this.mWifiSupplState].stopRunningLocked(elapsedRealtimeMs);
            }
            this.mWifiSupplState = supplState;
            this.mWifiSupplStateTimer[supplState].startRunningLocked(elapsedRealtimeMs);
            this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFFF0 | supplState << 0;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
    }

    @GuardedBy(value={"this"})
    void stopAllWifiSignalStrengthTimersLocked(int except, long elapsedRealtimeMs) {
        for (int i = 0; i < 5; ++i) {
            if (i == except) continue;
            while (this.mWifiSignalStrengthsTimer[i].isRunningLocked()) {
                this.mWifiSignalStrengthsTimer[i].stopRunningLocked(elapsedRealtimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiRssiChangedLocked(int newRssi) {
        this.noteWifiRssiChangedLocked(newRssi, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiRssiChangedLocked(int newRssi, long elapsedRealtimeMs, long uptimeMs) {
        int strengthBin = WifiManager.calculateSignalLevel(newRssi, 5);
        if (this.mWifiSignalStrengthBin != strengthBin) {
            if (this.mWifiSignalStrengthBin >= 0) {
                this.mWifiSignalStrengthsTimer[this.mWifiSignalStrengthBin].stopRunningLocked(elapsedRealtimeMs);
            }
            if (strengthBin >= 0) {
                if (!this.mWifiSignalStrengthsTimer[strengthBin].isRunningLocked()) {
                    this.mWifiSignalStrengthsTimer[strengthBin].startRunningLocked(elapsedRealtimeMs);
                }
                this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFF8F | strengthBin << 4;
                this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            } else {
                this.stopAllWifiSignalStrengthTimersLocked(-1, elapsedRealtimeMs);
            }
            this.mWifiSignalStrengthBin = strengthBin;
        }
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void noteFullWifiLockAcquiredLocked(int uid) {
        this.noteFullWifiLockAcquiredLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteFullWifiLockAcquiredLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states |= 0x10000000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
        ++this.mWifiFullLockNesting;
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteFullWifiLockAcquiredLocked(elapsedRealtimeMs);
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void noteFullWifiLockReleasedLocked(int uid) {
        this.noteFullWifiLockReleasedLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteFullWifiLockReleasedLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        --this.mWifiFullLockNesting;
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states &= 0xEFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteFullWifiLockReleasedLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteWifiScanStartedLocked(int uid) {
        this.noteWifiScanStartedLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiScanStartedLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states |= 0x8000000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
        ++this.mWifiScanNesting;
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiScanStartedLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteWifiScanStoppedLocked(int uid) {
        this.noteWifiScanStoppedLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiScanStoppedLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        --this.mWifiScanNesting;
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiScanStoppedLocked(elapsedRealtimeMs);
    }

    public void noteWifiBatchedScanStartedLocked(int uid, int csph) {
        this.noteWifiBatchedScanStartedLocked(uid, csph, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    public void noteWifiBatchedScanStartedLocked(int uid, int csph, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiBatchedScanStartedLocked(csph, elapsedRealtimeMs);
    }

    public void noteWifiBatchedScanStoppedLocked(int uid) {
        this.noteWifiBatchedScanStoppedLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    public void noteWifiBatchedScanStoppedLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiBatchedScanStoppedLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    @UnsupportedAppUsage
    public void noteWifiMulticastEnabledLocked(int uid) {
        this.noteWifiMulticastEnabledLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiMulticastEnabledLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states |= 0x10000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            if (!this.mWifiMulticastWakelockTimer.isRunningLocked()) {
                this.mWifiMulticastWakelockTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }
        ++this.mWifiMulticastNesting;
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiMulticastEnabledLocked(elapsedRealtimeMs);
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void noteWifiMulticastDisabledLocked(int uid) {
        this.noteWifiMulticastDisabledLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiMulticastDisabledLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        --this.mWifiMulticastNesting;
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states &= 0xFFFEFFFF;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            if (this.mWifiMulticastWakelockTimer.isRunningLocked()) {
                this.mWifiMulticastWakelockTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }
        this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).noteWifiMulticastDisabledLocked(elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void noteFullWifiLockAcquiredFromSourceLocked(WorkSource ws) {
        this.noteFullWifiLockAcquiredFromSourceLocked(ws, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteFullWifiLockAcquiredFromSourceLocked(WorkSource ws, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.noteFullWifiLockAcquiredLocked(uid, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = this.mapUid(workChain.getAttributionUid());
                this.noteFullWifiLockAcquiredLocked(uid, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteFullWifiLockReleasedFromSourceLocked(WorkSource ws) {
        this.noteFullWifiLockReleasedFromSourceLocked(ws, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteFullWifiLockReleasedFromSourceLocked(WorkSource ws, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.noteFullWifiLockReleasedLocked(uid, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = this.mapUid(workChain.getAttributionUid());
                this.noteFullWifiLockReleasedLocked(uid, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiScanStartedFromSourceLocked(WorkSource ws) {
        this.noteWifiScanStartedFromSourceLocked(ws, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiScanStartedFromSourceLocked(WorkSource ws, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.noteWifiScanStartedLocked(uid, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = this.mapUid(workChain.getAttributionUid());
                this.noteWifiScanStartedLocked(uid, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiScanStoppedFromSourceLocked(WorkSource ws) {
        this.noteWifiScanStoppedFromSourceLocked(ws, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiScanStoppedFromSourceLocked(WorkSource ws, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.noteWifiScanStoppedLocked(uid, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = this.mapUid(workChain.getAttributionUid());
                this.noteWifiScanStoppedLocked(uid, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiBatchedScanStartedFromSourceLocked(WorkSource ws, int csph) {
        this.noteWifiBatchedScanStartedFromSourceLocked(ws, csph, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiBatchedScanStartedFromSourceLocked(WorkSource ws, int csph, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStartedLocked(ws.getUid(i), csph, elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                this.noteWifiBatchedScanStartedLocked(workChains.get(i).getAttributionUid(), csph, elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void noteWifiBatchedScanStoppedFromSourceLocked(WorkSource ws) {
        this.noteWifiBatchedScanStoppedFromSourceLocked(ws, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    @GuardedBy(value={"this"})
    public void noteWifiBatchedScanStoppedFromSourceLocked(WorkSource ws, long elapsedRealtimeMs, long uptimeMs) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStoppedLocked(ws.getUid(i), elapsedRealtimeMs, uptimeMs);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                this.noteWifiBatchedScanStoppedLocked(workChains.get(i).getAttributionUid(), elapsedRealtimeMs, uptimeMs);
            }
        }
    }

    private static String[] includeInStringArray(String[] array2, String str) {
        if (ArrayUtils.indexOf(array2, str) >= 0) {
            return array2;
        }
        String[] newArray = new String[array2.length + 1];
        System.arraycopy(array2, 0, newArray, 0, array2.length);
        newArray[array2.length] = str;
        return newArray;
    }

    private static String[] excludeFromStringArray(String[] array2, String str) {
        int index = ArrayUtils.indexOf(array2, str);
        if (index >= 0) {
            String[] newArray = new String[array2.length - 1];
            if (index > 0) {
                System.arraycopy(array2, 0, newArray, 0, index);
            }
            if (index < array2.length - 1) {
                System.arraycopy(array2, index + 1, newArray, index, array2.length - index - 1);
            }
            return newArray;
        }
        return array2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteNetworkInterfaceForTransports(String iface, int[] transportTypes) {
        if (TextUtils.isEmpty(iface)) {
            return;
        }
        int displayTransport = NetworkCapabilitiesUtils.getDisplayTransport(transportTypes);
        Object object = this.mModemNetworkLock;
        synchronized (object) {
            this.mModemIfaces = displayTransport == 0 ? BatteryStatsImpl.includeInStringArray(this.mModemIfaces, iface) : BatteryStatsImpl.excludeFromStringArray(this.mModemIfaces, iface);
        }
        object = this.mWifiNetworkLock;
        synchronized (object) {
            this.mWifiIfaces = displayTransport == 1 ? BatteryStatsImpl.includeInStringArray(this.mWifiIfaces, iface) : BatteryStatsImpl.excludeFromStringArray(this.mWifiIfaces, iface);
        }
    }

    public void noteBinderCallStats(int workSourceUid, long incrementalCallCount, Collection<BinderCallsStats.CallStat> callStats) {
        this.noteBinderCallStats(workSourceUid, incrementalCallCount, callStats, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteBinderCallStats(int workSourceUid, long incrementalCallCount, Collection<BinderCallsStats.CallStat> callStats, long elapsedRealtimeMs, long uptimeMs) {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            this.getUidStatsLocked(workSourceUid, elapsedRealtimeMs, uptimeMs).noteBinderCallStatsLocked(incrementalCallCount, callStats);
        }
    }

    public void noteBinderThreadNativeIds(int[] binderThreadNativeTids) {
        this.mSystemServerCpuThreadReader.setBinderThreadNativeTids(binderThreadNativeTids);
    }

    @VisibleForTesting
    public void updateSystemServiceCallStats() {
        int i;
        int totalRecordedCallCount = 0;
        long totalRecordedCallTimeMicros = 0L;
        for (int i2 = 0; i2 < this.mUidStats.size(); ++i2) {
            Uid uid = this.mUidStats.valueAt(i2);
            ArraySet<BinderCallStats> binderCallStats = uid.mBinderCallStats;
            for (int j = binderCallStats.size() - 1; j >= 0; --j) {
                BinderCallStats stats = binderCallStats.valueAt(j);
                totalRecordedCallCount = (int)((long)totalRecordedCallCount + stats.recordedCallCount);
                totalRecordedCallTimeMicros += stats.recordedCpuTimeMicros;
            }
        }
        long totalSystemServiceTimeMicros = 0L;
        for (i = 0; i < this.mUidStats.size(); ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            long totalTimeForUidUs = 0L;
            int totalCallCountForUid = 0;
            ArraySet<BinderCallStats> binderCallStats = uid.mBinderCallStats;
            for (int j = binderCallStats.size() - 1; j >= 0; --j) {
                BinderCallStats stats = binderCallStats.valueAt(j);
                totalCallCountForUid = (int)((long)totalCallCountForUid + stats.callCount);
                if (stats.recordedCallCount > 0L) {
                    totalTimeForUidUs += stats.callCount * stats.recordedCpuTimeMicros / stats.recordedCallCount;
                    continue;
                }
                if (totalRecordedCallCount <= 0) continue;
                totalTimeForUidUs += stats.callCount * totalRecordedCallTimeMicros / (long)totalRecordedCallCount;
            }
            if ((long)totalCallCountForUid < uid.mBinderCallCount && totalRecordedCallCount > 0) {
                totalTimeForUidUs += (uid.mBinderCallCount - (long)totalCallCountForUid) * totalRecordedCallTimeMicros / (long)totalRecordedCallCount;
            }
            uid.mSystemServiceTimeUs = totalTimeForUidUs;
            totalSystemServiceTimeMicros += totalTimeForUidUs;
        }
        for (i = 0; i < this.mUidStats.size(); ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            uid.mProportionalSystemServiceUsage = totalSystemServiceTimeMicros > 0L ? (double)uid.mSystemServiceTimeUs / (double)totalSystemServiceTimeMicros : 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getWifiIfaces() {
        Object object = this.mWifiNetworkLock;
        synchronized (object) {
            return this.mWifiIfaces;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMobileIfaces() {
        Object object = this.mModemNetworkLock;
        synchronized (object) {
            return this.mModemIfaces;
        }
    }

    @Override
    @UnsupportedAppUsage
    public long getScreenOnTime(long elapsedRealtimeUs, int which) {
        return this.mScreenOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getScreenOnCount(int which) {
        return this.mScreenOnTimer.getCountLocked(which);
    }

    @Override
    public long getScreenDozeTime(long elapsedRealtimeUs, int which) {
        return this.mScreenDozeTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getScreenDozeCount(int which) {
        return this.mScreenDozeTimer.getCountLocked(which);
    }

    @Override
    @UnsupportedAppUsage
    public long getScreenBrightnessTime(int brightnessBin, long elapsedRealtimeUs, int which) {
        return this.mScreenBrightnessTimer[brightnessBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public Timer getScreenBrightnessTimer(int brightnessBin) {
        return this.mScreenBrightnessTimer[brightnessBin];
    }

    @Override
    public int getDisplayCount() {
        return this.mPerDisplayBatteryStats.length;
    }

    @Override
    public long getDisplayScreenOnTime(int display, long elapsedRealtimeUs) {
        return this.mPerDisplayBatteryStats[display].screenOnTimer.getTotalTimeLocked(elapsedRealtimeUs, 0);
    }

    @Override
    public long getDisplayScreenDozeTime(int display, long elapsedRealtimeUs) {
        return this.mPerDisplayBatteryStats[display].screenDozeTimer.getTotalTimeLocked(elapsedRealtimeUs, 0);
    }

    @Override
    public long getDisplayScreenBrightnessTime(int display, int brightnessBin, long elapsedRealtimeUs) {
        DisplayBatteryStats displayStats = this.mPerDisplayBatteryStats[display];
        return displayStats.screenBrightnessTimers[brightnessBin].getTotalTimeLocked(elapsedRealtimeUs, 0);
    }

    @Override
    public long getInteractiveTime(long elapsedRealtimeUs, int which) {
        return this.mInteractiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getPowerSaveModeEnabledTime(long elapsedRealtimeUs, int which) {
        return this.mPowerSaveModeEnabledTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getPowerSaveModeEnabledCount(int which) {
        return this.mPowerSaveModeEnabledTimer.getCountLocked(which);
    }

    @Override
    public long getDeviceIdleModeTime(int mode, long elapsedRealtimeUs, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceIdleModeLightTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
            case 2: {
                return this.mDeviceIdleModeFullTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
        }
        return 0L;
    }

    @Override
    public int getDeviceIdleModeCount(int mode, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceIdleModeLightTimer.getCountLocked(which);
            }
            case 2: {
                return this.mDeviceIdleModeFullTimer.getCountLocked(which);
            }
        }
        return 0;
    }

    @Override
    public long getLongestDeviceIdleModeTime(int mode) {
        switch (mode) {
            case 1: {
                return this.mLongestLightIdleTimeMs;
            }
            case 2: {
                return this.mLongestFullIdleTimeMs;
            }
        }
        return 0L;
    }

    @Override
    public long getDeviceIdlingTime(int mode, long elapsedRealtimeUs, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceLightIdlingTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
            case 2: {
                return this.mDeviceIdlingTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
        }
        return 0L;
    }

    @Override
    public int getDeviceIdlingCount(int mode, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceLightIdlingTimer.getCountLocked(which);
            }
            case 2: {
                return this.mDeviceIdlingTimer.getCountLocked(which);
            }
        }
        return 0;
    }

    @Override
    public int getNumConnectivityChange(int which) {
        return this.mNumConnectivityChange;
    }

    @Override
    public long getGpsSignalQualityTime(int strengthBin, long elapsedRealtimeUs, int which) {
        if (strengthBin < 0 || strengthBin >= this.mGpsSignalQualityTimer.length) {
            return 0L;
        }
        return this.mGpsSignalQualityTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getGpsBatteryDrainMaMs() {
        double opVolt = this.mPowerProfile.getAveragePower("gps.voltage") / 1000.0;
        if (opVolt == 0.0) {
            return 0L;
        }
        double energyUsedMaMs = 0.0;
        boolean which = false;
        long rawRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
        for (int i = 0; i < this.mGpsSignalQualityTimer.length; ++i) {
            energyUsedMaMs += this.mPowerProfile.getAveragePower("gps.signalqualitybased", i) * (double)(this.getGpsSignalQualityTime(i, rawRealtimeUs, 0) / 1000L);
        }
        return (long)energyUsedMaMs;
    }

    @Override
    @UnsupportedAppUsage
    public long getPhoneOnTime(long elapsedRealtimeUs, int which) {
        return this.mPhoneOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getPhoneOnCount(int which) {
        return this.mPhoneOnTimer.getCountLocked(which);
    }

    @Override
    @UnsupportedAppUsage
    public long getPhoneSignalStrengthTime(int strengthBin, long elapsedRealtimeUs, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    @UnsupportedAppUsage
    public long getPhoneSignalScanningTime(long elapsedRealtimeUs, int which) {
        return this.mPhoneSignalScanningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public Timer getPhoneSignalScanningTimer() {
        return this.mPhoneSignalScanningTimer;
    }

    @Override
    @UnsupportedAppUsage
    public int getPhoneSignalStrengthCount(int strengthBin, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getCountLocked(which);
    }

    @Override
    public Timer getPhoneSignalStrengthTimer(int strengthBin) {
        return this.mPhoneSignalStrengthsTimer[strengthBin];
    }

    @Override
    @UnsupportedAppUsage
    public long getPhoneDataConnectionTime(int dataType, long elapsedRealtimeUs, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    @UnsupportedAppUsage
    public int getPhoneDataConnectionCount(int dataType, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getCountLocked(which);
    }

    @Override
    public Timer getPhoneDataConnectionTimer(int dataType) {
        return this.mPhoneDataConnectionsTimer[dataType];
    }

    @Override
    public long getActiveRadioDurationMs(int rat, int frequencyRange, int signalStrength, long elapsedRealtimeMs) {
        RadioAccessTechnologyBatteryStats stats = this.mPerRatBatteryStats[rat];
        if (stats == null) {
            return 0L;
        }
        int freqCount = stats.perStateTimers.length;
        if (frequencyRange < 0 || frequencyRange >= freqCount) {
            return 0L;
        }
        StopwatchTimer[] strengthTimers = stats.perStateTimers[frequencyRange];
        int strengthCount = strengthTimers.length;
        if (signalStrength < 0 || signalStrength >= strengthCount) {
            return 0L;
        }
        return stats.perStateTimers[frequencyRange][signalStrength].getTotalTimeLocked(elapsedRealtimeMs * 1000L, 0) / 1000L;
    }

    @Override
    public long getActiveTxRadioDurationMs(int rat, int frequencyRange, int signalStrength, long elapsedRealtimeMs) {
        RadioAccessTechnologyBatteryStats stats = this.mPerRatBatteryStats[rat];
        if (stats == null) {
            return -1L;
        }
        LongSamplingCounter counter = stats.getTxDurationCounter(frequencyRange, signalStrength, false);
        if (counter == null) {
            return -1L;
        }
        return counter.getCountLocked(0);
    }

    @Override
    public long getActiveRxRadioDurationMs(int rat, int frequencyRange, long elapsedRealtimeMs) {
        RadioAccessTechnologyBatteryStats stats = this.mPerRatBatteryStats[rat];
        if (stats == null) {
            return -1L;
        }
        LongSamplingCounter counter = stats.getRxDurationCounter(frequencyRange, false);
        if (counter == null) {
            return -1L;
        }
        return counter.getCountLocked(0);
    }

    @Override
    @UnsupportedAppUsage
    public long getMobileRadioActiveTime(long elapsedRealtimeUs, int which) {
        return this.mMobileRadioActiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getMobileRadioActiveCount(int which) {
        return this.mMobileRadioActiveTimer.getCountLocked(which);
    }

    @Override
    public long getMobileRadioActiveAdjustedTime(int which) {
        return this.mMobileRadioActiveAdjustedTime.getCountLocked(which);
    }

    @Override
    public long getMobileRadioActiveUnknownTime(int which) {
        return this.mMobileRadioActiveUnknownTime.getCountLocked(which);
    }

    @Override
    public int getMobileRadioActiveUnknownCount(int which) {
        return (int)this.mMobileRadioActiveUnknownCount.getCountLocked(which);
    }

    @Override
    public long getWifiMulticastWakelockTime(long elapsedRealtimeUs, int which) {
        return this.mWifiMulticastWakelockTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiMulticastWakelockCount(int which) {
        return this.mWifiMulticastWakelockTimer.getCountLocked(which);
    }

    @Override
    @UnsupportedAppUsage
    public long getWifiOnTime(long elapsedRealtimeUs, int which) {
        return this.mWifiOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getWifiActiveTime(long elapsedRealtimeUs, int which) {
        return this.mWifiActiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    @UnsupportedAppUsage
    public long getGlobalWifiRunningTime(long elapsedRealtimeUs, int which) {
        return this.mGlobalWifiRunningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getWifiStateTime(int wifiState, long elapsedRealtimeUs, int which) {
        return this.mWifiStateTimer[wifiState].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiStateCount(int wifiState, int which) {
        return this.mWifiStateTimer[wifiState].getCountLocked(which);
    }

    @Override
    public Timer getWifiStateTimer(int wifiState) {
        return this.mWifiStateTimer[wifiState];
    }

    @Override
    public long getWifiSupplStateTime(int state, long elapsedRealtimeUs, int which) {
        return this.mWifiSupplStateTimer[state].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiSupplStateCount(int state, int which) {
        return this.mWifiSupplStateTimer[state].getCountLocked(which);
    }

    @Override
    public Timer getWifiSupplStateTimer(int state) {
        return this.mWifiSupplStateTimer[state];
    }

    @Override
    public long getWifiSignalStrengthTime(int strengthBin, long elapsedRealtimeUs, int which) {
        return this.mWifiSignalStrengthsTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiSignalStrengthCount(int strengthBin, int which) {
        return this.mWifiSignalStrengthsTimer[strengthBin].getCountLocked(which);
    }

    @Override
    public Timer getWifiSignalStrengthTimer(int strengthBin) {
        return this.mWifiSignalStrengthsTimer[strengthBin];
    }

    @Override
    public BatteryStats.ControllerActivityCounter getBluetoothControllerActivity() {
        return this.mBluetoothActivity;
    }

    @Override
    public BatteryStats.ControllerActivityCounter getWifiControllerActivity() {
        return this.mWifiActivity;
    }

    @Override
    public BatteryStats.ControllerActivityCounter getModemControllerActivity() {
        return this.mModemActivity;
    }

    @Override
    public boolean hasBluetoothActivityReporting() {
        return this.mHasBluetoothReporting;
    }

    @Override
    public boolean hasWifiActivityReporting() {
        return this.mHasWifiReporting;
    }

    @Override
    public boolean hasModemActivityReporting() {
        return this.mHasModemReporting;
    }

    @Override
    public long getFlashlightOnTime(long elapsedRealtimeUs, int which) {
        return this.mFlashlightOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getFlashlightOnCount(int which) {
        return this.mFlashlightOnTimer.getCountLocked(which);
    }

    @Override
    public long getCameraOnTime(long elapsedRealtimeUs, int which) {
        return this.mCameraOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getBluetoothScanTime(long elapsedRealtimeUs, int which) {
        return this.mBluetoothScanTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    @UnsupportedAppUsage
    public long getNetworkActivityBytes(int type, int which) {
        if (type >= 0 && type < this.mNetworkByteActivityCounters.length) {
            return this.mNetworkByteActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    @Override
    public long getNetworkActivityPackets(int type, int which) {
        if (type >= 0 && type < this.mNetworkPacketActivityCounters.length) {
            return this.mNetworkPacketActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    @Override
    @GuardedBy(value={"this"})
    public long getBluetoothMeasuredBatteryConsumptionUC() {
        return this.getPowerBucketConsumptionUC(5);
    }

    @Override
    @GuardedBy(value={"this"})
    public long getCpuMeasuredBatteryConsumptionUC() {
        return this.getPowerBucketConsumptionUC(3);
    }

    @Override
    @GuardedBy(value={"this"})
    public long getGnssMeasuredBatteryConsumptionUC() {
        return this.getPowerBucketConsumptionUC(6);
    }

    @Override
    @GuardedBy(value={"this"})
    public long getMobileRadioMeasuredBatteryConsumptionUC() {
        return this.getPowerBucketConsumptionUC(7);
    }

    @Override
    @GuardedBy(value={"this"})
    public long getScreenOnMeasuredBatteryConsumptionUC() {
        return this.getPowerBucketConsumptionUC(0);
    }

    @Override
    @GuardedBy(value={"this"})
    public long getScreenDozeMeasuredBatteryConsumptionUC() {
        return this.getPowerBucketConsumptionUC(1);
    }

    @Override
    @GuardedBy(value={"this"})
    public long getWifiMeasuredBatteryConsumptionUC() {
        return this.getPowerBucketConsumptionUC(4);
    }

    @GuardedBy(value={"this"})
    private long getPowerBucketConsumptionUC(int bucket) {
        if (this.mGlobalMeasuredEnergyStats == null) {
            return -1L;
        }
        return this.mGlobalMeasuredEnergyStats.getAccumulatedStandardBucketCharge(bucket);
    }

    @Override
    @GuardedBy(value={"this"})
    public long[] getCustomConsumerMeasuredBatteryConsumptionUC() {
        if (this.mGlobalMeasuredEnergyStats == null) {
            return null;
        }
        return this.mGlobalMeasuredEnergyStats.getAccumulatedCustomBucketCharges();
    }

    @Override
    @GuardedBy(value={"this"})
    public String[] getCustomEnergyConsumerNames() {
        if (this.mMeasuredEnergyStatsConfig == null) {
            return new String[0];
        }
        String[] names = this.mMeasuredEnergyStatsConfig.getCustomBucketNames();
        for (int i = 0; i < names.length; ++i) {
            if (!TextUtils.isEmpty(names[i])) continue;
            names[i] = "CUSTOM_1000" + i;
        }
        return names;
    }

    @Override
    @GuardedBy(value={"this"})
    public long getStartClockTime() {
        long currentTimeMs = this.mClock.currentTimeMillis();
        if (currentTimeMs > 31536000000L && this.mStartClockTimeMs < currentTimeMs - 31536000000L || this.mStartClockTimeMs > currentTimeMs) {
            this.recordCurrentTimeChangeLocked(currentTimeMs, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
            return currentTimeMs - (this.mClock.elapsedRealtime() - this.mRealtimeStartUs / 1000L);
        }
        return this.mStartClockTimeMs;
    }

    @Override
    public String getStartPlatformVersion() {
        return this.mStartPlatformVersion;
    }

    @Override
    public String getEndPlatformVersion() {
        return this.mEndPlatformVersion;
    }

    @Override
    public int getParcelVersion() {
        return 208;
    }

    @Override
    public boolean getIsOnBattery() {
        return this.mOnBattery;
    }

    @Override
    public long getStatsStartRealtime() {
        return this.mRealtimeStartUs;
    }

    @Override
    @UnsupportedAppUsage
    public SparseArray<? extends BatteryStats.Uid> getUidStats() {
        return this.mUidStats;
    }

    private static <T extends TimeBaseObs> boolean resetIfNotNull(T t, boolean detachIfReset, long elapsedRealtimeUs) {
        if (t != null) {
            return t.reset(detachIfReset, elapsedRealtimeUs);
        }
        return true;
    }

    private static <T extends TimeBaseObs> boolean resetIfNotNull(T[] t, boolean detachIfReset, long elapsedRealtimeUs) {
        if (t != null) {
            boolean ret = true;
            for (int i = 0; i < t.length; ++i) {
                ret &= BatteryStatsImpl.resetIfNotNull(t[i], detachIfReset, elapsedRealtimeUs);
            }
            return ret;
        }
        return true;
    }

    private static <T extends TimeBaseObs> boolean resetIfNotNull(T[][] t, boolean detachIfReset, long elapsedRealtimeUs) {
        if (t != null) {
            boolean ret = true;
            for (int i = 0; i < t.length; ++i) {
                ret &= BatteryStatsImpl.resetIfNotNull(t[i], detachIfReset, elapsedRealtimeUs);
            }
            return ret;
        }
        return true;
    }

    private static boolean resetIfNotNull(ControllerActivityCounterImpl counter, boolean detachIfReset, long elapsedRealtimeUs) {
        if (counter != null) {
            counter.reset(detachIfReset, elapsedRealtimeUs);
        }
        return true;
    }

    private static <T extends TimeBaseObs> void detachIfNotNull(T t) {
        if (t != null) {
            t.detach();
        }
    }

    private static <T extends TimeBaseObs> void detachIfNotNull(T[] t) {
        if (t != null) {
            for (int i = 0; i < t.length; ++i) {
                BatteryStatsImpl.detachIfNotNull(t[i]);
            }
        }
    }

    private static <T extends TimeBaseObs> void detachIfNotNull(T[][] t) {
        if (t != null) {
            for (int i = 0; i < t.length; ++i) {
                BatteryStatsImpl.detachIfNotNull(t[i]);
            }
        }
    }

    private static void detachIfNotNull(ControllerActivityCounterImpl counter) {
        if (counter != null) {
            counter.detach();
        }
    }

    @Override
    @GuardedBy(value={"this"})
    public long[] getCpuFreqs() {
        if (!this.mCpuFreqsInitialized) {
            this.mCpuFreqs = this.mCpuUidFreqTimeReader.readFreqs(this.mPowerProfile);
            this.mCpuFreqsInitialized = true;
        }
        return this.mCpuFreqs;
    }

    @Override
    @GuardedBy(value={"this"})
    public int getCpuFreqCount() {
        long[] cpuFreqs = this.getCpuFreqs();
        return cpuFreqs != null ? cpuFreqs.length : 0;
    }

    @GuardedBy(value={"this"})
    private LongArrayMultiStateCounter.LongArrayContainer getCpuTimeInFreqContainer() {
        if (this.mTmpCpuTimeInFreq == null) {
            this.mTmpCpuTimeInFreq = new LongArrayMultiStateCounter.LongArrayContainer(this.getCpuFreqCount());
        }
        return this.mTmpCpuTimeInFreq;
    }

    public BatteryStatsImpl(File systemDir, Handler handler, PlatformIdleStateCallback cb, MeasuredEnergyRetriever energyStatsCb, UserInfoProvider userInfoProvider) {
        this(Clock.SYSTEM_CLOCK, systemDir, handler, cb, energyStatsCb, userInfoProvider);
    }

    private BatteryStatsImpl(Clock clock, File systemDir, Handler handler, PlatformIdleStateCallback cb, MeasuredEnergyRetriever energyStatsCb, UserInfoProvider userInfoProvider) {
        this.init(clock);
        if (systemDir == null) {
            this.mStatsFile = null;
            this.mBatteryStatsHistory = new BatteryStatsHistory(this.mHistoryBuffer);
        } else {
            this.mStatsFile = new AtomicFile(new File(systemDir, "batterystats.bin"));
            this.mBatteryStatsHistory = new BatteryStatsHistory(this, systemDir, this.mHistoryBuffer);
        }
        this.mCheckinFile = new AtomicFile(new File(systemDir, "batterystats-checkin.bin"));
        this.mDailyFile = new AtomicFile(new File(systemDir, "batterystats-daily.xml"));
        this.mHandler = new MyHandler(handler.getLooper());
        this.mConstants = new Constants(this.mHandler);
        ++this.mStartCount;
        this.initTimersAndCounters();
        this.mOnBatteryInternal = false;
        this.mOnBattery = false;
        long uptimeUs = this.mClock.uptimeMillis() * 1000L;
        long realtimeUs = this.mClock.elapsedRealtime() * 1000L;
        this.initTimes(uptimeUs, realtimeUs);
        this.mStartPlatformVersion = this.mEndPlatformVersion = _Original_Build.ID;
        this.initDischarge(realtimeUs);
        this.clearHistoryLocked();
        this.updateDailyDeadlineLocked();
        this.mPlatformIdleStateCallback = cb;
        this.mMeasuredEnergyRetriever = energyStatsCb;
        this.mUserInfoProvider = userInfoProvider;
        this.mDeviceIdleMode = 0;
        FrameworkStatsLog.write(21, this.mDeviceIdleMode);
    }

    @VisibleForTesting
    protected void initTimersAndCounters() {
        int i;
        this.mScreenOnTimer = new StopwatchTimer(this.mClock, null, -1, null, this.mOnBatteryTimeBase);
        this.mScreenDozeTimer = new StopwatchTimer(this.mClock, null, -1, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(this.mClock, null, -100 - i, null, this.mOnBatteryTimeBase);
        }
        this.mPerDisplayBatteryStats = new DisplayBatteryStats[1];
        this.mPerDisplayBatteryStats[0] = new DisplayBatteryStats(this.mClock, this.mOnBatteryTimeBase);
        this.mInteractiveTimer = new StopwatchTimer(this.mClock, null, -10, null, this.mOnBatteryTimeBase);
        this.mPowerSaveModeEnabledTimer = new StopwatchTimer(this.mClock, null, -2, null, this.mOnBatteryTimeBase);
        this.mDeviceIdleModeLightTimer = new StopwatchTimer(this.mClock, null, -11, null, this.mOnBatteryTimeBase);
        this.mDeviceIdleModeFullTimer = new StopwatchTimer(this.mClock, null, -14, null, this.mOnBatteryTimeBase);
        this.mDeviceLightIdlingTimer = new StopwatchTimer(this.mClock, null, -15, null, this.mOnBatteryTimeBase);
        this.mDeviceIdlingTimer = new StopwatchTimer(this.mClock, null, -12, null, this.mOnBatteryTimeBase);
        this.mPhoneOnTimer = new StopwatchTimer(this.mClock, null, -3, null, this.mOnBatteryTimeBase);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(this.mClock, null, -200 - i, null, this.mOnBatteryTimeBase);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(this.mClock, null, -199, null, this.mOnBatteryTimeBase);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(this.mClock, null, -300 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
        }
        this.mWifiActivity = new ControllerActivityCounterImpl(this.mClock, this.mOnBatteryTimeBase, 1);
        this.mBluetoothActivity = new ControllerActivityCounterImpl(this.mClock, this.mOnBatteryTimeBase, 1);
        this.mModemActivity = new ControllerActivityCounterImpl(this.mClock, this.mOnBatteryTimeBase, ModemActivityInfo.getNumTxPowerLevels());
        this.mMobileRadioActiveTimer = new StopwatchTimer(this.mClock, null, -400, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(this.mClock, null, -401, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mWifiMulticastWakelockTimer = new StopwatchTimer(this.mClock, null, 23, null, this.mOnBatteryTimeBase);
        this.mWifiOnTimer = new StopwatchTimer(this.mClock, null, -4, null, this.mOnBatteryTimeBase);
        this.mGlobalWifiRunningTimer = new StopwatchTimer(this.mClock, null, -5, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(this.mClock, null, -600 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(this.mClock, null, -700 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(this.mClock, null, -800 - i, null, this.mOnBatteryTimeBase);
        }
        this.mWifiActiveTimer = new StopwatchTimer(this.mClock, null, -900, null, this.mOnBatteryTimeBase);
        for (i = 0; i < this.mGpsSignalQualityTimer.length; ++i) {
            this.mGpsSignalQualityTimer[i] = new StopwatchTimer(this.mClock, null, -1000 - i, null, this.mOnBatteryTimeBase);
        }
        this.mAudioOnTimer = new StopwatchTimer(this.mClock, null, -7, null, this.mOnBatteryTimeBase);
        this.mVideoOnTimer = new StopwatchTimer(this.mClock, null, -8, null, this.mOnBatteryTimeBase);
        this.mFlashlightOnTimer = new StopwatchTimer(this.mClock, null, -9, null, this.mOnBatteryTimeBase);
        this.mCameraOnTimer = new StopwatchTimer(this.mClock, null, -13, null, this.mOnBatteryTimeBase);
        this.mBluetoothScanTimer = new StopwatchTimer(this.mClock, null, -14, null, this.mOnBatteryTimeBase);
        this.mDischargeScreenOffCounter = new LongSamplingCounter(this.mOnBatteryScreenOffTimeBase);
        this.mDischargeScreenDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mDischargeLightDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mDischargeDeepDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mDischargeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mDischargeStartLevel = 0;
        this.mDischargeUnplugLevel = 0;
        this.mDischargePlugLevel = -1;
        this.mDischargeCurrentLevel = 0;
        this.mCurrentBatteryLevel = 0;
    }

    @UnsupportedAppUsage
    public BatteryStatsImpl(Parcel p) {
        this(Clock.SYSTEM_CLOCK, p);
    }

    public BatteryStatsImpl(Clock clock, Parcel p) {
        this.init(clock);
        this.mStatsFile = null;
        this.mCheckinFile = null;
        this.mDailyFile = null;
        this.mHandler = null;
        this.mExternalSync = null;
        this.mConstants = new Constants(this.mHandler);
        this.clearHistoryLocked();
        this.mBatteryStatsHistory = new BatteryStatsHistory(this.mHistoryBuffer);
        this.readFromParcel(p);
        this.mPlatformIdleStateCallback = null;
        this.mMeasuredEnergyRetriever = null;
    }

    public void setPowerProfileLocked(PowerProfile profile) {
        this.mPowerProfile = profile;
        int numClusters = this.mPowerProfile.getNumCpuClusters();
        this.mKernelCpuSpeedReaders = new KernelCpuSpeedReader[numClusters];
        int firstCpuOfCluster = 0;
        for (int i = 0; i < numClusters; ++i) {
            int numSpeedSteps = this.mPowerProfile.getNumSpeedStepsInCpuCluster(i);
            this.mKernelCpuSpeedReaders[i] = new KernelCpuSpeedReader(firstCpuOfCluster, numSpeedSteps);
            firstCpuOfCluster += this.mPowerProfile.getNumCoresInCpuCluster(i);
        }
        if (this.mEstimatedBatteryCapacityMah == -1) {
            this.mEstimatedBatteryCapacityMah = (int)this.mPowerProfile.getBatteryCapacity();
        }
        this.setDisplayCountLocked(this.mPowerProfile.getNumDisplays());
    }

    PowerProfile getPowerProfile() {
        return this.mPowerProfile;
    }

    public void startTrackingSystemServerCpuTime() {
        this.mSystemServerCpuThreadReader.startTrackingThreadCpuTime();
    }

    public SystemServerCpuThreadReader.SystemServiceCpuThreadTimes getSystemServiceCpuThreadTimes() {
        return this.mSystemServerCpuThreadReader.readAbsolute();
    }

    public void setCallback(BatteryCallback cb) {
        this.mCallback = cb;
    }

    public void setRadioScanningTimeoutLocked(long timeoutUs) {
        if (this.mPhoneSignalScanningTimer != null) {
            this.mPhoneSignalScanningTimer.setTimeout(timeoutUs);
        }
    }

    public void setExternalStatsSyncLocked(ExternalStatsSync sync) {
        this.mExternalSync = sync;
    }

    public void setDisplayCountLocked(int numDisplays) {
        this.mPerDisplayBatteryStats = new DisplayBatteryStats[numDisplays];
        for (int i = 0; i < numDisplays; ++i) {
            this.mPerDisplayBatteryStats[i] = new DisplayBatteryStats(this.mClock, this.mOnBatteryTimeBase);
        }
    }

    public void updateDailyDeadlineLocked() {
        long currentTimeMs = this.mDailyStartTimeMs = this.mClock.currentTimeMillis();
        Calendar calDeadline = Calendar.getInstance();
        calDeadline.setTimeInMillis(currentTimeMs);
        calDeadline.set(6, calDeadline.get(6) + 1);
        calDeadline.set(14, 0);
        calDeadline.set(13, 0);
        calDeadline.set(12, 0);
        calDeadline.set(11, 1);
        this.mNextMinDailyDeadlineMs = calDeadline.getTimeInMillis();
        calDeadline.set(11, 3);
        this.mNextMaxDailyDeadlineMs = calDeadline.getTimeInMillis();
    }

    public void recordDailyStatsIfNeededLocked(boolean settled, long currentTimeMs) {
        if (currentTimeMs >= this.mNextMaxDailyDeadlineMs) {
            this.recordDailyStatsLocked();
        } else if (settled && currentTimeMs >= this.mNextMinDailyDeadlineMs) {
            this.recordDailyStatsLocked();
        } else if (currentTimeMs < this.mDailyStartTimeMs - 86400000L) {
            this.recordDailyStatsLocked();
        }
    }

    public void recordDailyStatsLocked() {
        BatteryStats.DailyItem item = new BatteryStats.DailyItem();
        item.mStartTime = this.mDailyStartTimeMs;
        item.mEndTime = this.mClock.currentTimeMillis();
        boolean hasData = false;
        if (this.mDailyDischargeStepTracker.mNumStepDurations > 0) {
            hasData = true;
            item.mDischargeSteps = new BatteryStats.LevelStepTracker(this.mDailyDischargeStepTracker.mNumStepDurations, this.mDailyDischargeStepTracker.mStepDurations);
        }
        if (this.mDailyChargeStepTracker.mNumStepDurations > 0) {
            hasData = true;
            item.mChargeSteps = new BatteryStats.LevelStepTracker(this.mDailyChargeStepTracker.mNumStepDurations, this.mDailyChargeStepTracker.mStepDurations);
        }
        if (this.mDailyPackageChanges != null) {
            hasData = true;
            item.mPackageChanges = this.mDailyPackageChanges;
            this.mDailyPackageChanges = null;
        }
        this.mDailyDischargeStepTracker.init();
        this.mDailyChargeStepTracker.init();
        this.updateDailyDeadlineLocked();
        if (hasData) {
            long startTimeMs = SystemClock.uptimeMillis();
            this.mDailyItems.add(item);
            while (this.mDailyItems.size() > 10) {
                this.mDailyItems.remove(0);
            }
            final ByteArrayOutputStream memStream = new ByteArrayOutputStream();
            try {
                TypedXmlSerializer out = Xml.resolveSerializer(memStream);
                this.writeDailyItemsLocked(out);
                final long initialTimeMs = SystemClock.uptimeMillis() - startTimeMs;
                BackgroundThread.getHandler().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicFile atomicFile = BatteryStatsImpl.this.mCheckinFile;
                        synchronized (atomicFile) {
                            long startTimeMs2 = SystemClock.uptimeMillis();
                            FileOutputStream stream = null;
                            try {
                                stream = BatteryStatsImpl.this.mDailyFile.startWrite();
                                memStream.writeTo(stream);
                                stream.flush();
                                BatteryStatsImpl.this.mDailyFile.finishWrite(stream);
                                EventLogTags.writeCommitSysConfigFile("batterystats-daily", initialTimeMs + SystemClock.uptimeMillis() - startTimeMs2);
                            }
                            catch (IOException e) {
                                Slog.w("BatteryStats", "Error writing battery daily items", e);
                                BatteryStatsImpl.this.mDailyFile.failWrite(stream);
                            }
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeDailyItemsLocked(TypedXmlSerializer out) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        out.startDocument(null, true);
        out.startTag(null, "daily-items");
        for (int i = 0; i < this.mDailyItems.size(); ++i) {
            BatteryStats.DailyItem dit = this.mDailyItems.get(i);
            out.startTag(null, "item");
            out.attributeLong(null, "start", dit.mStartTime);
            out.attributeLong(null, "end", dit.mEndTime);
            this.writeDailyLevelSteps(out, "dis", dit.mDischargeSteps, sb);
            this.writeDailyLevelSteps(out, "chg", dit.mChargeSteps, sb);
            if (dit.mPackageChanges != null) {
                for (int j = 0; j < dit.mPackageChanges.size(); ++j) {
                    BatteryStats.PackageChange pc = dit.mPackageChanges.get(j);
                    if (pc.mUpdate) {
                        out.startTag(null, "upd");
                        out.attribute(null, "pkg", pc.mPackageName);
                        out.attributeLong(null, "ver", pc.mVersionCode);
                        out.endTag(null, "upd");
                        continue;
                    }
                    out.startTag(null, "rem");
                    out.attribute(null, "pkg", pc.mPackageName);
                    out.endTag(null, "rem");
                }
            }
            out.endTag(null, "item");
        }
        out.endTag(null, "daily-items");
        out.endDocument();
    }

    private void writeDailyLevelSteps(TypedXmlSerializer out, String tag, BatteryStats.LevelStepTracker steps, StringBuilder tmpBuilder) throws IOException {
        if (steps != null) {
            out.startTag(null, tag);
            out.attributeInt(null, "n", steps.mNumStepDurations);
            for (int i = 0; i < steps.mNumStepDurations; ++i) {
                out.startTag(null, "s");
                tmpBuilder.setLength(0);
                steps.encodeEntryAt(i, tmpBuilder);
                out.attribute(null, "v", tmpBuilder.toString());
                out.endTag(null, "s");
            }
            out.endTag(null, tag);
        }
    }

    @GuardedBy(value={"this"})
    public void readDailyStatsLocked() {
        FileInputStream stream;
        Slog.d(TAG, "Reading daily items from " + this.mDailyFile.getBaseFile());
        this.mDailyItems.clear();
        try {
            stream = this.mDailyFile.openRead();
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            TypedXmlPullParser parser = Xml.resolvePullParser(stream);
            this.readDailyItemsLocked(parser);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void readDailyItemsLocked(TypedXmlPullParser parser) {
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("no start tag found");
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("item")) {
                    this.readDailyItemTagLocked(parser);
                    continue;
                }
                Slog.w(TAG, "Unknown element under <daily-items>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Failed parsing daily " + (Object)((Object)e));
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
    }

    void readDailyItemTagLocked(TypedXmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        BatteryStats.DailyItem dit = new BatteryStats.DailyItem();
        dit.mStartTime = parser.getAttributeLong(null, "start", 0L);
        dit.mEndTime = parser.getAttributeLong(null, "end", 0L);
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            BatteryStats.PackageChange pc;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("dis")) {
                this.readDailyItemTagDetailsLocked(parser, dit, false, "dis");
                continue;
            }
            if (tagName.equals("chg")) {
                this.readDailyItemTagDetailsLocked(parser, dit, true, "chg");
                continue;
            }
            if (tagName.equals("upd")) {
                if (dit.mPackageChanges == null) {
                    dit.mPackageChanges = new ArrayList();
                }
                pc = new BatteryStats.PackageChange();
                pc.mUpdate = true;
                pc.mPackageName = parser.getAttributeValue(null, "pkg");
                pc.mVersionCode = parser.getAttributeLong(null, "ver", 0L);
                dit.mPackageChanges.add(pc);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("rem")) {
                if (dit.mPackageChanges == null) {
                    dit.mPackageChanges = new ArrayList();
                }
                pc = new BatteryStats.PackageChange();
                pc.mUpdate = false;
                pc.mPackageName = parser.getAttributeValue(null, "pkg");
                dit.mPackageChanges.add(pc);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <item>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        this.mDailyItems.add(dit);
    }

    void readDailyItemTagDetailsLocked(TypedXmlPullParser parser, BatteryStats.DailyItem dit, boolean isCharge, String tag) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        int num = parser.getAttributeInt(null, "n", -1);
        if (num == -1) {
            Slog.w(TAG, "Missing 'n' attribute at " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
            return;
        }
        BatteryStats.LevelStepTracker steps = new BatteryStats.LevelStepTracker(num);
        if (isCharge) {
            dit.mChargeSteps = steps;
        } else {
            dit.mDischargeSteps = steps;
        }
        int i = 0;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("s".equals(tagName)) {
                String valueAttr;
                if (i >= num || (valueAttr = parser.getAttributeValue(null, "v")) == null) continue;
                steps.decodeEntryAt(i, valueAttr);
                ++i;
                continue;
            }
            Slog.w(TAG, "Unknown element under <" + tag + ">: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        steps.mNumStepDurations = i;
    }

    @Override
    public BatteryStats.DailyItem getDailyItemLocked(int daysAgo) {
        int index = this.mDailyItems.size() - 1 - daysAgo;
        return index >= 0 ? this.mDailyItems.get(index) : null;
    }

    @Override
    public long getCurrentDailyStartTime() {
        return this.mDailyStartTimeMs;
    }

    @Override
    public long getNextMinDailyDeadline() {
        return this.mNextMinDailyDeadlineMs;
    }

    @Override
    public long getNextMaxDailyDeadline() {
        return this.mNextMaxDailyDeadlineMs;
    }

    @Override
    @GuardedBy(value={"this"})
    public int getHistoryTotalSize() {
        return this.mConstants.MAX_HISTORY_BUFFER * this.mConstants.MAX_HISTORY_FILES;
    }

    @Override
    public int getHistoryUsedSize() {
        return this.mBatteryStatsHistory.getHistoryUsedSize();
    }

    @Override
    @UnsupportedAppUsage
    public boolean startIteratingHistoryLocked() {
        this.mBatteryStatsHistoryIterator = this.createBatteryStatsHistoryIterator();
        return true;
    }

    @VisibleForTesting
    public BatteryStatsHistoryIterator createBatteryStatsHistoryIterator() {
        return new BatteryStatsHistoryIterator(this.mBatteryStatsHistory);
    }

    @Override
    public int getHistoryStringPoolSize() {
        return this.mHistoryTagPool.size();
    }

    @Override
    public int getHistoryStringPoolBytes() {
        return this.mNumHistoryTagChars;
    }

    @Override
    public String getHistoryTagPoolString(int index) {
        this.ensureHistoryTagArray();
        BatteryStats.HistoryTag historyTag = this.mHistoryTags.get(index);
        return historyTag != null ? historyTag.string : null;
    }

    @Override
    public int getHistoryTagPoolUid(int index) {
        this.ensureHistoryTagArray();
        BatteryStats.HistoryTag historyTag = this.mHistoryTags.get(index);
        return historyTag != null ? historyTag.uid : -1;
    }

    private void ensureHistoryTagArray() {
        if (this.mHistoryTags != null) {
            return;
        }
        this.mHistoryTags = new SparseArray(this.mHistoryTagPool.size());
        for (Map.Entry<BatteryStats.HistoryTag, Integer> entry : this.mHistoryTagPool.entrySet()) {
            this.mHistoryTags.put((int)(entry.getValue() & 0xFFFF7FFF), entry.getKey());
        }
    }

    @Override
    @UnsupportedAppUsage
    public boolean getNextHistoryLocked(BatteryStats.HistoryItem out) {
        return this.mBatteryStatsHistoryIterator.next(out);
    }

    @Override
    public void finishIteratingHistoryLocked() {
        this.mBatteryStatsHistoryIterator = null;
    }

    @Override
    public long getHistoryBaseTime() {
        return this.mHistoryBaseTimeMs;
    }

    @Override
    public int getStartCount() {
        return this.mStartCount;
    }

    @UnsupportedAppUsage
    public boolean isOnBattery() {
        return this.mOnBattery;
    }

    public boolean isCharging() {
        return this.mCharging;
    }

    void initTimes(long uptimeUs, long realtimeUs) {
        this.mStartClockTimeMs = this.mClock.currentTimeMillis();
        this.mOnBatteryTimeBase.init(uptimeUs, realtimeUs);
        this.mOnBatteryScreenOffTimeBase.init(uptimeUs, realtimeUs);
        this.mRealtimeUs = 0L;
        this.mUptimeUs = 0L;
        this.mRealtimeStartUs = realtimeUs;
        this.mUptimeStartUs = uptimeUs;
    }

    void initDischarge(long elapsedRealtimeUs) {
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
        this.mDischargeAmountScreenOn = 0;
        this.mDischargeAmountScreenOnSinceCharge = 0;
        this.mDischargeAmountScreenOff = 0;
        this.mDischargeAmountScreenOffSinceCharge = 0;
        this.mDischargeAmountScreenDoze = 0;
        this.mDischargeAmountScreenDozeSinceCharge = 0;
        this.mDischargeStepTracker.init();
        this.mChargeStepTracker.init();
        this.mDischargeScreenOffCounter.reset(false, elapsedRealtimeUs);
        this.mDischargeScreenDozeCounter.reset(false, elapsedRealtimeUs);
        this.mDischargeLightDozeCounter.reset(false, elapsedRealtimeUs);
        this.mDischargeDeepDozeCounter.reset(false, elapsedRealtimeUs);
        this.mDischargeCounter.reset(false, elapsedRealtimeUs);
    }

    public void setBatteryResetListener(BatteryResetListener batteryResetListener) {
        this.mBatteryResetListener = batteryResetListener;
    }

    @GuardedBy(value={"this"})
    public void resetAllStatsCmdLocked() {
        long mSecUptime = this.mClock.uptimeMillis();
        long uptimeUs = mSecUptime * 1000L;
        long mSecRealtime = this.mClock.elapsedRealtime();
        long realtimeUs = mSecRealtime * 1000L;
        this.resetAllStatsLocked(mSecUptime, mSecRealtime, 2);
        this.mDischargeStartLevel = this.mHistoryCur.batteryLevel;
        this.pullPendingStateUpdatesLocked();
        this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
        byte by = this.mHistoryCur.batteryLevel;
        this.mCurrentBatteryLevel = by;
        this.mDischargePlugLevel = by;
        this.mDischargeUnplugLevel = by;
        this.mDischargeCurrentLevel = by;
        this.mOnBatteryTimeBase.reset(uptimeUs, realtimeUs);
        this.mOnBatteryScreenOffTimeBase.reset(uptimeUs, realtimeUs);
        if ((this.mHistoryCur.states & 0x80000) == 0) {
            if (Display.isOnState(this.mScreenState)) {
                this.mDischargeScreenOnUnplugLevel = this.mHistoryCur.batteryLevel;
                this.mDischargeScreenDozeUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else if (Display.isDozeState(this.mScreenState)) {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenDozeUnplugLevel = this.mHistoryCur.batteryLevel;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenDozeUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = this.mHistoryCur.batteryLevel;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenOff = 0;
            this.mDischargeAmountScreenDoze = 0;
        }
        this.initActiveHistoryEventsLocked(mSecRealtime, mSecUptime);
    }

    @GuardedBy(value={"this"})
    private void resetAllStatsLocked(long uptimeMillis, long elapsedRealtimeMillis, int resetReason) {
        int i;
        if (this.mBatteryResetListener != null) {
            this.mBatteryResetListener.prepareForBatteryStatsReset(resetReason);
        }
        long uptimeUs = uptimeMillis * 1000L;
        long elapsedRealtimeUs = elapsedRealtimeMillis * 1000L;
        this.mStartCount = 0;
        this.initTimes(uptimeUs, elapsedRealtimeUs);
        this.mScreenOnTimer.reset(false, elapsedRealtimeUs);
        this.mScreenDozeTimer.reset(false, elapsedRealtimeUs);
        for (int i2 = 0; i2 < 5; ++i2) {
            this.mScreenBrightnessTimer[i2].reset(false, elapsedRealtimeUs);
        }
        int numDisplays = this.mPerDisplayBatteryStats.length;
        for (i = 0; i < numDisplays; ++i) {
            this.mPerDisplayBatteryStats[i].reset(elapsedRealtimeUs);
        }
        this.mEstimatedBatteryCapacityMah = this.mPowerProfile != null ? (int)this.mPowerProfile.getBatteryCapacity() : -1;
        this.mLastLearnedBatteryCapacityUah = -1;
        this.mMinLearnedBatteryCapacityUah = -1;
        this.mMaxLearnedBatteryCapacityUah = -1;
        this.mInteractiveTimer.reset(false, elapsedRealtimeUs);
        this.mPowerSaveModeEnabledTimer.reset(false, elapsedRealtimeUs);
        this.mLastIdleTimeStartMs = elapsedRealtimeMillis;
        this.mLongestLightIdleTimeMs = 0L;
        this.mLongestFullIdleTimeMs = 0L;
        this.mDeviceIdleModeLightTimer.reset(false, elapsedRealtimeUs);
        this.mDeviceIdleModeFullTimer.reset(false, elapsedRealtimeUs);
        this.mDeviceLightIdlingTimer.reset(false, elapsedRealtimeUs);
        this.mDeviceIdlingTimer.reset(false, elapsedRealtimeUs);
        this.mPhoneOnTimer.reset(false, elapsedRealtimeUs);
        this.mAudioOnTimer.reset(false, elapsedRealtimeUs);
        this.mVideoOnTimer.reset(false, elapsedRealtimeUs);
        this.mFlashlightOnTimer.reset(false, elapsedRealtimeUs);
        this.mCameraOnTimer.reset(false, elapsedRealtimeUs);
        this.mBluetoothScanTimer.reset(false, elapsedRealtimeUs);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i].reset(false, elapsedRealtimeUs);
        }
        this.mPhoneSignalScanningTimer.reset(false, elapsedRealtimeUs);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i].reset(false, elapsedRealtimeUs);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i].reset(false, elapsedRealtimeUs);
            this.mNetworkPacketActivityCounters[i].reset(false, elapsedRealtimeUs);
        }
        for (i = 0; i < 3; ++i) {
            RadioAccessTechnologyBatteryStats stats = this.mPerRatBatteryStats[i];
            if (stats == null) continue;
            stats.reset(elapsedRealtimeUs);
        }
        this.mMobileRadioActiveTimer.reset(false, elapsedRealtimeUs);
        this.mMobileRadioActivePerAppTimer.reset(false, elapsedRealtimeUs);
        this.mMobileRadioActiveAdjustedTime.reset(false, elapsedRealtimeUs);
        this.mMobileRadioActiveUnknownTime.reset(false, elapsedRealtimeUs);
        this.mMobileRadioActiveUnknownCount.reset(false, elapsedRealtimeUs);
        this.mWifiOnTimer.reset(false, elapsedRealtimeUs);
        this.mGlobalWifiRunningTimer.reset(false, elapsedRealtimeUs);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].reset(false, elapsedRealtimeUs);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].reset(false, elapsedRealtimeUs);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].reset(false, elapsedRealtimeUs);
        }
        this.mWifiMulticastWakelockTimer.reset(false, elapsedRealtimeUs);
        this.mWifiActiveTimer.reset(false, elapsedRealtimeUs);
        this.mWifiActivity.reset(false, elapsedRealtimeUs);
        for (i = 0; i < this.mGpsSignalQualityTimer.length; ++i) {
            this.mGpsSignalQualityTimer[i].reset(false, elapsedRealtimeUs);
        }
        this.mBluetoothActivity.reset(false, elapsedRealtimeUs);
        this.mModemActivity.reset(false, elapsedRealtimeUs);
        this.mNumConnectivityChange = 0;
        for (i = 0; i < this.mUidStats.size(); ++i) {
            if (!this.mUidStats.valueAt(i).reset(uptimeUs, elapsedRealtimeUs, resetReason)) continue;
            this.mUidStats.valueAt(i).detachFromTimeBase();
            this.mUidStats.remove(this.mUidStats.keyAt(i));
            --i;
        }
        if (this.mRpmStats.size() > 0) {
            for (SamplingTimer timer : this.mRpmStats.values()) {
                this.mOnBatteryTimeBase.remove(timer);
            }
            this.mRpmStats.clear();
        }
        if (this.mScreenOffRpmStats.size() > 0) {
            for (SamplingTimer timer : this.mScreenOffRpmStats.values()) {
                this.mOnBatteryScreenOffTimeBase.remove(timer);
            }
            this.mScreenOffRpmStats.clear();
        }
        if (this.mKernelWakelockStats.size() > 0) {
            for (SamplingTimer timer : this.mKernelWakelockStats.values()) {
                this.mOnBatteryScreenOffTimeBase.remove(timer);
            }
            this.mKernelWakelockStats.clear();
        }
        if (this.mKernelMemoryStats.size() > 0) {
            for (int i3 = 0; i3 < this.mKernelMemoryStats.size(); ++i3) {
                this.mOnBatteryTimeBase.remove(this.mKernelMemoryStats.valueAt(i3));
            }
            this.mKernelMemoryStats.clear();
        }
        if (this.mWakeupReasonStats.size() > 0) {
            for (SamplingTimer timer : this.mWakeupReasonStats.values()) {
                this.mOnBatteryTimeBase.remove(timer);
            }
            this.mWakeupReasonStats.clear();
        }
        this.mTmpRailStats.reset();
        MeasuredEnergyStats.resetIfNotNull(this.mGlobalMeasuredEnergyStats);
        BatteryStatsImpl.resetIfNotNull(this.mBinderThreadCpuTimesUs, false, elapsedRealtimeUs);
        this.mLastHistoryStepDetails = null;
        this.mLastStepCpuSystemTimeMs = 0L;
        this.mLastStepCpuUserTimeMs = 0L;
        this.mCurStepCpuSystemTimeMs = 0L;
        this.mCurStepCpuUserTimeMs = 0L;
        this.mCurStepCpuUserTimeMs = 0L;
        this.mLastStepCpuUserTimeMs = 0L;
        this.mCurStepCpuSystemTimeMs = 0L;
        this.mLastStepCpuSystemTimeMs = 0L;
        this.mCurStepStatUserTimeMs = 0L;
        this.mLastStepStatUserTimeMs = 0L;
        this.mCurStepStatSystemTimeMs = 0L;
        this.mLastStepStatSystemTimeMs = 0L;
        this.mCurStepStatIOWaitTimeMs = 0L;
        this.mLastStepStatIOWaitTimeMs = 0L;
        this.mCurStepStatIrqTimeMs = 0L;
        this.mLastStepStatIrqTimeMs = 0L;
        this.mCurStepStatSoftIrqTimeMs = 0L;
        this.mLastStepStatSoftIrqTimeMs = 0L;
        this.mCurStepStatIdleTimeMs = 0L;
        this.mLastStepStatIdleTimeMs = 0L;
        this.mNumAllUidCpuTimeReads = 0;
        this.mNumUidsRemoved = 0;
        this.initDischarge(elapsedRealtimeUs);
        this.clearHistoryLocked();
        if (this.mBatteryStatsHistory != null) {
            this.mBatteryStatsHistory.resetAllFiles();
        }
        this.mIgnoreNextExternalStats = true;
        this.mExternalSync.scheduleSync("reset", 127);
        this.mHandler.sendEmptyMessage(4);
    }

    @GuardedBy(value={"this"})
    private void initActiveHistoryEventsLocked(long elapsedRealtimeMs, long uptimeMs) {
        for (int i = 0; i < 22; ++i) {
            HashMap<String, SparseIntArray> active;
            if (!this.mRecordAllHistory && i == 1 || (active = this.mActiveEvents.getStateForEvent(i)) == null) continue;
            for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                SparseIntArray uids = ent.getValue();
                for (int j = 0; j < uids.size(); ++j) {
                    this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, i, ent.getKey(), uids.keyAt(j));
                }
            }
        }
    }

    @GuardedBy(value={"this"})
    void updateDischargeScreenLevelsLocked(int oldState, int newState) {
        this.updateOldDischargeScreenLevelLocked(oldState);
        this.updateNewDischargeScreenLevelLocked(newState);
    }

    @GuardedBy(value={"this"})
    private void updateOldDischargeScreenLevelLocked(int state) {
        int diff;
        if (Display.isOnState(state)) {
            int diff2 = this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            if (diff2 > 0) {
                this.mDischargeAmountScreenOn += diff2;
                this.mDischargeAmountScreenOnSinceCharge += diff2;
            }
        } else if (Display.isDozeState(state)) {
            int diff3 = this.mDischargeScreenDozeUnplugLevel - this.mDischargeCurrentLevel;
            if (diff3 > 0) {
                this.mDischargeAmountScreenDoze += diff3;
                this.mDischargeAmountScreenDozeSinceCharge += diff3;
            }
        } else if (Display.isOffState(state) && (diff = this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel) > 0) {
            this.mDischargeAmountScreenOff += diff;
            this.mDischargeAmountScreenOffSinceCharge += diff;
        }
    }

    @GuardedBy(value={"this"})
    private void updateNewDischargeScreenLevelLocked(int state) {
        if (Display.isOnState(state)) {
            this.mDischargeScreenOnUnplugLevel = this.mDischargeCurrentLevel;
            this.mDischargeScreenOffUnplugLevel = 0;
            this.mDischargeScreenDozeUnplugLevel = 0;
        } else if (Display.isDozeState(state)) {
            this.mDischargeScreenOnUnplugLevel = 0;
            this.mDischargeScreenDozeUnplugLevel = this.mDischargeCurrentLevel;
            this.mDischargeScreenOffUnplugLevel = 0;
        } else if (Display.isOffState(state)) {
            this.mDischargeScreenOnUnplugLevel = 0;
            this.mDischargeScreenDozeUnplugLevel = 0;
            this.mDischargeScreenOffUnplugLevel = this.mDischargeCurrentLevel;
        }
    }

    @GuardedBy(value={"this"})
    public void pullPendingStateUpdatesLocked() {
        if (this.mOnBatteryInternal) {
            this.updateDischargeScreenLevelsLocked(this.mScreenState, this.mScreenState);
        }
    }

    @VisibleForTesting
    protected NetworkStats readMobileNetworkStatsLocked(NetworkStatsManager networkStatsManager) {
        return networkStatsManager.getMobileUidStats();
    }

    @VisibleForTesting
    protected NetworkStats readWifiNetworkStatsLocked(NetworkStatsManager networkStatsManager) {
        return networkStatsManager.getWifiUidStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    public void updateWifiState(WifiActivityEnergyInfo info, long consumedChargeUC, long elapsedRealtimeMs, long uptimeMs, NetworkStatsManager networkStatsManager) {
        NetworkStats delta = null;
        Object object = this.mWifiNetworkLock;
        synchronized (object) {
            NetworkStats latestStats = this.readWifiNetworkStatsLocked(networkStatsManager);
            if (latestStats != null) {
                delta = latestStats.subtract(this.mLastWifiNetworkStats);
                this.mLastWifiNetworkStats = latestStats;
            }
        }
        object = this;
        synchronized (object) {
            if (!this.mOnBatteryInternal || this.mIgnoreNextExternalStats) {
                if (this.mIgnoreNextExternalStats) {
                    // empty if block
                }
                return;
            }
            SparseDoubleArray uidEstimatedConsumptionMah = this.mGlobalMeasuredEnergyStats != null && this.mWifiPowerCalculator != null && consumedChargeUC > 0L ? new SparseDoubleArray() : null;
            double totalEstimatedConsumptionMah = 0.0;
            SparseLongArray rxPackets = new SparseLongArray();
            SparseLongArray txPackets = new SparseLongArray();
            SparseLongArray rxTimesMs = new SparseLongArray();
            SparseLongArray txTimesMs = new SparseLongArray();
            long totalTxPackets = 0L;
            long totalRxPackets = 0L;
            if (delta != null) {
                for (NetworkStats.Entry entry : delta) {
                    long uidScanMs;
                    if (entry.getRxBytes() == 0L && entry.getTxBytes() == 0L) continue;
                    int uid = this.mapUid(entry.getUid());
                    Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs);
                    if (entry.getRxBytes() != 0L) {
                        u.noteNetworkActivityLocked(2, entry.getRxBytes(), entry.getRxPackets());
                        if (entry.getSet() == 0) {
                            u.noteNetworkActivityLocked(8, entry.getRxBytes(), entry.getRxPackets());
                        }
                        this.mNetworkByteActivityCounters[2].addCountLocked(entry.getRxBytes());
                        this.mNetworkPacketActivityCounters[2].addCountLocked(entry.getRxPackets());
                        rxPackets.incrementValue(uid, entry.getRxPackets());
                        totalRxPackets += entry.getRxPackets();
                    }
                    if (entry.getTxBytes() != 0L) {
                        u.noteNetworkActivityLocked(3, entry.getTxBytes(), entry.getTxPackets());
                        if (entry.getSet() == 0) {
                            u.noteNetworkActivityLocked(9, entry.getTxBytes(), entry.getTxPackets());
                        }
                        this.mNetworkByteActivityCounters[3].addCountLocked(entry.getTxBytes());
                        this.mNetworkPacketActivityCounters[3].addCountLocked(entry.getTxPackets());
                        txPackets.incrementValue(uid, entry.getTxPackets());
                        totalTxPackets += entry.getTxPackets();
                    }
                    if (uidEstimatedConsumptionMah == null || info != null || this.mHasWifiReporting) continue;
                    long uidRunningMs = u.mWifiRunningTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                    if (uidRunningMs > 0L) {
                        u.mWifiRunningTimer.setMark(elapsedRealtimeMs);
                    }
                    if ((uidScanMs = u.mWifiScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L) > 0L) {
                        u.mWifiScanTimer.setMark(elapsedRealtimeMs);
                    }
                    long uidBatchScanMs = 0L;
                    for (int bn = 0; bn < 5; ++bn) {
                        if (u.mWifiBatchedScanTimer[bn] == null) continue;
                        long bnMs = u.mWifiBatchedScanTimer[bn].getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                        if (bnMs > 0L) {
                            u.mWifiBatchedScanTimer[bn].setMark(elapsedRealtimeMs);
                        }
                        uidBatchScanMs += bnMs;
                    }
                    uidEstimatedConsumptionMah.incrementValue(u.getUid(), this.mWifiPowerCalculator.calcPowerWithoutControllerDataMah(entry.getRxPackets(), entry.getTxPackets(), uidRunningMs, uidScanMs, uidBatchScanMs));
                }
                delta = null;
            }
            if (info != null) {
                long myRxTimeMs;
                long myTxTimeMs;
                Uid uid;
                int i;
                this.mHasWifiReporting = true;
                long txTimeMs = info.getControllerTxDurationMillis();
                long rxTimeMs = info.getControllerRxDurationMillis();
                long scanTimeMs = info.getControllerScanDurationMillis();
                long idleTimeMs = info.getControllerIdleDurationMillis();
                long totalTimeMs = txTimeMs + rxTimeMs + idleTimeMs;
                long leftOverRxTimeMs = rxTimeMs;
                long leftOverTxTimeMs = txTimeMs;
                long totalWifiLockTimeMs = 0L;
                long totalScanTimeMs = 0L;
                int uidStatsSize = this.mUidStats.size();
                for (i = 0; i < uidStatsSize; ++i) {
                    uid = this.mUidStats.valueAt(i);
                    totalScanTimeMs += uid.mWifiScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                    totalWifiLockTimeMs += uid.mFullWifiLockTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                }
                for (i = 0; i < uidStatsSize; ++i) {
                    long scanTimeSinceMarkMs;
                    uid = this.mUidStats.valueAt(i);
                    long scanRxTimeSinceMarkMs = scanTimeSinceMarkMs = uid.mWifiScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                    long scanTxTimeSinceMarkMs = scanTimeSinceMarkMs;
                    if (scanTimeSinceMarkMs > 0L) {
                        uid.mWifiScanTimer.setMark(elapsedRealtimeMs);
                        if (totalScanTimeMs > rxTimeMs) {
                            scanRxTimeSinceMarkMs = rxTimeMs * scanRxTimeSinceMarkMs / totalScanTimeMs;
                        }
                        if (totalScanTimeMs > txTimeMs) {
                            scanTxTimeSinceMarkMs = txTimeMs * scanTxTimeSinceMarkMs / totalScanTimeMs;
                        }
                        rxTimesMs.incrementValue(uid.getUid(), scanRxTimeSinceMarkMs);
                        txTimesMs.incrementValue(uid.getUid(), scanTxTimeSinceMarkMs);
                        leftOverRxTimeMs -= scanRxTimeSinceMarkMs;
                        leftOverTxTimeMs -= scanTxTimeSinceMarkMs;
                    }
                    long myIdleTimeMs = 0L;
                    long wifiLockTimeSinceMarkMs = uid.mFullWifiLockTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                    if (wifiLockTimeSinceMarkMs > 0L) {
                        uid.mFullWifiLockTimer.setMark(elapsedRealtimeMs);
                        myIdleTimeMs = wifiLockTimeSinceMarkMs * idleTimeMs / totalWifiLockTimeMs;
                        uid.getOrCreateWifiControllerActivityLocked().getOrCreateIdleTimeCounter().increment(myIdleTimeMs, elapsedRealtimeMs);
                    }
                    if (uidEstimatedConsumptionMah == null) continue;
                    double uidEstMah = this.mWifiPowerCalculator.calcPowerFromControllerDataMah(scanRxTimeSinceMarkMs, scanTxTimeSinceMarkMs, myIdleTimeMs);
                    uidEstimatedConsumptionMah.incrementValue(uid.getUid(), uidEstMah);
                }
                for (i = 0; i < txPackets.size(); ++i) {
                    int uid2 = txPackets.keyAt(i);
                    myTxTimeMs = txPackets.valueAt(i) * leftOverTxTimeMs / totalTxPackets;
                    txTimesMs.incrementValue(uid2, myTxTimeMs);
                }
                for (i = 0; i < rxPackets.size(); ++i) {
                    int uid3 = rxPackets.keyAt(i);
                    myRxTimeMs = rxPackets.valueAt(i) * leftOverRxTimeMs / totalRxPackets;
                    rxTimesMs.incrementValue(uid3, myRxTimeMs);
                }
                for (i = 0; i < txTimesMs.size(); ++i) {
                    int uid4 = txTimesMs.keyAt(i);
                    myTxTimeMs = txTimesMs.valueAt(i);
                    this.getUidStatsLocked(uid4, elapsedRealtimeMs, uptimeMs).getOrCreateWifiControllerActivityLocked().getOrCreateTxTimeCounters()[0].increment(myTxTimeMs, elapsedRealtimeMs);
                    if (uidEstimatedConsumptionMah == null) continue;
                    uidEstimatedConsumptionMah.incrementValue(uid4, this.mWifiPowerCalculator.calcPowerFromControllerDataMah(0L, myTxTimeMs, 0L));
                }
                for (i = 0; i < rxTimesMs.size(); ++i) {
                    int uid5 = rxTimesMs.keyAt(i);
                    myRxTimeMs = rxTimesMs.valueAt(i);
                    this.getUidStatsLocked(rxTimesMs.keyAt(i), elapsedRealtimeMs, uptimeMs).getOrCreateWifiControllerActivityLocked().getOrCreateRxTimeCounter().increment(myRxTimeMs, elapsedRealtimeMs);
                    if (uidEstimatedConsumptionMah == null) continue;
                    uidEstimatedConsumptionMah.incrementValue(uid5, this.mWifiPowerCalculator.calcPowerFromControllerDataMah(myRxTimeMs, 0L, 0L));
                }
                this.mWifiActivity.getOrCreateRxTimeCounter().increment(info.getControllerRxDurationMillis(), elapsedRealtimeMs);
                this.mWifiActivity.getOrCreateTxTimeCounters()[0].increment(info.getControllerTxDurationMillis(), elapsedRealtimeMs);
                this.mWifiActivity.getScanTimeCounter().addCountLocked(info.getControllerScanDurationMillis());
                this.mWifiActivity.getOrCreateIdleTimeCounter().increment(info.getControllerIdleDurationMillis(), elapsedRealtimeMs);
                double opVolt = this.mPowerProfile.getAveragePower("wifi.controller.voltage") / 1000.0;
                double controllerMaMs = 0.0;
                if (opVolt != 0.0) {
                    controllerMaMs = (double)info.getControllerEnergyUsedMicroJoules() / opVolt;
                    this.mWifiActivity.getPowerCounter().addCountLocked((long)controllerMaMs);
                }
                long monitoredRailChargeConsumedMaMs = (long)((double)this.mTmpRailStats.getWifiTotalEnergyUseduWs() / opVolt);
                this.mWifiActivity.getMonitoredRailChargeConsumedMaMs().addCountLocked(monitoredRailChargeConsumedMaMs);
                this.mHistoryCur.wifiRailChargeMah += (double)monitoredRailChargeConsumedMaMs / 3600000.0;
                this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
                this.mTmpRailStats.resetWifiTotalEnergyUsed();
                if (uidEstimatedConsumptionMah != null) {
                    totalEstimatedConsumptionMah = Math.max(controllerMaMs / 3600000.0, this.mWifiPowerCalculator.calcPowerFromControllerDataMah(rxTimeMs, txTimeMs, idleTimeMs));
                }
            }
            if (uidEstimatedConsumptionMah != null) {
                this.mGlobalMeasuredEnergyStats.updateStandardBucket(4, consumedChargeUC);
                if (!this.mHasWifiReporting) {
                    long globalTimeMs = this.mGlobalWifiRunningTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                    this.mGlobalWifiRunningTimer.setMark(elapsedRealtimeMs);
                    totalEstimatedConsumptionMah = this.mWifiPowerCalculator.calcGlobalPowerWithoutControllerDataMah(globalTimeMs);
                }
                this.distributeEnergyToUidsLocked(4, consumedChargeUC, uidEstimatedConsumptionMah, totalEstimatedConsumptionMah, elapsedRealtimeMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteModemControllerActivity(ModemActivityInfo activityInfo, long consumedChargeUC, long elapsedRealtimeMs, long uptimeMs, NetworkStatsManager networkStatsManager) {
        ModemActivityInfo deltaInfo = this.mLastModemActivityInfo == null ? activityInfo : this.mLastModemActivityInfo.getDelta(activityInfo);
        this.mLastModemActivityInfo = activityInfo;
        this.addModemTxPowerToHistory(deltaInfo, elapsedRealtimeMs, uptimeMs);
        NetworkStats delta = null;
        Object object = this.mModemNetworkLock;
        synchronized (object) {
            NetworkStats latestStats = this.readMobileNetworkStatsLocked(networkStatsManager);
            if (latestStats != null) {
                delta = latestStats.subtract(this.mLastModemNetworkStats);
                this.mLastModemNetworkStats = latestStats;
            }
        }
        object = this;
        synchronized (object) {
            SparseDoubleArray uidEstimatedConsumptionMah;
            if (!this.mOnBatteryInternal || this.mIgnoreNextExternalStats) {
                return;
            }
            if (consumedChargeUC > 0L && this.mMobileRadioPowerCalculator != null && this.mGlobalMeasuredEnergyStats != null) {
                this.mGlobalMeasuredEnergyStats.updateStandardBucket(7, consumedChargeUC);
                uidEstimatedConsumptionMah = new SparseDoubleArray();
            } else {
                uidEstimatedConsumptionMah = null;
            }
            if (deltaInfo != null) {
                this.mHasModemReporting = true;
                this.mModemActivity.getOrCreateIdleTimeCounter().increment(deltaInfo.getIdleTimeMillis(), elapsedRealtimeMs);
                this.mModemActivity.getSleepTimeCounter().addCountLocked(deltaInfo.getSleepTimeMillis());
                this.mModemActivity.getOrCreateRxTimeCounter().increment(deltaInfo.getReceiveTimeMillis(), elapsedRealtimeMs);
                for (int lvl = 0; lvl < ModemActivityInfo.getNumTxPowerLevels(); ++lvl) {
                    this.mModemActivity.getOrCreateTxTimeCounters()[lvl].increment(deltaInfo.getTransmitDurationMillisAtPowerLevel(lvl), elapsedRealtimeMs);
                }
                double opVolt = this.mPowerProfile.getAveragePower("modem.controller.voltage") / 1000.0;
                if (opVolt != 0.0) {
                    double energyUsed = (double)deltaInfo.getSleepTimeMillis() * this.mPowerProfile.getAveragePower("modem.controller.sleep") + (double)deltaInfo.getIdleTimeMillis() * this.mPowerProfile.getAveragePower("modem.controller.idle") + (double)deltaInfo.getReceiveTimeMillis() * this.mPowerProfile.getAveragePower("modem.controller.rx");
                    for (int i = 0; i < Math.min(ModemActivityInfo.getNumTxPowerLevels(), CellSignalStrength.getNumSignalStrengthLevels()); ++i) {
                        energyUsed += (double)deltaInfo.getTransmitDurationMillisAtPowerLevel(i) * this.mPowerProfile.getAveragePower("modem.controller.tx", i);
                    }
                    this.mModemActivity.getPowerCounter().addCountLocked((long)energyUsed);
                    long monitoredRailChargeConsumedMaMs = (long)((double)this.mTmpRailStats.getCellularTotalEnergyUseduWs() / opVolt);
                    this.mModemActivity.getMonitoredRailChargeConsumedMaMs().addCountLocked(monitoredRailChargeConsumedMaMs);
                    this.mHistoryCur.modemRailChargeMah += (double)monitoredRailChargeConsumedMaMs / 3600000.0;
                    this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
                    this.mTmpRailStats.resetCellularTotalEnergyUsed();
                }
                this.incrementPerRatDataLocked(deltaInfo, elapsedRealtimeMs);
            }
            long totalAppRadioTimeUs = this.mMobileRadioActivePerAppTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L);
            this.mMobileRadioActivePerAppTimer.setMark(elapsedRealtimeMs);
            long totalRxPackets = 0L;
            long totalTxPackets = 0L;
            if (delta != null) {
                for (NetworkStats.Entry entry : delta) {
                    if (entry.getRxPackets() == 0L && entry.getTxPackets() == 0L) continue;
                    totalRxPackets += entry.getRxPackets();
                    totalTxPackets += entry.getTxPackets();
                    Uid u = this.getUidStatsLocked(this.mapUid(entry.getUid()), elapsedRealtimeMs, uptimeMs);
                    u.noteNetworkActivityLocked(0, entry.getRxBytes(), entry.getRxPackets());
                    u.noteNetworkActivityLocked(1, entry.getTxBytes(), entry.getTxPackets());
                    if (entry.getSet() == 0) {
                        u.noteNetworkActivityLocked(6, entry.getRxBytes(), entry.getRxPackets());
                        u.noteNetworkActivityLocked(7, entry.getTxBytes(), entry.getTxPackets());
                    }
                    this.mNetworkByteActivityCounters[0].addCountLocked(entry.getRxBytes());
                    this.mNetworkByteActivityCounters[1].addCountLocked(entry.getTxBytes());
                    this.mNetworkPacketActivityCounters[0].addCountLocked(entry.getRxPackets());
                    this.mNetworkPacketActivityCounters[1].addCountLocked(entry.getTxPackets());
                }
                long totalPackets = totalRxPackets + totalTxPackets;
                if (totalPackets > 0L) {
                    for (NetworkStats.Entry entry : delta) {
                        if (entry.getRxPackets() == 0L && entry.getTxPackets() == 0L) continue;
                        Uid u = this.getUidStatsLocked(this.mapUid(entry.getUid()), elapsedRealtimeMs, uptimeMs);
                        long appPackets = entry.getRxPackets() + entry.getTxPackets();
                        long appRadioTimeUs = totalAppRadioTimeUs * appPackets / totalPackets;
                        u.noteMobileRadioActiveTimeLocked(appRadioTimeUs, elapsedRealtimeMs);
                        if (uidEstimatedConsumptionMah != null) {
                            uidEstimatedConsumptionMah.incrementValue(u.getUid(), this.mMobileRadioPowerCalculator.calcPowerFromRadioActiveDurationMah(appRadioTimeUs / 1000L));
                        }
                        totalAppRadioTimeUs -= appRadioTimeUs;
                        totalPackets -= appPackets;
                        if (deltaInfo == null) continue;
                        ControllerActivityCounterImpl activityCounter = u.getOrCreateModemControllerActivityLocked();
                        if (totalRxPackets > 0L && entry.getRxPackets() > 0L) {
                            long rxMs = entry.getRxPackets() * deltaInfo.getReceiveTimeMillis() / totalRxPackets;
                            activityCounter.getOrCreateRxTimeCounter().increment(rxMs, elapsedRealtimeMs);
                        }
                        if (totalTxPackets <= 0L || entry.getTxPackets() <= 0L) continue;
                        for (int lvl = 0; lvl < ModemActivityInfo.getNumTxPowerLevels(); ++lvl) {
                            long txMs = entry.getTxPackets() * deltaInfo.getTransmitDurationMillisAtPowerLevel(lvl);
                            activityCounter.getOrCreateTxTimeCounters()[lvl].increment(txMs /= totalTxPackets, elapsedRealtimeMs);
                        }
                    }
                }
                if (totalAppRadioTimeUs > 0L) {
                    this.mMobileRadioActiveUnknownTime.addCountLocked(totalAppRadioTimeUs);
                    this.mMobileRadioActiveUnknownCount.addCountLocked(1L);
                }
                if (uidEstimatedConsumptionMah != null) {
                    double totalEstimatedConsumptionMah = 0.0;
                    long totalRadioTimeMs = this.mMobileRadioActiveTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                    this.mMobileRadioActiveTimer.setMark(elapsedRealtimeMs);
                    totalEstimatedConsumptionMah += this.mMobileRadioPowerCalculator.calcPowerFromRadioActiveDurationMah(totalRadioTimeMs);
                    int numSignalStrengthLevels = this.mPhoneSignalStrengthsTimer.length;
                    for (int strengthLevel = 0; strengthLevel < numSignalStrengthLevels; ++strengthLevel) {
                        long strengthLevelDurationMs = this.mPhoneSignalStrengthsTimer[strengthLevel].getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                        this.mPhoneSignalStrengthsTimer[strengthLevel].setMark(elapsedRealtimeMs);
                        totalEstimatedConsumptionMah += this.mMobileRadioPowerCalculator.calcIdlePowerAtSignalStrengthMah(strengthLevelDurationMs, strengthLevel);
                    }
                    long scanTimeMs = this.mPhoneSignalScanningTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                    this.mPhoneSignalScanningTimer.setMark(elapsedRealtimeMs);
                    this.distributeEnergyToUidsLocked(7, consumedChargeUC, uidEstimatedConsumptionMah, totalEstimatedConsumptionMah += this.mMobileRadioPowerCalculator.calcScanTimePowerMah(scanTimeMs), elapsedRealtimeMs);
                }
                delta = null;
            }
        }
    }

    @GuardedBy(value={"this"})
    private void incrementPerRatDataLocked(ModemActivityInfo deltaInfo, long elapsedRealtimeMs) {
        int infoSize = deltaInfo.getSpecificInfoLength();
        if (infoSize == 1 && deltaInfo.getSpecificInfoRat(0) == 0 && deltaInfo.getSpecificInfoFrequencyRange(0) == 0) {
            int freq;
            int freqCount;
            RadioAccessTechnologyBatteryStats ratStats;
            int rat;
            int levelCount = CellSignalStrength.getNumSignalStrengthLevels();
            long[] perSignalStrengthActiveTimeMs = new long[levelCount];
            long totalActiveTimeMs = 0L;
            for (rat = 0; rat < 3; ++rat) {
                ratStats = this.mPerRatBatteryStats[rat];
                if (ratStats == null) continue;
                freqCount = ratStats.getFrequencyRangeCount();
                for (freq = 0; freq < freqCount; ++freq) {
                    int level = 0;
                    while (level < levelCount) {
                        long durationMs = ratStats.getTimeSinceMark(freq, level, elapsedRealtimeMs);
                        int n = level++;
                        perSignalStrengthActiveTimeMs[n] = perSignalStrengthActiveTimeMs[n] + durationMs;
                        totalActiveTimeMs += durationMs;
                    }
                }
            }
            if (totalActiveTimeMs != 0L) {
                for (rat = 0; rat < 3; ++rat) {
                    ratStats = this.mPerRatBatteryStats[rat];
                    if (ratStats == null) continue;
                    freqCount = ratStats.getFrequencyRangeCount();
                    for (freq = 0; freq < freqCount; ++freq) {
                        long frequencyDurationMs = 0L;
                        for (int level = 0; level < levelCount; ++level) {
                            long durationMs = ratStats.getTimeSinceMark(freq, level, elapsedRealtimeMs);
                            long totalLvlDurationMs = perSignalStrengthActiveTimeMs[level];
                            if (totalLvlDurationMs == 0L) continue;
                            long totalTxLvlDurations = deltaInfo.getTransmitDurationMillisAtPowerLevel(level);
                            long proportionalTxDurationMs = (durationMs * totalTxLvlDurations + totalLvlDurationMs / 2L) / totalLvlDurationMs;
                            ratStats.incrementTxDuration(freq, level, proportionalTxDurationMs);
                            frequencyDurationMs += durationMs;
                        }
                        long totalRxDuration = deltaInfo.getReceiveTimeMillis();
                        long proportionalRxDurationMs = (frequencyDurationMs * totalRxDuration + totalActiveTimeMs / 2L) / totalActiveTimeMs;
                        ratStats.incrementRxDuration(freq, proportionalRxDurationMs);
                    }
                }
            }
        } else {
            for (int index = 0; index < infoSize; ++index) {
                int rat = deltaInfo.getSpecificInfoRat(index);
                int freq = deltaInfo.getSpecificInfoFrequencyRange(index);
                int ratBucket = BatteryStatsImpl.mapRadioAccessNetworkTypeToRadioAccessTechnology(rat);
                RadioAccessTechnologyBatteryStats ratStats = this.getRatBatteryStatsLocked(ratBucket);
                long rxTimeMs = deltaInfo.getReceiveTimeMillis(rat, freq);
                int[] txTimesMs = deltaInfo.getTransmitTimeMillis(rat, freq);
                ratStats.incrementRxDuration(freq, rxTimeMs);
                int numTxLvl = txTimesMs.length;
                for (int lvl = 0; lvl < numTxLvl; ++lvl) {
                    ratStats.incrementTxDuration(freq, lvl, txTimesMs[lvl]);
                }
            }
        }
        for (int rat = 0; rat < 3; ++rat) {
            RadioAccessTechnologyBatteryStats ratStats = this.mPerRatBatteryStats[rat];
            if (ratStats == null) continue;
            ratStats.setMark(elapsedRealtimeMs);
        }
    }

    private synchronized void addModemTxPowerToHistory(ModemActivityInfo activityInfo, long elapsedRealtimeMs, long uptimeMs) {
        if (activityInfo == null) {
            return;
        }
        int levelMaxTimeSpent = 0;
        for (int i = 1; i < ModemActivityInfo.getNumTxPowerLevels(); ++i) {
            if (activityInfo.getTransmitDurationMillisAtPowerLevel(i) <= activityInfo.getTransmitDurationMillisAtPowerLevel(levelMaxTimeSpent)) continue;
            levelMaxTimeSpent = i;
        }
        if (levelMaxTimeSpent == ModemActivityInfo.getNumTxPowerLevels() - 1) {
            this.mHistoryCur.states2 |= 0x80000;
            this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
        }
    }

    @GuardedBy(value={"this"})
    public void updateBluetoothStateLocked(BluetoothActivityEnergyInfo info, long consumedChargeUC, long elapsedRealtimeMs, long uptimeMs) {
        UidTraffic traffic;
        int i;
        if (info == null) {
            return;
        }
        if (!this.mOnBatteryInternal || this.mIgnoreNextExternalStats) {
            this.mLastBluetoothActivityInfo.set(info);
            return;
        }
        this.mHasBluetoothReporting = true;
        if (info.getControllerRxTimeMillis() < this.mLastBluetoothActivityInfo.rxTimeMs || info.getControllerTxTimeMillis() < this.mLastBluetoothActivityInfo.txTimeMs || info.getControllerIdleTimeMillis() < this.mLastBluetoothActivityInfo.idleTimeMs || info.getControllerEnergyUsed() < this.mLastBluetoothActivityInfo.energy) {
            this.mLastBluetoothActivityInfo.reset();
        }
        long rxTimeMs = info.getControllerRxTimeMillis() - this.mLastBluetoothActivityInfo.rxTimeMs;
        long txTimeMs = info.getControllerTxTimeMillis() - this.mLastBluetoothActivityInfo.txTimeMs;
        long idleTimeMs = info.getControllerIdleTimeMillis() - this.mLastBluetoothActivityInfo.idleTimeMs;
        SparseDoubleArray uidEstimatedConsumptionMah = this.mGlobalMeasuredEnergyStats != null && this.mBluetoothPowerCalculator != null && consumedChargeUC > 0L ? new SparseDoubleArray() : null;
        long totalScanTimeMs = 0L;
        int uidCount = this.mUidStats.size();
        for (int i2 = 0; i2 < uidCount; ++i2) {
            Uid u = this.mUidStats.valueAt(i2);
            if (u.mBluetoothScanTimer == null) continue;
            totalScanTimeMs += u.mBluetoothScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
        }
        boolean normalizeScanRxTime = totalScanTimeMs > rxTimeMs;
        boolean normalizeScanTxTime = totalScanTimeMs > txTimeMs;
        long leftOverRxTimeMs = rxTimeMs;
        long leftOverTxTimeMs = txTimeMs;
        SparseLongArray rxTimesMs = new SparseLongArray(uidCount);
        SparseLongArray txTimesMs = new SparseLongArray(uidCount);
        for (int i3 = 0; i3 < uidCount; ++i3) {
            long scanTimeSinceMarkMs;
            Uid u = this.mUidStats.valueAt(i3);
            if (u.mBluetoothScanTimer == null || (scanTimeSinceMarkMs = u.mBluetoothScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L) <= 0L) continue;
            u.mBluetoothScanTimer.setMark(elapsedRealtimeMs);
            long scanTimeRxSinceMarkMs = scanTimeSinceMarkMs;
            long scanTimeTxSinceMarkMs = scanTimeSinceMarkMs;
            if (normalizeScanRxTime) {
                scanTimeRxSinceMarkMs = rxTimeMs * scanTimeRxSinceMarkMs / totalScanTimeMs;
            }
            if (normalizeScanTxTime) {
                scanTimeTxSinceMarkMs = txTimeMs * scanTimeTxSinceMarkMs / totalScanTimeMs;
            }
            rxTimesMs.incrementValue(u.getUid(), scanTimeRxSinceMarkMs);
            txTimesMs.incrementValue(u.getUid(), scanTimeTxSinceMarkMs);
            if (uidEstimatedConsumptionMah != null) {
                uidEstimatedConsumptionMah.incrementValue(u.getUid(), this.mBluetoothPowerCalculator.calculatePowerMah(scanTimeRxSinceMarkMs, scanTimeTxSinceMarkMs, 0L));
            }
            leftOverRxTimeMs -= scanTimeRxSinceMarkMs;
            leftOverTxTimeMs -= scanTimeTxSinceMarkMs;
        }
        long totalTxBytes = 0L;
        long totalRxBytes = 0L;
        List<UidTraffic> uidTraffic = info.getUidTraffic();
        int numUids = uidTraffic.size();
        for (i = 0; i < numUids; ++i) {
            traffic = uidTraffic.get(i);
            long rxBytes = traffic.getRxBytes() - this.mLastBluetoothActivityInfo.uidRxBytes.get(traffic.getUid());
            long txBytes = traffic.getTxBytes() - this.mLastBluetoothActivityInfo.uidTxBytes.get(traffic.getUid());
            this.mNetworkByteActivityCounters[4].addCountLocked(rxBytes);
            this.mNetworkByteActivityCounters[5].addCountLocked(txBytes);
            Uid u = this.getUidStatsLocked(this.mapUid(traffic.getUid()), elapsedRealtimeMs, uptimeMs);
            u.noteNetworkActivityLocked(4, rxBytes, 0L);
            u.noteNetworkActivityLocked(5, txBytes, 0L);
            totalRxBytes += rxBytes;
            totalTxBytes += txBytes;
        }
        if (!(totalTxBytes == 0L && totalRxBytes == 0L || leftOverRxTimeMs == 0L && leftOverTxTimeMs == 0L)) {
            for (i = 0; i < numUids; ++i) {
                traffic = uidTraffic.get(i);
                int uid = traffic.getUid();
                long rxBytes = traffic.getRxBytes() - this.mLastBluetoothActivityInfo.uidRxBytes.get(uid);
                long txBytes = traffic.getTxBytes() - this.mLastBluetoothActivityInfo.uidTxBytes.get(uid);
                Uid u = this.getUidStatsLocked(this.mapUid(uid), elapsedRealtimeMs, uptimeMs);
                ControllerActivityCounterImpl counter = u.getOrCreateBluetoothControllerActivityLocked();
                if (totalRxBytes > 0L && rxBytes > 0L) {
                    long timeRxMs = leftOverRxTimeMs * rxBytes / totalRxBytes;
                    rxTimesMs.incrementValue(uid, timeRxMs);
                }
                if (totalTxBytes <= 0L || txBytes <= 0L) continue;
                long timeTxMs = leftOverTxTimeMs * txBytes / totalTxBytes;
                txTimesMs.incrementValue(uid, timeTxMs);
            }
            for (i = 0; i < txTimesMs.size(); ++i) {
                int uid = txTimesMs.keyAt(i);
                long myTxTimeMs = txTimesMs.valueAt(i);
                this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs).getOrCreateBluetoothControllerActivityLocked().getOrCreateTxTimeCounters()[0].increment(myTxTimeMs, elapsedRealtimeMs);
                if (uidEstimatedConsumptionMah == null) continue;
                uidEstimatedConsumptionMah.incrementValue(uid, this.mBluetoothPowerCalculator.calculatePowerMah(0L, myTxTimeMs, 0L));
            }
            for (i = 0; i < rxTimesMs.size(); ++i) {
                int uid = rxTimesMs.keyAt(i);
                long myRxTimeMs = rxTimesMs.valueAt(i);
                this.getUidStatsLocked(rxTimesMs.keyAt(i), elapsedRealtimeMs, uptimeMs).getOrCreateBluetoothControllerActivityLocked().getOrCreateRxTimeCounter().increment(myRxTimeMs, elapsedRealtimeMs);
                if (uidEstimatedConsumptionMah == null) continue;
                uidEstimatedConsumptionMah.incrementValue(uid, this.mBluetoothPowerCalculator.calculatePowerMah(myRxTimeMs, 0L, 0L));
            }
        }
        this.mBluetoothActivity.getOrCreateRxTimeCounter().increment(rxTimeMs, elapsedRealtimeMs);
        this.mBluetoothActivity.getOrCreateTxTimeCounters()[0].increment(txTimeMs, elapsedRealtimeMs);
        this.mBluetoothActivity.getOrCreateIdleTimeCounter().increment(idleTimeMs, elapsedRealtimeMs);
        double opVolt = this.mPowerProfile.getAveragePower("bluetooth.controller.voltage") / 1000.0;
        double controllerMaMs = 0.0;
        if (opVolt != 0.0) {
            controllerMaMs = (double)(info.getControllerEnergyUsed() - this.mLastBluetoothActivityInfo.energy) / opVolt;
            this.mBluetoothActivity.getPowerCounter().addCountLocked((long)controllerMaMs);
        }
        if (uidEstimatedConsumptionMah != null) {
            this.mGlobalMeasuredEnergyStats.updateStandardBucket(5, consumedChargeUC);
            double totalEstimatedMah = this.mBluetoothPowerCalculator.calculatePowerMah(rxTimeMs, txTimeMs, idleTimeMs);
            totalEstimatedMah = Math.max(totalEstimatedMah, controllerMaMs / 3600000.0);
            this.distributeEnergyToUidsLocked(5, consumedChargeUC, uidEstimatedConsumptionMah, totalEstimatedMah, elapsedRealtimeMs);
        }
        this.mLastBluetoothActivityInfo.set(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillLowPowerStats() {
        if (this.mPlatformIdleStateCallback == null) {
            return;
        }
        RpmStats rpmStats = new RpmStats();
        long now = SystemClock.elapsedRealtime();
        if (now - this.mLastRpmStatsUpdateTimeMs >= 1000L) {
            this.mPlatformIdleStateCallback.fillLowPowerStats(rpmStats);
            BatteryStatsImpl batteryStatsImpl = this;
            synchronized (batteryStatsImpl) {
                this.mTmpRpmStats = rpmStats;
                this.mLastRpmStatsUpdateTimeMs = now;
            }
        }
    }

    public void updateRpmStatsLocked(long elapsedRealtimeUs) {
        if (this.mTmpRpmStats == null) {
            return;
        }
        for (Map.Entry<String, RpmStats.PowerStatePlatformSleepState> entry : this.mTmpRpmStats.mPlatformLowPowerStats.entrySet()) {
            String pName = entry.getKey();
            long pTimeUs = entry.getValue().mTimeMs * 1000L;
            int pCount = entry.getValue().mCount;
            this.getRpmTimerLocked(pName).update(pTimeUs, pCount, elapsedRealtimeUs);
            for (Map.Entry<String, RpmStats.PowerStateElement> voter : entry.getValue().mVoters.entrySet()) {
                String vName = pName + "." + voter.getKey();
                long vTimeUs = voter.getValue().mTimeMs * 1000L;
                int vCount = voter.getValue().mCount;
                this.getRpmTimerLocked(vName).update(vTimeUs, vCount, elapsedRealtimeUs);
            }
        }
        for (Map.Entry<String, Object> entry : this.mTmpRpmStats.mSubsystemLowPowerStats.entrySet()) {
            String subsysName = entry.getKey();
            for (Map.Entry<String, RpmStats.PowerStateElement> sstate : ((RpmStats.PowerStateSubsystem)entry.getValue()).mStates.entrySet()) {
                String name = subsysName + "." + sstate.getKey();
                long timeUs = sstate.getValue().mTimeMs * 1000L;
                int count = sstate.getValue().mCount;
                this.getRpmTimerLocked(name).update(timeUs, count, elapsedRealtimeUs);
            }
        }
    }

    @GuardedBy(value={"this"})
    private void updateCpuMeasuredEnergyStatsLocked(long[] clusterChargeUC, CpuDeltaPowerAccumulator accumulator) {
        if (this.mGlobalMeasuredEnergyStats == null) {
            return;
        }
        int numClusters = clusterChargeUC.length;
        long totalCpuChargeUC = 0L;
        for (int i = 0; i < numClusters; ++i) {
            totalCpuChargeUC += clusterChargeUC[i];
        }
        if (totalCpuChargeUC <= 0L) {
            return;
        }
        long timestampMs = this.mClock.elapsedRealtime();
        this.mGlobalMeasuredEnergyStats.updateStandardBucket(3, totalCpuChargeUC, timestampMs);
        double[] clusterChargeRatio = new double[numClusters];
        for (int cluster = 0; cluster < numClusters; ++cluster) {
            double totalClusterChargeMah = accumulator.totalClusterChargesMah[cluster];
            clusterChargeRatio[cluster] = totalClusterChargeMah <= 0.0 ? 0.0 : (double)clusterChargeUC[cluster] / accumulator.totalClusterChargesMah[cluster];
        }
        long uidChargeArraySize = accumulator.perUidCpuClusterChargesMah.size();
        int i = 0;
        while ((long)i < uidChargeArraySize) {
            Uid uid = accumulator.perUidCpuClusterChargesMah.keyAt(i);
            double[] uidClusterChargesMah = accumulator.perUidCpuClusterChargesMah.valueAt(i);
            long uidCpuChargeUC = 0L;
            for (int cluster = 0; cluster < numClusters; ++cluster) {
                double uidClusterChargeMah = uidClusterChargesMah[cluster];
                long uidClusterChargeUC = (long)(uidClusterChargeMah * clusterChargeRatio[cluster] + 0.5);
                uidCpuChargeUC += uidClusterChargeUC;
            }
            if (uidCpuChargeUC < 0L) {
                Slog.wtf(TAG, "Unexpected proportional measured charge (" + uidCpuChargeUC + ") for uid " + uid.mUid);
            } else {
                uid.addChargeToStandardBucketLocked(uidCpuChargeUC, 3, timestampMs);
            }
            ++i;
        }
    }

    @GuardedBy(value={"this"})
    public void updateDisplayMeasuredEnergyStatsLocked(long[] chargesUC, int[] screenStates, long elapsedRealtimeMs) {
        int numDisplays;
        if (this.mGlobalMeasuredEnergyStats == null) {
            return;
        }
        if (this.mPerDisplayBatteryStats.length == screenStates.length) {
            numDisplays = screenStates.length;
        } else {
            if (this.mDisplayMismatchWtfCount++ % 100 == 0) {
                Slog.wtf(TAG, "Mismatch between PowerProfile reported display count (" + this.mPerDisplayBatteryStats.length + ") and PowerStatsHal reported display count (" + screenStates.length + ")");
            }
            numDisplays = this.mPerDisplayBatteryStats.length < screenStates.length ? this.mPerDisplayBatteryStats.length : screenStates.length;
        }
        int[] oldScreenStates = new int[numDisplays];
        for (int i = 0; i < numDisplays; ++i) {
            int screenState = screenStates[i];
            oldScreenStates[i] = this.mPerDisplayBatteryStats[i].screenStateAtLastEnergyMeasurement;
            this.mPerDisplayBatteryStats[i].screenStateAtLastEnergyMeasurement = screenState;
        }
        if (!this.mOnBatteryInternal) {
            return;
        }
        if (this.mIgnoreNextExternalStats) {
            int uidStatsSize = this.mUidStats.size();
            for (int i = 0; i < uidStatsSize; ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.markProcessForegroundTimeUs(elapsedRealtimeMs, false);
            }
            return;
        }
        long totalScreenOnChargeUC = 0L;
        for (int i = 0; i < numDisplays; ++i) {
            long chargeUC = chargesUC[i];
            if (chargeUC <= 0L) continue;
            int powerBucket = MeasuredEnergyStats.getDisplayPowerBucket(oldScreenStates[i]);
            this.mGlobalMeasuredEnergyStats.updateStandardBucket(powerBucket, chargeUC);
            if (powerBucket != 0) continue;
            totalScreenOnChargeUC += chargeUC;
        }
        if (totalScreenOnChargeUC <= 0L) {
            return;
        }
        SparseDoubleArray fgTimeUsArray = new SparseDoubleArray();
        long elapsedRealtimeUs = elapsedRealtimeMs * 1000L;
        int uidStatsSize = this.mUidStats.size();
        for (int i = 0; i < uidStatsSize; ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            long fgTimeUs = uid.markProcessForegroundTimeUs(elapsedRealtimeMs, true);
            if (fgTimeUs == 0L) continue;
            fgTimeUsArray.put(uid.getUid(), fgTimeUs);
        }
        this.distributeEnergyToUidsLocked(0, totalScreenOnChargeUC, fgTimeUsArray, 0.0, elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void updateGnssMeasuredEnergyStatsLocked(long chargeUC, long elapsedRealtimeMs) {
        if (this.mGlobalMeasuredEnergyStats == null) {
            return;
        }
        if (!this.mOnBatteryInternal || chargeUC <= 0L) {
            return;
        }
        if (this.mIgnoreNextExternalStats) {
            int uidStatsSize = this.mUidStats.size();
            for (int i = 0; i < uidStatsSize; ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.markGnssTimeUs(elapsedRealtimeMs);
            }
            return;
        }
        this.mGlobalMeasuredEnergyStats.updateStandardBucket(6, chargeUC);
        SparseDoubleArray gnssTimeUsArray = new SparseDoubleArray();
        int uidStatsSize = this.mUidStats.size();
        for (int i = 0; i < uidStatsSize; ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            long gnssTimeUs = uid.markGnssTimeUs(elapsedRealtimeMs);
            if (gnssTimeUs == 0L) continue;
            gnssTimeUsArray.put(uid.getUid(), gnssTimeUs);
        }
        this.distributeEnergyToUidsLocked(6, chargeUC, gnssTimeUsArray, 0.0, elapsedRealtimeMs);
    }

    @GuardedBy(value={"this"})
    public void updateCustomMeasuredEnergyStatsLocked(int customPowerBucket, long totalChargeUC, SparseLongArray uidCharges) {
        if (this.mGlobalMeasuredEnergyStats == null) {
            return;
        }
        if (!this.mOnBatteryInternal || this.mIgnoreNextExternalStats || totalChargeUC <= 0L) {
            return;
        }
        this.mGlobalMeasuredEnergyStats.updateCustomBucket(customPowerBucket, totalChargeUC, this.mClock.elapsedRealtime());
        if (uidCharges == null) {
            return;
        }
        int numUids = uidCharges.size();
        for (int i = 0; i < numUids; ++i) {
            int uidInt = this.mapUid(uidCharges.keyAt(i));
            long uidChargeUC = uidCharges.valueAt(i);
            if (uidChargeUC == 0L) continue;
            Uid uidObj = this.getAvailableUidStatsLocked(uidInt);
            if (uidObj != null) {
                uidObj.addChargeToCustomBucketLocked(uidChargeUC, customPowerBucket);
                continue;
            }
            if (Process.isIsolated(uidInt)) continue;
            Slog.w(TAG, "Received measured charge " + totalChargeUC + " for custom bucket " + customPowerBucket + " for non-existent uid " + uidInt);
        }
    }

    @GuardedBy(value={"this"})
    private void distributeEnergyToUidsLocked(int bucket, long totalConsumedChargeUC, SparseDoubleArray ratioNumerators, double minRatioDenominator, long timestampMs) {
        double sumRatioNumerators = 0.0;
        for (int i = ratioNumerators.size() - 1; i >= 0; --i) {
            sumRatioNumerators += ratioNumerators.valueAt(i);
        }
        double ratioDenominator = Math.max(sumRatioNumerators, minRatioDenominator);
        if (ratioDenominator <= 0.0) {
            return;
        }
        for (int i = ratioNumerators.size() - 1; i >= 0; --i) {
            Uid uid = this.getAvailableUidStatsLocked(ratioNumerators.keyAt(i));
            double ratioNumerator = ratioNumerators.valueAt(i);
            long uidActualUC = (long)((double)totalConsumedChargeUC * ratioNumerator / ratioDenominator + 0.5);
            uid.addChargeToStandardBucketLocked(uidActualUC, bucket, timestampMs);
        }
    }

    public void updateRailStatsLocked() {
        if (this.mMeasuredEnergyRetriever == null || !this.mTmpRailStats.isRailStatsAvailable()) {
            return;
        }
        this.mMeasuredEnergyRetriever.fillRailDataStats(this.mTmpRailStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informThatAllExternalStatsAreFlushed() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            this.mIgnoreNextExternalStats = false;
        }
    }

    public void updateKernelWakelocksLocked() {
        this.updateKernelWakelocksLocked(this.mClock.elapsedRealtime() * 1000L);
    }

    public void updateKernelWakelocksLocked(long elapsedRealtimeUs) {
        KernelWakelockStats wakelockStats = this.mKernelWakelockReader.readKernelWakelockStats(this.mTmpWakelockStats);
        if (wakelockStats == null) {
            Slog.w(TAG, "Couldn't get kernel wake lock stats");
            return;
        }
        for (Map.Entry ent : wakelockStats.entrySet()) {
            String name = (String)ent.getKey();
            KernelWakelockStats.Entry kws = (KernelWakelockStats.Entry)ent.getValue();
            SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
            if (kwlt == null) {
                kwlt = new SamplingTimer(this.mClock, this.mOnBatteryScreenOffTimeBase);
                this.mKernelWakelockStats.put(name, kwlt);
            }
            kwlt.update(kws.mTotalTime, kws.mCount, elapsedRealtimeUs);
            kwlt.setUpdateVersion(kws.mVersion);
        }
        int numWakelocksSetStale = 0;
        for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
            SamplingTimer st = ent.getValue();
            if (st.getUpdateVersion() == wakelockStats.kernelWakelockVersion) continue;
            st.endSample(elapsedRealtimeUs);
            ++numWakelocksSetStale;
        }
        if (wakelockStats.isEmpty()) {
            Slog.wtf(TAG, "All kernel wakelocks had time of zero");
        }
        if (numWakelocksSetStale == this.mKernelWakelockStats.size()) {
            Slog.wtf(TAG, "All kernel wakelocks were set stale. new version=" + wakelockStats.kernelWakelockVersion);
        }
    }

    public void updateKernelMemoryBandwidthLocked() {
        this.updateKernelMemoryBandwidthLocked(this.mClock.elapsedRealtime() * 1000L);
    }

    public void updateKernelMemoryBandwidthLocked(long elapsedRealtimeUs) {
        this.mKernelMemoryBandwidthStats.updateStats();
        LongSparseLongArray bandwidthEntries = this.mKernelMemoryBandwidthStats.getBandwidthEntries();
        int bandwidthEntryCount = bandwidthEntries.size();
        for (int i = 0; i < bandwidthEntryCount; ++i) {
            SamplingTimer timer;
            int index = this.mKernelMemoryStats.indexOfKey(bandwidthEntries.keyAt(i));
            if (index >= 0) {
                timer = this.mKernelMemoryStats.valueAt(index);
            } else {
                timer = new SamplingTimer(this.mClock, this.mOnBatteryTimeBase);
                this.mKernelMemoryStats.put(bandwidthEntries.keyAt(i), timer);
            }
            timer.update(bandwidthEntries.valueAt(i), 1, elapsedRealtimeUs);
        }
    }

    public boolean isOnBatteryLocked() {
        return this.mOnBatteryTimeBase.isRunning();
    }

    public boolean isOnBatteryScreenOffLocked() {
        return this.mOnBatteryScreenOffTimeBase.isRunning();
    }

    @GuardedBy(value={"this"})
    public void updateCpuTimeLocked(boolean onBattery, boolean onBatteryScreenOff, long[] measuredCpuClusterChargeUC) {
        CpuDeltaPowerAccumulator powerAccumulator;
        SparseLongArray updatedUids;
        if (this.mPowerProfile == null) {
            return;
        }
        if (this.mCpuFreqs == null) {
            this.mCpuFreqs = this.mCpuUidFreqTimeReader.readFreqs(this.mPowerProfile);
        }
        ArrayList<StopwatchTimer> partialTimersToConsider = null;
        if (onBatteryScreenOff) {
            partialTimersToConsider = new ArrayList<StopwatchTimer>();
            for (int i = this.mPartialTimers.size() - 1; i >= 0; --i) {
                StopwatchTimer timer = this.mPartialTimers.get(i);
                if (!timer.mInList || timer.mUid == null || timer.mUid.mUid == 1000) continue;
                partialTimersToConsider.add(timer);
            }
        }
        this.markPartialTimersAsEligible();
        if (!onBattery) {
            this.mCpuUidUserSysTimeReader.readDelta(false, null);
            this.mCpuUidFreqTimeReader.readDelta(false, null);
            this.mNumAllUidCpuTimeReads += 2;
            if (this.mConstants.TRACK_CPU_ACTIVE_CLUSTER_TIME) {
                this.mCpuUidActiveTimeReader.readDelta(false, null);
                this.mCpuUidClusterTimeReader.readDelta(false, null);
                this.mNumAllUidCpuTimeReads += 2;
            }
            for (int cluster = this.mKernelCpuSpeedReaders.length - 1; cluster >= 0; --cluster) {
                this.mKernelCpuSpeedReaders[cluster].readDelta();
            }
            this.mSystemServerCpuThreadReader.readDelta();
            return;
        }
        this.mUserInfoProvider.refreshUserIds();
        SparseLongArray sparseLongArray = updatedUids = this.mCpuUidFreqTimeReader.perClusterTimesAvailable() ? null : new SparseLongArray();
        if (this.mGlobalMeasuredEnergyStats != null && this.mGlobalMeasuredEnergyStats.isStandardBucketSupported(3) && this.mCpuPowerCalculator != null) {
            if (measuredCpuClusterChargeUC == null) {
                Slog.wtf(TAG, "POWER_BUCKET_CPU supported but no measured Cpu Cluster charge reported on updateCpuTimeLocked!");
                powerAccumulator = null;
            } else {
                int numClusters = this.mPowerProfile.getNumCpuClusters();
                powerAccumulator = new CpuDeltaPowerAccumulator(this.mCpuPowerCalculator, numClusters);
            }
        } else {
            powerAccumulator = null;
        }
        this.readKernelUidCpuTimesLocked(partialTimersToConsider, updatedUids, onBattery);
        if (updatedUids != null) {
            this.updateClusterSpeedTimes(updatedUids, onBattery, powerAccumulator);
        }
        this.readKernelUidCpuFreqTimesLocked(partialTimersToConsider, onBattery, onBatteryScreenOff, powerAccumulator);
        this.mNumAllUidCpuTimeReads += 2;
        if (this.mConstants.TRACK_CPU_ACTIVE_CLUSTER_TIME) {
            this.readKernelUidCpuActiveTimesLocked(onBattery);
            this.readKernelUidCpuClusterTimesLocked(onBattery, powerAccumulator);
            this.mNumAllUidCpuTimeReads += 2;
        }
        this.updateSystemServerThreadStats();
        if (powerAccumulator != null) {
            this.updateCpuMeasuredEnergyStatsLocked(measuredCpuClusterChargeUC, powerAccumulator);
        }
    }

    @VisibleForTesting
    public void updateSystemServerThreadStats() {
        SystemServerCpuThreadReader.SystemServiceCpuThreadTimes systemServiceCpuThreadTimes = this.mSystemServerCpuThreadReader.readDelta();
        if (systemServiceCpuThreadTimes == null) {
            return;
        }
        if (this.mBinderThreadCpuTimesUs == null) {
            this.mBinderThreadCpuTimesUs = new LongSamplingCounterArray(this.mOnBatteryTimeBase);
        }
        this.mBinderThreadCpuTimesUs.addCountLocked(systemServiceCpuThreadTimes.binderThreadCpuTimesUs);
    }

    @VisibleForTesting
    public void markPartialTimersAsEligible() {
        if (ArrayUtils.referenceEquals(this.mPartialTimers, this.mLastPartialTimers)) {
            for (int i = this.mPartialTimers.size() - 1; i >= 0; --i) {
                this.mPartialTimers.get((int)i).mInList = true;
            }
        } else {
            for (int i = this.mLastPartialTimers.size() - 1; i >= 0; --i) {
                this.mLastPartialTimers.get((int)i).mInList = false;
            }
            this.mLastPartialTimers.clear();
            int numPartialTimers = this.mPartialTimers.size();
            for (int i = 0; i < numPartialTimers; ++i) {
                StopwatchTimer timer = this.mPartialTimers.get(i);
                timer.mInList = true;
                this.mLastPartialTimers.add(timer);
            }
        }
    }

    @VisibleForTesting
    public void updateClusterSpeedTimes(SparseLongArray updatedUids, boolean onBattery, CpuDeltaPowerAccumulator powerAccumulator) {
        long totalCpuClustersTimeMs = 0L;
        long[][] clusterSpeedTimesMs = new long[this.mKernelCpuSpeedReaders.length][];
        for (int cluster = 0; cluster < this.mKernelCpuSpeedReaders.length; ++cluster) {
            clusterSpeedTimesMs[cluster] = this.mKernelCpuSpeedReaders[cluster].readDelta();
            if (clusterSpeedTimesMs[cluster] == null) continue;
            for (int speed = clusterSpeedTimesMs[cluster].length - 1; speed >= 0; --speed) {
                totalCpuClustersTimeMs += clusterSpeedTimesMs[cluster][speed];
            }
        }
        if (totalCpuClustersTimeMs != 0L) {
            int updatedUidsCount = updatedUids.size();
            long elapsedRealtimeMs = this.mClock.elapsedRealtime();
            long uptimeMs = this.mClock.uptimeMillis();
            for (int i = 0; i < updatedUidsCount; ++i) {
                Uid u = this.getUidStatsLocked(updatedUids.keyAt(i), elapsedRealtimeMs, uptimeMs);
                long appCpuTimeUs = updatedUids.valueAt(i);
                int numClusters = this.mPowerProfile.getNumCpuClusters();
                if (u.mCpuClusterSpeedTimesUs == null || u.mCpuClusterSpeedTimesUs.length != numClusters) {
                    u.mCpuClusterSpeedTimesUs = new LongSamplingCounter[numClusters][];
                }
                for (int cluster = 0; cluster < clusterSpeedTimesMs.length; ++cluster) {
                    int speedsInCluster = clusterSpeedTimesMs[cluster].length;
                    if (u.mCpuClusterSpeedTimesUs[cluster] == null || speedsInCluster != u.mCpuClusterSpeedTimesUs[cluster].length) {
                        u.mCpuClusterSpeedTimesUs[cluster] = new LongSamplingCounter[speedsInCluster];
                    }
                    LongSamplingCounter[] cpuSpeeds = u.mCpuClusterSpeedTimesUs[cluster];
                    for (int speed = 0; speed < speedsInCluster; ++speed) {
                        if (cpuSpeeds[speed] == null) {
                            cpuSpeeds[speed] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                        }
                        long deltaSpeedCount = appCpuTimeUs * clusterSpeedTimesMs[cluster][speed] / totalCpuClustersTimeMs;
                        cpuSpeeds[speed].addCountLocked(deltaSpeedCount, onBattery);
                        if (powerAccumulator == null) continue;
                        powerAccumulator.addCpuClusterSpeedDurationsMs(u, cluster, speed, deltaSpeedCount);
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public void readKernelUidCpuTimesLocked(ArrayList<StopwatchTimer> partialTimers, SparseLongArray updatedUids, boolean onBattery) {
        this.mTempTotalCpuSystemTimeUs = 0L;
        this.mTempTotalCpuUserTimeUs = 0L;
        int numWakelocks = partialTimers == null ? 0 : partialTimers.size();
        long startTimeMs = this.mClock.uptimeMillis();
        long elapsedRealtimeMs = this.mClock.elapsedRealtime();
        this.mCpuUidUserSysTimeReader.readDelta(false, (uid, timesUs) -> {
            long userTimeUs = timesUs[0];
            long systemTimeUs = timesUs[1];
            if (Process.isIsolated(uid = this.mapUid(uid))) {
                return;
            }
            if (!this.mUserInfoProvider.exists(UserHandle.getUserId(uid))) {
                return;
            }
            Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, startTimeMs);
            this.mTempTotalCpuUserTimeUs += userTimeUs;
            this.mTempTotalCpuSystemTimeUs += systemTimeUs;
            StringBuilder sb = null;
            if (numWakelocks > 0) {
                userTimeUs = userTimeUs * 50L / 100L;
                systemTimeUs = systemTimeUs * 50L / 100L;
            }
            if (sb != null) {
                sb.append("  adding to uid=").append(u.mUid).append(": u=");
                TimeUtils.formatDuration(userTimeUs / 1000L, sb);
                sb.append(" s=");
                TimeUtils.formatDuration(systemTimeUs / 1000L, sb);
                Slog.d(TAG, sb.toString());
            }
            u.mUserCpuTime.addCountLocked(userTimeUs, onBattery);
            u.mSystemCpuTime.addCountLocked(systemTimeUs, onBattery);
            if (updatedUids != null) {
                updatedUids.put(u.getUid(), userTimeUs + systemTimeUs);
            }
        });
        long elapsedTimeMs = this.mClock.uptimeMillis() - startTimeMs;
        if (elapsedTimeMs >= 100L) {
            Slog.d(TAG, "Reading cpu stats took " + elapsedTimeMs + "ms");
        }
        if (numWakelocks > 0) {
            this.mTempTotalCpuUserTimeUs = this.mTempTotalCpuUserTimeUs * 50L / 100L;
            this.mTempTotalCpuSystemTimeUs = this.mTempTotalCpuSystemTimeUs * 50L / 100L;
            for (int i = 0; i < numWakelocks; ++i) {
                StopwatchTimer timer = partialTimers.get(i);
                int userTimeUs = (int)(this.mTempTotalCpuUserTimeUs / (long)(numWakelocks - i));
                int systemTimeUs = (int)(this.mTempTotalCpuSystemTimeUs / (long)(numWakelocks - i));
                timer.mUid.mUserCpuTime.addCountLocked(userTimeUs, onBattery);
                timer.mUid.mSystemCpuTime.addCountLocked(systemTimeUs, onBattery);
                if (updatedUids != null) {
                    int uid2 = timer.mUid.getUid();
                    updatedUids.put(uid2, updatedUids.get(uid2, 0L) + (long)userTimeUs + (long)systemTimeUs);
                }
                Uid.Proc proc = timer.mUid.getProcessStatsLocked("*wakelock*");
                proc.addCpuTimeLocked(userTimeUs / 1000, systemTimeUs / 1000, onBattery);
                this.mTempTotalCpuUserTimeUs -= (long)userTimeUs;
                this.mTempTotalCpuSystemTimeUs -= (long)systemTimeUs;
            }
        }
    }

    @VisibleForTesting
    public void readKernelUidCpuFreqTimesLocked(ArrayList<StopwatchTimer> partialTimers, boolean onBattery, boolean onBatteryScreenOff, CpuDeltaPowerAccumulator powerAccumulator) {
        boolean perClusterTimesAvailable = this.mCpuUidFreqTimeReader.perClusterTimesAvailable();
        int numWakelocks = partialTimers == null ? 0 : partialTimers.size();
        int numClusters = this.mPowerProfile.getNumCpuClusters();
        this.mWakeLockAllocationsUs = null;
        long startTimeMs = this.mClock.uptimeMillis();
        long elapsedRealtimeMs = this.mClock.elapsedRealtime();
        boolean forceRead = powerAccumulator != null;
        this.mCpuUidFreqTimeReader.readDelta(forceRead, (uid, cpuFreqTimeMs) -> {
            if (Process.isIsolated(uid = this.mapUid(uid))) {
                return;
            }
            if (!this.mUserInfoProvider.exists(UserHandle.getUserId(uid))) {
                return;
            }
            Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, startTimeMs);
            if (u.mCpuFreqTimeMs == null || u.mCpuFreqTimeMs.getSize() != ((long[])cpuFreqTimeMs).length) {
                BatteryStatsImpl.detachIfNotNull(u.mCpuFreqTimeMs);
                u.mCpuFreqTimeMs = new LongSamplingCounterArray(this.mOnBatteryTimeBase);
            }
            u.mCpuFreqTimeMs.addCountLocked((long[])cpuFreqTimeMs, onBattery);
            if (u.mScreenOffCpuFreqTimeMs == null || u.mScreenOffCpuFreqTimeMs.getSize() != ((long[])cpuFreqTimeMs).length) {
                BatteryStatsImpl.detachIfNotNull(u.mScreenOffCpuFreqTimeMs);
                u.mScreenOffCpuFreqTimeMs = new LongSamplingCounterArray(this.mOnBatteryScreenOffTimeBase);
            }
            u.mScreenOffCpuFreqTimeMs.addCountLocked((long[])cpuFreqTimeMs, onBatteryScreenOff);
            if (perClusterTimesAvailable) {
                if (u.mCpuClusterSpeedTimesUs == null || u.mCpuClusterSpeedTimesUs.length != numClusters) {
                    BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs);
                    u.mCpuClusterSpeedTimesUs = new LongSamplingCounter[numClusters][];
                }
                if (numWakelocks > 0 && this.mWakeLockAllocationsUs == null) {
                    this.mWakeLockAllocationsUs = new long[numClusters][];
                }
                int freqIndex = 0;
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    int speedsInCluster = this.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster);
                    if (u.mCpuClusterSpeedTimesUs[cluster] == null || u.mCpuClusterSpeedTimesUs[cluster].length != speedsInCluster) {
                        BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs[cluster]);
                        u.mCpuClusterSpeedTimesUs[cluster] = new LongSamplingCounter[speedsInCluster];
                    }
                    if (numWakelocks > 0 && this.mWakeLockAllocationsUs[cluster] == null) {
                        this.mWakeLockAllocationsUs[cluster] = new long[speedsInCluster];
                    }
                    LongSamplingCounter[] cpuTimesUs = u.mCpuClusterSpeedTimesUs[cluster];
                    for (int speed = 0; speed < speedsInCluster; ++speed) {
                        long appAllocationUs;
                        if (cpuTimesUs[speed] == null) {
                            cpuTimesUs[speed] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                        }
                        if (this.mWakeLockAllocationsUs != null) {
                            appAllocationUs = cpuFreqTimeMs[freqIndex] * 1000L * 50L / 100L;
                            long[] lArray = this.mWakeLockAllocationsUs[cluster];
                            int n = speed;
                            lArray[n] = lArray[n] + (cpuFreqTimeMs[freqIndex] * 1000L - appAllocationUs);
                        } else {
                            appAllocationUs = cpuFreqTimeMs[freqIndex] * 1000L;
                        }
                        cpuTimesUs[speed].addCountLocked(appAllocationUs, onBattery);
                        if (powerAccumulator != null) {
                            powerAccumulator.addCpuClusterSpeedDurationsMs(u, cluster, speed, appAllocationUs / 1000L);
                        }
                        ++freqIndex;
                    }
                }
            }
        });
        long elapsedTimeMs = this.mClock.uptimeMillis() - startTimeMs;
        if (elapsedTimeMs >= 100L) {
            Slog.d(TAG, "Reading cpu freq times took " + elapsedTimeMs + "ms");
        }
        if (this.mWakeLockAllocationsUs != null) {
            for (int i = 0; i < numWakelocks; ++i) {
                Uid u = partialTimers.get((int)i).mUid;
                if (u.mCpuClusterSpeedTimesUs == null || u.mCpuClusterSpeedTimesUs.length != numClusters) {
                    BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs);
                    u.mCpuClusterSpeedTimesUs = new LongSamplingCounter[numClusters][];
                }
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    int speedsInCluster = this.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster);
                    if (u.mCpuClusterSpeedTimesUs[cluster] == null || u.mCpuClusterSpeedTimesUs[cluster].length != speedsInCluster) {
                        BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs[cluster]);
                        u.mCpuClusterSpeedTimesUs[cluster] = new LongSamplingCounter[speedsInCluster];
                    }
                    LongSamplingCounter[] cpuTimeUs = u.mCpuClusterSpeedTimesUs[cluster];
                    for (int speed = 0; speed < speedsInCluster; ++speed) {
                        if (cpuTimeUs[speed] == null) {
                            cpuTimeUs[speed] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                        }
                        long allocationUs = this.mWakeLockAllocationsUs[cluster][speed] / (long)(numWakelocks - i);
                        cpuTimeUs[speed].addCountLocked(allocationUs, onBattery);
                        long[] lArray = this.mWakeLockAllocationsUs[cluster];
                        int n = speed;
                        lArray[n] = lArray[n] - allocationUs;
                        if (powerAccumulator == null) continue;
                        powerAccumulator.addCpuClusterSpeedDurationsMs(u, cluster, speed, allocationUs / 1000L);
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public void readKernelUidCpuActiveTimesLocked(boolean onBattery) {
        long startTimeMs = this.mClock.uptimeMillis();
        long elapsedRealtimeMs = this.mClock.elapsedRealtime();
        this.mCpuUidActiveTimeReader.readAbsolute((uid, cpuActiveTimesMs) -> {
            int parentUid = this.mapUid(uid);
            if (Process.isIsolated(parentUid)) {
                return;
            }
            if (!this.mUserInfoProvider.exists(UserHandle.getUserId(uid))) {
                return;
            }
            Uid u = this.getUidStatsLocked(parentUid, elapsedRealtimeMs, startTimeMs);
            if (parentUid == uid) {
                u.getCpuActiveTimeCounter().update((long)cpuActiveTimesMs, elapsedRealtimeMs);
            } else {
                SparseArray<Uid.ChildUid> childUids = u.mChildUids;
                if (childUids == null) {
                    return;
                }
                Uid.ChildUid childUid = childUids.get(uid);
                if (childUid != null) {
                    long delta = childUid.cpuActiveCounter.update((long)cpuActiveTimesMs, elapsedRealtimeMs);
                    u.getCpuActiveTimeCounter().increment(delta, elapsedRealtimeMs);
                }
            }
        });
        long elapsedTimeMs = this.mClock.uptimeMillis() - startTimeMs;
        if (elapsedTimeMs >= 100L) {
            Slog.d(TAG, "Reading cpu active times took " + elapsedTimeMs + "ms");
        }
    }

    @VisibleForTesting
    public void readKernelUidCpuClusterTimesLocked(boolean onBattery, CpuDeltaPowerAccumulator powerAccumulator) {
        long startTimeMs = this.mClock.uptimeMillis();
        long elapsedRealtimeMs = this.mClock.elapsedRealtime();
        boolean forceRead = powerAccumulator != null;
        this.mCpuUidClusterTimeReader.readDelta(forceRead, (uid, cpuClusterTimesMs) -> {
            if (Process.isIsolated(uid = this.mapUid(uid))) {
                return;
            }
            if (!this.mUserInfoProvider.exists(UserHandle.getUserId(uid))) {
                return;
            }
            Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, startTimeMs);
            u.mCpuClusterTimesMs.addCountLocked((long[])cpuClusterTimesMs, onBattery);
            if (powerAccumulator != null) {
                powerAccumulator.addCpuClusterDurationsMs(u, (long[])cpuClusterTimesMs);
            }
        });
        long elapsedTimeMs = this.mClock.uptimeMillis() - startTimeMs;
        if (elapsedTimeMs >= 100L) {
            Slog.d(TAG, "Reading cpu cluster times took " + elapsedTimeMs + "ms");
        }
    }

    boolean setChargingLocked(boolean charging) {
        this.mHandler.removeCallbacks(this.mDeferSetCharging);
        if (this.mCharging != charging) {
            this.mCharging = charging;
            this.mHistoryCur.states2 = charging ? (this.mHistoryCur.states2 |= 0x1000000) : (this.mHistoryCur.states2 &= 0xFEFFFFFF);
            this.mHandler.sendEmptyMessage(3);
            return true;
        }
        return false;
    }

    public void onSystemReady() {
        this.mSystemReady = true;
    }

    @GuardedBy(value={"this"})
    protected void setOnBatteryLocked(long mSecRealtime, long mSecUptime, boolean onBattery, int oldStatus, int level, int chargeUah) {
        boolean doWrite = false;
        Message m = this.mHandler.obtainMessage(2);
        m.arg1 = onBattery ? 1 : 0;
        this.mHandler.sendMessage(m);
        long uptimeUs = mSecUptime * 1000L;
        long realtimeUs = mSecRealtime * 1000L;
        int screenState = this.mScreenState;
        if (onBattery) {
            boolean reset = false;
            if (!this.mNoAutoReset && this.mSystemReady && (oldStatus == 5 || level >= 90 || this.mDischargeCurrentLevel < 20 && level >= 80 || this.getHighDischargeAmountSinceCharge() >= 200)) {
                Slog.i(TAG, "Resetting battery stats: level=" + level + " status=" + oldStatus + " dischargeLevel=" + this.mDischargeCurrentLevel + " lowAmount=" + this.getLowDischargeAmountSinceCharge() + " highAmount=" + this.getHighDischargeAmountSinceCharge());
                if (this.getLowDischargeAmountSinceCharge() >= 20) {
                    long startTimeMs = SystemClock.uptimeMillis();
                    final Parcel parcel = Parcel.obtain();
                    this.writeSummaryToParcel(parcel, true);
                    final long initialTimeMs = SystemClock.uptimeMillis() - startTimeMs;
                    BackgroundThread.getHandler().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            AtomicFile atomicFile = BatteryStatsImpl.this.mCheckinFile;
                            synchronized (atomicFile) {
                                long startTimeMs2 = SystemClock.uptimeMillis();
                                FileOutputStream stream = null;
                                try {
                                    stream = BatteryStatsImpl.this.mCheckinFile.startWrite();
                                    stream.write(parcel.marshall());
                                    stream.flush();
                                    BatteryStatsImpl.this.mCheckinFile.finishWrite(stream);
                                    EventLogTags.writeCommitSysConfigFile("batterystats-checkin", initialTimeMs + SystemClock.uptimeMillis() - startTimeMs2);
                                }
                                catch (IOException e) {
                                    Slog.w("BatteryStats", "Error writing checkin battery statistics", e);
                                    BatteryStatsImpl.this.mCheckinFile.failWrite(stream);
                                }
                                finally {
                                    parcel.recycle();
                                }
                            }
                        }
                    });
                }
                doWrite = true;
                this.resetAllStatsLocked(mSecUptime, mSecRealtime, 3);
                if (chargeUah > 0 && level > 0) {
                    this.mEstimatedBatteryCapacityMah = (int)((double)(chargeUah / 1000) / ((double)level / 100.0));
                }
                this.mDischargeStartLevel = level;
                reset = true;
                this.mDischargeStepTracker.init();
            }
            if (this.mCharging) {
                this.setChargingLocked(false);
            }
            this.mLastChargingStateLevel = level;
            this.mOnBatteryInternal = true;
            this.mOnBattery = true;
            this.mLastDischargeStepLevel = level;
            this.mMinDischargeStepLevel = level;
            this.mDischargeStepTracker.clearTime();
            this.mDailyDischargeStepTracker.clearTime();
            this.mInitStepMode = this.mCurStepMode;
            this.mModStepMode = 0;
            this.pullPendingStateUpdatesLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states &= 0xFFF7FFFF;
            if (reset) {
                this.mRecordingHistory = true;
                this.startRecordingHistory(mSecRealtime, mSecUptime, reset);
            }
            this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
            this.mDischargeCurrentLevel = this.mDischargeUnplugLevel = level;
            if (Display.isOnState(screenState)) {
                this.mDischargeScreenOnUnplugLevel = level;
                this.mDischargeScreenDozeUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else if (Display.isDozeState(screenState)) {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenDozeUnplugLevel = level;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenDozeUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = level;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenDoze = 0;
            this.mDischargeAmountScreenOff = 0;
            this.updateTimeBasesLocked(true, screenState, uptimeUs, realtimeUs);
        } else {
            this.mLastChargingStateLevel = level;
            this.mOnBatteryInternal = false;
            this.mOnBattery = false;
            this.pullPendingStateUpdatesLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states |= 0x80000;
            this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
            this.mDischargeCurrentLevel = this.mDischargePlugLevel = level;
            if (level < this.mDischargeUnplugLevel) {
                this.mLowDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level - 1;
                this.mHighDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level;
            }
            this.updateDischargeScreenLevelsLocked(screenState, screenState);
            this.updateTimeBasesLocked(false, screenState, uptimeUs, realtimeUs);
            this.mChargeStepTracker.init();
            this.mLastChargeStepLevel = level;
            this.mMaxChargeStepLevel = level;
            this.mInitStepMode = this.mCurStepMode;
            this.mModStepMode = 0;
        }
        if ((doWrite || this.mLastWriteTimeMs + 60000L < mSecRealtime) && this.mStatsFile != null && this.mBatteryStatsHistory.getActiveFile() != null) {
            this.writeAsyncLocked();
        }
    }

    @GuardedBy(value={"this"})
    private void startRecordingHistory(long elapsedRealtimeMs, long uptimeMs, boolean reset) {
        this.mRecordingHistory = true;
        this.mHistoryCur.currentTime = this.mClock.currentTimeMillis();
        this.addHistoryBufferLocked(elapsedRealtimeMs, reset ? (byte)7 : 5, this.mHistoryCur);
        this.mHistoryCur.currentTime = 0L;
        if (reset) {
            this.initActiveHistoryEventsLocked(elapsedRealtimeMs, uptimeMs);
        }
    }

    @GuardedBy(value={"this"})
    private void recordCurrentTimeChangeLocked(long currentTimeMs, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mRecordingHistory) {
            this.mHistoryCur.currentTime = currentTimeMs;
            this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)5, this.mHistoryCur);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    @GuardedBy(value={"this"})
    private void recordShutdownLocked(long currentTimeMs, long elapsedRealtimeMs) {
        if (this.mRecordingHistory) {
            this.mHistoryCur.currentTime = currentTimeMs;
            this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)8, this.mHistoryCur);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    private void scheduleSyncExternalStatsLocked(String reason, int updateFlags) {
        if (this.mExternalSync != null) {
            this.mExternalSync.scheduleSync(reason, updateFlags);
        }
    }

    @GuardedBy(value={"this"})
    public void setBatteryStateLocked(int status, int health, int plugType, int level, int temp, int voltageMv, int chargeUah, int chargeFullUah, long chargeTimeToFullSeconds) {
        this.setBatteryStateLocked(status, health, plugType, level, temp, voltageMv, chargeUah, chargeFullUah, chargeTimeToFullSeconds, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis(), this.mClock.currentTimeMillis());
    }

    @GuardedBy(value={"this"})
    public void setBatteryStateLocked(int status, int health, int plugType, int level, int temp, int voltageMv, int chargeUah, int chargeFullUah, long chargeTimeToFullSeconds, long elapsedRealtimeMs, long uptimeMs, long currentTimeMs) {
        temp = Math.max(0, temp);
        this.reportChangesToStatsLog(this.mHaveBatteryLevel ? this.mHistoryCur : null, status, plugType, level);
        boolean onBattery = BatteryStatsImpl.isOnBattery(plugType, status);
        if (!this.mHaveBatteryLevel) {
            this.mHaveBatteryLevel = true;
            if (onBattery == this.mOnBattery) {
                this.mHistoryCur.states = onBattery ? (this.mHistoryCur.states &= 0xFFF7FFFF) : (this.mHistoryCur.states |= 0x80000);
            }
            this.mHistoryCur.states2 |= 0x1000000;
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.batteryChargeUah = chargeUah;
            this.mLastChargeStepLevel = this.mLastDischargeStepLevel = level;
            this.mMinDischargeStepLevel = this.mLastDischargeStepLevel;
            this.mMaxChargeStepLevel = this.mLastDischargeStepLevel;
            this.mLastChargingStateLevel = level;
        } else if (this.mCurrentBatteryLevel != level || this.mOnBattery != onBattery) {
            this.recordDailyStatsIfNeededLocked(level >= 100 && onBattery, currentTimeMs);
        }
        byte oldStatus = this.mHistoryCur.batteryStatus;
        if (onBattery) {
            this.mDischargeCurrentLevel = level;
            if (!this.mRecordingHistory) {
                this.mRecordingHistory = true;
                this.startRecordingHistory(elapsedRealtimeMs, uptimeMs, true);
            }
        } else if (level < 96 && status != 1 && !this.mRecordingHistory) {
            this.mRecordingHistory = true;
            this.startRecordingHistory(elapsedRealtimeMs, uptimeMs, true);
        }
        this.mBatteryVoltageMv = voltageMv;
        this.mCurrentBatteryLevel = level;
        if (this.mDischargePlugLevel < 0) {
            this.mDischargePlugLevel = level;
        }
        if (onBattery != this.mOnBattery) {
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryHealth = (byte)health;
            this.mHistoryCur.batteryPlugType = (byte)plugType;
            this.mHistoryCur.batteryTemperature = (short)temp;
            this.mHistoryCur.batteryVoltage = (char)voltageMv;
            if (chargeUah < this.mHistoryCur.batteryChargeUah) {
                long chargeDiff = this.mHistoryCur.batteryChargeUah - chargeUah;
                this.mDischargeCounter.addCountLocked(chargeDiff);
                this.mDischargeScreenOffCounter.addCountLocked(chargeDiff);
                if (Display.isDozeState(this.mScreenState)) {
                    this.mDischargeScreenDozeCounter.addCountLocked(chargeDiff);
                }
                if (this.mDeviceIdleMode == 1) {
                    this.mDischargeLightDozeCounter.addCountLocked(chargeDiff);
                } else if (this.mDeviceIdleMode == 2) {
                    this.mDischargeDeepDozeCounter.addCountLocked(chargeDiff);
                }
            }
            this.mHistoryCur.batteryChargeUah = chargeUah;
            this.setOnBatteryLocked(elapsedRealtimeMs, uptimeMs, onBattery, oldStatus, level, chargeUah);
        } else {
            boolean changed = false;
            if (this.mHistoryCur.batteryLevel != level) {
                this.mHistoryCur.batteryLevel = (byte)level;
                changed = true;
                this.mExternalSync.scheduleSyncDueToBatteryLevelChange(this.mConstants.BATTERY_LEVEL_COLLECTION_DELAY_MS);
            }
            if (this.mHistoryCur.batteryStatus != status) {
                this.mHistoryCur.batteryStatus = (byte)status;
                changed = true;
            }
            if (this.mHistoryCur.batteryHealth != health) {
                this.mHistoryCur.batteryHealth = (byte)health;
                changed = true;
            }
            if (this.mHistoryCur.batteryPlugType != plugType) {
                this.mHistoryCur.batteryPlugType = (byte)plugType;
                changed = true;
            }
            if (temp >= this.mHistoryCur.batteryTemperature + 10 || temp <= this.mHistoryCur.batteryTemperature - 10) {
                this.mHistoryCur.batteryTemperature = (short)temp;
                changed = true;
            }
            if (voltageMv > this.mHistoryCur.batteryVoltage + 20 || voltageMv < this.mHistoryCur.batteryVoltage - 20) {
                this.mHistoryCur.batteryVoltage = (char)voltageMv;
                changed = true;
            }
            if (chargeUah >= this.mHistoryCur.batteryChargeUah + 10 || chargeUah <= this.mHistoryCur.batteryChargeUah - 10) {
                if (chargeUah < this.mHistoryCur.batteryChargeUah) {
                    long chargeDiff = this.mHistoryCur.batteryChargeUah - chargeUah;
                    this.mDischargeCounter.addCountLocked(chargeDiff);
                    this.mDischargeScreenOffCounter.addCountLocked(chargeDiff);
                    if (Display.isDozeState(this.mScreenState)) {
                        this.mDischargeScreenDozeCounter.addCountLocked(chargeDiff);
                    }
                    if (this.mDeviceIdleMode == 1) {
                        this.mDischargeLightDozeCounter.addCountLocked(chargeDiff);
                    } else if (this.mDeviceIdleMode == 2) {
                        this.mDischargeDeepDozeCounter.addCountLocked(chargeDiff);
                    }
                }
                this.mHistoryCur.batteryChargeUah = chargeUah;
                changed = true;
            }
            long modeBits = (long)this.mInitStepMode << 48 | (long)this.mModStepMode << 56 | (long)(level & 0xFF) << 40;
            if (onBattery) {
                changed |= this.setChargingLocked(false);
                if (this.mLastDischargeStepLevel != level && this.mMinDischargeStepLevel > level) {
                    this.mDischargeStepTracker.addLevelSteps(this.mLastDischargeStepLevel - level, modeBits, elapsedRealtimeMs);
                    this.mDailyDischargeStepTracker.addLevelSteps(this.mLastDischargeStepLevel - level, modeBits, elapsedRealtimeMs);
                    this.mLastDischargeStepLevel = level;
                    this.mMinDischargeStepLevel = level;
                    this.mInitStepMode = this.mCurStepMode;
                    this.mModStepMode = 0;
                }
            } else {
                if (level >= 90) {
                    changed |= this.setChargingLocked(true);
                } else if (!this.mCharging) {
                    if (this.mLastChargeStepLevel < level) {
                        if (!this.mHandler.hasCallbacks(this.mDeferSetCharging)) {
                            this.mHandler.postDelayed(this.mDeferSetCharging, this.mConstants.BATTERY_CHARGED_DELAY_MS);
                        }
                    } else if (this.mLastChargeStepLevel > level) {
                        this.mHandler.removeCallbacks(this.mDeferSetCharging);
                    }
                } else if (this.mLastChargeStepLevel > level) {
                    changed |= this.setChargingLocked(false);
                }
                if (this.mLastChargeStepLevel != level && this.mMaxChargeStepLevel < level) {
                    this.mChargeStepTracker.addLevelSteps(level - this.mLastChargeStepLevel, modeBits, elapsedRealtimeMs);
                    this.mDailyChargeStepTracker.addLevelSteps(level - this.mLastChargeStepLevel, modeBits, elapsedRealtimeMs);
                    this.mMaxChargeStepLevel = level;
                    this.mInitStepMode = this.mCurStepMode;
                    this.mModStepMode = 0;
                }
                this.mLastChargeStepLevel = level;
            }
            if (changed) {
                this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
            }
        }
        if (!(onBattery || status != 5 && status != 1)) {
            this.mRecordingHistory = false;
        }
        this.mLastLearnedBatteryCapacityUah = chargeFullUah;
        this.mMinLearnedBatteryCapacityUah = this.mMinLearnedBatteryCapacityUah == -1 ? chargeFullUah : Math.min(this.mMinLearnedBatteryCapacityUah, chargeFullUah);
        this.mMaxLearnedBatteryCapacityUah = Math.max(this.mMaxLearnedBatteryCapacityUah, chargeFullUah);
        this.mBatteryTimeToFullSeconds = chargeTimeToFullSeconds;
    }

    public static boolean isOnBattery(int plugType, int status) {
        return plugType == 0 && status != 1;
    }

    private void reportChangesToStatsLog(BatteryStats.HistoryItem recentPast, int status, int plugType, int level) {
        if (recentPast == null || recentPast.batteryStatus != status) {
            FrameworkStatsLog.write(31, status);
        }
        if (recentPast == null || recentPast.batteryPlugType != plugType) {
            FrameworkStatsLog.write(32, plugType);
        }
        if (recentPast == null || recentPast.batteryLevel != level) {
            FrameworkStatsLog.write(30, level);
        }
    }

    @UnsupportedAppUsage
    public long getAwakeTimeBattery() {
        return this.getBatteryUptimeLocked(this.mClock.uptimeMillis());
    }

    @UnsupportedAppUsage
    public long getAwakeTimePlugged() {
        return this.mClock.uptimeMillis() * 1000L - this.getAwakeTimeBattery();
    }

    @Override
    public long computeUptime(long curTimeUs, int which) {
        return this.mUptimeUs + (curTimeUs - this.mUptimeStartUs);
    }

    @Override
    public long computeRealtime(long curTimeUs, int which) {
        return this.mRealtimeUs + (curTimeUs - this.mRealtimeStartUs);
    }

    @Override
    @UnsupportedAppUsage
    public long computeBatteryUptime(long curTimeUs, int which) {
        return this.mOnBatteryTimeBase.computeUptime(curTimeUs, which);
    }

    @Override
    @UnsupportedAppUsage
    public long computeBatteryRealtime(long curTimeUs, int which) {
        return this.mOnBatteryTimeBase.computeRealtime(curTimeUs, which);
    }

    @Override
    public long computeBatteryScreenOffUptime(long curTimeUs, int which) {
        return this.mOnBatteryScreenOffTimeBase.computeUptime(curTimeUs, which);
    }

    @Override
    public long computeBatteryScreenOffRealtime(long curTimeUs, int which) {
        return this.mOnBatteryScreenOffTimeBase.computeRealtime(curTimeUs, which);
    }

    private long computeTimePerLevel(long[] steps, int numSteps) {
        if (numSteps <= 0) {
            return -1L;
        }
        long total = 0L;
        for (int i = 0; i < numSteps; ++i) {
            total += steps[i] & 0xFFFFFFFFFFL;
        }
        return total / (long)numSteps;
    }

    @Override
    @UnsupportedAppUsage
    public long computeBatteryTimeRemaining(long curTime) {
        if (!this.mOnBattery) {
            return -1L;
        }
        if (this.mDischargeStepTracker.mNumStepDurations < 1) {
            return -1L;
        }
        long msPerLevel = this.mDischargeStepTracker.computeTimePerLevel();
        if (msPerLevel <= 0L) {
            return -1L;
        }
        return msPerLevel * (long)this.mCurrentBatteryLevel * 1000L;
    }

    @Override
    public BatteryStats.LevelStepTracker getDischargeLevelStepTracker() {
        return this.mDischargeStepTracker;
    }

    @Override
    public BatteryStats.LevelStepTracker getDailyDischargeLevelStepTracker() {
        return this.mDailyDischargeStepTracker;
    }

    @Override
    public long computeChargeTimeRemaining(long curTime) {
        if (this.mOnBattery) {
            return -1L;
        }
        if (this.mBatteryTimeToFullSeconds >= 0L) {
            return this.mBatteryTimeToFullSeconds * 1000000L;
        }
        if (this.mChargeStepTracker.mNumStepDurations < 1) {
            return -1L;
        }
        long msPerLevel = this.mChargeStepTracker.computeTimePerLevel();
        if (msPerLevel <= 0L) {
            return -1L;
        }
        return msPerLevel * (long)(100 - this.mCurrentBatteryLevel) * 1000L;
    }

    public CellularBatteryStats getCellularBatteryStats() {
        boolean which = false;
        long rawRealTimeUs = SystemClock.elapsedRealtime() * 1000L;
        BatteryStats.ControllerActivityCounter counter = this.getModemControllerActivity();
        long sleepTimeMs = counter.getSleepTimeCounter().getCountLocked(0);
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(0);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(0);
        long energyConsumedMaMs = counter.getPowerCounter().getCountLocked(0);
        long monitoredRailChargeConsumedMaMs = counter.getMonitoredRailChargeConsumedMaMs().getCountLocked(0);
        long[] timeInRatMs = new long[BatteryStats.NUM_DATA_CONNECTION_TYPES];
        for (int i = 0; i < timeInRatMs.length; ++i) {
            timeInRatMs[i] = this.getPhoneDataConnectionTime(i, rawRealTimeUs, 0) / 1000L;
        }
        long[] timeInRxSignalStrengthLevelMs = new long[CellSignalStrength.getNumSignalStrengthLevels()];
        for (int i = 0; i < timeInRxSignalStrengthLevelMs.length; ++i) {
            timeInRxSignalStrengthLevelMs[i] = this.getPhoneSignalStrengthTime(i, rawRealTimeUs, 0) / 1000L;
        }
        long[] txTimeMs = new long[Math.min(ModemActivityInfo.getNumTxPowerLevels(), counter.getTxTimeCounters().length)];
        long totalTxTimeMs = 0L;
        for (int i = 0; i < txTimeMs.length; ++i) {
            txTimeMs[i] = counter.getTxTimeCounters()[i].getCountLocked(0);
            totalTxTimeMs += txTimeMs[i];
        }
        return new CellularBatteryStats(this.computeBatteryRealtime(rawRealTimeUs, 0) / 1000L, this.getMobileRadioActiveTime(rawRealTimeUs, 0) / 1000L, this.getNetworkActivityPackets(1, 0), this.getNetworkActivityBytes(1, 0), this.getNetworkActivityPackets(0, 0), this.getNetworkActivityBytes(0, 0), sleepTimeMs, idleTimeMs, rxTimeMs, energyConsumedMaMs, timeInRatMs, timeInRxSignalStrengthLevelMs, txTimeMs, monitoredRailChargeConsumedMaMs);
    }

    public WifiBatteryStats getWifiBatteryStats() {
        boolean which = false;
        long rawRealTimeUs = SystemClock.elapsedRealtime() * 1000L;
        BatteryStats.ControllerActivityCounter counter = this.getWifiControllerActivity();
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(0);
        long scanTimeMs = counter.getScanTimeCounter().getCountLocked(0);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(0);
        long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(0);
        long totalControllerActivityTimeMs = this.computeBatteryRealtime(SystemClock.elapsedRealtime() * 1000L, 0) / 1000L;
        long sleepTimeMs = totalControllerActivityTimeMs - (idleTimeMs + rxTimeMs + txTimeMs);
        long energyConsumedMaMs = counter.getPowerCounter().getCountLocked(0);
        long monitoredRailChargeConsumedMaMs = counter.getMonitoredRailChargeConsumedMaMs().getCountLocked(0);
        long numAppScanRequest = 0L;
        for (int i = 0; i < this.mUidStats.size(); ++i) {
            numAppScanRequest += (long)this.mUidStats.valueAt((int)i).mWifiScanTimer.getCountLocked(0);
        }
        long[] timeInStateMs = new long[8];
        for (int i = 0; i < 8; ++i) {
            timeInStateMs[i] = this.getWifiStateTime(i, rawRealTimeUs, 0) / 1000L;
        }
        long[] timeInSupplStateMs = new long[13];
        for (int i = 0; i < 13; ++i) {
            timeInSupplStateMs[i] = this.getWifiSupplStateTime(i, rawRealTimeUs, 0) / 1000L;
        }
        long[] timeSignalStrengthTimeMs = new long[5];
        for (int i = 0; i < 5; ++i) {
            timeSignalStrengthTimeMs[i] = this.getWifiSignalStrengthTime(i, rawRealTimeUs, 0) / 1000L;
        }
        return new WifiBatteryStats(this.computeBatteryRealtime(rawRealTimeUs, 0) / 1000L, this.getWifiActiveTime(rawRealTimeUs, 0) / 1000L, this.getNetworkActivityPackets(3, 0), this.getNetworkActivityBytes(3, 0), this.getNetworkActivityPackets(2, 0), this.getNetworkActivityBytes(2, 0), sleepTimeMs, scanTimeMs, idleTimeMs, rxTimeMs, txTimeMs, energyConsumedMaMs, numAppScanRequest, timeInStateMs, timeSignalStrengthTimeMs, timeInSupplStateMs, monitoredRailChargeConsumedMaMs);
    }

    public GpsBatteryStats getGpsBatteryStats() {
        GpsBatteryStats s = new GpsBatteryStats();
        boolean which = false;
        long rawRealTimeUs = SystemClock.elapsedRealtime() * 1000L;
        s.setLoggingDurationMs(this.computeBatteryRealtime(rawRealTimeUs, 0) / 1000L);
        s.setEnergyConsumedMaMs(this.getGpsBatteryDrainMaMs());
        long[] time = new long[this.mGpsSignalQualityTimer.length];
        for (int i = 0; i < time.length; ++i) {
            time[i] = this.getGpsSignalQualityTime(i, rawRealTimeUs, 0) / 1000L;
        }
        s.setTimeInGpsSignalQualityLevel(time);
        return s;
    }

    @Override
    public BatteryStats.LevelStepTracker getChargeLevelStepTracker() {
        return this.mChargeStepTracker;
    }

    @Override
    public BatteryStats.LevelStepTracker getDailyChargeLevelStepTracker() {
        return this.mDailyChargeStepTracker;
    }

    @Override
    public ArrayList<BatteryStats.PackageChange> getDailyPackageChanges() {
        return this.mDailyPackageChanges;
    }

    protected long getBatteryUptimeLocked() {
        return this.getBatteryUptimeLocked(this.mClock.uptimeMillis());
    }

    protected long getBatteryUptimeLocked(long uptimeMs) {
        return this.mOnBatteryTimeBase.getUptime(uptimeMs * 1000L);
    }

    @Override
    public long getBatteryUptime(long curTimeUs) {
        return this.mOnBatteryTimeBase.getUptime(curTimeUs);
    }

    @Override
    @UnsupportedAppUsage
    public long getBatteryRealtime(long curTimeUs) {
        return this.mOnBatteryTimeBase.getRealtime(curTimeUs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getDischargeStartLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeStartLevelLocked();
        }
    }

    public int getDischargeStartLevelLocked() {
        return this.mDischargeUnplugLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getDischargeCurrentLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeCurrentLevelLocked();
        }
    }

    public int getDischargeCurrentLevelLocked() {
        return this.mDischargeCurrentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLowDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mLowDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel - 1;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHighDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mHighDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    @Override
    @UnsupportedAppUsage
    public int getDischargeAmount(int which) {
        int dischargeAmount;
        int n = dischargeAmount = which == 0 ? this.getHighDischargeAmountSinceCharge() : this.getDischargeStartLevel() - this.getDischargeCurrentLevel();
        if (dischargeAmount < 0) {
            dischargeAmount = 0;
        }
        return dischargeAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public int getDischargeAmountScreenOn() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOn;
            if (this.mOnBattery && Display.isOnState(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOnSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOnSinceCharge;
            if (this.mOnBattery && Display.isOnState(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public int getDischargeAmountScreenOff() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOff;
            if (this.mOnBattery && Display.isOffState(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val + this.getDischargeAmountScreenDoze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOffSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOffSinceCharge;
            if (this.mOnBattery && Display.isOffState(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val + this.getDischargeAmountScreenDozeSinceCharge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenDoze() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenDoze;
            if (this.mOnBattery && Display.isDozeState(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenDozeUnplugLevel) {
                val += this.mDischargeScreenDozeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenDozeSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenDozeSinceCharge;
            if (this.mOnBattery && Display.isDozeState(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenDozeUnplugLevel) {
                val += this.mDischargeScreenDozeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    @Override
    public long[] getSystemServiceTimeAtCpuSpeeds() {
        if (this.mBinderThreadCpuTimesUs == null) {
            return null;
        }
        return this.mBinderThreadCpuTimesUs.getCountsLocked(0);
    }

    @UnsupportedAppUsage
    public Uid getUidStatsLocked(int uid) {
        return this.getUidStatsLocked(uid, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    public Uid getUidStatsLocked(int uid, long elapsedRealtimeMs, long uptimeMs) {
        Uid u = this.mUidStats.get(uid);
        if (u == null) {
            if (Process.isSdkSandboxUid(uid)) {
                Log.wtf(TAG, "Tracking an SDK Sandbox UID");
            }
            u = new Uid(this, uid, elapsedRealtimeMs, uptimeMs);
            this.mUidStats.put(uid, u);
        }
        return u;
    }

    public Uid getAvailableUidStatsLocked(int uid) {
        Uid u = this.mUidStats.get(uid);
        return u;
    }

    @GuardedBy(value={"this"})
    public void onCleanupUserLocked(int userId, long elapsedRealtimeMs) {
        int firstUidForUser = UserHandle.getUid(userId, 0);
        int lastUidForUser = UserHandle.getUid(userId, 99999);
        this.mPendingRemovedUids.add(new UidToRemove(firstUidForUser, lastUidForUser, elapsedRealtimeMs));
    }

    @GuardedBy(value={"this"})
    public void onUserRemovedLocked(int userId) {
        if (this.mExternalSync != null) {
            this.mExternalSync.scheduleCleanupDueToRemovedUser(userId);
        }
    }

    @GuardedBy(value={"this"})
    public void clearRemovedUserUidsLocked(int userId) {
        int firstUidForUser = UserHandle.getUid(userId, 0);
        int lastUidForUser = UserHandle.getUid(userId, 99999);
        this.mUidStats.put(firstUidForUser, null);
        this.mUidStats.put(lastUidForUser, null);
        int firstIndex = this.mUidStats.indexOfKey(firstUidForUser);
        int lastIndex = this.mUidStats.indexOfKey(lastUidForUser);
        for (int i = firstIndex; i <= lastIndex; ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            if (uid == null) continue;
            uid.detachFromTimeBase();
        }
        this.mUidStats.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
        this.removeCpuStatsForUidRangeLocked(firstUidForUser, lastUidForUser);
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void removeUidStatsLocked(int uid) {
        this.removeUidStatsLocked(uid, this.mClock.elapsedRealtime());
    }

    @GuardedBy(value={"this"})
    public void removeUidStatsLocked(int uid, long elapsedRealtimeMs) {
        Uid u = this.mUidStats.get(uid);
        if (u != null) {
            u.detachFromTimeBase();
        }
        this.mUidStats.remove(uid);
        this.mPendingRemovedUids.add(new UidToRemove(uid, elapsedRealtimeMs));
    }

    @GuardedBy(value={"this"})
    private void removeCpuStatsForUidRangeLocked(int startUid, int endUid) {
        if (startUid == endUid) {
            this.mCpuUidUserSysTimeReader.removeUid(startUid);
            this.mCpuUidFreqTimeReader.removeUid(startUid);
            if (this.mConstants.TRACK_CPU_ACTIVE_CLUSTER_TIME) {
                this.mCpuUidActiveTimeReader.removeUid(startUid);
                this.mCpuUidClusterTimeReader.removeUid(startUid);
            }
            if (this.mKernelSingleUidTimeReader != null) {
                this.mKernelSingleUidTimeReader.removeUid(startUid);
            }
            ++this.mNumUidsRemoved;
        } else if (startUid < endUid) {
            this.mCpuUidFreqTimeReader.removeUidsInRange(startUid, endUid);
            this.mCpuUidUserSysTimeReader.removeUidsInRange(startUid, endUid);
            if (this.mConstants.TRACK_CPU_ACTIVE_CLUSTER_TIME) {
                this.mCpuUidActiveTimeReader.removeUidsInRange(startUid, endUid);
                this.mCpuUidClusterTimeReader.removeUidsInRange(startUid, endUid);
            }
            if (this.mKernelSingleUidTimeReader != null) {
                this.mKernelSingleUidTimeReader.removeUidsInRange(startUid, endUid);
            }
            ++this.mNumUidsRemoved;
        } else {
            Slog.w(TAG, "End UID " + endUid + " is smaller than start UID " + startUid);
        }
    }

    @UnsupportedAppUsage
    public Uid.Proc getProcessStatsLocked(int uid, String name) {
        return this.getProcessStatsLocked(uid, name, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    public Uid.Proc getProcessStatsLocked(int uid, String name, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs);
        return u.getProcessStatsLocked(name);
    }

    @UnsupportedAppUsage
    public Uid.Pkg getPackageStatsLocked(int uid, String pkg) {
        return this.getPackageStatsLocked(uid, pkg, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    public Uid.Pkg getPackageStatsLocked(int uid, String pkg, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs);
        return u.getPackageStatsLocked(pkg);
    }

    @UnsupportedAppUsage
    public Uid.Pkg.Serv getServiceStatsLocked(int uid, String pkg, String name) {
        return this.getServiceStatsLocked(uid, pkg, name, this.mClock.elapsedRealtime(), this.mClock.uptimeMillis());
    }

    public Uid.Pkg.Serv getServiceStatsLocked(int uid, String pkg, String name, long elapsedRealtimeMs, long uptimeMs) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid, elapsedRealtimeMs, uptimeMs);
        return u.getServiceStatsLocked(pkg, name);
    }

    @GuardedBy(value={"this"})
    public void shutdownLocked() {
        this.recordShutdownLocked(this.mClock.currentTimeMillis(), this.mClock.elapsedRealtime());
        this.writeSyncLocked();
        this.mShuttingDown = true;
    }

    @Override
    @GuardedBy(value={"this"})
    public boolean isProcessStateDataAvailable() {
        return this.trackPerProcStateCpuTimes();
    }

    @GuardedBy(value={"this"})
    public boolean trackPerProcStateCpuTimes() {
        return this.mCpuUidFreqTimeReader.isFastCpuTimesReader();
    }

    @GuardedBy(value={"this"})
    public void systemServicesReady(Context context) {
        this.mConstants.startObserving(context.getContentResolver());
        this.registerUsbStateReceiver(context);
    }

    @GuardedBy(value={"this"})
    public void initMeasuredEnergyStatsLocked(boolean[] supportedStandardBuckets, String[] customBucketNames) {
        boolean compatibleConfig;
        int numDisplays = this.mPerDisplayBatteryStats.length;
        for (int i = 0; i < numDisplays; ++i) {
            int screenState;
            this.mPerDisplayBatteryStats[i].screenStateAtLastEnergyMeasurement = screenState = this.mPerDisplayBatteryStats[i].screenState;
        }
        if (supportedStandardBuckets != null) {
            MeasuredEnergyStats.Config config = new MeasuredEnergyStats.Config(supportedStandardBuckets, customBucketNames, SUPPORTED_PER_PROCESS_STATE_STANDARD_ENERGY_BUCKETS, BatteryStatsImpl.getBatteryConsumerProcessStateNames());
            compatibleConfig = this.mMeasuredEnergyStatsConfig == null ? true : this.mMeasuredEnergyStatsConfig.isCompatible(config);
            this.mMeasuredEnergyStatsConfig = config;
            this.mGlobalMeasuredEnergyStats = new MeasuredEnergyStats(config);
            if (supportedStandardBuckets[5]) {
                this.mBluetoothPowerCalculator = new BluetoothPowerCalculator(this.mPowerProfile);
            }
            if (supportedStandardBuckets[3]) {
                this.mCpuPowerCalculator = new CpuPowerCalculator(this.mPowerProfile);
            }
            if (supportedStandardBuckets[7]) {
                this.mMobileRadioPowerCalculator = new MobileRadioPowerCalculator(this.mPowerProfile);
            }
            if (supportedStandardBuckets[4]) {
                this.mWifiPowerCalculator = new WifiPowerCalculator(this.mPowerProfile);
            }
        } else {
            compatibleConfig = this.mMeasuredEnergyStatsConfig == null;
            this.mMeasuredEnergyStatsConfig = null;
            this.mGlobalMeasuredEnergyStats = null;
        }
        if (!compatibleConfig) {
            this.resetAllStatsLocked(SystemClock.uptimeMillis(), SystemClock.elapsedRealtime(), 4);
        }
    }

    private static String[] getBatteryConsumerProcessStateNames() {
        String[] procStateNames = new String[5];
        for (int procState = 0; procState < 5; ++procState) {
            procStateNames[procState] = BatteryConsumer.processStateToString(procState);
        }
        return procStateNames;
    }

    @GuardedBy(value={"this"})
    public int getBatteryVoltageMvLocked() {
        return this.mBatteryVoltageMv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExternalStatsCollectionRateLimitMs() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.mConstants.EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS;
        }
    }

    @GuardedBy(value={"this"})
    public void dumpConstantsLocked(PrintWriter pw) {
        IndentingPrintWriter iPw = new IndentingPrintWriter((Writer)pw, "    ");
        iPw.println("BatteryStats constants:");
        iPw.increaseIndent();
        this.mConstants.dumpLocked(iPw);
        iPw.decreaseIndent();
    }

    @GuardedBy(value={"this"})
    public void dumpCpuStatsLocked(PrintWriter pw) {
        long[] times;
        Uid uid;
        int u;
        int i;
        int size = this.mUidStats.size();
        pw.println("Per UID CPU user & system time in ms:");
        for (i = 0; i < size; ++i) {
            u = this.mUidStats.keyAt(i);
            uid = this.mUidStats.get(u);
            pw.print("  ");
            pw.print(u);
            pw.print(": ");
            pw.print(uid.getUserCpuTimeUs(0) / 1000L);
            pw.print(" ");
            pw.println(uid.getSystemCpuTimeUs(0) / 1000L);
        }
        pw.println("Per UID CPU active time in ms:");
        for (i = 0; i < size; ++i) {
            u = this.mUidStats.keyAt(i);
            uid = this.mUidStats.get(u);
            if (uid.getCpuActiveTime() <= 0L) continue;
            pw.print("  ");
            pw.print(u);
            pw.print(": ");
            pw.println(uid.getCpuActiveTime());
        }
        pw.println("Per UID CPU cluster time in ms:");
        for (i = 0; i < size; ++i) {
            u = this.mUidStats.keyAt(i);
            times = this.mUidStats.get(u).getCpuClusterTimes();
            if (times == null) continue;
            pw.print("  ");
            pw.print(u);
            pw.print(": ");
            pw.println(Arrays.toString(times));
        }
        pw.println("Per UID CPU frequency time in ms:");
        for (i = 0; i < size; ++i) {
            u = this.mUidStats.keyAt(i);
            times = this.mUidStats.get(u).getCpuFreqTimes(0);
            if (times == null) continue;
            pw.print("  ");
            pw.print(u);
            pw.print(": ");
            pw.println(Arrays.toString(times));
        }
        this.updateSystemServiceCallStats();
        if (this.mBinderThreadCpuTimesUs != null) {
            pw.println("Per UID System server binder time in ms:");
            long[] systemServiceTimeAtCpuSpeeds = this.getSystemServiceTimeAtCpuSpeeds();
            for (int i2 = 0; i2 < size; ++i2) {
                int u2 = this.mUidStats.keyAt(i2);
                Uid uid2 = this.mUidStats.get(u2);
                double proportionalSystemServiceUsage = uid2.getProportionalSystemServiceUsage();
                long timeUs = 0L;
                for (int j = systemServiceTimeAtCpuSpeeds.length - 1; j >= 0; --j) {
                    timeUs = (long)((double)timeUs + (double)systemServiceTimeAtCpuSpeeds[j] * proportionalSystemServiceUsage);
                }
                pw.print("  ");
                pw.print(u2);
                pw.print(": ");
                pw.println(timeUs / 1000L);
            }
        }
    }

    @GuardedBy(value={"this"})
    public void dumpMeasuredEnergyStatsLocked(PrintWriter pw) {
        pw.printf("On battery measured charge stats (microcoulombs) \n", new Object[0]);
        if (this.mGlobalMeasuredEnergyStats == null) {
            pw.printf("    Not supported on this device.\n", new Object[0]);
            return;
        }
        this.dumpMeasuredEnergyStatsLocked(pw, "global usage", this.mGlobalMeasuredEnergyStats);
        int size = this.mUidStats.size();
        for (int i = 0; i < size; ++i) {
            int u = this.mUidStats.keyAt(i);
            Uid uid = this.mUidStats.get(u);
            String name = "uid " + uid.mUid;
            this.dumpMeasuredEnergyStatsLocked(pw, name, uid.mUidMeasuredEnergyStats);
        }
    }

    @GuardedBy(value={"this"})
    private void dumpMeasuredEnergyStatsLocked(PrintWriter pw, String name, MeasuredEnergyStats stats) {
        if (stats == null) {
            return;
        }
        IndentingPrintWriter iPw = new IndentingPrintWriter((Writer)pw, "    ");
        iPw.increaseIndent();
        iPw.printf("%s:\n", name);
        iPw.increaseIndent();
        stats.dump(iPw);
        iPw.decreaseIndent();
    }

    @GuardedBy(value={"this"})
    public void dumpPowerProfileLocked(PrintWriter pw) {
        IndentingPrintWriter iPw = new IndentingPrintWriter((Writer)pw, "    ");
        iPw.printf("Power Profile: \n", new Object[0]);
        iPw.increaseIndent();
        this.mPowerProfile.dump(iPw);
        iPw.decreaseIndent();
    }

    @GuardedBy(value={"this"})
    public void writeAsyncLocked() {
        this.writeStatsLocked(false);
        this.writeHistoryLocked(false);
    }

    @GuardedBy(value={"this"})
    public void writeSyncLocked() {
        this.writeStatsLocked(true);
        this.writeHistoryLocked(true);
    }

    @GuardedBy(value={"this"})
    void writeStatsLocked(boolean sync) {
        if (this.mStatsFile == null) {
            Slog.w(TAG, "writeStatsLocked: no file associated with this instance");
            return;
        }
        if (this.mShuttingDown) {
            return;
        }
        Parcel p = Parcel.obtain();
        long start = SystemClock.uptimeMillis();
        this.writeSummaryToParcel(p, false);
        this.mLastWriteTimeMs = this.mClock.elapsedRealtime();
        this.writeParcelToFileLocked(p, this.mStatsFile, sync);
    }

    void writeHistoryLocked(boolean sync) {
        if (this.mBatteryStatsHistory.getActiveFile() == null) {
            Slog.w(TAG, "writeHistoryLocked: no history file associated with this instance");
            return;
        }
        if (this.mShuttingDown) {
            return;
        }
        Parcel p = Parcel.obtain();
        long start = SystemClock.uptimeMillis();
        this.writeHistoryBuffer(p, true);
        this.writeParcelToFileLocked(p, this.mBatteryStatsHistory.getActiveFile(), sync);
    }

    void writeParcelToFileLocked(final Parcel p, final AtomicFile file, boolean sync) {
        if (sync) {
            this.commitPendingDataToDisk(p, file);
        } else {
            BackgroundThread.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    BatteryStatsImpl.this.commitPendingDataToDisk(p, file);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPendingDataToDisk(Parcel p, AtomicFile file) {
        this.mWriteLock.lock();
        FileOutputStream fos = null;
        try {
            long startTimeMs = SystemClock.uptimeMillis();
            fos = file.startWrite();
            fos.write(p.marshall());
            fos.flush();
            file.finishWrite(fos);
            EventLogTags.writeCommitSysConfigFile("batterystats", SystemClock.uptimeMillis() - startTimeMs);
        }
        catch (IOException e) {
            Slog.w(TAG, "Error writing battery statistics", e);
            file.failWrite(fos);
        }
        finally {
            p.recycle();
            this.mWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    public void readLocked() {
        if (this.mDailyFile != null) {
            this.readDailyStatsLocked();
        }
        if (this.mStatsFile == null) {
            Slog.w(TAG, "readLocked: no file associated with this instance");
            return;
        }
        AtomicFile activeHistoryFile = this.mBatteryStatsHistory.getActiveFile();
        if (activeHistoryFile == null) {
            Slog.w(TAG, "readLocked: no history file associated with this instance");
            return;
        }
        this.mUidStats.clear();
        Parcel stats = Parcel.obtain();
        try {
            long start = SystemClock.uptimeMillis();
            if (this.mStatsFile.exists()) {
                byte[] raw2 = this.mStatsFile.readFully();
                stats.unmarshall(raw2, 0, raw2.length);
                stats.setDataPosition(0);
                this.readSummaryFromParcel(stats);
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Error reading battery statistics", e);
            this.resetAllStatsLocked(SystemClock.uptimeMillis(), SystemClock.elapsedRealtime(), 1);
        }
        finally {
            stats.recycle();
        }
        Parcel history = Parcel.obtain();
        try {
            byte[] raw3;
            long start = SystemClock.uptimeMillis();
            if (activeHistoryFile.exists() && (raw3 = activeHistoryFile.readFully()).length > 0) {
                history.unmarshall(raw3, 0, raw3.length);
                history.setDataPosition(0);
                this.readHistoryBuffer(history);
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Error reading battery history", e);
            this.clearHistoryLocked();
            this.mBatteryStatsHistory.resetAllFiles();
        }
        finally {
            history.recycle();
        }
        this.mEndPlatformVersion = _Original_Build.ID;
        if (this.mHistoryBuffer.dataPosition() > 0 || this.mBatteryStatsHistory.getFilesNumbers().size() > 1) {
            this.mRecordingHistory = true;
            long elapsedRealtimeMs = this.mClock.elapsedRealtime();
            long uptimeMs = this.mClock.uptimeMillis();
            this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)4, this.mHistoryCur);
            this.startRecordingHistory(elapsedRealtimeMs, uptimeMs, false);
        }
        this.recordDailyStatsIfNeededLocked(false, this.mClock.currentTimeMillis());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @GuardedBy(value={"this"})
    void readHistoryBuffer(Parcel in) throws ParcelFormatException {
        int version = in.readInt();
        if (version != 208) {
            Slog.w("BatteryStats", "readHistoryBuffer: version got " + version + ", expected " + 208 + "; erasing old stats");
            return;
        }
        long historyBaseTime = in.readLong();
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        int bufSize = in.readInt();
        int curPos = in.dataPosition();
        if (bufSize >= this.mConstants.MAX_HISTORY_BUFFER * 100) {
            throw new ParcelFormatException("File corrupt: history data buffer too large " + bufSize);
        }
        if ((bufSize & 0xFFFFFFFC) != bufSize) {
            throw new ParcelFormatException("File corrupt: history data buffer not aligned " + bufSize);
        }
        this.mHistoryBuffer.appendFrom(in, curPos, bufSize);
        in.setDataPosition(curPos + bufSize);
        this.mHistoryBaseTimeMs = historyBaseTime;
        if (this.mHistoryBaseTimeMs > 0L) {
            long oldnow = this.mClock.elapsedRealtime();
            this.mHistoryBaseTimeMs = this.mHistoryBaseTimeMs - oldnow + 1L;
        }
    }

    void writeHistoryBuffer(Parcel out, boolean inclData) {
        out.writeInt(208);
        out.writeLong(this.mHistoryBaseTimeMs + this.mLastHistoryElapsedRealtimeMs);
        if (!inclData) {
            out.writeInt(0);
            out.writeInt(0);
            return;
        }
        out.writeInt(this.mHistoryBuffer.dataSize());
        out.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
    }

    @GuardedBy(value={"this"})
    public void readSummaryFromParcel(Parcel in) throws ParcelFormatException {
        int i;
        int i2;
        int NPKG;
        int version = in.readInt();
        if (version != 208) {
            Slog.w("BatteryStats", "readFromParcel: version got " + version + ", expected " + 208 + "; erasing old stats");
            return;
        }
        boolean inclHistory = in.readBoolean();
        if (inclHistory) {
            this.readHistoryBuffer(in);
            this.mBatteryStatsHistory.readFromParcel(in);
        }
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        int numTags = in.readInt();
        for (int i3 = 0; i3 < numTags; ++i3) {
            int idx = in.readInt();
            String str = in.readString();
            int uid = in.readInt();
            BatteryStats.HistoryTag tag = new BatteryStats.HistoryTag();
            tag.string = str;
            tag.uid = uid;
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(tag, idx);
            if (idx >= this.mNextHistoryTagIdx) {
                this.mNextHistoryTagIdx = idx + 1;
            }
            this.mNumHistoryTagChars += tag.string.length() + 1;
        }
        this.mStartCount = in.readInt();
        this.mUptimeUs = in.readLong();
        this.mRealtimeUs = in.readLong();
        this.mStartClockTimeMs = in.readLong();
        this.mStartPlatformVersion = in.readString();
        this.mEndPlatformVersion = in.readString();
        this.mOnBatteryTimeBase.readSummaryFromParcel(in);
        this.mOnBatteryScreenOffTimeBase.readSummaryFromParcel(in);
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargePlugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mCurrentBatteryLevel = in.readInt();
        this.mEstimatedBatteryCapacityMah = in.readInt();
        this.mLastLearnedBatteryCapacityUah = in.readInt();
        this.mMinLearnedBatteryCapacityUah = in.readInt();
        this.mMaxLearnedBatteryCapacityUah = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        this.mDischargeAmountScreenDozeSinceCharge = in.readInt();
        this.mDischargeStepTracker.readFromParcel(in);
        this.mChargeStepTracker.readFromParcel(in);
        this.mDailyDischargeStepTracker.readFromParcel(in);
        this.mDailyChargeStepTracker.readFromParcel(in);
        this.mDischargeCounter.readSummaryFromParcelLocked(in);
        this.mDischargeScreenOffCounter.readSummaryFromParcelLocked(in);
        this.mDischargeScreenDozeCounter.readSummaryFromParcelLocked(in);
        this.mDischargeLightDozeCounter.readSummaryFromParcelLocked(in);
        this.mDischargeDeepDozeCounter.readSummaryFromParcelLocked(in);
        if (NPKG > 0) {
            this.mDailyPackageChanges = new ArrayList(NPKG);
            for (NPKG = in.readInt(); NPKG > 0; --NPKG) {
                BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
                pc.mPackageName = in.readString();
                pc.mUpdate = in.readInt() != 0;
                pc.mVersionCode = in.readLong();
                this.mDailyPackageChanges.add(pc);
            }
        } else {
            this.mDailyPackageChanges = null;
        }
        this.mDailyStartTimeMs = in.readLong();
        this.mNextMinDailyDeadlineMs = in.readLong();
        this.mNextMaxDailyDeadlineMs = in.readLong();
        this.mBatteryTimeToFullSeconds = in.readLong();
        MeasuredEnergyStats.Config config = MeasuredEnergyStats.Config.createFromParcel(in);
        MeasuredEnergyStats measuredEnergyStats = MeasuredEnergyStats.createAndReadSummaryFromParcel(this.mMeasuredEnergyStatsConfig, in);
        if (config != null && Arrays.equals(config.getStateNames(), BatteryStatsImpl.getBatteryConsumerProcessStateNames())) {
            this.mMeasuredEnergyStatsConfig = config;
            this.mGlobalMeasuredEnergyStats = measuredEnergyStats;
        }
        ++this.mStartCount;
        this.mScreenState = 0;
        this.mScreenOnTimer.readSummaryFromParcelLocked(in);
        this.mScreenDozeTimer.readSummaryFromParcelLocked(in);
        for (i2 = 0; i2 < 5; ++i2) {
            this.mScreenBrightnessTimer[i2].readSummaryFromParcelLocked(in);
        }
        this.mInteractive = false;
        this.mInteractiveTimer.readSummaryFromParcelLocked(in);
        this.mPhoneOn = false;
        this.mPowerSaveModeEnabledTimer.readSummaryFromParcelLocked(in);
        this.mLongestLightIdleTimeMs = in.readLong();
        this.mLongestFullIdleTimeMs = in.readLong();
        this.mDeviceIdleModeLightTimer.readSummaryFromParcelLocked(in);
        this.mDeviceIdleModeFullTimer.readSummaryFromParcelLocked(in);
        this.mDeviceLightIdlingTimer.readSummaryFromParcelLocked(in);
        this.mDeviceIdlingTimer.readSummaryFromParcelLocked(in);
        this.mPhoneOnTimer.readSummaryFromParcelLocked(in);
        for (i2 = 0; i2 < CellSignalStrength.getNumSignalStrengthLevels(); ++i2) {
            this.mPhoneSignalStrengthsTimer[i2].readSummaryFromParcelLocked(in);
        }
        this.mPhoneSignalScanningTimer.readSummaryFromParcelLocked(in);
        for (i2 = 0; i2 < NUM_DATA_CONNECTION_TYPES; ++i2) {
            this.mPhoneDataConnectionsTimer[i2].readSummaryFromParcelLocked(in);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            this.mNetworkByteActivityCounters[i2].readSummaryFromParcelLocked(in);
            this.mNetworkPacketActivityCounters[i2].readSummaryFromParcelLocked(in);
        }
        int numRat = in.readInt();
        for (i = 0; i < numRat; ++i) {
            if (in.readInt() == 0) continue;
            this.getRatBatteryStatsLocked(i).readSummaryFromParcel(in);
        }
        this.mMobileRadioPowerState = 1;
        this.mMobileRadioActiveTimer.readSummaryFromParcelLocked(in);
        this.mMobileRadioActivePerAppTimer.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveAdjustedTime.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveUnknownTime.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveUnknownCount.readSummaryFromParcelLocked(in);
        this.mWifiMulticastWakelockTimer.readSummaryFromParcelLocked(in);
        this.mWifiRadioPowerState = 1;
        this.mWifiOn = false;
        this.mWifiOnTimer.readSummaryFromParcelLocked(in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mWifiActiveTimer.readSummaryFromParcelLocked(in);
        this.mWifiActivity.readSummaryFromParcel(in);
        for (i = 0; i < this.mGpsSignalQualityTimer.length; ++i) {
            this.mGpsSignalQualityTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mBluetoothActivity.readSummaryFromParcel(in);
        this.mModemActivity.readSummaryFromParcel(in);
        this.mHasWifiReporting = in.readInt() != 0;
        this.mHasBluetoothReporting = in.readInt() != 0;
        this.mHasModemReporting = in.readInt() != 0;
        this.mNumConnectivityChange = in.readInt();
        this.mFlashlightOnNesting = 0;
        this.mFlashlightOnTimer.readSummaryFromParcelLocked(in);
        this.mCameraOnNesting = 0;
        this.mCameraOnTimer.readSummaryFromParcelLocked(in);
        this.mBluetoothScanNesting = 0;
        this.mBluetoothScanTimer.readSummaryFromParcelLocked(in);
        int NRPMS = in.readInt();
        if (NRPMS > 10000) {
            throw new ParcelFormatException("File corrupt: too many rpm stats " + NRPMS);
        }
        for (int irpm = 0; irpm < NRPMS; ++irpm) {
            if (in.readInt() == 0) continue;
            String rpmName = in.readString();
            this.getRpmTimerLocked(rpmName).readSummaryFromParcelLocked(in);
        }
        int NSORPMS = in.readInt();
        if (NSORPMS > 10000) {
            throw new ParcelFormatException("File corrupt: too many screen-off rpm stats " + NSORPMS);
        }
        for (int irpm = 0; irpm < NSORPMS; ++irpm) {
            if (in.readInt() == 0) continue;
            String rpmName = in.readString();
            this.getScreenOffRpmTimerLocked(rpmName).readSummaryFromParcelLocked(in);
        }
        int NKW = in.readInt();
        if (NKW > 10000) {
            throw new ParcelFormatException("File corrupt: too many kernel wake locks " + NKW);
        }
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String kwltName = in.readString();
            this.getKernelWakelockTimerLocked(kwltName).readSummaryFromParcelLocked(in);
        }
        int NWR = in.readInt();
        if (NWR > 10000) {
            throw new ParcelFormatException("File corrupt: too many wakeup reasons " + NWR);
        }
        for (int iwr = 0; iwr < NWR; ++iwr) {
            if (in.readInt() == 0) continue;
            String reasonName = in.readString();
            this.getWakeupReasonTimerLocked(reasonName).readSummaryFromParcelLocked(in);
        }
        int NMS = in.readInt();
        for (int ims = 0; ims < NMS; ++ims) {
            if (in.readInt() == 0) continue;
            long kmstName = in.readLong();
            this.getKernelMemoryTimerLocked(kmstName).readSummaryFromParcelLocked(in);
        }
        int NU = in.readInt();
        if (NU > 10000) {
            throw new ParcelFormatException("File corrupt: too many uids " + NU);
        }
        long elapsedRealtimeMs = this.mClock.elapsedRealtime();
        long uptimeMs = this.mClock.uptimeMillis();
        for (int iu = 0; iu < NU; ++iu) {
            TimeBaseObs p;
            int ip;
            int i4;
            int uid = in.readInt();
            Uid u = new Uid(this, uid, elapsedRealtimeMs, uptimeMs);
            this.mUidStats.put(uid, u);
            u.mOnBatteryBackgroundTimeBase.readSummaryFromParcel(in);
            u.mOnBatteryScreenOffBackgroundTimeBase.readSummaryFromParcel(in);
            u.mWifiRunning = false;
            if (in.readInt() != 0) {
                u.mWifiRunningTimer.readSummaryFromParcelLocked(in);
            }
            u.mFullWifiLockOut = false;
            if (in.readInt() != 0) {
                u.mFullWifiLockTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiScanStarted = false;
            if (in.readInt() != 0) {
                u.mWifiScanTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiBatchedScanBinStarted = -1;
            for (i4 = 0; i4 < 5; ++i4) {
                if (in.readInt() == 0) continue;
                u.makeWifiBatchedScanBin(i4, null);
                u.mWifiBatchedScanTimer[i4].readSummaryFromParcelLocked(in);
            }
            u.mWifiMulticastWakelockCount = 0;
            if (in.readInt() != 0) {
                u.mWifiMulticastTimer.readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createAudioTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createVideoTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createFlashlightTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createCameraTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createForegroundActivityTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createForegroundServiceTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createAggregatedPartialWakelockTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createBluetoothScanTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createBluetoothUnoptimizedScanTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createBluetoothScanResultCounterLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createBluetoothScanResultBgCounterLocked().readSummaryFromParcelLocked(in);
            }
            u.mProcessState = 7;
            for (i4 = 0; i4 < 7; ++i4) {
                if (in.readInt() == 0) continue;
                u.makeProcessState(i4, null);
                u.mProcessStateTimer[i4].readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createVibratorOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                if (u.mUserActivityCounters == null) {
                    u.initUserActivityLocked();
                }
                for (i4 = 0; i4 < Uid.NUM_USER_ACTIVITY_TYPES; ++i4) {
                    u.mUserActivityCounters[i4].readSummaryFromParcelLocked(in);
                }
            }
            if (in.readInt() != 0) {
                u.ensureNetworkActivityLocked();
                for (i4 = 0; i4 < 10; ++i4) {
                    u.mNetworkByteActivityCounters[i4].readSummaryFromParcelLocked(in);
                    u.mNetworkPacketActivityCounters[i4].readSummaryFromParcelLocked(in);
                }
                if (in.readBoolean()) {
                    u.mMobileRadioActiveTime = TimeMultiStateCounter.readFromParcel(in, this.mOnBatteryTimeBase, 5, elapsedRealtimeMs);
                }
                u.mMobileRadioActiveCount.readSummaryFromParcelLocked(in);
            }
            u.mUserCpuTime.readSummaryFromParcelLocked(in);
            u.mSystemCpuTime.readSummaryFromParcelLocked(in);
            if (in.readInt() != 0) {
                int numClusters = in.readInt();
                if (this.mPowerProfile != null && this.mPowerProfile.getNumCpuClusters() != numClusters) {
                    throw new ParcelFormatException("Incompatible cpu cluster arrangement");
                }
                BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs);
                u.mCpuClusterSpeedTimesUs = new LongSamplingCounter[numClusters][];
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    if (in.readInt() != 0) {
                        int NSB = in.readInt();
                        if (this.mPowerProfile != null && this.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster) != NSB) {
                            throw new ParcelFormatException("File corrupt: too many speed bins " + NSB);
                        }
                        u.mCpuClusterSpeedTimesUs[cluster] = new LongSamplingCounter[NSB];
                        for (int speed = 0; speed < NSB; ++speed) {
                            if (in.readInt() == 0) continue;
                            u.mCpuClusterSpeedTimesUs[cluster][speed] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                            u.mCpuClusterSpeedTimesUs[cluster][speed].readSummaryFromParcelLocked(in);
                        }
                        continue;
                    }
                    u.mCpuClusterSpeedTimesUs[cluster] = null;
                }
            } else {
                BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs);
                u.mCpuClusterSpeedTimesUs = null;
            }
            BatteryStatsImpl.detachIfNotNull(u.mCpuFreqTimeMs);
            u.mCpuFreqTimeMs = LongSamplingCounterArray.readSummaryFromParcelLocked(in, this.mOnBatteryTimeBase);
            BatteryStatsImpl.detachIfNotNull(u.mScreenOffCpuFreqTimeMs);
            u.mScreenOffCpuFreqTimeMs = LongSamplingCounterArray.readSummaryFromParcelLocked(in, this.mOnBatteryScreenOffTimeBase);
            int stateCount = in.readInt();
            if (stateCount != 0) {
                u.mCpuActiveTimeMs = TimeMultiStateCounter.readFromParcel(in, this.mOnBatteryTimeBase, 5, this.mClock.elapsedRealtime());
            }
            u.mCpuClusterTimesMs.readSummaryFromParcelLocked(in);
            BatteryStatsImpl.detachIfNotNull(u.mProcStateTimeMs);
            u.mProcStateTimeMs = null;
            stateCount = in.readInt();
            if (stateCount != 0) {
                BatteryStatsImpl.detachIfNotNull(u.mProcStateTimeMs);
                u.mProcStateTimeMs = TimeInFreqMultiStateCounter.readFromParcel(in, this.mOnBatteryTimeBase, 8, this.getCpuFreqCount(), this.mClock.elapsedRealtime());
            }
            BatteryStatsImpl.detachIfNotNull(u.mProcStateScreenOffTimeMs);
            u.mProcStateScreenOffTimeMs = null;
            stateCount = in.readInt();
            if (stateCount != 0) {
                BatteryStatsImpl.detachIfNotNull(u.mProcStateScreenOffTimeMs);
                u.mProcStateScreenOffTimeMs = TimeInFreqMultiStateCounter.readFromParcel(in, this.mOnBatteryScreenOffTimeBase, 8, this.getCpuFreqCount(), this.mClock.elapsedRealtime());
            }
            if (in.readInt() != 0) {
                BatteryStatsImpl.detachIfNotNull(u.mMobileRadioApWakeupCount);
                u.mMobileRadioApWakeupCount = new LongSamplingCounter(this.mOnBatteryTimeBase);
                u.mMobileRadioApWakeupCount.readSummaryFromParcelLocked(in);
            } else {
                BatteryStatsImpl.detachIfNotNull(u.mMobileRadioApWakeupCount);
                u.mMobileRadioApWakeupCount = null;
            }
            if (in.readInt() != 0) {
                BatteryStatsImpl.detachIfNotNull(u.mWifiRadioApWakeupCount);
                u.mWifiRadioApWakeupCount = new LongSamplingCounter(this.mOnBatteryTimeBase);
                u.mWifiRadioApWakeupCount.readSummaryFromParcelLocked(in);
            } else {
                BatteryStatsImpl.detachIfNotNull(u.mWifiRadioApWakeupCount);
                u.mWifiRadioApWakeupCount = null;
            }
            u.mUidMeasuredEnergyStats = MeasuredEnergyStats.createAndReadSummaryFromParcel(this.mMeasuredEnergyStatsConfig, in);
            int NW = in.readInt();
            if (NW > MAX_WAKELOCKS_PER_UID + 1) {
                throw new ParcelFormatException("File corrupt: too many wake locks " + NW);
            }
            for (int iw = 0; iw < NW; ++iw) {
                String wlName = in.readString();
                u.readWakeSummaryFromParcelLocked(wlName, in);
            }
            int NS = in.readInt();
            if (NS > MAX_WAKELOCKS_PER_UID + 1) {
                throw new ParcelFormatException("File corrupt: too many syncs " + NS);
            }
            for (int is = 0; is < NS; ++is) {
                String name = in.readString();
                u.readSyncSummaryFromParcelLocked(name, in);
            }
            int NJ = in.readInt();
            if (NJ > MAX_WAKELOCKS_PER_UID + 1) {
                throw new ParcelFormatException("File corrupt: too many job timers " + NJ);
            }
            for (int ij = 0; ij < NJ; ++ij) {
                String name = in.readString();
                u.readJobSummaryFromParcelLocked(name, in);
            }
            u.readJobCompletionsFromParcelLocked(in);
            u.mJobsDeferredEventCount.readSummaryFromParcelLocked(in);
            u.mJobsDeferredCount.readSummaryFromParcelLocked(in);
            u.mJobsFreshnessTimeMs.readSummaryFromParcelLocked(in);
            BatteryStatsImpl.detachIfNotNull(u.mJobsFreshnessBuckets);
            for (int i5 = 0; i5 < JOB_FRESHNESS_BUCKETS.length; ++i5) {
                if (in.readInt() == 0) continue;
                u.mJobsFreshnessBuckets[i5] = new Counter(u.mBsi.mOnBatteryTimeBase);
                u.mJobsFreshnessBuckets[i5].readSummaryFromParcelLocked(in);
            }
            int NP = in.readInt();
            if (NP > 1000) {
                throw new ParcelFormatException("File corrupt: too many sensors " + NP);
            }
            for (int is = 0; is < NP; ++is) {
                int seNumber = in.readInt();
                if (in.readInt() == 0) continue;
                u.getSensorTimerLocked(seNumber, true).readSummaryFromParcelLocked(in);
            }
            NP = in.readInt();
            if (NP > 1000) {
                throw new ParcelFormatException("File corrupt: too many processes " + NP);
            }
            for (ip = 0; ip < NP; ++ip) {
                String procName = in.readString();
                p = u.getProcessStatsLocked(procName);
                ((Uid.Proc)p).mUserTimeMs = in.readLong();
                ((Uid.Proc)p).mSystemTimeMs = in.readLong();
                ((Uid.Proc)p).mForegroundTimeMs = in.readLong();
                ((Uid.Proc)p).mStarts = in.readInt();
                ((Uid.Proc)p).mNumCrashes = in.readInt();
                ((Uid.Proc)p).mNumAnrs = in.readInt();
                ((Uid.Proc)p).readExcessivePowerFromParcelLocked(in);
            }
            NP = in.readInt();
            if (NP > 10000) {
                throw new ParcelFormatException("File corrupt: too many packages " + NP);
            }
            for (ip = 0; ip < NP; ++ip) {
                String pkgName = in.readString();
                BatteryStatsImpl.detachIfNotNull(u.mPackageStats.get(pkgName));
                p = u.getPackageStatsLocked(pkgName);
                int NWA = in.readInt();
                if (NWA > 10000) {
                    throw new ParcelFormatException("File corrupt: too many wakeup alarms " + NWA);
                }
                ((Uid.Pkg)p).mWakeupAlarms.clear();
                for (int iwa = 0; iwa < NWA; ++iwa) {
                    String tag = in.readString();
                    Counter c = new Counter(this.mOnBatteryScreenOffTimeBase);
                    c.readSummaryFromParcelLocked(in);
                    ((Uid.Pkg)p).mWakeupAlarms.put(tag, c);
                }
                NS = in.readInt();
                if (NS > 10000) {
                    throw new ParcelFormatException("File corrupt: too many services " + NS);
                }
                for (int is = 0; is < NS; ++is) {
                    String servName = in.readString();
                    Uid.Pkg.Serv s = u.getServiceStatsLocked(pkgName, servName);
                    s.mStartTimeMs = in.readLong();
                    s.mStarts = in.readInt();
                    s.mLaunches = in.readInt();
                }
            }
        }
        this.mBinderThreadCpuTimesUs = LongSamplingCounterArray.readSummaryFromParcelLocked(in, this.mOnBatteryTimeBase);
    }

    @GuardedBy(value={"this"})
    public void writeSummaryToParcel(Parcel out, boolean inclHistory) {
        Timer rpmt;
        int i;
        int i2;
        this.pullPendingStateUpdatesLocked();
        this.getStartClockTime();
        long nowUptime = this.mClock.uptimeMillis() * 1000L;
        long nowRealtime = this.mClock.elapsedRealtime() * 1000L;
        out.writeInt(208);
        out.writeBoolean(inclHistory);
        if (inclHistory) {
            this.writeHistoryBuffer(out, true);
            this.mBatteryStatsHistory.writeToParcel(out);
        }
        out.writeInt(this.mHistoryTagPool.size());
        for (Map.Entry<BatteryStats.HistoryTag, Integer> ent : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag tag = ent.getKey();
            out.writeInt(ent.getValue());
            out.writeString(tag.string);
            out.writeInt(tag.uid);
        }
        out.writeInt(this.mStartCount);
        out.writeLong(this.computeUptime(nowUptime, 0));
        out.writeLong(this.computeRealtime(nowRealtime, 0));
        out.writeLong(this.mStartClockTimeMs);
        out.writeString(this.mStartPlatformVersion);
        out.writeString(this.mEndPlatformVersion);
        this.mOnBatteryTimeBase.writeSummaryToParcel(out, nowUptime, nowRealtime);
        this.mOnBatteryScreenOffTimeBase.writeSummaryToParcel(out, nowUptime, nowRealtime);
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargePlugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.mCurrentBatteryLevel);
        out.writeInt(this.mEstimatedBatteryCapacityMah);
        out.writeInt(this.mLastLearnedBatteryCapacityUah);
        out.writeInt(this.mMinLearnedBatteryCapacityUah);
        out.writeInt(this.mMaxLearnedBatteryCapacityUah);
        out.writeInt(this.getLowDischargeAmountSinceCharge());
        out.writeInt(this.getHighDischargeAmountSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOnSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOffSinceCharge());
        out.writeInt(this.getDischargeAmountScreenDozeSinceCharge());
        this.mDischargeStepTracker.writeToParcel(out);
        this.mChargeStepTracker.writeToParcel(out);
        this.mDailyDischargeStepTracker.writeToParcel(out);
        this.mDailyChargeStepTracker.writeToParcel(out);
        this.mDischargeCounter.writeSummaryFromParcelLocked(out);
        this.mDischargeScreenOffCounter.writeSummaryFromParcelLocked(out);
        this.mDischargeScreenDozeCounter.writeSummaryFromParcelLocked(out);
        this.mDischargeLightDozeCounter.writeSummaryFromParcelLocked(out);
        this.mDischargeDeepDozeCounter.writeSummaryFromParcelLocked(out);
        if (this.mDailyPackageChanges != null) {
            int NPKG = this.mDailyPackageChanges.size();
            out.writeInt(NPKG);
            for (int i3 = 0; i3 < NPKG; ++i3) {
                BatteryStats.PackageChange pc = this.mDailyPackageChanges.get(i3);
                out.writeString(pc.mPackageName);
                out.writeInt(pc.mUpdate ? 1 : 0);
                out.writeLong(pc.mVersionCode);
            }
        } else {
            out.writeInt(0);
        }
        out.writeLong(this.mDailyStartTimeMs);
        out.writeLong(this.mNextMinDailyDeadlineMs);
        out.writeLong(this.mNextMaxDailyDeadlineMs);
        out.writeLong(this.mBatteryTimeToFullSeconds);
        MeasuredEnergyStats.Config.writeToParcel(this.mMeasuredEnergyStatsConfig, out);
        MeasuredEnergyStats.writeSummaryToParcel(this.mGlobalMeasuredEnergyStats, out);
        this.mScreenOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mScreenDozeTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        for (i2 = 0; i2 < 5; ++i2) {
            this.mScreenBrightnessTimer[i2].writeSummaryFromParcelLocked(out, nowRealtime);
        }
        this.mInteractiveTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mPowerSaveModeEnabledTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        out.writeLong(this.mLongestLightIdleTimeMs);
        out.writeLong(this.mLongestFullIdleTimeMs);
        this.mDeviceIdleModeLightTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mDeviceIdleModeFullTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mDeviceLightIdlingTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mDeviceIdlingTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mPhoneOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        for (i2 = 0; i2 < CellSignalStrength.getNumSignalStrengthLevels(); ++i2) {
            this.mPhoneSignalStrengthsTimer[i2].writeSummaryFromParcelLocked(out, nowRealtime);
        }
        this.mPhoneSignalScanningTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        for (i2 = 0; i2 < NUM_DATA_CONNECTION_TYPES; ++i2) {
            this.mPhoneDataConnectionsTimer[i2].writeSummaryFromParcelLocked(out, nowRealtime);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            this.mNetworkByteActivityCounters[i2].writeSummaryFromParcelLocked(out);
            this.mNetworkPacketActivityCounters[i2].writeSummaryFromParcelLocked(out);
        }
        int numRat = this.mPerRatBatteryStats.length;
        out.writeInt(numRat);
        for (i = 0; i < numRat; ++i) {
            RadioAccessTechnologyBatteryStats ratStat = this.mPerRatBatteryStats[i];
            if (ratStat == null) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(1);
            ratStat.writeSummaryToParcel(out, nowRealtime);
        }
        this.mMobileRadioActiveTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mMobileRadioActivePerAppTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mMobileRadioActiveAdjustedTime.writeSummaryFromParcelLocked(out);
        this.mMobileRadioActiveUnknownTime.writeSummaryFromParcelLocked(out);
        this.mMobileRadioActiveUnknownCount.writeSummaryFromParcelLocked(out);
        this.mWifiMulticastWakelockTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mWifiOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mGlobalWifiRunningTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeSummaryFromParcelLocked(out, nowRealtime);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeSummaryFromParcelLocked(out, nowRealtime);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeSummaryFromParcelLocked(out, nowRealtime);
        }
        this.mWifiActiveTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mWifiActivity.writeSummaryToParcel(out);
        for (i = 0; i < this.mGpsSignalQualityTimer.length; ++i) {
            this.mGpsSignalQualityTimer[i].writeSummaryFromParcelLocked(out, nowRealtime);
        }
        this.mBluetoothActivity.writeSummaryToParcel(out);
        this.mModemActivity.writeSummaryToParcel(out);
        out.writeInt(this.mHasWifiReporting ? 1 : 0);
        out.writeInt(this.mHasBluetoothReporting ? 1 : 0);
        out.writeInt(this.mHasModemReporting ? 1 : 0);
        out.writeInt(this.mNumConnectivityChange);
        this.mFlashlightOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mCameraOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        this.mBluetoothScanTimer.writeSummaryFromParcelLocked(out, nowRealtime);
        out.writeInt(this.mRpmStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mRpmStats.entrySet()) {
            rpmt = ent.getValue();
            if (rpmt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                rpmt.writeSummaryFromParcelLocked(out, nowRealtime);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mScreenOffRpmStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mScreenOffRpmStats.entrySet()) {
            rpmt = ent.getValue();
            if (rpmt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                rpmt.writeSummaryFromParcelLocked(out, nowRealtime);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mKernelWakelockStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
            Timer kwlt = ent.getValue();
            if (kwlt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                kwlt.writeSummaryFromParcelLocked(out, nowRealtime);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mWakeupReasonStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mWakeupReasonStats.entrySet()) {
            SamplingTimer timer = ent.getValue();
            if (timer != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                timer.writeSummaryFromParcelLocked(out, nowRealtime);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mKernelMemoryStats.size());
        for (int i4 = 0; i4 < this.mKernelMemoryStats.size(); ++i4) {
            Timer kmt = this.mKernelMemoryStats.valueAt(i4);
            if (kmt != null) {
                out.writeInt(1);
                out.writeLong(this.mKernelMemoryStats.keyAt(i4));
                kmt.writeSummaryFromParcelLocked(out, nowRealtime);
                continue;
            }
            out.writeInt(0);
        }
        int NU = this.mUidStats.size();
        out.writeInt(NU);
        for (int iu = 0; iu < NU; ++iu) {
            int i5;
            out.writeInt(this.mUidStats.keyAt(iu));
            Uid u = this.mUidStats.valueAt(iu);
            u.mOnBatteryBackgroundTimeBase.writeSummaryToParcel(out, nowUptime, nowRealtime);
            u.mOnBatteryScreenOffBackgroundTimeBase.writeSummaryToParcel(out, nowUptime, nowRealtime);
            if (u.mWifiRunningTimer != null) {
                out.writeInt(1);
                u.mWifiRunningTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mFullWifiLockTimer != null) {
                out.writeInt(1);
                u.mFullWifiLockTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mWifiScanTimer != null) {
                out.writeInt(1);
                u.mWifiScanTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            for (i5 = 0; i5 < 5; ++i5) {
                if (u.mWifiBatchedScanTimer[i5] != null) {
                    out.writeInt(1);
                    u.mWifiBatchedScanTimer[i5].writeSummaryFromParcelLocked(out, nowRealtime);
                    continue;
                }
                out.writeInt(0);
            }
            if (u.mWifiMulticastTimer != null) {
                out.writeInt(1);
                u.mWifiMulticastTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                u.mAudioTurnedOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                u.mVideoTurnedOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mFlashlightTurnedOnTimer != null) {
                out.writeInt(1);
                u.mFlashlightTurnedOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mCameraTurnedOnTimer != null) {
                out.writeInt(1);
                u.mCameraTurnedOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mForegroundActivityTimer != null) {
                out.writeInt(1);
                u.mForegroundActivityTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mForegroundServiceTimer != null) {
                out.writeInt(1);
                u.mForegroundServiceTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mAggregatedPartialWakelockTimer != null) {
                out.writeInt(1);
                u.mAggregatedPartialWakelockTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mBluetoothScanTimer != null) {
                out.writeInt(1);
                u.mBluetoothScanTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mBluetoothUnoptimizedScanTimer != null) {
                out.writeInt(1);
                u.mBluetoothUnoptimizedScanTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mBluetoothScanResultCounter != null) {
                out.writeInt(1);
                u.mBluetoothScanResultCounter.writeSummaryFromParcelLocked(out);
            } else {
                out.writeInt(0);
            }
            if (u.mBluetoothScanResultBgCounter != null) {
                out.writeInt(1);
                u.mBluetoothScanResultBgCounter.writeSummaryFromParcelLocked(out);
            } else {
                out.writeInt(0);
            }
            for (i5 = 0; i5 < 7; ++i5) {
                if (u.mProcessStateTimer[i5] != null) {
                    out.writeInt(1);
                    u.mProcessStateTimer[i5].writeSummaryFromParcelLocked(out, nowRealtime);
                    continue;
                }
                out.writeInt(0);
            }
            if (u.mVibratorOnTimer != null) {
                out.writeInt(1);
                u.mVibratorOnTimer.writeSummaryFromParcelLocked(out, nowRealtime);
            } else {
                out.writeInt(0);
            }
            if (u.mUserActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i5 = 0; i5 < Uid.NUM_USER_ACTIVITY_TYPES; ++i5) {
                    u.mUserActivityCounters[i5].writeSummaryFromParcelLocked(out);
                }
            }
            if (u.mNetworkByteActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i5 = 0; i5 < 10; ++i5) {
                    u.mNetworkByteActivityCounters[i5].writeSummaryFromParcelLocked(out);
                    u.mNetworkPacketActivityCounters[i5].writeSummaryFromParcelLocked(out);
                }
                if (u.mMobileRadioActiveTime != null) {
                    out.writeBoolean(true);
                    u.mMobileRadioActiveTime.writeToParcel(out);
                } else {
                    out.writeBoolean(false);
                }
                u.mMobileRadioActiveCount.writeSummaryFromParcelLocked(out);
            }
            u.mUserCpuTime.writeSummaryFromParcelLocked(out);
            u.mSystemCpuTime.writeSummaryFromParcelLocked(out);
            if (u.mCpuClusterSpeedTimesUs != null) {
                out.writeInt(1);
                out.writeInt(u.mCpuClusterSpeedTimesUs.length);
                for (LongSamplingCounter[] cpuSpeeds : u.mCpuClusterSpeedTimesUs) {
                    if (cpuSpeeds != null) {
                        out.writeInt(1);
                        out.writeInt(cpuSpeeds.length);
                        for (LongSamplingCounter c : cpuSpeeds) {
                            if (c != null) {
                                out.writeInt(1);
                                c.writeSummaryFromParcelLocked(out);
                                continue;
                            }
                            out.writeInt(0);
                        }
                        continue;
                    }
                    out.writeInt(0);
                }
            } else {
                out.writeInt(0);
            }
            LongSamplingCounterArray.writeSummaryToParcelLocked(out, u.mCpuFreqTimeMs);
            LongSamplingCounterArray.writeSummaryToParcelLocked(out, u.mScreenOffCpuFreqTimeMs);
            if (u.mCpuActiveTimeMs != null) {
                out.writeInt(u.mCpuActiveTimeMs.getStateCount());
                u.mCpuActiveTimeMs.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            u.mCpuClusterTimesMs.writeSummaryToParcelLocked(out);
            if (u.mProcStateTimeMs != null) {
                out.writeInt(u.mProcStateTimeMs.getStateCount());
                u.mProcStateTimeMs.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (u.mProcStateScreenOffTimeMs != null) {
                out.writeInt(u.mProcStateScreenOffTimeMs.getStateCount());
                u.mProcStateScreenOffTimeMs.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (u.mMobileRadioApWakeupCount != null) {
                out.writeInt(1);
                u.mMobileRadioApWakeupCount.writeSummaryFromParcelLocked(out);
            } else {
                out.writeInt(0);
            }
            if (u.mWifiRadioApWakeupCount != null) {
                out.writeInt(1);
                u.mWifiRadioApWakeupCount.writeSummaryFromParcelLocked(out);
            } else {
                out.writeInt(0);
            }
            MeasuredEnergyStats.writeSummaryToParcel(u.mUidMeasuredEnergyStats, out);
            ArrayMap<String, Uid.Wakelock> wakeStats = u.mWakelockStats.getMap();
            int NW = wakeStats.size();
            out.writeInt(NW);
            for (int iw = 0; iw < NW; ++iw) {
                out.writeString(wakeStats.keyAt(iw));
                Uid.Wakelock wl = wakeStats.valueAt(iw);
                if (wl.mTimerFull != null) {
                    out.writeInt(1);
                    wl.mTimerFull.writeSummaryFromParcelLocked(out, nowRealtime);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerPartial != null) {
                    out.writeInt(1);
                    wl.mTimerPartial.writeSummaryFromParcelLocked(out, nowRealtime);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerWindow != null) {
                    out.writeInt(1);
                    wl.mTimerWindow.writeSummaryFromParcelLocked(out, nowRealtime);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerDraw != null) {
                    out.writeInt(1);
                    wl.mTimerDraw.writeSummaryFromParcelLocked(out, nowRealtime);
                    continue;
                }
                out.writeInt(0);
            }
            ArrayMap<String, DualTimer> syncStats = u.mSyncStats.getMap();
            int NS = syncStats.size();
            out.writeInt(NS);
            for (int is = 0; is < NS; ++is) {
                out.writeString(syncStats.keyAt(is));
                syncStats.valueAt(is).writeSummaryFromParcelLocked(out, nowRealtime);
            }
            ArrayMap<String, DualTimer> jobStats = u.mJobStats.getMap();
            int NJ = jobStats.size();
            out.writeInt(NJ);
            for (int ij = 0; ij < NJ; ++ij) {
                out.writeString(jobStats.keyAt(ij));
                jobStats.valueAt(ij).writeSummaryFromParcelLocked(out, nowRealtime);
            }
            u.writeJobCompletionsToParcelLocked(out);
            u.mJobsDeferredEventCount.writeSummaryFromParcelLocked(out);
            u.mJobsDeferredCount.writeSummaryFromParcelLocked(out);
            u.mJobsFreshnessTimeMs.writeSummaryFromParcelLocked(out);
            for (int i6 = 0; i6 < JOB_FRESHNESS_BUCKETS.length; ++i6) {
                if (u.mJobsFreshnessBuckets[i6] != null) {
                    out.writeInt(1);
                    u.mJobsFreshnessBuckets[i6].writeSummaryFromParcelLocked(out);
                    continue;
                }
                out.writeInt(0);
            }
            int NSE = u.mSensorStats.size();
            out.writeInt(NSE);
            for (int ise = 0; ise < NSE; ++ise) {
                out.writeInt(u.mSensorStats.keyAt(ise));
                Uid.Sensor se = u.mSensorStats.valueAt(ise);
                if (se.mTimer != null) {
                    out.writeInt(1);
                    se.mTimer.writeSummaryFromParcelLocked(out, nowRealtime);
                    continue;
                }
                out.writeInt(0);
            }
            int NP = u.mProcessStats.size();
            out.writeInt(NP);
            for (int ip = 0; ip < NP; ++ip) {
                out.writeString(u.mProcessStats.keyAt(ip));
                Uid.Proc ps = u.mProcessStats.valueAt(ip);
                out.writeLong(ps.mUserTimeMs);
                out.writeLong(ps.mSystemTimeMs);
                out.writeLong(ps.mForegroundTimeMs);
                out.writeInt(ps.mStarts);
                out.writeInt(ps.mNumCrashes);
                out.writeInt(ps.mNumAnrs);
                ps.writeExcessivePowerToParcelLocked(out);
            }
            NP = u.mPackageStats.size();
            out.writeInt(NP);
            if (NP <= 0) continue;
            for (Map.Entry<String, Uid.Pkg> ent : u.mPackageStats.entrySet()) {
                out.writeString(ent.getKey());
                Uid.Pkg ps = ent.getValue();
                int NWA = ps.mWakeupAlarms.size();
                out.writeInt(NWA);
                for (int iwa = 0; iwa < NWA; ++iwa) {
                    out.writeString(ps.mWakeupAlarms.keyAt(iwa));
                    ps.mWakeupAlarms.valueAt(iwa).writeSummaryFromParcelLocked(out);
                }
                NS = ps.mServiceStats.size();
                out.writeInt(NS);
                for (int is = 0; is < NS; ++is) {
                    out.writeString(ps.mServiceStats.keyAt(is));
                    Uid.Pkg.Serv ss = ps.mServiceStats.valueAt(is);
                    long time = ss.getStartTimeToNowLocked(this.mOnBatteryTimeBase.getUptime(nowUptime) / 1000L);
                    out.writeLong(time);
                    out.writeInt(ss.mStarts);
                    out.writeInt(ss.mLaunches);
                }
            }
        }
        LongSamplingCounterArray.writeSummaryToParcelLocked(out, this.mBinderThreadCpuTimesUs);
    }

    @GuardedBy(value={"this"})
    public void readFromParcel(Parcel in) {
        this.readFromParcelLocked(in);
    }

    @GuardedBy(value={"this"})
    void readFromParcelLocked(Parcel in) {
        int i;
        int magic = in.readInt();
        if (magic != -1166707595) {
            throw new ParcelFormatException("Bad magic number: #" + Integer.toHexString(magic));
        }
        this.readHistoryBuffer(in);
        this.mBatteryStatsHistory.readFromParcel(in);
        this.mStartCount = in.readInt();
        this.mStartClockTimeMs = in.readLong();
        this.mStartPlatformVersion = in.readString();
        this.mEndPlatformVersion = in.readString();
        this.mUptimeUs = in.readLong();
        this.mUptimeStartUs = in.readLong();
        this.mRealtimeUs = in.readLong();
        this.mRealtimeStartUs = in.readLong();
        this.mOnBattery = in.readInt() != 0;
        this.mEstimatedBatteryCapacityMah = in.readInt();
        this.mLastLearnedBatteryCapacityUah = in.readInt();
        this.mMinLearnedBatteryCapacityUah = in.readInt();
        this.mMaxLearnedBatteryCapacityUah = in.readInt();
        this.mOnBatteryInternal = false;
        this.mOnBatteryTimeBase.readFromParcel(in);
        this.mOnBatteryScreenOffTimeBase.readFromParcel(in);
        this.mScreenState = 0;
        this.mScreenOnTimer = new StopwatchTimer(this.mClock, null, -1, null, this.mOnBatteryTimeBase, in);
        this.mScreenDozeTimer = new StopwatchTimer(this.mClock, null, -1, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(this.mClock, null, -100 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mInteractive = false;
        this.mInteractiveTimer = new StopwatchTimer(this.mClock, null, -10, null, this.mOnBatteryTimeBase, in);
        this.mPhoneOn = false;
        this.mPowerSaveModeEnabledTimer = new StopwatchTimer(this.mClock, null, -2, null, this.mOnBatteryTimeBase, in);
        this.mLongestLightIdleTimeMs = in.readLong();
        this.mLongestFullIdleTimeMs = in.readLong();
        this.mDeviceIdleModeLightTimer = new StopwatchTimer(this.mClock, null, -14, null, this.mOnBatteryTimeBase, in);
        this.mDeviceIdleModeFullTimer = new StopwatchTimer(this.mClock, null, -11, null, this.mOnBatteryTimeBase, in);
        this.mDeviceLightIdlingTimer = new StopwatchTimer(this.mClock, null, -15, null, this.mOnBatteryTimeBase, in);
        this.mDeviceIdlingTimer = new StopwatchTimer(this.mClock, null, -12, null, this.mOnBatteryTimeBase, in);
        this.mPhoneOnTimer = new StopwatchTimer(this.mClock, null, -3, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(this.mClock, null, -200 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(this.mClock, null, -199, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(this.mClock, null, -300 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        }
        this.mMobileRadioPowerState = 1;
        this.mMobileRadioActiveTimer = new StopwatchTimer(this.mClock, null, -400, null, this.mOnBatteryTimeBase, in);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(this.mClock, null, -401, null, this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mWifiMulticastWakelockTimer = new StopwatchTimer(this.mClock, null, -4, null, this.mOnBatteryTimeBase, in);
        this.mWifiRadioPowerState = 1;
        this.mWifiOn = false;
        this.mWifiOnTimer = new StopwatchTimer(this.mClock, null, -4, null, this.mOnBatteryTimeBase, in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer = new StopwatchTimer(this.mClock, null, -5, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(this.mClock, null, -600 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(this.mClock, null, -700 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(this.mClock, null, -800 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mWifiActiveTimer = new StopwatchTimer(this.mClock, null, -900, null, this.mOnBatteryTimeBase, in);
        this.mWifiActivity = new ControllerActivityCounterImpl(this.mClock, this.mOnBatteryTimeBase, 1, in);
        for (i = 0; i < this.mGpsSignalQualityTimer.length; ++i) {
            this.mGpsSignalQualityTimer[i] = new StopwatchTimer(this.mClock, null, -1000 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mBluetoothActivity = new ControllerActivityCounterImpl(this.mClock, this.mOnBatteryTimeBase, 1, in);
        this.mModemActivity = new ControllerActivityCounterImpl(this.mClock, this.mOnBatteryTimeBase, ModemActivityInfo.getNumTxPowerLevels(), in);
        this.mHasWifiReporting = in.readInt() != 0;
        this.mHasBluetoothReporting = in.readInt() != 0;
        this.mHasModemReporting = in.readInt() != 0;
        this.mNumConnectivityChange = in.readInt();
        this.mAudioOnNesting = 0;
        this.mAudioOnTimer = new StopwatchTimer(this.mClock, null, -7, null, this.mOnBatteryTimeBase);
        this.mVideoOnNesting = 0;
        this.mVideoOnTimer = new StopwatchTimer(this.mClock, null, -8, null, this.mOnBatteryTimeBase);
        this.mFlashlightOnNesting = 0;
        this.mFlashlightOnTimer = new StopwatchTimer(this.mClock, null, -9, null, this.mOnBatteryTimeBase, in);
        this.mCameraOnNesting = 0;
        this.mCameraOnTimer = new StopwatchTimer(this.mClock, null, -13, null, this.mOnBatteryTimeBase, in);
        this.mBluetoothScanNesting = 0;
        this.mBluetoothScanTimer = new StopwatchTimer(this.mClock, null, -14, null, this.mOnBatteryTimeBase, in);
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargePlugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mCurrentBatteryLevel = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOn = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOff = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        this.mDischargeAmountScreenDoze = in.readInt();
        this.mDischargeAmountScreenDozeSinceCharge = in.readInt();
        this.mDischargeStepTracker.readFromParcel(in);
        this.mChargeStepTracker.readFromParcel(in);
        this.mDischargeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mDischargeScreenOffCounter = new LongSamplingCounter(this.mOnBatteryScreenOffTimeBase, in);
        this.mDischargeScreenDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mDischargeLightDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mDischargeDeepDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mLastWriteTimeMs = in.readLong();
        this.mBatteryTimeToFullSeconds = in.readLong();
        MeasuredEnergyStats.Config config = MeasuredEnergyStats.Config.createFromParcel(in);
        MeasuredEnergyStats measuredEnergyStats = MeasuredEnergyStats.createFromParcel(this.mMeasuredEnergyStatsConfig, in);
        if (config != null && Arrays.equals(config.getStateNames(), BatteryStatsImpl.getBatteryConsumerProcessStateNames())) {
            this.mMeasuredEnergyStatsConfig = config;
            this.mGlobalMeasuredEnergyStats = measuredEnergyStats;
        }
        this.mRpmStats.clear();
        int NRPMS = in.readInt();
        for (int irpm = 0; irpm < NRPMS; ++irpm) {
            if (in.readInt() == 0) continue;
            String rpmName = in.readString();
            SamplingTimer rpmt = new SamplingTimer(this.mClock, this.mOnBatteryTimeBase, in);
            this.mRpmStats.put(rpmName, rpmt);
        }
        this.mScreenOffRpmStats.clear();
        int NSORPMS = in.readInt();
        for (int irpm = 0; irpm < NSORPMS; ++irpm) {
            if (in.readInt() == 0) continue;
            String rpmName = in.readString();
            SamplingTimer rpmt = new SamplingTimer(this.mClock, this.mOnBatteryScreenOffTimeBase, in);
            this.mScreenOffRpmStats.put(rpmName, rpmt);
        }
        this.mKernelWakelockStats.clear();
        int NKW = in.readInt();
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String wakelockName = in.readString();
            SamplingTimer kwlt = new SamplingTimer(this.mClock, this.mOnBatteryScreenOffTimeBase, in);
            this.mKernelWakelockStats.put(wakelockName, kwlt);
        }
        this.mWakeupReasonStats.clear();
        int NWR = in.readInt();
        for (int iwr = 0; iwr < NWR; ++iwr) {
            if (in.readInt() == 0) continue;
            String reasonName = in.readString();
            SamplingTimer timer = new SamplingTimer(this.mClock, this.mOnBatteryTimeBase, in);
            this.mWakeupReasonStats.put(reasonName, timer);
        }
        this.mKernelMemoryStats.clear();
        int nmt = in.readInt();
        for (int imt = 0; imt < nmt; ++imt) {
            if (in.readInt() == 0) continue;
            Long bucket = in.readLong();
            SamplingTimer kmt = new SamplingTimer(this.mClock, this.mOnBatteryTimeBase, in);
            this.mKernelMemoryStats.put(bucket, kmt);
        }
        this.mPartialTimers.clear();
        this.mFullTimers.clear();
        this.mWindowTimers.clear();
        this.mWifiRunningTimers.clear();
        this.mFullWifiLockTimers.clear();
        this.mWifiScanTimers.clear();
        this.mWifiBatchedScanTimers.clear();
        this.mWifiMulticastTimers.clear();
        this.mAudioTurnedOnTimers.clear();
        this.mVideoTurnedOnTimers.clear();
        this.mFlashlightTurnedOnTimers.clear();
        this.mCameraTurnedOnTimers.clear();
        int numUids = in.readInt();
        this.mUidStats.clear();
        long elapsedRealtimeMs = this.mClock.elapsedRealtime();
        long uptimeMs = this.mClock.uptimeMillis();
        for (int i2 = 0; i2 < numUids; ++i2) {
            int uid = in.readInt();
            Uid u = new Uid(this, uid, elapsedRealtimeMs, uptimeMs);
            u.readFromParcelLocked(this.mOnBatteryTimeBase, this.mOnBatteryScreenOffTimeBase, in);
            this.mUidStats.append(uid, u);
        }
        this.mBinderThreadCpuTimesUs = LongSamplingCounterArray.readFromParcel(in, this.mOnBatteryTimeBase);
    }

    @Override
    @GuardedBy(value={"this"})
    public void writeToParcel(Parcel out, int flags) {
        this.writeToParcelLocked(out, true, flags);
    }

    @Override
    @GuardedBy(value={"this"})
    public void writeToParcelWithoutUids(Parcel out, int flags) {
        this.writeToParcelLocked(out, false, flags);
    }

    @GuardedBy(value={"this"})
    void writeToParcelLocked(Parcel out, boolean inclUids, int flags) {
        SamplingTimer rpmt;
        int i;
        this.pullPendingStateUpdatesLocked();
        this.updateSystemServiceCallStats();
        this.getStartClockTime();
        long uSecUptime = this.mClock.uptimeMillis() * 1000L;
        long uSecRealtime = this.mClock.elapsedRealtime() * 1000L;
        long batteryRealtime = this.mOnBatteryTimeBase.getRealtime(uSecRealtime);
        long batteryScreenOffRealtime = this.mOnBatteryScreenOffTimeBase.getRealtime(uSecRealtime);
        out.writeInt(-1166707595);
        this.writeHistoryBuffer(out, true);
        this.mBatteryStatsHistory.writeToParcel(out);
        out.writeInt(this.mStartCount);
        out.writeLong(this.mStartClockTimeMs);
        out.writeString(this.mStartPlatformVersion);
        out.writeString(this.mEndPlatformVersion);
        out.writeLong(this.mUptimeUs);
        out.writeLong(this.mUptimeStartUs);
        out.writeLong(this.mRealtimeUs);
        out.writeLong(this.mRealtimeStartUs);
        out.writeInt(this.mOnBattery ? 1 : 0);
        out.writeInt(this.mEstimatedBatteryCapacityMah);
        out.writeInt(this.mLastLearnedBatteryCapacityUah);
        out.writeInt(this.mMinLearnedBatteryCapacityUah);
        out.writeInt(this.mMaxLearnedBatteryCapacityUah);
        this.mOnBatteryTimeBase.writeToParcel(out, uSecUptime, uSecRealtime);
        this.mOnBatteryScreenOffTimeBase.writeToParcel(out, uSecUptime, uSecRealtime);
        this.mScreenOnTimer.writeToParcel(out, uSecRealtime);
        this.mScreenDozeTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mInteractiveTimer.writeToParcel(out, uSecRealtime);
        this.mPowerSaveModeEnabledTimer.writeToParcel(out, uSecRealtime);
        out.writeLong(this.mLongestLightIdleTimeMs);
        out.writeLong(this.mLongestFullIdleTimeMs);
        this.mDeviceIdleModeLightTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceIdleModeFullTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceLightIdlingTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceIdlingTimer.writeToParcel(out, uSecRealtime);
        this.mPhoneOnTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mPhoneSignalScanningTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i].writeToParcel(out);
            this.mNetworkPacketActivityCounters[i].writeToParcel(out);
        }
        this.mMobileRadioActiveTimer.writeToParcel(out, uSecRealtime);
        this.mMobileRadioActivePerAppTimer.writeToParcel(out, uSecRealtime);
        this.mMobileRadioActiveAdjustedTime.writeToParcel(out);
        this.mMobileRadioActiveUnknownTime.writeToParcel(out);
        this.mMobileRadioActiveUnknownCount.writeToParcel(out);
        this.mWifiMulticastWakelockTimer.writeToParcel(out, uSecRealtime);
        this.mWifiOnTimer.writeToParcel(out, uSecRealtime);
        this.mGlobalWifiRunningTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mWifiActiveTimer.writeToParcel(out, uSecRealtime);
        this.mWifiActivity.writeToParcel(out, 0);
        for (i = 0; i < this.mGpsSignalQualityTimer.length; ++i) {
            this.mGpsSignalQualityTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mBluetoothActivity.writeToParcel(out, 0);
        this.mModemActivity.writeToParcel(out, 0);
        out.writeInt(this.mHasWifiReporting ? 1 : 0);
        out.writeInt(this.mHasBluetoothReporting ? 1 : 0);
        out.writeInt(this.mHasModemReporting ? 1 : 0);
        out.writeInt(this.mNumConnectivityChange);
        this.mFlashlightOnTimer.writeToParcel(out, uSecRealtime);
        this.mCameraOnTimer.writeToParcel(out, uSecRealtime);
        this.mBluetoothScanTimer.writeToParcel(out, uSecRealtime);
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargePlugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.mCurrentBatteryLevel);
        out.writeInt(this.mLowDischargeAmountSinceCharge);
        out.writeInt(this.mHighDischargeAmountSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOn);
        out.writeInt(this.mDischargeAmountScreenOnSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOff);
        out.writeInt(this.mDischargeAmountScreenOffSinceCharge);
        out.writeInt(this.mDischargeAmountScreenDoze);
        out.writeInt(this.mDischargeAmountScreenDozeSinceCharge);
        this.mDischargeStepTracker.writeToParcel(out);
        this.mChargeStepTracker.writeToParcel(out);
        this.mDischargeCounter.writeToParcel(out);
        this.mDischargeScreenOffCounter.writeToParcel(out);
        this.mDischargeScreenDozeCounter.writeToParcel(out);
        this.mDischargeLightDozeCounter.writeToParcel(out);
        this.mDischargeDeepDozeCounter.writeToParcel(out);
        out.writeLong(this.mLastWriteTimeMs);
        out.writeLong(this.mBatteryTimeToFullSeconds);
        MeasuredEnergyStats.Config.writeToParcel(this.mMeasuredEnergyStatsConfig, out);
        if (this.mGlobalMeasuredEnergyStats != null) {
            out.writeInt(1);
            this.mGlobalMeasuredEnergyStats.writeToParcel(out);
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.mRpmStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mRpmStats.entrySet()) {
            rpmt = ent.getValue();
            if (rpmt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                rpmt.writeToParcel(out, uSecRealtime);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mScreenOffRpmStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mScreenOffRpmStats.entrySet()) {
            rpmt = ent.getValue();
            if (rpmt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                rpmt.writeToParcel(out, uSecRealtime);
                continue;
            }
            out.writeInt(0);
        }
        if (inclUids) {
            out.writeInt(this.mKernelWakelockStats.size());
            for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer kwlt = ent.getValue();
                if (kwlt != null) {
                    out.writeInt(1);
                    out.writeString(ent.getKey());
                    kwlt.writeToParcel(out, uSecRealtime);
                    continue;
                }
                out.writeInt(0);
            }
            out.writeInt(this.mWakeupReasonStats.size());
            for (Map.Entry<String, SamplingTimer> ent : this.mWakeupReasonStats.entrySet()) {
                SamplingTimer timer = ent.getValue();
                if (timer != null) {
                    out.writeInt(1);
                    out.writeString(ent.getKey());
                    timer.writeToParcel(out, uSecRealtime);
                    continue;
                }
                out.writeInt(0);
            }
        } else {
            out.writeInt(0);
            out.writeInt(0);
        }
        out.writeInt(this.mKernelMemoryStats.size());
        for (int i2 = 0; i2 < this.mKernelMemoryStats.size(); ++i2) {
            SamplingTimer kmt = this.mKernelMemoryStats.valueAt(i2);
            if (kmt != null) {
                out.writeInt(1);
                out.writeLong(this.mKernelMemoryStats.keyAt(i2));
                kmt.writeToParcel(out, uSecRealtime);
                continue;
            }
            out.writeInt(0);
        }
        if (inclUids) {
            int size = this.mUidStats.size();
            out.writeInt(size);
            for (int i3 = 0; i3 < size; ++i3) {
                out.writeInt(this.mUidStats.keyAt(i3));
                Uid uid = this.mUidStats.valueAt(i3);
                uid.writeToParcelLocked(out, uSecUptime, uSecRealtime);
            }
        } else {
            out.writeInt(0);
        }
        LongSamplingCounterArray.writeToParcel(out, this.mBinderThreadCpuTimesUs);
    }

    private void writeCpuSpeedCountersToParcel(Parcel out, LongSamplingCounter[][] counters) {
        if (counters == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(1);
        out.writeInt(counters.length);
        for (int i = 0; i < counters.length; ++i) {
            LongSamplingCounter[] counterArray = counters[i];
            if (counterArray == null) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(1);
            out.writeInt(counterArray.length);
            for (int j = 0; j < counterArray.length; ++j) {
                LongSamplingCounter c = counterArray[j];
                if (c != null) {
                    out.writeInt(1);
                    c.writeToParcel(out);
                    continue;
                }
                out.writeInt(0);
            }
        }
    }

    private LongSamplingCounter[][] readCpuSpeedCountersFromParcel(Parcel in) {
        LongSamplingCounter[][] counters;
        if (in.readInt() != 0) {
            int numCpuClusters = in.readInt();
            if (this.mPowerProfile != null && this.mPowerProfile.getNumCpuClusters() != numCpuClusters) {
                throw new ParcelFormatException("Incompatible number of cpu clusters");
            }
            counters = new LongSamplingCounter[numCpuClusters][];
            for (int cluster = 0; cluster < numCpuClusters; ++cluster) {
                if (in.readInt() != 0) {
                    int numSpeeds = in.readInt();
                    if (this.mPowerProfile != null && this.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster) != numSpeeds) {
                        throw new ParcelFormatException("Incompatible number of cpu speeds");
                    }
                    LongSamplingCounter[] cpuSpeeds = new LongSamplingCounter[numSpeeds];
                    counters[cluster] = cpuSpeeds;
                    for (int speed = 0; speed < numSpeeds; ++speed) {
                        if (in.readInt() == 0) continue;
                        cpuSpeeds[speed] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
                    }
                    continue;
                }
                counters[cluster] = null;
            }
        } else {
            counters = null;
        }
        return counters;
    }

    @Override
    @GuardedBy(value={"this"})
    public void prepareForDumpLocked() {
        this.pullPendingStateUpdatesLocked();
        this.getStartClockTime();
        this.updateSystemServiceCallStats();
    }

    @Override
    @GuardedBy(value={"this"})
    public void dumpLocked(Context context, PrintWriter pw, int flags, int reqUid, long histStart) {
        super.dumpLocked(context, pw, flags, reqUid, histStart);
        pw.print("Per process state tracking available: ");
        pw.println(this.trackPerProcStateCpuTimes());
        pw.print("Total cpu time reads: ");
        pw.println(this.mNumSingleUidCpuTimeReads);
        pw.print("Batching Duration (min): ");
        pw.println((this.mClock.uptimeMillis() - this.mCpuTimeReadsTrackingStartTimeMs) / 60000L);
        pw.print("All UID cpu time reads since the later of device start or stats reset: ");
        pw.println(this.mNumAllUidCpuTimeReads);
        pw.print("UIDs removed since the later of device start or stats reset: ");
        pw.println(this.mNumUidsRemoved);
        pw.println("Currently mapped isolated uids:");
        int numIsolatedUids = this.mIsolatedUids.size();
        for (int i = 0; i < numIsolatedUids; ++i) {
            int isolatedUid = this.mIsolatedUids.keyAt(i);
            int ownerUid = this.mIsolatedUids.valueAt(i);
            int refCount = this.mIsolatedUidRefCounts.get(isolatedUid);
            pw.println("  " + isolatedUid + "->" + ownerUid + " (ref count = " + refCount + ")");
        }
        pw.println();
        this.dumpConstantsLocked(pw);
        pw.println();
        this.dumpMeasuredEnergyStatsLocked(pw);
    }

    @VisibleForTesting
    public class Constants
    extends ContentObserver {
        public static final String KEY_TRACK_CPU_ACTIVE_CLUSTER_TIME = "track_cpu_active_cluster_time";
        public static final String KEY_PROC_STATE_CPU_TIMES_READ_DELAY_MS = "proc_state_cpu_times_read_delay_ms";
        public static final String KEY_KERNEL_UID_READERS_THROTTLE_TIME = "kernel_uid_readers_throttle_time";
        public static final String KEY_UID_REMOVE_DELAY_MS = "uid_remove_delay_ms";
        public static final String KEY_EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS = "external_stats_collection_rate_limit_ms";
        public static final String KEY_BATTERY_LEVEL_COLLECTION_DELAY_MS = "battery_level_collection_delay_ms";
        public static final String KEY_PROC_STATE_CHANGE_COLLECTION_DELAY_MS = "procstate_change_collection_delay_ms";
        public static final String KEY_MAX_HISTORY_FILES = "max_history_files";
        public static final String KEY_MAX_HISTORY_BUFFER_KB = "max_history_buffer_kb";
        public static final String KEY_BATTERY_CHARGED_DELAY_MS = "battery_charged_delay_ms";
        private static final boolean DEFAULT_TRACK_CPU_ACTIVE_CLUSTER_TIME = true;
        private static final long DEFAULT_KERNEL_UID_READERS_THROTTLE_TIME = 1000L;
        private static final long DEFAULT_UID_REMOVE_DELAY_MS = 300000L;
        private static final long DEFAULT_EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS = 600000L;
        private static final long DEFAULT_BATTERY_LEVEL_COLLECTION_DELAY_MS = 300000L;
        private static final long DEFAULT_PROC_STATE_CHANGE_COLLECTION_DELAY_MS = 60000L;
        private static final int DEFAULT_MAX_HISTORY_FILES = 32;
        private static final int DEFAULT_MAX_HISTORY_BUFFER_KB = 128;
        private static final int DEFAULT_MAX_HISTORY_FILES_LOW_RAM_DEVICE = 64;
        private static final int DEFAULT_MAX_HISTORY_BUFFER_LOW_RAM_DEVICE_KB = 64;
        private static final int DEFAULT_BATTERY_CHARGED_DELAY_MS = 900000;
        public boolean TRACK_CPU_ACTIVE_CLUSTER_TIME;
        public long KERNEL_UID_READERS_THROTTLE_TIME;
        public long UID_REMOVE_DELAY_MS;
        public long EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS;
        public long BATTERY_LEVEL_COLLECTION_DELAY_MS;
        public long PROC_STATE_CHANGE_COLLECTION_DELAY_MS;
        public int MAX_HISTORY_FILES;
        public int MAX_HISTORY_BUFFER;
        public int BATTERY_CHARGED_DELAY_MS;
        private ContentResolver mResolver;
        private final KeyValueListParser mParser;

        public Constants(Handler handler) {
            super(handler);
            this.TRACK_CPU_ACTIVE_CLUSTER_TIME = true;
            this.UID_REMOVE_DELAY_MS = 300000L;
            this.EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS = 600000L;
            this.BATTERY_LEVEL_COLLECTION_DELAY_MS = 300000L;
            this.PROC_STATE_CHANGE_COLLECTION_DELAY_MS = 60000L;
            this.BATTERY_CHARGED_DELAY_MS = 900000;
            this.mParser = new KeyValueListParser(',');
            if (ActivityManager.isLowRamDeviceStatic()) {
                this.MAX_HISTORY_FILES = 64;
                this.MAX_HISTORY_BUFFER = 65536;
            } else {
                this.MAX_HISTORY_FILES = 32;
                this.MAX_HISTORY_BUFFER = 131072;
            }
        }

        public void startObserving(ContentResolver resolver) {
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("battery_stats_constants"), false, this);
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("battery_charging_state_update_delay"), false, this);
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (uri.equals(Settings.Global.getUriFor("battery_charging_state_update_delay"))) {
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                synchronized (batteryStatsImpl) {
                    this.updateBatteryChargedDelayMsLocked();
                }
                return;
            }
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConstants() {
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            synchronized (batteryStatsImpl) {
                try {
                    this.mParser.setString(Settings.Global.getString(this.mResolver, "battery_stats_constants"));
                }
                catch (IllegalArgumentException e) {
                    Slog.e(BatteryStatsImpl.TAG, "Bad batterystats settings", e);
                }
                this.TRACK_CPU_ACTIVE_CLUSTER_TIME = this.mParser.getBoolean(KEY_TRACK_CPU_ACTIVE_CLUSTER_TIME, true);
                this.updateKernelUidReadersThrottleTime(this.KERNEL_UID_READERS_THROTTLE_TIME, this.mParser.getLong(KEY_KERNEL_UID_READERS_THROTTLE_TIME, 1000L));
                this.updateUidRemoveDelay(this.mParser.getLong(KEY_UID_REMOVE_DELAY_MS, 300000L));
                this.EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS = this.mParser.getLong(KEY_EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS, 600000L);
                this.BATTERY_LEVEL_COLLECTION_DELAY_MS = this.mParser.getLong(KEY_BATTERY_LEVEL_COLLECTION_DELAY_MS, 300000L);
                this.PROC_STATE_CHANGE_COLLECTION_DELAY_MS = this.mParser.getLong(KEY_PROC_STATE_CHANGE_COLLECTION_DELAY_MS, 60000L);
                this.MAX_HISTORY_FILES = this.mParser.getInt(KEY_MAX_HISTORY_FILES, ActivityManager.isLowRamDeviceStatic() ? 64 : 32);
                this.MAX_HISTORY_BUFFER = this.mParser.getInt(KEY_MAX_HISTORY_BUFFER_KB, ActivityManager.isLowRamDeviceStatic() ? 64 : 128) * 1024;
                this.updateBatteryChargedDelayMsLocked();
            }
        }

        private void updateBatteryChargedDelayMsLocked() {
            int delay = Settings.Global.getInt(this.mResolver, "battery_charging_state_update_delay", -1);
            int n = this.BATTERY_CHARGED_DELAY_MS = delay >= 0 ? delay : this.mParser.getInt(KEY_BATTERY_CHARGED_DELAY_MS, 900000);
            if (BatteryStatsImpl.this.mHandler.hasCallbacks(BatteryStatsImpl.this.mDeferSetCharging)) {
                BatteryStatsImpl.this.mHandler.removeCallbacks(BatteryStatsImpl.this.mDeferSetCharging);
                BatteryStatsImpl.this.mHandler.postDelayed(BatteryStatsImpl.this.mDeferSetCharging, this.BATTERY_CHARGED_DELAY_MS);
            }
        }

        private void updateKernelUidReadersThrottleTime(long oldTimeMs, long newTimeMs) {
            this.KERNEL_UID_READERS_THROTTLE_TIME = newTimeMs;
            if (oldTimeMs != newTimeMs) {
                BatteryStatsImpl.this.mCpuUidUserSysTimeReader.setThrottle(this.KERNEL_UID_READERS_THROTTLE_TIME);
                BatteryStatsImpl.this.mCpuUidFreqTimeReader.setThrottle(this.KERNEL_UID_READERS_THROTTLE_TIME);
                BatteryStatsImpl.this.mCpuUidActiveTimeReader.setThrottle(this.KERNEL_UID_READERS_THROTTLE_TIME);
                BatteryStatsImpl.this.mCpuUidClusterTimeReader.setThrottle(this.KERNEL_UID_READERS_THROTTLE_TIME);
            }
        }

        @GuardedBy(value={"BatteryStatsImpl.this"})
        private void updateUidRemoveDelay(long newTimeMs) {
            this.UID_REMOVE_DELAY_MS = newTimeMs;
            BatteryStatsImpl.this.clearPendingRemovedUidsLocked();
        }

        public void dumpLocked(PrintWriter pw) {
            pw.print(KEY_TRACK_CPU_ACTIVE_CLUSTER_TIME);
            pw.print("=");
            pw.println(this.TRACK_CPU_ACTIVE_CLUSTER_TIME);
            pw.print(KEY_KERNEL_UID_READERS_THROTTLE_TIME);
            pw.print("=");
            pw.println(this.KERNEL_UID_READERS_THROTTLE_TIME);
            pw.print(KEY_EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS);
            pw.print("=");
            pw.println(this.EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS);
            pw.print(KEY_BATTERY_LEVEL_COLLECTION_DELAY_MS);
            pw.print("=");
            pw.println(this.BATTERY_LEVEL_COLLECTION_DELAY_MS);
            pw.print(KEY_PROC_STATE_CHANGE_COLLECTION_DELAY_MS);
            pw.print("=");
            pw.println(this.PROC_STATE_CHANGE_COLLECTION_DELAY_MS);
            pw.print(KEY_MAX_HISTORY_FILES);
            pw.print("=");
            pw.println(this.MAX_HISTORY_FILES);
            pw.print(KEY_MAX_HISTORY_BUFFER_KB);
            pw.print("=");
            pw.println(this.MAX_HISTORY_BUFFER / 1024);
            pw.print(KEY_BATTERY_CHARGED_DELAY_MS);
            pw.print("=");
            pw.println(this.BATTERY_CHARGED_DELAY_MS);
        }
    }

    @VisibleForTesting
    public static class CpuDeltaPowerAccumulator {
        public final double[] totalClusterChargesMah;
        public final ArrayMap<Uid, double[]> perUidCpuClusterChargesMah;
        private final CpuPowerCalculator mCalculator;
        private Uid mCachedUid = null;
        private double[] mUidClusterCache = null;

        CpuDeltaPowerAccumulator(CpuPowerCalculator calculator, int nClusters) {
            this.mCalculator = calculator;
            this.totalClusterChargesMah = new double[nClusters];
            this.perUidCpuClusterChargesMah = new ArrayMap();
        }

        public void addCpuClusterDurationsMs(Uid uid, long[] durationsMs) {
            double[] uidChargesMah = this.getOrCreateUidCpuClusterCharges(uid);
            int cluster = 0;
            while (cluster < durationsMs.length) {
                double estimatedDeltaMah = this.mCalculator.calculatePerCpuClusterPowerMah(cluster, durationsMs[cluster]);
                int n = cluster;
                uidChargesMah[n] = uidChargesMah[n] + estimatedDeltaMah;
                int n2 = cluster++;
                this.totalClusterChargesMah[n2] = this.totalClusterChargesMah[n2] + estimatedDeltaMah;
            }
        }

        public void addCpuClusterSpeedDurationsMs(Uid uid, int cluster, int speed, long durationsMs) {
            double[] uidChargesMah = this.getOrCreateUidCpuClusterCharges(uid);
            double estimatedDeltaMah = this.mCalculator.calculatePerCpuFreqPowerMah(cluster, speed, durationsMs);
            int n = cluster;
            uidChargesMah[n] = uidChargesMah[n] + estimatedDeltaMah;
            int n2 = cluster;
            this.totalClusterChargesMah[n2] = this.totalClusterChargesMah[n2] + estimatedDeltaMah;
        }

        private double[] getOrCreateUidCpuClusterCharges(Uid uid) {
            if (uid == this.mCachedUid) {
                return this.mUidClusterCache;
            }
            double[] uidChargesMah = this.perUidCpuClusterChargesMah.get(uid);
            if (uidChargesMah == null) {
                uidChargesMah = new double[this.totalClusterChargesMah.length];
                this.perUidCpuClusterChargesMah.put(uid, uidChargesMah);
            }
            this.mCachedUid = uid;
            this.mUidClusterCache = uidChargesMah;
            return uidChargesMah;
        }
    }

    private class BluetoothActivityInfoCache {
        long idleTimeMs;
        long rxTimeMs;
        long txTimeMs;
        long energy;
        SparseLongArray uidRxBytes = new SparseLongArray();
        SparseLongArray uidTxBytes = new SparseLongArray();

        private BluetoothActivityInfoCache() {
        }

        void set(BluetoothActivityEnergyInfo info) {
            this.idleTimeMs = info.getControllerIdleTimeMillis();
            this.rxTimeMs = info.getControllerRxTimeMillis();
            this.txTimeMs = info.getControllerTxTimeMillis();
            this.energy = info.getControllerEnergyUsed();
            if (!info.getUidTraffic().isEmpty()) {
                for (UidTraffic traffic : info.getUidTraffic()) {
                    this.uidRxBytes.incrementValue(traffic.getUid(), traffic.getRxBytes());
                    this.uidTxBytes.incrementValue(traffic.getUid(), traffic.getTxBytes());
                }
            }
        }

        void reset() {
            this.idleTimeMs = 0L;
            this.rxTimeMs = 0L;
            this.txTimeMs = 0L;
            this.energy = 0L;
            this.uidRxBytes.clear();
            this.uidTxBytes.clear();
        }
    }

    public static class Uid
    extends BatteryStats.Uid {
        protected BatteryStatsImpl mBsi;
        final int mUid;
        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public final TimeBase mOnBatteryBackgroundTimeBase;
        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public final TimeBase mOnBatteryScreenOffBackgroundTimeBase;
        boolean mWifiRunning;
        StopwatchTimer mWifiRunningTimer;
        boolean mFullWifiLockOut;
        StopwatchTimer mFullWifiLockTimer;
        boolean mWifiScanStarted;
        DualTimer mWifiScanTimer;
        static final int NO_BATCHED_SCAN_STARTED = -1;
        int mWifiBatchedScanBinStarted = -1;
        StopwatchTimer[] mWifiBatchedScanTimer;
        int mWifiMulticastWakelockCount;
        StopwatchTimer mWifiMulticastTimer;
        StopwatchTimer mAudioTurnedOnTimer;
        StopwatchTimer mVideoTurnedOnTimer;
        StopwatchTimer mFlashlightTurnedOnTimer;
        StopwatchTimer mCameraTurnedOnTimer;
        StopwatchTimer mForegroundActivityTimer;
        StopwatchTimer mForegroundServiceTimer;
        DualTimer mAggregatedPartialWakelockTimer;
        DualTimer mBluetoothScanTimer;
        DualTimer mBluetoothUnoptimizedScanTimer;
        Counter mBluetoothScanResultCounter;
        Counter mBluetoothScanResultBgCounter;
        int mProcessState = 7;
        StopwatchTimer[] mProcessStateTimer;
        boolean mInForegroundService = false;
        BatchTimer mVibratorOnTimer;
        Counter[] mUserActivityCounters;
        LongSamplingCounter[] mNetworkByteActivityCounters;
        LongSamplingCounter[] mNetworkPacketActivityCounters;
        TimeMultiStateCounter mMobileRadioActiveTime;
        LongSamplingCounter mMobileRadioActiveCount;
        private LongSamplingCounter mMobileRadioApWakeupCount;
        private LongSamplingCounter mWifiRadioApWakeupCount;
        private ControllerActivityCounterImpl mWifiControllerActivity;
        private ControllerActivityCounterImpl mBluetoothControllerActivity;
        private ControllerActivityCounterImpl mModemControllerActivity;
        long mLastStepUserTimeMs;
        long mLastStepSystemTimeMs;
        long mCurStepUserTimeMs;
        long mCurStepSystemTimeMs;
        LongSamplingCounter mUserCpuTime;
        LongSamplingCounter mSystemCpuTime;
        LongSamplingCounter[][] mCpuClusterSpeedTimesUs;
        TimeMultiStateCounter mCpuActiveTimeMs;
        LongSamplingCounterArray mCpuFreqTimeMs;
        LongSamplingCounterArray mScreenOffCpuFreqTimeMs;
        LongSamplingCounterArray mCpuClusterTimesMs;
        TimeInFreqMultiStateCounter mProcStateTimeMs;
        TimeInFreqMultiStateCounter mProcStateScreenOffTimeMs;
        SparseArray<ChildUid> mChildUids;
        final OverflowArrayMap<Wakelock> mWakelockStats;
        final OverflowArrayMap<DualTimer> mSyncStats;
        final OverflowArrayMap<DualTimer> mJobStats;
        final ArrayMap<String, SparseIntArray> mJobCompletions = new ArrayMap();
        Counter mJobsDeferredEventCount;
        Counter mJobsDeferredCount;
        LongSamplingCounter mJobsFreshnessTimeMs;
        final Counter[] mJobsFreshnessBuckets;
        final SparseArray<Sensor> mSensorStats = new SparseArray();
        final ArrayMap<String, Proc> mProcessStats = new ArrayMap();
        final ArrayMap<String, Pkg> mPackageStats = new ArrayMap();
        final SparseArray<BatteryStats.Uid.Pid> mPids = new SparseArray();
        private long mBinderCallCount;
        private final ArraySet<BinderCallStats> mBinderCallStats = new ArraySet();
        private MeasuredEnergyStats mUidMeasuredEnergyStats;
        private long mSystemServiceTimeUs;
        private double mProportionalSystemServiceUsage;
        private static BinderCallStats sTempBinderCallStats = new BinderCallStats();

        public Uid(BatteryStatsImpl bsi, int uid) {
            this(bsi, uid, bsi.mClock.elapsedRealtime(), bsi.mClock.uptimeMillis());
        }

        public Uid(BatteryStatsImpl bsi, int uid, long elapsedRealtimeMs, long uptimeMs) {
            this.mBsi = bsi;
            this.mUid = uid;
            this.mOnBatteryBackgroundTimeBase = new TimeBase(false);
            this.mOnBatteryBackgroundTimeBase.init(uptimeMs * 1000L, elapsedRealtimeMs * 1000L);
            this.mOnBatteryScreenOffBackgroundTimeBase = new TimeBase(false);
            this.mOnBatteryScreenOffBackgroundTimeBase.init(uptimeMs * 1000L, elapsedRealtimeMs * 1000L);
            this.mUserCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mSystemCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mCpuClusterTimesMs = new LongSamplingCounterArray(this.mBsi.mOnBatteryTimeBase);
            BatteryStatsImpl batteryStatsImpl = this.mBsi;
            Objects.requireNonNull(batteryStatsImpl);
            this.mWakelockStats = new OverflowArrayMap<Wakelock>(batteryStatsImpl, uid){
                {
                    BatteryStatsImpl batteryStatsImpl = x0;
                    Objects.requireNonNull(batteryStatsImpl);
                    super(uid);
                }

                @Override
                public Wakelock instantiateObject() {
                    return new Wakelock(mBsi, this);
                }
            };
            BatteryStatsImpl batteryStatsImpl2 = this.mBsi;
            Objects.requireNonNull(batteryStatsImpl2);
            this.mSyncStats = new OverflowArrayMap<DualTimer>(batteryStatsImpl2, uid){
                {
                    BatteryStatsImpl batteryStatsImpl = x0;
                    Objects.requireNonNull(batteryStatsImpl);
                    super(uid);
                }

                @Override
                public DualTimer instantiateObject() {
                    return new DualTimer(mBsi.mClock, this, 13, null, mBsi.mOnBatteryTimeBase, mOnBatteryBackgroundTimeBase);
                }
            };
            BatteryStatsImpl batteryStatsImpl3 = this.mBsi;
            Objects.requireNonNull(batteryStatsImpl3);
            this.mJobStats = new OverflowArrayMap<DualTimer>(batteryStatsImpl3, uid){
                {
                    BatteryStatsImpl batteryStatsImpl = x0;
                    Objects.requireNonNull(batteryStatsImpl);
                    super(uid);
                }

                @Override
                public DualTimer instantiateObject() {
                    return new DualTimer(mBsi.mClock, this, 14, null, mBsi.mOnBatteryTimeBase, mOnBatteryBackgroundTimeBase);
                }
            };
            this.mWifiRunningTimer = new StopwatchTimer(this.mBsi.mClock, this, 4, this.mBsi.mWifiRunningTimers, this.mBsi.mOnBatteryTimeBase);
            this.mFullWifiLockTimer = new StopwatchTimer(this.mBsi.mClock, this, 5, this.mBsi.mFullWifiLockTimers, this.mBsi.mOnBatteryTimeBase);
            this.mWifiScanTimer = new DualTimer(this.mBsi.mClock, this, 6, this.mBsi.mWifiScanTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
            this.mWifiBatchedScanTimer = new StopwatchTimer[5];
            this.mWifiMulticastTimer = new StopwatchTimer(this.mBsi.mClock, this, 7, this.mBsi.mWifiMulticastTimers, this.mBsi.mOnBatteryTimeBase);
            this.mProcessStateTimer = new StopwatchTimer[7];
            this.mJobsDeferredEventCount = new Counter(this.mBsi.mOnBatteryTimeBase);
            this.mJobsDeferredCount = new Counter(this.mBsi.mOnBatteryTimeBase);
            this.mJobsFreshnessTimeMs = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mJobsFreshnessBuckets = new Counter[BatteryStats.JOB_FRESHNESS_BUCKETS.length];
        }

        @GuardedBy(value={"mBsi"})
        @VisibleForTesting
        public void setProcessStateForTest(int procState, long elapsedTimeMs) {
            MeasuredEnergyStats energyStats;
            ControllerActivityCounterImpl bluetoothControllerActivity;
            this.mProcessState = procState;
            this.getProcStateTimeCounter(elapsedTimeMs).setState(procState, elapsedTimeMs);
            this.getProcStateScreenOffTimeCounter(elapsedTimeMs).setState(procState, elapsedTimeMs);
            int batteryConsumerProcessState = BatteryStats.mapUidProcessStateToBatteryConsumerProcessState(procState);
            this.getCpuActiveTimeCounter().setState(batteryConsumerProcessState, elapsedTimeMs);
            this.getMobileRadioActiveTimeCounter().setState(batteryConsumerProcessState, elapsedTimeMs);
            ControllerActivityCounterImpl wifiControllerActivity = this.getWifiControllerActivity();
            if (wifiControllerActivity != null) {
                wifiControllerActivity.setState(batteryConsumerProcessState, elapsedTimeMs);
            }
            if ((bluetoothControllerActivity = this.getBluetoothControllerActivity()) != null) {
                bluetoothControllerActivity.setState(batteryConsumerProcessState, elapsedTimeMs);
            }
            if ((energyStats = this.getOrCreateMeasuredEnergyStatsIfSupportedLocked()) != null) {
                energyStats.setState(batteryConsumerProcessState, elapsedTimeMs);
            }
        }

        @Override
        public long[] getCpuFreqTimes(int which) {
            return this.nullIfAllZeros(this.mCpuFreqTimeMs, which);
        }

        @Override
        public long[] getScreenOffCpuFreqTimes(int which) {
            return this.nullIfAllZeros(this.mScreenOffCpuFreqTimeMs, which);
        }

        private TimeMultiStateCounter getCpuActiveTimeCounter() {
            if (this.mCpuActiveTimeMs == null) {
                long timestampMs = this.mBsi.mClock.elapsedRealtime();
                this.mCpuActiveTimeMs = new TimeMultiStateCounter(this.mBsi.mOnBatteryTimeBase, 5, timestampMs);
                this.mCpuActiveTimeMs.setState(BatteryStats.mapUidProcessStateToBatteryConsumerProcessState(this.mProcessState), timestampMs);
            }
            return this.mCpuActiveTimeMs;
        }

        @Override
        public long getCpuActiveTime() {
            if (this.mCpuActiveTimeMs == null) {
                return 0L;
            }
            long activeTime = 0L;
            for (int procState = 0; procState < 5; ++procState) {
                activeTime += this.mCpuActiveTimeMs.getCountForProcessState(procState);
            }
            return activeTime;
        }

        @Override
        public long getCpuActiveTime(int procState) {
            if (this.mCpuActiveTimeMs == null || procState < 0 || procState >= 5) {
                return 0L;
            }
            return this.mCpuActiveTimeMs.getCountForProcessState(procState);
        }

        @Override
        public long[] getCpuClusterTimes() {
            return this.nullIfAllZeros(this.mCpuClusterTimesMs, 0);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public boolean getCpuFreqTimes(long[] timesInFreqMs, int procState) {
            if (procState < 0 || procState >= 7) {
                return false;
            }
            if (this.mProcStateTimeMs == null) {
                return false;
            }
            if (!this.mBsi.mPerProcStateCpuTimesAvailable) {
                this.mProcStateTimeMs = null;
                return false;
            }
            return this.mProcStateTimeMs.getCountsLocked(timesInFreqMs, procState);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public boolean getScreenOffCpuFreqTimes(long[] timesInFreqMs, int procState) {
            if (procState < 0 || procState >= 7) {
                return false;
            }
            if (this.mProcStateScreenOffTimeMs == null) {
                return false;
            }
            if (!this.mBsi.mPerProcStateCpuTimesAvailable) {
                this.mProcStateScreenOffTimeMs = null;
                return false;
            }
            return this.mProcStateScreenOffTimeMs.getCountsLocked(timesInFreqMs, procState);
        }

        public long getBinderCallCount() {
            return this.mBinderCallCount;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
        public ArraySet<BinderCallStats> getBinderCallStats() {
            return this.mBinderCallStats;
        }

        @Override
        public double getProportionalSystemServiceUsage() {
            return this.mProportionalSystemServiceUsage;
        }

        @GuardedBy(value={"mBsi"})
        public void addIsolatedUid(int isolatedUid) {
            if (this.mChildUids == null) {
                this.mChildUids = new SparseArray();
            } else if (this.mChildUids.indexOfKey(isolatedUid) >= 0) {
                return;
            }
            this.mChildUids.put(isolatedUid, new ChildUid());
        }

        public void removeIsolatedUid(int isolatedUid) {
            int idx;
            int n = idx = this.mChildUids == null ? -1 : this.mChildUids.indexOfKey(isolatedUid);
            if (idx < 0) {
                return;
            }
            this.mChildUids.remove(idx);
        }

        @GuardedBy(value={"mBsi"})
        ChildUid getChildUid(int childUid) {
            return this.mChildUids == null ? null : this.mChildUids.get(childUid);
        }

        private long[] nullIfAllZeros(LongSamplingCounterArray cpuTimesMs, int which) {
            if (cpuTimesMs == null) {
                return null;
            }
            long[] counts = cpuTimesMs.getCountsLocked(which);
            if (counts == null) {
                return null;
            }
            for (int i = counts.length - 1; i >= 0; --i) {
                if (counts[i] == 0L) continue;
                return counts;
            }
            return null;
        }

        @GuardedBy(value={"mBsi"})
        private void ensureMultiStateCounters(long timestampMs) {
            if (this.mProcStateTimeMs != null) {
                return;
            }
            this.mProcStateTimeMs = new TimeInFreqMultiStateCounter(this.mBsi.mOnBatteryTimeBase, 8, this.mBsi.getCpuFreqCount(), timestampMs);
            this.mProcStateScreenOffTimeMs = new TimeInFreqMultiStateCounter(this.mBsi.mOnBatteryScreenOffTimeBase, 8, this.mBsi.getCpuFreqCount(), timestampMs);
        }

        @GuardedBy(value={"mBsi"})
        private TimeInFreqMultiStateCounter getProcStateTimeCounter(long timestampMs) {
            this.ensureMultiStateCounters(timestampMs);
            return this.mProcStateTimeMs;
        }

        @GuardedBy(value={"mBsi"})
        private TimeInFreqMultiStateCounter getProcStateScreenOffTimeCounter(long timestampMs) {
            this.ensureMultiStateCounters(timestampMs);
            return this.mProcStateScreenOffTimeMs;
        }

        @Override
        public Timer getAggregatedPartialWakelockTimer() {
            return this.mAggregatedPartialWakelockTimer;
        }

        @Override
        @UnsupportedAppUsage
        public ArrayMap<String, ? extends BatteryStats.Uid.Wakelock> getWakelockStats() {
            return this.mWakelockStats.getMap();
        }

        @Override
        public Timer getMulticastWakelockStats() {
            return this.mWifiMulticastTimer;
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Timer> getSyncStats() {
            return this.mSyncStats.getMap();
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Timer> getJobStats() {
            return this.mJobStats.getMap();
        }

        @Override
        public ArrayMap<String, SparseIntArray> getJobCompletionStats() {
            return this.mJobCompletions;
        }

        @Override
        @UnsupportedAppUsage
        public SparseArray<? extends BatteryStats.Uid.Sensor> getSensorStats() {
            return this.mSensorStats;
        }

        @Override
        @UnsupportedAppUsage
        public ArrayMap<String, ? extends BatteryStats.Uid.Proc> getProcessStats() {
            return this.mProcessStats;
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Uid.Pkg> getPackageStats() {
            return this.mPackageStats;
        }

        @Override
        @UnsupportedAppUsage
        public int getUid() {
            return this.mUid;
        }

        @Override
        public void noteWifiRunningLocked(long elapsedRealtimeMs) {
            if (!this.mWifiRunning) {
                this.mWifiRunning = true;
                if (this.mWifiRunningTimer == null) {
                    this.mWifiRunningTimer = new StopwatchTimer(this.mBsi.mClock, this, 4, this.mBsi.mWifiRunningTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mWifiRunningTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiRunning) {
                this.mWifiRunning = false;
                this.mWifiRunningTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteFullWifiLockAcquiredLocked(long elapsedRealtimeMs) {
            if (!this.mFullWifiLockOut) {
                this.mFullWifiLockOut = true;
                if (this.mFullWifiLockTimer == null) {
                    this.mFullWifiLockTimer = new StopwatchTimer(this.mBsi.mClock, this, 5, this.mBsi.mFullWifiLockTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mFullWifiLockTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteFullWifiLockReleasedLocked(long elapsedRealtimeMs) {
            if (this.mFullWifiLockOut) {
                this.mFullWifiLockOut = false;
                this.mFullWifiLockTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiScanStartedLocked(long elapsedRealtimeMs) {
            if (!this.mWifiScanStarted) {
                this.mWifiScanStarted = true;
                if (this.mWifiScanTimer == null) {
                    this.mWifiScanTimer = new DualTimer(this.mBsi.mClock, this, 6, this.mBsi.mWifiScanTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
                }
                this.mWifiScanTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiScanStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiScanStarted) {
                this.mWifiScanStarted = false;
                this.mWifiScanTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiBatchedScanStartedLocked(int csph, long elapsedRealtimeMs) {
            int bin;
            for (bin = 0; csph > 8 && bin < 4; csph >>= 3, ++bin) {
            }
            if (this.mWifiBatchedScanBinStarted == bin) {
                return;
            }
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(elapsedRealtimeMs);
            }
            this.mWifiBatchedScanBinStarted = bin;
            if (this.mWifiBatchedScanTimer[bin] == null) {
                this.makeWifiBatchedScanBin(bin, null);
            }
            this.mWifiBatchedScanTimer[bin].startRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void noteWifiBatchedScanStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(elapsedRealtimeMs);
                this.mWifiBatchedScanBinStarted = -1;
            }
        }

        @Override
        public void noteWifiMulticastEnabledLocked(long elapsedRealtimeMs) {
            if (this.mWifiMulticastWakelockCount == 0) {
                if (this.mWifiMulticastTimer == null) {
                    this.mWifiMulticastTimer = new StopwatchTimer(this.mBsi.mClock, this, 7, this.mBsi.mWifiMulticastTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mWifiMulticastTimer.startRunningLocked(elapsedRealtimeMs);
            }
            ++this.mWifiMulticastWakelockCount;
        }

        @Override
        public void noteWifiMulticastDisabledLocked(long elapsedRealtimeMs) {
            if (this.mWifiMulticastWakelockCount == 0) {
                return;
            }
            --this.mWifiMulticastWakelockCount;
            if (this.mWifiMulticastWakelockCount == 0) {
                this.mWifiMulticastTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public ControllerActivityCounterImpl getWifiControllerActivity() {
            return this.mWifiControllerActivity;
        }

        @Override
        public ControllerActivityCounterImpl getBluetoothControllerActivity() {
            return this.mBluetoothControllerActivity;
        }

        @Override
        public BatteryStats.ControllerActivityCounter getModemControllerActivity() {
            return this.mModemControllerActivity;
        }

        public ControllerActivityCounterImpl getOrCreateWifiControllerActivityLocked() {
            if (this.mWifiControllerActivity == null) {
                this.mWifiControllerActivity = new ControllerActivityCounterImpl(this.mBsi.mClock, this.mBsi.mOnBatteryTimeBase, 1);
            }
            return this.mWifiControllerActivity;
        }

        public ControllerActivityCounterImpl getOrCreateBluetoothControllerActivityLocked() {
            if (this.mBluetoothControllerActivity == null) {
                this.mBluetoothControllerActivity = new ControllerActivityCounterImpl(this.mBsi.mClock, this.mBsi.mOnBatteryTimeBase, 1);
            }
            return this.mBluetoothControllerActivity;
        }

        public ControllerActivityCounterImpl getOrCreateModemControllerActivityLocked() {
            if (this.mModemControllerActivity == null) {
                this.mModemControllerActivity = new ControllerActivityCounterImpl(this.mBsi.mClock, this.mBsi.mOnBatteryTimeBase, ModemActivityInfo.getNumTxPowerLevels());
            }
            return this.mModemControllerActivity;
        }

        @GuardedBy(value={"mBsi"})
        private MeasuredEnergyStats getOrCreateMeasuredEnergyStatsLocked() {
            if (this.mUidMeasuredEnergyStats == null) {
                this.mUidMeasuredEnergyStats = new MeasuredEnergyStats(this.mBsi.mMeasuredEnergyStatsConfig);
            }
            return this.mUidMeasuredEnergyStats;
        }

        @GuardedBy(value={"mBsi"})
        private MeasuredEnergyStats getOrCreateMeasuredEnergyStatsIfSupportedLocked() {
            if (this.mUidMeasuredEnergyStats == null && this.mBsi.mMeasuredEnergyStatsConfig != null) {
                this.mUidMeasuredEnergyStats = new MeasuredEnergyStats(this.mBsi.mMeasuredEnergyStatsConfig);
            }
            return this.mUidMeasuredEnergyStats;
        }

        @GuardedBy(value={"mBsi"})
        private void addChargeToStandardBucketLocked(long chargeDeltaUC, int powerBucket, long timestampMs) {
            MeasuredEnergyStats measuredEnergyStats = this.getOrCreateMeasuredEnergyStatsLocked();
            measuredEnergyStats.updateStandardBucket(powerBucket, chargeDeltaUC, timestampMs);
        }

        @GuardedBy(value={"mBsi"})
        private void addChargeToCustomBucketLocked(long chargeDeltaUC, int powerBucket) {
            this.getOrCreateMeasuredEnergyStatsLocked().updateCustomBucket(powerBucket, chargeDeltaUC, this.mBsi.mClock.elapsedRealtime());
        }

        @GuardedBy(value={"mBsi"})
        public long getMeasuredBatteryConsumptionUC(int bucket) {
            if (this.mBsi.mGlobalMeasuredEnergyStats == null || !this.mBsi.mGlobalMeasuredEnergyStats.isStandardBucketSupported(bucket)) {
                return -1L;
            }
            if (this.mUidMeasuredEnergyStats == null) {
                return 0L;
            }
            return this.mUidMeasuredEnergyStats.getAccumulatedStandardBucketCharge(bucket);
        }

        @GuardedBy(value={"mBsi"})
        public long getMeasuredBatteryConsumptionUC(int bucket, int processState) {
            if (this.mBsi.mGlobalMeasuredEnergyStats == null || !this.mBsi.mGlobalMeasuredEnergyStats.isStandardBucketSupported(bucket)) {
                return -1L;
            }
            if (this.mUidMeasuredEnergyStats == null) {
                return 0L;
            }
            return this.mUidMeasuredEnergyStats.getAccumulatedStandardBucketCharge(bucket, processState);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long[] getCustomConsumerMeasuredBatteryConsumptionUC() {
            if (this.mBsi.mGlobalMeasuredEnergyStats == null) {
                return null;
            }
            if (this.mUidMeasuredEnergyStats == null) {
                return new long[this.mBsi.mGlobalMeasuredEnergyStats.getNumberCustomPowerBuckets()];
            }
            return this.mUidMeasuredEnergyStats.getAccumulatedCustomBucketCharges();
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getBluetoothMeasuredBatteryConsumptionUC() {
            return this.getMeasuredBatteryConsumptionUC(5);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getBluetoothMeasuredBatteryConsumptionUC(int processState) {
            return this.getMeasuredBatteryConsumptionUC(5, processState);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getCpuMeasuredBatteryConsumptionUC() {
            return this.getMeasuredBatteryConsumptionUC(3);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getCpuMeasuredBatteryConsumptionUC(int processState) {
            return this.getMeasuredBatteryConsumptionUC(3, processState);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getGnssMeasuredBatteryConsumptionUC() {
            return this.getMeasuredBatteryConsumptionUC(6);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getMobileRadioMeasuredBatteryConsumptionUC() {
            return this.getMeasuredBatteryConsumptionUC(7);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getMobileRadioMeasuredBatteryConsumptionUC(int processState) {
            return this.getMeasuredBatteryConsumptionUC(7, processState);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getScreenOnMeasuredBatteryConsumptionUC() {
            return this.getMeasuredBatteryConsumptionUC(0);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getWifiMeasuredBatteryConsumptionUC() {
            return this.getMeasuredBatteryConsumptionUC(4);
        }

        @Override
        @GuardedBy(value={"mBsi"})
        public long getWifiMeasuredBatteryConsumptionUC(int processState) {
            return this.getMeasuredBatteryConsumptionUC(4, processState);
        }

        private long markProcessForegroundTimeUs(long elapsedRealtimeMs, boolean doCalc) {
            long fgTimeUs = 0L;
            StopwatchTimer fgTimer = this.mForegroundActivityTimer;
            if (fgTimer != null) {
                if (doCalc) {
                    fgTimeUs = fgTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L);
                }
                fgTimer.setMark(elapsedRealtimeMs);
            }
            long topTimeUs = 0L;
            StopwatchTimer topTimer = this.mProcessStateTimer[0];
            if (topTimer != null) {
                if (doCalc) {
                    topTimeUs = topTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L);
                }
                topTimer.setMark(elapsedRealtimeMs);
            }
            return topTimeUs < fgTimeUs ? topTimeUs : fgTimeUs;
        }

        private long markGnssTimeUs(long elapsedRealtimeMs) {
            Sensor sensor = this.mSensorStats.get(-10000);
            if (sensor == null) {
                return 0L;
            }
            DualTimer timer = sensor.mTimer;
            if (timer == null) {
                return 0L;
            }
            long gnssTimeUs = timer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L);
            timer.setMark(elapsedRealtimeMs);
            return gnssTimeUs;
        }

        public StopwatchTimer createAudioTurnedOnTimerLocked() {
            if (this.mAudioTurnedOnTimer == null) {
                this.mAudioTurnedOnTimer = new StopwatchTimer(this.mBsi.mClock, this, 15, this.mBsi.mAudioTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mAudioTurnedOnTimer;
        }

        public void noteAudioTurnedOnLocked(long elapsedRealtimeMs) {
            this.createAudioTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteAudioTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetAudioLocked(long elapsedRealtimeMs) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createVideoTurnedOnTimerLocked() {
            if (this.mVideoTurnedOnTimer == null) {
                this.mVideoTurnedOnTimer = new StopwatchTimer(this.mBsi.mClock, this, 8, this.mBsi.mVideoTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mVideoTurnedOnTimer;
        }

        public void noteVideoTurnedOnLocked(long elapsedRealtimeMs) {
            this.createVideoTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteVideoTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetVideoLocked(long elapsedRealtimeMs) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createFlashlightTurnedOnTimerLocked() {
            if (this.mFlashlightTurnedOnTimer == null) {
                this.mFlashlightTurnedOnTimer = new StopwatchTimer(this.mBsi.mClock, this, 16, this.mBsi.mFlashlightTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mFlashlightTurnedOnTimer;
        }

        public void noteFlashlightTurnedOnLocked(long elapsedRealtimeMs) {
            this.createFlashlightTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteFlashlightTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mFlashlightTurnedOnTimer != null) {
                this.mFlashlightTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetFlashlightLocked(long elapsedRealtimeMs) {
            if (this.mFlashlightTurnedOnTimer != null) {
                this.mFlashlightTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createCameraTurnedOnTimerLocked() {
            if (this.mCameraTurnedOnTimer == null) {
                this.mCameraTurnedOnTimer = new StopwatchTimer(this.mBsi.mClock, this, 17, this.mBsi.mCameraTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mCameraTurnedOnTimer;
        }

        public void noteCameraTurnedOnLocked(long elapsedRealtimeMs) {
            this.createCameraTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteCameraTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mCameraTurnedOnTimer != null) {
                this.mCameraTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetCameraLocked(long elapsedRealtimeMs) {
            if (this.mCameraTurnedOnTimer != null) {
                this.mCameraTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createForegroundActivityTimerLocked() {
            if (this.mForegroundActivityTimer == null) {
                this.mForegroundActivityTimer = new StopwatchTimer(this.mBsi.mClock, this, 10, null, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mForegroundActivityTimer;
        }

        public StopwatchTimer createForegroundServiceTimerLocked() {
            if (this.mForegroundServiceTimer == null) {
                this.mForegroundServiceTimer = new StopwatchTimer(this.mBsi.mClock, this, 22, null, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mForegroundServiceTimer;
        }

        public DualTimer createAggregatedPartialWakelockTimerLocked() {
            if (this.mAggregatedPartialWakelockTimer == null) {
                this.mAggregatedPartialWakelockTimer = new DualTimer(this.mBsi.mClock, this, 20, null, this.mBsi.mOnBatteryScreenOffTimeBase, this.mOnBatteryScreenOffBackgroundTimeBase);
            }
            return this.mAggregatedPartialWakelockTimer;
        }

        public DualTimer createBluetoothScanTimerLocked() {
            if (this.mBluetoothScanTimer == null) {
                this.mBluetoothScanTimer = new DualTimer(this.mBsi.mClock, this, 19, this.mBsi.mBluetoothScanOnTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
            }
            return this.mBluetoothScanTimer;
        }

        public DualTimer createBluetoothUnoptimizedScanTimerLocked() {
            if (this.mBluetoothUnoptimizedScanTimer == null) {
                this.mBluetoothUnoptimizedScanTimer = new DualTimer(this.mBsi.mClock, this, 21, null, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
            }
            return this.mBluetoothUnoptimizedScanTimer;
        }

        public void noteBluetoothScanStartedLocked(long elapsedRealtimeMs, boolean isUnoptimized) {
            this.createBluetoothScanTimerLocked().startRunningLocked(elapsedRealtimeMs);
            if (isUnoptimized) {
                this.createBluetoothUnoptimizedScanTimerLocked().startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteBluetoothScanStoppedLocked(long elapsedRealtimeMs, boolean isUnoptimized) {
            if (this.mBluetoothScanTimer != null) {
                this.mBluetoothScanTimer.stopRunningLocked(elapsedRealtimeMs);
            }
            if (isUnoptimized && this.mBluetoothUnoptimizedScanTimer != null) {
                this.mBluetoothUnoptimizedScanTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetBluetoothScanLocked(long elapsedRealtimeMs) {
            if (this.mBluetoothScanTimer != null) {
                this.mBluetoothScanTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
            if (this.mBluetoothUnoptimizedScanTimer != null) {
                this.mBluetoothUnoptimizedScanTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public Counter createBluetoothScanResultCounterLocked() {
            if (this.mBluetoothScanResultCounter == null) {
                this.mBluetoothScanResultCounter = new Counter(this.mBsi.mOnBatteryTimeBase);
            }
            return this.mBluetoothScanResultCounter;
        }

        public Counter createBluetoothScanResultBgCounterLocked() {
            if (this.mBluetoothScanResultBgCounter == null) {
                this.mBluetoothScanResultBgCounter = new Counter(this.mOnBatteryBackgroundTimeBase);
            }
            return this.mBluetoothScanResultBgCounter;
        }

        public void noteBluetoothScanResultsLocked(int numNewResults) {
            this.createBluetoothScanResultCounterLocked().addAtomic(numNewResults);
            this.createBluetoothScanResultBgCounterLocked().addAtomic(numNewResults);
        }

        @Override
        public void noteActivityResumedLocked(long elapsedRealtimeMs) {
            this.createForegroundActivityTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void noteActivityPausedLocked(long elapsedRealtimeMs) {
            if (this.mForegroundActivityTimer != null) {
                this.mForegroundActivityTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteForegroundServiceResumedLocked(long elapsedRealtimeMs) {
            this.createForegroundServiceTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteForegroundServicePausedLocked(long elapsedRealtimeMs) {
            if (this.mForegroundServiceTimer != null) {
                this.mForegroundServiceTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public BatchTimer createVibratorOnTimerLocked() {
            if (this.mVibratorOnTimer == null) {
                this.mVibratorOnTimer = new BatchTimer(this.mBsi.mClock, this, 9, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mVibratorOnTimer;
        }

        public void noteVibratorOnLocked(long durationMillis, long elapsedRealtimeMs) {
            this.createVibratorOnTimerLocked().addDuration(this.mBsi, durationMillis, elapsedRealtimeMs);
        }

        public void noteVibratorOffLocked(long elapsedRealtimeMs) {
            if (this.mVibratorOnTimer != null) {
                this.mVibratorOnTimer.abortLastDuration(this.mBsi, elapsedRealtimeMs);
            }
        }

        @Override
        @UnsupportedAppUsage
        public long getWifiRunningTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiRunningTimer == null) {
                return 0L;
            }
            return this.mWifiRunningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public long getFullWifiLockTime(long elapsedRealtimeUs, int which) {
            if (this.mFullWifiLockTimer == null) {
                return 0L;
            }
            return this.mFullWifiLockTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        @UnsupportedAppUsage
        public long getWifiScanTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiScanTimer == null) {
                return 0L;
            }
            return this.mWifiScanTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public int getWifiScanCount(int which) {
            if (this.mWifiScanTimer == null) {
                return 0;
            }
            return this.mWifiScanTimer.getCountLocked(which);
        }

        @Override
        public Timer getWifiScanTimer() {
            return this.mWifiScanTimer;
        }

        @Override
        public int getWifiScanBackgroundCount(int which) {
            if (this.mWifiScanTimer == null || this.mWifiScanTimer.getSubTimer() == null) {
                return 0;
            }
            return this.mWifiScanTimer.getSubTimer().getCountLocked(which);
        }

        @Override
        public long getWifiScanActualTime(long elapsedRealtimeUs) {
            if (this.mWifiScanTimer == null) {
                return 0L;
            }
            long elapsedRealtimeMs = (elapsedRealtimeUs + 500L) / 1000L;
            return this.mWifiScanTimer.getTotalDurationMsLocked(elapsedRealtimeMs) * 1000L;
        }

        @Override
        public long getWifiScanBackgroundTime(long elapsedRealtimeUs) {
            if (this.mWifiScanTimer == null || this.mWifiScanTimer.getSubTimer() == null) {
                return 0L;
            }
            long elapsedRealtimeMs = (elapsedRealtimeUs + 500L) / 1000L;
            return this.mWifiScanTimer.getSubTimer().getTotalDurationMsLocked(elapsedRealtimeMs) * 1000L;
        }

        @Override
        public Timer getWifiScanBackgroundTimer() {
            if (this.mWifiScanTimer == null) {
                return null;
            }
            return this.mWifiScanTimer.getSubTimer();
        }

        @Override
        public long getWifiBatchedScanTime(int csphBin, long elapsedRealtimeUs, int which) {
            if (csphBin < 0 || csphBin >= 5) {
                return 0L;
            }
            if (this.mWifiBatchedScanTimer[csphBin] == null) {
                return 0L;
            }
            return this.mWifiBatchedScanTimer[csphBin].getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public int getWifiBatchedScanCount(int csphBin, int which) {
            if (csphBin < 0 || csphBin >= 5) {
                return 0;
            }
            if (this.mWifiBatchedScanTimer[csphBin] == null) {
                return 0;
            }
            return this.mWifiBatchedScanTimer[csphBin].getCountLocked(which);
        }

        @Override
        public long getWifiMulticastTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiMulticastTimer == null) {
                return 0L;
            }
            return this.mWifiMulticastTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public Timer getAudioTurnedOnTimer() {
            return this.mAudioTurnedOnTimer;
        }

        @Override
        public Timer getVideoTurnedOnTimer() {
            return this.mVideoTurnedOnTimer;
        }

        @Override
        public Timer getFlashlightTurnedOnTimer() {
            return this.mFlashlightTurnedOnTimer;
        }

        @Override
        public Timer getCameraTurnedOnTimer() {
            return this.mCameraTurnedOnTimer;
        }

        @Override
        public Timer getForegroundActivityTimer() {
            return this.mForegroundActivityTimer;
        }

        @Override
        public Timer getForegroundServiceTimer() {
            return this.mForegroundServiceTimer;
        }

        @Override
        public Timer getBluetoothScanTimer() {
            return this.mBluetoothScanTimer;
        }

        @Override
        public Timer getBluetoothScanBackgroundTimer() {
            if (this.mBluetoothScanTimer == null) {
                return null;
            }
            return this.mBluetoothScanTimer.getSubTimer();
        }

        @Override
        public Timer getBluetoothUnoptimizedScanTimer() {
            return this.mBluetoothUnoptimizedScanTimer;
        }

        @Override
        public Timer getBluetoothUnoptimizedScanBackgroundTimer() {
            if (this.mBluetoothUnoptimizedScanTimer == null) {
                return null;
            }
            return this.mBluetoothUnoptimizedScanTimer.getSubTimer();
        }

        @Override
        public Counter getBluetoothScanResultCounter() {
            return this.mBluetoothScanResultCounter;
        }

        @Override
        public Counter getBluetoothScanResultBgCounter() {
            return this.mBluetoothScanResultBgCounter;
        }

        void makeProcessState(int i, Parcel in) {
            if (i < 0 || i >= 7) {
                return;
            }
            BatteryStatsImpl.detachIfNotNull(this.mProcessStateTimer[i]);
            this.mProcessStateTimer[i] = in == null ? new StopwatchTimer(this.mBsi.mClock, this, 12, null, this.mBsi.mOnBatteryTimeBase) : new StopwatchTimer(this.mBsi.mClock, this, 12, null, this.mBsi.mOnBatteryTimeBase, in);
        }

        @Override
        public long getProcessStateTime(int state, long elapsedRealtimeUs, int which) {
            if (state < 0 || state >= 7) {
                return 0L;
            }
            if (this.mProcessStateTimer[state] == null) {
                return 0L;
            }
            return this.mProcessStateTimer[state].getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public Timer getProcessStateTimer(int state) {
            if (state < 0 || state >= 7) {
                return null;
            }
            return this.mProcessStateTimer[state];
        }

        @Override
        public Timer getVibratorOnTimer() {
            return this.mVibratorOnTimer;
        }

        @Override
        public void noteUserActivityLocked(int type) {
            if (this.mUserActivityCounters == null) {
                this.initUserActivityLocked();
            }
            if (type >= 0 && type < NUM_USER_ACTIVITY_TYPES) {
                this.mUserActivityCounters[type].stepAtomic();
            } else {
                Slog.w(BatteryStatsImpl.TAG, "Unknown user activity type " + type + " was specified.", new Throwable());
            }
        }

        @Override
        public boolean hasUserActivity() {
            return this.mUserActivityCounters != null;
        }

        @Override
        public int getUserActivityCount(int type, int which) {
            if (this.mUserActivityCounters == null) {
                return 0;
            }
            return this.mUserActivityCounters[type].getCountLocked(which);
        }

        void makeWifiBatchedScanBin(int i, Parcel in) {
            if (i < 0 || i >= 5) {
                return;
            }
            ArrayList<StopwatchTimer> collected = this.mBsi.mWifiBatchedScanTimers.get(i);
            if (collected == null) {
                collected = new ArrayList();
                this.mBsi.mWifiBatchedScanTimers.put(i, collected);
            }
            BatteryStatsImpl.detachIfNotNull(this.mWifiBatchedScanTimer[i]);
            this.mWifiBatchedScanTimer[i] = in == null ? new StopwatchTimer(this.mBsi.mClock, this, 11, collected, this.mBsi.mOnBatteryTimeBase) : new StopwatchTimer(this.mBsi.mClock, this, 11, collected, this.mBsi.mOnBatteryTimeBase, in);
        }

        void initUserActivityLocked() {
            BatteryStatsImpl.detachIfNotNull(this.mUserActivityCounters);
            this.mUserActivityCounters = new Counter[NUM_USER_ACTIVITY_TYPES];
            for (int i = 0; i < NUM_USER_ACTIVITY_TYPES; ++i) {
                this.mUserActivityCounters[i] = new Counter(this.mBsi.mOnBatteryTimeBase);
            }
        }

        void noteNetworkActivityLocked(int type, long deltaBytes, long deltaPackets) {
            this.ensureNetworkActivityLocked();
            if (type >= 0 && type < 10) {
                this.mNetworkByteActivityCounters[type].addCountLocked(deltaBytes);
                this.mNetworkPacketActivityCounters[type].addCountLocked(deltaPackets);
            } else {
                Slog.w(BatteryStatsImpl.TAG, "Unknown network activity type " + type + " was specified.", new Throwable());
            }
        }

        void noteMobileRadioActiveTimeLocked(long batteryUptimeDeltaUs, long elapsedTimeMs) {
            this.ensureNetworkActivityLocked();
            this.getMobileRadioActiveTimeCounter().increment(batteryUptimeDeltaUs, elapsedTimeMs);
            this.mMobileRadioActiveCount.addCountLocked(1L);
        }

        private TimeMultiStateCounter getMobileRadioActiveTimeCounter() {
            if (this.mMobileRadioActiveTime == null) {
                long timestampMs = this.mBsi.mClock.elapsedRealtime();
                this.mMobileRadioActiveTime = new TimeMultiStateCounter(this.mBsi.mOnBatteryTimeBase, 5, timestampMs);
                this.mMobileRadioActiveTime.setState(BatteryStats.mapUidProcessStateToBatteryConsumerProcessState(this.mProcessState), timestampMs);
                this.mMobileRadioActiveTime.update(0L, timestampMs);
            }
            return this.mMobileRadioActiveTime;
        }

        @Override
        public boolean hasNetworkActivity() {
            return this.mNetworkByteActivityCounters != null;
        }

        @Override
        public long getNetworkActivityBytes(int type, int which) {
            if (this.mNetworkByteActivityCounters != null && type >= 0 && type < this.mNetworkByteActivityCounters.length) {
                return this.mNetworkByteActivityCounters[type].getCountLocked(which);
            }
            return 0L;
        }

        @Override
        public long getNetworkActivityPackets(int type, int which) {
            if (this.mNetworkPacketActivityCounters != null && type >= 0 && type < this.mNetworkPacketActivityCounters.length) {
                return this.mNetworkPacketActivityCounters[type].getCountLocked(which);
            }
            return 0L;
        }

        @Override
        public long getMobileRadioActiveTime(int which) {
            return this.getMobileRadioActiveTimeInProcessState(0);
        }

        @Override
        public long getMobileRadioActiveTimeInProcessState(int processState) {
            if (this.mMobileRadioActiveTime == null) {
                return 0L;
            }
            if (processState == 0) {
                return this.mMobileRadioActiveTime.getTotalCountLocked();
            }
            return this.mMobileRadioActiveTime.getCountForProcessState(processState);
        }

        @Override
        public int getMobileRadioActiveCount(int which) {
            return this.mMobileRadioActiveCount != null ? (int)this.mMobileRadioActiveCount.getCountLocked(which) : 0;
        }

        @Override
        public long getUserCpuTimeUs(int which) {
            return this.mUserCpuTime.getCountLocked(which);
        }

        @Override
        public long getSystemCpuTimeUs(int which) {
            return this.mSystemCpuTime.getCountLocked(which);
        }

        @Override
        public long getTimeAtCpuSpeed(int cluster, int step, int which) {
            LongSamplingCounter c;
            LongSamplingCounter[] cpuSpeedTimesUs;
            if (this.mCpuClusterSpeedTimesUs != null && cluster >= 0 && cluster < this.mCpuClusterSpeedTimesUs.length && (cpuSpeedTimesUs = this.mCpuClusterSpeedTimesUs[cluster]) != null && step >= 0 && step < cpuSpeedTimesUs.length && (c = cpuSpeedTimesUs[step]) != null) {
                return c.getCountLocked(which);
            }
            return 0L;
        }

        public void noteMobileRadioApWakeupLocked() {
            if (this.mMobileRadioApWakeupCount == null) {
                this.mMobileRadioApWakeupCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            }
            this.mMobileRadioApWakeupCount.addCountLocked(1L);
        }

        @Override
        public long getMobileRadioApWakeupCount(int which) {
            if (this.mMobileRadioApWakeupCount != null) {
                return this.mMobileRadioApWakeupCount.getCountLocked(which);
            }
            return 0L;
        }

        public void noteWifiRadioApWakeupLocked() {
            if (this.mWifiRadioApWakeupCount == null) {
                this.mWifiRadioApWakeupCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            }
            this.mWifiRadioApWakeupCount.addCountLocked(1L);
        }

        @Override
        public long getWifiRadioApWakeupCount(int which) {
            if (this.mWifiRadioApWakeupCount != null) {
                return this.mWifiRadioApWakeupCount.getCountLocked(which);
            }
            return 0L;
        }

        @Override
        public void getDeferredJobsCheckinLineLocked(StringBuilder sb, int which) {
            sb.setLength(0);
            int deferredEventCount = this.mJobsDeferredEventCount.getCountLocked(which);
            if (deferredEventCount == 0) {
                return;
            }
            int deferredCount = this.mJobsDeferredCount.getCountLocked(which);
            long totalLatency = this.mJobsFreshnessTimeMs.getCountLocked(which);
            sb.append(deferredEventCount);
            sb.append(',');
            sb.append(deferredCount);
            sb.append(',');
            sb.append(totalLatency);
            for (int i = 0; i < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i) {
                if (this.mJobsFreshnessBuckets[i] == null) {
                    sb.append(",0");
                    continue;
                }
                sb.append(",");
                sb.append(this.mJobsFreshnessBuckets[i].getCountLocked(which));
            }
        }

        @Override
        public void getDeferredJobsLineLocked(StringBuilder sb, int which) {
            sb.setLength(0);
            int deferredEventCount = this.mJobsDeferredEventCount.getCountLocked(which);
            if (deferredEventCount == 0) {
                return;
            }
            int deferredCount = this.mJobsDeferredCount.getCountLocked(which);
            long totalLatency = this.mJobsFreshnessTimeMs.getCountLocked(which);
            sb.append("times=");
            sb.append(deferredEventCount);
            sb.append(", ");
            sb.append("count=");
            sb.append(deferredCount);
            sb.append(", ");
            sb.append("totalLatencyMs=");
            sb.append(totalLatency);
            sb.append(", ");
            for (int i = 0; i < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i) {
                sb.append("<");
                sb.append(BatteryStats.JOB_FRESHNESS_BUCKETS[i]);
                sb.append("ms=");
                if (this.mJobsFreshnessBuckets[i] == null) {
                    sb.append("0");
                } else {
                    sb.append(this.mJobsFreshnessBuckets[i].getCountLocked(which));
                }
                sb.append(" ");
            }
        }

        void ensureNetworkActivityLocked() {
            if (this.mNetworkByteActivityCounters != null) {
                return;
            }
            this.mNetworkByteActivityCounters = new LongSamplingCounter[10];
            this.mNetworkPacketActivityCounters = new LongSamplingCounter[10];
            for (int i = 0; i < 10; ++i) {
                this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
                this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            }
            this.mMobileRadioActiveCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public boolean reset(long uptimeUs, long realtimeUs, int resetReason) {
            int i;
            int i2;
            boolean active = false;
            this.mOnBatteryBackgroundTimeBase.init(uptimeUs, realtimeUs);
            this.mOnBatteryScreenOffBackgroundTimeBase.init(uptimeUs, realtimeUs);
            if (this.mWifiRunningTimer != null) {
                active |= !this.mWifiRunningTimer.reset(false, realtimeUs);
                active |= this.mWifiRunning;
            }
            if (this.mFullWifiLockTimer != null) {
                active |= !this.mFullWifiLockTimer.reset(false, realtimeUs);
                active |= this.mFullWifiLockOut;
            }
            if (this.mWifiScanTimer != null) {
                active |= !this.mWifiScanTimer.reset(false, realtimeUs);
                active |= this.mWifiScanStarted;
            }
            if (this.mWifiBatchedScanTimer != null) {
                for (i2 = 0; i2 < 5; ++i2) {
                    if (this.mWifiBatchedScanTimer[i2] == null) continue;
                    active |= !this.mWifiBatchedScanTimer[i2].reset(false, realtimeUs);
                }
                active |= this.mWifiBatchedScanBinStarted != -1;
            }
            if (this.mWifiMulticastTimer != null) {
                active |= !this.mWifiMulticastTimer.reset(false, realtimeUs);
                active |= this.mWifiMulticastWakelockCount > 0;
            }
            active |= !BatteryStatsImpl.resetIfNotNull(this.mAudioTurnedOnTimer, false, realtimeUs);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mVideoTurnedOnTimer, false, realtimeUs);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mFlashlightTurnedOnTimer, false, realtimeUs);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mCameraTurnedOnTimer, false, realtimeUs);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mForegroundActivityTimer, false, realtimeUs);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mForegroundServiceTimer, false, realtimeUs);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mAggregatedPartialWakelockTimer, false, realtimeUs);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mBluetoothScanTimer, false, realtimeUs);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mBluetoothUnoptimizedScanTimer, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mBluetoothScanResultCounter, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mBluetoothScanResultBgCounter, false, realtimeUs);
            if (this.mProcessStateTimer != null) {
                for (i2 = 0; i2 < 7; ++i2) {
                    active |= !BatteryStatsImpl.resetIfNotNull(this.mProcessStateTimer[i2], false, realtimeUs);
                }
                active |= this.mProcessState != 7;
            }
            if (this.mVibratorOnTimer != null) {
                if (this.mVibratorOnTimer.reset(false, realtimeUs)) {
                    this.mVibratorOnTimer.detach();
                    this.mVibratorOnTimer = null;
                } else {
                    active = true;
                }
            }
            BatteryStatsImpl.resetIfNotNull(this.mUserActivityCounters, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mNetworkByteActivityCounters, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mNetworkPacketActivityCounters, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mMobileRadioActiveTime, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mMobileRadioActiveCount, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mWifiControllerActivity, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mBluetoothControllerActivity, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mModemControllerActivity, false, realtimeUs);
            if (resetReason == 4) {
                this.mUidMeasuredEnergyStats = null;
            } else {
                MeasuredEnergyStats.resetIfNotNull(this.mUidMeasuredEnergyStats);
            }
            BatteryStatsImpl.resetIfNotNull(this.mUserCpuTime, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mSystemCpuTime, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mCpuClusterSpeedTimesUs, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mCpuFreqTimeMs, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mScreenOffCpuFreqTimeMs, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mCpuActiveTimeMs, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mCpuClusterTimesMs, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mProcStateTimeMs, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mProcStateScreenOffTimeMs, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mMobileRadioApWakeupCount, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mWifiRadioApWakeupCount, false, realtimeUs);
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            for (int iw = wakeStats.size() - 1; iw >= 0; --iw) {
                Wakelock wl = wakeStats.valueAt(iw);
                if (wl.reset(realtimeUs)) {
                    wakeStats.removeAt(iw);
                    continue;
                }
                active = true;
            }
            long realtimeMs = realtimeUs / 1000L;
            this.mWakelockStats.cleanup(realtimeMs);
            ArrayMap<String, DualTimer> syncStats = this.mSyncStats.getMap();
            for (int is = syncStats.size() - 1; is >= 0; --is) {
                DualTimer timer = syncStats.valueAt(is);
                if (timer.reset(false, realtimeUs)) {
                    syncStats.removeAt(is);
                    timer.detach();
                    continue;
                }
                active = true;
            }
            this.mSyncStats.cleanup(realtimeMs);
            ArrayMap<String, DualTimer> jobStats = this.mJobStats.getMap();
            for (int ij = jobStats.size() - 1; ij >= 0; --ij) {
                DualTimer timer = jobStats.valueAt(ij);
                if (timer.reset(false, realtimeUs)) {
                    jobStats.removeAt(ij);
                    timer.detach();
                    continue;
                }
                active = true;
            }
            this.mJobStats.cleanup(realtimeMs);
            this.mJobCompletions.clear();
            BatteryStatsImpl.resetIfNotNull(this.mJobsDeferredEventCount, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mJobsDeferredCount, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mJobsFreshnessTimeMs, false, realtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mJobsFreshnessBuckets, false, realtimeUs);
            for (int ise = this.mSensorStats.size() - 1; ise >= 0; --ise) {
                Sensor s = this.mSensorStats.valueAt(ise);
                if (s.reset(realtimeUs)) {
                    this.mSensorStats.removeAt(ise);
                    continue;
                }
                active = true;
            }
            for (int ip = this.mProcessStats.size() - 1; ip >= 0; --ip) {
                Proc proc = this.mProcessStats.valueAt(ip);
                proc.detach();
            }
            this.mProcessStats.clear();
            for (i = this.mPids.size() - 1; i >= 0; --i) {
                BatteryStats.Uid.Pid pid = this.mPids.valueAt(i);
                if (pid.mWakeNesting > 0) {
                    active = true;
                    continue;
                }
                this.mPids.removeAt(i);
            }
            for (i = this.mPackageStats.size() - 1; i >= 0; --i) {
                Pkg p = this.mPackageStats.valueAt(i);
                p.detach();
            }
            this.mPackageStats.clear();
            this.mBinderCallCount = 0L;
            this.mBinderCallStats.clear();
            this.mProportionalSystemServiceUsage = 0.0;
            this.mLastStepSystemTimeMs = 0L;
            this.mLastStepUserTimeMs = 0L;
            this.mCurStepSystemTimeMs = 0L;
            this.mCurStepUserTimeMs = 0L;
            return !active;
        }

        void detachFromTimeBase() {
            BatteryStatsImpl.detachIfNotNull(this.mWifiRunningTimer);
            BatteryStatsImpl.detachIfNotNull(this.mFullWifiLockTimer);
            BatteryStatsImpl.detachIfNotNull(this.mWifiScanTimer);
            BatteryStatsImpl.detachIfNotNull(this.mWifiBatchedScanTimer);
            BatteryStatsImpl.detachIfNotNull(this.mWifiMulticastTimer);
            BatteryStatsImpl.detachIfNotNull(this.mAudioTurnedOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mVideoTurnedOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mFlashlightTurnedOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mCameraTurnedOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mForegroundActivityTimer);
            BatteryStatsImpl.detachIfNotNull(this.mForegroundServiceTimer);
            BatteryStatsImpl.detachIfNotNull(this.mAggregatedPartialWakelockTimer);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothScanTimer);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothUnoptimizedScanTimer);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothScanResultCounter);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothScanResultBgCounter);
            BatteryStatsImpl.detachIfNotNull(this.mProcessStateTimer);
            BatteryStatsImpl.detachIfNotNull(this.mVibratorOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mUserActivityCounters);
            BatteryStatsImpl.detachIfNotNull(this.mNetworkByteActivityCounters);
            BatteryStatsImpl.detachIfNotNull(this.mNetworkPacketActivityCounters);
            BatteryStatsImpl.detachIfNotNull(this.mMobileRadioActiveTime);
            BatteryStatsImpl.detachIfNotNull(this.mMobileRadioActiveCount);
            BatteryStatsImpl.detachIfNotNull(this.mMobileRadioApWakeupCount);
            BatteryStatsImpl.detachIfNotNull(this.mWifiRadioApWakeupCount);
            BatteryStatsImpl.detachIfNotNull(this.mWifiControllerActivity);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothControllerActivity);
            BatteryStatsImpl.detachIfNotNull(this.mModemControllerActivity);
            this.mPids.clear();
            BatteryStatsImpl.detachIfNotNull(this.mUserCpuTime);
            BatteryStatsImpl.detachIfNotNull(this.mSystemCpuTime);
            BatteryStatsImpl.detachIfNotNull(this.mCpuClusterSpeedTimesUs);
            BatteryStatsImpl.detachIfNotNull(this.mCpuActiveTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mCpuFreqTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mScreenOffCpuFreqTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mCpuClusterTimesMs);
            BatteryStatsImpl.detachIfNotNull(this.mProcStateTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mProcStateScreenOffTimeMs);
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            for (int iw = wakeStats.size() - 1; iw >= 0; --iw) {
                Wakelock wl = wakeStats.valueAt(iw);
                wl.detachFromTimeBase();
            }
            ArrayMap<String, DualTimer> syncStats = this.mSyncStats.getMap();
            for (int is = syncStats.size() - 1; is >= 0; --is) {
                DualTimer timer = syncStats.valueAt(is);
                BatteryStatsImpl.detachIfNotNull(timer);
            }
            ArrayMap<String, DualTimer> jobStats = this.mJobStats.getMap();
            for (int ij = jobStats.size() - 1; ij >= 0; --ij) {
                DualTimer timer = jobStats.valueAt(ij);
                BatteryStatsImpl.detachIfNotNull(timer);
            }
            BatteryStatsImpl.detachIfNotNull(this.mJobsDeferredEventCount);
            BatteryStatsImpl.detachIfNotNull(this.mJobsDeferredCount);
            BatteryStatsImpl.detachIfNotNull(this.mJobsFreshnessTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mJobsFreshnessBuckets);
            for (int ise = this.mSensorStats.size() - 1; ise >= 0; --ise) {
                Sensor s = this.mSensorStats.valueAt(ise);
                s.detachFromTimeBase();
            }
            for (int ip = this.mProcessStats.size() - 1; ip >= 0; --ip) {
                Proc proc = this.mProcessStats.valueAt(ip);
                proc.detach();
            }
            this.mProcessStats.clear();
            for (int i = this.mPackageStats.size() - 1; i >= 0; --i) {
                Pkg p = this.mPackageStats.valueAt(i);
                p.detach();
            }
            this.mPackageStats.clear();
        }

        void writeJobCompletionsToParcelLocked(Parcel out) {
            int NJC = this.mJobCompletions.size();
            out.writeInt(NJC);
            for (int ijc = 0; ijc < NJC; ++ijc) {
                out.writeString(this.mJobCompletions.keyAt(ijc));
                SparseIntArray types = this.mJobCompletions.valueAt(ijc);
                int NT = types.size();
                out.writeInt(NT);
                for (int it = 0; it < NT; ++it) {
                    out.writeInt(types.keyAt(it));
                    out.writeInt(types.valueAt(it));
                }
            }
        }

        void writeToParcelLocked(Parcel out, long uptimeUs, long elapsedRealtimeUs) {
            int i;
            this.mOnBatteryBackgroundTimeBase.writeToParcel(out, uptimeUs, elapsedRealtimeUs);
            this.mOnBatteryScreenOffBackgroundTimeBase.writeToParcel(out, uptimeUs, elapsedRealtimeUs);
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            int NW = wakeStats.size();
            out.writeInt(NW);
            for (int iw = 0; iw < NW; ++iw) {
                out.writeString(wakeStats.keyAt(iw));
                Wakelock wakelock = wakeStats.valueAt(iw);
                wakelock.writeToParcelLocked(out, elapsedRealtimeUs);
            }
            ArrayMap<String, DualTimer> syncStats = this.mSyncStats.getMap();
            int NS = syncStats.size();
            out.writeInt(NS);
            for (int is = 0; is < NS; ++is) {
                out.writeString(syncStats.keyAt(is));
                DualTimer timer = syncStats.valueAt(is);
                Timer.writeTimerToParcel(out, timer, elapsedRealtimeUs);
            }
            ArrayMap<String, DualTimer> jobStats = this.mJobStats.getMap();
            int NJ = jobStats.size();
            out.writeInt(NJ);
            for (int ij = 0; ij < NJ; ++ij) {
                out.writeString(jobStats.keyAt(ij));
                DualTimer timer = jobStats.valueAt(ij);
                Timer.writeTimerToParcel(out, timer, elapsedRealtimeUs);
            }
            this.writeJobCompletionsToParcelLocked(out);
            this.mJobsDeferredEventCount.writeToParcel(out);
            this.mJobsDeferredCount.writeToParcel(out);
            this.mJobsFreshnessTimeMs.writeToParcel(out);
            for (int i2 = 0; i2 < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i2) {
                Counter.writeCounterToParcel(out, this.mJobsFreshnessBuckets[i2]);
            }
            int NSE = this.mSensorStats.size();
            out.writeInt(NSE);
            for (int ise = 0; ise < NSE; ++ise) {
                out.writeInt(this.mSensorStats.keyAt(ise));
                Sensor sensor = this.mSensorStats.valueAt(ise);
                sensor.writeToParcelLocked(out, elapsedRealtimeUs);
            }
            int NP = this.mProcessStats.size();
            out.writeInt(NP);
            for (int ip = 0; ip < NP; ++ip) {
                out.writeString(this.mProcessStats.keyAt(ip));
                Proc proc = this.mProcessStats.valueAt(ip);
                proc.writeToParcelLocked(out);
            }
            out.writeInt(this.mPackageStats.size());
            for (Map.Entry<String, Pkg> pkgEntry : this.mPackageStats.entrySet()) {
                out.writeString(pkgEntry.getKey());
                Pkg pkg = pkgEntry.getValue();
                pkg.writeToParcelLocked(out);
            }
            if (this.mWifiRunningTimer != null) {
                out.writeInt(1);
                this.mWifiRunningTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mFullWifiLockTimer != null) {
                out.writeInt(1);
                this.mFullWifiLockTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiScanTimer != null) {
                out.writeInt(1);
                this.mWifiScanTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 5; ++i) {
                if (this.mWifiBatchedScanTimer[i] != null) {
                    out.writeInt(1);
                    this.mWifiBatchedScanTimer[i].writeToParcel(out, elapsedRealtimeUs);
                    continue;
                }
                out.writeInt(0);
            }
            if (this.mWifiMulticastTimer != null) {
                out.writeInt(1);
                this.mWifiMulticastTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                this.mAudioTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                this.mVideoTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mFlashlightTurnedOnTimer != null) {
                out.writeInt(1);
                this.mFlashlightTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mCameraTurnedOnTimer != null) {
                out.writeInt(1);
                this.mCameraTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mForegroundActivityTimer != null) {
                out.writeInt(1);
                this.mForegroundActivityTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mForegroundServiceTimer != null) {
                out.writeInt(1);
                this.mForegroundServiceTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mAggregatedPartialWakelockTimer != null) {
                out.writeInt(1);
                this.mAggregatedPartialWakelockTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothScanTimer != null) {
                out.writeInt(1);
                this.mBluetoothScanTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothUnoptimizedScanTimer != null) {
                out.writeInt(1);
                this.mBluetoothUnoptimizedScanTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothScanResultCounter != null) {
                out.writeInt(1);
                this.mBluetoothScanResultCounter.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothScanResultBgCounter != null) {
                out.writeInt(1);
                this.mBluetoothScanResultBgCounter.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 7; ++i) {
                if (this.mProcessStateTimer[i] != null) {
                    out.writeInt(1);
                    this.mProcessStateTimer[i].writeToParcel(out, elapsedRealtimeUs);
                    continue;
                }
                out.writeInt(0);
            }
            if (this.mVibratorOnTimer != null) {
                out.writeInt(1);
                this.mVibratorOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mUserActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < NUM_USER_ACTIVITY_TYPES; ++i) {
                    this.mUserActivityCounters[i].writeToParcel(out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.mNetworkByteActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < 10; ++i) {
                    this.mNetworkByteActivityCounters[i].writeToParcel(out);
                    this.mNetworkPacketActivityCounters[i].writeToParcel(out);
                }
                if (this.mMobileRadioActiveTime != null) {
                    out.writeBoolean(true);
                    this.mMobileRadioActiveTime.writeToParcel(out);
                } else {
                    out.writeBoolean(false);
                }
                this.mMobileRadioActiveCount.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiControllerActivity != null) {
                out.writeInt(1);
                this.mWifiControllerActivity.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothControllerActivity != null) {
                out.writeInt(1);
                this.mBluetoothControllerActivity.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            if (this.mModemControllerActivity != null) {
                out.writeInt(1);
                this.mModemControllerActivity.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            if (this.mUidMeasuredEnergyStats != null) {
                out.writeInt(1);
                this.mUidMeasuredEnergyStats.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            this.mUserCpuTime.writeToParcel(out);
            this.mSystemCpuTime.writeToParcel(out);
            this.mBsi.writeCpuSpeedCountersToParcel(out, this.mCpuClusterSpeedTimesUs);
            LongSamplingCounterArray.writeToParcel(out, this.mCpuFreqTimeMs);
            LongSamplingCounterArray.writeToParcel(out, this.mScreenOffCpuFreqTimeMs);
            if (this.mCpuActiveTimeMs != null) {
                out.writeInt(this.mCpuActiveTimeMs.getStateCount());
                this.mCpuActiveTimeMs.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            this.mCpuClusterTimesMs.writeToParcel(out);
            if (this.mProcStateTimeMs != null) {
                out.writeInt(this.mProcStateTimeMs.getStateCount());
                this.mProcStateTimeMs.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (this.mProcStateScreenOffTimeMs != null) {
                out.writeInt(this.mProcStateScreenOffTimeMs.getStateCount());
                this.mProcStateScreenOffTimeMs.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (this.mMobileRadioApWakeupCount != null) {
                out.writeInt(1);
                this.mMobileRadioApWakeupCount.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiRadioApWakeupCount != null) {
                out.writeInt(1);
                this.mWifiRadioApWakeupCount.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            out.writeDouble(this.mProportionalSystemServiceUsage);
        }

        void readJobCompletionsFromParcelLocked(Parcel in) {
            int numJobCompletions = in.readInt();
            this.mJobCompletions.clear();
            for (int j = 0; j < numJobCompletions; ++j) {
                String jobName = in.readString();
                int numTypes = in.readInt();
                if (numTypes <= 0) continue;
                SparseIntArray types = new SparseIntArray();
                for (int k = 0; k < numTypes; ++k) {
                    int type = in.readInt();
                    int count = in.readInt();
                    types.put(type, count);
                }
                this.mJobCompletions.put(jobName, types);
            }
        }

        @GuardedBy(value={"mBsi"})
        void readFromParcelLocked(TimeBase timeBase, TimeBase screenOffTimeBase, Parcel in) {
            int i;
            long timestampMs = this.mBsi.mClock.elapsedRealtime();
            this.mOnBatteryBackgroundTimeBase.readFromParcel(in);
            this.mOnBatteryScreenOffBackgroundTimeBase.readFromParcel(in);
            int numWakelocks = in.readInt();
            this.mWakelockStats.clear();
            for (int j = 0; j < numWakelocks; ++j) {
                String wakelockName = in.readString();
                Wakelock wakelock = new Wakelock(this.mBsi, this);
                wakelock.readFromParcelLocked(timeBase, screenOffTimeBase, this.mOnBatteryScreenOffBackgroundTimeBase, in);
                this.mWakelockStats.add(wakelockName, wakelock);
            }
            int numSyncs = in.readInt();
            this.mSyncStats.clear();
            for (int j = 0; j < numSyncs; ++j) {
                String syncName = in.readString();
                if (in.readInt() == 0) continue;
                this.mSyncStats.add(syncName, new DualTimer(this.mBsi.mClock, this, 13, null, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in));
            }
            int numJobs = in.readInt();
            this.mJobStats.clear();
            for (int j = 0; j < numJobs; ++j) {
                String jobName = in.readString();
                if (in.readInt() == 0) continue;
                this.mJobStats.add(jobName, new DualTimer(this.mBsi.mClock, this, 14, null, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in));
            }
            this.readJobCompletionsFromParcelLocked(in);
            this.mJobsDeferredEventCount = new Counter(this.mBsi.mOnBatteryTimeBase, in);
            this.mJobsDeferredCount = new Counter(this.mBsi.mOnBatteryTimeBase, in);
            this.mJobsFreshnessTimeMs = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            for (int i2 = 0; i2 < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i2) {
                this.mJobsFreshnessBuckets[i2] = Counter.readCounterFromParcel(this.mBsi.mOnBatteryTimeBase, in);
            }
            int numSensors = in.readInt();
            this.mSensorStats.clear();
            for (int k = 0; k < numSensors; ++k) {
                int sensorNumber = in.readInt();
                Sensor sensor = new Sensor(this.mBsi, this, sensorNumber);
                sensor.readFromParcelLocked(this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in);
                this.mSensorStats.put(sensorNumber, sensor);
            }
            int numProcs = in.readInt();
            this.mProcessStats.clear();
            for (int k = 0; k < numProcs; ++k) {
                String processName = in.readString();
                Proc proc = new Proc(this.mBsi, processName);
                proc.readFromParcelLocked(in);
                this.mProcessStats.put(processName, proc);
            }
            int numPkgs = in.readInt();
            this.mPackageStats.clear();
            for (int l = 0; l < numPkgs; ++l) {
                String packageName = in.readString();
                Pkg pkg = new Pkg(this.mBsi);
                pkg.readFromParcelLocked(in);
                this.mPackageStats.put(packageName, pkg);
            }
            this.mWifiRunning = false;
            this.mWifiRunningTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClock, this, 4, this.mBsi.mWifiRunningTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mFullWifiLockOut = false;
            this.mFullWifiLockTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClock, this, 5, this.mBsi.mFullWifiLockTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mWifiScanStarted = false;
            this.mWifiScanTimer = in.readInt() != 0 ? new DualTimer(this.mBsi.mClock, this, 6, this.mBsi.mWifiScanTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in) : null;
            this.mWifiBatchedScanBinStarted = -1;
            for (i = 0; i < 5; ++i) {
                if (in.readInt() != 0) {
                    this.makeWifiBatchedScanBin(i, in);
                    continue;
                }
                this.mWifiBatchedScanTimer[i] = null;
            }
            this.mWifiMulticastWakelockCount = 0;
            this.mWifiMulticastTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClock, this, 7, this.mBsi.mWifiMulticastTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mAudioTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClock, this, 15, this.mBsi.mAudioTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mVideoTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClock, this, 8, this.mBsi.mVideoTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mFlashlightTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClock, this, 16, this.mBsi.mFlashlightTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mCameraTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClock, this, 17, this.mBsi.mCameraTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mForegroundActivityTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClock, this, 10, null, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mForegroundServiceTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClock, this, 22, null, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mAggregatedPartialWakelockTimer = in.readInt() != 0 ? new DualTimer(this.mBsi.mClock, this, 20, null, this.mBsi.mOnBatteryScreenOffTimeBase, this.mOnBatteryScreenOffBackgroundTimeBase, in) : null;
            this.mBluetoothScanTimer = in.readInt() != 0 ? new DualTimer(this.mBsi.mClock, this, 19, this.mBsi.mBluetoothScanOnTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in) : null;
            this.mBluetoothUnoptimizedScanTimer = in.readInt() != 0 ? new DualTimer(this.mBsi.mClock, this, 21, null, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in) : null;
            this.mBluetoothScanResultCounter = in.readInt() != 0 ? new Counter(this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mBluetoothScanResultBgCounter = in.readInt() != 0 ? new Counter(this.mOnBatteryBackgroundTimeBase, in) : null;
            this.mProcessState = 7;
            for (i = 0; i < 7; ++i) {
                if (in.readInt() != 0) {
                    this.makeProcessState(i, in);
                    continue;
                }
                this.mProcessStateTimer[i] = null;
            }
            this.mVibratorOnTimer = in.readInt() != 0 ? new BatchTimer(this.mBsi.mClock, this, 9, this.mBsi.mOnBatteryTimeBase, in) : null;
            if (in.readInt() != 0) {
                this.mUserActivityCounters = new Counter[NUM_USER_ACTIVITY_TYPES];
                for (i = 0; i < NUM_USER_ACTIVITY_TYPES; ++i) {
                    this.mUserActivityCounters[i] = new Counter(this.mBsi.mOnBatteryTimeBase, in);
                }
            } else {
                this.mUserActivityCounters = null;
            }
            if (in.readInt() != 0) {
                this.mNetworkByteActivityCounters = new LongSamplingCounter[10];
                this.mNetworkPacketActivityCounters = new LongSamplingCounter[10];
                for (i = 0; i < 10; ++i) {
                    this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                    this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                }
                if (in.readBoolean()) {
                    this.mMobileRadioActiveTime = TimeMultiStateCounter.readFromParcel(in, this.mBsi.mOnBatteryTimeBase, 5, timestampMs);
                }
                this.mMobileRadioActiveCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            } else {
                this.mNetworkByteActivityCounters = null;
                this.mNetworkPacketActivityCounters = null;
            }
            this.mWifiControllerActivity = in.readInt() != 0 ? new ControllerActivityCounterImpl(this.mBsi.mClock, this.mBsi.mOnBatteryTimeBase, 1, in) : null;
            this.mBluetoothControllerActivity = in.readInt() != 0 ? new ControllerActivityCounterImpl(this.mBsi.mClock, this.mBsi.mOnBatteryTimeBase, 1, in) : null;
            this.mModemControllerActivity = in.readInt() != 0 ? new ControllerActivityCounterImpl(this.mBsi.mClock, this.mBsi.mOnBatteryTimeBase, ModemActivityInfo.getNumTxPowerLevels(), in) : null;
            if (in.readInt() != 0) {
                this.mUidMeasuredEnergyStats = new MeasuredEnergyStats(this.mBsi.mMeasuredEnergyStatsConfig, in);
            }
            this.mUserCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            this.mSystemCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            this.mCpuClusterSpeedTimesUs = this.mBsi.readCpuSpeedCountersFromParcel(in);
            this.mCpuFreqTimeMs = LongSamplingCounterArray.readFromParcel(in, this.mBsi.mOnBatteryTimeBase);
            this.mScreenOffCpuFreqTimeMs = LongSamplingCounterArray.readFromParcel(in, this.mBsi.mOnBatteryScreenOffTimeBase);
            int stateCount = in.readInt();
            if (stateCount != 0) {
                this.mCpuActiveTimeMs = TimeMultiStateCounter.readFromParcel(in, this.mBsi.mOnBatteryTimeBase, 5, timestampMs);
            }
            this.mCpuClusterTimesMs = new LongSamplingCounterArray(this.mBsi.mOnBatteryTimeBase, in);
            stateCount = in.readInt();
            this.mProcStateTimeMs = stateCount != 0 ? TimeInFreqMultiStateCounter.readFromParcel(in, this.mBsi.mOnBatteryTimeBase, 8, this.mBsi.getCpuFreqCount(), this.mBsi.mClock.elapsedRealtime()) : null;
            stateCount = in.readInt();
            this.mProcStateScreenOffTimeMs = stateCount != 0 ? TimeInFreqMultiStateCounter.readFromParcel(in, this.mBsi.mOnBatteryScreenOffTimeBase, 8, this.mBsi.getCpuFreqCount(), this.mBsi.mClock.elapsedRealtime()) : null;
            this.mMobileRadioApWakeupCount = in.readInt() != 0 ? new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mWifiRadioApWakeupCount = in.readInt() != 0 ? new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mProportionalSystemServiceUsage = in.readDouble();
        }

        public void noteJobsDeferredLocked(int numDeferred, long sinceLast) {
            this.mJobsDeferredEventCount.addAtomic(1);
            this.mJobsDeferredCount.addAtomic(numDeferred);
            if (sinceLast != 0L) {
                this.mJobsFreshnessTimeMs.addCountLocked(sinceLast);
                for (int i = 0; i < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i) {
                    if (sinceLast >= BatteryStats.JOB_FRESHNESS_BUCKETS[i]) continue;
                    if (this.mJobsFreshnessBuckets[i] == null) {
                        this.mJobsFreshnessBuckets[i] = new Counter(this.mBsi.mOnBatteryTimeBase);
                    }
                    this.mJobsFreshnessBuckets[i].addAtomic(1);
                    break;
                }
            }
        }

        public void noteBinderCallStatsLocked(long incrementalCallCount, Collection<BinderCallsStats.CallStat> callStats) {
            this.mBinderCallCount += incrementalCallCount;
            for (BinderCallsStats.CallStat stat : callStats) {
                BinderCallStats bcs;
                Uid.sTempBinderCallStats.binderClass = stat.binderClass;
                Uid.sTempBinderCallStats.transactionCode = stat.transactionCode;
                int index = this.mBinderCallStats.indexOf(sTempBinderCallStats);
                if (index >= 0) {
                    bcs = this.mBinderCallStats.valueAt(index);
                } else {
                    bcs = new BinderCallStats();
                    bcs.binderClass = stat.binderClass;
                    bcs.transactionCode = stat.transactionCode;
                    this.mBinderCallStats.add(bcs);
                }
                bcs.callCount += stat.incrementalCallCount;
                bcs.recordedCallCount = stat.recordedCallCount;
                bcs.recordedCpuTimeMicros = stat.cpuTimeMicros;
            }
        }

        public Proc getProcessStatsLocked(String name) {
            Proc ps = this.mProcessStats.get(name);
            if (ps == null) {
                ps = new Proc(this.mBsi, name);
                this.mProcessStats.put(name, ps);
            }
            return ps;
        }

        @GuardedBy(value={"mBsi"})
        public void updateUidProcessStateLocked(int procState, long elapsedRealtimeMs, long uptimeMs) {
            boolean userAwareService = ActivityManager.isForegroundService(procState);
            int uidRunningState = BatteryStats.mapToInternalProcessState(procState);
            if (this.mProcessState == uidRunningState && userAwareService == this.mInForegroundService) {
                return;
            }
            if (this.mProcessState != uidRunningState) {
                MeasuredEnergyStats energyStats;
                ControllerActivityCounterImpl bluetoothControllerActivity;
                if (this.mProcessState != 7) {
                    this.mProcessStateTimer[this.mProcessState].stopRunningLocked(elapsedRealtimeMs);
                }
                if (uidRunningState != 7) {
                    if (this.mProcessStateTimer[uidRunningState] == null) {
                        this.makeProcessState(uidRunningState, null);
                    }
                    this.mProcessStateTimer[uidRunningState].startRunningLocked(elapsedRealtimeMs);
                }
                if (this.mBsi.trackPerProcStateCpuTimes()) {
                    this.mBsi.updateProcStateCpuTimesLocked(this.mUid, elapsedRealtimeMs);
                    LongArrayMultiStateCounter onBatteryCounter = this.getProcStateTimeCounter(elapsedRealtimeMs).getCounter();
                    LongArrayMultiStateCounter onBatteryScreenOffCounter = this.getProcStateScreenOffTimeCounter(elapsedRealtimeMs).getCounter();
                    onBatteryCounter.setState(uidRunningState, elapsedRealtimeMs);
                    onBatteryScreenOffCounter.setState(uidRunningState, elapsedRealtimeMs);
                }
                int prevBatteryConsumerProcessState = BatteryStats.mapUidProcessStateToBatteryConsumerProcessState(this.mProcessState);
                this.mProcessState = uidRunningState;
                this.updateOnBatteryBgTimeBase(uptimeMs * 1000L, elapsedRealtimeMs * 1000L);
                this.updateOnBatteryScreenOffBgTimeBase(uptimeMs * 1000L, elapsedRealtimeMs * 1000L);
                int batteryConsumerProcessState = BatteryStats.mapUidProcessStateToBatteryConsumerProcessState(uidRunningState);
                this.getCpuActiveTimeCounter().setState(batteryConsumerProcessState, elapsedRealtimeMs);
                this.getMobileRadioActiveTimeCounter().setState(batteryConsumerProcessState, elapsedRealtimeMs);
                ControllerActivityCounterImpl wifiControllerActivity = this.getWifiControllerActivity();
                if (wifiControllerActivity != null) {
                    wifiControllerActivity.setState(batteryConsumerProcessState, elapsedRealtimeMs);
                }
                if ((bluetoothControllerActivity = this.getBluetoothControllerActivity()) != null) {
                    bluetoothControllerActivity.setState(batteryConsumerProcessState, elapsedRealtimeMs);
                }
                if ((energyStats = this.getOrCreateMeasuredEnergyStatsIfSupportedLocked()) != null) {
                    energyStats.setState(batteryConsumerProcessState, elapsedRealtimeMs);
                }
                this.maybeScheduleExternalStatsSync(prevBatteryConsumerProcessState, batteryConsumerProcessState);
            }
            if (userAwareService != this.mInForegroundService) {
                if (userAwareService) {
                    this.noteForegroundServiceResumedLocked(elapsedRealtimeMs);
                } else {
                    this.noteForegroundServicePausedLocked(elapsedRealtimeMs);
                }
                this.mInForegroundService = userAwareService;
            }
        }

        @GuardedBy(value={"mBsi"})
        private void maybeScheduleExternalStatsSync(int oldProcessState, int newProcessState) {
            if (oldProcessState == newProcessState) {
                return;
            }
            if (oldProcessState == 0 && newProcessState == 2 || oldProcessState == 2 && newProcessState == 0) {
                return;
            }
            int flags = 14;
            if (!BatteryStatsImpl.isActiveRadioPowerState(this.mBsi.mMobileRadioPowerState)) {
                flags &= 0xFFFFFFFB;
            }
            this.mBsi.mExternalSync.scheduleSyncDueToProcessStateChange(flags, this.mBsi.mConstants.PROC_STATE_CHANGE_COLLECTION_DELAY_MS);
        }

        public boolean isInBackground() {
            return this.mProcessState >= 3;
        }

        public boolean updateOnBatteryBgTimeBase(long uptimeUs, long realtimeUs) {
            boolean on = this.mBsi.mOnBatteryTimeBase.isRunning() && this.isInBackground();
            return this.mOnBatteryBackgroundTimeBase.setRunning(on, uptimeUs, realtimeUs);
        }

        public boolean updateOnBatteryScreenOffBgTimeBase(long uptimeUs, long realtimeUs) {
            boolean on = this.mBsi.mOnBatteryScreenOffTimeBase.isRunning() && this.isInBackground();
            return this.mOnBatteryScreenOffBackgroundTimeBase.setRunning(on, uptimeUs, realtimeUs);
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Pid> getPidStats() {
            return this.mPids;
        }

        public BatteryStats.Uid.Pid getPidStatsLocked(int pid) {
            BatteryStats.Uid.Pid p = this.mPids.get(pid);
            if (p == null) {
                p = new BatteryStats.Uid.Pid();
                this.mPids.put(pid, p);
            }
            return p;
        }

        public Pkg getPackageStatsLocked(String name) {
            Pkg ps = this.mPackageStats.get(name);
            if (ps == null) {
                ps = new Pkg(this.mBsi);
                this.mPackageStats.put(name, ps);
            }
            return ps;
        }

        public Pkg.Serv getServiceStatsLocked(String pkg, String serv) {
            Pkg ps = this.getPackageStatsLocked(pkg);
            Pkg.Serv ss = ps.mServiceStats.get(serv);
            if (ss == null) {
                ss = ps.newServiceStatsLocked();
                ps.mServiceStats.put(serv, ss);
            }
            return ss;
        }

        public void readSyncSummaryFromParcelLocked(String name, Parcel in) {
            DualTimer timer = this.mSyncStats.instantiateObject();
            timer.readSummaryFromParcelLocked(in);
            this.mSyncStats.add(name, timer);
        }

        public void readJobSummaryFromParcelLocked(String name, Parcel in) {
            DualTimer timer = this.mJobStats.instantiateObject();
            timer.readSummaryFromParcelLocked(in);
            this.mJobStats.add(name, timer);
        }

        public void readWakeSummaryFromParcelLocked(String wlName, Parcel in) {
            Wakelock wl = new Wakelock(this.mBsi, this);
            this.mWakelockStats.add(wlName, wl);
            if (in.readInt() != 0) {
                this.getWakelockTimerLocked(wl, 1).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                this.getWakelockTimerLocked(wl, 0).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                this.getWakelockTimerLocked(wl, 2).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                this.getWakelockTimerLocked(wl, 18).readSummaryFromParcelLocked(in);
            }
        }

        public DualTimer getSensorTimerLocked(int sensor, boolean create) {
            DualTimer t;
            Sensor se = this.mSensorStats.get(sensor);
            if (se == null) {
                if (!create) {
                    return null;
                }
                se = new Sensor(this.mBsi, this, sensor);
                this.mSensorStats.put(sensor, se);
            }
            if ((t = se.mTimer) != null) {
                return t;
            }
            ArrayList<StopwatchTimer> timers = this.mBsi.mSensorTimers.get(sensor);
            if (timers == null) {
                timers = new ArrayList();
                this.mBsi.mSensorTimers.put(sensor, timers);
            }
            se.mTimer = t = new DualTimer(this.mBsi.mClock, this, 3, timers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
            return t;
        }

        public void noteStartSyncLocked(String name, long elapsedRealtimeMs) {
            DualTimer t = this.mSyncStats.startObject(name, elapsedRealtimeMs);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStopSyncLocked(String name, long elapsedRealtimeMs) {
            DualTimer t = this.mSyncStats.stopObject(name, elapsedRealtimeMs);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStartJobLocked(String name, long elapsedRealtimeMs) {
            DualTimer t = this.mJobStats.startObject(name, elapsedRealtimeMs);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStopJobLocked(String name, long elapsedRealtimeMs, int stopReason) {
            DualTimer t = this.mJobStats.stopObject(name, elapsedRealtimeMs);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
            if (this.mBsi.mOnBatteryTimeBase.isRunning()) {
                SparseIntArray types = this.mJobCompletions.get(name);
                if (types == null) {
                    types = new SparseIntArray();
                    this.mJobCompletions.put(name, types);
                }
                int last = types.get(stopReason, 0);
                types.put(stopReason, last + 1);
            }
        }

        public StopwatchTimer getWakelockTimerLocked(Wakelock wl, int type) {
            if (wl == null) {
                return null;
            }
            switch (type) {
                case 0: {
                    DualTimer t = wl.mTimerPartial;
                    if (t == null) {
                        wl.mTimerPartial = t = new DualTimer(this.mBsi.mClock, this, 0, this.mBsi.mPartialTimers, this.mBsi.mOnBatteryScreenOffTimeBase, this.mOnBatteryScreenOffBackgroundTimeBase);
                    }
                    return t;
                }
                case 1: {
                    StopwatchTimer t = wl.mTimerFull;
                    if (t == null) {
                        wl.mTimerFull = t = new StopwatchTimer(this.mBsi.mClock, this, 1, this.mBsi.mFullTimers, this.mBsi.mOnBatteryTimeBase);
                    }
                    return t;
                }
                case 2: {
                    StopwatchTimer t = wl.mTimerWindow;
                    if (t == null) {
                        wl.mTimerWindow = t = new StopwatchTimer(this.mBsi.mClock, this, 2, this.mBsi.mWindowTimers, this.mBsi.mOnBatteryTimeBase);
                    }
                    return t;
                }
                case 18: {
                    StopwatchTimer t = wl.mTimerDraw;
                    if (t == null) {
                        wl.mTimerDraw = t = new StopwatchTimer(this.mBsi.mClock, this, 18, this.mBsi.mDrawTimers, this.mBsi.mOnBatteryTimeBase);
                    }
                    return t;
                }
            }
            throw new IllegalArgumentException("type=" + type);
        }

        public void noteStartWakeLocked(int pid, String name, int type, long elapsedRealtimeMs) {
            Wakelock wl = this.mWakelockStats.startObject(name, elapsedRealtimeMs);
            if (wl != null) {
                this.getWakelockTimerLocked(wl, type).startRunningLocked(elapsedRealtimeMs);
            }
            if (type == 0) {
                this.createAggregatedPartialWakelockTimerLocked().startRunningLocked(elapsedRealtimeMs);
                if (pid >= 0) {
                    BatteryStats.Uid.Pid p = this.getPidStatsLocked(pid);
                    if (p.mWakeNesting++ == 0) {
                        p.mWakeStartMs = elapsedRealtimeMs;
                    }
                }
            }
        }

        public void noteStopWakeLocked(int pid, String name, int type, long elapsedRealtimeMs) {
            Wakelock wl = this.mWakelockStats.stopObject(name, elapsedRealtimeMs);
            if (wl != null) {
                StopwatchTimer wlt = this.getWakelockTimerLocked(wl, type);
                wlt.stopRunningLocked(elapsedRealtimeMs);
            }
            if (type == 0) {
                BatteryStats.Uid.Pid p;
                if (this.mAggregatedPartialWakelockTimer != null) {
                    this.mAggregatedPartialWakelockTimer.stopRunningLocked(elapsedRealtimeMs);
                }
                if (pid >= 0 && (p = this.mPids.get(pid)) != null && p.mWakeNesting > 0 && p.mWakeNesting-- == 1) {
                    p.mWakeSumMs += elapsedRealtimeMs - p.mWakeStartMs;
                    p.mWakeStartMs = 0L;
                }
            }
        }

        public void reportExcessiveCpuLocked(String proc, long overTimeMs, long usedTimeMs) {
            Proc p = this.getProcessStatsLocked(proc);
            if (p != null) {
                p.addExcessiveCpu(overTimeMs, usedTimeMs);
            }
        }

        public void noteStartSensor(int sensor, long elapsedRealtimeMs) {
            DualTimer t = this.getSensorTimerLocked(sensor, true);
            t.startRunningLocked(elapsedRealtimeMs);
        }

        public void noteStopSensor(int sensor, long elapsedRealtimeMs) {
            DualTimer t = this.getSensorTimerLocked(sensor, false);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStartGps(long elapsedRealtimeMs) {
            this.noteStartSensor(-10000, elapsedRealtimeMs);
        }

        public void noteStopGps(long elapsedRealtimeMs) {
            this.noteStopSensor(-10000, elapsedRealtimeMs);
        }

        public BatteryStatsImpl getBatteryStats() {
            return this.mBsi;
        }

        private class ChildUid {
            public final TimeMultiStateCounter cpuActiveCounter;
            public final LongArrayMultiStateCounter cpuTimeInFreqCounter;

            ChildUid() {
                long timestampMs = Uid.this.mBsi.mClock.elapsedRealtime();
                this.cpuActiveCounter = new TimeMultiStateCounter(Uid.this.mBsi.mOnBatteryTimeBase, 1, timestampMs);
                this.cpuActiveCounter.setState(0, timestampMs);
                if (Uid.this.mBsi.trackPerProcStateCpuTimes()) {
                    int cpuFreqCount = Uid.this.mBsi.getCpuFreqCount();
                    this.cpuTimeInFreqCounter = new LongArrayMultiStateCounter(1, cpuFreqCount);
                    this.cpuTimeInFreqCounter.updateValues(new LongArrayMultiStateCounter.LongArrayContainer(cpuFreqCount), timestampMs);
                } else {
                    this.cpuTimeInFreqCounter = null;
                }
            }
        }

        public static class Pkg
        extends BatteryStats.Uid.Pkg
        implements TimeBaseObs {
            protected BatteryStatsImpl mBsi;
            ArrayMap<String, Counter> mWakeupAlarms = new ArrayMap();
            final ArrayMap<String, Serv> mServiceStats = new ArrayMap();

            public Pkg(BatteryStatsImpl bsi) {
                this.mBsi = bsi;
                this.mBsi.mOnBatteryScreenOffTimeBase.add(this);
            }

            @Override
            public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            }

            @Override
            public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            }

            @Override
            public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
                if (detachIfReset) {
                    this.detach();
                }
                return true;
            }

            @Override
            public void detach() {
                int j;
                this.mBsi.mOnBatteryScreenOffTimeBase.remove(this);
                for (j = this.mWakeupAlarms.size() - 1; j >= 0; --j) {
                    BatteryStatsImpl.detachIfNotNull(this.mWakeupAlarms.valueAt(j));
                }
                for (j = this.mServiceStats.size() - 1; j >= 0; --j) {
                    BatteryStatsImpl.detachIfNotNull(this.mServiceStats.valueAt(j));
                }
            }

            void readFromParcelLocked(Parcel in) {
                int numWA = in.readInt();
                this.mWakeupAlarms.clear();
                for (int i = 0; i < numWA; ++i) {
                    String tag = in.readString();
                    this.mWakeupAlarms.put(tag, new Counter(this.mBsi.mOnBatteryScreenOffTimeBase, in));
                }
                int numServs = in.readInt();
                this.mServiceStats.clear();
                for (int m = 0; m < numServs; ++m) {
                    String serviceName = in.readString();
                    Serv serv = new Serv(this.mBsi);
                    this.mServiceStats.put(serviceName, serv);
                    serv.readFromParcelLocked(in);
                }
            }

            void writeToParcelLocked(Parcel out) {
                int numWA = this.mWakeupAlarms.size();
                out.writeInt(numWA);
                for (int i = 0; i < numWA; ++i) {
                    out.writeString(this.mWakeupAlarms.keyAt(i));
                    this.mWakeupAlarms.valueAt(i).writeToParcel(out);
                }
                int NS = this.mServiceStats.size();
                out.writeInt(NS);
                for (int i = 0; i < NS; ++i) {
                    out.writeString(this.mServiceStats.keyAt(i));
                    Serv serv = this.mServiceStats.valueAt(i);
                    serv.writeToParcelLocked(out);
                }
            }

            @Override
            public ArrayMap<String, ? extends BatteryStats.Counter> getWakeupAlarmStats() {
                return this.mWakeupAlarms;
            }

            public void noteWakeupAlarmLocked(String tag) {
                Counter c = this.mWakeupAlarms.get(tag);
                if (c == null) {
                    c = new Counter(this.mBsi.mOnBatteryScreenOffTimeBase);
                    this.mWakeupAlarms.put(tag, c);
                }
                c.stepAtomic();
            }

            @Override
            public ArrayMap<String, ? extends BatteryStats.Uid.Pkg.Serv> getServiceStats() {
                return this.mServiceStats;
            }

            Serv newServiceStatsLocked() {
                return new Serv(this.mBsi);
            }

            public static class Serv
            extends BatteryStats.Uid.Pkg.Serv
            implements TimeBaseObs {
                protected BatteryStatsImpl mBsi;
                protected Pkg mPkg;
                protected long mStartTimeMs;
                protected long mRunningSinceMs;
                protected boolean mRunning;
                protected int mStarts;
                protected long mLaunchedTimeMs;
                protected long mLaunchedSinceMs;
                protected boolean mLaunched;
                protected int mLaunches;

                public Serv(BatteryStatsImpl bsi) {
                    this.mBsi = bsi;
                    this.mBsi.mOnBatteryTimeBase.add(this);
                }

                @Override
                public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
                }

                @Override
                public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
                }

                @Override
                public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
                    if (detachIfReset) {
                        this.detach();
                    }
                    return true;
                }

                @Override
                public void detach() {
                    this.mBsi.mOnBatteryTimeBase.remove(this);
                }

                public void readFromParcelLocked(Parcel in) {
                    this.mStartTimeMs = in.readLong();
                    this.mRunningSinceMs = in.readLong();
                    this.mRunning = in.readInt() != 0;
                    this.mStarts = in.readInt();
                    this.mLaunchedTimeMs = in.readLong();
                    this.mLaunchedSinceMs = in.readLong();
                    this.mLaunched = in.readInt() != 0;
                    this.mLaunches = in.readInt();
                }

                public void writeToParcelLocked(Parcel out) {
                    out.writeLong(this.mStartTimeMs);
                    out.writeLong(this.mRunningSinceMs);
                    out.writeInt(this.mRunning ? 1 : 0);
                    out.writeInt(this.mStarts);
                    out.writeLong(this.mLaunchedTimeMs);
                    out.writeLong(this.mLaunchedSinceMs);
                    out.writeInt(this.mLaunched ? 1 : 0);
                    out.writeInt(this.mLaunches);
                }

                public long getLaunchTimeToNowLocked(long batteryUptimeMs) {
                    if (!this.mLaunched) {
                        return this.mLaunchedTimeMs;
                    }
                    return this.mLaunchedTimeMs + batteryUptimeMs - this.mLaunchedSinceMs;
                }

                public long getStartTimeToNowLocked(long batteryUptimeMs) {
                    if (!this.mRunning) {
                        return this.mStartTimeMs;
                    }
                    return this.mStartTimeMs + batteryUptimeMs - this.mRunningSinceMs;
                }

                @UnsupportedAppUsage
                public void startLaunchedLocked() {
                    this.startLaunchedLocked(this.mBsi.mClock.uptimeMillis());
                }

                public void startLaunchedLocked(long uptimeMs) {
                    if (!this.mLaunched) {
                        ++this.mLaunches;
                        this.mLaunchedSinceMs = this.mBsi.getBatteryUptimeLocked(uptimeMs) / 1000L;
                        this.mLaunched = true;
                    }
                }

                @UnsupportedAppUsage
                public void stopLaunchedLocked() {
                    this.stopLaunchedLocked(this.mBsi.mClock.uptimeMillis());
                }

                public void stopLaunchedLocked(long uptimeMs) {
                    if (this.mLaunched) {
                        long timeMs = this.mBsi.getBatteryUptimeLocked(uptimeMs) / 1000L - this.mLaunchedSinceMs;
                        if (timeMs > 0L) {
                            this.mLaunchedTimeMs += timeMs;
                        } else {
                            --this.mLaunches;
                        }
                        this.mLaunched = false;
                    }
                }

                @UnsupportedAppUsage
                public void startRunningLocked() {
                    this.startRunningLocked(this.mBsi.mClock.uptimeMillis());
                }

                public void startRunningLocked(long uptimeMs) {
                    if (!this.mRunning) {
                        ++this.mStarts;
                        this.mRunningSinceMs = this.mBsi.getBatteryUptimeLocked(uptimeMs) / 1000L;
                        this.mRunning = true;
                    }
                }

                @UnsupportedAppUsage
                public void stopRunningLocked() {
                    this.stopRunningLocked(this.mBsi.mClock.uptimeMillis());
                }

                public void stopRunningLocked(long uptimeMs) {
                    if (this.mRunning) {
                        long timeMs = this.mBsi.getBatteryUptimeLocked(uptimeMs) / 1000L - this.mRunningSinceMs;
                        if (timeMs > 0L) {
                            this.mStartTimeMs += timeMs;
                        } else {
                            --this.mStarts;
                        }
                        this.mRunning = false;
                    }
                }

                @UnsupportedAppUsage
                public BatteryStatsImpl getBatteryStats() {
                    return this.mBsi;
                }

                @Override
                public int getLaunches(int which) {
                    return this.mLaunches;
                }

                @Override
                public long getStartTime(long now, int which) {
                    return this.getStartTimeToNowLocked(now);
                }

                @Override
                public int getStarts(int which) {
                    return this.mStarts;
                }
            }
        }

        public static class Proc
        extends BatteryStats.Uid.Proc
        implements TimeBaseObs {
            protected BatteryStatsImpl mBsi;
            final String mName;
            boolean mActive = true;
            long mUserTimeMs;
            long mSystemTimeMs;
            long mForegroundTimeMs;
            int mStarts;
            int mNumCrashes;
            int mNumAnrs;
            ArrayList<BatteryStats.Uid.Proc.ExcessivePower> mExcessivePower;

            public Proc(BatteryStatsImpl bsi, String name) {
                this.mBsi = bsi;
                this.mName = name;
                this.mBsi.mOnBatteryTimeBase.add(this);
            }

            @Override
            public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            }

            @Override
            public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            }

            @Override
            public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
                if (detachIfReset) {
                    this.detach();
                }
                return true;
            }

            @Override
            public void detach() {
                this.mActive = false;
                this.mBsi.mOnBatteryTimeBase.remove(this);
            }

            @Override
            public int countExcessivePowers() {
                return this.mExcessivePower != null ? this.mExcessivePower.size() : 0;
            }

            @Override
            public BatteryStats.Uid.Proc.ExcessivePower getExcessivePower(int i) {
                if (this.mExcessivePower != null) {
                    return this.mExcessivePower.get(i);
                }
                return null;
            }

            public void addExcessiveCpu(long overTimeMs, long usedTimeMs) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                ew.type = 2;
                ew.overTime = overTimeMs;
                ew.usedTime = usedTimeMs;
                this.mExcessivePower.add(ew);
            }

            void writeExcessivePowerToParcelLocked(Parcel out) {
                if (this.mExcessivePower == null) {
                    out.writeInt(0);
                    return;
                }
                int N = this.mExcessivePower.size();
                out.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = this.mExcessivePower.get(i);
                    out.writeInt(ew.type);
                    out.writeLong(ew.overTime);
                    out.writeLong(ew.usedTime);
                }
            }

            void readExcessivePowerFromParcelLocked(Parcel in) {
                int N = in.readInt();
                if (N == 0) {
                    this.mExcessivePower = null;
                    return;
                }
                if (N > 10000) {
                    throw new ParcelFormatException("File corrupt: too many excessive power entries " + N);
                }
                this.mExcessivePower = new ArrayList();
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                    ew.type = in.readInt();
                    ew.overTime = in.readLong();
                    ew.usedTime = in.readLong();
                    this.mExcessivePower.add(ew);
                }
            }

            void writeToParcelLocked(Parcel out) {
                out.writeLong(this.mUserTimeMs);
                out.writeLong(this.mSystemTimeMs);
                out.writeLong(this.mForegroundTimeMs);
                out.writeInt(this.mStarts);
                out.writeInt(this.mNumCrashes);
                out.writeInt(this.mNumAnrs);
                this.writeExcessivePowerToParcelLocked(out);
            }

            void readFromParcelLocked(Parcel in) {
                this.mUserTimeMs = in.readLong();
                this.mSystemTimeMs = in.readLong();
                this.mForegroundTimeMs = in.readLong();
                this.mStarts = in.readInt();
                this.mNumCrashes = in.readInt();
                this.mNumAnrs = in.readInt();
                this.readExcessivePowerFromParcelLocked(in);
            }

            @UnsupportedAppUsage
            public void addCpuTimeLocked(int utimeMs, int stimeMs) {
                this.addCpuTimeLocked(utimeMs, stimeMs, this.mBsi.mOnBatteryTimeBase.isRunning());
            }

            public void addCpuTimeLocked(int utimeMs, int stimeMs, boolean isRunning) {
                if (isRunning) {
                    this.mUserTimeMs += (long)utimeMs;
                    this.mSystemTimeMs += (long)stimeMs;
                }
            }

            @UnsupportedAppUsage
            public void addForegroundTimeLocked(long ttimeMs) {
                this.mForegroundTimeMs += ttimeMs;
            }

            @UnsupportedAppUsage
            public void incStartsLocked() {
                ++this.mStarts;
            }

            public void incNumCrashesLocked() {
                ++this.mNumCrashes;
            }

            public void incNumAnrsLocked() {
                ++this.mNumAnrs;
            }

            @Override
            public boolean isActive() {
                return this.mActive;
            }

            @Override
            @UnsupportedAppUsage
            public long getUserTime(int which) {
                return this.mUserTimeMs;
            }

            @Override
            @UnsupportedAppUsage
            public long getSystemTime(int which) {
                return this.mSystemTimeMs;
            }

            @Override
            @UnsupportedAppUsage
            public long getForegroundTime(int which) {
                return this.mForegroundTimeMs;
            }

            @Override
            @UnsupportedAppUsage
            public int getStarts(int which) {
                return this.mStarts;
            }

            @Override
            public int getNumCrashes(int which) {
                return this.mNumCrashes;
            }

            @Override
            public int getNumAnrs(int which) {
                return this.mNumAnrs;
            }
        }

        public static class Sensor
        extends BatteryStats.Uid.Sensor {
            protected BatteryStatsImpl mBsi;
            protected Uid mUid;
            final int mHandle;
            DualTimer mTimer;

            public Sensor(BatteryStatsImpl bsi, Uid uid, int handle) {
                this.mBsi = bsi;
                this.mUid = uid;
                this.mHandle = handle;
            }

            private DualTimer readTimersFromParcel(TimeBase timeBase, TimeBase bgTimeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                ArrayList<StopwatchTimer> pool = this.mBsi.mSensorTimers.get(this.mHandle);
                if (pool == null) {
                    pool = new ArrayList();
                    this.mBsi.mSensorTimers.put(this.mHandle, pool);
                }
                return new DualTimer(this.mBsi.mClock, this.mUid, 0, pool, timeBase, bgTimeBase, in);
            }

            boolean reset(long elapsedRealtimeUs) {
                if (this.mTimer.reset(true, elapsedRealtimeUs)) {
                    this.mTimer = null;
                    return true;
                }
                return false;
            }

            void readFromParcelLocked(TimeBase timeBase, TimeBase bgTimeBase, Parcel in) {
                this.mTimer = this.readTimersFromParcel(timeBase, bgTimeBase, in);
            }

            void writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
                Timer.writeTimerToParcel(out, this.mTimer, elapsedRealtimeUs);
            }

            @Override
            @UnsupportedAppUsage
            public Timer getSensorTime() {
                return this.mTimer;
            }

            @Override
            public Timer getSensorBackgroundTime() {
                if (this.mTimer == null) {
                    return null;
                }
                return this.mTimer.getSubTimer();
            }

            @Override
            @UnsupportedAppUsage
            public int getHandle() {
                return this.mHandle;
            }

            public void detachFromTimeBase() {
                BatteryStatsImpl.detachIfNotNull(this.mTimer);
            }
        }

        public static class Wakelock
        extends BatteryStats.Uid.Wakelock {
            protected BatteryStatsImpl mBsi;
            protected Uid mUid;
            DualTimer mTimerPartial;
            StopwatchTimer mTimerFull;
            StopwatchTimer mTimerWindow;
            StopwatchTimer mTimerDraw;

            public Wakelock(BatteryStatsImpl bsi, Uid uid) {
                this.mBsi = bsi;
                this.mUid = uid;
            }

            private StopwatchTimer readStopwatchTimerFromParcel(int type, ArrayList<StopwatchTimer> pool, TimeBase timeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                return new StopwatchTimer(this.mBsi.mClock, this.mUid, type, pool, timeBase, in);
            }

            private DualTimer readDualTimerFromParcel(int type, ArrayList<StopwatchTimer> pool, TimeBase timeBase, TimeBase bgTimeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                return new DualTimer(this.mBsi.mClock, this.mUid, type, pool, timeBase, bgTimeBase, in);
            }

            boolean reset(long elapsedRealtimeUs) {
                boolean wlactive = false;
                wlactive |= !BatteryStatsImpl.resetIfNotNull(this.mTimerFull, false, elapsedRealtimeUs);
                wlactive |= !BatteryStatsImpl.resetIfNotNull(this.mTimerPartial, false, elapsedRealtimeUs);
                wlactive |= !BatteryStatsImpl.resetIfNotNull(this.mTimerWindow, false, elapsedRealtimeUs);
                if (!(wlactive |= !BatteryStatsImpl.resetIfNotNull(this.mTimerDraw, false, elapsedRealtimeUs))) {
                    BatteryStatsImpl.detachIfNotNull(this.mTimerFull);
                    this.mTimerFull = null;
                    BatteryStatsImpl.detachIfNotNull(this.mTimerPartial);
                    this.mTimerPartial = null;
                    BatteryStatsImpl.detachIfNotNull(this.mTimerWindow);
                    this.mTimerWindow = null;
                    BatteryStatsImpl.detachIfNotNull(this.mTimerDraw);
                    this.mTimerDraw = null;
                }
                return !wlactive;
            }

            void readFromParcelLocked(TimeBase timeBase, TimeBase screenOffTimeBase, TimeBase screenOffBgTimeBase, Parcel in) {
                this.mTimerPartial = this.readDualTimerFromParcel(0, this.mBsi.mPartialTimers, screenOffTimeBase, screenOffBgTimeBase, in);
                this.mTimerFull = this.readStopwatchTimerFromParcel(1, this.mBsi.mFullTimers, timeBase, in);
                this.mTimerWindow = this.readStopwatchTimerFromParcel(2, this.mBsi.mWindowTimers, timeBase, in);
                this.mTimerDraw = this.readStopwatchTimerFromParcel(18, this.mBsi.mDrawTimers, timeBase, in);
            }

            void writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
                Timer.writeTimerToParcel(out, this.mTimerPartial, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerFull, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerWindow, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerDraw, elapsedRealtimeUs);
            }

            @Override
            @UnsupportedAppUsage
            public Timer getWakeTime(int type) {
                switch (type) {
                    case 1: {
                        return this.mTimerFull;
                    }
                    case 0: {
                        return this.mTimerPartial;
                    }
                    case 2: {
                        return this.mTimerWindow;
                    }
                    case 18: {
                        return this.mTimerDraw;
                    }
                }
                throw new IllegalArgumentException("type = " + type);
            }

            public void detachFromTimeBase() {
                BatteryStatsImpl.detachIfNotNull(this.mTimerPartial);
                BatteryStatsImpl.detachIfNotNull(this.mTimerFull);
                BatteryStatsImpl.detachIfNotNull(this.mTimerWindow);
                BatteryStatsImpl.detachIfNotNull(this.mTimerDraw);
            }
        }
    }

    @VisibleForTesting
    protected static class BinderCallStats {
        static final Comparator<BinderCallStats> COMPARATOR = Comparator.comparing(BinderCallStats::getClassName).thenComparing(BinderCallStats::getMethodName);
        public Class<? extends Binder> binderClass;
        public int transactionCode;
        public String methodName;
        public long callCount;
        public long recordedCallCount;
        public long recordedCpuTimeMicros;

        protected BinderCallStats() {
        }

        public int hashCode() {
            return this.binderClass.hashCode() * 31 + this.transactionCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BinderCallStats)) {
                return false;
            }
            BinderCallStats bcsk = (BinderCallStats)obj;
            return this.binderClass.equals(bcsk.binderClass) && this.transactionCode == bcsk.transactionCode;
        }

        public String getClassName() {
            return this.binderClass.getName();
        }

        public String getMethodName() {
            return this.methodName;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void ensureMethodName(BinderTransactionNameResolver resolver) {
            if (this.methodName == null) {
                this.methodName = resolver.getMethodName(this.binderClass, this.transactionCode);
            }
        }

        public String toString() {
            return "BinderCallStats{" + this.binderClass + " transaction=" + this.transactionCode + " callCount=" + this.callCount + " recordedCallCount=" + this.recordedCallCount + " recorderCpuTimeMicros=" + this.recordedCpuTimeMicros + "}";
        }
    }

    public static class ControllerActivityCounterImpl
    extends BatteryStats.ControllerActivityCounter
    implements Parcelable {
        private final Clock mClock;
        private final TimeBase mTimeBase;
        private int mNumTxStates;
        private int mProcessState;
        private TimeMultiStateCounter mIdleTimeMillis;
        private final LongSamplingCounter mScanTimeMillis;
        private final LongSamplingCounter mSleepTimeMillis;
        private TimeMultiStateCounter mRxTimeMillis;
        private TimeMultiStateCounter[] mTxTimeMillis;
        private final LongSamplingCounter mPowerDrainMaMs;
        private final LongSamplingCounter mMonitoredRailChargeConsumedMaMs;

        public ControllerActivityCounterImpl(Clock clock, TimeBase timeBase, int numTxStates) {
            this.mClock = clock;
            this.mTimeBase = timeBase;
            this.mNumTxStates = numTxStates;
            this.mScanTimeMillis = new LongSamplingCounter(timeBase);
            this.mSleepTimeMillis = new LongSamplingCounter(timeBase);
            this.mPowerDrainMaMs = new LongSamplingCounter(timeBase);
            this.mMonitoredRailChargeConsumedMaMs = new LongSamplingCounter(timeBase);
        }

        public ControllerActivityCounterImpl(Clock clock, TimeBase timeBase, int numTxStates, Parcel in) {
            this.mClock = clock;
            this.mTimeBase = timeBase;
            this.mNumTxStates = numTxStates;
            this.mIdleTimeMillis = this.readTimeMultiStateCounter(in, timeBase);
            this.mScanTimeMillis = new LongSamplingCounter(timeBase, in);
            this.mSleepTimeMillis = new LongSamplingCounter(timeBase, in);
            this.mRxTimeMillis = this.readTimeMultiStateCounter(in, timeBase);
            this.mTxTimeMillis = this.readTimeMultiStateCounters(in, timeBase, numTxStates);
            this.mPowerDrainMaMs = new LongSamplingCounter(timeBase, in);
            this.mMonitoredRailChargeConsumedMaMs = new LongSamplingCounter(timeBase, in);
        }

        public void readSummaryFromParcel(Parcel in) {
            this.mIdleTimeMillis = this.readTimeMultiStateCounter(in, this.mTimeBase);
            this.mScanTimeMillis.readSummaryFromParcelLocked(in);
            this.mSleepTimeMillis.readSummaryFromParcelLocked(in);
            this.mRxTimeMillis = this.readTimeMultiStateCounter(in, this.mTimeBase);
            this.mTxTimeMillis = this.readTimeMultiStateCounters(in, this.mTimeBase, this.mNumTxStates);
            this.mPowerDrainMaMs.readSummaryFromParcelLocked(in);
            this.mMonitoredRailChargeConsumedMaMs.readSummaryFromParcelLocked(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public void writeSummaryToParcel(Parcel dest) {
            this.writeTimeMultiStateCounter(dest, this.mIdleTimeMillis);
            this.mScanTimeMillis.writeSummaryFromParcelLocked(dest);
            this.mSleepTimeMillis.writeSummaryFromParcelLocked(dest);
            this.writeTimeMultiStateCounter(dest, this.mRxTimeMillis);
            this.writeTimeMultiStateCounters(dest, this.mTxTimeMillis);
            this.mPowerDrainMaMs.writeSummaryFromParcelLocked(dest);
            this.mMonitoredRailChargeConsumedMaMs.writeSummaryFromParcelLocked(dest);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.writeTimeMultiStateCounter(dest, this.mIdleTimeMillis);
            this.mScanTimeMillis.writeToParcel(dest);
            this.mSleepTimeMillis.writeToParcel(dest);
            this.writeTimeMultiStateCounter(dest, this.mRxTimeMillis);
            this.writeTimeMultiStateCounters(dest, this.mTxTimeMillis);
            this.mPowerDrainMaMs.writeToParcel(dest);
            this.mMonitoredRailChargeConsumedMaMs.writeToParcel(dest);
        }

        private TimeMultiStateCounter readTimeMultiStateCounter(Parcel in, TimeBase timeBase) {
            if (in.readBoolean()) {
                return TimeMultiStateCounter.readFromParcel(in, timeBase, 5, this.mClock.elapsedRealtime());
            }
            return null;
        }

        private void writeTimeMultiStateCounter(Parcel dest, TimeMultiStateCounter counter) {
            if (counter != null) {
                dest.writeBoolean(true);
                counter.writeToParcel(dest);
            } else {
                dest.writeBoolean(false);
            }
        }

        private TimeMultiStateCounter[] readTimeMultiStateCounters(Parcel in, TimeBase timeBase, int expectedNumCounters) {
            if (in.readBoolean()) {
                int numCounters = in.readInt();
                boolean valid = numCounters == expectedNumCounters;
                TimeMultiStateCounter[] counters = new TimeMultiStateCounter[numCounters];
                for (int i = 0; i < numCounters; ++i) {
                    TimeMultiStateCounter counter = TimeMultiStateCounter.readFromParcel(in, timeBase, 5, this.mClock.elapsedRealtime());
                    if (counter != null) {
                        counters[i] = counter;
                        continue;
                    }
                    valid = false;
                }
                if (valid) {
                    return counters;
                }
            }
            return null;
        }

        private void writeTimeMultiStateCounters(Parcel dest, TimeMultiStateCounter[] counters) {
            if (counters != null) {
                dest.writeBoolean(true);
                dest.writeInt(counters.length);
                for (TimeMultiStateCounter counter : counters) {
                    counter.writeToParcel(dest);
                }
            } else {
                dest.writeBoolean(false);
            }
        }

        public void reset(boolean detachIfReset, long elapsedRealtimeUs) {
            BatteryStatsImpl.resetIfNotNull(this.mIdleTimeMillis, detachIfReset, elapsedRealtimeUs);
            this.mScanTimeMillis.reset(detachIfReset, elapsedRealtimeUs);
            this.mSleepTimeMillis.reset(detachIfReset, elapsedRealtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mRxTimeMillis, detachIfReset, elapsedRealtimeUs);
            BatteryStatsImpl.resetIfNotNull(this.mTxTimeMillis, detachIfReset, elapsedRealtimeUs);
            this.mPowerDrainMaMs.reset(detachIfReset, elapsedRealtimeUs);
            this.mMonitoredRailChargeConsumedMaMs.reset(detachIfReset, elapsedRealtimeUs);
        }

        public void detach() {
            BatteryStatsImpl.detachIfNotNull(this.mIdleTimeMillis);
            this.mScanTimeMillis.detach();
            this.mSleepTimeMillis.detach();
            BatteryStatsImpl.detachIfNotNull(this.mRxTimeMillis);
            BatteryStatsImpl.detachIfNotNull(this.mTxTimeMillis);
            this.mPowerDrainMaMs.detach();
            this.mMonitoredRailChargeConsumedMaMs.detach();
        }

        @Override
        public BatteryStats.LongCounter getIdleTimeCounter() {
            if (this.mIdleTimeMillis == null) {
                return ZERO_LONG_COUNTER;
            }
            return this.mIdleTimeMillis;
        }

        private TimeMultiStateCounter getOrCreateIdleTimeCounter() {
            if (this.mIdleTimeMillis == null) {
                this.mIdleTimeMillis = this.createTimeMultiStateCounter();
            }
            return this.mIdleTimeMillis;
        }

        @Override
        public LongSamplingCounter getScanTimeCounter() {
            return this.mScanTimeMillis;
        }

        @Override
        public LongSamplingCounter getSleepTimeCounter() {
            return this.mSleepTimeMillis;
        }

        @Override
        public BatteryStats.LongCounter getRxTimeCounter() {
            if (this.mRxTimeMillis == null) {
                return ZERO_LONG_COUNTER;
            }
            return this.mRxTimeMillis;
        }

        private TimeMultiStateCounter getOrCreateRxTimeCounter() {
            if (this.mRxTimeMillis == null) {
                this.mRxTimeMillis = this.createTimeMultiStateCounter();
            }
            return this.mRxTimeMillis;
        }

        @Override
        public BatteryStats.LongCounter[] getTxTimeCounters() {
            if (this.mTxTimeMillis == null) {
                return ZERO_LONG_COUNTER_ARRAY;
            }
            return this.mTxTimeMillis;
        }

        private TimeMultiStateCounter[] getOrCreateTxTimeCounters() {
            if (this.mTxTimeMillis == null) {
                this.mTxTimeMillis = new TimeMultiStateCounter[this.mNumTxStates];
                for (int i = 0; i < this.mNumTxStates; ++i) {
                    this.mTxTimeMillis[i] = this.createTimeMultiStateCounter();
                }
            }
            return this.mTxTimeMillis;
        }

        private TimeMultiStateCounter createTimeMultiStateCounter() {
            long timestampMs = this.mClock.elapsedRealtime();
            TimeMultiStateCounter counter = new TimeMultiStateCounter(this.mTimeBase, 5, timestampMs);
            counter.setState(BatteryStats.mapUidProcessStateToBatteryConsumerProcessState(this.mProcessState), timestampMs);
            counter.update(0L, timestampMs);
            return counter;
        }

        @Override
        public LongSamplingCounter getPowerCounter() {
            return this.mPowerDrainMaMs;
        }

        @Override
        public LongSamplingCounter getMonitoredRailChargeConsumedMaMs() {
            return this.mMonitoredRailChargeConsumedMaMs;
        }

        private void setState(int processState, long elapsedTimeMs) {
            this.mProcessState = processState;
            if (this.mIdleTimeMillis != null) {
                this.mIdleTimeMillis.setState(processState, elapsedTimeMs);
            }
            if (this.mRxTimeMillis != null) {
                this.mRxTimeMillis.setState(processState, elapsedTimeMs);
            }
            if (this.mTxTimeMillis != null) {
                for (int i = 0; i < this.mTxTimeMillis.length; ++i) {
                    this.mTxTimeMillis[i].setState(processState, elapsedTimeMs);
                }
            }
        }
    }

    public abstract class OverflowArrayMap<T> {
        private static final String OVERFLOW_NAME = "*overflow*";
        final int mUid;
        final ArrayMap<String, T> mMap = new ArrayMap();
        T mCurOverflow;
        ArrayMap<String, MutableInt> mActiveOverflow;
        long mLastOverflowTimeMs;
        long mLastOverflowFinishTimeMs;
        long mLastClearTimeMs;
        long mLastCleanupTimeMs;

        public OverflowArrayMap(int uid) {
            this.mUid = uid;
        }

        public ArrayMap<String, T> getMap() {
            return this.mMap;
        }

        public void clear() {
            this.mLastClearTimeMs = SystemClock.elapsedRealtime();
            this.mMap.clear();
            this.mCurOverflow = null;
            this.mActiveOverflow = null;
        }

        public void add(String name, T obj) {
            if (name == null) {
                name = "";
            }
            this.mMap.put(name, obj);
            if (OVERFLOW_NAME.equals(name)) {
                this.mCurOverflow = obj;
            }
        }

        public void cleanup(long elapsedRealtimeMs) {
            this.mLastCleanupTimeMs = elapsedRealtimeMs;
            if (this.mActiveOverflow != null && this.mActiveOverflow.size() == 0) {
                this.mActiveOverflow = null;
            }
            if (this.mActiveOverflow == null) {
                if (this.mMap.containsKey(OVERFLOW_NAME)) {
                    Slog.wtf(BatteryStatsImpl.TAG, "Cleaning up with no active overflow, but have overflow entry " + this.mMap.get(OVERFLOW_NAME));
                    this.mMap.remove(OVERFLOW_NAME);
                }
                this.mCurOverflow = null;
            } else if (this.mCurOverflow == null || !this.mMap.containsKey(OVERFLOW_NAME)) {
                Slog.wtf(BatteryStatsImpl.TAG, "Cleaning up with active overflow, but no overflow entry: cur=" + this.mCurOverflow + " map=" + this.mMap.get(OVERFLOW_NAME));
            }
        }

        public T startObject(String name, long elapsedRealtimeMs) {
            MutableInt over;
            T obj;
            if (name == null) {
                name = "";
            }
            if ((obj = this.mMap.get(name)) != null) {
                return obj;
            }
            if (this.mActiveOverflow != null && (over = this.mActiveOverflow.get(name)) != null) {
                obj = this.mCurOverflow;
                if (obj == null) {
                    Slog.wtf(BatteryStatsImpl.TAG, "Have active overflow " + name + " but null overflow");
                    this.mCurOverflow = this.instantiateObject();
                    obj = this.mCurOverflow;
                    this.mMap.put(OVERFLOW_NAME, obj);
                }
                ++over.value;
                return obj;
            }
            int N = this.mMap.size();
            if (N >= MAX_WAKELOCKS_PER_UID) {
                obj = this.mCurOverflow;
                if (obj == null) {
                    this.mCurOverflow = this.instantiateObject();
                    obj = this.mCurOverflow;
                    this.mMap.put(OVERFLOW_NAME, obj);
                }
                if (this.mActiveOverflow == null) {
                    this.mActiveOverflow = new ArrayMap();
                }
                this.mActiveOverflow.put(name, new MutableInt(1));
                this.mLastOverflowTimeMs = elapsedRealtimeMs;
                return obj;
            }
            obj = this.instantiateObject();
            this.mMap.put(name, obj);
            return obj;
        }

        public T stopObject(String name, long elapsedRealtimeMs) {
            MutableInt over;
            T obj;
            if (name == null) {
                name = "";
            }
            if ((obj = this.mMap.get(name)) != null) {
                return obj;
            }
            if (this.mActiveOverflow != null && (over = this.mActiveOverflow.get(name)) != null && (obj = this.mCurOverflow) != null) {
                --over.value;
                if (over.value <= 0) {
                    this.mActiveOverflow.remove(name);
                    this.mLastOverflowFinishTimeMs = elapsedRealtimeMs;
                }
                return obj;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find object for ");
            sb.append(name);
            sb.append(" in uid ");
            sb.append(this.mUid);
            sb.append(" mapsize=");
            sb.append(this.mMap.size());
            sb.append(" activeoverflow=");
            sb.append(this.mActiveOverflow);
            sb.append(" curoverflow=");
            sb.append(this.mCurOverflow);
            long now = elapsedRealtimeMs;
            if (this.mLastOverflowTimeMs != 0L) {
                sb.append(" lastOverflowTime=");
                TimeUtils.formatDuration(this.mLastOverflowTimeMs - now, sb);
            }
            if (this.mLastOverflowFinishTimeMs != 0L) {
                sb.append(" lastOverflowFinishTime=");
                TimeUtils.formatDuration(this.mLastOverflowFinishTimeMs - now, sb);
            }
            if (this.mLastClearTimeMs != 0L) {
                sb.append(" lastClearTime=");
                TimeUtils.formatDuration(this.mLastClearTimeMs - now, sb);
            }
            if (this.mLastCleanupTimeMs != 0L) {
                sb.append(" lastCleanupTime=");
                TimeUtils.formatDuration(this.mLastCleanupTimeMs - now, sb);
            }
            Slog.wtf(BatteryStatsImpl.TAG, sb.toString());
            return null;
        }

        public abstract T instantiateObject();
    }

    public static class DualTimer
    extends DurationTimer {
        private final DurationTimer mSubTimer;

        public DualTimer(Clock clock, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, TimeBase subTimeBase, Parcel in) {
            super(clock, uid, type, timerPool, timeBase, in);
            this.mSubTimer = new DurationTimer(clock, uid, type, null, subTimeBase, in);
        }

        public DualTimer(Clock clock, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, TimeBase subTimeBase) {
            super(clock, uid, type, timerPool, timeBase);
            this.mSubTimer = new DurationTimer(clock, uid, type, null, subTimeBase);
        }

        @Override
        public DurationTimer getSubTimer() {
            return this.mSubTimer;
        }

        @Override
        public void startRunningLocked(long elapsedRealtimeMs) {
            super.startRunningLocked(elapsedRealtimeMs);
            this.mSubTimer.startRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void stopRunningLocked(long elapsedRealtimeMs) {
            super.stopRunningLocked(elapsedRealtimeMs);
            this.mSubTimer.stopRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void stopAllRunningLocked(long elapsedRealtimeMs) {
            super.stopAllRunningLocked(elapsedRealtimeMs);
            this.mSubTimer.stopAllRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            boolean active = false;
            active |= !this.mSubTimer.reset(false, elapsedRealtimeUs);
            return !(active |= !super.reset(detachIfReset, elapsedRealtimeUs));
        }

        @Override
        public void detach() {
            this.mSubTimer.detach();
            super.detach();
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            this.mSubTimer.writeToParcel(out, elapsedRealtimeUs);
        }

        @Override
        public void writeSummaryFromParcelLocked(Parcel out, long elapsedRealtimeUs) {
            super.writeSummaryFromParcelLocked(out, elapsedRealtimeUs);
            this.mSubTimer.writeSummaryFromParcelLocked(out, elapsedRealtimeUs);
        }

        @Override
        public void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mSubTimer.readSummaryFromParcelLocked(in);
        }
    }

    public static class StopwatchTimer
    extends Timer {
        final Uid mUid;
        final ArrayList<StopwatchTimer> mTimerPool;
        int mNesting;
        long mUpdateTimeUs;
        long mAcquireTimeUs = -1L;
        long mTimeoutUs;
        @VisibleForTesting
        public boolean mInList;

        public StopwatchTimer(Clock clock, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, Parcel in) {
            super(clock, type, timeBase, in);
            this.mUid = uid;
            this.mTimerPool = timerPool;
            this.mUpdateTimeUs = in.readLong();
        }

        public StopwatchTimer(Clock clock, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase) {
            super(clock, type, timeBase);
            this.mUid = uid;
            this.mTimerPool = timerPool;
        }

        public void setTimeout(long timeoutUs) {
            this.mTimeoutUs = timeoutUs;
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.mUpdateTimeUs);
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            if (this.mNesting > 0) {
                super.onTimeStopped(elapsedRealtimeUs, baseUptimeUs, baseRealtimeUs);
                this.mUpdateTimeUs = baseRealtimeUs;
            }
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mNesting=" + this.mNesting + " mUpdateTime=" + this.mUpdateTimeUs + " mAcquireTime=" + this.mAcquireTimeUs);
        }

        public void startRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting++ == 0) {
                long batteryRealtimeUs;
                this.mUpdateTimeUs = batteryRealtimeUs = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtimeUs, this.mTimerPool, null);
                    this.mTimerPool.add(this);
                }
                if (this.mTimeBase.isRunning()) {
                    ++this.mCount;
                    this.mAcquireTimeUs = this.mTotalTimeUs;
                } else {
                    this.mAcquireTimeUs = -1L;
                }
            }
        }

        @Override
        public boolean isRunningLocked() {
            return this.mNesting > 0;
        }

        public void stopRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting == 0) {
                return;
            }
            if (--this.mNesting == 0) {
                long batteryRealtimeUs = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtimeUs, this.mTimerPool, null);
                    this.mTimerPool.remove(this);
                } else {
                    this.mNesting = 1;
                    this.mTotalTimeUs = this.computeRunTimeLocked(batteryRealtimeUs, elapsedRealtimeMs * 1000L);
                    this.mNesting = 0;
                }
                if (this.mAcquireTimeUs >= 0L && this.mTotalTimeUs == this.mAcquireTimeUs) {
                    --this.mCount;
                }
            }
        }

        public void stopAllRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting > 0) {
                this.mNesting = 1;
                this.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private static long refreshTimersLocked(long batteryRealtimeUs, ArrayList<StopwatchTimer> pool, StopwatchTimer self) {
            long selfTimeUs = 0L;
            int N = pool.size();
            for (int i = N - 1; i >= 0; --i) {
                StopwatchTimer t = pool.get(i);
                long heldTimeUs = batteryRealtimeUs - t.mUpdateTimeUs;
                if (heldTimeUs > 0L) {
                    long myTimeUs = heldTimeUs / (long)N;
                    if (t == self) {
                        selfTimeUs = myTimeUs;
                    }
                    t.mTotalTimeUs += myTimeUs;
                }
                t.mUpdateTimeUs = batteryRealtimeUs;
            }
            return selfTimeUs;
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtimeUs, long elapsedRealtimeUs) {
            if (this.mTimeoutUs > 0L && curBatteryRealtimeUs > this.mUpdateTimeUs + this.mTimeoutUs) {
                curBatteryRealtimeUs = this.mUpdateTimeUs + this.mTimeoutUs;
            }
            return this.mTotalTimeUs + (this.mNesting > 0 ? (curBatteryRealtimeUs - this.mUpdateTimeUs) / (long)(this.mTimerPool != null ? this.mTimerPool.size() : 1) : 0L);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            boolean canDetach = this.mNesting <= 0;
            super.reset(canDetach && detachIfReset, elapsedRealtimeUs);
            if (this.mNesting > 0) {
                this.mUpdateTimeUs = this.mTimeBase.getRealtime(elapsedRealtimeUs);
            }
            this.mAcquireTimeUs = -1L;
            return canDetach;
        }

        @Override
        @UnsupportedAppUsage
        public void detach() {
            super.detach();
            if (this.mTimerPool != null) {
                this.mTimerPool.remove(this);
            }
        }

        @Override
        public void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mNesting = 0;
        }

        public void setMark(long elapsedRealtimeMs) {
            long batteryRealtimeUs = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
            if (this.mNesting > 0) {
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtimeUs, this.mTimerPool, this);
                } else {
                    this.mTotalTimeUs += batteryRealtimeUs - this.mUpdateTimeUs;
                    this.mUpdateTimeUs = batteryRealtimeUs;
                }
            }
            this.mTimeBeforeMarkUs = this.mTotalTimeUs;
        }
    }

    public static class DurationTimer
    extends StopwatchTimer {
        long mStartTimeMs = -1L;
        long mMaxDurationMs;
        long mCurrentDurationMs;
        long mTotalDurationMs;

        public DurationTimer(Clock clock, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, Parcel in) {
            super(clock, uid, type, timerPool, timeBase, in);
            this.mMaxDurationMs = in.readLong();
            this.mTotalDurationMs = in.readLong();
            this.mCurrentDurationMs = in.readLong();
        }

        public DurationTimer(Clock clock, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase) {
            super(clock, uid, type, timerPool, timeBase);
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.getMaxDurationMsLocked(elapsedRealtimeUs / 1000L));
            out.writeLong(this.mTotalDurationMs);
            out.writeLong(this.getCurrentDurationMsLocked(elapsedRealtimeUs / 1000L));
        }

        @Override
        public void writeSummaryFromParcelLocked(Parcel out, long elapsedRealtimeUs) {
            super.writeSummaryFromParcelLocked(out, elapsedRealtimeUs);
            out.writeLong(this.getMaxDurationMsLocked(elapsedRealtimeUs / 1000L));
            out.writeLong(this.getTotalDurationMsLocked(elapsedRealtimeUs / 1000L));
        }

        @Override
        public void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mMaxDurationMs = in.readLong();
            this.mTotalDurationMs = in.readLong();
            this.mStartTimeMs = -1L;
            this.mCurrentDurationMs = 0L;
        }

        @Override
        public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            super.onTimeStarted(elapsedRealtimeUs, baseUptimeUs, baseRealtimeUs);
            if (this.mNesting > 0) {
                this.mStartTimeMs = baseRealtimeUs / 1000L;
            }
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            super.onTimeStopped(elapsedRealtimeUs, baseUptimeUs, baseRealtimeUs);
            if (this.mNesting > 0) {
                this.mCurrentDurationMs += baseRealtimeUs / 1000L - this.mStartTimeMs;
            }
            this.mStartTimeMs = -1L;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
        }

        @Override
        public void startRunningLocked(long elapsedRealtimeMs) {
            super.startRunningLocked(elapsedRealtimeMs);
            if (this.mNesting == 1 && this.mTimeBase.isRunning()) {
                this.mStartTimeMs = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L) / 1000L;
            }
        }

        @Override
        public void stopRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting == 1) {
                long durationMs = this.getCurrentDurationMsLocked(elapsedRealtimeMs);
                this.mTotalDurationMs += durationMs;
                if (durationMs > this.mMaxDurationMs) {
                    this.mMaxDurationMs = durationMs;
                }
                this.mStartTimeMs = -1L;
                this.mCurrentDurationMs = 0L;
            }
            super.stopRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            boolean result = super.reset(detachIfReset, elapsedRealtimeUs);
            this.mMaxDurationMs = 0L;
            this.mTotalDurationMs = 0L;
            this.mCurrentDurationMs = 0L;
            this.mStartTimeMs = this.mNesting > 0 ? this.mTimeBase.getRealtime(elapsedRealtimeUs) / 1000L : -1L;
            return result;
        }

        @Override
        public long getMaxDurationMsLocked(long elapsedRealtimeMs) {
            long durationMs;
            if (this.mNesting > 0 && (durationMs = this.getCurrentDurationMsLocked(elapsedRealtimeMs)) > this.mMaxDurationMs) {
                return durationMs;
            }
            return this.mMaxDurationMs;
        }

        @Override
        public long getCurrentDurationMsLocked(long elapsedRealtimeMs) {
            long durationMs = this.mCurrentDurationMs;
            if (this.mNesting > 0 && this.mTimeBase.isRunning()) {
                durationMs += this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L) / 1000L - this.mStartTimeMs;
            }
            return durationMs;
        }

        @Override
        public long getTotalDurationMsLocked(long elapsedRealtimeMs) {
            return this.mTotalDurationMs + this.getCurrentDurationMsLocked(elapsedRealtimeMs);
        }
    }

    public static class BatchTimer
    extends Timer {
        final Uid mUid;
        long mLastAddedTimeUs;
        long mLastAddedDurationUs;
        boolean mInDischarge;

        BatchTimer(Clock clock, Uid uid, int type, TimeBase timeBase, Parcel in) {
            super(clock, type, timeBase, in);
            this.mUid = uid;
            this.mLastAddedTimeUs = in.readLong();
            this.mLastAddedDurationUs = in.readLong();
            this.mInDischarge = timeBase.isRunning();
        }

        BatchTimer(Clock clock, Uid uid, int type, TimeBase timeBase) {
            super(clock, type, timeBase);
            this.mUid = uid;
            this.mInDischarge = timeBase.isRunning();
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.mLastAddedTimeUs);
            out.writeLong(this.mLastAddedDurationUs);
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            this.recomputeLastDuration(elapsedRealtimeUs, false);
            this.mInDischarge = false;
            super.onTimeStopped(elapsedRealtimeUs, baseUptimeUs, baseRealtimeUs);
        }

        @Override
        public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            this.recomputeLastDuration(elapsedRealtimeUs, false);
            this.mInDischarge = true;
            if (this.mLastAddedTimeUs == elapsedRealtimeUs) {
                this.mTotalTimeUs += this.mLastAddedDurationUs;
            }
            super.onTimeStarted(elapsedRealtimeUs, baseUptimeUs, baseRealtimeUs);
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mLastAddedTime=" + this.mLastAddedTimeUs + " mLastAddedDuration=" + this.mLastAddedDurationUs);
        }

        private long computeOverage(long curTimeUs) {
            if (this.mLastAddedTimeUs > 0L) {
                return this.mLastAddedDurationUs - curTimeUs;
            }
            return 0L;
        }

        private void recomputeLastDuration(long curTimeUs, boolean abort) {
            long overage = this.computeOverage(curTimeUs);
            if (overage > 0L) {
                if (this.mInDischarge) {
                    this.mTotalTimeUs -= overage;
                }
                if (abort) {
                    this.mLastAddedTimeUs = 0L;
                } else {
                    this.mLastAddedTimeUs = curTimeUs;
                    this.mLastAddedDurationUs -= overage;
                }
            }
        }

        public void addDuration(BatteryStatsImpl stats, long durationMs) {
            this.addDuration(stats, durationMs, this.mClock.elapsedRealtime());
        }

        public void addDuration(BatteryStatsImpl stats, long durationMs, long elapsedRealtimeMs) {
            long nowUs = elapsedRealtimeMs * 1000L;
            this.recomputeLastDuration(nowUs, true);
            this.mLastAddedTimeUs = nowUs;
            this.mLastAddedDurationUs = durationMs * 1000L;
            if (this.mInDischarge) {
                this.mTotalTimeUs += this.mLastAddedDurationUs;
                ++this.mCount;
            }
        }

        public void abortLastDuration(BatteryStatsImpl stats) {
            this.abortLastDuration(stats, this.mClock.elapsedRealtime());
        }

        public void abortLastDuration(BatteryStatsImpl stats, long elapsedRealtimeMs) {
            long nowUs = elapsedRealtimeMs * 1000L;
            this.recomputeLastDuration(nowUs, true);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtimeUs, long elapsedRealtimeUs) {
            long overage = this.computeOverage(elapsedRealtimeUs);
            if (overage > 0L) {
                this.mTotalTimeUs = overage;
                return this.mTotalTimeUs;
            }
            return this.mTotalTimeUs;
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            this.recomputeLastDuration(elapsedRealtimeUs, true);
            boolean stillActive = this.mLastAddedTimeUs == elapsedRealtimeUs;
            super.reset(!stillActive && detachIfReset, elapsedRealtimeUs);
            return !stillActive;
        }
    }

    public static class SamplingTimer
    extends Timer {
        int mCurrentReportedCount;
        int mUnpluggedReportedCount;
        long mCurrentReportedTotalTimeUs;
        long mUnpluggedReportedTotalTimeUs;
        boolean mTimeBaseRunning;
        boolean mTrackingReportedValues;
        int mUpdateVersion;

        @VisibleForTesting
        public SamplingTimer(Clock clock, TimeBase timeBase, Parcel in) {
            super(clock, 0, timeBase, in);
            this.mCurrentReportedCount = in.readInt();
            this.mUnpluggedReportedCount = in.readInt();
            this.mCurrentReportedTotalTimeUs = in.readLong();
            this.mUnpluggedReportedTotalTimeUs = in.readLong();
            this.mTrackingReportedValues = in.readInt() == 1;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        @VisibleForTesting
        public SamplingTimer(Clock clock, TimeBase timeBase) {
            super(clock, 0, timeBase);
            this.mTrackingReportedValues = false;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        public void endSample() {
            this.endSample(this.mClock.elapsedRealtime() * 1000L);
        }

        public void endSample(long elapsedRealtimeUs) {
            this.mTotalTimeUs = this.computeRunTimeLocked(0L, elapsedRealtimeUs);
            this.mCount = this.computeCurrentCountLocked();
            this.mCurrentReportedTotalTimeUs = 0L;
            this.mUnpluggedReportedTotalTimeUs = 0L;
            this.mCurrentReportedCount = 0;
            this.mUnpluggedReportedCount = 0;
            this.mTrackingReportedValues = false;
        }

        public void setUpdateVersion(int version) {
            this.mUpdateVersion = version;
        }

        public int getUpdateVersion() {
            return this.mUpdateVersion;
        }

        public void updated(long totalTimeUs, int count) {
            this.update(totalTimeUs, count, this.mClock.elapsedRealtime() * 1000L);
        }

        public void update(long totalTimeUs, int count, long elapsedRealtimeUs) {
            if (this.mTimeBaseRunning && !this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTimeUs = totalTimeUs;
                this.mUnpluggedReportedCount = count;
            }
            this.mTrackingReportedValues = true;
            if (totalTimeUs < this.mCurrentReportedTotalTimeUs || count < this.mCurrentReportedCount) {
                this.endSample(elapsedRealtimeUs);
            }
            this.mCurrentReportedTotalTimeUs = totalTimeUs;
            this.mCurrentReportedCount = count;
        }

        public void add(long deltaTimeUs, int deltaCount) {
            this.add(deltaTimeUs, deltaCount, this.mClock.elapsedRealtime() * 1000L);
        }

        public void add(long deltaTimeUs, int deltaCount, long elapsedRealtimeUs) {
            this.update(this.mCurrentReportedTotalTimeUs + deltaTimeUs, this.mCurrentReportedCount + deltaCount, elapsedRealtimeUs);
        }

        @Override
        public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            super.onTimeStarted(elapsedRealtimeUs, baseUptimeUs, baseRealtimeUs);
            if (this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTimeUs = this.mCurrentReportedTotalTimeUs;
                this.mUnpluggedReportedCount = this.mCurrentReportedCount;
            }
            this.mTimeBaseRunning = true;
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            super.onTimeStopped(elapsedRealtimeUs, baseUptimeUs, baseRealtimeUs);
            this.mTimeBaseRunning = false;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mCurrentReportedCount=" + this.mCurrentReportedCount + " mUnpluggedReportedCount=" + this.mUnpluggedReportedCount + " mCurrentReportedTotalTime=" + this.mCurrentReportedTotalTimeUs + " mUnpluggedReportedTotalTime=" + this.mUnpluggedReportedTotalTimeUs);
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime, long elapsedRealtimeUs) {
            return this.mTotalTimeUs + (this.mTimeBaseRunning && this.mTrackingReportedValues ? this.mCurrentReportedTotalTimeUs - this.mUnpluggedReportedTotalTimeUs : 0L);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount + (this.mTimeBaseRunning && this.mTrackingReportedValues ? this.mCurrentReportedCount - this.mUnpluggedReportedCount : 0);
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeInt(this.mCurrentReportedCount);
            out.writeInt(this.mUnpluggedReportedCount);
            out.writeLong(this.mCurrentReportedTotalTimeUs);
            out.writeLong(this.mUnpluggedReportedTotalTimeUs);
            out.writeInt(this.mTrackingReportedValues ? 1 : 0);
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            super.reset(detachIfReset, elapsedRealtimeUs);
            this.mTrackingReportedValues = false;
            this.mUnpluggedReportedTotalTimeUs = 0L;
            this.mUnpluggedReportedCount = 0;
            return true;
        }
    }

    public static abstract class Timer
    extends BatteryStats.Timer
    implements TimeBaseObs {
        protected final Clock mClock;
        protected final int mType;
        protected final TimeBase mTimeBase;
        protected int mCount;
        protected long mTotalTimeUs;
        protected long mTimeBeforeMarkUs;

        public Timer(Clock clock, int type, TimeBase timeBase, Parcel in) {
            this.mClock = clock;
            this.mType = type;
            this.mTimeBase = timeBase;
            this.mCount = in.readInt();
            this.mTotalTimeUs = in.readLong();
            this.mTimeBeforeMarkUs = in.readLong();
            timeBase.add(this);
        }

        public Timer(Clock clock, int type, TimeBase timeBase) {
            this.mClock = clock;
            this.mType = type;
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            out.writeInt(this.computeCurrentCountLocked());
            out.writeLong(this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs), elapsedRealtimeUs));
            out.writeLong(this.mTimeBeforeMarkUs);
        }

        protected abstract long computeRunTimeLocked(long var1, long var3);

        protected abstract int computeCurrentCountLocked();

        @Override
        public boolean reset(boolean detachIfReset) {
            return this.reset(detachIfReset, this.mClock.elapsedRealtime() * 1000L);
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            this.mTimeBeforeMarkUs = 0L;
            this.mTotalTimeUs = 0L;
            this.mCount = 0;
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }

        @Override
        public void onTimeStarted(long elapsedRealtimeUs, long timeBaseUptimeUs, long baseRealtimeUs) {
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            this.mTotalTimeUs = this.computeRunTimeLocked(baseRealtimeUs, elapsedRealtimeUs);
            this.mCount = this.computeCurrentCountLocked();
        }

        @UnsupportedAppUsage
        public static void writeTimerToParcel(Parcel out, Timer timer, long elapsedRealtimeUs) {
            if (timer == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            timer.writeToParcel(out, elapsedRealtimeUs);
        }

        @Override
        @UnsupportedAppUsage
        public long getTotalTimeLocked(long elapsedRealtimeUs, int which) {
            return this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs), elapsedRealtimeUs);
        }

        @Override
        @UnsupportedAppUsage
        public int getCountLocked(int which) {
            return this.computeCurrentCountLocked();
        }

        @Override
        public long getTimeSinceMarkLocked(long elapsedRealtimeUs) {
            long val = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs), elapsedRealtimeUs);
            return val - this.mTimeBeforeMarkUs;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount);
            pw.println(prefix + "mTotalTime=" + this.mTotalTimeUs);
        }

        public void writeSummaryFromParcelLocked(Parcel out, long elapsedRealtimeUs) {
            long runTimeUs = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs), elapsedRealtimeUs);
            out.writeLong(runTimeUs);
            out.writeInt(this.computeCurrentCountLocked());
        }

        public void readSummaryFromParcelLocked(Parcel in) {
            this.mTotalTimeUs = in.readLong();
            this.mCount = in.readInt();
            this.mTimeBeforeMarkUs = this.mTotalTimeUs;
        }
    }

    @VisibleForTesting
    public static class LongSamplingCounter
    extends BatteryStats.LongCounter
    implements TimeBaseObs {
        final TimeBase mTimeBase;
        private long mCount;

        public LongSamplingCounter(TimeBase timeBase, Parcel in) {
            this.mTimeBase = timeBase;
            this.mCount = in.readLong();
            timeBase.add(this);
        }

        public LongSamplingCounter(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        public void writeToParcel(Parcel out) {
            out.writeLong(this.mCount);
        }

        @Override
        public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
        }

        @Override
        public long getCountLocked(int which) {
            return this.mCount;
        }

        @Override
        public long getCountForProcessState(int procState) {
            if (procState == 0) {
                return this.getCountLocked(0);
            }
            return 0L;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount);
        }

        public void addCountLocked(long count) {
            this.addCountLocked(count, this.mTimeBase.isRunning());
        }

        public void addCountLocked(long count, boolean isRunning) {
            if (isRunning) {
                this.mCount += count;
            }
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            this.mCount = 0L;
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }

        public void writeSummaryFromParcelLocked(Parcel out) {
            out.writeLong(this.mCount);
        }

        public void readSummaryFromParcelLocked(Parcel in) {
            this.mCount = in.readLong();
        }
    }

    private static class TimeInFreqMultiStateCounter
    implements TimeBaseObs {
        private final TimeBase mTimeBase;
        private final LongArrayMultiStateCounter mCounter;

        private TimeInFreqMultiStateCounter(TimeBase timeBase, int stateCount, int cpuFreqCount, long timestampMs) {
            this(timeBase, new LongArrayMultiStateCounter(stateCount, cpuFreqCount), timestampMs);
        }

        private TimeInFreqMultiStateCounter(TimeBase timeBase, LongArrayMultiStateCounter counter, long timestampMs) {
            this.mTimeBase = timeBase;
            this.mCounter = counter;
            this.mCounter.setEnabled(this.mTimeBase.isRunning(), timestampMs);
            timeBase.add(this);
        }

        private void writeToParcel(Parcel out) {
            this.mCounter.writeToParcel(out, 0);
        }

        private static TimeInFreqMultiStateCounter readFromParcel(Parcel in, TimeBase timeBase, int stateCount, int cpuFreqCount, long timestampMs) {
            LongArrayMultiStateCounter counter = LongArrayMultiStateCounter.CREATOR.createFromParcel(in);
            if (counter.getStateCount() != stateCount || counter.getArrayLength() != cpuFreqCount) {
                return null;
            }
            return new TimeInFreqMultiStateCounter(timeBase, counter, timestampMs);
        }

        @Override
        public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            this.mCounter.setEnabled(true, elapsedRealtimeUs / 1000L);
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            this.mCounter.setEnabled(false, elapsedRealtimeUs / 1000L);
        }

        public LongArrayMultiStateCounter getCounter() {
            return this.mCounter;
        }

        public int getStateCount() {
            return this.mCounter.getStateCount();
        }

        public void setTrackingEnabled(boolean enabled, long timestampMs) {
            this.mCounter.setEnabled(enabled && this.mTimeBase.isRunning(), timestampMs);
        }

        private void setState(int uidRunningState, long elapsedRealtimeMs) {
            this.mCounter.setState(uidRunningState, elapsedRealtimeMs);
        }

        public boolean getCountsLocked(long[] counts, int procState) {
            if (counts.length != this.mCounter.getArrayLength()) {
                return false;
            }
            this.mCounter.getCounts(counts, procState);
            for (int i = counts.length - 1; i >= 0; --i) {
                if (counts[i] == 0L) continue;
                return true;
            }
            return false;
        }

        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCounter=" + this.mCounter);
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            this.mCounter.reset();
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }
    }

    private static class TimeMultiStateCounter
    extends BatteryStats.LongCounter
    implements TimeBaseObs {
        private final TimeBase mTimeBase;
        private final LongMultiStateCounter mCounter;

        private TimeMultiStateCounter(TimeBase timeBase, int stateCount, long timestampMs) {
            this(timeBase, new LongMultiStateCounter(stateCount), timestampMs);
        }

        private TimeMultiStateCounter(TimeBase timeBase, LongMultiStateCounter counter, long timestampMs) {
            this.mTimeBase = timeBase;
            this.mCounter = counter;
            this.mCounter.setEnabled(this.mTimeBase.isRunning(), timestampMs);
            timeBase.add(this);
        }

        private static TimeMultiStateCounter readFromParcel(Parcel in, TimeBase timeBase, int stateCount, long timestampMs) {
            LongMultiStateCounter counter = LongMultiStateCounter.CREATOR.createFromParcel(in);
            if (counter.getStateCount() != stateCount) {
                return null;
            }
            return new TimeMultiStateCounter(timeBase, counter, timestampMs);
        }

        private void writeToParcel(Parcel out) {
            this.mCounter.writeToParcel(out, 0);
        }

        @Override
        public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            this.mCounter.setEnabled(true, elapsedRealtimeUs / 1000L);
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
            this.mCounter.setEnabled(false, elapsedRealtimeUs / 1000L);
        }

        public int getStateCount() {
            return this.mCounter.getStateCount();
        }

        private void setState(int processState, long elapsedRealtimeMs) {
            this.mCounter.setState(processState, elapsedRealtimeMs);
        }

        private long update(long value, long timestampMs) {
            return this.mCounter.updateValue(value, timestampMs);
        }

        private void increment(long increment, long timestampMs) {
            this.mCounter.incrementValue(increment, timestampMs);
        }

        @Override
        public long getCountForProcessState(int procState) {
            return this.mCounter.getCount(procState);
        }

        public long getTotalCountLocked() {
            return this.mCounter.getTotalCount();
        }

        @Override
        public long getCountLocked(int statsType) {
            return this.getTotalCountLocked();
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCounter=" + this.mCounter);
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            this.mCounter.reset();
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }
    }

    @VisibleForTesting
    public static class LongSamplingCounterArray
    extends BatteryStats.LongCounterArray
    implements TimeBaseObs {
        final TimeBase mTimeBase;
        public long[] mCounts;

        private LongSamplingCounterArray(TimeBase timeBase, Parcel in) {
            this.mTimeBase = timeBase;
            this.mCounts = in.createLongArray();
            timeBase.add(this);
        }

        public LongSamplingCounterArray(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        private void writeToParcel(Parcel out) {
            out.writeLongArray(this.mCounts);
        }

        @Override
        public void onTimeStarted(long elapsedRealTimeUs, long baseUptimeUs, long baseRealtimeUs) {
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
        }

        @Override
        public long[] getCountsLocked(int which) {
            return this.mCounts == null ? null : Arrays.copyOf(this.mCounts, this.mCounts.length);
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCounts=" + Arrays.toString(this.mCounts));
        }

        public void addCountLocked(long[] counts) {
            this.addCountLocked(counts, this.mTimeBase.isRunning());
        }

        public void addCountLocked(long[] counts, boolean isRunning) {
            if (counts == null) {
                return;
            }
            if (isRunning) {
                if (this.mCounts == null) {
                    this.mCounts = new long[counts.length];
                }
                for (int i = 0; i < counts.length; ++i) {
                    int n = i;
                    this.mCounts[n] = this.mCounts[n] + counts[i];
                }
            }
        }

        public int getSize() {
            return this.mCounts == null ? 0 : this.mCounts.length;
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            if (this.mCounts != null) {
                Arrays.fill(this.mCounts, 0L);
            }
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }

        private void writeSummaryToParcelLocked(Parcel out) {
            out.writeLongArray(this.mCounts);
        }

        private void readSummaryFromParcelLocked(Parcel in) {
            this.mCounts = in.createLongArray();
        }

        public static void writeToParcel(Parcel out, LongSamplingCounterArray counterArray) {
            if (counterArray != null) {
                out.writeInt(1);
                counterArray.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
        }

        public static LongSamplingCounterArray readFromParcel(Parcel in, TimeBase timeBase) {
            if (in.readInt() != 0) {
                return new LongSamplingCounterArray(timeBase, in);
            }
            return null;
        }

        public static void writeSummaryToParcelLocked(Parcel out, LongSamplingCounterArray counterArray) {
            if (counterArray != null) {
                out.writeInt(1);
                counterArray.writeSummaryToParcelLocked(out);
            } else {
                out.writeInt(0);
            }
        }

        public static LongSamplingCounterArray readSummaryFromParcelLocked(Parcel in, TimeBase timeBase) {
            if (in.readInt() != 0) {
                LongSamplingCounterArray counterArray = new LongSamplingCounterArray(timeBase);
                counterArray.readSummaryFromParcelLocked(in);
                return counterArray;
            }
            return null;
        }
    }

    public static class Counter
    extends BatteryStats.Counter
    implements TimeBaseObs {
        @UnsupportedAppUsage
        final AtomicInteger mCount = new AtomicInteger();
        final TimeBase mTimeBase;

        public Counter(TimeBase timeBase, Parcel in) {
            this.mTimeBase = timeBase;
            this.mCount.set(in.readInt());
            timeBase.add(this);
        }

        public Counter(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        public void writeToParcel(Parcel out) {
            out.writeInt(this.mCount.get());
        }

        @Override
        public void onTimeStarted(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptimeUs, long baseRealtimeUs) {
        }

        public static void writeCounterToParcel(Parcel out, Counter counter) {
            if (counter == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            counter.writeToParcel(out);
        }

        public static Counter readCounterFromParcel(TimeBase timeBase, Parcel in) {
            if (in.readInt() == 0) {
                return null;
            }
            return new Counter(timeBase, in);
        }

        @Override
        public int getCountLocked(int which) {
            return this.mCount.get();
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount.get());
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void stepAtomic() {
            if (this.mTimeBase.isRunning()) {
                this.mCount.incrementAndGet();
            }
        }

        void addAtomic(int delta) {
            if (this.mTimeBase.isRunning()) {
                this.mCount.addAndGet(delta);
            }
        }

        @Override
        public boolean reset(boolean detachIfReset, long elapsedRealtimeUs) {
            this.mCount.set(0);
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void writeSummaryFromParcelLocked(Parcel out) {
            out.writeInt(this.mCount.get());
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void readSummaryFromParcelLocked(Parcel in) {
            this.mCount.set(in.readInt());
        }
    }

    public static class TimeBase {
        protected final Collection<TimeBaseObs> mObservers;
        protected long mUptimeUs;
        protected long mRealtimeUs;
        protected boolean mRunning;
        protected long mPastUptimeUs;
        protected long mUptimeStartUs;
        protected long mPastRealtimeUs;
        protected long mRealtimeStartUs;
        protected long mUnpluggedUptimeUs;
        protected long mUnpluggedRealtimeUs;

        public void dump(PrintWriter pw, String prefix) {
            StringBuilder sb = new StringBuilder(128);
            pw.print(prefix);
            pw.print("mRunning=");
            pw.println(this.mRunning);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mUptime=");
            BatteryStats.formatTimeMs(sb, this.mUptimeUs / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mRealtime=");
            BatteryStats.formatTimeMs(sb, this.mRealtimeUs / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPastUptime=");
            BatteryStats.formatTimeMs(sb, this.mPastUptimeUs / 1000L);
            sb.append("mUptimeStart=");
            BatteryStats.formatTimeMs(sb, this.mUptimeStartUs / 1000L);
            sb.append("mUnpluggedUptime=");
            BatteryStats.formatTimeMs(sb, this.mUnpluggedUptimeUs / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPastRealtime=");
            BatteryStats.formatTimeMs(sb, this.mPastRealtimeUs / 1000L);
            sb.append("mRealtimeStart=");
            BatteryStats.formatTimeMs(sb, this.mRealtimeStartUs / 1000L);
            sb.append("mUnpluggedRealtime=");
            BatteryStats.formatTimeMs(sb, this.mUnpluggedRealtimeUs / 1000L);
            pw.println(sb.toString());
        }

        public TimeBase(boolean isLongList) {
            this.mObservers = isLongList ? new HashSet() : new ArrayList();
        }

        public TimeBase() {
            this(false);
        }

        public void add(TimeBaseObs observer) {
            this.mObservers.add(observer);
        }

        public void remove(TimeBaseObs observer) {
            this.mObservers.remove(observer);
        }

        public boolean hasObserver(TimeBaseObs observer) {
            return this.mObservers.contains(observer);
        }

        public void init(long uptimeUs, long elapsedRealtimeUs) {
            this.mRealtimeUs = 0L;
            this.mUptimeUs = 0L;
            this.mPastUptimeUs = 0L;
            this.mPastRealtimeUs = 0L;
            this.mUptimeStartUs = uptimeUs;
            this.mRealtimeStartUs = elapsedRealtimeUs;
            this.mUnpluggedUptimeUs = this.getUptime(this.mUptimeStartUs);
            this.mUnpluggedRealtimeUs = this.getRealtime(this.mRealtimeStartUs);
        }

        public void reset(long uptimeUs, long elapsedRealtimeUs) {
            if (!this.mRunning) {
                this.mPastUptimeUs = 0L;
                this.mPastRealtimeUs = 0L;
            } else {
                this.mUptimeStartUs = uptimeUs;
                this.mRealtimeStartUs = elapsedRealtimeUs;
                this.mUnpluggedUptimeUs = this.getUptime(uptimeUs);
                this.mUnpluggedRealtimeUs = this.getRealtime(elapsedRealtimeUs);
            }
        }

        public long computeUptime(long curTimeUs, int which) {
            return this.mUptimeUs + this.getUptime(curTimeUs);
        }

        public long computeRealtime(long curTimeUs, int which) {
            return this.mRealtimeUs + this.getRealtime(curTimeUs);
        }

        public long getUptime(long curTimeUs) {
            long time = this.mPastUptimeUs;
            if (this.mRunning) {
                time += curTimeUs - this.mUptimeStartUs;
            }
            return time;
        }

        public long getRealtime(long curTimeUs) {
            long time = this.mPastRealtimeUs;
            if (this.mRunning) {
                time += curTimeUs - this.mRealtimeStartUs;
            }
            return time;
        }

        public long getUptimeStart() {
            return this.mUptimeStartUs;
        }

        public long getRealtimeStart() {
            return this.mRealtimeStartUs;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public boolean setRunning(boolean running, long uptimeUs, long elapsedRealtimeUs) {
            if (this.mRunning != running) {
                this.mRunning = running;
                if (running) {
                    this.mUptimeStartUs = uptimeUs;
                    this.mRealtimeStartUs = elapsedRealtimeUs;
                    long batteryUptimeUs = this.mUnpluggedUptimeUs = this.getUptime(uptimeUs);
                    long batteryRealtimeUs = this.mUnpluggedRealtimeUs = this.getRealtime(elapsedRealtimeUs);
                    Iterator<TimeBaseObs> iter = this.mObservers.iterator();
                    while (iter.hasNext()) {
                        iter.next().onTimeStarted(elapsedRealtimeUs, batteryUptimeUs, batteryRealtimeUs);
                    }
                } else {
                    this.mPastUptimeUs += uptimeUs - this.mUptimeStartUs;
                    this.mPastRealtimeUs += elapsedRealtimeUs - this.mRealtimeStartUs;
                    long batteryUptimeUs = this.getUptime(uptimeUs);
                    long batteryRealtimeUs = this.getRealtime(elapsedRealtimeUs);
                    Iterator<TimeBaseObs> iter = this.mObservers.iterator();
                    while (iter.hasNext()) {
                        iter.next().onTimeStopped(elapsedRealtimeUs, batteryUptimeUs, batteryRealtimeUs);
                    }
                }
                return true;
            }
            return false;
        }

        public void readSummaryFromParcel(Parcel in) {
            this.mUptimeUs = in.readLong();
            this.mRealtimeUs = in.readLong();
        }

        public void writeSummaryToParcel(Parcel out, long uptimeUs, long elapsedRealtimeUs) {
            out.writeLong(this.computeUptime(uptimeUs, 0));
            out.writeLong(this.computeRealtime(elapsedRealtimeUs, 0));
        }

        public void readFromParcel(Parcel in) {
            this.mRunning = false;
            this.mUptimeUs = in.readLong();
            this.mPastUptimeUs = in.readLong();
            this.mUptimeStartUs = in.readLong();
            this.mRealtimeUs = in.readLong();
            this.mPastRealtimeUs = in.readLong();
            this.mRealtimeStartUs = in.readLong();
            this.mUnpluggedUptimeUs = in.readLong();
            this.mUnpluggedRealtimeUs = in.readLong();
        }

        public void writeToParcel(Parcel out, long uptimeUs, long elapsedRealtimeUs) {
            long runningUptime = this.getUptime(uptimeUs);
            long runningRealtime = this.getRealtime(elapsedRealtimeUs);
            out.writeLong(this.mUptimeUs);
            out.writeLong(runningUptime);
            out.writeLong(this.mUptimeStartUs);
            out.writeLong(this.mRealtimeUs);
            out.writeLong(runningRealtime);
            out.writeLong(this.mRealtimeStartUs);
            out.writeLong(this.mUnpluggedUptimeUs);
            out.writeLong(this.mUnpluggedRealtimeUs);
        }
    }

    public static interface TimeBaseObs {
        public void onTimeStarted(long var1, long var3, long var5);

        public void onTimeStopped(long var1, long var3, long var5);

        default public boolean reset(boolean detachIfReset) {
            return this.reset(detachIfReset, SystemClock.elapsedRealtime() * 1000L);
        }

        public boolean reset(boolean var1, long var2);

        public void detach();
    }

    private static class RadioAccessTechnologyBatteryStats {
        private boolean mActive = false;
        private int mFrequencyRange = 0;
        private int mSignalStrength = 0;
        public final StopwatchTimer[][] perStateTimers;
        private LongSamplingCounter[][] mPerStateTxDurationMs = null;
        private LongSamplingCounter[] mPerFrequencyRxDurationMs = null;

        RadioAccessTechnologyBatteryStats(int freqCount, Clock clock, TimeBase timeBase) {
            this.perStateTimers = new StopwatchTimer[freqCount][5];
            for (int i = 0; i < freqCount; ++i) {
                for (int j = 0; j < 5; ++j) {
                    this.perStateTimers[i][j] = new StopwatchTimer(clock, null, -1, null, timeBase);
                }
            }
        }

        public void noteActive(boolean active, long elapsedRealtimeMs) {
            if (this.mActive == active) {
                return;
            }
            this.mActive = active;
            if (this.mActive) {
                this.perStateTimers[this.mFrequencyRange][this.mSignalStrength].startRunningLocked(elapsedRealtimeMs);
            } else {
                this.perStateTimers[this.mFrequencyRange][this.mSignalStrength].stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteFrequencyRange(int frequencyRange, long elapsedRealtimeMs) {
            if (this.mFrequencyRange == frequencyRange) {
                return;
            }
            if (!this.mActive) {
                this.mFrequencyRange = frequencyRange;
                return;
            }
            this.perStateTimers[this.mFrequencyRange][this.mSignalStrength].stopRunningLocked(elapsedRealtimeMs);
            this.perStateTimers[frequencyRange][this.mSignalStrength].startRunningLocked(elapsedRealtimeMs);
            this.mFrequencyRange = frequencyRange;
        }

        public void noteSignalStrength(int signalStrength, long elapsedRealtimeMs) {
            if (this.mSignalStrength == signalStrength) {
                return;
            }
            if (!this.mActive) {
                this.mSignalStrength = signalStrength;
                return;
            }
            this.perStateTimers[this.mFrequencyRange][this.mSignalStrength].stopRunningLocked(elapsedRealtimeMs);
            this.perStateTimers[this.mFrequencyRange][signalStrength].startRunningLocked(elapsedRealtimeMs);
            this.mSignalStrength = signalStrength;
        }

        public long getTimeSinceMark(int frequencyRange, int signalStrength, long elapsedRealtimeMs) {
            return this.perStateTimers[frequencyRange][signalStrength].getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
        }

        public void setMark(long elapsedRealtimeMs) {
            int size = this.perStateTimers.length;
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < 5; ++j) {
                    this.perStateTimers[i][j].setMark(elapsedRealtimeMs);
                }
            }
        }

        public int getFrequencyRangeCount() {
            return this.perStateTimers.length;
        }

        public void incrementTxDuration(int frequencyRange, int signalStrength, long durationMs) {
            this.getTxDurationCounter(frequencyRange, signalStrength, true).addCountLocked(durationMs);
        }

        public void incrementRxDuration(int frequencyRange, long durationMs) {
            this.getRxDurationCounter(frequencyRange, true).addCountLocked(durationMs);
        }

        public void reset(long elapsedRealtimeUs) {
            int size = this.perStateTimers.length;
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < 5; ++j) {
                    this.perStateTimers[i][j].reset(false, elapsedRealtimeUs);
                    if (this.mPerStateTxDurationMs == null) continue;
                    this.mPerStateTxDurationMs[i][j].reset(false, elapsedRealtimeUs);
                }
                if (this.mPerFrequencyRxDurationMs == null) continue;
                this.mPerFrequencyRxDurationMs[i].reset(false, elapsedRealtimeUs);
            }
        }

        public void writeSummaryToParcel(Parcel out, long elapsedRealtimeUs) {
            int j;
            int i;
            int freqCount = this.perStateTimers.length;
            out.writeInt(freqCount);
            out.writeInt(5);
            for (i = 0; i < freqCount; ++i) {
                for (j = 0; j < 5; ++j) {
                    this.perStateTimers[i][j].writeSummaryFromParcelLocked(out, elapsedRealtimeUs);
                }
            }
            if (this.mPerStateTxDurationMs == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i = 0; i < freqCount; ++i) {
                    for (j = 0; j < 5; ++j) {
                        this.mPerStateTxDurationMs[i][j].writeSummaryFromParcelLocked(out);
                    }
                }
            }
            if (this.mPerFrequencyRxDurationMs == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i = 0; i < freqCount; ++i) {
                    this.mPerFrequencyRxDurationMs[i].writeSummaryFromParcelLocked(out);
                }
            }
        }

        public void readSummaryFromParcel(Parcel in) {
            StopwatchTimer temp;
            int strength;
            int freq;
            int oldFreqCount = in.readInt();
            int oldSignalStrengthCount = in.readInt();
            int currFreqCount = this.perStateTimers.length;
            int currSignalStrengthCount = 5;
            for (freq = 0; freq < oldFreqCount; ++freq) {
                for (strength = 0; strength < oldSignalStrengthCount; ++strength) {
                    if (freq >= currFreqCount || strength >= 5) {
                        temp = new StopwatchTimer(null, null, -1, null, new TimeBase());
                        temp.readSummaryFromParcelLocked(in);
                        continue;
                    }
                    this.perStateTimers[freq][strength].readSummaryFromParcelLocked(in);
                }
            }
            if (in.readInt() == 1) {
                for (freq = 0; freq < oldFreqCount; ++freq) {
                    for (strength = 0; strength < oldSignalStrengthCount; ++strength) {
                        if (freq >= currFreqCount || strength >= 5) {
                            temp = new StopwatchTimer(null, null, -1, null, new TimeBase());
                            temp.readSummaryFromParcelLocked(in);
                        }
                        this.getTxDurationCounter(freq, strength, true).readSummaryFromParcelLocked(in);
                    }
                }
            }
            if (in.readInt() == 1) {
                for (freq = 0; freq < oldFreqCount; ++freq) {
                    if (freq >= currFreqCount) {
                        StopwatchTimer temp2 = new StopwatchTimer(null, null, -1, null, new TimeBase());
                        temp2.readSummaryFromParcelLocked(in);
                        continue;
                    }
                    this.getRxDurationCounter(freq, true).readSummaryFromParcelLocked(in);
                }
            }
        }

        private LongSamplingCounter getTxDurationCounter(int frequencyRange, int signalStrength, boolean make) {
            if (this.mPerStateTxDurationMs == null) {
                if (!make) {
                    return null;
                }
                int freqCount = this.getFrequencyRangeCount();
                int signalStrengthCount = this.perStateTimers[0].length;
                TimeBase timeBase = this.perStateTimers[0][0].mTimeBase;
                this.mPerStateTxDurationMs = new LongSamplingCounter[freqCount][signalStrengthCount];
                for (int freq = 0; freq < freqCount; ++freq) {
                    for (int strength = 0; strength < signalStrengthCount; ++strength) {
                        this.mPerStateTxDurationMs[freq][strength] = new LongSamplingCounter(timeBase);
                    }
                }
            }
            if (frequencyRange < 0 || frequencyRange >= this.getFrequencyRangeCount()) {
                Slog.w(BatteryStatsImpl.TAG, "Unexpected frequency range (" + frequencyRange + ") requested in getTxDurationCounter");
                return null;
            }
            if (signalStrength < 0 || signalStrength >= this.perStateTimers[0].length) {
                Slog.w(BatteryStatsImpl.TAG, "Unexpected signal strength (" + signalStrength + ") requested in getTxDurationCounter");
                return null;
            }
            return this.mPerStateTxDurationMs[frequencyRange][signalStrength];
        }

        private LongSamplingCounter getRxDurationCounter(int frequencyRange, boolean make) {
            if (this.mPerFrequencyRxDurationMs == null) {
                if (!make) {
                    return null;
                }
                int freqCount = this.getFrequencyRangeCount();
                TimeBase timeBase = this.perStateTimers[0][0].mTimeBase;
                this.mPerFrequencyRxDurationMs = new LongSamplingCounter[freqCount];
                for (int freq = 0; freq < freqCount; ++freq) {
                    this.mPerFrequencyRxDurationMs[freq] = new LongSamplingCounter(timeBase);
                }
            }
            if (frequencyRange < 0 || frequencyRange >= this.getFrequencyRangeCount()) {
                Slog.w(BatteryStatsImpl.TAG, "Unexpected frequency range (" + frequencyRange + ") requested in getRxDurationCounter");
                return null;
            }
            return this.mPerFrequencyRxDurationMs[frequencyRange];
        }
    }

    private static class DisplayBatteryStats {
        public int screenState = 0;
        public StopwatchTimer screenOnTimer;
        public StopwatchTimer screenDozeTimer;
        public int screenBrightnessBin = -1;
        public StopwatchTimer[] screenBrightnessTimers = new StopwatchTimer[5];
        public int screenStateAtLastEnergyMeasurement = 0;

        DisplayBatteryStats(Clock clock, TimeBase timeBase) {
            this.screenOnTimer = new StopwatchTimer(clock, null, -1, null, timeBase);
            this.screenDozeTimer = new StopwatchTimer(clock, null, -1, null, timeBase);
            for (int i = 0; i < 5; ++i) {
                this.screenBrightnessTimers[i] = new StopwatchTimer(clock, null, -100 - i, null, timeBase);
            }
        }

        public void reset(long elapsedRealtimeUs) {
            this.screenOnTimer.reset(false, elapsedRealtimeUs);
            this.screenDozeTimer.reset(false, elapsedRealtimeUs);
            for (int i = 0; i < 5; ++i) {
                this.screenBrightnessTimers[i].reset(false, elapsedRealtimeUs);
            }
        }
    }

    public static interface ExternalStatsSync {
        public static final int UPDATE_CPU = 1;
        public static final int UPDATE_WIFI = 2;
        public static final int UPDATE_RADIO = 4;
        public static final int UPDATE_BT = 8;
        public static final int UPDATE_RPM = 16;
        public static final int UPDATE_DISPLAY = 32;
        public static final int RESET = 64;
        public static final int UPDATE_ALL = 63;
        public static final int UPDATE_ON_PROC_STATE_CHANGE = 14;
        public static final int UPDATE_ON_RESET = 127;

        public Future<?> scheduleSync(String var1, int var2);

        public Future<?> scheduleCpuSyncDueToRemovedUid(int var1);

        public Future<?> scheduleCpuSyncDueToSettingChange();

        public Future<?> scheduleSyncDueToScreenStateChange(int var1, boolean var2, boolean var3, int var4, int[] var5);

        public Future<?> scheduleCpuSyncDueToWakelockChange(long var1);

        public void cancelCpuSyncDueToWakelockChange();

        public Future<?> scheduleSyncDueToBatteryLevelChange(long var1);

        public Future<?> scheduleCleanupDueToRemovedUser(int var1);

        public void scheduleSyncDueToProcessStateChange(int var1, long var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ExternalUpdateFlag {
        }
    }

    class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            BatteryCallback cb = BatteryStatsImpl.this.mCallback;
            switch (msg.what) {
                case 1: {
                    if (cb == null) break;
                    cb.batteryNeedsCpuUpdate();
                    break;
                }
                case 2: {
                    if (cb == null) break;
                    cb.batteryPowerChanged(msg.arg1 != 0);
                    break;
                }
                case 3: {
                    String action;
                    if (cb == null) break;
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                    synchronized (batteryStatsImpl) {
                        action = BatteryStatsImpl.this.mCharging ? "android.os.action.CHARGING" : "android.os.action.DISCHARGING";
                    }
                    Intent intent = new Intent(action);
                    intent.addFlags(0x4000000);
                    cb.batterySendBroadcast(intent);
                    break;
                }
                case 4: {
                    if (cb == null) break;
                    cb.batteryStatsReset();
                }
            }
        }
    }

    public static abstract class UserInfoProvider {
        private int[] userIds;

        protected abstract int[] getUserIds();

        @VisibleForTesting
        public void refreshUserIds() {
            this.userIds = this.getUserIds();
        }

        @VisibleForTesting
        public boolean exists(int userId) {
            return this.userIds != null ? ArrayUtils.contains(this.userIds, userId) : true;
        }
    }

    public static interface MeasuredEnergyRetriever {
        public void fillRailDataStats(RailStats var1);
    }

    public static interface PlatformIdleStateCallback {
        public void fillLowPowerStats(RpmStats var1);

        public String getSubsystemLowPowerStats();
    }

    public static interface BatteryCallback {
        public void batteryNeedsCpuUpdate();

        public void batteryPowerChanged(boolean var1);

        public void batterySendBroadcast(Intent var1);

        public void batteryStatsReset();
    }

    public static interface BatteryResetListener {
        public void prepareForBatteryStatsReset(int var1);
    }

    @VisibleForTesting
    public class UidToRemove {
        private final int mStartUid;
        private final int mEndUid;
        private final long mUidRemovalTimestamp;

        public UidToRemove(int uid, long timestamp) {
            this(uid, uid, timestamp);
        }

        public UidToRemove(int startUid, int endUid, long timestamp) {
            this.mStartUid = startUid;
            this.mEndUid = endUid;
            this.mUidRemovalTimestamp = timestamp;
        }

        public long getUidRemovalTimestamp() {
            return this.mUidRemovalTimestamp;
        }

        @GuardedBy(value={"BatteryStatsImpl.this"})
        void removeLocked() {
            BatteryStatsImpl.this.removeCpuStatsForUidRangeLocked(this.mStartUid, this.mEndUid);
        }
    }
}

