/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.hardware.SensorManager;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.Parcel;
import android.os.SystemClock;
import android.os.UidBatteryConsumer;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import com.android.internal.os.AmbientDisplayPowerCalculator;
import com.android.internal.os.AudioPowerCalculator;
import com.android.internal.os.BatteryChargeCalculator;
import com.android.internal.os.BatteryStatsHistory;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.BatteryUsageStatsStore;
import com.android.internal.os.BluetoothPowerCalculator;
import com.android.internal.os.CameraPowerCalculator;
import com.android.internal.os.CpuPowerCalculator;
import com.android.internal.os.CustomMeasuredPowerCalculator;
import com.android.internal.os.FlashlightPowerCalculator;
import com.android.internal.os.GnssPowerCalculator;
import com.android.internal.os.IdlePowerCalculator;
import com.android.internal.os.MemoryPowerCalculator;
import com.android.internal.os.MobileRadioPowerCalculator;
import com.android.internal.os.PhonePowerCalculator;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.ScreenPowerCalculator;
import com.android.internal.os.SensorPowerCalculator;
import com.android.internal.os.SystemServicePowerCalculator;
import com.android.internal.os.UserPowerCalculator;
import com.android.internal.os.VideoPowerCalculator;
import com.android.internal.os.WakelockPowerCalculator;
import com.android.internal.os.WifiPowerCalculator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BatteryUsageStatsProvider {
    private static final String TAG = "BatteryUsageStatsProv";
    private final Context mContext;
    private final BatteryStats mStats;
    private final BatteryUsageStatsStore mBatteryUsageStatsStore;
    private final PowerProfile mPowerProfile;
    private final Object mLock = new Object();
    private List<PowerCalculator> mPowerCalculators;
    private static boolean sErrorReported;

    public BatteryUsageStatsProvider(Context context, BatteryStats stats) {
        this(context, stats, null);
    }

    @VisibleForTesting
    public BatteryUsageStatsProvider(Context context, BatteryStats stats, BatteryUsageStatsStore batteryUsageStatsStore) {
        this.mContext = context;
        this.mStats = stats;
        this.mBatteryUsageStatsStore = batteryUsageStatsStore;
        this.mPowerProfile = stats instanceof BatteryStatsImpl ? ((BatteryStatsImpl)stats).getPowerProfile() : new PowerProfile(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PowerCalculator> getPowerCalculators() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPowerCalculators == null) {
                this.mPowerCalculators = new ArrayList<PowerCalculator>();
                this.mPowerCalculators.add(new BatteryChargeCalculator());
                this.mPowerCalculators.add(new CpuPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new MemoryPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new WakelockPowerCalculator(this.mPowerProfile));
                if (!BatteryStats.checkWifiOnly(this.mContext)) {
                    this.mPowerCalculators.add(new MobileRadioPowerCalculator(this.mPowerProfile));
                }
                this.mPowerCalculators.add(new WifiPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new BluetoothPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new SensorPowerCalculator(this.mContext.getSystemService(SensorManager.class)));
                this.mPowerCalculators.add(new GnssPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new CameraPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new FlashlightPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new AudioPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new VideoPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new PhonePowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new ScreenPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new AmbientDisplayPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new IdlePowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new CustomMeasuredPowerCalculator(this.mPowerProfile));
                this.mPowerCalculators.add(new UserPowerCalculator());
                this.mPowerCalculators.add(new SystemServicePowerCalculator(this.mPowerProfile));
            }
        }
        return this.mPowerCalculators;
    }

    public boolean shouldUpdateStats(List<BatteryUsageStatsQuery> queries, long lastUpdateTimeStampMs) {
        long allowableStatsAge = Long.MAX_VALUE;
        for (int i = queries.size() - 1; i >= 0; --i) {
            BatteryUsageStatsQuery query = queries.get(i);
            allowableStatsAge = Math.min(allowableStatsAge, query.getMaxStatsAge());
        }
        return this.elapsedRealtime() - lastUpdateTimeStampMs > allowableStatsAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BatteryUsageStats> getBatteryUsageStats(List<BatteryUsageStatsQuery> queries) {
        ArrayList<BatteryUsageStats> results = new ArrayList<BatteryUsageStats>(queries.size());
        BatteryStats batteryStats = this.mStats;
        synchronized (batteryStats) {
            this.mStats.prepareForDumpLocked();
            long currentTimeMillis = this.currentTimeMillis();
            for (int i = 0; i < queries.size(); ++i) {
                results.add(this.getBatteryUsageStats(queries.get(i), currentTimeMillis));
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public BatteryUsageStats getBatteryUsageStats(BatteryUsageStatsQuery query) {
        BatteryStats batteryStats = this.mStats;
        synchronized (batteryStats) {
            return this.getBatteryUsageStats(query, this.currentTimeMillis());
        }
    }

    @GuardedBy(value={"mStats"})
    private BatteryUsageStats getBatteryUsageStats(BatteryUsageStatsQuery query, long currentTimeMs) {
        if (query.getToTimestamp() == 0L) {
            return this.getCurrentBatteryUsageStats(query, currentTimeMs);
        }
        return this.getAggregatedBatteryUsageStats(query);
    }

    @GuardedBy(value={"mStats"})
    private BatteryUsageStats getCurrentBatteryUsageStats(BatteryUsageStatsQuery query, long currentTimeMs) {
        long realtimeUs = this.elapsedRealtime() * 1000L;
        long uptimeUs = this.uptimeMillis() * 1000L;
        boolean includePowerModels = (query.getFlags() & 4) != 0;
        boolean includeProcessStateData = (query.getFlags() & 8) != 0 && this.mStats.isProcessStateDataAvailable();
        boolean includeVirtualUids = (query.getFlags() & 0x10) != 0;
        BatteryUsageStats.Builder batteryUsageStatsBuilder = new BatteryUsageStats.Builder(this.mStats.getCustomEnergyConsumerNames(), includePowerModels, includeProcessStateData);
        batteryUsageStatsBuilder.setStatsStartTimestamp(this.mStats.getStartClockTime());
        batteryUsageStatsBuilder.setStatsEndTimestamp(currentTimeMs);
        SparseArray<? extends BatteryStats.Uid> uidStats = this.mStats.getUidStats();
        for (int i = uidStats.size() - 1; i >= 0; --i) {
            BatteryStats.Uid uid = uidStats.valueAt(i);
            if (!includeVirtualUids && uid.getUid() == 1090) continue;
            batteryUsageStatsBuilder.getOrCreateUidBatteryConsumerBuilder(uid).setTimeInStateMs(1, this.getProcessBackgroundTimeMs(uid, realtimeUs)).setTimeInStateMs(0, this.getProcessForegroundTimeMs(uid, realtimeUs));
        }
        int[] powerComponents = query.getPowerComponents();
        List<PowerCalculator> powerCalculators = this.getPowerCalculators();
        int count = powerCalculators.size();
        for (int i = 0; i < count; ++i) {
            PowerCalculator powerCalculator = powerCalculators.get(i);
            if (powerComponents != null) {
                boolean include = false;
                for (int j = 0; j < powerComponents.length; ++j) {
                    if (!powerCalculator.isPowerComponentSupported(powerComponents[j])) continue;
                    include = true;
                    break;
                }
                if (!include) continue;
            }
            powerCalculator.calculate(batteryUsageStatsBuilder, this.mStats, realtimeUs, uptimeUs, query);
        }
        if ((query.getFlags() & 2) != 0) {
            if (!(this.mStats instanceof BatteryStatsImpl)) {
                throw new UnsupportedOperationException("History cannot be included for " + this.getClass().getName());
            }
            BatteryStatsImpl batteryStatsImpl = (BatteryStatsImpl)this.mStats;
            Parcel historyBuffer = Parcel.obtain();
            historyBuffer.appendFrom(batteryStatsImpl.mHistoryBuffer, 0, batteryStatsImpl.mHistoryBuffer.dataSize());
            File systemDir = batteryStatsImpl.mBatteryStatsHistory.getHistoryDirectory().getParentFile();
            BatteryStatsHistory batteryStatsHistory = new BatteryStatsHistory(batteryStatsImpl, systemDir, historyBuffer);
            batteryUsageStatsBuilder.setBatteryHistory(batteryStatsHistory);
        }
        BatteryUsageStats stats = batteryUsageStatsBuilder.build();
        if (includeProcessStateData) {
            this.verify(stats);
        }
        return stats;
    }

    private void verify(BatteryUsageStats stats) {
        if (sErrorReported) {
            return;
        }
        double precision = 2.0;
        int[] components = new int[]{1, 8, 11, 2};
        int[] states = new int[]{1, 2, 3, 4};
        for (UidBatteryConsumer ubc : stats.getUidBatteryConsumers()) {
            for (int component : components) {
                double consumedPower = ubc.getConsumedPower(ubc.getKey(component));
                double sumStates = 0.0;
                for (int state : states) {
                    sumStates += ubc.getConsumedPower(ubc.getKey(component, state));
                }
                if (!(sumStates > consumedPower + 2.0)) continue;
                String error = "Sum of states exceeds total. UID = " + ubc.getUid() + " " + BatteryConsumer.powerComponentIdToString(component) + " total = " + consumedPower + " states = " + sumStates;
                if (!sErrorReported) {
                    Slog.wtf(TAG, error);
                    sErrorReported = true;
                } else {
                    Slog.e(TAG, error);
                }
                return;
            }
        }
    }

    private long getProcessForegroundTimeMs(BatteryStats.Uid uid, long realtimeUs) {
        long topStateDurationUs = uid.getProcessStateTime(0, realtimeUs, 0);
        long foregroundActivityDurationUs = 0L;
        BatteryStats.Timer foregroundActivityTimer = uid.getForegroundActivityTimer();
        if (foregroundActivityTimer != null) {
            foregroundActivityDurationUs = foregroundActivityTimer.getTotalTimeLocked(realtimeUs, 0);
        }
        long totalForegroundDurationUs = Math.min(topStateDurationUs, foregroundActivityDurationUs);
        totalForegroundDurationUs += uid.getProcessStateTime(2, realtimeUs, 0);
        return (totalForegroundDurationUs += uid.getProcessStateTime(1, realtimeUs, 0)) / 1000L;
    }

    private long getProcessBackgroundTimeMs(BatteryStats.Uid uid, long realtimeUs) {
        return uid.getProcessStateTime(3, realtimeUs, 0) / 1000L;
    }

    private BatteryUsageStats getAggregatedBatteryUsageStats(BatteryUsageStatsQuery query) {
        long[] timestamps;
        boolean includePowerModels = (query.getFlags() & 4) != 0;
        boolean includeProcessStateData = (query.getFlags() & 8) != 0 && this.mStats.isProcessStateDataAvailable();
        Object[] customEnergyConsumerNames = this.mStats.getCustomEnergyConsumerNames();
        BatteryUsageStats.Builder builder = new BatteryUsageStats.Builder((String[])customEnergyConsumerNames, includePowerModels, includeProcessStateData);
        if (this.mBatteryUsageStatsStore == null) {
            Log.e(TAG, "BatteryUsageStatsStore is unavailable");
            return builder.build();
        }
        for (long timestamp : timestamps = this.mBatteryUsageStatsStore.listBatteryUsageStatsTimestamps()) {
            BatteryUsageStats snapshot;
            if (timestamp <= query.getFromTimestamp() || timestamp > query.getToTimestamp() || (snapshot = this.mBatteryUsageStatsStore.loadBatteryUsageStats(timestamp)) == null) continue;
            if (!Arrays.equals(snapshot.getCustomPowerComponentNames(), customEnergyConsumerNames)) {
                Log.w(TAG, "Ignoring older BatteryUsageStats snapshot, which has different custom power components: " + Arrays.toString(snapshot.getCustomPowerComponentNames()));
                continue;
            }
            if (includeProcessStateData && !snapshot.isProcessStateDataIncluded()) {
                Log.w(TAG, "Ignoring older BatteryUsageStats snapshot, which  does not include process state data");
                continue;
            }
            builder.add(snapshot);
        }
        return builder.build();
    }

    private long elapsedRealtime() {
        if (this.mStats instanceof BatteryStatsImpl) {
            return ((BatteryStatsImpl)this.mStats).mClock.elapsedRealtime();
        }
        return SystemClock.elapsedRealtime();
    }

    private long uptimeMillis() {
        if (this.mStats instanceof BatteryStatsImpl) {
            return ((BatteryStatsImpl)this.mStats).mClock.uptimeMillis();
        }
        return SystemClock.uptimeMillis();
    }

    private long currentTimeMillis() {
        if (this.mStats instanceof BatteryStatsImpl) {
            return ((BatteryStatsImpl)this.mStats).mClock.currentTimeMillis();
        }
        return System_Delegate.currentTimeMillis();
    }
}

