/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomAnalytics;
import java.util.ArrayList;
import java.util.List;

public interface ITelecomService
extends IInterface {
    public void showInCallScreen(boolean var1, String var2, String var3) throws RemoteException;

    public PhoneAccountHandle getDefaultOutgoingPhoneAccount(String var1, String var2, String var3) throws RemoteException;

    public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount(String var1) throws RemoteException;

    public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle var1) throws RemoteException;

    public ParceledListSlice<PhoneAccountHandle> getCallCapablePhoneAccounts(boolean var1, String var2, String var3) throws RemoteException;

    public ParceledListSlice<PhoneAccountHandle> getSelfManagedPhoneAccounts(String var1, String var2) throws RemoteException;

    public ParceledListSlice<PhoneAccountHandle> getOwnSelfManagedPhoneAccounts(String var1, String var2) throws RemoteException;

    public ParceledListSlice<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String var1, String var2) throws RemoteException;

    public ParceledListSlice<PhoneAccountHandle> getPhoneAccountsForPackage(String var1) throws RemoteException;

    public PhoneAccount getPhoneAccount(PhoneAccountHandle var1, String var2) throws RemoteException;

    public int getAllPhoneAccountsCount() throws RemoteException;

    public ParceledListSlice<PhoneAccount> getAllPhoneAccounts() throws RemoteException;

    public ParceledListSlice<PhoneAccountHandle> getAllPhoneAccountHandles() throws RemoteException;

    public PhoneAccountHandle getSimCallManager(int var1) throws RemoteException;

    public PhoneAccountHandle getSimCallManagerForUser(int var1) throws RemoteException;

    public void registerPhoneAccount(PhoneAccount var1) throws RemoteException;

    public void unregisterPhoneAccount(PhoneAccountHandle var1) throws RemoteException;

    public void clearAccounts(String var1) throws RemoteException;

    public boolean isVoiceMailNumber(PhoneAccountHandle var1, String var2, String var3, String var4) throws RemoteException;

    public String getVoiceMailNumber(PhoneAccountHandle var1, String var2, String var3) throws RemoteException;

    public String getLine1Number(PhoneAccountHandle var1, String var2, String var3) throws RemoteException;

    public ComponentName getDefaultPhoneApp() throws RemoteException;

    public String getDefaultDialerPackage() throws RemoteException;

    public String getDefaultDialerPackageForUser(int var1) throws RemoteException;

    public String getSystemDialerPackage() throws RemoteException;

    public TelecomAnalytics dumpCallAnalytics() throws RemoteException;

    public void silenceRinger(String var1) throws RemoteException;

    public boolean isInCall(String var1, String var2) throws RemoteException;

    public boolean hasManageOngoingCallsPermission(String var1) throws RemoteException;

    public boolean isInManagedCall(String var1, String var2) throws RemoteException;

    public boolean isRinging(String var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telecomm/java/com/android/internal/telecom/ITelecomService.aidl:209:1:209:69")
    public int getCallState() throws RemoteException;

    public int getCallStateUsingPackage(String var1, String var2) throws RemoteException;

    public boolean endCall(String var1) throws RemoteException;

    public void acceptRingingCall(String var1) throws RemoteException;

    public void acceptRingingCallWithVideoState(String var1, int var2) throws RemoteException;

    public void cancelMissedCallsNotification(String var1) throws RemoteException;

    public boolean handlePinMmi(String var1, String var2) throws RemoteException;

    public boolean handlePinMmiForPhoneAccount(PhoneAccountHandle var1, String var2, String var3) throws RemoteException;

    public Uri getAdnUriForPhoneAccount(PhoneAccountHandle var1, String var2) throws RemoteException;

    public boolean isTtySupported(String var1, String var2) throws RemoteException;

    public int getCurrentTtyMode(String var1, String var2) throws RemoteException;

    public void addNewIncomingCall(PhoneAccountHandle var1, Bundle var2) throws RemoteException;

    public void addNewIncomingConference(PhoneAccountHandle var1, Bundle var2) throws RemoteException;

    public void addNewUnknownCall(PhoneAccountHandle var1, Bundle var2) throws RemoteException;

    public void startConference(List<Uri> var1, Bundle var2, String var3) throws RemoteException;

    public void placeCall(Uri var1, Bundle var2, String var3, String var4) throws RemoteException;

    public boolean enablePhoneAccount(PhoneAccountHandle var1, boolean var2) throws RemoteException;

    public boolean setDefaultDialer(String var1) throws RemoteException;

    public void stopBlockSuppression() throws RemoteException;

    public Intent createManageBlockedNumbersIntent() throws RemoteException;

    public Intent createLaunchEmergencyDialerIntent(String var1) throws RemoteException;

    public boolean isIncomingCallPermitted(PhoneAccountHandle var1, String var2) throws RemoteException;

    public boolean isOutgoingCallPermitted(PhoneAccountHandle var1, String var2) throws RemoteException;

    public void waitOnHandlers() throws RemoteException;

    public void acceptHandover(Uri var1, int var2, PhoneAccountHandle var3) throws RemoteException;

    public void setTestEmergencyPhoneAccountPackageNameFilter(String var1) throws RemoteException;

    public boolean isInEmergencyCall() throws RemoteException;

    public void handleCallIntent(Intent var1, String var2) throws RemoteException;

    public void cleanupStuckCalls() throws RemoteException;

    public int cleanupOrphanPhoneAccounts() throws RemoteException;

    public void resetCarMode() throws RemoteException;

    public void setTestDefaultCallRedirectionApp(String var1) throws RemoteException;

    public void requestLogMark(String var1) throws RemoteException;

    public void setTestPhoneAcctSuggestionComponent(String var1) throws RemoteException;

    public void setTestDefaultCallScreeningApp(String var1) throws RemoteException;

    public void addOrRemoveTestCallCompanionApp(String var1, boolean var2) throws RemoteException;

    public void setSystemDialer(ComponentName var1) throws RemoteException;

    public void setTestDefaultDialer(String var1) throws RemoteException;

    public void setTestCallDiagnosticService(String var1) throws RemoteException;

    public boolean isInSelfManagedCall(String var1, UserHandle var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITelecomService {
        public static final String DESCRIPTOR = "com.android.internal.telecom.ITelecomService";
        static final int TRANSACTION_showInCallScreen = 1;
        static final int TRANSACTION_getDefaultOutgoingPhoneAccount = 2;
        static final int TRANSACTION_getUserSelectedOutgoingPhoneAccount = 3;
        static final int TRANSACTION_setUserSelectedOutgoingPhoneAccount = 4;
        static final int TRANSACTION_getCallCapablePhoneAccounts = 5;
        static final int TRANSACTION_getSelfManagedPhoneAccounts = 6;
        static final int TRANSACTION_getOwnSelfManagedPhoneAccounts = 7;
        static final int TRANSACTION_getPhoneAccountsSupportingScheme = 8;
        static final int TRANSACTION_getPhoneAccountsForPackage = 9;
        static final int TRANSACTION_getPhoneAccount = 10;
        static final int TRANSACTION_getAllPhoneAccountsCount = 11;
        static final int TRANSACTION_getAllPhoneAccounts = 12;
        static final int TRANSACTION_getAllPhoneAccountHandles = 13;
        static final int TRANSACTION_getSimCallManager = 14;
        static final int TRANSACTION_getSimCallManagerForUser = 15;
        static final int TRANSACTION_registerPhoneAccount = 16;
        static final int TRANSACTION_unregisterPhoneAccount = 17;
        static final int TRANSACTION_clearAccounts = 18;
        static final int TRANSACTION_isVoiceMailNumber = 19;
        static final int TRANSACTION_getVoiceMailNumber = 20;
        static final int TRANSACTION_getLine1Number = 21;
        static final int TRANSACTION_getDefaultPhoneApp = 22;
        static final int TRANSACTION_getDefaultDialerPackage = 23;
        static final int TRANSACTION_getDefaultDialerPackageForUser = 24;
        static final int TRANSACTION_getSystemDialerPackage = 25;
        static final int TRANSACTION_dumpCallAnalytics = 26;
        static final int TRANSACTION_silenceRinger = 27;
        static final int TRANSACTION_isInCall = 28;
        static final int TRANSACTION_hasManageOngoingCallsPermission = 29;
        static final int TRANSACTION_isInManagedCall = 30;
        static final int TRANSACTION_isRinging = 31;
        static final int TRANSACTION_getCallState = 32;
        static final int TRANSACTION_getCallStateUsingPackage = 33;
        static final int TRANSACTION_endCall = 34;
        static final int TRANSACTION_acceptRingingCall = 35;
        static final int TRANSACTION_acceptRingingCallWithVideoState = 36;
        static final int TRANSACTION_cancelMissedCallsNotification = 37;
        static final int TRANSACTION_handlePinMmi = 38;
        static final int TRANSACTION_handlePinMmiForPhoneAccount = 39;
        static final int TRANSACTION_getAdnUriForPhoneAccount = 40;
        static final int TRANSACTION_isTtySupported = 41;
        static final int TRANSACTION_getCurrentTtyMode = 42;
        static final int TRANSACTION_addNewIncomingCall = 43;
        static final int TRANSACTION_addNewIncomingConference = 44;
        static final int TRANSACTION_addNewUnknownCall = 45;
        static final int TRANSACTION_startConference = 46;
        static final int TRANSACTION_placeCall = 47;
        static final int TRANSACTION_enablePhoneAccount = 48;
        static final int TRANSACTION_setDefaultDialer = 49;
        static final int TRANSACTION_stopBlockSuppression = 50;
        static final int TRANSACTION_createManageBlockedNumbersIntent = 51;
        static final int TRANSACTION_createLaunchEmergencyDialerIntent = 52;
        static final int TRANSACTION_isIncomingCallPermitted = 53;
        static final int TRANSACTION_isOutgoingCallPermitted = 54;
        static final int TRANSACTION_waitOnHandlers = 55;
        static final int TRANSACTION_acceptHandover = 56;
        static final int TRANSACTION_setTestEmergencyPhoneAccountPackageNameFilter = 57;
        static final int TRANSACTION_isInEmergencyCall = 58;
        static final int TRANSACTION_handleCallIntent = 59;
        static final int TRANSACTION_cleanupStuckCalls = 60;
        static final int TRANSACTION_cleanupOrphanPhoneAccounts = 61;
        static final int TRANSACTION_resetCarMode = 62;
        static final int TRANSACTION_setTestDefaultCallRedirectionApp = 63;
        static final int TRANSACTION_requestLogMark = 64;
        static final int TRANSACTION_setTestPhoneAcctSuggestionComponent = 65;
        static final int TRANSACTION_setTestDefaultCallScreeningApp = 66;
        static final int TRANSACTION_addOrRemoveTestCallCompanionApp = 67;
        static final int TRANSACTION_setSystemDialer = 68;
        static final int TRANSACTION_setTestDefaultDialer = 69;
        static final int TRANSACTION_setTestCallDiagnosticService = 70;
        static final int TRANSACTION_isInSelfManagedCall = 71;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITelecomService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITelecomService) {
                return (ITelecomService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "showInCallScreen";
                }
                case 2: {
                    return "getDefaultOutgoingPhoneAccount";
                }
                case 3: {
                    return "getUserSelectedOutgoingPhoneAccount";
                }
                case 4: {
                    return "setUserSelectedOutgoingPhoneAccount";
                }
                case 5: {
                    return "getCallCapablePhoneAccounts";
                }
                case 6: {
                    return "getSelfManagedPhoneAccounts";
                }
                case 7: {
                    return "getOwnSelfManagedPhoneAccounts";
                }
                case 8: {
                    return "getPhoneAccountsSupportingScheme";
                }
                case 9: {
                    return "getPhoneAccountsForPackage";
                }
                case 10: {
                    return "getPhoneAccount";
                }
                case 11: {
                    return "getAllPhoneAccountsCount";
                }
                case 12: {
                    return "getAllPhoneAccounts";
                }
                case 13: {
                    return "getAllPhoneAccountHandles";
                }
                case 14: {
                    return "getSimCallManager";
                }
                case 15: {
                    return "getSimCallManagerForUser";
                }
                case 16: {
                    return "registerPhoneAccount";
                }
                case 17: {
                    return "unregisterPhoneAccount";
                }
                case 18: {
                    return "clearAccounts";
                }
                case 19: {
                    return "isVoiceMailNumber";
                }
                case 20: {
                    return "getVoiceMailNumber";
                }
                case 21: {
                    return "getLine1Number";
                }
                case 22: {
                    return "getDefaultPhoneApp";
                }
                case 23: {
                    return "getDefaultDialerPackage";
                }
                case 24: {
                    return "getDefaultDialerPackageForUser";
                }
                case 25: {
                    return "getSystemDialerPackage";
                }
                case 26: {
                    return "dumpCallAnalytics";
                }
                case 27: {
                    return "silenceRinger";
                }
                case 28: {
                    return "isInCall";
                }
                case 29: {
                    return "hasManageOngoingCallsPermission";
                }
                case 30: {
                    return "isInManagedCall";
                }
                case 31: {
                    return "isRinging";
                }
                case 32: {
                    return "getCallState";
                }
                case 33: {
                    return "getCallStateUsingPackage";
                }
                case 34: {
                    return "endCall";
                }
                case 35: {
                    return "acceptRingingCall";
                }
                case 36: {
                    return "acceptRingingCallWithVideoState";
                }
                case 37: {
                    return "cancelMissedCallsNotification";
                }
                case 38: {
                    return "handlePinMmi";
                }
                case 39: {
                    return "handlePinMmiForPhoneAccount";
                }
                case 40: {
                    return "getAdnUriForPhoneAccount";
                }
                case 41: {
                    return "isTtySupported";
                }
                case 42: {
                    return "getCurrentTtyMode";
                }
                case 43: {
                    return "addNewIncomingCall";
                }
                case 44: {
                    return "addNewIncomingConference";
                }
                case 45: {
                    return "addNewUnknownCall";
                }
                case 46: {
                    return "startConference";
                }
                case 47: {
                    return "placeCall";
                }
                case 48: {
                    return "enablePhoneAccount";
                }
                case 49: {
                    return "setDefaultDialer";
                }
                case 50: {
                    return "stopBlockSuppression";
                }
                case 51: {
                    return "createManageBlockedNumbersIntent";
                }
                case 52: {
                    return "createLaunchEmergencyDialerIntent";
                }
                case 53: {
                    return "isIncomingCallPermitted";
                }
                case 54: {
                    return "isOutgoingCallPermitted";
                }
                case 55: {
                    return "waitOnHandlers";
                }
                case 56: {
                    return "acceptHandover";
                }
                case 57: {
                    return "setTestEmergencyPhoneAccountPackageNameFilter";
                }
                case 58: {
                    return "isInEmergencyCall";
                }
                case 59: {
                    return "handleCallIntent";
                }
                case 60: {
                    return "cleanupStuckCalls";
                }
                case 61: {
                    return "cleanupOrphanPhoneAccounts";
                }
                case 62: {
                    return "resetCarMode";
                }
                case 63: {
                    return "setTestDefaultCallRedirectionApp";
                }
                case 64: {
                    return "requestLogMark";
                }
                case 65: {
                    return "setTestPhoneAcctSuggestionComponent";
                }
                case 66: {
                    return "setTestDefaultCallScreeningApp";
                }
                case 67: {
                    return "addOrRemoveTestCallCompanionApp";
                }
                case 68: {
                    return "setSystemDialer";
                }
                case 69: {
                    return "setTestDefaultDialer";
                }
                case 70: {
                    return "setTestCallDiagnosticService";
                }
                case 71: {
                    return "isInSelfManagedCall";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.showInCallScreen(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    PhoneAccountHandle _result = this.getDefaultOutgoingPhoneAccount(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    PhoneAccountHandle _result = this.getUserSelectedOutgoingPhoneAccount(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.setUserSelectedOutgoingPhoneAccount(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice<PhoneAccountHandle> _result = this.getCallCapablePhoneAccounts(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice<PhoneAccountHandle> _result = this.getSelfManagedPhoneAccounts(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice<PhoneAccountHandle> _result = this.getOwnSelfManagedPhoneAccounts(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice<PhoneAccountHandle> _result = this.getPhoneAccountsSupportingScheme(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice<PhoneAccountHandle> _result = this.getPhoneAccountsForPackage(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    PhoneAccount _result = this.getPhoneAccount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    int _result = this.getAllPhoneAccountsCount();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    ParceledListSlice<PhoneAccount> _result = this.getAllPhoneAccounts();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 13: {
                    ParceledListSlice<PhoneAccountHandle> _result = this.getAllPhoneAccountHandles();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    PhoneAccountHandle _result = this.getSimCallManager(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    PhoneAccountHandle _result = this.getSimCallManagerForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 16: {
                    PhoneAccount _arg0 = data.readTypedObject(PhoneAccount.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerPhoneAccount(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterPhoneAccount(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.clearAccounts(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isVoiceMailNumber(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getVoiceMailNumber(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 21: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getLine1Number(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 22: {
                    ComponentName _result = this.getDefaultPhoneApp();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 23: {
                    String _result = this.getDefaultDialerPackage();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getDefaultDialerPackageForUser(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 25: {
                    String _result = this.getSystemDialerPackage();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 26: {
                    TelecomAnalytics _result = this.dumpCallAnalytics();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.silenceRinger(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isInCall(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasManageOngoingCallsPermission(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isInManagedCall(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isRinging(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    int _result = this.getCallState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 33: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getCallStateUsingPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.endCall(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.acceptRingingCall(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.acceptRingingCallWithVideoState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.cancelMissedCallsNotification(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.handlePinMmi(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.handlePinMmiForPhoneAccount(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 40: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    Uri _result = this.getAdnUriForPhoneAccount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isTtySupported(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getCurrentTtyMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 43: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addNewIncomingCall(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addNewIncomingConference(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addNewUnknownCall(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    ArrayList<Uri> _arg0 = data.createTypedArrayList(Uri.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.startConference(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.placeCall(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.enablePhoneAccount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 49: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.setDefaultDialer(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 50: {
                    this.stopBlockSuppression();
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    Intent _result = this.createManageBlockedNumbersIntent();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 52: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    Intent _result = this.createLaunchEmergencyDialerIntent(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 53: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isIncomingCallPermitted(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 54: {
                    PhoneAccountHandle _arg0 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isOutgoingCallPermitted(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 55: {
                    this.waitOnHandlers();
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    int _arg1 = data.readInt();
                    PhoneAccountHandle _arg2 = data.readTypedObject(PhoneAccountHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.acceptHandover(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setTestEmergencyPhoneAccountPackageNameFilter(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    boolean _result = this.isInEmergencyCall();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 59: {
                    Intent _arg0 = data.readTypedObject(Intent.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.handleCallIntent(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    this.cleanupStuckCalls();
                    reply.writeNoException();
                    break;
                }
                case 61: {
                    int _result = this.cleanupOrphanPhoneAccounts();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 62: {
                    this.resetCarMode();
                    reply.writeNoException();
                    break;
                }
                case 63: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setTestDefaultCallRedirectionApp(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 64: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.requestLogMark(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 65: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setTestPhoneAcctSuggestionComponent(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setTestDefaultCallScreeningApp(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.addOrRemoveTestCallCompanionApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.setSystemDialer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 69: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setTestDefaultDialer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 70: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setTestCallDiagnosticService(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 71: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isInSelfManagedCall(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 70;
        }

        private static class Proxy
        implements ITelecomService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInCallScreen(boolean showDialpad, String callingPackage, String callingFeatureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(showDialpad);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PhoneAccountHandle getDefaultOutgoingPhoneAccount(String uriScheme, String callingPackage, String callingFeatureId) throws RemoteException {
                PhoneAccountHandle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uriScheme);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PhoneAccountHandle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount(String callingPackage) throws RemoteException {
                PhoneAccountHandle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PhoneAccountHandle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle account) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<PhoneAccountHandle> getCallCapablePhoneAccounts(boolean includeDisabledAccounts, String callingPackage, String callingFeatureId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(includeDisabledAccounts);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<PhoneAccountHandle> getSelfManagedPhoneAccounts(String callingPackage, String callingFeatureId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<PhoneAccountHandle> getOwnSelfManagedPhoneAccounts(String callingPackage, String callingFeatureId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String uriScheme, String callingPackage) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uriScheme);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<PhoneAccountHandle> getPhoneAccountsForPackage(String packageName) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PhoneAccount getPhoneAccount(PhoneAccountHandle account, String callingPackage) throws RemoteException {
                PhoneAccount _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PhoneAccount.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAllPhoneAccountsCount() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<PhoneAccount> getAllPhoneAccounts() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<PhoneAccountHandle> getAllPhoneAccountHandles() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PhoneAccountHandle getSimCallManager(int subId) throws RemoteException {
                PhoneAccountHandle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PhoneAccountHandle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PhoneAccountHandle getSimCallManagerForUser(int userId) throws RemoteException {
                PhoneAccountHandle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PhoneAccountHandle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPhoneAccount(PhoneAccount metadata) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(metadata, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPhoneAccount(PhoneAccountHandle account) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearAccounts(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVoiceMailNumber(PhoneAccountHandle accountHandle, String number, String callingPackage, String callingFeatureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accountHandle, 0);
                    _data.writeString(number);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getVoiceMailNumber(PhoneAccountHandle accountHandle, String callingPackage, String callingFeatureId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accountHandle, 0);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getLine1Number(PhoneAccountHandle accountHandle, String callingPackage, String callingFeatureId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accountHandle, 0);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getDefaultPhoneApp() throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDefaultDialerPackage() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDefaultDialerPackageForUser(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSystemDialerPackage() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TelecomAnalytics dumpCallAnalytics() throws RemoteException {
                TelecomAnalytics _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TelecomAnalytics.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void silenceRinger(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInCall(String callingPackage, String callingFeatureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasManageOngoingCallsPermission(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInManagedCall(String callingPackage, String callingFeatureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRinging(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCallState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCallStateUsingPackage(String callingPackage, String callingFeatureId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean endCall(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acceptRingingCall(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acceptRingingCallWithVideoState(String callingPackage, int videoState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(videoState);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelMissedCallsNotification(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean handlePinMmi(String dialString, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(dialString);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean handlePinMmiForPhoneAccount(PhoneAccountHandle accountHandle, String dialString, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accountHandle, 0);
                    _data.writeString(dialString);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Uri getAdnUriForPhoneAccount(PhoneAccountHandle accountHandle, String callingPackage) throws RemoteException {
                Uri _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accountHandle, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Uri.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTtySupported(String callingPackage, String callingFeatureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCurrentTtyMode(String callingPackage, String callingFeatureId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addNewIncomingCall(PhoneAccountHandle phoneAccount, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(phoneAccount, 0);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addNewIncomingConference(PhoneAccountHandle phoneAccount, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(phoneAccount, 0);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addNewUnknownCall(PhoneAccountHandle phoneAccount, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(phoneAccount, 0);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startConference(List<Uri> participants, Bundle extras, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(participants);
                    _data.writeTypedObject(extras, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void placeCall(Uri handle, Bundle extras, String callingPackage, String callingFeatureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(handle, 0);
                    _data.writeTypedObject(extras, 0);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enablePhoneAccount(PhoneAccountHandle accountHandle, boolean isEnabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(accountHandle, 0);
                    _data.writeBoolean(isEnabled);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDefaultDialer(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopBlockSuppression() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Intent createManageBlockedNumbersIntent() throws RemoteException {
                Intent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Intent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Intent createLaunchEmergencyDialerIntent(String number) throws RemoteException {
                Intent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(number);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Intent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isIncomingCallPermitted(PhoneAccountHandle phoneAccountHandle, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(phoneAccountHandle, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOutgoingCallPermitted(PhoneAccountHandle phoneAccountHandle, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(phoneAccountHandle, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void waitOnHandlers() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acceptHandover(Uri srcAddr, int videoState, PhoneAccountHandle destAcct) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(srcAddr, 0);
                    _data.writeInt(videoState);
                    _data.writeTypedObject(destAcct, 0);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestEmergencyPhoneAccountPackageNameFilter(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInEmergencyCall() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleCallIntent(Intent intent, String callingPackageProxy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    _data.writeString(callingPackageProxy);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cleanupStuckCalls() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int cleanupOrphanPhoneAccounts() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetCarMode() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestDefaultCallRedirectionApp(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestLogMark(String message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(message);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestPhoneAcctSuggestionComponent(String flattenedComponentName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(flattenedComponentName);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestDefaultCallScreeningApp(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOrRemoveTestCallCompanionApp(String packageName, boolean isAdded) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(isAdded);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemDialer(ComponentName testComponentName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(testComponentName, 0);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestDefaultDialer(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestCallDiagnosticService(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInSelfManagedCall(String packageName, UserHandle userHandle, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ITelecomService {
        @Override
        public void showInCallScreen(boolean showDialpad, String callingPackage, String callingFeatureId) throws RemoteException {
        }

        @Override
        public PhoneAccountHandle getDefaultOutgoingPhoneAccount(String uriScheme, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle account) throws RemoteException {
        }

        @Override
        public ParceledListSlice<PhoneAccountHandle> getCallCapablePhoneAccounts(boolean includeDisabledAccounts, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice<PhoneAccountHandle> getSelfManagedPhoneAccounts(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice<PhoneAccountHandle> getOwnSelfManagedPhoneAccounts(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String uriScheme, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice<PhoneAccountHandle> getPhoneAccountsForPackage(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public PhoneAccount getPhoneAccount(PhoneAccountHandle account, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public int getAllPhoneAccountsCount() throws RemoteException {
            return 0;
        }

        @Override
        public ParceledListSlice<PhoneAccount> getAllPhoneAccounts() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice<PhoneAccountHandle> getAllPhoneAccountHandles() throws RemoteException {
            return null;
        }

        @Override
        public PhoneAccountHandle getSimCallManager(int subId) throws RemoteException {
            return null;
        }

        @Override
        public PhoneAccountHandle getSimCallManagerForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void registerPhoneAccount(PhoneAccount metadata) throws RemoteException {
        }

        @Override
        public void unregisterPhoneAccount(PhoneAccountHandle account) throws RemoteException {
        }

        @Override
        public void clearAccounts(String packageName) throws RemoteException {
        }

        @Override
        public boolean isVoiceMailNumber(PhoneAccountHandle accountHandle, String number, String callingPackage, String callingFeatureId) throws RemoteException {
            return false;
        }

        @Override
        public String getVoiceMailNumber(PhoneAccountHandle accountHandle, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public String getLine1Number(PhoneAccountHandle accountHandle, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getDefaultPhoneApp() throws RemoteException {
            return null;
        }

        @Override
        public String getDefaultDialerPackage() throws RemoteException {
            return null;
        }

        @Override
        public String getDefaultDialerPackageForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String getSystemDialerPackage() throws RemoteException {
            return null;
        }

        @Override
        public TelecomAnalytics dumpCallAnalytics() throws RemoteException {
            return null;
        }

        @Override
        public void silenceRinger(String callingPackage) throws RemoteException {
        }

        @Override
        public boolean isInCall(String callingPackage, String callingFeatureId) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasManageOngoingCallsPermission(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public boolean isInManagedCall(String callingPackage, String callingFeatureId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isRinging(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public int getCallState() throws RemoteException {
            return 0;
        }

        @Override
        public int getCallStateUsingPackage(String callingPackage, String callingFeatureId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean endCall(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public void acceptRingingCall(String callingPackage) throws RemoteException {
        }

        @Override
        public void acceptRingingCallWithVideoState(String callingPackage, int videoState) throws RemoteException {
        }

        @Override
        public void cancelMissedCallsNotification(String callingPackage) throws RemoteException {
        }

        @Override
        public boolean handlePinMmi(String dialString, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public boolean handlePinMmiForPhoneAccount(PhoneAccountHandle accountHandle, String dialString, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public Uri getAdnUriForPhoneAccount(PhoneAccountHandle accountHandle, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public boolean isTtySupported(String callingPackage, String callingFeatureId) throws RemoteException {
            return false;
        }

        @Override
        public int getCurrentTtyMode(String callingPackage, String callingFeatureId) throws RemoteException {
            return 0;
        }

        @Override
        public void addNewIncomingCall(PhoneAccountHandle phoneAccount, Bundle extras) throws RemoteException {
        }

        @Override
        public void addNewIncomingConference(PhoneAccountHandle phoneAccount, Bundle extras) throws RemoteException {
        }

        @Override
        public void addNewUnknownCall(PhoneAccountHandle phoneAccount, Bundle extras) throws RemoteException {
        }

        @Override
        public void startConference(List<Uri> participants, Bundle extras, String callingPackage) throws RemoteException {
        }

        @Override
        public void placeCall(Uri handle, Bundle extras, String callingPackage, String callingFeatureId) throws RemoteException {
        }

        @Override
        public boolean enablePhoneAccount(PhoneAccountHandle accountHandle, boolean isEnabled) throws RemoteException {
            return false;
        }

        @Override
        public boolean setDefaultDialer(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void stopBlockSuppression() throws RemoteException {
        }

        @Override
        public Intent createManageBlockedNumbersIntent() throws RemoteException {
            return null;
        }

        @Override
        public Intent createLaunchEmergencyDialerIntent(String number) throws RemoteException {
            return null;
        }

        @Override
        public boolean isIncomingCallPermitted(PhoneAccountHandle phoneAccountHandle, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public boolean isOutgoingCallPermitted(PhoneAccountHandle phoneAccountHandle, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public void waitOnHandlers() throws RemoteException {
        }

        @Override
        public void acceptHandover(Uri srcAddr, int videoState, PhoneAccountHandle destAcct) throws RemoteException {
        }

        @Override
        public void setTestEmergencyPhoneAccountPackageNameFilter(String packageName) throws RemoteException {
        }

        @Override
        public boolean isInEmergencyCall() throws RemoteException {
            return false;
        }

        @Override
        public void handleCallIntent(Intent intent, String callingPackageProxy) throws RemoteException {
        }

        @Override
        public void cleanupStuckCalls() throws RemoteException {
        }

        @Override
        public int cleanupOrphanPhoneAccounts() throws RemoteException {
            return 0;
        }

        @Override
        public void resetCarMode() throws RemoteException {
        }

        @Override
        public void setTestDefaultCallRedirectionApp(String packageName) throws RemoteException {
        }

        @Override
        public void requestLogMark(String message) throws RemoteException {
        }

        @Override
        public void setTestPhoneAcctSuggestionComponent(String flattenedComponentName) throws RemoteException {
        }

        @Override
        public void setTestDefaultCallScreeningApp(String packageName) throws RemoteException {
        }

        @Override
        public void addOrRemoveTestCallCompanionApp(String packageName, boolean isAdded) throws RemoteException {
        }

        @Override
        public void setSystemDialer(ComponentName testComponentName) throws RemoteException {
        }

        @Override
        public void setTestDefaultDialer(String packageName) throws RemoteException {
        }

        @Override
        public void setTestCallDiagnosticService(String packageName) throws RemoteException {
        }

        @Override
        public boolean isInSelfManagedCall(String packageName, UserHandle userHandle, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

