/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.ViewAttribute;
import com.google.common.annotations.Beta;
import java.util.Locale;

@Beta
public class SetViewAttributeFixSuggestion
implements FixSuggestion {
    private final ViewAttribute viewAttribute;
    private final String suggestedValue;

    public SetViewAttributeFixSuggestion(ViewAttribute viewAttribute, String suggestedValue) {
        this.viewAttribute = viewAttribute;
        this.suggestedValue = suggestedValue;
    }

    public SetViewAttributeFixSuggestion(String attributeName, String suggestedValue) {
        this(new ViewAttribute(attributeName), suggestedValue);
    }

    public ViewAttribute getViewAttribute() {
        return this.viewAttribute;
    }

    public String getSuggestedValue() {
        return this.suggestedValue;
    }

    @Override
    public CharSequence getRawDescription(Locale locale) {
        if (this.suggestedValue.isEmpty()) {
            return String.format(locale, StringManager.getString(locale, "suggestion_set_view_attribute_with_an_non_empty_string"), this.viewAttribute.getFullyQualifiedName());
        }
        return String.format(locale, StringManager.getString(locale, "suggestion_set_view_attribute"), this.viewAttribute.getFullyQualifiedName(), this.suggestedValue);
    }
}

