/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.android.icu.util.ExtendedCalendar;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import libcore.icu.ICU;
import libcore.icu.LocaleData;

public class SimpleDateFormatData {
    private static final ConcurrentHashMap<String, SimpleDateFormatData> CACHE = new ConcurrentHashMap(3);
    private final Locale locale;
    private final String fullTimeFormat;
    private final String longTimeFormat;
    private final String mediumTimeFormat;
    private final String shortTimeFormat;
    private final String fullDateFormat;
    private final String longDateFormat;
    private final String mediumDateFormat;
    private final String shortDateFormat;

    private SimpleDateFormatData(Locale locale) {
        this.locale = locale;
        ExtendedCalendar extendedCalendar = ICU.getExtendedCalendar(locale, "gregorian");
        String tmpFullTimeFormat = SimpleDateFormatData.getDateTimeFormatString(extendedCalendar, -1, 0);
        if (tmpFullTimeFormat != null) {
            tmpFullTimeFormat = tmpFullTimeFormat.replace('v', 'z');
        }
        this.fullTimeFormat = tmpFullTimeFormat;
        this.longTimeFormat = SimpleDateFormatData.getDateTimeFormatString(extendedCalendar, -1, 1);
        this.mediumTimeFormat = SimpleDateFormatData.getDateTimeFormatString(extendedCalendar, -1, 2);
        this.shortTimeFormat = SimpleDateFormatData.getDateTimeFormatString(extendedCalendar, -1, 3);
        this.fullDateFormat = SimpleDateFormatData.getDateTimeFormatString(extendedCalendar, 0, -1);
        this.longDateFormat = SimpleDateFormatData.getDateTimeFormatString(extendedCalendar, 1, -1);
        this.mediumDateFormat = SimpleDateFormatData.getDateTimeFormatString(extendedCalendar, 2, -1);
        this.shortDateFormat = SimpleDateFormatData.getDateTimeFormatString(extendedCalendar, 3, -1);
    }

    public static SimpleDateFormatData getInstance(Locale locale) {
        Objects.requireNonNull(locale, "locale can't be null");
        locale = LocaleData.getCompatibleLocaleForBug159514442(locale);
        String languageTag = locale.toLanguageTag();
        SimpleDateFormatData data = CACHE.get(languageTag);
        if (data != null) {
            return data;
        }
        data = new SimpleDateFormatData(locale);
        SimpleDateFormatData prev = CACHE.putIfAbsent(languageTag, data);
        if (prev != null) {
            return prev;
        }
        return data;
    }

    public static void initializeCacheInZygote() {
        SimpleDateFormatData.getInstance(Locale.ROOT);
        SimpleDateFormatData.getInstance(Locale.US);
        SimpleDateFormatData.getInstance(AndroidLocale.getDefault());
    }

    public String getDateFormat(int style2) {
        switch (style2) {
            case 3: {
                return this.shortDateFormat;
            }
            case 2: {
                return this.mediumDateFormat;
            }
            case 1: {
                return this.longDateFormat;
            }
            case 0: {
                return this.fullDateFormat;
            }
        }
        throw new AssertionError();
    }

    public String getTimeFormat(int style2) {
        switch (style2) {
            case 3: {
                if (DateFormat.is24Hour == null) {
                    return this.shortTimeFormat;
                }
                return ICU.getTimePattern(this.locale, DateFormat.is24Hour, false);
            }
            case 2: {
                if (DateFormat.is24Hour == null) {
                    return this.mediumTimeFormat;
                }
                return ICU.getTimePattern(this.locale, DateFormat.is24Hour, true);
            }
            case 1: {
                return this.longTimeFormat;
            }
            case 0: {
                return this.fullTimeFormat;
            }
        }
        throw new AssertionError();
    }

    private static String getDateTimeFormatString(ExtendedCalendar extendedCalendar, int dateStyle, int timeStyle) {
        return ICU.transformIcuDateTimePattern_forJavaText(extendedCalendar.getDateTimePattern(dateStyle, timeStyle));
    }
}

