/*
 * Decompiled with CFR 0.152.
 */
package android.app.ambientcontext;

import android.app.PendingIntent;
import android.app.ambientcontext.AmbientContextEventRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;

public interface IAmbientContextManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ambientcontext.IAmbientContextManager";

    public void registerObserver(AmbientContextEventRequest var1, PendingIntent var2, RemoteCallback var3) throws RemoteException;

    public void unregisterObserver(String var1) throws RemoteException;

    public void queryServiceStatus(int[] var1, String var2, RemoteCallback var3) throws RemoteException;

    public void startConsentActivity(int[] var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAmbientContextManager {
        static final int TRANSACTION_registerObserver = 1;
        static final int TRANSACTION_unregisterObserver = 2;
        static final int TRANSACTION_queryServiceStatus = 3;
        static final int TRANSACTION_startConsentActivity = 4;

        public Stub() {
            this.attachInterface(this, IAmbientContextManager.DESCRIPTOR);
        }

        public static IAmbientContextManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAmbientContextManager.DESCRIPTOR);
            if (iin != null && iin instanceof IAmbientContextManager) {
                return (IAmbientContextManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerObserver";
                }
                case 2: {
                    return "unregisterObserver";
                }
                case 3: {
                    return "queryServiceStatus";
                }
                case 4: {
                    return "startConsentActivity";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAmbientContextManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    AmbientContextEventRequest _arg0 = data.readTypedObject(AmbientContextEventRequest.CREATOR);
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerObserver(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterObserver(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int[] _arg0 = data.createIntArray();
                    String _arg1 = data.readString();
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.queryServiceStatus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int[] _arg0 = data.createIntArray();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.startConsentActivity(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IAmbientContextManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAmbientContextManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerObserver(AmbientContextEventRequest request, PendingIntent resultPendingIntent, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAmbientContextManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeTypedObject(resultPendingIntent, 0);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterObserver(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAmbientContextManager.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryServiceStatus(int[] eventTypes, String callingPackage, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAmbientContextManager.DESCRIPTOR);
                    _data.writeIntArray(eventTypes);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startConsentActivity(int[] eventTypes, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAmbientContextManager.DESCRIPTOR);
                    _data.writeIntArray(eventTypes);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAmbientContextManager {
        @Override
        public void registerObserver(AmbientContextEventRequest request, PendingIntent resultPendingIntent, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public void unregisterObserver(String callingPackage) throws RemoteException {
        }

        @Override
        public void queryServiceStatus(int[] eventTypes, String callingPackage, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public void startConsentActivity(int[] eventTypes, String callingPackage) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

