/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.SuppressLint;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.util.BundleUtil;
import android.os.Bundle;
import android.util.ArrayMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SearchSpec {
    public static final String PROJECTION_SCHEMA_TYPE_WILDCARD = "*";
    static final String TERM_MATCH_TYPE_FIELD = "termMatchType";
    static final String SCHEMA_FIELD = "schema";
    static final String NAMESPACE_FIELD = "namespace";
    static final String PACKAGE_NAME_FIELD = "packageName";
    static final String NUM_PER_PAGE_FIELD = "numPerPage";
    static final String RANKING_STRATEGY_FIELD = "rankingStrategy";
    static final String ORDER_FIELD = "order";
    static final String SNIPPET_COUNT_FIELD = "snippetCount";
    static final String SNIPPET_COUNT_PER_PROPERTY_FIELD = "snippetCountPerProperty";
    static final String MAX_SNIPPET_FIELD = "maxSnippet";
    static final String PROJECTION_TYPE_PROPERTY_PATHS_FIELD = "projectionTypeFieldMasks";
    static final String RESULT_GROUPING_TYPE_FLAGS = "resultGroupingTypeFlags";
    static final String RESULT_GROUPING_LIMIT = "resultGroupingLimit";
    public static final int DEFAULT_NUM_PER_PAGE = 10;
    private static final int MAX_NUM_PER_PAGE = 10000;
    private static final int MAX_SNIPPET_COUNT = 10000;
    private static final int MAX_SNIPPET_PER_PROPERTY_COUNT = 10000;
    private static final int MAX_SNIPPET_SIZE_LIMIT = 10000;
    public static final int TERM_MATCH_EXACT_ONLY = 1;
    public static final int TERM_MATCH_PREFIX = 2;
    public static final int RANKING_STRATEGY_NONE = 0;
    public static final int RANKING_STRATEGY_DOCUMENT_SCORE = 1;
    public static final int RANKING_STRATEGY_CREATION_TIMESTAMP = 2;
    public static final int RANKING_STRATEGY_RELEVANCE_SCORE = 3;
    public static final int RANKING_STRATEGY_USAGE_COUNT = 4;
    public static final int RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP = 5;
    public static final int RANKING_STRATEGY_SYSTEM_USAGE_COUNT = 6;
    public static final int RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP = 7;
    public static final int ORDER_DESCENDING = 0;
    public static final int ORDER_ASCENDING = 1;
    public static final int GROUPING_TYPE_PER_PACKAGE = 1;
    public static final int GROUPING_TYPE_PER_NAMESPACE = 2;
    private final Bundle mBundle;

    public SearchSpec(Bundle bundle) {
        Objects.requireNonNull(bundle);
        this.mBundle = bundle;
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public int getTermMatch() {
        return this.mBundle.getInt(TERM_MATCH_TYPE_FIELD, -1);
    }

    public List<String> getFilterSchemas() {
        ArrayList<String> schemas = this.mBundle.getStringArrayList(SCHEMA_FIELD);
        if (schemas == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(schemas);
    }

    public List<String> getFilterNamespaces() {
        ArrayList<String> namespaces = this.mBundle.getStringArrayList(NAMESPACE_FIELD);
        if (namespaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(namespaces);
    }

    public List<String> getFilterPackageNames() {
        ArrayList<String> packageNames = this.mBundle.getStringArrayList(PACKAGE_NAME_FIELD);
        if (packageNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(packageNames);
    }

    public int getResultCountPerPage() {
        return this.mBundle.getInt(NUM_PER_PAGE_FIELD, 10);
    }

    public int getRankingStrategy() {
        return this.mBundle.getInt(RANKING_STRATEGY_FIELD);
    }

    public int getOrder() {
        return this.mBundle.getInt(ORDER_FIELD);
    }

    public int getSnippetCount() {
        return this.mBundle.getInt(SNIPPET_COUNT_FIELD);
    }

    public int getSnippetCountPerProperty() {
        return this.mBundle.getInt(SNIPPET_COUNT_PER_PROPERTY_FIELD);
    }

    public int getMaxSnippetSize() {
        return this.mBundle.getInt(MAX_SNIPPET_FIELD);
    }

    public Map<String, List<String>> getProjections() {
        Bundle typePropertyPathsBundle = this.mBundle.getBundle(PROJECTION_TYPE_PROPERTY_PATHS_FIELD);
        Set<String> schemas = typePropertyPathsBundle.keySet();
        ArrayMap<String, List<String>> typePropertyPathsMap = new ArrayMap<String, List<String>>(schemas.size());
        for (String schema : schemas) {
            typePropertyPathsMap.put(schema, typePropertyPathsBundle.getStringArrayList(schema));
        }
        return typePropertyPathsMap;
    }

    public int getResultGroupingTypeFlags() {
        return this.mBundle.getInt(RESULT_GROUPING_TYPE_FLAGS);
    }

    public int getResultGroupingLimit() {
        return this.mBundle.getInt(RESULT_GROUPING_LIMIT, Integer.MAX_VALUE);
    }

    public static class Builder {
        private ArrayList<String> mSchemas = new ArrayList();
        private ArrayList<String> mNamespaces = new ArrayList();
        private ArrayList<String> mPackageNames = new ArrayList();
        private Bundle mProjectionTypePropertyMasks = new Bundle();
        private int mResultCountPerPage = 10;
        private int mTermMatchType = 2;
        private int mSnippetCount = 0;
        private int mSnippetCountPerProperty = 10000;
        private int mMaxSnippetSize = 0;
        private int mRankingStrategy = 0;
        private int mOrder = 0;
        private int mGroupingTypeFlags = 0;
        private int mGroupingLimit = 0;
        private boolean mBuilt = false;

        public Builder setTermMatch(int termMatchType) {
            Preconditions.checkArgumentInRange(termMatchType, 1, 2, "Term match type");
            this.resetIfBuilt();
            this.mTermMatchType = termMatchType;
            return this;
        }

        public Builder addFilterSchemas(String ... schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            return this.addFilterSchemas(Arrays.asList(schemas));
        }

        public Builder addFilterSchemas(Collection<String> schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            this.mSchemas.addAll(schemas);
            return this;
        }

        public Builder addFilterNamespaces(String ... namespaces) {
            Objects.requireNonNull(namespaces);
            this.resetIfBuilt();
            return this.addFilterNamespaces(Arrays.asList(namespaces));
        }

        public Builder addFilterNamespaces(Collection<String> namespaces) {
            Objects.requireNonNull(namespaces);
            this.resetIfBuilt();
            this.mNamespaces.addAll(namespaces);
            return this;
        }

        public Builder addFilterPackageNames(String ... packageNames) {
            Objects.requireNonNull(packageNames);
            this.resetIfBuilt();
            return this.addFilterPackageNames(Arrays.asList(packageNames));
        }

        public Builder addFilterPackageNames(Collection<String> packageNames) {
            Objects.requireNonNull(packageNames);
            this.resetIfBuilt();
            this.mPackageNames.addAll(packageNames);
            return this;
        }

        public Builder setResultCountPerPage(int resultCountPerPage) {
            Preconditions.checkArgumentInRange(resultCountPerPage, 0, 10000, "resultCountPerPage");
            this.resetIfBuilt();
            this.mResultCountPerPage = resultCountPerPage;
            return this;
        }

        public Builder setRankingStrategy(int rankingStrategy) {
            Preconditions.checkArgumentInRange(rankingStrategy, 0, 7, "Result ranking strategy");
            this.resetIfBuilt();
            this.mRankingStrategy = rankingStrategy;
            return this;
        }

        public Builder setOrder(int order) {
            Preconditions.checkArgumentInRange(order, 0, 1, "Result ranking order");
            this.resetIfBuilt();
            this.mOrder = order;
            return this;
        }

        public Builder setSnippetCount(int snippetCount) {
            Preconditions.checkArgumentInRange(snippetCount, 0, 10000, SearchSpec.SNIPPET_COUNT_FIELD);
            this.resetIfBuilt();
            this.mSnippetCount = snippetCount;
            return this;
        }

        public Builder setSnippetCountPerProperty(int snippetCountPerProperty) {
            Preconditions.checkArgumentInRange(snippetCountPerProperty, 0, 10000, SearchSpec.SNIPPET_COUNT_PER_PROPERTY_FIELD);
            this.resetIfBuilt();
            this.mSnippetCountPerProperty = snippetCountPerProperty;
            return this;
        }

        public Builder setMaxSnippetSize(int maxSnippetSize) {
            Preconditions.checkArgumentInRange(maxSnippetSize, 0, 10000, "maxSnippetSize");
            this.resetIfBuilt();
            this.mMaxSnippetSize = maxSnippetSize;
            return this;
        }

        public Builder addProjection(String schema, Collection<String> propertyPaths) {
            Objects.requireNonNull(schema);
            Objects.requireNonNull(propertyPaths);
            this.resetIfBuilt();
            ArrayList<String> propertyPathsArrayList = new ArrayList<String>(propertyPaths.size());
            for (String propertyPath : propertyPaths) {
                Objects.requireNonNull(propertyPath);
                propertyPathsArrayList.add(propertyPath);
            }
            this.mProjectionTypePropertyMasks.putStringArrayList(schema, propertyPathsArrayList);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setResultGrouping(int groupingTypeFlags, int limit) {
            Preconditions.checkState(groupingTypeFlags != 0, "Result grouping type cannot be zero.");
            this.resetIfBuilt();
            this.mGroupingTypeFlags = groupingTypeFlags;
            this.mGroupingLimit = limit;
            return this;
        }

        public SearchSpec build() {
            Bundle bundle = new Bundle();
            bundle.putStringArrayList(SearchSpec.SCHEMA_FIELD, this.mSchemas);
            bundle.putStringArrayList(SearchSpec.NAMESPACE_FIELD, this.mNamespaces);
            bundle.putStringArrayList(SearchSpec.PACKAGE_NAME_FIELD, this.mPackageNames);
            bundle.putBundle(SearchSpec.PROJECTION_TYPE_PROPERTY_PATHS_FIELD, this.mProjectionTypePropertyMasks);
            bundle.putInt(SearchSpec.NUM_PER_PAGE_FIELD, this.mResultCountPerPage);
            bundle.putInt(SearchSpec.TERM_MATCH_TYPE_FIELD, this.mTermMatchType);
            bundle.putInt(SearchSpec.SNIPPET_COUNT_FIELD, this.mSnippetCount);
            bundle.putInt(SearchSpec.SNIPPET_COUNT_PER_PROPERTY_FIELD, this.mSnippetCountPerProperty);
            bundle.putInt(SearchSpec.MAX_SNIPPET_FIELD, this.mMaxSnippetSize);
            bundle.putInt(SearchSpec.RANKING_STRATEGY_FIELD, this.mRankingStrategy);
            bundle.putInt(SearchSpec.ORDER_FIELD, this.mOrder);
            bundle.putInt(SearchSpec.RESULT_GROUPING_TYPE_FLAGS, this.mGroupingTypeFlags);
            bundle.putInt(SearchSpec.RESULT_GROUPING_LIMIT, this.mGroupingLimit);
            this.mBuilt = true;
            return new SearchSpec(bundle);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mSchemas = new ArrayList<String>(this.mSchemas);
                this.mNamespaces = new ArrayList<String>(this.mNamespaces);
                this.mPackageNames = new ArrayList<String>(this.mPackageNames);
                this.mProjectionTypePropertyMasks = BundleUtil.deepCopy(this.mProjectionTypePropertyMasks);
                this.mBuilt = false;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GroupingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Order {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RankingStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TermMatch {
    }
}

