/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.os.Bundle;
import java.util.Objects;

public class StorageInfo {
    private static final String SIZE_BYTES_FIELD = "sizeBytes";
    private static final String ALIVE_DOCUMENTS_COUNT = "aliveDocumentsCount";
    private static final String ALIVE_NAMESPACES_COUNT = "aliveNamespacesCount";
    private final Bundle mBundle;

    StorageInfo(Bundle bundle) {
        this.mBundle = Objects.requireNonNull(bundle);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public long getSizeBytes() {
        return this.mBundle.getLong(SIZE_BYTES_FIELD);
    }

    public int getAliveDocumentsCount() {
        return this.mBundle.getInt(ALIVE_DOCUMENTS_COUNT);
    }

    public int getAliveNamespacesCount() {
        return this.mBundle.getInt(ALIVE_NAMESPACES_COUNT);
    }

    public static class Builder {
        private long mSizeBytes;
        private int mAliveDocumentsCount;
        private int mAliveNamespacesCount;

        public Builder setSizeBytes(long sizeBytes) {
            this.mSizeBytes = sizeBytes;
            return this;
        }

        public Builder setAliveDocumentsCount(int aliveDocumentsCount) {
            this.mAliveDocumentsCount = aliveDocumentsCount;
            return this;
        }

        public Builder setAliveNamespacesCount(int aliveNamespacesCount) {
            this.mAliveNamespacesCount = aliveNamespacesCount;
            return this;
        }

        public StorageInfo build() {
            Bundle bundle = new Bundle();
            bundle.putLong(StorageInfo.SIZE_BYTES_FIELD, this.mSizeBytes);
            bundle.putInt(StorageInfo.ALIVE_DOCUMENTS_COUNT, this.mAliveDocumentsCount);
            bundle.putInt(StorageInfo.ALIVE_NAMESPACES_COUNT, this.mAliveNamespacesCount);
            return new StorageInfo(bundle);
        }
    }
}

