/*
 * Decompiled with CFR 0.152.
 */
package android.app.prediction;

import android.app.prediction.AppPredictionContext;
import android.app.prediction.AppPredictionSessionId;
import android.app.prediction.AppTargetEvent;
import android.app.prediction.IPredictionCallback;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPredictionManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.prediction.IPredictionManager";

    public void createPredictionSession(AppPredictionContext var1, AppPredictionSessionId var2, IBinder var3) throws RemoteException;

    public void notifyAppTargetEvent(AppPredictionSessionId var1, AppTargetEvent var2) throws RemoteException;

    public void notifyLaunchLocationShown(AppPredictionSessionId var1, String var2, ParceledListSlice var3) throws RemoteException;

    public void sortAppTargets(AppPredictionSessionId var1, ParceledListSlice var2, IPredictionCallback var3) throws RemoteException;

    public void registerPredictionUpdates(AppPredictionSessionId var1, IPredictionCallback var2) throws RemoteException;

    public void unregisterPredictionUpdates(AppPredictionSessionId var1, IPredictionCallback var2) throws RemoteException;

    public void requestPredictionUpdate(AppPredictionSessionId var1) throws RemoteException;

    public void onDestroyPredictionSession(AppPredictionSessionId var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPredictionManager {
        static final int TRANSACTION_createPredictionSession = 1;
        static final int TRANSACTION_notifyAppTargetEvent = 2;
        static final int TRANSACTION_notifyLaunchLocationShown = 3;
        static final int TRANSACTION_sortAppTargets = 4;
        static final int TRANSACTION_registerPredictionUpdates = 5;
        static final int TRANSACTION_unregisterPredictionUpdates = 6;
        static final int TRANSACTION_requestPredictionUpdate = 7;
        static final int TRANSACTION_onDestroyPredictionSession = 8;

        public Stub() {
            this.attachInterface(this, IPredictionManager.DESCRIPTOR);
        }

        public static IPredictionManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPredictionManager.DESCRIPTOR);
            if (iin != null && iin instanceof IPredictionManager) {
                return (IPredictionManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createPredictionSession";
                }
                case 2: {
                    return "notifyAppTargetEvent";
                }
                case 3: {
                    return "notifyLaunchLocationShown";
                }
                case 4: {
                    return "sortAppTargets";
                }
                case 5: {
                    return "registerPredictionUpdates";
                }
                case 6: {
                    return "unregisterPredictionUpdates";
                }
                case 7: {
                    return "requestPredictionUpdate";
                }
                case 8: {
                    return "onDestroyPredictionSession";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPredictionManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    AppPredictionContext _arg0 = data.readTypedObject(AppPredictionContext.CREATOR);
                    AppPredictionSessionId _arg1 = data.readTypedObject(AppPredictionSessionId.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createPredictionSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    AppPredictionSessionId _arg0 = data.readTypedObject(AppPredictionSessionId.CREATOR);
                    AppTargetEvent _arg1 = data.readTypedObject(AppTargetEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyAppTargetEvent(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    AppPredictionSessionId _arg0 = data.readTypedObject(AppPredictionSessionId.CREATOR);
                    String _arg1 = data.readString();
                    ParceledListSlice _arg2 = data.readTypedObject(ParceledListSlice.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyLaunchLocationShown(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    AppPredictionSessionId _arg0 = data.readTypedObject(AppPredictionSessionId.CREATOR);
                    ParceledListSlice _arg1 = data.readTypedObject(ParceledListSlice.CREATOR);
                    IPredictionCallback _arg2 = IPredictionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.sortAppTargets(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    AppPredictionSessionId _arg0 = data.readTypedObject(AppPredictionSessionId.CREATOR);
                    IPredictionCallback _arg1 = IPredictionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPredictionUpdates(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    AppPredictionSessionId _arg0 = data.readTypedObject(AppPredictionSessionId.CREATOR);
                    IPredictionCallback _arg1 = IPredictionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterPredictionUpdates(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    AppPredictionSessionId _arg0 = data.readTypedObject(AppPredictionSessionId.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestPredictionUpdate(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    AppPredictionSessionId _arg0 = data.readTypedObject(AppPredictionSessionId.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDestroyPredictionSession(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IPredictionManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPredictionManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createPredictionSession(AppPredictionContext context, AppPredictionSessionId sessionId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPredictionManager.DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAppTargetEvent(AppPredictionSessionId sessionId, AppTargetEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPredictionManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyLaunchLocationShown(AppPredictionSessionId sessionId, String launchLocation, ParceledListSlice targetIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPredictionManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeString(launchLocation);
                    _data.writeTypedObject(targetIds, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sortAppTargets(AppPredictionSessionId sessionId, ParceledListSlice targets, IPredictionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPredictionManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(targets, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPredictionManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPredictionManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestPredictionUpdate(AppPredictionSessionId sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPredictionManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDestroyPredictionSession(AppPredictionSessionId sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPredictionManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPredictionManager {
        @Override
        public void createPredictionSession(AppPredictionContext context, AppPredictionSessionId sessionId, IBinder token) throws RemoteException {
        }

        @Override
        public void notifyAppTargetEvent(AppPredictionSessionId sessionId, AppTargetEvent event) throws RemoteException {
        }

        @Override
        public void notifyLaunchLocationShown(AppPredictionSessionId sessionId, String launchLocation, ParceledListSlice targetIds) throws RemoteException {
        }

        @Override
        public void sortAppTargets(AppPredictionSessionId sessionId, ParceledListSlice targets, IPredictionCallback callback) throws RemoteException {
        }

        @Override
        public void registerPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) throws RemoteException {
        }

        @Override
        public void requestPredictionUpdate(AppPredictionSessionId sessionId) throws RemoteException {
        }

        @Override
        public void onDestroyPredictionSession(AppPredictionSessionId sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

