/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.app.sdksandbox.IRemoteSdkCallback;
import android.app.sdksandbox.ISdkSandboxManager;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SdkSandboxManager {
    public static final String SDK_SANDBOX_SERVICE = "sdk_sandbox";
    private final ISdkSandboxManager mService;
    private final Context mContext;
    public static final int SDK_SANDBOX_STATE_DISABLED = 0;
    public static final int SDK_SANDBOX_STATE_ENABLED_PROCESS_ISOLATION = 2;
    public static final int LOAD_SDK_SDK_NOT_FOUND = 100;
    public static final int LOAD_SDK_SDK_ALREADY_LOADED = 101;
    public static final int LOAD_SDK_INTERNAL_ERROR = 500;
    public static final int SURFACE_PACKAGE_INTERNAL_ERROR = 700;

    public SdkSandboxManager(Context context, ISdkSandboxManager binder) {
        this.mContext = context;
        this.mService = binder;
    }

    public static int getSdkSandboxState() {
        return 0;
    }

    public void loadSdk(String name, Bundle params, IRemoteSdkCallback callback) {
        try {
            this.mService.loadSdk(this.mContext.getPackageName(), name, params, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestSurfacePackage(IBinder sdkToken, IBinder hostToken, int displayId, Bundle params) {
        try {
            this.mService.requestSurfacePackage(sdkToken, hostToken, displayId, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendData(int id2, Bundle params) {
        try {
            this.mService.sendData(id2, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SdkSandboxState {
    }
}

