/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattCallback;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.os.Handler;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;

public class BluetoothGatt
implements BluetoothProfile {
    private static final String TAG = "BluetoothGatt";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    @UnsupportedAppUsage
    private IBluetoothGatt mService;
    @UnsupportedAppUsage
    private volatile BluetoothGattCallback mCallback;
    private Handler mHandler;
    @UnsupportedAppUsage
    private int mClientIf;
    private BluetoothDevice mDevice;
    @UnsupportedAppUsage
    private boolean mAutoConnect;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mAuthRetryState;
    private int mConnState;
    private final Object mStateLock = new Object();
    private final Object mDeviceBusyLock = new Object();
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Boolean mDeviceBusy = false;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mTransport;
    private int mPhy;
    private boolean mOpportunistic;
    private final AttributionSource mAttributionSource;
    private static final int AUTH_RETRY_STATE_IDLE = 0;
    private static final int AUTH_RETRY_STATE_NO_MITM = 1;
    private static final int AUTH_RETRY_STATE_MITM = 2;
    private static final int CONN_STATE_IDLE = 0;
    private static final int CONN_STATE_CONNECTING = 1;
    private static final int CONN_STATE_CONNECTED = 2;
    private static final int CONN_STATE_DISCONNECTING = 3;
    private static final int CONN_STATE_CLOSED = 4;
    private static final int WRITE_CHARACTERISTIC_MAX_RETRIES = 5;
    private static final int WRITE_CHARACTERISTIC_TIME_TO_WAIT = 10;
    private List<BluetoothGattService> mServices;
    public static final int GATT_SUCCESS = 0;
    public static final int GATT_READ_NOT_PERMITTED = 2;
    public static final int GATT_WRITE_NOT_PERMITTED = 3;
    public static final int GATT_INSUFFICIENT_AUTHENTICATION = 5;
    public static final int GATT_REQUEST_NOT_SUPPORTED = 6;
    public static final int GATT_INSUFFICIENT_ENCRYPTION = 15;
    public static final int GATT_INVALID_OFFSET = 7;
    public static final int GATT_INSUFFICIENT_AUTHORIZATION = 8;
    public static final int GATT_INVALID_ATTRIBUTE_LENGTH = 13;
    public static final int GATT_CONNECTION_CONGESTED = 143;
    public static final int GATT_FAILURE = 257;
    public static final int CONNECTION_PRIORITY_BALANCED = 0;
    public static final int CONNECTION_PRIORITY_HIGH = 1;
    public static final int CONNECTION_PRIORITY_LOW_POWER = 2;
    static final int AUTHENTICATION_NONE = 0;
    static final int AUTHENTICATION_NO_MITM = 1;
    static final int AUTHENTICATION_MITM = 2;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothGattCallback mBluetoothGattCallback = new IBluetoothGattCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        public void onClientRegistered(int status, int clientIf) {
            Log.d(BluetoothGatt.TAG, "onClientRegistered() - status=" + status + " clientIf=" + clientIf);
            BluetoothGatt.this.mClientIf = clientIf;
            if (status != 0) {
                BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                        if (callback != null) {
                            callback.onConnectionStateChange(BluetoothGatt.this, 257, 0);
                        }
                    }
                });
                Object object = BluetoothGatt.this.mStateLock;
                synchronized (object) {
                    BluetoothGatt.this.mConnState = 0;
                }
                return;
            }
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                BluetoothGatt.this.mService.clientConnect(BluetoothGatt.this.mClientIf, BluetoothGatt.this.mDevice.getAddress(), !BluetoothGatt.this.mAutoConnect, BluetoothGatt.this.mTransport, BluetoothGatt.this.mOpportunistic, BluetoothGatt.this.mPhy, BluetoothGatt.this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(BluetoothGatt.TAG, "", e);
            }
        }

        @Override
        public void onPhyUpdate(String address, final int txPhy, final int rxPhy, final int status) {
            Log.d(BluetoothGatt.TAG, "onPhyUpdate() - status=" + status + " address=" + address + " txPhy=" + txPhy + " rxPhy=" + rxPhy);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onPhyUpdate(BluetoothGatt.this, txPhy, rxPhy, status);
                    }
                }
            });
        }

        @Override
        public void onPhyRead(String address, final int txPhy, final int rxPhy, final int status) {
            Log.d(BluetoothGatt.TAG, "onPhyRead() - status=" + status + " address=" + address + " txPhy=" + txPhy + " rxPhy=" + rxPhy);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onPhyRead(BluetoothGatt.this, txPhy, rxPhy, status);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClientConnectionState(final int status, int clientIf, boolean connected, String address) {
            Log.d(BluetoothGatt.TAG, "onClientConnectionState() - status=" + status + " clientIf=" + clientIf + " device=" + address);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            final int profileState = connected ? 2 : 0;
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onConnectionStateChange(BluetoothGatt.this, status, profileState);
                    }
                }
            });
            Object object = BluetoothGatt.this.mStateLock;
            synchronized (object) {
                BluetoothGatt.this.mConnState = connected ? 2 : 0;
            }
            object = BluetoothGatt.this.mDeviceBusyLock;
            synchronized (object) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
        }

        @Override
        public void onSearchComplete(String address, List<BluetoothGattService> services, final int status) {
            Log.d(BluetoothGatt.TAG, "onSearchComplete() = Device=" + address + " Status=" + status);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            for (BluetoothGattService s : services) {
                s.setDevice(BluetoothGatt.this.mDevice);
            }
            BluetoothGatt.this.mServices.addAll(services);
            for (BluetoothGattService fixedService : BluetoothGatt.this.mServices) {
                ArrayList<BluetoothGattService> includedServices = new ArrayList<BluetoothGattService>(fixedService.getIncludedServices());
                fixedService.getIncludedServices().clear();
                for (BluetoothGattService brokenRef : includedServices) {
                    BluetoothGattService includedService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, brokenRef.getUuid(), brokenRef.getInstanceId());
                    if (includedService != null) {
                        fixedService.addIncludedService(includedService);
                        continue;
                    }
                    Log.e(BluetoothGatt.TAG, "Broken GATT database: can't find included service.");
                }
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onServicesDiscovered(BluetoothGatt.this, status);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        public void onCharacteristicRead(String address, final int status, int handle, final byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Object object = BluetoothGatt.this.mDeviceBusyLock;
            synchronized (object) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            if ((status == 5 || status == 15) && BluetoothGatt.this.mAuthRetryState != 2) {
                try {
                    int authReq = BluetoothGatt.this.mAuthRetryState == 0 ? 1 : 2;
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    BluetoothGatt.this.mService.readCharacteristic(BluetoothGatt.this.mClientIf, address, handle, authReq, BluetoothGatt.this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                    ++BluetoothGatt.this.mAuthRetryState;
                    return;
                }
                catch (RemoteException | TimeoutException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetryState = 0;
            final BluetoothGattCharacteristic characteristic = BluetoothGatt.this.getCharacteristicById(BluetoothGatt.this.mDevice, handle);
            if (characteristic == null) {
                Log.w(BluetoothGatt.TAG, "onCharacteristicRead() failed to find characteristic!");
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        if (status == 0) {
                            characteristic.setValue(value);
                        }
                        callback.onCharacteristicRead(BluetoothGatt.this, characteristic, value, status);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        public void onCharacteristicWrite(String address, final int status, int handle, byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Object object = BluetoothGatt.this.mDeviceBusyLock;
            synchronized (object) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            final BluetoothGattCharacteristic characteristic = BluetoothGatt.this.getCharacteristicById(BluetoothGatt.this.mDevice, handle);
            if (characteristic == null) {
                return;
            }
            if ((status == 5 || status == 15) && BluetoothGatt.this.mAuthRetryState != 2) {
                try {
                    int authReq = BluetoothGatt.this.mAuthRetryState == 0 ? 1 : 2;
                    int requestStatus = Integer.MAX_VALUE;
                    for (int i = 0; i < 5; ++i) {
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        BluetoothGatt.this.mService.writeCharacteristic(BluetoothGatt.this.mClientIf, address, handle, characteristic.getWriteType(), authReq, value, BluetoothGatt.this.mAttributionSource, recv);
                        requestStatus = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(9);
                        if (requestStatus != 201) break;
                        try {
                            Thread.sleep(10L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ++BluetoothGatt.this.mAuthRetryState;
                    return;
                }
                catch (RemoteException | TimeoutException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetryState = 0;
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onCharacteristicWrite(BluetoothGatt.this, characteristic, status);
                    }
                }
            });
        }

        @Override
        public void onNotify(String address, int handle, final byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            final BluetoothGattCharacteristic characteristic = BluetoothGatt.this.getCharacteristicById(BluetoothGatt.this.mDevice, handle);
            if (characteristic == null) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        characteristic.setValue(value);
                        callback.onCharacteristicChanged(BluetoothGatt.this, characteristic, value);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        public void onDescriptorRead(String address, final int status, int handle, final byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Object object = BluetoothGatt.this.mDeviceBusyLock;
            synchronized (object) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            final BluetoothGattDescriptor descriptor = BluetoothGatt.this.getDescriptorById(BluetoothGatt.this.mDevice, handle);
            if (descriptor == null) {
                return;
            }
            if ((status == 5 || status == 15) && BluetoothGatt.this.mAuthRetryState != 2) {
                try {
                    int authReq = BluetoothGatt.this.mAuthRetryState == 0 ? 1 : 2;
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    BluetoothGatt.this.mService.readDescriptor(BluetoothGatt.this.mClientIf, address, handle, authReq, BluetoothGatt.this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                    ++BluetoothGatt.this.mAuthRetryState;
                    return;
                }
                catch (RemoteException | TimeoutException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetryState = 0;
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        if (status == 0) {
                            descriptor.setValue(value);
                        }
                        callback.onDescriptorRead(BluetoothGatt.this, descriptor, status, value);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        public void onDescriptorWrite(String address, final int status, int handle, byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Object object = BluetoothGatt.this.mDeviceBusyLock;
            synchronized (object) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            final BluetoothGattDescriptor descriptor = BluetoothGatt.this.getDescriptorById(BluetoothGatt.this.mDevice, handle);
            if (descriptor == null) {
                return;
            }
            if ((status == 5 || status == 15) && BluetoothGatt.this.mAuthRetryState != 2) {
                try {
                    int authReq = BluetoothGatt.this.mAuthRetryState == 0 ? 1 : 2;
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    BluetoothGatt.this.mService.writeDescriptor(BluetoothGatt.this.mClientIf, address, handle, authReq, value, BluetoothGatt.this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                    ++BluetoothGatt.this.mAuthRetryState;
                    return;
                }
                catch (RemoteException | TimeoutException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetryState = 0;
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onDescriptorWrite(BluetoothGatt.this, descriptor, status);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExecuteWrite(String address, final int status) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Object object = BluetoothGatt.this.mDeviceBusyLock;
            synchronized (object) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onReliableWriteCompleted(BluetoothGatt.this, status);
                    }
                }
            });
        }

        @Override
        public void onReadRemoteRssi(String address, final int rssi, final int status) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onReadRemoteRssi(BluetoothGatt.this, rssi, status);
                    }
                }
            });
        }

        @Override
        public void onConfigureMTU(String address, final int mtu, final int status) {
            Log.d(BluetoothGatt.TAG, "onConfigureMTU() - Device=" + address + " mtu=" + mtu + " status=" + status);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onMtuChanged(BluetoothGatt.this, mtu, status);
                    }
                }
            });
        }

        @Override
        public void onConnectionUpdated(String address, final int interval, final int latency, final int timeout, final int status) {
            Log.d(BluetoothGatt.TAG, "onConnectionUpdated() - Device=" + address + " interval=" + interval + " latency=" + latency + " timeout=" + timeout + " status=" + status);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onConnectionUpdated(BluetoothGatt.this, interval, latency, timeout, status);
                    }
                }
            });
        }

        @Override
        public void onServiceChanged(String address) {
            Log.d(BluetoothGatt.TAG, "onServiceChanged() - Device=" + address);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onServiceChanged(BluetoothGatt.this);
                    }
                }
            });
        }
    };

    BluetoothGatt(IBluetoothGatt iGatt, BluetoothDevice device, int transport, boolean opportunistic, int phy, AttributionSource attributionSource) {
        this.mService = iGatt;
        this.mDevice = device;
        this.mTransport = transport;
        this.mPhy = phy;
        this.mOpportunistic = opportunistic;
        this.mAttributionSource = attributionSource;
        this.mServices = new ArrayList<BluetoothGattService>();
        this.mConnState = 0;
        this.mAuthRetryState = 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void close() {
        Log.d(TAG, "close()");
        this.unregisterApp();
        this.mConnState = 4;
        this.mAuthRetryState = 0;
    }

    BluetoothGattService getService(BluetoothDevice device, UUID uuid, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            if (!svc.getDevice().equals(device) || svc.getInstanceId() != instanceId || !svc.getUuid().equals(uuid)) continue;
            return svc;
        }
        return null;
    }

    BluetoothGattCharacteristic getCharacteristicById(BluetoothDevice device, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                if (charac.getInstanceId() != instanceId) continue;
                return charac;
            }
        }
        return null;
    }

    BluetoothGattDescriptor getDescriptorById(BluetoothDevice device, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                for (BluetoothGattDescriptor desc : charac.getDescriptors()) {
                    if (desc.getInstanceId() != instanceId) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    private void runOrQueueCallback(Runnable cb) {
        if (this.mHandler == null) {
            try {
                cb.run();
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception in callback", ex);
            }
        } else {
            this.mHandler.post(cb);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private boolean registerApp(BluetoothGattCallback callback, Handler handler) {
        return this.registerApp(callback, handler, false);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private boolean registerApp(BluetoothGattCallback callback, Handler handler, boolean eatt_support) {
        Log.d(TAG, "registerApp()");
        if (this.mService == null) {
            return false;
        }
        this.mCallback = callback;
        this.mHandler = handler;
        UUID uuid = UUID.randomUUID();
        Log.d(TAG, "registerApp() - UUID=" + uuid);
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.registerClient(new ParcelUuid(uuid), this.mBluetoothGattCallback, eatt_support, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private void unregisterApp() {
        Log.d(TAG, "unregisterApp() - mClientIf=" + this.mClientIf);
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.unregisterClient(this.mClientIf, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            this.mClientIf = 0;
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    boolean connect(Boolean autoConnect, BluetoothGattCallback callback, Handler handler) {
        Log.d(TAG, "connect() - device: " + this.mDevice.getAddress() + ", auto: " + autoConnect);
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mConnState != 0) {
                throw new IllegalStateException("Not idle");
            }
            this.mConnState = 1;
        }
        this.mAutoConnect = autoConnect;
        if (!this.registerApp(callback, handler)) {
            object = this.mStateLock;
            synchronized (object) {
                this.mConnState = 0;
            }
            Log.e(TAG, "Failed to register callback");
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void disconnect() {
        Log.d(TAG, "cancelOpen() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.clientDisconnect(this.mClientIf, this.mDevice.getAddress(), this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean connect() {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.clientConnect(this.mClientIf, this.mDevice.getAddress(), false, this.mTransport, this.mOpportunistic, this.mPhy, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            return true;
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setPreferredPhy(int txPhy, int rxPhy, int phyOptions) {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.clientSetPreferredPhy(this.mClientIf, this.mDevice.getAddress(), txPhy, rxPhy, phyOptions, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void readPhy() {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.clientReadPhy(this.mClientIf, this.mDevice.getAddress(), this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresNoPermission
    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean discoverServices() {
        Log.d(TAG, "discoverServices() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        this.mServices.clear();
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.discoverServices(this.mClientIf, this.mDevice.getAddress(), this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean discoverServiceByUuid(UUID uuid) {
        Log.d(TAG, "discoverServiceByUuid() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        this.mServices.clear();
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.discoverServiceByUuid(this.mClientIf, this.mDevice.getAddress(), new ParcelUuid(uuid), this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresNoPermission
    public List<BluetoothGattService> getServices() {
        ArrayList<BluetoothGattService> result = new ArrayList<BluetoothGattService>();
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice)) continue;
            result.add(service);
        }
        return result;
    }

    @RequiresNoPermission
    public BluetoothGattService getService(UUID uuid) {
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice) || !service.getUuid().equals(uuid)) continue;
            return service;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean readCharacteristic(BluetoothGattCharacteristic characteristic) {
        if ((characteristic.getProperties() & 2) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Object object = this.mDeviceBusyLock;
        synchronized (object) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.readCharacteristic(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), 0, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            Object object2 = this.mDeviceBusyLock;
            synchronized (object2) {
                this.mDeviceBusy = false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean readUsingCharacteristicUuid(UUID uuid, int startHandle, int endHandle) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        Object object = this.mDeviceBusyLock;
        synchronized (object) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.readUsingCharacteristicUuid(this.mClientIf, this.mDevice.getAddress(), new ParcelUuid(uuid), startHandle, endHandle, 0, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            Object object2 = this.mDeviceBusyLock;
            synchronized (object2) {
                this.mDeviceBusy = false;
            }
            return false;
        }
        return true;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        try {
            return this.writeCharacteristic(characteristic, characteristic.getValue(), characteristic.getWriteType()) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int writeCharacteristic(BluetoothGattCharacteristic characteristic, byte[] value, int writeType) {
        if (characteristic == null) {
            throw new IllegalArgumentException("characteristic must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if ((characteristic.getProperties() & 8) == 0 && (characteristic.getProperties() & 4) == 0) {
            return 200;
        }
        if (this.mService == null || this.mClientIf == 0) {
            return 9;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            throw new IllegalArgumentException("Characteristic must have a non-null service");
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            throw new IllegalArgumentException("Service must have a non-null device");
        }
        Object object = this.mDeviceBusyLock;
        synchronized (object) {
            if (this.mDeviceBusy.booleanValue()) {
                return 201;
            }
            this.mDeviceBusy = true;
        }
        int requestStatus = Integer.MAX_VALUE;
        try {
            for (int i = 0; i < 5; ++i) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.writeCharacteristic(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), writeType, 0, value, this.mAttributionSource, recv);
                requestStatus = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(9);
                if (requestStatus == 201) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                break;
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, "", e);
            Object object2 = this.mDeviceBusyLock;
            synchronized (object2) {
                this.mDeviceBusy = false;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            Object object3 = this.mDeviceBusyLock;
            synchronized (object3) {
                this.mDeviceBusy = false;
            }
            throw e.rethrowFromSystemServer();
        }
        return requestStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean readDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Object object = this.mDeviceBusyLock;
        synchronized (object) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.readDescriptor(this.mClientIf, device.getAddress(), descriptor.getInstanceId(), 0, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            Object object2 = this.mDeviceBusyLock;
            synchronized (object2) {
                this.mDeviceBusy = false;
            }
            return false;
        }
        return true;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean writeDescriptor(BluetoothGattDescriptor descriptor) {
        try {
            return this.writeDescriptor(descriptor, descriptor.getValue()) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int writeDescriptor(BluetoothGattDescriptor descriptor, byte[] value) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (this.mService == null || this.mClientIf == 0) {
            return 9;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            throw new IllegalArgumentException("Descriptor must have a non-null characteristic");
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            throw new IllegalArgumentException("Characteristic must have a non-null service");
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            throw new IllegalArgumentException("Service must have a non-null device");
        }
        Object object = this.mDeviceBusyLock;
        synchronized (object) {
            if (this.mDeviceBusy.booleanValue()) {
                return 201;
            }
            this.mDeviceBusy = true;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.writeDescriptor(this.mClientIf, device.getAddress(), descriptor.getInstanceId(), 0, value, this.mAttributionSource, recv);
            return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(9);
        }
        catch (TimeoutException e) {
            Log.e(TAG, "", e);
            Object object2 = this.mDeviceBusyLock;
            synchronized (object2) {
                this.mDeviceBusy = false;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            Object object3 = this.mDeviceBusyLock;
            synchronized (object3) {
                this.mDeviceBusy = false;
            }
            e.rethrowFromSystemServer();
        }
        return Integer.MAX_VALUE;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean beginReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.beginReliableWrite(this.mClientIf, this.mDevice.getAddress(), this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean executeReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        Object object = this.mDeviceBusyLock;
        synchronized (object) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), true, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            Object object2 = this.mDeviceBusyLock;
            synchronized (object2) {
                this.mDeviceBusy = false;
            }
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void abortReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), false, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void abortReliableWrite(BluetoothDevice mDevice) {
        this.abortReliableWrite();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enable) {
        Log.d(TAG, "setCharacteristicNotification() - uuid: " + characteristic.getUuid() + " enable: " + enable);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.registerForNotification(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), enable, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean refresh() {
        Log.d(TAG, "refresh() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.refreshDevice(this.mClientIf, this.mDevice.getAddress(), this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean readRemoteRssi() {
        Log.d(TAG, "readRssi() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.readRemoteRssi(this.mClientIf, this.mDevice.getAddress(), this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean requestMtu(int mtu) {
        Log.d(TAG, "configureMTU() - device: " + this.mDevice.getAddress() + " mtu: " + mtu);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.configureMTU(this.mClientIf, this.mDevice.getAddress(), mtu, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean requestConnectionPriority(int connectionPriority) {
        if (connectionPriority < 0 || connectionPriority > 2) {
            throw new IllegalArgumentException("connectionPriority not within valid range");
        }
        Log.d(TAG, "requestConnectionPriority() - params: " + connectionPriority);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.connectionParameterUpdate(this.mClientIf, this.mDevice.getAddress(), connectionPriority, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean requestLeConnectionUpdate(int minConnectionInterval, int maxConnectionInterval, int slaveLatency, int supervisionTimeout, int minConnectionEventLen, int maxConnectionEventLen) {
        Log.d(TAG, "requestLeConnectionUpdate() - min=(" + minConnectionInterval + ")" + 1.25 * (double)minConnectionInterval + "msec, max=(" + maxConnectionInterval + ")" + 1.25 * (double)maxConnectionInterval + "msec, latency=" + slaveLatency + ", timeout=" + supervisionTimeout + "msec, min_ce=" + minConnectionEventLen + ", max_ce=" + maxConnectionEventLen);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mService.leConnectionUpdate(this.mClientIf, this.mDevice.getAddress(), minConnectionInterval, maxConnectionInterval, slaveLatency, supervisionTimeout, minConnectionEventLen, maxConnectionEventLen, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    @RequiresNoPermission
    public int getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    @Override
    @Deprecated
    @RequiresNoPermission
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    @Override
    @Deprecated
    @RequiresNoPermission
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WriteOperationReturnValues {
    }
}

