/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.companion.AssociationInfo;
import android.companion.AssociationRequest;
import android.companion.DeviceNotAssociatedException;
import android.companion.IAssociationRequestCallback;
import android.companion.ICompanionDeviceManager;
import android.companion.IOnAssociationsChangedListener;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.net.MacAddress;
import android.os.Handler;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ExceptionUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class CompanionDeviceManager {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "CompanionDeviceManager";
    public static final int RESULT_USER_REJECTED = 1;
    public static final int RESULT_DISCOVERY_TIMEOUT = 2;
    public static final int RESULT_INTERNAL_ERROR = 3;
    public static final String REASON_USER_REJECTED = "user_rejected";
    public static final String REASON_DISCOVERY_TIMEOUT = "discovery_timeout";
    public static final String REASON_CANCELED = "canceled";
    @Deprecated
    public static final String EXTRA_DEVICE = "android.companion.extra.DEVICE";
    public static final String EXTRA_ASSOCIATION = "android.companion.extra.ASSOCIATION";
    public static final String COMPANION_DEVICE_DISCOVERY_PACKAGE_NAME = "com.android.companiondevicemanager";
    private final ICompanionDeviceManager mService;
    private Context mContext;
    @GuardedBy(value={"mListeners"})
    private final ArrayList<OnAssociationsChangedListenerProxy> mListeners = new ArrayList();

    public CompanionDeviceManager(ICompanionDeviceManager service, Context context) {
        this.mService = service;
        this.mContext = context;
    }

    @RequiresPermission(anyOf={"android.permission.REQUEST_COMPANION_PROFILE_WATCH", "android.permission.REQUEST_COMPANION_PROFILE_COMPUTER", "android.permission.REQUEST_COMPANION_PROFILE_APP_STREAMING", "android.permission.REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION"}, conditional=true)
    public void associate(AssociationRequest request, Callback callback, Handler handler) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(request, "Request cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        handler = Handler.mainIfNull(handler);
        try {
            this.mService.associate(request, new AssociationRequestCallbackProxy(handler, callback), this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.REQUEST_COMPANION_PROFILE_WATCH", "android.permission.REQUEST_COMPANION_PROFILE_COMPUTER", "android.permission.REQUEST_COMPANION_PROFILE_APP_STREAMING", "android.permission.REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION"}, conditional=true)
    public void associate(AssociationRequest request, Executor executor, Callback callback) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(request, "Request cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        try {
            this.mService.associate(request, new AssociationRequestCallbackProxy(executor, callback), this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public List<String> getAssociations() {
        return CollectionUtils.mapNotNull(this.getMyAssociations(), a -> a.isSelfManaged() ? null : a.getDeviceMacAddressAsString());
    }

    public List<AssociationInfo> getMyAssociations() {
        if (!this.checkFeaturePresent()) {
            return Collections.emptyList();
        }
        try {
            return this.mService.getAssociations(this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void disassociate(String deviceMacAddress) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            this.mService.legacyDisassociate(deviceMacAddress, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disassociate(int associationId) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            this.mService.disassociate(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            IntentSender intentSender = this.mService.requestNotificationAccess(component, this.mContext.getUserId()).getIntentSender();
            this.mContext.startIntentSender(intentSender, null, 0, 0, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (IntentSender.SendIntentException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public boolean hasNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        try {
            return this.mService.hasNotificationAccess(component);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public boolean isDeviceAssociatedForWifiConnection(String packageName, MacAddress macAddress, UserHandle user) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(macAddress, "mac address cannot be null");
        Objects.requireNonNull(user, "user cannot be null");
        try {
            return this.mService.isDeviceAssociatedForWifiConnection(packageName, macAddress.toString(), user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public List<AssociationInfo> getAllAssociations() {
        if (!this.checkFeaturePresent()) {
            return Collections.emptyList();
        }
        try {
            return this.mService.getAllAssociationsForUser(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void addOnAssociationsChangedListener(Executor executor, OnAssociationsChangedListener listener) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        ArrayList<OnAssociationsChangedListenerProxy> arrayList = this.mListeners;
        synchronized (arrayList) {
            OnAssociationsChangedListenerProxy proxy = new OnAssociationsChangedListenerProxy(executor, listener);
            try {
                this.mService.addOnAssociationsChangedListener(proxy, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mListeners.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void removeOnAssociationsChangedListener(OnAssociationsChangedListener listener) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        ArrayList<OnAssociationsChangedListenerProxy> arrayList = this.mListeners;
        synchronized (arrayList) {
            Iterator<OnAssociationsChangedListenerProxy> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                OnAssociationsChangedListenerProxy proxy = iterator.next();
                if (proxy.mListener != listener) continue;
                try {
                    this.mService.removeOnAssociationsChangedListener(proxy, this.mContext.getUserId());
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                iterator.remove();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public boolean canPairWithoutPrompt(String packageName, String deviceMacAddress, UserHandle user) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(deviceMacAddress, "device mac address cannot be null");
        Objects.requireNonNull(user, "user handle cannot be null");
        try {
            return this.mService.canPairWithoutPrompt(packageName, deviceMacAddress, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void startObservingDevicePresence(String deviceAddress) throws DeviceNotAssociatedException {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(deviceAddress, "address cannot be null");
        try {
            this.mService.registerDevicePresenceListenerService(deviceAddress, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void stopObservingDevicePresence(String deviceAddress) throws DeviceNotAssociatedException {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(deviceAddress, "address cannot be null");
        try {
            this.mService.unregisterDevicePresenceListenerService(deviceAddress, this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
        }
    }

    @RequiresPermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void dispatchMessage(int messageId, int associationId, byte[] message) throws DeviceNotAssociatedException {
        try {
            this.mService.dispatchMessage(messageId, associationId, message);
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ASSOCIATE_COMPANION_DEVICES")
    public void associate(String packageName, MacAddress macAddress, byte[] certificate) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(macAddress, "mac address cannot be null");
        UserHandle user = Process.myUserHandle();
        try {
            this.mService.createAssociation(packageName, macAddress.toString(), user.getIdentifier(), certificate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
    public void notifyDeviceAppeared(int associationId) {
        try {
            this.mService.notifyDeviceAppeared(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
    public void notifyDeviceDisappeared(int associationId) {
        try {
            this.mService.notifyDeviceDisappeared(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean checkFeaturePresent() {
        boolean featurePresent;
        boolean bl = featurePresent = this.mService != null;
        if (!featurePresent) {
            // empty if block
        }
        return featurePresent;
    }

    private static class OnAssociationsChangedListenerProxy
    extends IOnAssociationsChangedListener.Stub {
        private final Executor mExecutor;
        private final OnAssociationsChangedListener mListener;

        private OnAssociationsChangedListenerProxy(Executor executor, OnAssociationsChangedListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onAssociationsChanged(List<AssociationInfo> associations) {
            this.mExecutor.execute(() -> this.mListener.onAssociationsChanged(associations));
        }
    }

    private static class AssociationRequestCallbackProxy
    extends IAssociationRequestCallback.Stub {
        private final Handler mHandler;
        private final Callback mCallback;
        private final Executor mExecutor;

        private AssociationRequestCallbackProxy(Executor executor, Callback callback) {
            this.mExecutor = executor;
            this.mHandler = null;
            this.mCallback = callback;
        }

        private AssociationRequestCallbackProxy(Handler handler, Callback callback) {
            this.mHandler = handler;
            this.mExecutor = null;
            this.mCallback = callback;
        }

        @Override
        public void onAssociationPending(PendingIntent pi) {
            this.execute(this.mCallback::onAssociationPending, pi.getIntentSender());
        }

        @Override
        public void onAssociationCreated(AssociationInfo association) {
            this.execute(this.mCallback::onAssociationCreated, association);
        }

        @Override
        public void onFailure(CharSequence error) throws RemoteException {
            this.execute(this.mCallback::onFailure, error);
        }

        private <T> void execute(Consumer<T> callback, T arg) {
            if (this.mExecutor != null) {
                this.mExecutor.execute(() -> callback.accept(arg));
            } else {
                this.mHandler.post(() -> callback.accept(arg));
            }
        }
    }

    @SystemApi
    public static interface OnAssociationsChangedListener {
        public void onAssociationsChanged(List<AssociationInfo> var1);
    }

    public static abstract class Callback {
        @Deprecated
        public void onDeviceFound(IntentSender intentSender) {
        }

        public void onAssociationPending(IntentSender intentSender) {
            this.onDeviceFound(intentSender);
        }

        public void onAssociationCreated(AssociationInfo associationInfo) {
        }

        public abstract void onFailure(CharSequence var1);
    }
}

