/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ApkChecksum;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IOnChecksumsReadyListener
extends IInterface {
    public static final String DESCRIPTOR = "android.content.pm.IOnChecksumsReadyListener";

    public void onChecksumsReady(List<ApkChecksum> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOnChecksumsReadyListener {
        static final int TRANSACTION_onChecksumsReady = 1;

        public Stub() {
            this.attachInterface(this, IOnChecksumsReadyListener.DESCRIPTOR);
        }

        public static IOnChecksumsReadyListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOnChecksumsReadyListener.DESCRIPTOR);
            if (iin != null && iin instanceof IOnChecksumsReadyListener) {
                return (IOnChecksumsReadyListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onChecksumsReady";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOnChecksumsReadyListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ArrayList<ApkChecksum> _arg0 = data.createTypedArrayList(ApkChecksum.CREATOR);
                    data.enforceNoDataAvail();
                    this.onChecksumsReady(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IOnChecksumsReadyListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOnChecksumsReadyListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChecksumsReady(List<ApkChecksum> checksums) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnChecksumsReadyListener.DESCRIPTOR);
                    _data.writeTypedList(checksums);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOnChecksumsReadyListener {
        @Override
        public void onChecksumsReady(List<ApkChecksum> checksums) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

