/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;

public class InstrumentationInfo
extends PackageItemInfo
implements Parcelable {
    public String targetPackage;
    public String targetProcesses;
    public String sourceDir;
    public String publicSourceDir;
    public String[] splitNames;
    public String[] splitSourceDirs;
    public String[] splitPublicSourceDirs;
    public SparseArray<int[]> splitDependencies;
    public String dataDir;
    public String deviceProtectedDataDir;
    public String credentialProtectedDataDir;
    public String primaryCpuAbi;
    public String secondaryCpuAbi;
    public String nativeLibraryDir;
    public String secondaryNativeLibraryDir;
    public boolean handleProfiling;
    public boolean functionalTest;
    public static final Parcelable.Creator<InstrumentationInfo> CREATOR = new Parcelable.Creator<InstrumentationInfo>(){

        @Override
        public InstrumentationInfo createFromParcel(Parcel source) {
            return new InstrumentationInfo(source);
        }

        public InstrumentationInfo[] newArray(int size) {
            return new InstrumentationInfo[size];
        }
    };

    public InstrumentationInfo() {
    }

    public InstrumentationInfo(InstrumentationInfo orig) {
        super(orig);
        this.targetPackage = orig.targetPackage;
        this.targetProcesses = orig.targetProcesses;
        this.sourceDir = orig.sourceDir;
        this.publicSourceDir = orig.publicSourceDir;
        this.splitNames = orig.splitNames;
        this.splitSourceDirs = orig.splitSourceDirs;
        this.splitPublicSourceDirs = orig.splitPublicSourceDirs;
        this.splitDependencies = orig.splitDependencies;
        this.dataDir = orig.dataDir;
        this.deviceProtectedDataDir = orig.deviceProtectedDataDir;
        this.credentialProtectedDataDir = orig.credentialProtectedDataDir;
        this.primaryCpuAbi = orig.primaryCpuAbi;
        this.secondaryCpuAbi = orig.secondaryCpuAbi;
        this.nativeLibraryDir = orig.nativeLibraryDir;
        this.secondaryNativeLibraryDir = orig.secondaryNativeLibraryDir;
        this.handleProfiling = orig.handleProfiling;
        this.functionalTest = orig.functionalTest;
    }

    public String toString() {
        return "InstrumentationInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeString8(this.targetPackage);
        dest.writeString8(this.targetProcesses);
        dest.writeString8(this.sourceDir);
        dest.writeString8(this.publicSourceDir);
        dest.writeString8Array(this.splitNames);
        dest.writeString8Array(this.splitSourceDirs);
        dest.writeString8Array(this.splitPublicSourceDirs);
        dest.writeSparseArray(this.splitDependencies);
        dest.writeString8(this.dataDir);
        dest.writeString8(this.deviceProtectedDataDir);
        dest.writeString8(this.credentialProtectedDataDir);
        dest.writeString8(this.primaryCpuAbi);
        dest.writeString8(this.secondaryCpuAbi);
        dest.writeString8(this.nativeLibraryDir);
        dest.writeString8(this.secondaryNativeLibraryDir);
        dest.writeInt(!this.handleProfiling ? 0 : 1);
        dest.writeInt(!this.functionalTest ? 0 : 1);
    }

    private InstrumentationInfo(Parcel source) {
        super(source);
        this.targetPackage = source.readString8();
        this.targetProcesses = source.readString8();
        this.sourceDir = source.readString8();
        this.publicSourceDir = source.readString8();
        this.splitNames = source.createString8Array();
        this.splitSourceDirs = source.createString8Array();
        this.splitPublicSourceDirs = source.createString8Array();
        this.splitDependencies = source.readSparseArray(null);
        this.dataDir = source.readString8();
        this.deviceProtectedDataDir = source.readString8();
        this.credentialProtectedDataDir = source.readString8();
        this.primaryCpuAbi = source.readString8();
        this.secondaryCpuAbi = source.readString8();
        this.nativeLibraryDir = source.readString8();
        this.secondaryNativeLibraryDir = source.readString8();
        this.handleProfiling = source.readInt() != 0;
        this.functionalTest = source.readInt() != 0;
    }

    public void copyTo(ApplicationInfo ai) {
        ai.packageName = this.packageName;
        ai.sourceDir = this.sourceDir;
        ai.publicSourceDir = this.publicSourceDir;
        ai.splitNames = this.splitNames;
        ai.splitSourceDirs = this.splitSourceDirs;
        ai.splitPublicSourceDirs = this.splitPublicSourceDirs;
        ai.splitDependencies = this.splitDependencies;
        ai.dataDir = this.dataDir;
        ai.deviceProtectedDataDir = this.deviceProtectedDataDir;
        ai.credentialProtectedDataDir = this.credentialProtectedDataDir;
        ai.primaryCpuAbi = this.primaryCpuAbi;
        ai.secondaryCpuAbi = this.secondaryCpuAbi;
        ai.nativeLibraryDir = this.nativeLibraryDir;
        ai.secondaryNativeLibraryDir = this.secondaryNativeLibraryDir;
    }
}

