/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ImageDecoder;
import android.graphics.Rect;
import android.graphics.drawable.Animatable2;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import libcore.util.NativeAllocationRegistry;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedImageDrawable
extends Drawable
implements Animatable2 {
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private boolean mStarting;
    private Handler mHandler;
    private State mState;
    private Runnable mRunnable;
    private ColorFilter mColorFilter;
    public static final int REPEAT_INFINITE = -1;
    @Deprecated
    public static final int LOOP_INFINITE = -1;
    private static final int REPEAT_UNDEFINED = -2;
    private static final int FINISHED = -1;
    private ArrayList<Animatable2.AnimationCallback> mAnimationCallbacks = null;

    public void setRepeatCount(int repeatCount) {
        if (repeatCount < -1) {
            throw new IllegalArgumentException("invalid value passed to setRepeatCount" + repeatCount);
        }
        if (this.mState.mRepeatCount != repeatCount) {
            this.mState.mRepeatCount = repeatCount;
            if (this.mState.mNativePtr != 0L) {
                AnimatedImageDrawable.nSetRepeatCount(this.mState.mNativePtr, repeatCount);
            }
        }
    }

    @Deprecated
    public void setLoopCount(int loopCount) {
        this.setRepeatCount(loopCount);
    }

    public int getRepeatCount() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called getRepeatCount on empty AnimatedImageDrawable");
        }
        if (this.mState.mRepeatCount == -2) {
            this.mState.mRepeatCount = AnimatedImageDrawable.nGetRepeatCount(this.mState.mNativePtr);
        }
        return this.mState.mRepeatCount;
    }

    @Deprecated
    public int getLoopCount(int loopCount) {
        return this.getRepeatCount();
    }

    public AnimatedImageDrawable() {
        this.mState = new State(0L, null, null);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = AnimatedImageDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedImageDrawable);
        this.updateStateFromTypedArray(a, this.mSrcDensityOverride);
    }

    private void updateStateFromTypedArray(TypedArray a, int srcDensityOverride) throws XmlPullParserException {
        boolean autoStart;
        State oldState = this.mState;
        Resources r = a.getResources();
        int srcResId = a.getResourceId(0, 0);
        if (srcResId != 0) {
            TypedValue value = new TypedValue();
            r.getValueForDensity(srcResId, srcDensityOverride, value, true);
            if (srcDensityOverride > 0 && value.density > 0 && value.density != 65535) {
                value.density = value.density == srcDensityOverride ? r.getDisplayMetrics().densityDpi : value.density * r.getDisplayMetrics().densityDpi / srcDensityOverride;
            }
            int density = 0;
            if (value.density == 0) {
                density = 160;
            } else if (value.density != 65535) {
                density = value.density;
            }
            Drawable drawable2 = null;
            try {
                InputStream is = r.openRawResource(srcResId, value);
                ImageDecoder.Source source = ImageDecoder.createSource(r, is, density);
                drawable2 = ImageDecoder.decodeDrawable(source, (decoder, info, src) -> {
                    if (!info.isAnimated()) {
                        throw new IllegalArgumentException("image is not animated");
                    }
                });
            }
            catch (IOException e) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <animated-image> requires a valid 'src' attribute", null, (Throwable)e);
            }
            if (!(drawable2 instanceof AnimatedImageDrawable)) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <animated-image> did not decode animated");
            }
            int repeatCount = this.mState.mRepeatCount;
            AnimatedImageDrawable other = (AnimatedImageDrawable)drawable2;
            this.mState = other.mState;
            other.mState = null;
            this.mIntrinsicWidth = other.mIntrinsicWidth;
            this.mIntrinsicHeight = other.mIntrinsicHeight;
            if (repeatCount != -2) {
                this.setRepeatCount(repeatCount);
            }
        }
        this.mState.mThemeAttrs = a.extractThemeAttrs();
        if (this.mState.mNativePtr == 0L && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[0] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <animated-image> requires a valid 'src' attribute");
        }
        this.mState.mAutoMirrored = a.getBoolean(3, oldState.mAutoMirrored);
        int repeatCount = a.getInt(1, -2);
        if (repeatCount != -2) {
            this.setRepeatCount(repeatCount);
        }
        if ((autoStart = a.getBoolean(2, false)) && this.mState.mNativePtr != 0L) {
            this.start();
        }
    }

    public AnimatedImageDrawable(long nativeImageDecoder, ImageDecoder decoder, int width, int height, long colorSpaceHandle, boolean extended, int srcDensity, int dstDensity, Rect cropRect, InputStream inputStream, AssetFileDescriptor afd) throws IOException {
        width = Bitmap.scaleFromDensity(width, srcDensity, dstDensity);
        height = Bitmap.scaleFromDensity(height, srcDensity, dstDensity);
        if (cropRect == null) {
            this.mIntrinsicWidth = width;
            this.mIntrinsicHeight = height;
        } else {
            cropRect.set(Bitmap.scaleFromDensity(cropRect.left, srcDensity, dstDensity), Bitmap.scaleFromDensity(cropRect.top, srcDensity, dstDensity), Bitmap.scaleFromDensity(cropRect.right, srcDensity, dstDensity), Bitmap.scaleFromDensity(cropRect.bottom, srcDensity, dstDensity));
            this.mIntrinsicWidth = cropRect.width();
            this.mIntrinsicHeight = cropRect.height();
        }
        this.mState = new State(AnimatedImageDrawable.nCreate(nativeImageDecoder, decoder, width, height, colorSpaceHandle, extended, cropRect), inputStream, afd);
        long nativeSize = AnimatedImageDrawable.nNativeByteSize(this.mState.mNativePtr);
        NativeAllocationRegistry registry = NativeAllocationRegistry.createMalloced(AnimatedImageDrawable.class.getClassLoader(), AnimatedImageDrawable.nGetNativeFinalizer(), nativeSize);
        registry.registerNativeAllocation(this.mState, this.mState.mNativePtr);
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mIntrinsicWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mIntrinsicHeight;
    }

    @Override
    public void draw(Canvas canvas) {
        long nextUpdate;
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called draw on empty AnimatedImageDrawable");
        }
        if (this.mStarting) {
            this.mStarting = false;
            this.postOnAnimationStart();
        }
        if ((nextUpdate = AnimatedImageDrawable.nDraw(this.mState.mNativePtr, canvas.getNativeCanvasWrapper())) > 0L) {
            if (this.mRunnable == null) {
                this.mRunnable = this::invalidateSelf;
            }
            this.scheduleSelf(this.mRunnable, nextUpdate + SystemClock.uptimeMillis());
        } else if (nextUpdate == -1L) {
            this.postOnAnimationEnd();
        }
    }

    @Override
    public void setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha must be between 0 and 255! provided " + alpha);
        }
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called setAlpha on empty AnimatedImageDrawable");
        }
        AnimatedImageDrawable.nSetAlpha(this.mState.mNativePtr, alpha);
        this.invalidateSelf();
    }

    @Override
    public int getAlpha() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called getAlpha on empty AnimatedImageDrawable");
        }
        return AnimatedImageDrawable.nGetAlpha(this.mState.mNativePtr);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called setColorFilter on empty AnimatedImageDrawable");
        }
        if (colorFilter != this.mColorFilter) {
            this.mColorFilter = colorFilter;
            long nativeFilter = colorFilter == null ? 0L : colorFilter.getNativeInstance();
            AnimatedImageDrawable.nSetColorFilter(this.mState.mNativePtr, nativeFilter);
            this.invalidateSelf();
        }
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    public void setAutoMirrored(boolean mirrored) {
        if (this.mState.mAutoMirrored != mirrored) {
            this.mState.mAutoMirrored = mirrored;
            if (this.getLayoutDirection() == 1 && this.mState.mNativePtr != 0L) {
                AnimatedImageDrawable.nSetMirrored(this.mState.mNativePtr, mirrored);
                this.invalidateSelf();
            }
        }
    }

    @Override
    public boolean onLayoutDirectionChanged(int layoutDirection) {
        if (!this.mState.mAutoMirrored || this.mState.mNativePtr == 0L) {
            return false;
        }
        boolean mirror = layoutDirection == 1;
        AnimatedImageDrawable.nSetMirrored(this.mState.mNativePtr, mirror);
        return true;
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mState.mAutoMirrored;
    }

    @Override
    public boolean isRunning() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called isRunning on empty AnimatedImageDrawable");
        }
        return AnimatedImageDrawable.nIsRunning(this.mState.mNativePtr);
    }

    @Override
    public void start() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called start on empty AnimatedImageDrawable");
        }
        if (AnimatedImageDrawable.nStart(this.mState.mNativePtr)) {
            this.mStarting = true;
            this.invalidateSelf();
        }
    }

    @Override
    public void stop() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called stop on empty AnimatedImageDrawable");
        }
        if (AnimatedImageDrawable.nStop(this.mState.mNativePtr)) {
            this.postOnAnimationEnd();
        }
    }

    @Override
    public void registerAnimationCallback(Animatable2.AnimationCallback callback) {
        if (callback == null) {
            return;
        }
        if (this.mAnimationCallbacks == null) {
            this.mAnimationCallbacks = new ArrayList();
            AnimatedImageDrawable.nSetOnAnimationEndListener(this.mState.mNativePtr, new WeakReference<AnimatedImageDrawable>(this));
        }
        if (!this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks.add(callback);
        }
    }

    @Override
    public boolean unregisterAnimationCallback(Animatable2.AnimationCallback callback) {
        if (callback == null || this.mAnimationCallbacks == null || !this.mAnimationCallbacks.remove(callback)) {
            return false;
        }
        if (this.mAnimationCallbacks.isEmpty()) {
            this.clearAnimationCallbacks();
        }
        return true;
    }

    @Override
    public void clearAnimationCallbacks() {
        if (this.mAnimationCallbacks != null) {
            this.mAnimationCallbacks = null;
            AnimatedImageDrawable.nSetOnAnimationEndListener(this.mState.mNativePtr, null);
        }
    }

    private void postOnAnimationStart() {
        if (this.mAnimationCallbacks == null) {
            return;
        }
        this.getHandler().post(() -> {
            for (Animatable2.AnimationCallback callback : this.mAnimationCallbacks) {
                callback.onAnimationStart(this);
            }
        });
    }

    private void postOnAnimationEnd() {
        if (this.mAnimationCallbacks == null) {
            return;
        }
        this.getHandler().post(() -> {
            for (Animatable2.AnimationCallback callback : this.mAnimationCallbacks) {
                callback.onAnimationEnd(this);
            }
        });
    }

    private Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    private static void callOnAnimationEnd(WeakReference<AnimatedImageDrawable> weakDrawable) {
        AnimatedImageDrawable drawable2 = (AnimatedImageDrawable)weakDrawable.get();
        if (drawable2 != null) {
            drawable2.onAnimationEnd();
        }
    }

    private void onAnimationEnd() {
        if (this.mAnimationCallbacks != null) {
            for (Animatable2.AnimationCallback callback : this.mAnimationCallbacks) {
                callback.onAnimationEnd(this);
            }
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        if (this.mState.mNativePtr != 0L) {
            AnimatedImageDrawable.nSetBounds(this.mState.mNativePtr, bounds);
        }
    }

    private static long nCreate(long l, ImageDecoder imageDecoder, int n, int n2, long l2, boolean bl, Rect rect) throws IOException {
        return OverrideMethod.invokeL("android.graphics.drawable.AnimatedImageDrawable#nCreate(JLandroid/graphics/ImageDecoder;IIJZLandroid/graphics/Rect;)J", true, null);
    }

    @FastNative
    private static long nGetNativeFinalizer() {
        return OverrideMethod.invokeL("android.graphics.drawable.AnimatedImageDrawable#nGetNativeFinalizer()J", true, null);
    }

    private static long nDraw(long l, long l2) {
        return OverrideMethod.invokeL("android.graphics.drawable.AnimatedImageDrawable#nDraw(JJ)J", true, null);
    }

    @FastNative
    private static void nSetAlpha(long l, int n) {
        OverrideMethod.invokeV("android.graphics.drawable.AnimatedImageDrawable#nSetAlpha(JI)V", true, null);
    }

    @FastNative
    private static int nGetAlpha(long l) {
        return OverrideMethod.invokeI("android.graphics.drawable.AnimatedImageDrawable#nGetAlpha(J)I", true, null);
    }

    @FastNative
    private static void nSetColorFilter(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.drawable.AnimatedImageDrawable#nSetColorFilter(JJ)V", true, null);
    }

    @FastNative
    private static boolean nIsRunning(long l) {
        return OverrideMethod.invokeI("android.graphics.drawable.AnimatedImageDrawable#nIsRunning(J)Z", true, null) != 0;
    }

    @FastNative
    private static boolean nStart(long l) {
        return OverrideMethod.invokeI("android.graphics.drawable.AnimatedImageDrawable#nStart(J)Z", true, null) != 0;
    }

    @FastNative
    private static boolean nStop(long l) {
        return OverrideMethod.invokeI("android.graphics.drawable.AnimatedImageDrawable#nStop(J)Z", true, null) != 0;
    }

    @FastNative
    private static int nGetRepeatCount(long l) {
        return OverrideMethod.invokeI("android.graphics.drawable.AnimatedImageDrawable#nGetRepeatCount(J)I", true, null);
    }

    @FastNative
    private static void nSetRepeatCount(long l, int n) {
        OverrideMethod.invokeV("android.graphics.drawable.AnimatedImageDrawable#nSetRepeatCount(JI)V", true, null);
    }

    private static void nSetOnAnimationEndListener(long l, WeakReference<AnimatedImageDrawable> weakReference) {
        OverrideMethod.invokeV("android.graphics.drawable.AnimatedImageDrawable#nSetOnAnimationEndListener(JLjava/lang/ref/WeakReference;)V", true, null);
    }

    @FastNative
    private static long nNativeByteSize(long l) {
        return OverrideMethod.invokeL("android.graphics.drawable.AnimatedImageDrawable#nNativeByteSize(J)J", true, null);
    }

    @FastNative
    private static void nSetMirrored(long l, boolean bl) {
        OverrideMethod.invokeV("android.graphics.drawable.AnimatedImageDrawable#nSetMirrored(JZ)V", true, null);
    }

    @FastNative
    private static void nSetBounds(long l, Rect rect) {
        OverrideMethod.invokeV("android.graphics.drawable.AnimatedImageDrawable#nSetBounds(JLandroid/graphics/Rect;)V", true, null);
    }

    private class State {
        final long mNativePtr;
        private final InputStream mInputStream;
        private final AssetFileDescriptor mAssetFd;
        int[] mThemeAttrs = null;
        boolean mAutoMirrored = false;
        int mRepeatCount = -2;

        State(long nativePtr, InputStream is, AssetFileDescriptor afd) {
            this.mNativePtr = nativePtr;
            this.mInputStream = is;
            this.mAssetFd = afd;
        }
    }
}

