/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.RecordingCanvas;
import android.graphics.animation.RenderNodeAnimator;
import android.graphics.drawable.RippleShader;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.PathInterpolator;
import java.util.function.Consumer;

public class RippleAnimationSession {
    private static final String TAG = "RippleAnimationSession";
    private static final int ENTER_ANIM_DURATION = 450;
    private static final int EXIT_ANIM_DURATION = 375;
    private static final long NOISE_ANIMATION_DURATION = 7000L;
    private static final long MAX_NOISE_PHASE = 32L;
    private static final TimeInterpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator FAST_OUT_SLOW_IN = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    private Consumer<RippleAnimationSession> mOnSessionEnd;
    private final AnimationProperties<Float, Paint> mProperties;
    private AnimationProperties<CanvasProperty<Float>, CanvasProperty<Paint>> mCanvasProperties;
    private Runnable mOnUpdate;
    private long mStartTime;
    private boolean mForceSoftware;
    private Animator mLoopAnimation;
    private Animator mCurrentAnimation;

    RippleAnimationSession(AnimationProperties<Float, Paint> properties, boolean forceSoftware) {
        this.mProperties = properties;
        this.mForceSoftware = forceSoftware;
    }

    boolean isForceSoftware() {
        return this.mForceSoftware;
    }

    RippleAnimationSession enter(Canvas canvas) {
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        if (this.useRTAnimations(canvas)) {
            this.enterHardware((RecordingCanvas)canvas);
        } else {
            this.enterSoftware();
        }
        return this;
    }

    void end() {
        if (this.mCurrentAnimation != null) {
            this.mCurrentAnimation.end();
        }
    }

    RippleAnimationSession exit(Canvas canvas) {
        if (this.useRTAnimations(canvas)) {
            this.exitHardware((RecordingCanvas)canvas);
        } else {
            this.exitSoftware();
        }
        return this;
    }

    private void onAnimationEnd(Animator anim2) {
        this.notifyUpdate();
    }

    RippleAnimationSession setOnSessionEnd(Consumer<RippleAnimationSession> onSessionEnd) {
        this.mOnSessionEnd = onSessionEnd;
        return this;
    }

    RippleAnimationSession setOnAnimationUpdated(Runnable run) {
        this.mOnUpdate = run;
        return this;
    }

    private boolean useRTAnimations(Canvas canvas) {
        if (this.mForceSoftware) {
            return false;
        }
        if (!canvas.isHardwareAccelerated()) {
            return false;
        }
        RecordingCanvas hwCanvas = (RecordingCanvas)canvas;
        return hwCanvas.mNode != null && hwCanvas.mNode.isAttached();
    }

    private void exitSoftware() {
        final ValueAnimator expand = ValueAnimator.ofFloat(0.5f, 1.0f);
        expand.setDuration(375L);
        expand.setStartDelay(this.computeDelay());
        expand.addUpdateListener(updatedAnimation -> {
            this.notifyUpdate();
            this.mProperties.getShader().setProgress(((Float)expand.getAnimatedValue()).floatValue());
        });
        expand.addListener(new AnimatorListener(this){

            @Override
            public void onAnimationEnd(Animator animation) {
                Consumer<RippleAnimationSession> onEnd;
                super.onAnimationEnd(animation);
                if (RippleAnimationSession.this.mLoopAnimation != null) {
                    RippleAnimationSession.this.mLoopAnimation.cancel();
                }
                if ((onEnd = RippleAnimationSession.this.mOnSessionEnd) != null) {
                    onEnd.accept(RippleAnimationSession.this);
                }
                if (RippleAnimationSession.this.mCurrentAnimation == expand) {
                    RippleAnimationSession.this.mCurrentAnimation = null;
                }
            }
        });
        expand.setInterpolator(LINEAR_INTERPOLATOR);
        expand.start();
        this.mCurrentAnimation = expand;
    }

    private long computeDelay() {
        long timePassed = AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
        return Math.max(450L - timePassed, 0L);
    }

    private void notifyUpdate() {
        if (this.mOnUpdate != null) {
            this.mOnUpdate.run();
        }
    }

    RippleAnimationSession setForceSoftwareAnimation(boolean forceSw) {
        this.mForceSoftware = forceSw;
        return this;
    }

    private void exitHardware(RecordingCanvas canvas) {
        AnimationProperties<CanvasProperty<Float>, CanvasProperty<Paint>> props = this.getCanvasProperties();
        final RenderNodeAnimator exit = new RenderNodeAnimator(props.getProgress(), 1.0f);
        exit.setDuration(375L);
        exit.addListener(new AnimatorListener(this){

            @Override
            public void onAnimationEnd(Animator animation) {
                Consumer<RippleAnimationSession> onEnd;
                super.onAnimationEnd(animation);
                if (RippleAnimationSession.this.mLoopAnimation != null) {
                    RippleAnimationSession.this.mLoopAnimation.cancel();
                }
                if ((onEnd = RippleAnimationSession.this.mOnSessionEnd) != null) {
                    onEnd.accept(RippleAnimationSession.this);
                }
                if (RippleAnimationSession.this.mCurrentAnimation == exit) {
                    RippleAnimationSession.this.mCurrentAnimation = null;
                }
            }
        });
        exit.setTarget(canvas);
        exit.setInterpolator(LINEAR_INTERPOLATOR);
        long delay = this.computeDelay();
        exit.setStartDelay(delay);
        exit.start();
        this.mCurrentAnimation = exit;
    }

    private void enterHardware(RecordingCanvas canvas) {
        AnimationProperties<CanvasProperty<Float>, CanvasProperty<Paint>> props = this.getCanvasProperties();
        RenderNodeAnimator expand = new RenderNodeAnimator(props.getProgress(), 0.5f);
        expand.setTarget(canvas);
        RenderNodeAnimator loop = new RenderNodeAnimator(props.getNoisePhase(), (float)(this.mStartTime + 32L));
        loop.setTarget(canvas);
        this.startAnimation(expand, loop);
        this.mCurrentAnimation = expand;
    }

    private void startAnimation(Animator expand, Animator loop) {
        expand.setDuration(450L);
        expand.addListener(new AnimatorListener(this));
        expand.setInterpolator(FAST_OUT_SLOW_IN);
        expand.start();
        loop.setDuration(7000L);
        loop.addListener(new AnimatorListener(this){

            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                RippleAnimationSession.this.mLoopAnimation = null;
            }
        });
        loop.setInterpolator(LINEAR_INTERPOLATOR);
        loop.start();
        if (this.mLoopAnimation != null) {
            this.mLoopAnimation.cancel();
        }
        this.mLoopAnimation = loop;
    }

    private void enterSoftware() {
        ValueAnimator expand = ValueAnimator.ofFloat(0.0f, 0.5f);
        expand.addUpdateListener(updatedAnimation -> {
            this.notifyUpdate();
            this.mProperties.getShader().setProgress(((Float)expand.getAnimatedValue()).floatValue());
        });
        ValueAnimator loop = ValueAnimator.ofFloat(this.mStartTime, this.mStartTime + 32L);
        loop.addUpdateListener(updatedAnimation -> {
            this.notifyUpdate();
            this.mProperties.getShader().setNoisePhase(((Float)loop.getAnimatedValue()).floatValue());
        });
        this.startAnimation(expand, loop);
        this.mCurrentAnimation = expand;
    }

    void setRadius(float radius) {
        this.mProperties.setRadius(Float.valueOf(radius));
        this.mProperties.getShader().setRadius(radius);
        if (this.mCanvasProperties != null) {
            this.mCanvasProperties.setRadius(CanvasProperty.createFloat(radius));
            this.mCanvasProperties.getShader().setRadius(radius);
        }
    }

    AnimationProperties<Float, Paint> getProperties() {
        return this.mProperties;
    }

    AnimationProperties<CanvasProperty<Float>, CanvasProperty<Paint>> getCanvasProperties() {
        if (this.mCanvasProperties == null) {
            this.mCanvasProperties = new AnimationProperties<CanvasProperty<Float>, CanvasProperty<Paint>>(CanvasProperty.createFloat(this.mProperties.getX().floatValue()), CanvasProperty.createFloat(this.mProperties.getY().floatValue()), CanvasProperty.createFloat(this.mProperties.getMaxRadius().floatValue()), CanvasProperty.createFloat(this.mProperties.getNoisePhase().floatValue()), CanvasProperty.createPaint(this.mProperties.getPaint()), CanvasProperty.createFloat(this.mProperties.getProgress().floatValue()), this.mProperties.getColor(), this.mProperties.getShader());
        }
        return this.mCanvasProperties;
    }

    static class AnimationProperties<FloatType, PaintType> {
        private final FloatType mProgress;
        private FloatType mMaxRadius;
        private final FloatType mNoisePhase;
        private final PaintType mPaint;
        private final RippleShader mShader;
        private final int mColor;
        private FloatType mX;
        private FloatType mY;

        AnimationProperties(FloatType x, FloatType y, FloatType maxRadius, FloatType noisePhase, PaintType paint, FloatType progress, int color2, RippleShader shader) {
            this.mY = y;
            this.mX = x;
            this.mMaxRadius = maxRadius;
            this.mNoisePhase = noisePhase;
            this.mPaint = paint;
            this.mShader = shader;
            this.mProgress = progress;
            this.mColor = color2;
        }

        FloatType getProgress() {
            return this.mProgress;
        }

        void setRadius(FloatType radius) {
            this.mMaxRadius = radius;
        }

        void setOrigin(FloatType x, FloatType y) {
            this.mX = x;
            this.mY = y;
        }

        FloatType getX() {
            return this.mX;
        }

        FloatType getY() {
            return this.mY;
        }

        FloatType getMaxRadius() {
            return this.mMaxRadius;
        }

        PaintType getPaint() {
            return this.mPaint;
        }

        RippleShader getShader() {
            return this.mShader;
        }

        FloatType getNoisePhase() {
            return this.mNoisePhase;
        }

        int getColor() {
            return this.mColor;
        }
    }

    private static class AnimatorListener
    implements Animator.AnimatorListener {
        private final RippleAnimationSession mSession;

        AnimatorListener(RippleAnimationSession session) {
            this.mSession = session;
        }

        @Override
        public void onAnimationStart(Animator animation) {
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            this.mSession.onAnimationEnd(animation);
        }

        @Override
        public void onAnimationCancel(Animator animation) {
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }
    }
}

