/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class LineBreakConfig {
    public static final int LINE_BREAK_STYLE_NONE = 0;
    public static final int LINE_BREAK_STYLE_LOOSE = 1;
    public static final int LINE_BREAK_STYLE_NORMAL = 2;
    public static final int LINE_BREAK_STYLE_STRICT = 3;
    public static final int LINE_BREAK_WORD_STYLE_NONE = 0;
    public static final int LINE_BREAK_WORD_STYLE_PHRASE = 1;
    public static final LineBreakConfig NONE = new Builder().setLineBreakStyle(0).setLineBreakWordStyle(0).build();
    private final int mLineBreakStyle;
    private final int mLineBreakWordStyle;

    public static LineBreakConfig getLineBreakConfig(int lineBreakStyle, int lineBreakWordStyle) {
        Builder builder = new Builder();
        return builder.setLineBreakStyle(lineBreakStyle).setLineBreakWordStyle(lineBreakWordStyle).build();
    }

    private LineBreakConfig(int lineBreakStyle, int lineBreakWordStyle) {
        this.mLineBreakStyle = lineBreakStyle;
        this.mLineBreakWordStyle = lineBreakWordStyle;
    }

    public int getLineBreakStyle() {
        return this.mLineBreakStyle;
    }

    public int getLineBreakWordStyle() {
        return this.mLineBreakWordStyle;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineBreakConfig)) {
            return false;
        }
        LineBreakConfig that = (LineBreakConfig)o;
        return this.mLineBreakStyle == that.mLineBreakStyle && this.mLineBreakWordStyle == that.mLineBreakWordStyle;
    }

    public int hashCode() {
        return Objects.hash(this.mLineBreakStyle, this.mLineBreakWordStyle);
    }

    public static class Builder {
        private int mLineBreakStyle = 0;
        private int mLineBreakWordStyle = 0;

        public Builder setLineBreakStyle(int lineBreakStyle) {
            this.mLineBreakStyle = lineBreakStyle;
            return this;
        }

        public Builder setLineBreakWordStyle(int lineBreakWordStyle) {
            this.mLineBreakWordStyle = lineBreakWordStyle;
            return this;
        }

        public LineBreakConfig build() {
            return new LineBreakConfig(this.mLineBreakStyle, this.mLineBreakWordStyle);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineBreakWordStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineBreakStyle {
    }
}

