/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.extension.CaptureBundle;
import android.hardware.camera2.extension.ICaptureProcessorImpl;
import android.hardware.camera2.extension.IProcessResultImpl;
import android.hardware.camera2.extension.Size;
import android.media.Image;
import android.media.ImageReader;
import android.media.ImageWriter;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CameraExtensionJpegProcessor
implements ICaptureProcessorImpl {
    public static final String TAG = "CameraExtensionJpeg";
    private static final int JPEG_QUEUE_SIZE = 1;
    private final Handler mHandler;
    private final HandlerThread mHandlerThread;
    private final ICaptureProcessorImpl mProcessor;
    private ImageReader mYuvReader = null;
    private Size mResolution = null;
    private int mFormat = -1;
    private Surface mOutputSurface = null;
    private ImageWriter mOutputWriter = null;
    private ConcurrentLinkedQueue<JpegParameters> mJpegParameters = new ConcurrentLinkedQueue();

    public CameraExtensionJpegProcessor(ICaptureProcessorImpl processor) {
        this.mProcessor = processor;
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    public void close() {
        this.mHandlerThread.quitSafely();
        if (this.mOutputWriter != null) {
            this.mOutputWriter.close();
            this.mOutputWriter = null;
        }
        if (this.mYuvReader != null) {
            this.mYuvReader.close();
            this.mYuvReader = null;
        }
    }

    private static JpegParameters getJpegParameters(List<CaptureBundle> captureBundles) {
        JpegParameters ret = new JpegParameters();
        if (!captureBundles.isEmpty()) {
            Byte jpegQuality = captureBundles.get((int)0).captureResult.get(CaptureResult.JPEG_QUALITY);
            if (jpegQuality != null) {
                ret.mQuality = jpegQuality.byteValue();
            } else {
                Log.w(TAG, "No jpeg quality set, using default: 100");
            }
            Integer orientation = captureBundles.get((int)0).captureResult.get(CaptureResult.JPEG_ORIENTATION);
            if (orientation != null) {
                ret.mRotation = (360 - orientation % 360) / 90;
            } else {
                Log.w(TAG, "No jpeg rotation set, using default: 0");
            }
            for (CaptureBundle bundle : captureBundles) {
                Long timeStamp = bundle.captureResult.get(CaptureResult.SENSOR_TIMESTAMP);
                if (timeStamp != null) {
                    ret.mTimeStamps.add(timeStamp);
                    continue;
                }
                Log.e(TAG, "Capture bundle without valid sensor timestamp!");
            }
        }
        return ret;
    }

    private static int compressJpegFromYUV420pNative(int n, int n2, ByteBuffer byteBuffer, int n3, int n4, ByteBuffer byteBuffer2, int n5, int n6, ByteBuffer byteBuffer3, int n7, int n8, ByteBuffer byteBuffer4, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraExtensionJpegProcessor#compressJpegFromYUV420pNative(IILjava/nio/ByteBuffer;IILjava/nio/ByteBuffer;IILjava/nio/ByteBuffer;IILjava/nio/ByteBuffer;IIIIIII)I", true, null);
    }

    @Override
    public void process(List<CaptureBundle> captureBundle, IProcessResultImpl captureCallback) throws RemoteException {
        JpegParameters jpegParams = CameraExtensionJpegProcessor.getJpegParameters(captureBundle);
        try {
            this.mJpegParameters.add(jpegParams);
            this.mProcessor.process(captureBundle, captureCallback);
        }
        catch (Exception e) {
            this.mJpegParameters.remove(jpegParams);
            throw e;
        }
    }

    @Override
    public void onOutputSurface(Surface surface, int format) throws RemoteException {
        if (format != 256) {
            Log.e(TAG, "Unsupported output format: " + format);
            return;
        }
        this.mOutputSurface = surface;
        this.initializePipeline();
    }

    @Override
    public void onResolutionUpdate(Size size) throws RemoteException {
        this.mResolution = size;
        this.initializePipeline();
    }

    @Override
    public void onImageFormatUpdate(int format) throws RemoteException {
        if (format != 35) {
            Log.e(TAG, "Unsupported input format: " + format);
            return;
        }
        this.mFormat = format;
        this.initializePipeline();
    }

    private void initializePipeline() throws RemoteException {
        if (this.mFormat != -1 && this.mOutputSurface != null && this.mResolution != null && this.mYuvReader == null) {
            this.mOutputWriter = ImageWriter.newInstance(this.mOutputSurface, 1, 256, this.mResolution.width * this.mResolution.height, 1);
            this.mYuvReader = ImageReader.newInstance(this.mResolution.width, this.mResolution.height, this.mFormat, 1);
            this.mYuvReader.setOnImageAvailableListener(new YuvCallback(), this.mHandler);
            this.mProcessor.onOutputSurface(this.mYuvReader.getSurface(), this.mFormat);
            this.mProcessor.onResolutionUpdate(this.mResolution);
            this.mProcessor.onImageFormatUpdate(this.mFormat);
        }
    }

    @Override
    public IBinder asBinder() {
        throw new UnsupportedOperationException("Binder IPC not supported!");
    }

    private class YuvCallback
    implements ImageReader.OnImageAvailableListener {
        private YuvCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageAvailable(ImageReader reader) {
            Image yuvImage = null;
            Image jpegImage = null;
            try {
                yuvImage = CameraExtensionJpegProcessor.this.mYuvReader.acquireNextImage();
                jpegImage = CameraExtensionJpegProcessor.this.mOutputWriter.dequeueInputImage();
            }
            catch (IllegalStateException e) {
                if (yuvImage != null) {
                    yuvImage.close();
                }
                if (jpegImage != null) {
                    jpegImage.close();
                }
                Log.e(CameraExtensionJpegProcessor.TAG, "Failed to acquire processed yuv image or jpeg image!");
                return;
            }
            ByteBuffer jpegBuffer = jpegImage.getPlanes()[0].getBuffer();
            jpegBuffer.clear();
            int jpegCapacity = jpegImage.getWidth();
            Image.Plane lumaPlane = yuvImage.getPlanes()[0];
            Image.Plane crPlane = yuvImage.getPlanes()[1];
            Image.Plane cbPlane = yuvImage.getPlanes()[2];
            Iterator<JpegParameters> jpegIter = CameraExtensionJpegProcessor.this.mJpegParameters.iterator();
            JpegParameters jpegParams = null;
            while (jpegIter.hasNext()) {
                JpegParameters currentParams = jpegIter.next();
                if (!currentParams.mTimeStamps.contains(yuvImage.getTimestamp())) continue;
                jpegParams = currentParams;
                jpegIter.remove();
                break;
            }
            if (jpegParams == null) {
                if (CameraExtensionJpegProcessor.this.mJpegParameters.isEmpty()) {
                    Log.w(CameraExtensionJpegProcessor.TAG, "Empty jpeg settings queue! Using default jpeg orientation and quality!");
                    jpegParams = new JpegParameters();
                    jpegParams.mRotation = 0;
                    jpegParams.mQuality = 100;
                } else {
                    Log.w(CameraExtensionJpegProcessor.TAG, "No jpeg settings found with matching timestamp for current processed input!");
                    Log.w(CameraExtensionJpegProcessor.TAG, "Using values from the top of the queue!");
                    jpegParams = CameraExtensionJpegProcessor.this.mJpegParameters.poll();
                }
            }
            CameraExtensionJpegProcessor.compressJpegFromYUV420pNative(yuvImage.getWidth(), yuvImage.getHeight(), lumaPlane.getBuffer(), lumaPlane.getPixelStride(), lumaPlane.getRowStride(), crPlane.getBuffer(), crPlane.getPixelStride(), crPlane.getRowStride(), cbPlane.getBuffer(), cbPlane.getPixelStride(), cbPlane.getRowStride(), jpegBuffer, jpegCapacity, jpegParams.mQuality, 0, 0, yuvImage.getWidth(), yuvImage.getHeight(), jpegParams.mRotation);
            jpegImage.setTimestamp(yuvImage.getTimestamp());
            yuvImage.close();
            try {
                CameraExtensionJpegProcessor.this.mOutputWriter.queueInputImage(jpegImage);
            }
            catch (IllegalStateException e) {
                Log.e(CameraExtensionJpegProcessor.TAG, "Failed to queue encoded result!");
            }
            finally {
                jpegImage.close();
            }
        }
    }

    private static class JpegParameters {
        public HashSet<Long> mTimeStamps = new HashSet();
        public int mRotation = 0;
        public int mQuality = 100;

        private JpegParameters() {
        }
    }
}

