/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.IntRange;
import android.annotation.NonNull;
import android.hardware.display.DisplayManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.Surface;
import com.android.internal.util.AnnotationValidations;

public class VirtualDisplayConfig
implements Parcelable {
    private String mName;
    private int mWidth;
    private int mHeight;
    private int mDensityDpi;
    private int mFlags = 0;
    private Surface mSurface = null;
    private String mUniqueId = null;
    private int mDisplayIdToMirror = 0;
    private boolean mWindowManagerMirroring = false;
    public static final Parcelable.Creator<VirtualDisplayConfig> CREATOR = new Parcelable.Creator<VirtualDisplayConfig>(){

        public VirtualDisplayConfig[] newArray(int size) {
            return new VirtualDisplayConfig[size];
        }

        @Override
        public VirtualDisplayConfig createFromParcel(Parcel in) {
            return new VirtualDisplayConfig(in);
        }
    };

    VirtualDisplayConfig(String name, int width, int height, int densityDpi, int flags, Surface surface, String uniqueId, int displayIdToMirror, boolean windowManagerMirroring) {
        this.mName = name;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mName);
        this.mWidth = width;
        AnnotationValidations.validate(IntRange.class, null, this.mWidth, "from", 1L);
        this.mHeight = height;
        AnnotationValidations.validate(IntRange.class, null, this.mHeight, "from", 1L);
        this.mDensityDpi = densityDpi;
        AnnotationValidations.validate(IntRange.class, null, this.mDensityDpi, "from", 1L);
        this.mFlags = flags;
        AnnotationValidations.validate(DisplayManager.VirtualDisplayFlag.class, null, this.mFlags);
        this.mSurface = surface;
        this.mUniqueId = uniqueId;
        this.mDisplayIdToMirror = displayIdToMirror;
        this.mWindowManagerMirroring = windowManagerMirroring;
    }

    public String getName() {
        return this.mName;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getDensityDpi() {
        return this.mDensityDpi;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public String getUniqueId() {
        return this.mUniqueId;
    }

    public int getDisplayIdToMirror() {
        return this.mDisplayIdToMirror;
    }

    public boolean isWindowManagerMirroring() {
        return this.mWindowManagerMirroring;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int flg = 0;
        if (this.mWindowManagerMirroring) {
            flg |= 0x100;
        }
        if (this.mSurface != null) {
            flg |= 0x20;
        }
        if (this.mUniqueId != null) {
            flg |= 0x40;
        }
        dest.writeInt(flg);
        dest.writeString(this.mName);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        dest.writeInt(this.mDensityDpi);
        dest.writeInt(this.mFlags);
        if (this.mSurface != null) {
            dest.writeTypedObject(this.mSurface, flags);
        }
        if (this.mUniqueId != null) {
            dest.writeString(this.mUniqueId);
        }
        dest.writeInt(this.mDisplayIdToMirror);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    VirtualDisplayConfig(Parcel in) {
        int flg = in.readInt();
        boolean windowManagerMirroring = (flg & 0x100) != 0;
        String name = in.readString();
        int width = in.readInt();
        int height = in.readInt();
        int densityDpi = in.readInt();
        int flags = in.readInt();
        Surface surface = (flg & 0x20) == 0 ? null : in.readTypedObject(Surface.CREATOR);
        String uniqueId = (flg & 0x40) == 0 ? null : in.readString();
        int displayIdToMirror = in.readInt();
        this.mName = name;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mName);
        this.mWidth = width;
        AnnotationValidations.validate(IntRange.class, null, this.mWidth, "from", 1L);
        this.mHeight = height;
        AnnotationValidations.validate(IntRange.class, null, this.mHeight, "from", 1L);
        this.mDensityDpi = densityDpi;
        AnnotationValidations.validate(IntRange.class, null, this.mDensityDpi, "from", 1L);
        this.mFlags = flags;
        AnnotationValidations.validate(DisplayManager.VirtualDisplayFlag.class, null, this.mFlags);
        this.mSurface = surface;
        this.mUniqueId = uniqueId;
        this.mDisplayIdToMirror = displayIdToMirror;
        this.mWindowManagerMirroring = windowManagerMirroring;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        private String mName;
        private int mWidth;
        private int mHeight;
        private int mDensityDpi;
        private int mFlags;
        private Surface mSurface;
        private String mUniqueId;
        private int mDisplayIdToMirror;
        private boolean mWindowManagerMirroring;
        private long mBuilderFieldsSet = 0L;

        public Builder(String name, int width, int height, int densityDpi) {
            this.mName = name;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mName);
            this.mWidth = width;
            AnnotationValidations.validate(IntRange.class, null, this.mWidth, "from", 1L);
            this.mHeight = height;
            AnnotationValidations.validate(IntRange.class, null, this.mHeight, "from", 1L);
            this.mDensityDpi = densityDpi;
            AnnotationValidations.validate(IntRange.class, null, this.mDensityDpi, "from", 1L);
        }

        public Builder setName(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mName = value;
            return this;
        }

        public Builder setWidth(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mWidth = value;
            return this;
        }

        public Builder setHeight(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mHeight = value;
            return this;
        }

        public Builder setDensityDpi(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mDensityDpi = value;
            return this;
        }

        public Builder setFlags(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mFlags = value;
            return this;
        }

        public Builder setSurface(Surface value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mSurface = value;
            return this;
        }

        public Builder setUniqueId(String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mUniqueId = value;
            return this;
        }

        public Builder setDisplayIdToMirror(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x80L;
            this.mDisplayIdToMirror = value;
            return this;
        }

        public Builder setWindowManagerMirroring(boolean value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x100L;
            this.mWindowManagerMirroring = value;
            return this;
        }

        public VirtualDisplayConfig build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x200L;
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mFlags = 0;
            }
            if ((this.mBuilderFieldsSet & 0x20L) == 0L) {
                this.mSurface = null;
            }
            if ((this.mBuilderFieldsSet & 0x40L) == 0L) {
                this.mUniqueId = null;
            }
            if ((this.mBuilderFieldsSet & 0x80L) == 0L) {
                this.mDisplayIdToMirror = 0;
            }
            if ((this.mBuilderFieldsSet & 0x100L) == 0L) {
                this.mWindowManagerMirroring = false;
            }
            VirtualDisplayConfig o = new VirtualDisplayConfig(this.mName, this.mWidth, this.mHeight, this.mDensityDpi, this.mFlags, this.mSurface, this.mUniqueId, this.mDisplayIdToMirror, this.mWindowManagerMirroring);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x200L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

