/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.inputmethodservice.InputMethodServiceInternal;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.SurroundingText;
import android.view.inputmethod.TextAttribute;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.inputmethod.CancellationGroup;
import com.android.internal.inputmethod.CompletableFutureUtil;
import com.android.internal.inputmethod.IInputContextInvoker;
import com.android.internal.inputmethod.ImeTracing;
import com.android.internal.inputmethod.InputConnectionProtoDumper;
import com.android.internal.view.IInputContext;
import java.lang.ref.WeakReference;

class RemoteInputConnection
implements InputConnection {
    private static final String TAG = "RemoteInputConnection";
    private static final int MAX_WAIT_TIME_MILLIS = 2000;
    private final IInputContextInvoker mInvoker;
    private final InputMethodServiceInternalHolder mImsInternal;
    private final CancellationGroup mCancellationGroup;

    RemoteInputConnection(WeakReference<InputMethodServiceInternal> inputMethodService, IInputContext inputContext, CancellationGroup cancellationGroup) {
        this.mImsInternal = new InputMethodServiceInternalHolder(inputMethodService);
        this.mInvoker = IInputContextInvoker.create(inputContext);
        this.mCancellationGroup = cancellationGroup;
    }

    public boolean isSameConnection(IInputContext inputContext) {
        return this.mInvoker.isSameConnection(inputContext);
    }

    RemoteInputConnection(RemoteInputConnection original, int sessionId) {
        this.mImsInternal = original.mImsInternal;
        this.mInvoker = original.mInvoker.cloneWithSessionId(sessionId);
        this.mCancellationGroup = original.mCancellationGroup;
    }

    @Override
    public CharSequence getTextAfterCursor(int length, int flags) {
        if (length < 0) {
            Log.e(TAG, "length=" + length + " is invalid and always results in null result.");
        }
        if (this.mCancellationGroup.isCanceled()) {
            return null;
        }
        AndroidFuture<CharSequence> value = this.mInvoker.getTextAfterCursor(length, flags);
        CharSequence result = CompletableFutureUtil.getResultOrNull(value, TAG, "getTextAfterCursor()", this.mCancellationGroup, 2000L);
        InputMethodServiceInternal imsInternal = this.mImsInternal.getAndWarnIfNull();
        if (imsInternal != null && ImeTracing.getInstance().isEnabled()) {
            byte[] icProto = InputConnectionProtoDumper.buildGetTextAfterCursorProto(length, flags, result);
            imsInternal.triggerServiceDump("RemoteInputConnection#getTextAfterCursor", icProto);
        }
        return result;
    }

    @Override
    public CharSequence getTextBeforeCursor(int length, int flags) {
        if (length < 0) {
            Log.e(TAG, "length=" + length + " is invalid and always results in null result.");
        }
        if (this.mCancellationGroup.isCanceled()) {
            return null;
        }
        AndroidFuture<CharSequence> value = this.mInvoker.getTextBeforeCursor(length, flags);
        CharSequence result = CompletableFutureUtil.getResultOrNull(value, TAG, "getTextBeforeCursor()", this.mCancellationGroup, 2000L);
        InputMethodServiceInternal imsInternal = this.mImsInternal.getAndWarnIfNull();
        if (imsInternal != null && ImeTracing.getInstance().isEnabled()) {
            byte[] icProto = InputConnectionProtoDumper.buildGetTextBeforeCursorProto(length, flags, result);
            imsInternal.triggerServiceDump("RemoteInputConnection#getTextBeforeCursor", icProto);
        }
        return result;
    }

    @Override
    public CharSequence getSelectedText(int flags) {
        if (this.mCancellationGroup.isCanceled()) {
            return null;
        }
        AndroidFuture<CharSequence> value = this.mInvoker.getSelectedText(flags);
        CharSequence result = CompletableFutureUtil.getResultOrNull(value, TAG, "getSelectedText()", this.mCancellationGroup, 2000L);
        InputMethodServiceInternal imsInternal = this.mImsInternal.getAndWarnIfNull();
        if (imsInternal != null && ImeTracing.getInstance().isEnabled()) {
            byte[] icProto = InputConnectionProtoDumper.buildGetSelectedTextProto(flags, result);
            imsInternal.triggerServiceDump("RemoteInputConnection#getSelectedText", icProto);
        }
        return result;
    }

    @Override
    public SurroundingText getSurroundingText(int beforeLength, int afterLength, int flags) {
        if (beforeLength < 0) {
            Log.e(TAG, "beforeLength=" + beforeLength + " is invalid and always results in null result.");
        }
        if (afterLength < 0) {
            Log.e(TAG, "afterLength=" + afterLength + " is invalid and always results in null result.");
        }
        if (this.mCancellationGroup.isCanceled()) {
            return null;
        }
        AndroidFuture<SurroundingText> value = this.mInvoker.getSurroundingText(beforeLength, afterLength, flags);
        SurroundingText result = CompletableFutureUtil.getResultOrNull(value, TAG, "getSurroundingText()", this.mCancellationGroup, 2000L);
        InputMethodServiceInternal imsInternal = this.mImsInternal.getAndWarnIfNull();
        if (imsInternal != null && ImeTracing.getInstance().isEnabled()) {
            byte[] icProto = InputConnectionProtoDumper.buildGetSurroundingTextProto(beforeLength, afterLength, flags, result);
            imsInternal.triggerServiceDump("RemoteInputConnection#getSurroundingText", icProto);
        }
        return result;
    }

    @Override
    public int getCursorCapsMode(int reqModes) {
        if (this.mCancellationGroup.isCanceled()) {
            return 0;
        }
        AndroidFuture<Integer> value = this.mInvoker.getCursorCapsMode(reqModes);
        int result = CompletableFutureUtil.getResultOrZero(value, TAG, "getCursorCapsMode()", this.mCancellationGroup, 2000L);
        InputMethodServiceInternal imsInternal = this.mImsInternal.getAndWarnIfNull();
        if (imsInternal != null && ImeTracing.getInstance().isEnabled()) {
            byte[] icProto = InputConnectionProtoDumper.buildGetCursorCapsModeProto(reqModes, result);
            imsInternal.triggerServiceDump("RemoteInputConnection#getCursorCapsMode", icProto);
        }
        return result;
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        if (this.mCancellationGroup.isCanceled()) {
            return null;
        }
        AndroidFuture<ExtractedText> value = this.mInvoker.getExtractedText(request, flags);
        ExtractedText result = CompletableFutureUtil.getResultOrNull(value, TAG, "getExtractedText()", this.mCancellationGroup, 2000L);
        InputMethodServiceInternal imsInternal = this.mImsInternal.getAndWarnIfNull();
        if (imsInternal != null && ImeTracing.getInstance().isEnabled()) {
            byte[] icProto = InputConnectionProtoDumper.buildGetExtractedTextProto(request, flags, result);
            imsInternal.triggerServiceDump("RemoteInputConnection#getExtractedText", icProto);
        }
        return result;
    }

    @Override
    public boolean commitText(CharSequence text, int newCursorPosition) {
        boolean handled = this.mInvoker.commitText(text, newCursorPosition);
        if (handled) {
            this.notifyUserActionIfNecessary();
        }
        return handled;
    }

    @Override
    public boolean commitText(CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        boolean handled = this.mInvoker.commitText(text, newCursorPosition, textAttribute);
        if (handled) {
            this.notifyUserActionIfNecessary();
        }
        return handled;
    }

    private void notifyUserActionIfNecessary() {
        InputMethodServiceInternal imsInternal = this.mImsInternal.getAndWarnIfNull();
        if (imsInternal == null) {
            return;
        }
        imsInternal.notifyUserActionIfNecessary();
    }

    @Override
    public boolean commitCompletion(CompletionInfo text) {
        return this.mInvoker.commitCompletion(text);
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        return this.mInvoker.commitCorrection(correctionInfo);
    }

    @Override
    public boolean setSelection(int start, int end) {
        return this.mInvoker.setSelection(start, end);
    }

    @Override
    public boolean performEditorAction(int actionCode) {
        return this.mInvoker.performEditorAction(actionCode);
    }

    @Override
    public boolean performContextMenuAction(int id2) {
        return this.mInvoker.performContextMenuAction(id2);
    }

    @Override
    public boolean setComposingRegion(int start, int end) {
        return this.mInvoker.setComposingRegion(start, end);
    }

    @Override
    public boolean setComposingRegion(int start, int end, TextAttribute textAttribute) {
        return this.mInvoker.setComposingRegion(start, end, textAttribute);
    }

    @Override
    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        boolean handled = this.mInvoker.setComposingText(text, newCursorPosition);
        if (handled) {
            this.notifyUserActionIfNecessary();
        }
        return handled;
    }

    @Override
    public boolean setComposingText(CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        boolean handled = this.mInvoker.setComposingText(text, newCursorPosition, textAttribute);
        if (handled) {
            this.notifyUserActionIfNecessary();
        }
        return handled;
    }

    @Override
    public boolean finishComposingText() {
        return this.mInvoker.finishComposingText();
    }

    @Override
    public boolean beginBatchEdit() {
        return this.mInvoker.beginBatchEdit();
    }

    @Override
    public boolean endBatchEdit() {
        return this.mInvoker.endBatchEdit();
    }

    @Override
    public boolean sendKeyEvent(KeyEvent event) {
        boolean handled = this.mInvoker.sendKeyEvent(event);
        if (handled) {
            this.notifyUserActionIfNecessary();
        }
        return handled;
    }

    @Override
    public boolean clearMetaKeyStates(int states) {
        return this.mInvoker.clearMetaKeyStates(states);
    }

    @Override
    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        return this.mInvoker.deleteSurroundingText(beforeLength, afterLength);
    }

    @Override
    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        return this.mInvoker.deleteSurroundingTextInCodePoints(beforeLength, afterLength);
    }

    @Override
    public boolean reportFullscreenMode(boolean enabled) {
        return false;
    }

    @Override
    public boolean performSpellCheck() {
        return this.mInvoker.performSpellCheck();
    }

    @Override
    public boolean performPrivateCommand(String action, Bundle data) {
        return this.mInvoker.performPrivateCommand(action, data);
    }

    @Override
    public boolean requestCursorUpdates(int cursorUpdateMode) {
        if (this.mCancellationGroup.isCanceled()) {
            return false;
        }
        InputMethodServiceInternal ims = this.mImsInternal.getAndWarnIfNull();
        if (ims == null) {
            return false;
        }
        int displayId = ims.getContext().getDisplayId();
        AndroidFuture<Boolean> value = this.mInvoker.requestCursorUpdates(cursorUpdateMode, displayId);
        return CompletableFutureUtil.getResultOrFalse(value, TAG, "requestCursorUpdates()", this.mCancellationGroup, 2000L);
    }

    @Override
    public boolean requestCursorUpdates(int cursorUpdateMode, int cursorUpdateFilter) {
        if (this.mCancellationGroup.isCanceled()) {
            return false;
        }
        InputMethodServiceInternal ims = this.mImsInternal.getAndWarnIfNull();
        if (ims == null) {
            return false;
        }
        int displayId = ims.getContext().getDisplayId();
        AndroidFuture<Boolean> value = this.mInvoker.requestCursorUpdates(cursorUpdateMode, cursorUpdateFilter, displayId);
        return CompletableFutureUtil.getResultOrFalse(value, TAG, "requestCursorUpdates()", this.mCancellationGroup, 2000L);
    }

    @Override
    public Handler getHandler() {
        return null;
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public boolean commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts) {
        if (this.mCancellationGroup.isCanceled()) {
            return false;
        }
        if ((flags & 1) != 0) {
            InputMethodServiceInternal imsInternal = this.mImsInternal.getAndWarnIfNull();
            if (imsInternal == null) {
                return false;
            }
            imsInternal.exposeContent(inputContentInfo, this);
        }
        AndroidFuture<Boolean> value = this.mInvoker.commitContent(inputContentInfo, flags, opts);
        return CompletableFutureUtil.getResultOrFalse(value, TAG, "commitContent()", this.mCancellationGroup, 2000L);
    }

    @Override
    public boolean setImeConsumesInput(boolean imeConsumesInput) {
        return this.mInvoker.setImeConsumesInput(imeConsumesInput);
    }

    public String toString() {
        return "RemoteInputConnection{idHash=#" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    private static class InputMethodServiceInternalHolder {
        private final WeakReference<InputMethodServiceInternal> mServiceRef;

        private InputMethodServiceInternalHolder(WeakReference<InputMethodServiceInternal> ims) {
            this.mServiceRef = ims;
        }

        public InputMethodServiceInternal getAndWarnIfNull() {
            InputMethodServiceInternal ims = (InputMethodServiceInternal)this.mServiceRef.get();
            if (ims == null) {
                Log.e(RemoteInputConnection.TAG, "InputMethodService is already destroyed.  InputConnection instances cannot be used beyond InputMethodService lifetime.", new Throwable());
            }
            return ims;
        }
    }
}

