/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.TimeUtils;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class Geofence
implements Parcelable {
    private final double mLatitude;
    private final double mLongitude;
    private final float mRadius;
    private long mExpirationRealtimeMs;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<Geofence> CREATOR = new Parcelable.Creator<Geofence>(){

        @Override
        public Geofence createFromParcel(Parcel in) {
            return new Geofence(in.readDouble(), in.readDouble(), in.readFloat(), in.readLong());
        }

        public Geofence[] newArray(int size) {
            return new Geofence[size];
        }
    };

    public static Geofence createCircle(double latitude, double longitude, float radius, long expirationRealtimeMs) {
        return new Geofence(latitude, longitude, radius, expirationRealtimeMs);
    }

    Geofence(double latitude, double longitude, float radius, long expirationRealtimeMs) {
        Preconditions.checkArgumentInRange(latitude, -90.0, 90.0, "latitude");
        Preconditions.checkArgumentInRange(longitude, -180.0, 180.0, "latitude");
        Preconditions.checkArgument(radius > 0.0f, "invalid radius: %f", Float.valueOf(radius));
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.mRadius = radius;
        this.mExpirationRealtimeMs = expirationRealtimeMs;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public boolean isExpired() {
        return this.isExpired(SystemClock.elapsedRealtime());
    }

    public boolean isExpired(long referenceRealtimeMs) {
        return referenceRealtimeMs >= this.mExpirationRealtimeMs;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeFloat(this.mRadius);
        parcel.writeLong(this.mExpirationRealtimeMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Geofence)) {
            return false;
        }
        Geofence geofence = (Geofence)o;
        return Double.compare(geofence.mLatitude, this.mLatitude) == 0 && Double.compare(geofence.mLongitude, this.mLongitude) == 0 && Float.compare(geofence.mRadius, this.mRadius) == 0 && this.mExpirationRealtimeMs == geofence.mExpirationRealtimeMs;
    }

    public int hashCode() {
        return Objects.hash(this.mLatitude, this.mLongitude, Float.valueOf(this.mRadius));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Geofence[(").append(this.mLatitude).append(", ").append(this.mLongitude).append(")");
        builder.append(" ").append(this.mRadius).append("m");
        if (this.mExpirationRealtimeMs < Long.MAX_VALUE) {
            if (this.isExpired()) {
                builder.append(" expired");
            } else {
                builder.append(" expires=");
                TimeUtils.formatDuration(this.mExpirationRealtimeMs, builder);
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

