/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RouteDiscoveryPreference
implements Parcelable {
    public static final Parcelable.Creator<RouteDiscoveryPreference> CREATOR = new Parcelable.Creator<RouteDiscoveryPreference>(){

        @Override
        public RouteDiscoveryPreference createFromParcel(Parcel in) {
            return new RouteDiscoveryPreference(in);
        }

        public RouteDiscoveryPreference[] newArray(int size) {
            return new RouteDiscoveryPreference[size];
        }
    };
    private final List<String> mPreferredFeatures;
    private final List<String> mPackageOrder;
    private final List<String> mAllowedPackages;
    private final boolean mShouldPerformActiveScan;
    private final Bundle mExtras;
    @SystemApi
    public static final RouteDiscoveryPreference EMPTY = new Builder(Collections.emptyList(), false).build();

    RouteDiscoveryPreference(Builder builder) {
        this.mPreferredFeatures = builder.mPreferredFeatures;
        this.mPackageOrder = builder.mPackageOrder;
        this.mAllowedPackages = builder.mAllowedPackages;
        this.mShouldPerformActiveScan = builder.mActiveScan;
        this.mExtras = builder.mExtras;
    }

    RouteDiscoveryPreference(Parcel in) {
        this.mPreferredFeatures = in.createStringArrayList();
        this.mPackageOrder = in.createStringArrayList();
        this.mAllowedPackages = in.createStringArrayList();
        this.mShouldPerformActiveScan = in.readBoolean();
        this.mExtras = in.readBundle();
    }

    public List<String> getPreferredFeatures() {
        return this.mPreferredFeatures;
    }

    public List<String> getDeduplicationPackageOrder() {
        return this.mPackageOrder;
    }

    public List<String> getAllowedPackages() {
        return this.mAllowedPackages;
    }

    public boolean shouldPerformActiveScan() {
        return this.mShouldPerformActiveScan;
    }

    public boolean shouldRemoveDuplicates() {
        return !this.mPackageOrder.isEmpty();
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringList(this.mPreferredFeatures);
        dest.writeStringList(this.mPackageOrder);
        dest.writeStringList(this.mAllowedPackages);
        dest.writeBoolean(this.mShouldPerformActiveScan);
        dest.writeBundle(this.mExtras);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("RouteDiscoveryRequest{ ").append("preferredFeatures={").append(String.join((CharSequence)", ", this.mPreferredFeatures)).append("}").append(", activeScan=").append(this.mShouldPerformActiveScan).append(" }");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RouteDiscoveryPreference)) {
            return false;
        }
        RouteDiscoveryPreference other = (RouteDiscoveryPreference)o;
        return Objects.equals(this.mPreferredFeatures, other.mPreferredFeatures) && Objects.equals(this.mPackageOrder, other.mPackageOrder) && Objects.equals(this.mAllowedPackages, other.mAllowedPackages) && this.mShouldPerformActiveScan == other.mShouldPerformActiveScan;
    }

    public int hashCode() {
        return Objects.hash(this.mPreferredFeatures, this.mPackageOrder, this.mAllowedPackages, this.mShouldPerformActiveScan);
    }

    public static class Builder {
        List<String> mPreferredFeatures;
        List<String> mPackageOrder;
        List<String> mAllowedPackages;
        boolean mActiveScan;
        Bundle mExtras;

        public Builder(List<String> preferredFeatures, boolean activeScan) {
            Objects.requireNonNull(preferredFeatures, "preferredFeatures must not be null");
            this.mPreferredFeatures = preferredFeatures.stream().filter(str -> !TextUtils.isEmpty(str)).collect(Collectors.toList());
            this.mPackageOrder = List.of();
            this.mAllowedPackages = List.of();
            this.mActiveScan = activeScan;
        }

        public Builder(RouteDiscoveryPreference preference) {
            Objects.requireNonNull(preference, "preference must not be null");
            this.mPreferredFeatures = preference.getPreferredFeatures();
            this.mPackageOrder = preference.getDeduplicationPackageOrder();
            this.mAllowedPackages = preference.getAllowedPackages();
            this.mActiveScan = preference.shouldPerformActiveScan();
            this.mExtras = preference.getExtras();
        }

        public Builder(Collection<RouteDiscoveryPreference> preferences) {
            Objects.requireNonNull(preferences, "preferences must not be null");
            HashSet<String> preferredFeatures = new HashSet<String>();
            HashSet<String> allowedPackages = new HashSet<String>();
            this.mPackageOrder = List.of();
            boolean activeScan = false;
            for (RouteDiscoveryPreference preference : preferences) {
                preferredFeatures.addAll(preference.mPreferredFeatures);
                allowedPackages.addAll(preference.mAllowedPackages);
                activeScan |= preference.mShouldPerformActiveScan;
                if (!this.mPackageOrder.isEmpty() || preference.mPackageOrder.isEmpty()) continue;
                this.mPackageOrder = List.copyOf(preference.mPackageOrder);
            }
            this.mPreferredFeatures = List.copyOf(preferredFeatures);
            this.mAllowedPackages = List.copyOf(allowedPackages);
            this.mActiveScan = activeScan;
        }

        public Builder setPreferredFeatures(List<String> preferredFeatures) {
            Objects.requireNonNull(preferredFeatures, "preferredFeatures must not be null");
            this.mPreferredFeatures = preferredFeatures.stream().filter(str -> !TextUtils.isEmpty(str)).collect(Collectors.toList());
            return this;
        }

        public Builder setAllowedPackages(List<String> allowedPackages) {
            Objects.requireNonNull(allowedPackages, "allowedPackages must not be null");
            this.mAllowedPackages = List.copyOf(allowedPackages);
            return this;
        }

        public Builder setShouldPerformActiveScan(boolean activeScan) {
            this.mActiveScan = activeScan;
            return this;
        }

        public Builder setDeduplicationPackageOrder(List<String> packageOrder) {
            Objects.requireNonNull(packageOrder, "packageOrder must not be null");
            this.mPackageOrder = List.copyOf(packageOrder);
            return this;
        }

        public Builder setExtras(Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        public RouteDiscoveryPreference build() {
            return new RouteDiscoveryPreference(this);
        }
    }
}

