/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.SuppressLint;
import android.media.tv.CommandRequest;
import android.media.tv.DsmccRequest;
import android.media.tv.PesRequest;
import android.media.tv.SectionRequest;
import android.media.tv.StreamEventRequest;
import android.media.tv.TableRequest;
import android.media.tv.TimelineRequest;
import android.media.tv.TsRequest;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SuppressLint(value={"ParcelNotFinal"})
public abstract class BroadcastInfoRequest
implements Parcelable {
    public static final int REQUEST_OPTION_REPEAT = 0;
    public static final int REQUEST_OPTION_AUTO_UPDATE = 1;
    public static final Parcelable.Creator<BroadcastInfoRequest> CREATOR = new Parcelable.Creator<BroadcastInfoRequest>(){

        @Override
        public BroadcastInfoRequest createFromParcel(Parcel source) {
            int type = source.readInt();
            switch (type) {
                case 1: {
                    return TsRequest.createFromParcelBody(source);
                }
                case 2: {
                    return TableRequest.createFromParcelBody(source);
                }
                case 3: {
                    return SectionRequest.createFromParcelBody(source);
                }
                case 4: {
                    return PesRequest.createFromParcelBody(source);
                }
                case 5: {
                    return StreamEventRequest.createFromParcelBody(source);
                }
                case 6: {
                    return DsmccRequest.createFromParcelBody(source);
                }
                case 7: {
                    return CommandRequest.createFromParcelBody(source);
                }
                case 8: {
                    return TimelineRequest.createFromParcelBody(source);
                }
            }
            throw new IllegalStateException("Unexpected broadcast info request type (value " + type + ") in parcel.");
        }

        public BroadcastInfoRequest[] newArray(int size) {
            return new BroadcastInfoRequest[size];
        }
    };
    private final int mType;
    private final int mRequestId;
    private final int mOption;

    BroadcastInfoRequest(int type, int requestId, int option) {
        this.mType = type;
        this.mRequestId = requestId;
        this.mOption = option;
    }

    BroadcastInfoRequest(int type, Parcel source) {
        this.mType = type;
        this.mRequestId = source.readInt();
        this.mOption = source.readInt();
    }

    public int getType() {
        return this.mType;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public int getOption() {
        return this.mOption;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mRequestId);
        dest.writeInt(this.mOption);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestOption {
    }
}

