/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.interactive;

import android.graphics.Rect;
import android.media.tv.AdRequest;
import android.media.tv.BroadcastInfoRequest;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.InputChannel;

public interface ITvInteractiveAppClient
extends IInterface {
    public static final String DESCRIPTOR = "android.media.tv.interactive.ITvInteractiveAppClient";

    public void onSessionCreated(String var1, IBinder var2, InputChannel var3, int var4) throws RemoteException;

    public void onSessionReleased(int var1) throws RemoteException;

    public void onLayoutSurface(int var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void onBroadcastInfoRequest(BroadcastInfoRequest var1, int var2) throws RemoteException;

    public void onRemoveBroadcastInfo(int var1, int var2) throws RemoteException;

    public void onSessionStateChanged(int var1, int var2, int var3) throws RemoteException;

    public void onBiInteractiveAppCreated(Uri var1, String var2, int var3) throws RemoteException;

    public void onTeletextAppStateChanged(int var1, int var2) throws RemoteException;

    public void onCommandRequest(String var1, Bundle var2, int var3) throws RemoteException;

    public void onSetVideoBounds(Rect var1, int var2) throws RemoteException;

    public void onRequestCurrentChannelUri(int var1) throws RemoteException;

    public void onRequestCurrentChannelLcn(int var1) throws RemoteException;

    public void onRequestStreamVolume(int var1) throws RemoteException;

    public void onRequestTrackInfoList(int var1) throws RemoteException;

    public void onRequestCurrentTvInputId(int var1) throws RemoteException;

    public void onRequestSigning(String var1, String var2, String var3, byte[] var4, int var5) throws RemoteException;

    public void onAdRequest(AdRequest var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInteractiveAppClient {
        static final int TRANSACTION_onSessionCreated = 1;
        static final int TRANSACTION_onSessionReleased = 2;
        static final int TRANSACTION_onLayoutSurface = 3;
        static final int TRANSACTION_onBroadcastInfoRequest = 4;
        static final int TRANSACTION_onRemoveBroadcastInfo = 5;
        static final int TRANSACTION_onSessionStateChanged = 6;
        static final int TRANSACTION_onBiInteractiveAppCreated = 7;
        static final int TRANSACTION_onTeletextAppStateChanged = 8;
        static final int TRANSACTION_onCommandRequest = 9;
        static final int TRANSACTION_onSetVideoBounds = 10;
        static final int TRANSACTION_onRequestCurrentChannelUri = 11;
        static final int TRANSACTION_onRequestCurrentChannelLcn = 12;
        static final int TRANSACTION_onRequestStreamVolume = 13;
        static final int TRANSACTION_onRequestTrackInfoList = 14;
        static final int TRANSACTION_onRequestCurrentTvInputId = 15;
        static final int TRANSACTION_onRequestSigning = 16;
        static final int TRANSACTION_onAdRequest = 17;

        public Stub() {
            this.attachInterface(this, ITvInteractiveAppClient.DESCRIPTOR);
        }

        public static ITvInteractiveAppClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITvInteractiveAppClient.DESCRIPTOR);
            if (iin != null && iin instanceof ITvInteractiveAppClient) {
                return (ITvInteractiveAppClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSessionCreated";
                }
                case 2: {
                    return "onSessionReleased";
                }
                case 3: {
                    return "onLayoutSurface";
                }
                case 4: {
                    return "onBroadcastInfoRequest";
                }
                case 5: {
                    return "onRemoveBroadcastInfo";
                }
                case 6: {
                    return "onSessionStateChanged";
                }
                case 7: {
                    return "onBiInteractiveAppCreated";
                }
                case 8: {
                    return "onTeletextAppStateChanged";
                }
                case 9: {
                    return "onCommandRequest";
                }
                case 10: {
                    return "onSetVideoBounds";
                }
                case 11: {
                    return "onRequestCurrentChannelUri";
                }
                case 12: {
                    return "onRequestCurrentChannelLcn";
                }
                case 13: {
                    return "onRequestStreamVolume";
                }
                case 14: {
                    return "onRequestTrackInfoList";
                }
                case 15: {
                    return "onRequestCurrentTvInputId";
                }
                case 16: {
                    return "onRequestSigning";
                }
                case 17: {
                    return "onAdRequest";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITvInteractiveAppClient.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    InputChannel _arg2 = data.readTypedObject(InputChannel.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionCreated(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionReleased(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLayoutSurface(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 4: {
                    BroadcastInfoRequest _arg0 = data.readTypedObject(BroadcastInfoRequest.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastInfoRequest(_arg0, _arg1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRemoveBroadcastInfo(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionStateChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBiInteractiveAppCreated(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTeletextAppStateChanged(_arg0, _arg1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCommandRequest(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSetVideoBounds(_arg0, _arg1);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentChannelUri(_arg0);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentChannelLcn(_arg0);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestStreamVolume(_arg0);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestTrackInfoList(_arg0);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentTvInputId(_arg0);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    byte[] _arg3 = data.createByteArray();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestSigning(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 17: {
                    AdRequest _arg0 = data.readTypedObject(AdRequest.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAdRequest(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 16;
        }

        private static class Proxy
        implements ITvInteractiveAppClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITvInteractiveAppClient.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionCreated(String iAppServiceId, IBinder token, InputChannel channel, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(iAppServiceId);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(channel, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionReleased(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutSurface(int left, int top, int right, int bottom, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(left);
                    _data.writeInt(top);
                    _data.writeInt(right);
                    _data.writeInt(bottom);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastInfoRequest(BroadcastInfoRequest request, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoveBroadcastInfo(int id2, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionStateChanged(int state, int err, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeInt(err);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiInteractiveAppCreated(Uri biIAppUri, String biIAppId, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeTypedObject(biIAppUri, 0);
                    _data.writeString(biIAppId);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTeletextAppStateChanged(int state, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCommandRequest(String cmdType, Bundle parameters, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(cmdType);
                    _data.writeTypedObject(parameters, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetVideoBounds(Rect rect, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeTypedObject(rect, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentChannelUri(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentChannelLcn(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestStreamVolume(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestTrackInfoList(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentTvInputId(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestSigning(String id2, String algorithm, String alias, byte[] data, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeString(algorithm);
                    _data.writeString(alias);
                    _data.writeByteArray(data);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdRequest(AdRequest request, int Seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(Seq);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInteractiveAppClient {
        @Override
        public void onSessionCreated(String iAppServiceId, IBinder token, InputChannel channel, int seq) throws RemoteException {
        }

        @Override
        public void onSessionReleased(int seq) throws RemoteException {
        }

        @Override
        public void onLayoutSurface(int left, int top, int right, int bottom, int seq) throws RemoteException {
        }

        @Override
        public void onBroadcastInfoRequest(BroadcastInfoRequest request, int seq) throws RemoteException {
        }

        @Override
        public void onRemoveBroadcastInfo(int id2, int seq) throws RemoteException {
        }

        @Override
        public void onSessionStateChanged(int state, int err, int seq) throws RemoteException {
        }

        @Override
        public void onBiInteractiveAppCreated(Uri biIAppUri, String biIAppId, int seq) throws RemoteException {
        }

        @Override
        public void onTeletextAppStateChanged(int state, int seq) throws RemoteException {
        }

        @Override
        public void onCommandRequest(String cmdType, Bundle parameters, int seq) throws RemoteException {
        }

        @Override
        public void onSetVideoBounds(Rect rect, int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentChannelUri(int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentChannelLcn(int seq) throws RemoteException {
        }

        @Override
        public void onRequestStreamVolume(int seq) throws RemoteException {
        }

        @Override
        public void onRequestTrackInfoList(int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentTvInputId(int seq) throws RemoteException {
        }

        @Override
        public void onRequestSigning(String id2, String algorithm, String alias, byte[] data, int seq) throws RemoteException {
        }

        @Override
        public void onAdRequest(AdRequest request, int Seq) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

