/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.NetworkUtils;
import android.net.connectivity.com.android.net.module.util.NetUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;

public class IpPrefix
implements Parcelable {
    private final byte[] address;
    private final int prefixLength;
    public static final Parcelable.Creator<IpPrefix> CREATOR = new Parcelable.Creator<IpPrefix>(){

        @Override
        public IpPrefix createFromParcel(Parcel in) {
            byte[] address = in.createByteArray();
            int prefixLength = in.readInt();
            return new IpPrefix(address, prefixLength);
        }

        public IpPrefix[] newArray(int size) {
            return new IpPrefix[size];
        }
    };

    private void checkAndMaskAddressAndPrefixLength() {
        if (this.address.length != 4 && this.address.length != 16) {
            throw new IllegalArgumentException("IpPrefix has " + this.address.length + " bytes which is neither 4 nor 16");
        }
        NetUtils.maskRawAddress(this.address, this.prefixLength);
    }

    public IpPrefix(byte[] address, int prefixLength) {
        this.address = (byte[])address.clone();
        this.prefixLength = prefixLength;
        this.checkAndMaskAddressAndPrefixLength();
    }

    public IpPrefix(InetAddress address, int prefixLength) {
        this.address = address.getAddress();
        this.prefixLength = prefixLength;
        this.checkAndMaskAddressAndPrefixLength();
    }

    @SystemApi
    public IpPrefix(String prefix) {
        Pair<InetAddress, Integer> ipAndMask = NetworkUtils.legacyParseIpAndMask(prefix);
        this.address = ((InetAddress)ipAndMask.first).getAddress();
        this.prefixLength = (Integer)ipAndMask.second;
        this.checkAndMaskAddressAndPrefixLength();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IpPrefix)) {
            return false;
        }
        IpPrefix that = (IpPrefix)obj;
        return Arrays.equals(this.address, that.address) && this.prefixLength == that.prefixLength;
    }

    public int hashCode() {
        return Arrays.hashCode(this.address) + 11 * this.prefixLength;
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByAddress(this.address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Address is invalid");
        }
    }

    public byte[] getRawAddress() {
        return (byte[])this.address.clone();
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public boolean contains(InetAddress address) {
        byte[] addrBytes = address.getAddress();
        if (addrBytes == null || addrBytes.length != this.address.length) {
            return false;
        }
        NetUtils.maskRawAddress(addrBytes, this.prefixLength);
        return Arrays.equals(this.address, addrBytes);
    }

    public boolean containsPrefix(IpPrefix otherPrefix) {
        if (otherPrefix.getPrefixLength() < this.prefixLength) {
            return false;
        }
        byte[] otherAddress = otherPrefix.getRawAddress();
        NetUtils.maskRawAddress(otherAddress, this.prefixLength);
        return Arrays.equals(otherAddress, this.address);
    }

    public boolean isIPv6() {
        return this.getAddress() instanceof Inet6Address;
    }

    public boolean isIPv4() {
        return this.getAddress() instanceof Inet4Address;
    }

    public String toString() {
        try {
            return InetAddress.getByAddress(this.address).getHostAddress() + "/" + this.prefixLength;
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("IpPrefix with invalid address! Shouldn't happen.", e);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.address);
        dest.writeInt(this.prefixLength);
    }

    public static Comparator<IpPrefix> lengthComparator() {
        return new Comparator<IpPrefix>(){

            @Override
            public int compare(IpPrefix prefix1, IpPrefix prefix2) {
                int p2len;
                int p1len;
                if (prefix1.isIPv4()) {
                    if (prefix2.isIPv6()) {
                        return -1;
                    }
                } else if (prefix2.isIPv4()) {
                    return 1;
                }
                if ((p1len = prefix1.getPrefixLength()) < (p2len = prefix2.getPrefixLength())) {
                    return -1;
                }
                if (p2len < p1len) {
                    return 1;
                }
                byte[] a1 = prefix1.address;
                byte[] a2 = prefix2.address;
                int len = a1.length < a2.length ? a1.length : a2.length;
                for (int i = 0; i < len; ++i) {
                    if (a1[i] < a2[i]) {
                        return -1;
                    }
                    if (a1[i] <= a2[i]) continue;
                    return 1;
                }
                if (a2.length < len) {
                    return 1;
                }
                if (a1.length < len) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

