/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.WifiKey;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@Deprecated
@SystemApi
public class NetworkKey
implements Parcelable {
    private static final String TAG = "NetworkKey";
    public static final int TYPE_WIFI = 1;
    public final int type;
    public final WifiKey wifiKey;
    public static final Parcelable.Creator<NetworkKey> CREATOR = new Parcelable.Creator<NetworkKey>(){

        @Override
        public NetworkKey createFromParcel(Parcel in) {
            return new NetworkKey(in);
        }

        public NetworkKey[] newArray(int size) {
            return new NetworkKey[size];
        }
    };

    public static NetworkKey createFromScanResult(ScanResult result) {
        Objects.requireNonNull(result);
        String ssid = result.SSID;
        if (TextUtils.isEmpty(ssid) || ssid.equals("<unknown ssid>")) {
            return null;
        }
        String bssid = result.BSSID;
        if (TextUtils.isEmpty(bssid)) {
            return null;
        }
        try {
            WifiKey wifiKey = new WifiKey(String.format("\"%s\"", ssid), bssid);
            return new NetworkKey(wifiKey);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Unable to create WifiKey.", e);
            return null;
        }
    }

    public static NetworkKey createFromWifiInfo(WifiInfo wifiInfo) {
        if (wifiInfo != null) {
            String ssid = wifiInfo.getSSID();
            String bssid = wifiInfo.getBSSID();
            if (!(TextUtils.isEmpty(ssid) || ssid.equals("<unknown ssid>") || TextUtils.isEmpty(bssid))) {
                WifiKey wifiKey;
                try {
                    wifiKey = new WifiKey(ssid, bssid);
                }
                catch (IllegalArgumentException e) {
                    Log.e(TAG, "Unable to create WifiKey.", e);
                    return null;
                }
                return new NetworkKey(wifiKey);
            }
        }
        return null;
    }

    public NetworkKey(WifiKey wifiKey) {
        this.type = 1;
        this.wifiKey = wifiKey;
    }

    private NetworkKey(Parcel in) {
        this.type = in.readInt();
        switch (this.type) {
            case 1: {
                this.wifiKey = WifiKey.CREATOR.createFromParcel(in);
                break;
            }
            default: {
                throw new IllegalArgumentException("Parcel has unknown type: " + this.type);
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.type);
        switch (this.type) {
            case 1: {
                this.wifiKey.writeToParcel(out, flags);
                break;
            }
            default: {
                throw new IllegalStateException("NetworkKey has unknown type " + this.type);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkKey that = (NetworkKey)o;
        return this.type == that.type && Objects.equals(this.wifiKey, that.wifiKey);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.wifiKey);
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return this.wifiKey.toString();
            }
        }
        return "InvalidKey";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkType {
    }
}

