/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.app.usage.NetworkStats;
import android.net.NetworkStats;
import com.android.internal.annotations.VisibleForTesting;

public class NetworkStatsUtils {
    private static final int SET_ALL = -1;
    private static final int METERED_ALL = -1;
    private static final int ROAMING_ALL = -1;
    private static final int DEFAULT_NETWORK_ALL = -1;
    public static final int SUBSCRIBER_ID_MATCH_RULE_EXACT = 0;
    public static final int SUBSCRIBER_ID_MATCH_RULE_ALL = 1;
    public static final String LIMIT_GLOBAL_ALERT = "globalAlert";

    public static long multiplySafeByRational(long value, long num, long den) {
        long ay;
        if (den == 0L) {
            throw new ArithmeticException("Invalid Denominator");
        }
        long x = value;
        long y = num;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            return (long)((double)num / (double)den * (double)value);
        }
        return r / den;
    }

    public static int constrain(int amount, int low, int high) {
        if (low > high) {
            throw new IllegalArgumentException("low(" + low + ") > high(" + high + ")");
        }
        return amount < low ? low : (amount > high ? high : amount);
    }

    public static long constrain(long amount, long low, long high) {
        if (low > high) {
            throw new IllegalArgumentException("low(" + low + ") > high(" + high + ")");
        }
        return amount < low ? low : (amount > high ? high : amount);
    }

    public static NetworkStats fromPublicNetworkStats(android.app.usage.NetworkStats publiceNetworkStats) {
        NetworkStats stats = new NetworkStats(0L, 0);
        while (publiceNetworkStats.hasNextBucket()) {
            NetworkStats.Bucket bucket = new NetworkStats.Bucket();
            publiceNetworkStats.getNextBucket(bucket);
            NetworkStats.Entry entry = NetworkStatsUtils.fromBucket(bucket);
            stats = stats.addEntry(entry);
        }
        return stats;
    }

    @VisibleForTesting
    public static NetworkStats.Entry fromBucket(NetworkStats.Bucket bucket) {
        return new NetworkStats.Entry(null, bucket.getUid(), NetworkStatsUtils.convertBucketState(bucket.getState()), NetworkStatsUtils.convertBucketTag(bucket.getTag()), NetworkStatsUtils.convertBucketMetered(bucket.getMetered()), NetworkStatsUtils.convertBucketRoaming(bucket.getRoaming()), NetworkStatsUtils.convertBucketDefaultNetworkStatus(bucket.getDefaultNetworkStatus()), bucket.getRxBytes(), bucket.getRxPackets(), bucket.getTxBytes(), bucket.getTxPackets(), 0L);
    }

    private static int convertBucketState(int networkStatsSet) {
        switch (networkStatsSet) {
            case -1: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private static int convertBucketTag(int tag) {
        switch (tag) {
            case 0: {
                return 0;
            }
        }
        return tag;
    }

    private static int convertBucketMetered(int metered) {
        switch (metered) {
            case -1: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private static int convertBucketRoaming(int roaming) {
        switch (roaming) {
            case -1: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private static int convertBucketDefaultNetworkStatus(int defaultNetworkStatus) {
        switch (defaultNetworkStatus) {
            case -1: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }
}

