/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike.exceptions;

import android.annotation.SystemApi;
import android.net.ipsec.ike.exceptions.IkeException;
import com.android.internal.net.ipsec.ike.message.IkeNotifyPayload;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;

public abstract class IkeProtocolException
extends IkeException {
    public static final int ERROR_TYPE_UNSUPPORTED_CRITICAL_PAYLOAD = 1;
    public static final int ERROR_TYPE_INVALID_IKE_SPI = 4;
    public static final int ERROR_TYPE_INVALID_MAJOR_VERSION = 5;
    public static final int ERROR_TYPE_INVALID_SYNTAX = 7;
    public static final int ERROR_TYPE_INVALID_MESSAGE_ID = 9;
    public static final int ERROR_TYPE_NO_PROPOSAL_CHOSEN = 14;
    public static final int ERROR_TYPE_INVALID_KE_PAYLOAD = 17;
    public static final int ERROR_TYPE_AUTHENTICATION_FAILED = 24;
    public static final int ERROR_TYPE_SINGLE_PAIR_REQUIRED = 34;
    public static final int ERROR_TYPE_NO_ADDITIONAL_SAS = 35;
    public static final int ERROR_TYPE_INTERNAL_ADDRESS_FAILURE = 36;
    public static final int ERROR_TYPE_FAILED_CP_REQUIRED = 37;
    public static final int ERROR_TYPE_TS_UNACCEPTABLE = 38;
    public static final int ERROR_TYPE_INVALID_SELECTORS = 39;
    public static final int ERROR_TYPE_TEMPORARY_FAILURE = 43;
    public static final int ERROR_TYPE_CHILD_SA_NOT_FOUND = 44;
    public static final byte[] ERROR_DATA_NOT_INCLUDED = new byte[0];
    private static final int INTEGER_BYTE_SIZE = 4;
    private final int mErrorType;
    private final byte[] mErrorData;

    protected IkeProtocolException(int code) {
        this.mErrorType = code;
        this.mErrorData = ERROR_DATA_NOT_INCLUDED;
    }

    protected IkeProtocolException(int code, String message) {
        super(message);
        this.mErrorType = code;
        this.mErrorData = ERROR_DATA_NOT_INCLUDED;
    }

    protected IkeProtocolException(int code, Throwable cause) {
        super(cause);
        this.mErrorType = code;
        this.mErrorData = ERROR_DATA_NOT_INCLUDED;
    }

    protected IkeProtocolException(int code, String message, Throwable cause) {
        super(message, cause);
        this.mErrorType = code;
        this.mErrorData = ERROR_DATA_NOT_INCLUDED;
    }

    protected IkeProtocolException(int code, byte[] notifyData) {
        if (!this.isValidDataLength(notifyData.length)) {
            throw new IllegalArgumentException("Invalid error data for error type: " + code + " Received error data size: " + notifyData.length);
        }
        this.mErrorType = code;
        this.mErrorData = (byte[])notifyData.clone();
    }

    protected abstract boolean isValidDataLength(int var1);

    protected static byte[] integerToByteArray(int integer2, int arraySize) {
        if (arraySize > 4) {
            throw new IllegalArgumentException("Cannot convert integer to a byte array of length: " + arraySize);
        }
        ByteBuffer dataBuffer = ByteBuffer.allocate(4);
        dataBuffer.putInt(integer2);
        dataBuffer.rewind();
        byte[] zeroPad = new byte[4 - arraySize];
        byte[] byteData = new byte[arraySize];
        dataBuffer.get(zeroPad).get(byteData);
        return byteData;
    }

    protected static int byteArrayToInteger(byte[] byteArray) {
        if (byteArray == null || byteArray.length > 4) {
            throw new IllegalArgumentException("Cannot convert the byte array to integer");
        }
        ByteBuffer dataBuffer = ByteBuffer.allocate(4);
        byte[] zeroPad = new byte[4 - byteArray.length];
        dataBuffer.put(zeroPad).put(byteArray);
        dataBuffer.rewind();
        return dataBuffer.getInt();
    }

    public int getErrorType() {
        return this.mErrorType;
    }

    @SystemApi
    public byte[] getErrorData() {
        return this.mErrorData;
    }

    public IkeNotifyPayload buildNotifyPayload() {
        return new IkeNotifyPayload(this.mErrorType, this.mErrorData);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorType {
    }
}

