/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.lowpan.LowpanBeaconInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILowpanNetScanCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.lowpan.ILowpanNetScanCallback";

    public void onNetScanBeacon(LowpanBeaconInfo var1) throws RemoteException;

    public void onNetScanFinished() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILowpanNetScanCallback {
        static final int TRANSACTION_onNetScanBeacon = 1;
        static final int TRANSACTION_onNetScanFinished = 2;

        public Stub() {
            this.attachInterface(this, ILowpanNetScanCallback.DESCRIPTOR);
        }

        public static ILowpanNetScanCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILowpanNetScanCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ILowpanNetScanCallback) {
                return (ILowpanNetScanCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onNetScanBeacon";
                }
                case 2: {
                    return "onNetScanFinished";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILowpanNetScanCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    LowpanBeaconInfo _arg0 = data.readTypedObject(LowpanBeaconInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNetScanBeacon(_arg0);
                    break;
                }
                case 2: {
                    this.onNetScanFinished();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ILowpanNetScanCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILowpanNetScanCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetScanBeacon(LowpanBeaconInfo beacon) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanNetScanCallback.DESCRIPTOR);
                    _data.writeTypedObject(beacon, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNetScanFinished() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanNetScanCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILowpanNetScanCallback {
        @Override
        public void onNetScanBeacon(LowpanBeaconInfo beacon) throws RemoteException {
        }

        @Override
        public void onNetScanFinished() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

