/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.SoftApCapability;
import android.net.wifi.SoftApInfo;
import android.net.wifi.WifiClient;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public interface ISoftApCallback
extends IInterface {
    public void onStateChanged(int var1, int var2) throws RemoteException;

    public void onConnectedClientsOrInfoChanged(Map<String, SoftApInfo> var1, Map<String, List<WifiClient>> var2, boolean var3, boolean var4) throws RemoteException;

    public void onCapabilityChanged(SoftApCapability var1) throws RemoteException;

    public void onBlockedClientConnecting(WifiClient var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISoftApCallback {
        public static final String DESCRIPTOR = "android.net.wifi.ISoftApCallback";
        static final int TRANSACTION_onStateChanged = 1;
        static final int TRANSACTION_onConnectedClientsOrInfoChanged = 2;
        static final int TRANSACTION_onCapabilityChanged = 3;
        static final int TRANSACTION_onBlockedClientConnecting = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISoftApCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISoftApCallback) {
                return (ISoftApCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onStateChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int N = data.readInt();
                    HashMap<String, SoftApInfo> _arg0 = N < 0 ? null : new HashMap<String, SoftApInfo>();
                    IntStream.range(0, N).forEach(i -> {
                        String k = data.readString();
                        SoftApInfo v = data.readTypedObject(SoftApInfo.CREATOR);
                        _arg0.put(k, v);
                    });
                    int N2 = data.readInt();
                    HashMap<String, List<WifiClient>> _arg1 = N2 < 0 ? null : new HashMap<String, List<WifiClient>>();
                    IntStream.range(0, N2).forEach(i -> {
                        String k = data.readString();
                        ArrayList<WifiClient> v = data.createTypedArrayList(WifiClient.CREATOR);
                        _arg1.put(k, v);
                    });
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    this.onConnectedClientsOrInfoChanged(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    SoftApCapability _arg0 = data.readTypedObject(SoftApCapability.CREATOR);
                    this.onCapabilityChanged(_arg0);
                    break;
                }
                case 4: {
                    WifiClient _arg0 = data.readTypedObject(WifiClient.CREATOR);
                    int _arg1 = data.readInt();
                    this.onBlockedClientConnecting(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISoftApCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStateChanged(int state, int failureReason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeInt(failureReason);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectedClientsOrInfoChanged(Map<String, SoftApInfo> infos, Map<String, List<WifiClient>> clients, boolean isBridged, boolean isRegistration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (infos == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(infos.size());
                        infos.forEach((k, v) -> {
                            _data.writeString((String)k);
                            _data.writeTypedObject(v, 0);
                        });
                    }
                    if (clients == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(clients.size());
                        clients.forEach((k, v) -> {
                            _data.writeString((String)k);
                            _data.writeTypedList(v);
                        });
                    }
                    _data.writeBoolean(isBridged);
                    _data.writeBoolean(isRegistration);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilityChanged(SoftApCapability capability) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(capability, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBlockedClientConnecting(WifiClient client, int blockedReason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(client, 0);
                    _data.writeInt(blockedReason);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISoftApCallback {
        @Override
        public void onStateChanged(int state, int failureReason) throws RemoteException {
        }

        @Override
        public void onConnectedClientsOrInfoChanged(Map<String, SoftApInfo> infos, Map<String, List<WifiClient>> clients, boolean isBridged, boolean isRegistration) throws RemoteException {
        }

        @Override
        public void onCapabilityChanged(SoftApCapability capability) throws RemoteException {
        }

        @Override
        public void onBlockedClientConnecting(WifiClient client, int blockedReason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

