/*
 * Decompiled with CFR 0.152.
 */
package android.os;

public class ThreadLocalWorkSource {
    public static final int UID_NONE = -1;
    private static final ThreadLocal<Integer> sWorkSourceUid = ThreadLocal.withInitial(() -> -1);

    public static int getUid() {
        return sWorkSourceUid.get();
    }

    public static long setUid(int uid) {
        long token = ThreadLocalWorkSource.getToken();
        sWorkSourceUid.set(uid);
        return token;
    }

    public static void restore(long token) {
        sWorkSourceUid.set(ThreadLocalWorkSource.parseUidFromToken(token));
    }

    public static long clear() {
        return ThreadLocalWorkSource.setUid(-1);
    }

    private static int parseUidFromToken(long token) {
        return (int)token;
    }

    private static long getToken() {
        return sWorkSourceUid.get().intValue();
    }

    private ThreadLocalWorkSource() {
    }
}

