/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.content.pm.VersionedPackage;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;

public class NotificationListenerFilter
implements Parcelable {
    private static final int DEFAULT_TYPES = 15;
    private int mAllowedNotificationTypes;
    private ArraySet<VersionedPackage> mDisallowedPackages;
    public static final Parcelable.Creator<NotificationListenerFilter> CREATOR = new Parcelable.Creator<NotificationListenerFilter>(){

        @Override
        public NotificationListenerFilter createFromParcel(Parcel in) {
            return new NotificationListenerFilter(in);
        }

        public NotificationListenerFilter[] newArray(int size) {
            return new NotificationListenerFilter[size];
        }
    };

    public NotificationListenerFilter() {
        this.mAllowedNotificationTypes = 15;
        this.mDisallowedPackages = new ArraySet();
    }

    public NotificationListenerFilter(int types, ArraySet<VersionedPackage> pkgs) {
        this.mAllowedNotificationTypes = types;
        this.mDisallowedPackages = pkgs;
    }

    protected NotificationListenerFilter(Parcel in) {
        this.mAllowedNotificationTypes = in.readInt();
        this.mDisallowedPackages = in.readArraySet(VersionedPackage.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mAllowedNotificationTypes);
        dest.writeArraySet(this.mDisallowedPackages);
    }

    public boolean isTypeAllowed(int type) {
        return (this.mAllowedNotificationTypes & type) != 0;
    }

    public boolean areAllTypesAllowed() {
        return 15 == this.mAllowedNotificationTypes;
    }

    public boolean isPackageAllowed(VersionedPackage pkg) {
        return !this.mDisallowedPackages.contains(pkg);
    }

    public int getTypes() {
        return this.mAllowedNotificationTypes;
    }

    public ArraySet<VersionedPackage> getDisallowedPackages() {
        return this.mDisallowedPackages;
    }

    public void setTypes(int types) {
        this.mAllowedNotificationTypes = types;
    }

    public void setDisallowedPackages(ArraySet<VersionedPackage> pkgs) {
        this.mDisallowedPackages = pkgs;
    }

    public void removePackage(VersionedPackage pkg) {
        this.mDisallowedPackages.remove(pkg);
    }

    public void addPackage(VersionedPackage pkg) {
        this.mDisallowedPackages.add(pkg);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

