/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.telephony.CellSignalStrength;
import android.telephony.ServiceState;
import com.android.telephony.Rlog;
import java.util.Objects;

public class CellSignalStrengthCdma
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthCdma";
    private static final boolean DBG = false;
    private int mCdmaDbm;
    private int mCdmaEcio;
    private int mEvdoDbm;
    private int mEvdoEcio;
    private int mEvdoSnr;
    private int mLevel;
    private static final CellSignalStrengthCdma sInvalid = new CellSignalStrengthCdma();
    public static final Parcelable.Creator<CellSignalStrengthCdma> CREATOR = new Parcelable.Creator<CellSignalStrengthCdma>(){

        @Override
        public CellSignalStrengthCdma createFromParcel(Parcel in) {
            return new CellSignalStrengthCdma(in);
        }

        public CellSignalStrengthCdma[] newArray(int size) {
            return new CellSignalStrengthCdma[size];
        }
    };

    public CellSignalStrengthCdma() {
        this.setDefaultValues();
    }

    public CellSignalStrengthCdma(int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr) {
        this.mCdmaDbm = CellSignalStrengthCdma.inRangeOrUnavailable(cdmaDbm, -120, 0);
        this.mCdmaEcio = CellSignalStrengthCdma.inRangeOrUnavailable(cdmaEcio, -160, 0);
        this.mEvdoDbm = CellSignalStrengthCdma.inRangeOrUnavailable(evdoDbm, -120, 0);
        this.mEvdoEcio = CellSignalStrengthCdma.inRangeOrUnavailable(evdoEcio, -160, 0);
        this.mEvdoSnr = CellSignalStrengthCdma.inRangeOrUnavailable(evdoSnr, 0, 8);
        this.updateLevel(null, null);
    }

    public CellSignalStrengthCdma(CellSignalStrengthCdma s) {
        this.copyFrom(s);
    }

    protected void copyFrom(CellSignalStrengthCdma s) {
        this.mCdmaDbm = s.mCdmaDbm;
        this.mCdmaEcio = s.mCdmaEcio;
        this.mEvdoDbm = s.mEvdoDbm;
        this.mEvdoEcio = s.mEvdoEcio;
        this.mEvdoSnr = s.mEvdoSnr;
        this.mLevel = s.mLevel;
    }

    @Override
    public CellSignalStrengthCdma copy() {
        return new CellSignalStrengthCdma(this);
    }

    @Override
    public void setDefaultValues() {
        this.mCdmaDbm = Integer.MAX_VALUE;
        this.mCdmaEcio = Integer.MAX_VALUE;
        this.mEvdoDbm = Integer.MAX_VALUE;
        this.mEvdoEcio = Integer.MAX_VALUE;
        this.mEvdoSnr = Integer.MAX_VALUE;
        this.mLevel = 0;
    }

    @Override
    public int getLevel() {
        return this.mLevel;
    }

    @Override
    public void updateLevel(PersistableBundle cc, ServiceState ss) {
        int cdmaLevel = this.getCdmaLevel();
        int evdoLevel = this.getEvdoLevel();
        this.mLevel = evdoLevel == 0 ? this.getCdmaLevel() : (cdmaLevel == 0 ? this.getEvdoLevel() : (cdmaLevel < evdoLevel ? cdmaLevel : evdoLevel));
    }

    @Override
    public int getAsuLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int cdmaAsuLevel = cdmaDbm == Integer.MAX_VALUE ? 99 : (cdmaDbm >= -75 ? 16 : (cdmaDbm >= -82 ? 8 : (cdmaDbm >= -90 ? 4 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 99)))));
        int ecioAsuLevel = cdmaEcio == Integer.MAX_VALUE ? 99 : (cdmaEcio >= -90 ? 16 : (cdmaEcio >= -100 ? 8 : (cdmaEcio >= -115 ? 4 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 99)))));
        int level = cdmaAsuLevel < ecioAsuLevel ? cdmaAsuLevel : ecioAsuLevel;
        return level;
    }

    public int getCdmaLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int levelDbm = cdmaDbm == Integer.MAX_VALUE ? 0 : (cdmaDbm >= -75 ? 4 : (cdmaDbm >= -85 ? 3 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 0))));
        int levelEcio = cdmaEcio == Integer.MAX_VALUE ? 0 : (cdmaEcio >= -90 ? 4 : (cdmaEcio >= -110 ? 3 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 0))));
        int level = levelDbm < levelEcio ? levelDbm : levelEcio;
        return level;
    }

    public int getEvdoLevel() {
        int evdoDbm = this.getEvdoDbm();
        int evdoSnr = this.getEvdoSnr();
        int levelEvdoDbm = evdoDbm == Integer.MAX_VALUE ? 0 : (evdoDbm >= -65 ? 4 : (evdoDbm >= -75 ? 3 : (evdoDbm >= -90 ? 2 : (evdoDbm >= -105 ? 1 : 0))));
        int levelEvdoSnr = evdoSnr == Integer.MAX_VALUE ? 0 : (evdoSnr >= 7 ? 4 : (evdoSnr >= 5 ? 3 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 0))));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    public int getEvdoAsuLevel() {
        int evdoDbm = this.getEvdoDbm();
        int evdoSnr = this.getEvdoSnr();
        int levelEvdoDbm = evdoDbm >= -65 ? 16 : (evdoDbm >= -75 ? 8 : (evdoDbm >= -85 ? 4 : (evdoDbm >= -95 ? 2 : (evdoDbm >= -105 ? 1 : 99))));
        int levelEvdoSnr = evdoSnr >= 7 ? 16 : (evdoSnr >= 6 ? 8 : (evdoSnr >= 5 ? 4 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 99))));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    @Override
    public int getDbm() {
        int evdoDbm;
        int cdmaDbm = this.getCdmaDbm();
        return cdmaDbm < (evdoDbm = this.getEvdoDbm()) ? cdmaDbm : evdoDbm;
    }

    public int getCdmaDbm() {
        return this.mCdmaDbm;
    }

    public void setCdmaDbm(int cdmaDbm) {
        this.mCdmaDbm = cdmaDbm;
    }

    public int getCdmaEcio() {
        return this.mCdmaEcio;
    }

    public void setCdmaEcio(int cdmaEcio) {
        this.mCdmaEcio = cdmaEcio;
    }

    public int getEvdoDbm() {
        return this.mEvdoDbm;
    }

    public void setEvdoDbm(int evdoDbm) {
        this.mEvdoDbm = evdoDbm;
    }

    public int getEvdoEcio() {
        return this.mEvdoEcio;
    }

    public void setEvdoEcio(int evdoEcio) {
        this.mEvdoEcio = evdoEcio;
    }

    public int getEvdoSnr() {
        return this.mEvdoSnr;
    }

    public void setEvdoSnr(int evdoSnr) {
        this.mEvdoSnr = evdoSnr;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mCdmaDbm, this.mCdmaEcio, this.mEvdoDbm, this.mEvdoEcio, this.mEvdoSnr, this.mLevel);
    }

    @Override
    public boolean isValid() {
        return !this.equals(sInvalid);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CellSignalStrengthCdma)) {
            return false;
        }
        CellSignalStrengthCdma s = (CellSignalStrengthCdma)o;
        return this.mCdmaDbm == s.mCdmaDbm && this.mCdmaEcio == s.mCdmaEcio && this.mEvdoDbm == s.mEvdoDbm && this.mEvdoEcio == s.mEvdoEcio && this.mEvdoSnr == s.mEvdoSnr && this.mLevel == s.mLevel;
    }

    public String toString() {
        return "CellSignalStrengthCdma: cdmaDbm=" + this.mCdmaDbm + " cdmaEcio=" + this.mCdmaEcio + " evdoDbm=" + this.mEvdoDbm + " evdoEcio=" + this.mEvdoEcio + " evdoSnr=" + this.mEvdoSnr + " level=" + this.mLevel;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mCdmaDbm);
        dest.writeInt(this.mCdmaEcio);
        dest.writeInt(this.mEvdoDbm);
        dest.writeInt(this.mEvdoEcio);
        dest.writeInt(this.mEvdoSnr);
        dest.writeInt(this.mLevel);
    }

    private CellSignalStrengthCdma(Parcel in) {
        this.mCdmaDbm = in.readInt();
        this.mCdmaEcio = in.readInt();
        this.mEvdoDbm = in.readInt();
        this.mEvdoEcio = in.readInt();
        this.mEvdoSnr = in.readInt();
        this.mLevel = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }
}

