/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.SipMessage;

public interface ISipDelegate
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.ISipDelegate";

    public void sendMessage(SipMessage var1, long var2) throws RemoteException;

    public void notifyMessageReceived(String var1) throws RemoteException;

    public void notifyMessageReceiveError(String var1, int var2) throws RemoteException;

    public void cleanupSession(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISipDelegate {
        static final int TRANSACTION_sendMessage = 1;
        static final int TRANSACTION_notifyMessageReceived = 2;
        static final int TRANSACTION_notifyMessageReceiveError = 3;
        static final int TRANSACTION_cleanupSession = 4;

        public Stub() {
            this.attachInterface(this, ISipDelegate.DESCRIPTOR);
        }

        public static ISipDelegate asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISipDelegate.DESCRIPTOR);
            if (iin != null && iin instanceof ISipDelegate) {
                return (ISipDelegate)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendMessage";
                }
                case 2: {
                    return "notifyMessageReceived";
                }
                case 3: {
                    return "notifyMessageReceiveError";
                }
                case 4: {
                    return "cleanupSession";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISipDelegate.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    SipMessage _arg0 = data.readTypedObject(SipMessage.CREATOR);
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.sendMessage(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.notifyMessageReceived(_arg0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyMessageReceiveError(_arg0, _arg1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.cleanupSession(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements ISipDelegate {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISipDelegate.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMessage(SipMessage sipMessage, long configVersion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISipDelegate.DESCRIPTOR);
                    _data.writeTypedObject(sipMessage, 0);
                    _data.writeLong(configVersion);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyMessageReceived(String viaTransactionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISipDelegate.DESCRIPTOR);
                    _data.writeString(viaTransactionId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyMessageReceiveError(String viaTransactionId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISipDelegate.DESCRIPTOR);
                    _data.writeString(viaTransactionId);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cleanupSession(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISipDelegate.DESCRIPTOR);
                    _data.writeString(callId);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISipDelegate {
        @Override
        public void sendMessage(SipMessage sipMessage, long configVersion) throws RemoteException {
        }

        @Override
        public void notifyMessageReceived(String viaTransactionId) throws RemoteException {
        }

        @Override
        public void notifyMessageReceiveError(String viaTransactionId, int reason) throws RemoteException {
        }

        @Override
        public void cleanupSession(String callId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

