/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SystemApi;
import android.net.Uri;
import android.os.RemoteException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsRegistrationAttributes;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsRegistrationCallback;
import android.util.Log;
import com.android.internal.telephony.util.RemoteCallbackListExt;
import com.android.internal.telephony.util.TelephonyUtils;
import com.android.internal.util.ArrayUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class ImsRegistrationImplBase {
    private static final String LOG_TAG = "ImsRegistrationImplBase";
    public static final int REGISTRATION_TECH_NONE = -1;
    public static final int REGISTRATION_TECH_LTE = 0;
    public static final int REGISTRATION_TECH_IWLAN = 1;
    public static final int REGISTRATION_TECH_CROSS_SIM = 2;
    public static final int REGISTRATION_TECH_NR = 3;
    public static final int REGISTRATION_TECH_MAX = 4;
    private static final int REGISTRATION_STATE_UNKNOWN = -1;
    private Executor mExecutor;
    private final IImsRegistration mBinder = new IImsRegistration.Stub(){

        @Override
        public int getRegistrationTechnology() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsRegistrationImplBase.this.mRegistrationAttributes == null ? -1 : ImsRegistrationImplBase.this.mRegistrationAttributes.getRegistrationTechnology(), "getRegistrationTechnology");
        }

        @Override
        public void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    ImsRegistrationImplBase.this.addRegistrationCallback(c);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "addRegistrationCallback");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void removeRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
            this.executeMethodAsync(() -> ImsRegistrationImplBase.this.removeRegistrationCallback(c), "removeRegistrationCallback");
        }

        @Override
        public void triggerFullNetworkRegistration(int sipCode, String sipReason) {
            this.executeMethodAsyncNoException(() -> ImsRegistrationImplBase.this.triggerFullNetworkRegistration(sipCode, sipReason), "triggerFullNetworkRegistration");
        }

        @Override
        public void triggerUpdateSipDelegateRegistration() {
            this.executeMethodAsyncNoException(() -> ImsRegistrationImplBase.this.updateSipDelegateRegistration(), "triggerUpdateSipDelegateRegistration");
        }

        @Override
        public void triggerSipDelegateDeregistration() {
            this.executeMethodAsyncNoException(() -> ImsRegistrationImplBase.this.triggerSipDelegateDeregistration(), "triggerSipDelegateDeregistration");
        }

        private void executeMethodAsync(Runnable r, String errorLogName) throws RemoteException {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsRegistrationImplBase.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsRegistrationImplBase.LOG_TAG, "ImsRegistrationImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        private void executeMethodAsyncNoException(Runnable r, String errorLogName) {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsRegistrationImplBase.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsRegistrationImplBase.LOG_TAG, "ImsRegistrationImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResult(Supplier<T> r, String errorLogName) throws RemoteException {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsRegistrationImplBase.this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(ImsRegistrationImplBase.LOG_TAG, "ImsRegistrationImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }
    };
    private final RemoteCallbackListExt<IImsRegistrationCallback> mCallbacks = new RemoteCallbackListExt();
    private final Object mLock = new Object();
    private ImsRegistrationAttributes mRegistrationAttributes;
    private int mRegistrationState = -1;
    private ImsReasonInfo mLastDisconnectCause = new ImsReasonInfo();
    private Uri[] mUris = new Uri[0];
    private boolean mUrisSet = false;

    @SystemApi
    public ImsRegistrationImplBase() {
    }

    @SystemApi
    public ImsRegistrationImplBase(Executor executor) {
        this.mExecutor = executor;
    }

    public IImsRegistration getBinder() {
        return this.mBinder;
    }

    private void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        this.mCallbacks.register(c);
        this.updateNewCallbackWithState(c);
    }

    private void removeRegistrationCallback(IImsRegistrationCallback c) {
        this.mCallbacks.unregister(c);
    }

    @SystemApi
    public void updateSipDelegateRegistration() {
    }

    @SystemApi
    public void triggerSipDelegateDeregistration() {
    }

    @SystemApi
    public void triggerFullNetworkRegistration(int sipCode, String sipReason) {
    }

    @SystemApi
    public void onRegistered(int imsRadioTech) {
        this.onRegistered(new ImsRegistrationAttributes.Builder(imsRadioTech).build());
    }

    @SystemApi
    public void onRegistered(ImsRegistrationAttributes attributes) {
        this.updateToState(attributes, 2);
        this.mCallbacks.broadcastAction(c -> {
            try {
                c.onRegistered(attributes);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + "onRegistered(int, Set) - Skipping callback.");
            }
        });
    }

    @SystemApi
    public void onRegistering(int imsRadioTech) {
        this.onRegistering(new ImsRegistrationAttributes.Builder(imsRadioTech).build());
    }

    @SystemApi
    public void onRegistering(ImsRegistrationAttributes attributes) {
        this.updateToState(attributes, 1);
        this.mCallbacks.broadcastAction(c -> {
            try {
                c.onRegistering(attributes);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + "onRegistering(int, Set) - Skipping callback.");
            }
        });
    }

    @SystemApi
    public void onDeregistered(ImsReasonInfo info) {
        this.updateToDisconnectedState(info);
        ImsReasonInfo reasonInfo = info != null ? info : new ImsReasonInfo();
        this.mCallbacks.broadcastAction(c -> {
            try {
                c.onDeregistered(reasonInfo);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + "onDeregistered() - Skipping callback.");
            }
        });
    }

    @SystemApi
    public void onTechnologyChangeFailed(int imsRadioTech, ImsReasonInfo info) {
        ImsReasonInfo reasonInfo = info != null ? info : new ImsReasonInfo();
        this.mCallbacks.broadcastAction(c -> {
            try {
                c.onTechnologyChangeFailed(imsRadioTech, reasonInfo);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + "onTechnologyChangeFailed() - Skipping callback.");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void onSubscriberAssociatedUriChanged(Uri[] uris) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUris = ArrayUtils.cloneOrNull(uris);
            this.mUrisSet = true;
        }
        this.mCallbacks.broadcastAction(c -> this.onSubscriberAssociatedUriChanged((IImsRegistrationCallback)c, uris));
    }

    private void onSubscriberAssociatedUriChanged(IImsRegistrationCallback callback, Uri[] uris) {
        try {
            callback.onSubscriberAssociatedUriChanged(uris);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, e + "onSubscriberAssociatedUriChanged() - Skipping callback.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToState(ImsRegistrationAttributes attributes, int newState) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRegistrationAttributes = attributes;
            this.mRegistrationState = newState;
            this.mLastDisconnectCause = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToDisconnectedState(ImsReasonInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUrisSet = false;
            this.mUris = null;
            this.updateToState(new ImsRegistrationAttributes.Builder(-1).build(), 0);
            if (info != null) {
                this.mLastDisconnectCause = info;
            } else {
                Log.w(LOG_TAG, "updateToDisconnectedState: no ImsReasonInfo provided.");
                this.mLastDisconnectCause = new ImsReasonInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNewCallbackWithState(IImsRegistrationCallback c) throws RemoteException {
        Uri[] uris;
        boolean urisSet;
        ImsReasonInfo disconnectInfo;
        ImsRegistrationAttributes attributes;
        int state;
        Object object = this.mLock;
        synchronized (object) {
            state = this.mRegistrationState;
            attributes = this.mRegistrationAttributes;
            disconnectInfo = this.mLastDisconnectCause;
            urisSet = this.mUrisSet;
            uris = this.mUris;
        }
        switch (state) {
            case 0: {
                c.onDeregistered(disconnectInfo);
                break;
            }
            case 1: {
                c.onRegistering(attributes);
                break;
            }
            case 2: {
                c.onRegistered(attributes);
                break;
            }
        }
        if (urisSet) {
            this.onSubscriberAssociatedUriChanged(c, uris);
        }
    }

    public void setDefaultExecutor(Executor executor) {
        if (this.mExecutor == null) {
            this.mExecutor = executor;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsRegistrationTech {
    }
}

