/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Paint;
import android.graphics.text.LineBreakConfig;
import android.graphics.text.LineBreaker;
import android.text.Layout;
import android.text.MeasuredParagraph;
import android.text.PrecomputedText;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.TabStopSpan;
import android.util.Log;
import android.util.Pools;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.util.Arrays;

public class StaticLayout
extends Layout {
    static final String TAG = "StaticLayout";
    @UnsupportedAppUsage
    private int mLineCount;
    private int mTopPadding;
    private int mBottomPadding;
    @UnsupportedAppUsage
    private int mColumns;
    private int mEllipsizedWidth;
    private boolean mFallbackLineSpacing;
    private boolean mEllipsized;
    private int mMaxLineHeight = -1;
    private static final int COLUMNS_NORMAL = 5;
    private static final int COLUMNS_ELLIPSIZE = 7;
    private static final int START = 0;
    private static final int DIR = 0;
    private static final int TAB = 0;
    private static final int TOP = 1;
    private static final int DESCENT = 2;
    private static final int EXTRA = 3;
    private static final int HYPHEN = 4;
    @UnsupportedAppUsage
    private static final int ELLIPSIS_START = 5;
    private static final int ELLIPSIS_COUNT = 6;
    @UnsupportedAppUsage
    private int[] mLines;
    @UnsupportedAppUsage
    private Layout.Directions[] mLineDirections;
    @UnsupportedAppUsage
    private int mMaximumVisibleLineCount = Integer.MAX_VALUE;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int DIR_SHIFT = 30;
    private static final int TAB_MASK = 0x20000000;
    private static final int HYPHEN_MASK = 255;
    private static final int START_HYPHEN_BITS_SHIFT = 3;
    private static final int START_HYPHEN_MASK = 24;
    private static final int END_HYPHEN_MASK = 7;
    private static final float TAB_INCREMENT = 20.0f;
    private static final char CHAR_NEW_LINE = '\n';
    private static final double EXTRA_ROUNDING = 0.5;
    private static final int DEFAULT_MAX_LINE_HEIGHT = -1;
    private int[] mLeftIndents;
    private int[] mRightIndents;

    @Deprecated
    public StaticLayout(CharSequence source, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, 0, source.length(), paint, width, align, spacingmult, spacingadd, includepad);
    }

    @Deprecated
    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, bufstart, bufend, paint, outerwidth, align, spacingmult, spacingadd, includepad, null, 0);
    }

    @Deprecated
    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        this(source, bufstart, bufend, paint, outerwidth, align, TextDirectionHeuristics.FIRSTSTRONG_LTR, spacingmult, spacingadd, includepad, ellipsize, ellipsizedWidth, Integer.MAX_VALUE);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=117521430L)
    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth, int maxLines) {
        super(ellipsize == null ? source : (source instanceof Spanned ? new Layout.SpannedEllipsizer(source) : new Layout.Ellipsizer(source)), paint, outerwidth, align, textDir, spacingmult, spacingadd);
        Builder b = Builder.obtain(source, bufstart, bufend, paint, outerwidth).setAlignment(align).setTextDirection(textDir).setLineSpacing(spacingadd, spacingmult).setIncludePad(includepad).setEllipsizedWidth(ellipsizedWidth).setEllipsize(ellipsize).setMaxLines(maxLines);
        if (ellipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = ellipsizedWidth;
            e.mMethod = ellipsize;
            this.mEllipsizedWidth = ellipsizedWidth;
            this.mColumns = 7;
        } else {
            this.mColumns = 5;
            this.mEllipsizedWidth = outerwidth;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2);
        this.mLines = ArrayUtils.newUnpaddedIntArray(2 * this.mColumns);
        this.mMaximumVisibleLineCount = maxLines;
        this.generate(b, b.mIncludePad, b.mIncludePad);
        Builder.recycle(b);
    }

    StaticLayout(CharSequence text) {
        super(text, null, 0, null, 0.0f, 0.0f);
        this.mColumns = 7;
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2);
        this.mLines = ArrayUtils.newUnpaddedIntArray(2 * this.mColumns);
    }

    private StaticLayout(Builder b) {
        super(b.mEllipsize == null ? b.mText : (b.mText instanceof Spanned ? new Layout.SpannedEllipsizer(b.mText) : new Layout.Ellipsizer(b.mText)), b.mPaint, b.mWidth, b.mAlignment, b.mTextDir, b.mSpacingMult, b.mSpacingAdd);
        if (b.mEllipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = b.mEllipsizedWidth;
            e.mMethod = b.mEllipsize;
            this.mEllipsizedWidth = b.mEllipsizedWidth;
            this.mColumns = 7;
        } else {
            this.mColumns = 5;
            this.mEllipsizedWidth = b.mWidth;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2);
        this.mLines = ArrayUtils.newUnpaddedIntArray(2 * this.mColumns);
        this.mMaximumVisibleLineCount = b.mMaxLines;
        this.mLeftIndents = b.mLeftIndents;
        this.mRightIndents = b.mRightIndents;
        this.setJustificationMode(b.mJustificationMode);
        this.generate(b, b.mIncludePad, b.mIncludePad);
    }

    private static int getBaseHyphenationFrequency(int frequency) {
        switch (frequency) {
            case 2: 
            case 4: {
                return 2;
            }
            case 1: 
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    void generate(Builder b, boolean includepad, boolean trackpad) {
        Spanned spanned;
        int[] indents;
        CharSequence source = b.mText;
        int bufStart = b.mStart;
        int bufEnd = b.mEnd;
        TextPaint paint = b.mPaint;
        int outerWidth = b.mWidth;
        TextDirectionHeuristic textDir = b.mTextDir;
        float spacingmult = b.mSpacingMult;
        float spacingadd = b.mSpacingAdd;
        float ellipsizedWidth = b.mEllipsizedWidth;
        TextUtils.TruncateAt ellipsize = b.mEllipsize;
        boolean addLastLineSpacing = b.mAddLastLineLineSpacing;
        int lineBreakCapacity = 0;
        int[] breaks = null;
        float[] lineWidths = null;
        float[] ascents = null;
        float[] descents = null;
        boolean[] hasTabs = null;
        int[] hyphenEdits = null;
        this.mLineCount = 0;
        this.mEllipsized = false;
        this.mMaxLineHeight = this.mMaximumVisibleLineCount < 1 ? 0 : -1;
        this.mFallbackLineSpacing = b.mFallbackLineSpacing;
        int v = 0;
        boolean needMultiply = spacingmult != 1.0f || spacingadd != 0.0f;
        Paint.FontMetricsInt fm = b.mFontMetricsInt;
        int[] chooseHtv = null;
        if (this.mLeftIndents != null || this.mRightIndents != null) {
            int i;
            int leftLen = this.mLeftIndents == null ? 0 : this.mLeftIndents.length;
            int rightLen = this.mRightIndents == null ? 0 : this.mRightIndents.length;
            int indentsLen = Math.max(leftLen, rightLen);
            indents = new int[indentsLen];
            for (i = 0; i < leftLen; ++i) {
                indents[i] = this.mLeftIndents[i];
            }
            for (i = 0; i < rightLen; ++i) {
                int n = i;
                indents[n] = indents[n] + this.mRightIndents[i];
            }
        } else {
            indents = null;
        }
        LineBreaker lineBreaker = new LineBreaker.Builder().setBreakStrategy(b.mBreakStrategy).setHyphenationFrequency(StaticLayout.getBaseHyphenationFrequency(b.mHyphenationFrequency)).setJustificationMode(b.mJustificationMode).setIndents(indents).build();
        LineBreaker.ParagraphConstraints constraints = new LineBreaker.ParagraphConstraints();
        PrecomputedText.ParagraphInfo[] paragraphInfo = null;
        Spanned spanned2 = spanned = source instanceof Spanned ? (Spanned)source : null;
        if (source instanceof PrecomputedText) {
            PrecomputedText precomputed = (PrecomputedText)source;
            int checkResult = precomputed.checkResultUsable(bufStart, bufEnd, textDir, paint, b.mBreakStrategy, b.mHyphenationFrequency, b.mLineBreakConfig);
            switch (checkResult) {
                case 0: {
                    break;
                }
                case 1: {
                    PrecomputedText.Params newParams = new PrecomputedText.Params.Builder(paint).setBreakStrategy(b.mBreakStrategy).setHyphenationFrequency(b.mHyphenationFrequency).setTextDirection(textDir).setLineBreakConfig(b.mLineBreakConfig).build();
                    precomputed = PrecomputedText.create(precomputed, newParams);
                    paragraphInfo = precomputed.getParagraphInfo();
                    break;
                }
                case 2: {
                    paragraphInfo = precomputed.getParagraphInfo();
                }
            }
        }
        if (paragraphInfo == null) {
            PrecomputedText.Params param = new PrecomputedText.Params(paint, b.mLineBreakConfig, textDir, b.mBreakStrategy, b.mHyphenationFrequency);
            paragraphInfo = PrecomputedText.createMeasuredParagraphs(source, param, bufStart, bufEnd, false);
        }
        for (int paraIndex = 0; paraIndex < paragraphInfo.length; ++paraIndex) {
            boolean ellipsisMayBeApplied;
            TabStopSpan[] spans;
            int paraStart = paraIndex == 0 ? bufStart : paragraphInfo[paraIndex - 1].paragraphEnd;
            int paraEnd = paragraphInfo[paraIndex].paragraphEnd;
            int firstWidthLineCount = 1;
            int firstWidth = outerWidth;
            int restWidth = outerWidth;
            LineHeightSpan[] chooseHt = null;
            if (spanned != null) {
                int i;
                LeadingMarginSpan[] sp = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LeadingMarginSpan.class);
                for (i = 0; i < sp.length; ++i) {
                    LeadingMarginSpan lms = sp[i];
                    firstWidth -= sp[i].getLeadingMargin(true);
                    restWidth -= sp[i].getLeadingMargin(false);
                    if (!(lms instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    LeadingMarginSpan.LeadingMarginSpan2 lms2 = (LeadingMarginSpan.LeadingMarginSpan2)lms;
                    firstWidthLineCount = Math.max(firstWidthLineCount, lms2.getLeadingMarginLineCount());
                }
                chooseHt = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LineHeightSpan.class);
                if (chooseHt.length == 0) {
                    chooseHt = null;
                } else {
                    if (chooseHtv == null || chooseHtv.length < chooseHt.length) {
                        chooseHtv = ArrayUtils.newUnpaddedIntArray(chooseHt.length);
                    }
                    for (i = 0; i < chooseHt.length; ++i) {
                        int o = spanned.getSpanStart(chooseHt[i]);
                        chooseHtv[i] = o < paraStart ? this.getLineTop(this.getLineForOffset(o)) : v;
                    }
                }
            }
            float[] variableTabStops = null;
            if (spanned != null && (spans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, TabStopSpan.class)).length > 0) {
                float[] stops = new float[spans.length];
                for (int i = 0; i < spans.length; ++i) {
                    stops[i] = spans[i].getTabStop();
                }
                Arrays.sort(stops, 0, stops.length);
                variableTabStops = stops;
            }
            MeasuredParagraph measuredPara = paragraphInfo[paraIndex].measured;
            char[] chs = measuredPara.getChars();
            int[] spanEndCache = measuredPara.getSpanEndCache().getRawArray();
            int[] fmCache = measuredPara.getFontMetrics().getRawArray();
            constraints.setWidth(restWidth);
            constraints.setIndent(firstWidth, firstWidthLineCount);
            constraints.setTabStops(variableTabStops, 20.0f);
            LineBreaker.Result res = lineBreaker.computeLineBreaks(measuredPara.getMeasuredText(), constraints, this.mLineCount);
            int breakCount = res.getLineCount();
            if (lineBreakCapacity < breakCount) {
                lineBreakCapacity = breakCount;
                breaks = new int[lineBreakCapacity];
                lineWidths = new float[lineBreakCapacity];
                ascents = new float[lineBreakCapacity];
                descents = new float[lineBreakCapacity];
                hasTabs = new boolean[lineBreakCapacity];
                hyphenEdits = new int[lineBreakCapacity];
            }
            for (int i = 0; i < breakCount; ++i) {
                breaks[i] = res.getLineBreakOffset(i);
                lineWidths[i] = res.getLineWidth(i);
                ascents[i] = res.getLineAscent(i);
                descents[i] = res.getLineDescent(i);
                hasTabs[i] = res.hasLineTab(i);
                hyphenEdits[i] = StaticLayout.packHyphenEdit(res.getStartLineHyphenEdit(i), res.getEndLineHyphenEdit(i));
            }
            int remainingLineCount = this.mMaximumVisibleLineCount - this.mLineCount;
            boolean bl = ellipsisMayBeApplied = ellipsize != null && (ellipsize == TextUtils.TruncateAt.END || this.mMaximumVisibleLineCount == 1 && ellipsize != TextUtils.TruncateAt.MARQUEE);
            if (0 < remainingLineCount && remainingLineCount < breakCount && ellipsisMayBeApplied) {
                float width = 0.0f;
                boolean hasTab = false;
                for (int i = remainingLineCount - 1; i < breakCount; ++i) {
                    if (i == breakCount - 1) {
                        width += lineWidths[i];
                    } else {
                        int j;
                        int n = j = i == 0 ? 0 : breaks[i - 1];
                        while (j < breaks[i]) {
                            width += measuredPara.getCharWidthAt(j);
                            ++j;
                        }
                    }
                    hasTab |= hasTabs[i];
                }
                breaks[remainingLineCount - 1] = breaks[breakCount - 1];
                lineWidths[remainingLineCount - 1] = width;
                hasTabs[remainingLineCount - 1] = hasTab;
                breakCount = remainingLineCount;
            }
            int here = paraStart;
            int fmTop = 0;
            int fmBottom = 0;
            int fmAscent = 0;
            int fmDescent = 0;
            int fmCacheIndex = 0;
            int spanEndCacheIndex = 0;
            int breakIndex = 0;
            int spanStart = paraStart;
            while (spanStart < paraEnd) {
                int spanEnd = spanEndCache[spanEndCacheIndex++];
                fm.top = fmCache[fmCacheIndex * 4 + 0];
                fm.bottom = fmCache[fmCacheIndex * 4 + 1];
                fm.ascent = fmCache[fmCacheIndex * 4 + 2];
                fm.descent = fmCache[fmCacheIndex * 4 + 3];
                ++fmCacheIndex;
                if (fm.top < fmTop) {
                    fmTop = fm.top;
                }
                if (fm.ascent < fmAscent) {
                    fmAscent = fm.ascent;
                }
                if (fm.descent > fmDescent) {
                    fmDescent = fm.descent;
                }
                if (fm.bottom > fmBottom) {
                    fmBottom = fm.bottom;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] < spanStart) {
                    ++breakIndex;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] <= spanEnd) {
                    int descent;
                    int endPos = paraStart + breaks[breakIndex];
                    boolean moreChars = endPos < bufEnd;
                    int ascent = this.mFallbackLineSpacing ? Math.min(fmAscent, Math.round(ascents[breakIndex])) : fmAscent;
                    int n = descent = this.mFallbackLineSpacing ? Math.max(fmDescent, Math.round(descents[breakIndex])) : fmDescent;
                    if (this.mFallbackLineSpacing) {
                        if (ascent < fmTop) {
                            fmTop = ascent;
                        }
                        if (descent > fmBottom) {
                            fmBottom = descent;
                        }
                    }
                    v = this.out(source, here, endPos, ascent, descent, fmTop, fmBottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, hasTabs[breakIndex], hyphenEdits[breakIndex], needMultiply, measuredPara, bufEnd, includepad, trackpad, addLastLineSpacing, chs, paraStart, ellipsize, ellipsizedWidth, lineWidths[breakIndex], paint, moreChars);
                    if (endPos < spanEnd) {
                        fmTop = fm.top;
                        fmBottom = fm.bottom;
                        fmAscent = fm.ascent;
                        fmDescent = fm.descent;
                    } else {
                        fmDescent = 0;
                        fmAscent = 0;
                        fmBottom = 0;
                        fmTop = 0;
                    }
                    here = endPos;
                    ++breakIndex;
                    if (this.mLineCount < this.mMaximumVisibleLineCount || !this.mEllipsized) continue;
                    return;
                }
                spanStart = spanEnd;
            }
            if (paraEnd == bufEnd) break;
        }
        if ((bufEnd == bufStart || source.charAt(bufEnd - 1) == '\n') && this.mLineCount < this.mMaximumVisibleLineCount) {
            MeasuredParagraph measuredPara = MeasuredParagraph.buildForBidi(source, bufEnd, bufEnd, textDir, null);
            paint.getFontMetricsInt(fm);
            v = this.out(source, bufEnd, bufEnd, fm.ascent, fm.descent, fm.top, fm.bottom, v, spacingmult, spacingadd, null, null, fm, false, 0, needMultiply, measuredPara, bufEnd, includepad, trackpad, addLastLineSpacing, null, bufStart, ellipsize, ellipsizedWidth, 0.0f, paint, false);
        }
    }

    private int out(CharSequence text, int start, int end, int above, int below, int top, int bottom, int v, float spacingmult, float spacingadd, LineHeightSpan[] chooseHt, int[] chooseHtv, Paint.FontMetricsInt fm, boolean hasTab, int hyphenEdit, boolean needMultiply, MeasuredParagraph measured, int bufEnd, boolean includePad, boolean trackPad, boolean addLastLineLineSpacing, char[] chs, int widthStart, TextUtils.TruncateAt ellipsize, float ellipsisWidth, float textWidth, TextPaint paint, boolean moreChars) {
        double ex;
        boolean lastLine;
        boolean currentLineIsTheLastVisibleOne;
        Object[] grow;
        int j = this.mLineCount;
        int off = j * this.mColumns;
        int want = off + this.mColumns + 1;
        int[] lines = this.mLines;
        int dir = measured.getParagraphDir();
        if (want >= lines.length) {
            grow = ArrayUtils.newUnpaddedIntArray(GrowingArrayUtils.growSize(want));
            System.arraycopy(lines, 0, grow, 0, lines.length);
            this.mLines = grow;
            lines = grow;
        }
        if (j >= this.mLineDirections.length) {
            grow = ArrayUtils.newUnpaddedArray(Layout.Directions.class, GrowingArrayUtils.growSize(j));
            System.arraycopy(this.mLineDirections, 0, grow, 0, this.mLineDirections.length);
            this.mLineDirections = (Layout.Directions[])grow;
        }
        if (chooseHt != null) {
            fm.ascent = above;
            fm.descent = below;
            fm.top = top;
            fm.bottom = bottom;
            for (int i = 0; i < chooseHt.length; ++i) {
                if (chooseHt[i] instanceof LineHeightSpan.WithDensity) {
                    ((LineHeightSpan.WithDensity)chooseHt[i]).chooseHeight(text, start, end, chooseHtv[i], v, fm, paint);
                    continue;
                }
                chooseHt[i].chooseHeight(text, start, end, chooseHtv[i], v, fm);
            }
            above = fm.ascent;
            below = fm.descent;
            top = fm.top;
            bottom = fm.bottom;
        }
        boolean firstLine = j == 0;
        boolean bl = currentLineIsTheLastVisibleOne = j + 1 == this.mMaximumVisibleLineCount;
        if (ellipsize != null) {
            boolean doEllipsis;
            boolean forceEllipsis = moreChars && this.mLineCount + 1 == this.mMaximumVisibleLineCount;
            boolean bl2 = doEllipsis = (this.mMaximumVisibleLineCount == 1 && moreChars || firstLine && !moreChars) && ellipsize != TextUtils.TruncateAt.MARQUEE || !firstLine && (currentLineIsTheLastVisibleOne || !moreChars) && ellipsize == TextUtils.TruncateAt.END;
            if (doEllipsis) {
                this.calculateEllipsis(start, end, measured, widthStart, ellipsisWidth, ellipsize, j, textWidth, paint, forceEllipsis);
            } else {
                this.mLines[this.mColumns * j + 5] = 0;
                this.mLines[this.mColumns * j + 6] = 0;
            }
        }
        if (this.mEllipsized) {
            lastLine = true;
        } else {
            boolean lastCharIsNewLine;
            boolean bl3 = lastCharIsNewLine = widthStart != bufEnd && bufEnd > 0 && text.charAt(bufEnd - 1) == '\n';
            lastLine = end == bufEnd && !lastCharIsNewLine ? true : start == bufEnd && lastCharIsNewLine;
        }
        if (firstLine) {
            if (trackPad) {
                this.mTopPadding = top - above;
            }
            if (includePad) {
                above = top;
            }
        }
        if (lastLine) {
            if (trackPad) {
                this.mBottomPadding = bottom - below;
            }
            if (includePad) {
                below = bottom;
            }
        }
        int extra = needMultiply && (addLastLineLineSpacing || !lastLine) ? ((ex = (double)((float)(below - above) * (spacingmult - 1.0f) + spacingadd)) >= 0.0 ? (int)(ex + 0.5) : -((int)(-ex + 0.5))) : 0;
        lines[off + 0] = start;
        lines[off + 1] = v;
        lines[off + 2] = below + extra;
        lines[off + 3] = extra;
        if (!this.mEllipsized && currentLineIsTheLastVisibleOne) {
            int maxLineBelow = includePad ? bottom : below;
            this.mMaxLineHeight = v + (maxLineBelow - above);
        }
        lines[off + this.mColumns + 0] = end;
        lines[off + this.mColumns + 1] = v += below - above + extra;
        int n = off + 0;
        lines[n] = lines[n] | (hasTab ? 0x20000000 : 0);
        lines[off + 4] = hyphenEdit;
        int n2 = off + 0;
        lines[n2] = lines[n2] | dir << 30;
        this.mLineDirections[j] = measured.getDirections(start - widthStart, end - widthStart);
        ++this.mLineCount;
        return v;
    }

    private void calculateEllipsis(int lineStart, int lineEnd, MeasuredParagraph measured, int widthStart, float avail, TextUtils.TruncateAt where, int line, float textWidth, TextPaint paint, boolean forceEllipsis) {
        if (textWidth <= (avail -= this.getTotalInsets(line)) && !forceEllipsis) {
            this.mLines[this.mColumns * line + 5] = 0;
            this.mLines[this.mColumns * line + 6] = 0;
            return;
        }
        float ellipsisWidth = paint.measureText(TextUtils.getEllipsisString(where));
        int ellipsisStart = 0;
        int ellipsisCount = 0;
        int len = lineEnd - lineStart;
        if (where == TextUtils.TruncateAt.START) {
            if (this.mMaximumVisibleLineCount == 1) {
                int i;
                float sum = 0.0f;
                for (i = len; i > 0; --i) {
                    float w = measured.getCharWidthAt(i - 1 + lineStart - widthStart);
                    if (w + sum + ellipsisWidth > avail) {
                        while (i < len && measured.getCharWidthAt(i + lineStart - widthStart) == 0.0f) {
                            ++i;
                        }
                        break;
                    }
                    sum += w;
                }
                ellipsisStart = 0;
                ellipsisCount = i;
            } else if (Log.isLoggable(TAG, 5)) {
                Log.w(TAG, "Start Ellipsis only supported with one line");
            }
        } else if (where == TextUtils.TruncateAt.END || where == TextUtils.TruncateAt.MARQUEE || where == TextUtils.TruncateAt.END_SMALL) {
            float w;
            int i;
            float sum = 0.0f;
            for (i = 0; i < len && !((w = measured.getCharWidthAt(i + lineStart - widthStart)) + sum + ellipsisWidth > avail); ++i) {
                sum += w;
            }
            ellipsisStart = i;
            ellipsisCount = len - i;
            if (forceEllipsis && ellipsisCount == 0 && len > 0) {
                ellipsisStart = len - 1;
                ellipsisCount = 1;
            }
        } else if (this.mMaximumVisibleLineCount == 1) {
            float w;
            float lsum = 0.0f;
            float rsum = 0.0f;
            int left = 0;
            int right = len;
            float ravail = (avail - ellipsisWidth) / 2.0f;
            for (right = len; right > 0; --right) {
                float w2 = measured.getCharWidthAt(right - 1 + lineStart - widthStart);
                if (w2 + rsum > ravail) {
                    while (right < len && measured.getCharWidthAt(right + lineStart - widthStart) == 0.0f) {
                        ++right;
                    }
                    break;
                }
                rsum += w2;
            }
            float lavail = avail - ellipsisWidth - rsum;
            for (left = 0; left < right && !((w = measured.getCharWidthAt(left + lineStart - widthStart)) + lsum > lavail); ++left) {
                lsum += w;
            }
            ellipsisStart = left;
            ellipsisCount = right - left;
        } else if (Log.isLoggable(TAG, 5)) {
            Log.w(TAG, "Middle Ellipsis only supported with one line");
        }
        this.mEllipsized = true;
        this.mLines[this.mColumns * line + 5] = ellipsisStart;
        this.mLines[this.mColumns * line + 6] = ellipsisCount;
    }

    private float getTotalInsets(int line) {
        int totalIndent = 0;
        if (this.mLeftIndents != null) {
            totalIndent = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (this.mRightIndents != null) {
            totalIndent += this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        return totalIndent;
    }

    @Override
    public int getLineForVertical(int vertical) {
        int high = this.mLineCount;
        int low = -1;
        int[] lines = this.mLines;
        while (high - low > 1) {
            int guess = high + low >> 1;
            if (lines[this.mColumns * guess + 1] > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    @Override
    public int getLineCount() {
        return this.mLineCount;
    }

    @Override
    public int getLineTop(int line) {
        return this.mLines[this.mColumns * line + 1];
    }

    @Override
    public int getLineExtra(int line) {
        return this.mLines[this.mColumns * line + 3];
    }

    @Override
    public int getLineDescent(int line) {
        return this.mLines[this.mColumns * line + 2];
    }

    @Override
    public int getLineStart(int line) {
        return this.mLines[this.mColumns * line + 0] & 0x1FFFFFFF;
    }

    @Override
    public int getParagraphDirection(int line) {
        return this.mLines[this.mColumns * line + 0] >> 30;
    }

    @Override
    public boolean getLineContainsTab(int line) {
        return (this.mLines[this.mColumns * line + 0] & 0x20000000) != 0;
    }

    @Override
    public Layout.Directions getLineDirections(int line) {
        if (line > this.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.mLineDirections[line];
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    static int packHyphenEdit(int start, int end) {
        return start << 3 | end;
    }

    static int unpackStartHyphenEdit(int packedHyphenEdit) {
        return (packedHyphenEdit & 0x18) >> 3;
    }

    static int unpackEndHyphenEdit(int packedHyphenEdit) {
        return packedHyphenEdit & 7;
    }

    @Override
    public int getStartHyphenEdit(int lineNumber) {
        return StaticLayout.unpackStartHyphenEdit(this.mLines[this.mColumns * lineNumber + 4] & 0xFF);
    }

    @Override
    public int getEndHyphenEdit(int lineNumber) {
        return StaticLayout.unpackEndHyphenEdit(this.mLines[this.mColumns * lineNumber + 4] & 0xFF);
    }

    @Override
    public int getIndentAdjust(int line, Layout.Alignment align) {
        if (align == Layout.Alignment.ALIGN_LEFT) {
            if (this.mLeftIndents == null) {
                return 0;
            }
            return this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_RIGHT) {
            if (this.mRightIndents == null) {
                return 0;
            }
            return -this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_CENTER) {
            int left = 0;
            if (this.mLeftIndents != null) {
                left = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
            }
            int right = 0;
            if (this.mRightIndents != null) {
                right = this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
            }
            return left - right >> 1;
        }
        throw new AssertionError((Object)("unhandled alignment " + (Object)((Object)align)));
    }

    @Override
    public int getEllipsisCount(int line) {
        if (this.mColumns < 7) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 6];
    }

    @Override
    public int getEllipsisStart(int line) {
        if (this.mColumns < 7) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 5];
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    @Override
    public boolean isFallbackLineSpacingEnabled() {
        return this.mFallbackLineSpacing;
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getHeight(boolean cap) {
        if (cap && this.mLineCount > this.mMaximumVisibleLineCount && this.mMaxLineHeight == -1 && Log.isLoggable(TAG, 5)) {
            Log.w(TAG, "maxLineHeight should not be -1.  maxLines:" + this.mMaximumVisibleLineCount + " lineCount:" + this.mLineCount);
        }
        return cap && this.mLineCount > this.mMaximumVisibleLineCount && this.mMaxLineHeight != -1 ? this.mMaxLineHeight : super.getHeight();
    }

    static class LineBreaks {
        private static final int INITIAL_SIZE = 16;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int[] breaks = new int[16];
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public float[] widths = new float[16];
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public float[] ascents = new float[16];
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public float[] descents = new float[16];
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int[] flags = new int[16];

        LineBreaks() {
        }
    }

    public static class Builder {
        private CharSequence mText;
        private int mStart;
        private int mEnd;
        private TextPaint mPaint;
        private int mWidth;
        private Layout.Alignment mAlignment;
        private TextDirectionHeuristic mTextDir;
        private float mSpacingMult;
        private float mSpacingAdd;
        private boolean mIncludePad;
        private boolean mFallbackLineSpacing;
        private int mEllipsizedWidth;
        private TextUtils.TruncateAt mEllipsize;
        private int mMaxLines;
        private int mBreakStrategy;
        private int mHyphenationFrequency;
        private int[] mLeftIndents;
        private int[] mRightIndents;
        private int mJustificationMode;
        private boolean mAddLastLineLineSpacing;
        private LineBreakConfig mLineBreakConfig = LineBreakConfig.NONE;
        private final Paint.FontMetricsInt mFontMetricsInt = new Paint.FontMetricsInt();
        private static final Pools.SynchronizedPool<Builder> sPool = new Pools.SynchronizedPool(3);

        private Builder() {
        }

        public static Builder obtain(CharSequence source, int start, int end, TextPaint paint, int width) {
            Builder b = sPool.acquire();
            if (b == null) {
                b = new Builder();
            }
            b.mText = source;
            b.mStart = start;
            b.mEnd = end;
            b.mPaint = paint;
            b.mWidth = width;
            b.mAlignment = Layout.Alignment.ALIGN_NORMAL;
            b.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            b.mSpacingMult = 1.0f;
            b.mSpacingAdd = 0.0f;
            b.mIncludePad = true;
            b.mFallbackLineSpacing = false;
            b.mEllipsizedWidth = width;
            b.mEllipsize = null;
            b.mMaxLines = Integer.MAX_VALUE;
            b.mBreakStrategy = 0;
            b.mHyphenationFrequency = 0;
            b.mJustificationMode = 0;
            b.mLineBreakConfig = LineBreakConfig.NONE;
            return b;
        }

        private static void recycle(Builder b) {
            b.mPaint = null;
            b.mText = null;
            b.mLeftIndents = null;
            b.mRightIndents = null;
            sPool.release(b);
        }

        void finish() {
            this.mText = null;
            this.mPaint = null;
            this.mLeftIndents = null;
            this.mRightIndents = null;
        }

        public Builder setText(CharSequence source) {
            return this.setText(source, 0, source.length());
        }

        public Builder setText(CharSequence source, int start, int end) {
            this.mText = source;
            this.mStart = start;
            this.mEnd = end;
            return this;
        }

        public Builder setPaint(TextPaint paint) {
            this.mPaint = paint;
            return this;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            if (this.mEllipsize == null) {
                this.mEllipsizedWidth = width;
            }
            return this;
        }

        public Builder setAlignment(Layout.Alignment alignment) {
            this.mAlignment = alignment;
            return this;
        }

        public Builder setTextDirection(TextDirectionHeuristic textDir) {
            this.mTextDir = textDir;
            return this;
        }

        public Builder setLineSpacing(float spacingAdd, float spacingMult) {
            this.mSpacingAdd = spacingAdd;
            this.mSpacingMult = spacingMult;
            return this;
        }

        public Builder setIncludePad(boolean includePad) {
            this.mIncludePad = includePad;
            return this;
        }

        public Builder setUseLineSpacingFromFallbacks(boolean useLineSpacingFromFallbacks) {
            this.mFallbackLineSpacing = useLineSpacingFromFallbacks;
            return this;
        }

        public Builder setEllipsizedWidth(int ellipsizedWidth) {
            this.mEllipsizedWidth = ellipsizedWidth;
            return this;
        }

        public Builder setEllipsize(TextUtils.TruncateAt ellipsize) {
            this.mEllipsize = ellipsize;
            return this;
        }

        public Builder setMaxLines(int maxLines) {
            this.mMaxLines = maxLines;
            return this;
        }

        public Builder setBreakStrategy(int breakStrategy) {
            this.mBreakStrategy = breakStrategy;
            return this;
        }

        public Builder setHyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequency = hyphenationFrequency;
            return this;
        }

        public Builder setIndents(int[] leftIndents, int[] rightIndents) {
            this.mLeftIndents = leftIndents;
            this.mRightIndents = rightIndents;
            return this;
        }

        public Builder setJustificationMode(int justificationMode) {
            this.mJustificationMode = justificationMode;
            return this;
        }

        Builder setAddLastLineLineSpacing(boolean value) {
            this.mAddLastLineLineSpacing = value;
            return this;
        }

        public Builder setLineBreakConfig(LineBreakConfig lineBreakConfig) {
            this.mLineBreakConfig = lineBreakConfig;
            return this;
        }

        public StaticLayout build() {
            StaticLayout result = new StaticLayout(this);
            Builder.recycle(this);
            return result;
        }
    }
}

